/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.proAI.logging;

import games.strategy.triplea.ai.proAI.logging.LogSettings;
import games.strategy.triplea.ui.TripleAFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LogWindow
extends JDialog {
    private static final long serialVersionUID = -5989598624017028122L;
    private JTextArea currentLogTextArea = null;
    private JLabel jLabel15;
    private JLabel jLabel46;
    private JPanel jPanel13;
    private JPanel jPanel14;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JTextArea v_aiOutputLogArea;
    private JScrollPane v_aiOutputLogAreaScrollPane;
    private JButton v_cancelButton;
    private JCheckBox v_enableAILogging;
    private JCheckBox v_limitLogHistoryCB;
    private JSpinner v_limitLogHistoryToSpinner;
    private JComboBox v_logDepth;
    private JTabbedPane v_logHolderTabbedPane;
    private JButton v_okButton;
    private JPanel v_pauseAIs;
    private JButton v_restoreDefaultsButton;
    private JButton v_settingsDetailsButton;
    private JTabbedPane v_tabPaneMain;

    public LogWindow(TripleAFrame frame) {
        super(frame);
        this.initComponents();
    }

    public void clear() {
        this.dispose();
        this.v_tabPaneMain = null;
        this.v_logHolderTabbedPane = null;
    }

    private void initComponents() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.jPanel7 = new JPanel();
        this.v_restoreDefaultsButton = new JButton();
        this.v_settingsDetailsButton = new JButton();
        this.jPanel14 = new JPanel();
        this.jPanel13 = new JPanel();
        this.v_cancelButton = new JButton();
        this.v_okButton = new JButton();
        this.v_tabPaneMain = new JTabbedPane();
        this.jPanel8 = new JPanel();
        this.v_logHolderTabbedPane = new JTabbedPane();
        this.jPanel9 = new JPanel();
        this.v_aiOutputLogAreaScrollPane = new JScrollPane();
        this.v_aiOutputLogArea = new JTextArea();
        this.v_enableAILogging = new JCheckBox();
        this.jLabel15 = new JLabel();
        this.v_logDepth = new JComboBox();
        this.v_limitLogHistoryToSpinner = new JSpinner();
        this.v_limitLogHistoryCB = new JCheckBox();
        this.jLabel46 = new JLabel();
        this.v_pauseAIs = new JPanel();
        this.setTitle("Hard AI Settings");
        this.setMinimumSize(new Dimension(775, 400));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                LogWindow.this.formWindowClosing(evt);
            }

            @Override
            public void windowOpened(WindowEvent evt) {
                LogWindow.this.formWindowOpened(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel7.setName("jPanel3");
        this.jPanel7.setPreferredSize(new Dimension(600, 45));
        this.jPanel7.setLayout(new GridBagLayout());
        this.v_restoreDefaultsButton.setText("Restore Defaults");
        this.v_restoreDefaultsButton.setMinimumSize(new Dimension(118, 23));
        this.v_restoreDefaultsButton.setName("v_restoreDefaultsButton");
        this.v_restoreDefaultsButton.setPreferredSize(new Dimension(118, 23));
        this.v_restoreDefaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogWindow.this.v_restoreDefaultsButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 0, 11, 0);
        this.jPanel7.add((Component)this.v_restoreDefaultsButton, gridBagConstraints);
        this.v_settingsDetailsButton.setText("Settings Details");
        this.v_settingsDetailsButton.setMinimumSize(new Dimension(115, 23));
        this.v_settingsDetailsButton.setName("v_settingsDetailsButton");
        this.v_settingsDetailsButton.setPreferredSize(new Dimension(115, 23));
        this.v_settingsDetailsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogWindow.this.v_settingsDetailsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(11, 6, 11, 0);
        this.jPanel7.add((Component)this.v_settingsDetailsButton, gridBagConstraints);
        this.jPanel14.setName("jPanel14");
        this.jPanel14.setLayout(new GridBagLayout());
        this.jPanel13.setName("jPanel13");
        this.jPanel13.setLayout(new GridBagLayout());
        this.v_cancelButton.setText("Cancel");
        this.v_cancelButton.setName("v_cancelButton");
        this.v_cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogWindow.this.v_cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel13.add((Component)this.v_cancelButton, gridBagConstraints);
        this.v_okButton.setText("OK");
        this.v_okButton.setName("v_okButton");
        this.v_okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogWindow.this.v_okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.jPanel13.add((Component)this.v_okButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.jPanel14.add((Component)this.jPanel13, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 99.0;
        gridBagConstraints.insets = new Insets(11, 6, 11, 0);
        this.jPanel7.add((Component)this.jPanel14, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 99.0;
        gridBagConstraints.insets = new Insets(0, 7, 0, 7);
        this.getContentPane().add((Component)this.jPanel7, gridBagConstraints);
        this.v_tabPaneMain.setTabLayoutPolicy(1);
        this.v_tabPaneMain.setName("v_tabPaneMain");
        this.v_tabPaneMain.setPreferredSize(new Dimension(500, screenSize.height - 200));
        this.jPanel8.setName("jPanel8");
        this.jPanel8.setPreferredSize(new Dimension(500, 314));
        this.jPanel8.setLayout(new GridBagLayout());
        this.v_logHolderTabbedPane.setTabLayoutPolicy(1);
        this.v_logHolderTabbedPane.setFont(new Font("Segoe UI", 0, 10));
        this.v_logHolderTabbedPane.setName("v_logHolderTabbedPane");
        this.jPanel9.setName("jPanel9");
        this.jPanel9.setLayout(new GridLayout(1, 0));
        this.v_aiOutputLogAreaScrollPane.setName("v_aiOutputLogAreaScrollPane");
        this.v_aiOutputLogArea.setColumns(20);
        this.v_aiOutputLogArea.setEditable(false);
        this.v_aiOutputLogArea.setFont(new Font("Segoe UI", 0, 10));
        this.v_aiOutputLogArea.setRows(5);
        this.v_aiOutputLogArea.setName("v_aiOutputLogArea");
        this.v_aiOutputLogAreaScrollPane.setViewportView(this.v_aiOutputLogArea);
        this.jPanel9.add(this.v_aiOutputLogAreaScrollPane);
        this.v_logHolderTabbedPane.addTab("Pre-Game", this.jPanel9);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 99.0;
        gridBagConstraints.weighty = 99.0;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.jPanel8.add((Component)this.v_logHolderTabbedPane, gridBagConstraints);
        this.v_enableAILogging.setSelected(true);
        this.v_enableAILogging.setText("Enable AI Logging");
        this.v_enableAILogging.setName("v_enableAILogging");
        this.v_enableAILogging.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                LogWindow.this.v_enableAILoggingStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(7, 7, 0, 0);
        this.jPanel8.add((Component)this.v_enableAILogging, gridBagConstraints);
        this.jLabel15.setText("Log Depth:");
        this.jLabel15.setName("jLabel15");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(7, 12, 0, 0);
        this.jPanel8.add((Component)this.jLabel15, gridBagConstraints);
        this.v_logDepth.setModel(new DefaultComboBoxModel<String>(new String[]{"Fine", "Finer", "Finest"}));
        this.v_logDepth.setSelectedItem(this.v_logDepth.getItemAt(2));
        this.v_logDepth.setName("v_logDepth");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(7, 5, 0, 0);
        this.jPanel8.add((Component)this.v_logDepth, gridBagConstraints);
        this.v_limitLogHistoryToSpinner.setModel(new SpinnerNumberModel(5, 1, 100, 1));
        this.v_limitLogHistoryToSpinner.setMinimumSize(new Dimension(60, 20));
        this.v_limitLogHistoryToSpinner.setName("v_limitLogHistoryToSpinner");
        this.v_limitLogHistoryToSpinner.setPreferredSize(new Dimension(60, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.insets = new Insets(7, 0, 0, 0);
        this.jPanel8.add((Component)this.v_limitLogHistoryToSpinner, gridBagConstraints);
        this.v_limitLogHistoryCB.setSelected(true);
        this.v_limitLogHistoryCB.setText("Limit Log History To:");
        this.v_limitLogHistoryCB.setName("v_limitLogHistoryCB");
        this.v_limitLogHistoryCB.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                LogWindow.this.v_limitLogHistoryCBStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(7, 0, 0, 12);
        this.jPanel8.add((Component)this.v_limitLogHistoryCB, gridBagConstraints);
        this.jLabel46.setText("rounds");
        this.jLabel46.setName("jLabel46");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(7, 5, 0, 7);
        this.jPanel8.add((Component)this.jLabel46, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 99.0;
        gridBagConstraints.insets = new Insets(7, 0, 0, 0);
        this.jPanel8.add((Component)this.v_pauseAIs, gridBagConstraints);
        this.v_tabPaneMain.addTab("Debugging", this.jPanel8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 99.0;
        gridBagConstraints.weighty = 99.0;
        gridBagConstraints.insets = new Insets(7, 7, 0, 7);
        this.getContentPane().add((Component)this.v_tabPaneMain, gridBagConstraints);
        this.setBounds(screenSize.width - 800, 25, 775, 401);
    }

    private void formWindowOpened(WindowEvent evt) {
        this.loadSettings(LogSettings.loadSettings());
        this.pack();
    }

    private void loadSettings(LogSettings settings) {
        this.v_enableAILogging.setSelected(settings.EnableAILogging);
        if (settings.AILoggingDepth.equals(Level.FINE)) {
            this.v_logDepth.setSelectedIndex(0);
        } else if (settings.AILoggingDepth.equals(Level.FINER)) {
            this.v_logDepth.setSelectedIndex(1);
        } else if (settings.AILoggingDepth.equals(Level.FINEST)) {
            this.v_logDepth.setSelectedIndex(2);
        }
        this.v_limitLogHistoryCB.setSelected(settings.LimitLogHistory);
        this.v_limitLogHistoryToSpinner.setValue(settings.LimitLogHistoryTo);
    }

    public LogSettings createSettings() {
        LogSettings settings = new LogSettings();
        settings.EnableAILogging = this.v_enableAILogging.isSelected();
        if (this.v_logDepth.getSelectedIndex() == 0) {
            settings.AILoggingDepth = Level.FINE;
        } else if (this.v_logDepth.getSelectedIndex() == 1) {
            settings.AILoggingDepth = Level.FINER;
        } else if (this.v_logDepth.getSelectedIndex() == 2) {
            settings.AILoggingDepth = Level.FINEST;
        }
        settings.LimitLogHistory = this.v_limitLogHistoryCB.isSelected();
        settings.LimitLogHistoryTo = Integer.parseInt(this.v_limitLogHistoryToSpinner.getValue().toString());
        return settings;
    }

    private void v_restoreDefaultsButtonActionPerformed(ActionEvent evt) {
        int result = JOptionPane.showConfirmDialog(this.rootPane, "Are you sure you want to reset all Dynamix AI settings?", "Reset Default Settings", 2, 3);
        if (result == 0) {
            LogSettings defaultSettings = new LogSettings();
            this.loadSettings(defaultSettings);
            JOptionPane.showMessageDialog(this.rootPane, "Default settings restored.\r\n\r\n(If you don't want to keep these default settings, just hit cancel)", "Default Settings Restored", 1);
        }
    }

    private void v_enableAILoggingStateChanged(ChangeEvent evt) {
        this.v_logDepth.setEnabled(this.v_enableAILogging.isSelected());
        this.v_limitLogHistoryCB.setEnabled(this.v_enableAILogging.isSelected());
    }

    private void v_limitLogHistoryCBStateChanged(ChangeEvent evt) {
        this.v_limitLogHistoryToSpinner.setEnabled(this.v_limitLogHistoryCB.isSelected() && this.v_enableAILogging.isSelected());
    }

    private void formWindowClosing(WindowEvent evt) {
        this.v_cancelButtonActionPerformed(null);
    }

    private void v_okButtonActionPerformed(ActionEvent evt) {
        LogSettings settings = this.createSettings();
        LogSettings.saveSettings(settings);
        this.setVisible(false);
    }

    private void v_cancelButtonActionPerformed(ActionEvent evt) {
        LogSettings settings = LogSettings.loadSettings();
        this.loadSettings(settings);
        this.setVisible(false);
    }

    private void v_settingsDetailsButtonActionPerformed(ActionEvent evt) {
        final JDialog dialog = new JDialog((Dialog)this, "Pro AI - Settings Details");
        String message = "";
        if (this.v_tabPaneMain.getSelectedIndex() == 0) {
            message = "Debugging\r\n\r\nAI Logging: When this is checked, the AI's will output their logs, as they come in, so you can see exactly what the AI is thinking.\r\nNote that if you check this on, you still have to press OK then reopen the settings window for the logs to actually start displaying.\r\n\r\nLog Depth: This setting lets you choose how deep you want the AI logging to be. Fine only displays the high-level events, like the start of a phase, etc.\r\nFiner displays medium-level events, such as attacks, reinforcements, etc.\r\nFinest displays all the AI logging available. Can be used for detailed ananlysis, but is a lot harder to read through it.\r\n\r\nPause AI's: This checkbox pauses all the Dynamix AI's while it's checked, so you can look at the logs without the AI's outputing floods of information.\r\n\r\nLimit Log History To X Rounds: If this is checked, the AI log information will be limited to X rounds of information.\r\n";
        }
        JTextArea label = new JTextArea(message);
        label.setFont(new Font("Segoe UI", 0, 12));
        label.setEditable(false);
        label.setAutoscrolls(true);
        label.setLineWrap(false);
        label.setFocusable(false);
        label.setWrapStyleWord(true);
        label.setLocation(0, 0);
        dialog.setBackground(label.getBackground());
        dialog.setLayout(new BorderLayout());
        JScrollPane pane = new JScrollPane();
        pane.setHorizontalScrollBarPolicy(30);
        pane.setVerticalScrollBarPolicy(20);
        pane.setViewportView(label);
        dialog.add((Component)pane, "Center");
        JButton button = new JButton(new AbstractAction(){
            private static final long serialVersionUID = -1367858475413936399L;

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        button.setText("Close");
        button.setMinimumSize(new Dimension(100, 30));
        dialog.add((Component)button, "South");
        dialog.setMinimumSize(new Dimension(500, 300));
        dialog.setSize(new Dimension(800, 600));
        dialog.setResizable(true);
        dialog.setLocationRelativeTo(this);
        dialog.setDefaultCloseOperation(2);
        dialog.setVisible(true);
    }

    public void addMessage(Level level, String message) {
        try {
            if (this.currentLogTextArea == null) {
                this.currentLogTextArea = this.v_aiOutputLogArea;
            }
            this.currentLogTextArea.append(message + "\r\n");
        }
        catch (NullPointerException ex) {
            System.out.print("Error adding Pro log message! Level: " + level.getName() + " Message: " + message);
        }
    }

    public void notifyNewRound(final int roundNumber, final String name) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    JPanel newPanel = new JPanel();
                    JScrollPane newScrollPane = new JScrollPane();
                    JTextArea newTextArea = new JTextArea();
                    newTextArea.setColumns(20);
                    newTextArea.setRows(5);
                    newTextArea.setFont(new Font("Segoe UI", 0, 10));
                    newTextArea.setEditable(false);
                    newScrollPane.getHorizontalScrollBar().setEnabled(true);
                    newScrollPane.setViewportView(newTextArea);
                    newPanel.setLayout(new GridLayout());
                    newPanel.add(newScrollPane);
                    LogWindow.this.v_logHolderTabbedPane.addTab(Integer.toString(roundNumber) + "-" + name, newPanel);
                    LogWindow.this.currentLogTextArea = newTextArea;
                }
            });
        }
        catch (Exception ex) {
            System.out.print("Error initializing ProAI settings window: " + ex.toString() + "\r\n");
        }
        this.trimLogRoundPanels();
    }

    private void trimLogRoundPanels() {
        if (LogSettings.loadSettings().EnableAILogging && LogSettings.loadSettings().LimitLogHistory || !LogSettings.loadSettings().EnableAILogging) {
            final int maxHistoryRounds = LogSettings.loadSettings().EnableAILogging ? LogSettings.loadSettings().LimitLogHistoryTo : 1;
            try {
                Runnable runner = new Runnable(){

                    @Override
                    public void run() {
                        for (int i = 0; i < LogWindow.this.v_logHolderTabbedPane.getTabCount(); ++i) {
                            if (i == 0 || i >= LogWindow.this.v_logHolderTabbedPane.getTabCount() - maxHistoryRounds) continue;
                            LogWindow.this.v_logHolderTabbedPane.removeTabAt(i);
                            --i;
                        }
                    }
                };
                SwingUtilities.invokeAndWait(runner);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

