/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.proAI.simulate;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.RelationshipTracker;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.triplea.ai.proAI.ProAI;
import games.strategy.triplea.ai.proAI.ProAttackTerritoryData;
import games.strategy.triplea.ai.proAI.ProBattleResultData;
import games.strategy.triplea.ai.proAI.util.LogUtils;
import games.strategy.triplea.ai.proAI.util.ProBattleUtils;
import games.strategy.triplea.ai.proAI.util.ProMatches;
import games.strategy.triplea.ai.proAI.util.ProMoveUtils;
import games.strategy.triplea.ai.proAI.util.ProUtils;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.delegate.BattleDelegate;
import games.strategy.triplea.delegate.BattleTracker;
import games.strategy.triplea.delegate.DelegateFinder;
import games.strategy.triplea.delegate.IBattle;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.OriginalOwnerTracker;
import games.strategy.triplea.delegate.TransportTracker;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class ProSimulateTurnUtils {
    private final ProAI ai;
    private final ProUtils utils;
    private final ProBattleUtils battleUtils;
    private final ProMoveUtils moveUtils;

    public ProSimulateTurnUtils(ProAI ai, ProUtils utils, ProBattleUtils battleUtils, ProMoveUtils moveUtils) {
        this.ai = ai;
        this.utils = utils;
        this.battleUtils = battleUtils;
        this.moveUtils = moveUtils;
    }

    public void simulateBattles(GameData data, PlayerID player, IDelegateBridge delegateBridge) {
        LogUtils.log(Level.FINE, "Starting battle simulation phase");
        BattleDelegate battleDelegate = DelegateFinder.battleDelegate(data);
        Map<IBattle.BattleType, Collection<Territory>> battleTerritories = battleDelegate.getBattles().getBattles();
        for (Map.Entry<IBattle.BattleType, Collection<Territory>> entry : battleTerritories.entrySet()) {
            for (Territory t : entry.getValue()) {
                IBattle battle = battleDelegate.getBattleTracker().getPendingBattle(t, entry.getKey().isBombingRun(), entry.getKey());
                List attackers = (List)battle.getAttackingUnits();
                attackers.retainAll(t.getUnits().getUnits());
                List defenders = (List)battle.getDefendingUnits();
                defenders.retainAll(t.getUnits().getUnits());
                HashSet<Unit> bombardingUnits = new HashSet<Unit>(battle.getBombardingUnits());
                LogUtils.log(Level.FINER, "---" + t);
                LogUtils.log(Level.FINER, "attackers=" + attackers);
                LogUtils.log(Level.FINER, "defenders=" + defenders);
                LogUtils.log(Level.FINER, "bombardingUnits=" + bombardingUnits);
                ProBattleResultData result = this.battleUtils.callBattleCalculator(player, t, attackers, defenders, bombardingUnits, true);
                List<Unit> remainingUnits = result.getAverageUnitsRemaining();
                LogUtils.log(Level.FINER, "remainingUnits=" + remainingUnits);
                ArrayList<Unit> attackersToRemove = new ArrayList<Unit>(attackers);
                attackersToRemove.removeAll(remainingUnits);
                List<Unit> defendersToRemove = Match.getMatches(defenders, Matches.UnitIsInfrastructure.invert());
                List<Unit> infrastructureToChangeOwner = Match.getMatches(defenders, Matches.UnitIsInfrastructure);
                LogUtils.log(Level.FINER, "attackersToRemove=" + attackersToRemove);
                LogUtils.log(Level.FINER, "defendersToRemove=" + defendersToRemove);
                LogUtils.log(Level.FINER, "infrastructureToChangeOwner=" + infrastructureToChangeOwner);
                Change attackerskilledChange = ChangeFactory.removeUnits(t, attackersToRemove);
                delegateBridge.addChange(attackerskilledChange);
                Change defenderskilledChange = ChangeFactory.removeUnits(t, defendersToRemove);
                delegateBridge.addChange(defenderskilledChange);
                BattleTracker.captureOrDestroyUnits(t, player, player, delegateBridge, null, remainingUnits);
                if (!this.checkIfCapturedTerritoryIsAlliedCapital(t, data, player, delegateBridge)) {
                    delegateBridge.addChange(ChangeFactory.changeOwner(t, player));
                }
                battleDelegate.getBattleTracker().getConquered().add(t);
                battleDelegate.getBattleTracker().removeBattle(battle);
                Territory updatedTerritory = data.getMap().getTerritory(t.getName());
                LogUtils.log(Level.FINER, "after changes owner=" + updatedTerritory.getOwner() + ", units=" + updatedTerritory.getUnits().getUnits());
            }
        }
    }

    public Map<Territory, ProAttackTerritoryData> transferMoveMap(Map<Territory, ProAttackTerritoryData> moveMap, Map<Unit, Territory> unitTerritoryMap, GameData fromData, GameData toData, PlayerID player) {
        LogUtils.log(Level.FINE, "Transferring move map");
        HashMap<Territory, ProAttackTerritoryData> result = new HashMap<Territory, ProAttackTerritoryData>();
        ArrayList<Unit> usedUnits = new ArrayList<Unit>();
        for (Territory fromTerritory : moveMap.keySet()) {
            Unit toUnit;
            Territory toTerritory = toData.getMap().getTerritory(fromTerritory.getName());
            ProAttackTerritoryData patd = new ProAttackTerritoryData(toTerritory);
            result.put(toTerritory, patd);
            Map<Unit, List<Unit>> amphibAttackMap = moveMap.get(fromTerritory).getAmphibAttackMap();
            Map<Unit, Boolean> isTransportingMap = moveMap.get(fromTerritory).getIsTransportingMap();
            Map<Unit, Territory> transportTerritoryMap = moveMap.get(fromTerritory).getTransportTerritoryMap();
            Map<Unit, Territory> bombardMap = moveMap.get(fromTerritory).getBombardTerritoryMap();
            LogUtils.log(Level.FINER, "Transferring " + fromTerritory + " to " + toTerritory);
            ArrayList amphibUnits = new ArrayList();
            for (Unit transport : amphibAttackMap.keySet()) {
                Unit toTransport = null;
                ArrayList<Unit> toUnits = new ArrayList<Unit>();
                if (isTransportingMap.get(transport).booleanValue()) {
                    toTransport = this.transferLoadedTransport(transport, amphibAttackMap.get(transport), unitTerritoryMap, usedUnits, toData, player);
                    toUnits.addAll(TransportTracker.transporting(toTransport));
                } else {
                    toTransport = this.transferUnit(transport, unitTerritoryMap, usedUnits, toData, player);
                    for (Unit u : amphibAttackMap.get(transport)) {
                        Unit toUnit2 = this.transferUnit(u, unitTerritoryMap, usedUnits, toData, player);
                        toUnits.add(toUnit2);
                    }
                }
                patd.addUnits(toUnits);
                patd.putAmphibAttackMap(toTransport, toUnits);
                amphibUnits.addAll(amphibAttackMap.get(transport));
                if (transportTerritoryMap.get(transport) != null) {
                    patd.getTransportTerritoryMap().put(toTransport, toData.getMap().getTerritory(transportTerritoryMap.get(transport).getName()));
                }
                LogUtils.log(Level.FINEST, "---Transferring transport=" + transport + " with units=" + amphibAttackMap.get(transport) + " unloadTerritory=" + transportTerritoryMap.get(transport) + " to transport=" + toTransport + " with units=" + toUnits + " unloadTerritory=" + patd.getTransportTerritoryMap().get(toTransport));
            }
            for (Unit u : moveMap.get(fromTerritory).getUnits()) {
                if (amphibUnits.contains(u)) continue;
                toUnit = this.transferUnit(u, unitTerritoryMap, usedUnits, toData, player);
                patd.addUnit(toUnit);
                LogUtils.log(Level.FINEST, "---Transferring unit " + u + " to " + toUnit);
            }
            for (Unit u : bombardMap.keySet()) {
                toUnit = this.transferUnit(u, unitTerritoryMap, usedUnits, toData, player);
                patd.getBombardTerritoryMap().put(toUnit, toData.getMap().getTerritory(bombardMap.get(u).getName()));
                LogUtils.log(Level.FINEST, "---Transferring bombard=" + u + ", bombardFromTerritory=" + bombardMap.get(u) + " to bomard=" + toUnit + ", bombardFromTerritory=" + patd.getBombardTerritoryMap().get(toUnit));
            }
        }
        return result;
    }

    private boolean checkIfCapturedTerritoryIsAlliedCapital(Territory t, GameData data, PlayerID player, IDelegateBridge delegateBridge) {
        PlayerID terrOrigOwner = OriginalOwnerTracker.getOriginalOwner(t);
        RelationshipTracker relationshipTracker = data.getRelationshipTracker();
        TerritoryAttachment ta = TerritoryAttachment.get(t);
        if (ta != null && ta.getCapital() != null && terrOrigOwner != null && TerritoryAttachment.getAllCapitals(terrOrigOwner, data).contains(t) && relationshipTracker.isAllied(terrOrigOwner, player)) {
            Collection<Territory> originallyOwned = OriginalOwnerTracker.getOriginallyOwned(data, terrOrigOwner);
            List<Territory> friendlyTerritories = Match.getMatches(originallyOwned, Matches.isTerritoryAllied(terrOrigOwner, data));
            friendlyTerritories.add(t);
            for (Territory item : friendlyTerritories) {
                if (item.getOwner() == terrOrigOwner) continue;
                Change takeOverFriendlyTerritories = ChangeFactory.changeOwner(item, terrOrigOwner);
                delegateBridge.addChange(takeOverFriendlyTerritories);
                List<Unit> units = Match.getMatches(item.getUnits().getUnits(), Matches.UnitIsInfrastructure);
                if (units.isEmpty()) continue;
                Change takeOverNonComUnits = ChangeFactory.changeOwner(units, terrOrigOwner, t);
                delegateBridge.addChange(takeOverNonComUnits);
            }
            return true;
        }
        return false;
    }

    private Unit transferUnit(Unit u, Map<Unit, Territory> unitTerritoryMap, List<Unit> usedUnits, GameData toData, PlayerID player) {
        Territory unitTerritory = unitTerritoryMap.get(u);
        List<Unit> toUnits = toData.getMap().getTerritory(unitTerritory.getName()).getUnits().getMatches(ProMatches.unitIsOwnedAndMatchesTypeAndNotTransporting(player, u.getType()));
        for (Unit toUnit : toUnits) {
            if (usedUnits.contains(toUnit)) continue;
            usedUnits.add(toUnit);
            return toUnit;
        }
        return null;
    }

    private Unit transferLoadedTransport(Unit transport, List<Unit> transportingUnits, Map<Unit, Territory> unitTerritoryMap, List<Unit> usedUnits, GameData toData, PlayerID player) {
        Territory unitTerritory = unitTerritoryMap.get(transport);
        List<Unit> toTransports = toData.getMap().getTerritory(unitTerritory.getName()).getUnits().getMatches(ProMatches.unitIsOwnedAndMatchesTypeAndIsTransporting(player, transport.getType()));
        for (Unit toTransport : toTransports) {
            if (usedUnits.contains(toTransport)) continue;
            List toTransportingUnits = (List)TransportTracker.transporting(toTransport);
            if (transportingUnits.size() != toTransportingUnits.size()) continue;
            boolean canTransfer = true;
            for (int i = 0; i < transportingUnits.size(); ++i) {
                if (transportingUnits.get(i).getType().equals(((Unit)toTransportingUnits.get(i)).getType())) continue;
                canTransfer = false;
                break;
            }
            if (!canTransfer) continue;
            usedUnits.add(toTransport);
            usedUnits.addAll(toTransportingUnits);
            return toTransport;
        }
        return null;
    }
}

