/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.proAI.util;

import games.strategy.triplea.ai.proAI.ProAI;
import games.strategy.triplea.ai.proAI.logging.LogSettings;
import games.strategy.triplea.ai.proAI.logging.LogUI;
import java.util.logging.Level;

public class LogUtils {
    public static void log(Level level, String message, Throwable t) {
        if (t == null) {
            ProAI.getLogger().log(level, LogUtils.addIndentationCompensation(message, level));
        } else {
            ProAI.getLogger().log(level, LogUtils.addIndentationCompensation(message, level), t);
        }
        if (!LogSettings.loadSettings().EnableAILogging) {
            return;
        }
        Level logDepth = LogSettings.loadSettings().AILoggingDepth;
        if (logDepth.equals(Level.FINE) && (level.equals(Level.FINER) || level.equals(Level.FINEST))) {
            return;
        }
        if (logDepth.equals(Level.FINER) && level.equals(Level.FINEST)) {
            return;
        }
        LogUI.notifyAILogMessage(level, LogUtils.addIndentationCompensation(message, level));
    }

    public static void log(Level level, String message) {
        LogUtils.log(level, message, null);
    }

    private static String addIndentationCompensation(String message, Level level) {
        StringBuilder builder = new StringBuilder();
        int compensateLength = (level.toString().length() - 4) * 2;
        if (compensateLength == 0) {
            return message;
        }
        for (int i = 0; i < compensateLength; ++i) {
            builder.append(" ");
        }
        builder.append(message);
        return builder.toString();
    }
}

