/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.proAI.util;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.Properties;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.ai.proAI.ProAI;
import games.strategy.triplea.ai.proAI.ProAmphibData;
import games.strategy.triplea.ai.proAI.ProAttackTerritoryData;
import games.strategy.triplea.ai.proAI.util.LogUtils;
import games.strategy.triplea.ai.proAI.util.ProBattleUtils;
import games.strategy.triplea.ai.proAI.util.ProMatches;
import games.strategy.triplea.ai.proAI.util.ProPurchaseUtils;
import games.strategy.triplea.ai.proAI.util.ProTransportUtils;
import games.strategy.triplea.ai.proAI.util.ProUtils;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.BattleCalculator;
import games.strategy.triplea.delegate.DiceRoll;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.MoveValidator;
import games.strategy.triplea.delegate.TerritoryEffectHelper;
import games.strategy.triplea.delegate.TransportTracker;
import games.strategy.triplea.delegate.UnitBattleComparator;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.CompositeMatchOr;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class ProAttackOptionsUtils {
    public static double WIN_PERCENTAGE = 95.0;
    public static double MIN_WIN_PERCENTAGE = 75.0;
    private final ProAI ai;
    private final ProUtils utils;
    private final ProBattleUtils battleUtils;
    private final ProTransportUtils transportUtils;
    private final ProPurchaseUtils purchaseUtils;

    public ProAttackOptionsUtils(ProAI ai, ProUtils utils, ProBattleUtils battleUtils, ProTransportUtils transportUtils, ProPurchaseUtils purchaseUtils) {
        this.ai = ai;
        this.utils = utils;
        this.battleUtils = battleUtils;
        this.transportUtils = transportUtils;
        this.purchaseUtils = purchaseUtils;
    }

    public Map<Unit, Set<Territory>> sortUnitMoveOptions(PlayerID player, Map<Unit, Set<Territory>> unitAttackOptions) {
        GameData data = this.ai.getGameData();
        final IntegerMap<UnitType> playerCostMap = BattleCalculator.getCostsForTUV(player, data);
        LinkedList<Map.Entry<Unit, Set<Territory>>> list = new LinkedList<Map.Entry<Unit, Set<Territory>>>(unitAttackOptions.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Unit, Set<Territory>>>(){

            @Override
            public int compare(Map.Entry<Unit, Set<Territory>> o1, Map.Entry<Unit, Set<Territory>> o2) {
                if (o1.getValue().size() != o2.getValue().size()) {
                    return o1.getValue().size() - o2.getValue().size();
                }
                if (playerCostMap.getInt(o1.getKey().getType()) != playerCostMap.getInt(o2.getKey().getType())) {
                    return playerCostMap.getInt(o1.getKey().getType()) - playerCostMap.getInt(o2.getKey().getType());
                }
                return o1.getKey().getType().getName().compareTo(o2.getKey().getType().getName());
            }
        });
        LinkedHashMap<Unit, Set<Territory>> sortedUnitAttackOptions = new LinkedHashMap<Unit, Set<Territory>>();
        for (Map.Entry entry : list) {
            sortedUnitAttackOptions.put((Unit)entry.getKey(), (Set<Territory>)entry.getValue());
        }
        return sortedUnitAttackOptions;
    }

    public Map<Unit, Set<Territory>> sortUnitNeededOptions(final PlayerID player, Map<Unit, Set<Territory>> unitAttackOptions, final Map<Territory, ProAttackTerritoryData> attackMap) {
        final GameData data = this.ai.getGameData();
        final IntegerMap<UnitType> playerCostMap = BattleCalculator.getCostsForTUV(player, data);
        LinkedList<Map.Entry<Unit, Set<Territory>>> list = new LinkedList<Map.Entry<Unit, Set<Territory>>>(unitAttackOptions.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Unit, Set<Territory>>>(){

            @Override
            public int compare(Map.Entry<Unit, Set<Territory>> o1, Map.Entry<Unit, Set<Territory>> o2) {
                int numOptions1 = 0;
                for (Territory t : o1.getValue()) {
                    ProAttackTerritoryData patd = (ProAttackTerritoryData)attackMap.get(t);
                    if (patd.getBattleResult() == null) {
                        patd.setBattleResult(ProAttackOptionsUtils.this.battleUtils.estimateAttackBattleResults(player, t, patd.getUnits(), patd.getMaxEnemyDefenders(player, data), patd.getBombardTerritoryMap().keySet()));
                    }
                    if (patd.isCurrentlyWins()) continue;
                    ++numOptions1;
                }
                int numOptions2 = 0;
                for (Territory t : o2.getValue()) {
                    ProAttackTerritoryData patd = (ProAttackTerritoryData)attackMap.get(t);
                    if (patd.getBattleResult() == null) {
                        patd.setBattleResult(ProAttackOptionsUtils.this.battleUtils.estimateAttackBattleResults(player, t, patd.getUnits(), patd.getMaxEnemyDefenders(player, data), patd.getBombardTerritoryMap().keySet()));
                    }
                    if (patd.isCurrentlyWins()) continue;
                    ++numOptions2;
                }
                if (numOptions1 != numOptions2) {
                    return numOptions1 - numOptions2;
                }
                if (playerCostMap.getInt(o1.getKey().getType()) != playerCostMap.getInt(o2.getKey().getType())) {
                    return playerCostMap.getInt(o1.getKey().getType()) - playerCostMap.getInt(o2.getKey().getType());
                }
                return o1.getKey().getType().getName().compareTo(o2.getKey().getType().getName());
            }
        });
        LinkedHashMap<Unit, Set<Territory>> sortedUnitAttackOptions = new LinkedHashMap<Unit, Set<Territory>>();
        for (Map.Entry entry : list) {
            sortedUnitAttackOptions.put((Unit)entry.getKey(), (Set<Territory>)entry.getValue());
        }
        return sortedUnitAttackOptions;
    }

    public Map<Unit, Set<Territory>> sortUnitNeededOptionsThenAttack(final PlayerID player, Map<Unit, Set<Territory>> unitAttackOptions, final Map<Territory, ProAttackTerritoryData> attackMap, final Map<Unit, Territory> unitTerritoryMap) {
        final GameData data = this.ai.getGameData();
        final IntegerMap<UnitType> playerCostMap = BattleCalculator.getCostsForTUV(player, data);
        LinkedList<Map.Entry<Unit, Set<Territory>>> list = new LinkedList<Map.Entry<Unit, Set<Territory>>>(unitAttackOptions.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Unit, Set<Territory>>>(){

            @Override
            public int compare(Map.Entry<Unit, Set<Territory>> o1, Map.Entry<Unit, Set<Territory>> o2) {
                boolean isAirUnit;
                double attackEfficiency2;
                int numOptions1 = 0;
                for (Territory t : o1.getValue()) {
                    ProAttackTerritoryData patd = (ProAttackTerritoryData)attackMap.get(t);
                    if (patd.getBattleResult() == null) {
                        patd.setBattleResult(ProAttackOptionsUtils.this.battleUtils.estimateAttackBattleResults(player, t, patd.getUnits(), patd.getMaxEnemyDefenders(player, data), patd.getBombardTerritoryMap().keySet()));
                    }
                    if (patd.isCurrentlyWins()) continue;
                    ++numOptions1;
                }
                int numOptions2 = 0;
                for (Territory t : o2.getValue()) {
                    ProAttackTerritoryData patd = (ProAttackTerritoryData)attackMap.get(t);
                    if (patd.getBattleResult() == null) {
                        patd.setBattleResult(ProAttackOptionsUtils.this.battleUtils.estimateAttackBattleResults(player, t, patd.getUnits(), patd.getMaxEnemyDefenders(player, data), patd.getBombardTerritoryMap().keySet()));
                    }
                    if (patd.isCurrentlyWins()) continue;
                    ++numOptions2;
                }
                if (numOptions1 != numOptions2) {
                    return numOptions1 - numOptions2;
                }
                if (numOptions1 == 0) {
                    return 0;
                }
                int minPower1 = Integer.MAX_VALUE;
                for (Territory t : o1.getValue()) {
                    if (((ProAttackTerritoryData)attackMap.get(t)).isCurrentlyWins()) continue;
                    List<Unit> defendingUnits = t.getUnits().getMatches(Matches.enemyUnit(player, data));
                    ArrayList<Unit> sortedUnitsList = new ArrayList<Unit>(((ProAttackTerritoryData)attackMap.get(t)).getUnits());
                    Collections.sort(sortedUnitsList, new UnitBattleComparator(false, playerCostMap, TerritoryEffectHelper.getEffects(t), data, false, false));
                    Collections.reverse(sortedUnitsList);
                    int powerWithout = DiceRoll.getTotalPowerAndRolls(DiceRoll.getUnitPowerAndRollsForNormalBattles(sortedUnitsList, sortedUnitsList, defendingUnits, false, false, player, data, t, TerritoryEffectHelper.getEffects(t), false, null), data).getFirst();
                    sortedUnitsList.add(o1.getKey());
                    Collections.sort(sortedUnitsList, new UnitBattleComparator(false, playerCostMap, TerritoryEffectHelper.getEffects(t), data, false, false));
                    Collections.reverse(sortedUnitsList);
                    int powerWith = DiceRoll.getTotalPowerAndRolls(DiceRoll.getUnitPowerAndRollsForNormalBattles(sortedUnitsList, sortedUnitsList, defendingUnits, false, false, player, data, t, TerritoryEffectHelper.getEffects(t), false, null), data).getFirst();
                    int power = powerWith - powerWithout;
                    if (power >= minPower1) continue;
                    minPower1 = power;
                }
                UnitAttachment ua1 = UnitAttachment.get(o1.getKey().getType());
                if (ua1.getIsAir()) {
                    minPower1 *= 10;
                }
                double attackEfficiency1 = (double)minPower1 / (double)playerCostMap.getInt(o1.getKey().getType());
                int minPower2 = Integer.MAX_VALUE;
                for (Territory t : o2.getValue()) {
                    if (((ProAttackTerritoryData)attackMap.get(t)).isCurrentlyWins()) continue;
                    List<Unit> defendingUnits = t.getUnits().getMatches(Matches.enemyUnit(player, data));
                    ArrayList<Unit> sortedUnitsList = new ArrayList<Unit>(((ProAttackTerritoryData)attackMap.get(t)).getUnits());
                    Collections.sort(sortedUnitsList, new UnitBattleComparator(false, playerCostMap, TerritoryEffectHelper.getEffects(t), data, false, false));
                    Collections.reverse(sortedUnitsList);
                    int powerWithout = DiceRoll.getTotalPowerAndRolls(DiceRoll.getUnitPowerAndRollsForNormalBattles(sortedUnitsList, sortedUnitsList, defendingUnits, false, false, player, data, t, TerritoryEffectHelper.getEffects(t), false, null), data).getFirst();
                    sortedUnitsList.add(o2.getKey());
                    Collections.sort(sortedUnitsList, new UnitBattleComparator(false, playerCostMap, TerritoryEffectHelper.getEffects(t), data, false, false));
                    Collections.reverse(sortedUnitsList);
                    int powerWith = DiceRoll.getTotalPowerAndRolls(DiceRoll.getUnitPowerAndRollsForNormalBattles(sortedUnitsList, sortedUnitsList, defendingUnits, false, false, player, data, t, TerritoryEffectHelper.getEffects(t), false, null), data).getFirst();
                    int power = powerWith - powerWithout;
                    if (power >= minPower2) continue;
                    minPower2 = power;
                }
                UnitAttachment ua2 = UnitAttachment.get(o2.getKey().getType());
                if (ua2.getIsAir()) {
                    minPower2 *= 10;
                }
                if (attackEfficiency1 != (attackEfficiency2 = (double)minPower2 / (double)playerCostMap.getInt(o2.getKey().getType()))) {
                    if (attackEfficiency1 < attackEfficiency2) {
                        return 1;
                    }
                    return -1;
                }
                if (o1.getKey().getType().equals(o2.getKey().getType()) && (isAirUnit = UnitAttachment.get(o1.getKey().getType()).getIsAir())) {
                    int distance1 = 0;
                    for (Territory t : o1.getValue()) {
                        if (((ProAttackTerritoryData)attackMap.get(t)).isCurrentlyWins()) continue;
                        distance1 += data.getMap().getDistance_IgnoreEndForCondition((Territory)unitTerritoryMap.get(o1.getKey()), t, ProMatches.territoryCanMoveAirUnitsAndNoAA(player, data, true));
                    }
                    int distance2 = 0;
                    for (Territory t : o2.getValue()) {
                        if (((ProAttackTerritoryData)attackMap.get(t)).isCurrentlyWins()) continue;
                        distance2 += data.getMap().getDistance_IgnoreEndForCondition((Territory)unitTerritoryMap.get(o2.getKey()), t, ProMatches.territoryCanMoveAirUnitsAndNoAA(player, data, true));
                    }
                    if (distance1 != distance2) {
                        return distance1 - distance2;
                    }
                }
                return o1.getKey().getType().getName().compareTo(o2.getKey().getType().getName());
            }
        });
        LinkedHashMap<Unit, Set<Territory>> sortedUnitAttackOptions = new LinkedHashMap<Unit, Set<Territory>>();
        for (Map.Entry entry : list) {
            sortedUnitAttackOptions.put((Unit)entry.getKey(), (Set<Territory>)entry.getValue());
        }
        return sortedUnitAttackOptions;
    }

    public void findScrambleOptions(final PlayerID player, Map<Territory, ProAttackTerritoryData> moveMap) {
        GameData data = this.ai.getGameData();
        if (!Properties.getScramble_Rules_In_Effect(data)) {
            return;
        }
        boolean fromIslandOnly = Properties.getScramble_From_Island_Only(data);
        boolean toSeaOnly = Properties.getScramble_To_Sea_Only(data);
        int maxScrambleDistance = 0;
        Iterator<UnitType> utIter = data.getUnitTypeList().iterator();
        while (utIter.hasNext()) {
            UnitAttachment ua = UnitAttachment.get(utIter.next());
            if (!ua.getCanScramble() || maxScrambleDistance >= ua.getMaxScrambleDistance()) continue;
            maxScrambleDistance = ua.getMaxScrambleDistance();
        }
        CompositeMatchAnd<Unit> airbasesCanScramble = new CompositeMatchAnd<Unit>(Matches.unitIsEnemyOf(data, player), Matches.UnitIsAirBase, Matches.UnitIsNotDisabled, Matches.unitIsBeingTransported().invert());
        CompositeMatchAnd<Territory> canScramble = new CompositeMatchAnd<Territory>(new CompositeMatchOr(Matches.TerritoryIsWater, Matches.isTerritoryEnemy(player, data)), Matches.territoryHasUnitsThatMatch(new CompositeMatchAnd<Unit>(Matches.UnitCanScramble, Matches.unitIsEnemyOf(data, player), Matches.UnitIsNotDisabled)), Matches.territoryHasUnitsThatMatch(airbasesCanScramble));
        if (fromIslandOnly) {
            canScramble.add(Matches.TerritoryIsIsland);
        }
        HashMap<Territory, HashSet<Territory>> scrambleTerrs = new HashMap<Territory, HashSet<Territory>>();
        for (Territory t : moveMap.keySet()) {
            HashSet<Territory> canScrambleFrom;
            if (!t.isWater() && toSeaOnly || (canScrambleFrom = new HashSet<Territory>(Match.getMatches(data.getMap().getNeighbors(t, maxScrambleDistance), canScramble))).isEmpty()) continue;
            scrambleTerrs.put(t, canScrambleFrom);
        }
        if (scrambleTerrs.isEmpty()) {
            return;
        }
        for (final Territory to : scrambleTerrs.keySet()) {
            for (Territory from : (HashSet)scrambleTerrs.get(to)) {
                List<Unit> airbases = from.getUnits().getMatches(airbasesCanScramble);
                int maxCanScramble = ProAttackOptionsUtils.getMaxScrambleCount(airbases);
                Route toBattleRoute = data.getMap().getRoute_IgnoreEnd(from, to, Matches.TerritoryIsNotImpassable);
                List<Unit> canScrambleAir = from.getUnits().getMatches(new CompositeMatchAnd<Unit>(Matches.unitIsEnemyOf(data, player), Matches.UnitCanScramble, Matches.UnitIsNotDisabled, Matches.UnitWasScrambled.invert(), Matches.unitCanScrambleOnRouteDistance(toBattleRoute)));
                if (maxCanScramble <= 0 || canScrambleAir.isEmpty()) continue;
                if (maxCanScramble < canScrambleAir.size()) {
                    Collections.sort(canScrambleAir, new Comparator<Unit>(){

                        @Override
                        public int compare(Unit o1, Unit o2) {
                            double strength1 = ProAttackOptionsUtils.this.battleUtils.estimateStrength(player, to, Collections.singletonList(o1), new ArrayList<Unit>(), false);
                            double strength2 = ProAttackOptionsUtils.this.battleUtils.estimateStrength(player, to, Collections.singletonList(o2), new ArrayList<Unit>(), false);
                            return Double.compare(strength2, strength1);
                        }
                    });
                    canScrambleAir = canScrambleAir.subList(0, maxCanScramble);
                }
                moveMap.get(to).getMaxScrambleUnits().addAll(canScrambleAir);
            }
        }
    }

    private static int getMaxScrambleCount(Collection<Unit> airbases) {
        if (!Match.allMatch(airbases, new CompositeMatchAnd(Matches.UnitIsAirBase, Matches.UnitIsNotDisabled))) {
            throw new IllegalStateException("All units must be viable airbases");
        }
        int maxScrambled = 0;
        for (Unit base : airbases) {
            UnitAttachment ua = UnitAttachment.get(base.getType());
            int baseMax = ua.getMaxScrambleCount();
            if (baseMax == -1) {
                return Integer.MAX_VALUE;
            }
            maxScrambled += baseMax;
        }
        return maxScrambled;
    }

    public void findAttackOptions(PlayerID player, List<Territory> myUnitTerritories, Map<Territory, ProAttackTerritoryData> moveMap, Map<Unit, Set<Territory>> unitMoveMap, Map<Unit, Set<Territory>> transportMoveMap, Map<Unit, Set<Territory>> bombardMap, Map<Territory, Set<Territory>> landRoutesMap, List<ProAmphibData> transportMapList, List<Territory> enemyTerritories, List<Territory> territoriesToCheck, boolean isCheckingEnemyAttacks, boolean isIgnoringRelationships) {
        GameData data = this.ai.getGameData();
        ArrayList<Territory> territoriesThatCantBeHeld = new ArrayList<Territory>(enemyTerritories);
        territoriesThatCantBeHeld.addAll(territoriesToCheck);
        this.findNavalMoveOptions(player, myUnitTerritories, moveMap, unitMoveMap, transportMoveMap, ProMatches.territoryIsEnemyOrHasEnemyUnitsOrCantBeHeld(player, data, territoriesThatCantBeHeld), enemyTerritories, true, isCheckingEnemyAttacks);
        this.findLandMoveOptions(player, myUnitTerritories, moveMap, unitMoveMap, landRoutesMap, ProMatches.territoryIsEnemyOrCantBeHeld(player, data, territoriesThatCantBeHeld), enemyTerritories, true, isCheckingEnemyAttacks, isIgnoringRelationships);
        this.findAirMoveOptions(player, myUnitTerritories, moveMap, unitMoveMap, ProMatches.territoryHasEnemyUnitsOrCantBeHeld(player, data, territoriesThatCantBeHeld), enemyTerritories, true, isCheckingEnemyAttacks, isIgnoringRelationships);
        this.findAmphibMoveOptions(player, myUnitTerritories, moveMap, transportMapList, landRoutesMap, ProMatches.territoryIsEnemyOrCantBeHeld(player, data, territoriesThatCantBeHeld), enemyTerritories, true, isCheckingEnemyAttacks, isIgnoringRelationships);
        this.findBombardOptions(player, myUnitTerritories, moveMap, bombardMap, transportMapList, isCheckingEnemyAttacks);
    }

    public void findPotentialAttackOptions(PlayerID player, List<Territory> myUnitTerritories, Map<Territory, ProAttackTerritoryData> moveMap, Map<Unit, Set<Territory>> unitMoveMap, Map<Unit, Set<Territory>> transportMoveMap, Map<Unit, Set<Territory>> bombardMap, Map<Territory, Set<Territory>> landRoutesMap, List<ProAmphibData> transportMapList) {
        GameData data = this.ai.getGameData();
        List<PlayerID> otherPlayers = this.utils.getPotentialEnemyPlayers(player);
        this.findNavalMoveOptions(player, myUnitTerritories, moveMap, unitMoveMap, transportMoveMap, ProMatches.territoryIsPotentialEnemyOrHasPotentialEnemyUnits(player, data, otherPlayers), new ArrayList<Territory>(), true, false);
        this.findLandMoveOptions(player, myUnitTerritories, moveMap, unitMoveMap, landRoutesMap, ProMatches.territoryIsPotentialEnemy(player, data, otherPlayers), new ArrayList<Territory>(), true, false, true);
        this.findAirMoveOptions(player, myUnitTerritories, moveMap, unitMoveMap, ProMatches.territoryHasPotentialEnemyUnits(player, data, otherPlayers), new ArrayList<Territory>(), true, false, true);
        this.findAmphibMoveOptions(player, myUnitTerritories, moveMap, transportMapList, landRoutesMap, ProMatches.territoryIsPotentialEnemy(player, data, otherPlayers), new ArrayList<Territory>(), true, false, true);
        this.findBombardOptions(player, myUnitTerritories, moveMap, bombardMap, transportMapList, false);
    }

    public void findDefendOptions(PlayerID player, List<Territory> myUnitTerritories, Map<Territory, ProAttackTerritoryData> moveMap, Map<Unit, Set<Territory>> unitMoveMap, Map<Unit, Set<Territory>> transportMoveMap, Map<Territory, Set<Territory>> landRoutesMap, List<ProAmphibData> transportMapList, List<Territory> clearedTerritories) {
        GameData data = this.ai.getGameData();
        this.findNavalMoveOptions(player, myUnitTerritories, moveMap, unitMoveMap, transportMoveMap, ProMatches.territoryHasNoEnemyUnitsOrCleared(player, data, clearedTerritories), clearedTerritories, false, false);
        this.findLandMoveOptions(player, myUnitTerritories, moveMap, unitMoveMap, landRoutesMap, Matches.isTerritoryAllied(player, data), new ArrayList<Territory>(), false, false, false);
        this.findAirMoveOptions(player, myUnitTerritories, moveMap, unitMoveMap, ProMatches.territoryIsNotConqueredAlliedLand(player, data), new ArrayList<Territory>(), false, false, false);
        this.findAmphibMoveOptions(player, myUnitTerritories, moveMap, transportMapList, landRoutesMap, Matches.isTerritoryAllied(player, data), new ArrayList<Territory>(), false, false, false);
    }

    public void findMaxEnemyAttackUnits(PlayerID player, List<Territory> myConqueredTerritories, List<Territory> territoriesToCheck, Map<Territory, ProAttackTerritoryData> enemyAttackMap) {
        GameData data = this.ai.getGameData();
        ArrayList<HashMap<Territory, ProAttackTerritoryData>> enemyAttackMaps = new ArrayList<HashMap<Territory, ProAttackTerritoryData>>();
        ArrayList<ArrayList<ProAmphibData>> enemyTransportMapLists = new ArrayList<ArrayList<ProAmphibData>>();
        List<PlayerID> enemyPlayers = this.utils.getEnemyPlayers(player);
        List<Territory> allTerritories = data.getMap().getTerritories();
        for (PlayerID playerID : enemyPlayers) {
            List<Territory> enemyUnitTerritories = Match.getMatches(allTerritories, Matches.territoryHasUnitsOwnedBy(playerID));
            enemyUnitTerritories.removeAll(myConqueredTerritories);
            HashMap<Territory, ProAttackTerritoryData> attackMap2 = new HashMap<Territory, ProAttackTerritoryData>();
            HashMap<Unit, Set<Territory>> unitAttackMap2 = new HashMap<Unit, Set<Territory>>();
            HashMap<Unit, Set<Territory>> transportAttackMap2 = new HashMap<Unit, Set<Territory>>();
            HashMap<Unit, Set<Territory>> bombardMap2 = new HashMap<Unit, Set<Territory>>();
            ArrayList<ProAmphibData> transportMapList2 = new ArrayList<ProAmphibData>();
            HashMap<Territory, Set<Territory>> landRoutesMap2 = new HashMap<Territory, Set<Territory>>();
            enemyAttackMaps.add(attackMap2);
            enemyTransportMapLists.add(transportMapList2);
            this.findAttackOptions(playerID, enemyUnitTerritories, attackMap2, unitAttackMap2, transportAttackMap2, bombardMap2, landRoutesMap2, transportMapList2, myConqueredTerritories, territoriesToCheck, true, true);
        }
        for (Map map : enemyAttackMaps) {
            for (Territory t : map.keySet()) {
                if (!enemyAttackMap.containsKey(t)) {
                    enemyAttackMap.put(t, (ProAttackTerritoryData)map.get(t));
                    continue;
                }
                HashSet<Unit> maxUnits = new HashSet<Unit>(enemyAttackMap.get(t).getMaxUnits());
                maxUnits.addAll(enemyAttackMap.get(t).getMaxAmphibUnits());
                double maxStrength = 0.0;
                if (!maxUnits.isEmpty()) {
                    maxStrength = this.battleUtils.estimateStrength(((Unit)maxUnits.iterator().next()).getOwner(), t, new ArrayList<Unit>(maxUnits), new ArrayList<Unit>(), true);
                }
                HashSet<Unit> currentUnits = new HashSet<Unit>(((ProAttackTerritoryData)map.get(t)).getMaxUnits());
                currentUnits.addAll(((ProAttackTerritoryData)map.get(t)).getMaxAmphibUnits());
                double currentStrength = 0.0;
                if (!currentUnits.isEmpty()) {
                    currentStrength = this.battleUtils.estimateStrength(((Unit)currentUnits.iterator().next()).getOwner(), t, new ArrayList<Unit>(currentUnits), new ArrayList<Unit>(), true);
                }
                boolean currentHasLandUnits = Match.someMatch(currentUnits, Matches.UnitIsLand);
                boolean maxHasLandUnits = Match.someMatch(maxUnits, Matches.UnitIsLand);
                if (!(currentHasLandUnits && (!maxHasLandUnits && !t.isWater() || currentStrength > maxStrength)) && (maxHasLandUnits && !t.isWater() || !(currentStrength > maxStrength))) continue;
                enemyAttackMap.put(t, (ProAttackTerritoryData)map.get(t));
            }
        }
    }

    private void findNavalMoveOptions(PlayerID player, List<Territory> myUnitTerritories, Map<Territory, ProAttackTerritoryData> moveMap, Map<Unit, Set<Territory>> unitMoveMap, Map<Unit, Set<Territory>> transportMoveMap, Match<Territory> moveToTerritoryMatch, List<Territory> enemyTerritories, boolean isCombatMove, boolean isCheckingEnemyAttacks) {
        GameData data = this.ai.getGameData();
        for (Territory myUnitTerritory : myUnitTerritories) {
            List<Unit> mySeaUnits = myUnitTerritory.getUnits().getMatches(ProMatches.unitCanBeMovedAndIsOwnedSea(player, isCombatMove));
            for (Unit mySeaUnit : mySeaUnits) {
                Map<Unit, Collection<Unit>> carrierMustMoveWith;
                if (isCombatMove && !isCheckingEnemyAttacks && (carrierMustMoveWith = MoveValidator.carrierMustMoveWith(myUnitTerritory.getUnits().getUnits(), myUnitTerritory, data, player)).containsKey(mySeaUnit) && !carrierMustMoveWith.get(mySeaUnit).isEmpty()) continue;
                int range = TripleAUnit.get(mySeaUnit).getMovementLeft();
                if (isCheckingEnemyAttacks) {
                    range = UnitAttachment.get(mySeaUnit.getType()).getMovement(player);
                    if (Matches.UnitCanBeGivenBonusMovementByFacilitiesInItsTerritory(myUnitTerritory, player, data).match(mySeaUnit)) {
                        ++range;
                    }
                }
                Set<Territory> possibleMoveTerritories = data.getMap().getNeighbors(myUnitTerritory, range, ProMatches.territoryCanMoveSeaUnits(player, data, isCombatMove));
                possibleMoveTerritories.add(myUnitTerritory);
                HashSet<Territory> potentialTerritories = new HashSet<Territory>(Match.getMatches(possibleMoveTerritories, moveToTerritoryMatch));
                if (!isCombatMove) {
                    potentialTerritories.add(myUnitTerritory);
                }
                for (Territory potentialTerritory : potentialTerritories) {
                    HashSet<Territory> unitMoveTerritories;
                    boolean hasNoRoute;
                    block15: {
                        Route myRoute;
                        hasNoRoute = true;
                        ArrayList<Territory> eliminatedTerritories = new ArrayList<Territory>();
                        while (true) {
                            myRoute = data.getMap().getRoute_IgnoreEnd(myUnitTerritory, potentialTerritory, ProMatches.territoryCanMoveSeaUnitsThroughOrClearedAndNotInList(player, data, isCombatMove, enemyTerritories, eliminatedTerritories));
                            if (isCheckingEnemyAttacks) {
                                myRoute = data.getMap().getRoute_IgnoreEnd(myUnitTerritory, potentialTerritory, ProMatches.territoryCanMoveSeaUnitsAndNotInList(player, data, isCombatMove, eliminatedTerritories));
                            }
                            if (myRoute == null) break block15;
                            if (MoveValidator.validateCanal(myRoute, Collections.singletonList(mySeaUnit), player, data) == null) break;
                            if (!myRoute.getMiddleSteps().isEmpty()) {
                                eliminatedTerritories.addAll(myRoute.getMiddleSteps());
                                continue;
                            }
                            break block15;
                            break;
                        }
                        int myRouteLength = myRoute.numberOfSteps();
                        if (myRouteLength <= range) {
                            hasNoRoute = false;
                        }
                    }
                    if (hasNoRoute) continue;
                    if (moveMap.containsKey(potentialTerritory)) {
                        moveMap.get(potentialTerritory).addMaxUnit(mySeaUnit);
                    } else {
                        ProAttackTerritoryData moveTerritoryData = new ProAttackTerritoryData(potentialTerritory);
                        moveTerritoryData.addMaxUnit(mySeaUnit);
                        moveMap.put(potentialTerritory, moveTerritoryData);
                    }
                    if (Matches.UnitIsTransport.match(mySeaUnit)) {
                        if (transportMoveMap.containsKey(mySeaUnit)) {
                            transportMoveMap.get(mySeaUnit).add(potentialTerritory);
                            continue;
                        }
                        unitMoveTerritories = new HashSet<Territory>();
                        unitMoveTerritories.add(potentialTerritory);
                        transportMoveMap.put(mySeaUnit, unitMoveTerritories);
                        continue;
                    }
                    if (unitMoveMap.containsKey(mySeaUnit)) {
                        unitMoveMap.get(mySeaUnit).add(potentialTerritory);
                        continue;
                    }
                    unitMoveTerritories = new HashSet();
                    unitMoveTerritories.add(potentialTerritory);
                    unitMoveMap.put(mySeaUnit, unitMoveTerritories);
                }
            }
        }
    }

    private void findLandMoveOptions(PlayerID player, List<Territory> myUnitTerritories, Map<Territory, ProAttackTerritoryData> moveMap, Map<Unit, Set<Territory>> unitMoveMap, Map<Territory, Set<Territory>> landRoutesMap, Match<Territory> moveToTerritoryMatch, List<Territory> enemyTerritories, boolean isCombatMove, boolean isCheckingEnemyAttacks, boolean isIgnoringRelationships) {
        GameData data = this.ai.getGameData();
        Map<Unit, Territory> unitTerritoryMap = this.utils.createUnitTerritoryMap(player);
        for (Territory myUnitTerritory : myUnitTerritories) {
            List<Unit> myLandUnits = myUnitTerritory.getUnits().getMatches(ProMatches.unitCanBeMovedAndIsOwnedLand(player, isCombatMove));
            for (Unit myLandUnit : myLandUnits) {
                Territory startTerritory = unitTerritoryMap.get(myLandUnit);
                int range = TripleAUnit.get(myLandUnit).getMovementLeft();
                Set<Territory> possibleMoveTerritories = data.getMap().getNeighbors(myUnitTerritory, range, ProMatches.territoryCanMoveSpecificLandUnit(player, data, isCombatMove, myLandUnit));
                if (isIgnoringRelationships) {
                    possibleMoveTerritories = data.getMap().getNeighbors(myUnitTerritory, range, ProMatches.territoryCanPotentiallyMoveSpecificLandUnit(player, data, isCombatMove, myLandUnit));
                }
                possibleMoveTerritories.add(myUnitTerritory);
                HashSet<Territory> potentialTerritories = new HashSet<Territory>(Match.getMatches(possibleMoveTerritories, moveToTerritoryMatch));
                if (!isCombatMove) {
                    potentialTerritories.add(myUnitTerritory);
                }
                for (Territory potentialTerritory : potentialTerritories) {
                    int myRouteLength;
                    Route myRoute = data.getMap().getRoute_IgnoreEnd(myUnitTerritory, potentialTerritory, ProMatches.territoryCanMoveLandUnitsThrough(player, data, myLandUnit, startTerritory, isCombatMove, enemyTerritories));
                    if (isCheckingEnemyAttacks) {
                        myRoute = data.getMap().getRoute_IgnoreEnd(myUnitTerritory, potentialTerritory, ProMatches.territoryCanMoveLandUnitsThroughIgnoreEnemyUnits(player, data, myLandUnit, startTerritory, isCombatMove, enemyTerritories));
                    }
                    if (myRoute == null || myRoute.hasMoreThenOneStep() && Match.someMatch(myRoute.getMiddleSteps(), Matches.isTerritoryEnemy(player, data)) && Matches.unitIsOfTypes(TerritoryEffectHelper.getUnitTypesThatLostBlitz(myRoute.getAllTerritories())).match(myLandUnit) || (myRouteLength = myRoute.numberOfSteps()) > range) continue;
                    if (landRoutesMap.containsKey(potentialTerritory)) {
                        landRoutesMap.get(potentialTerritory).add(myUnitTerritory);
                    } else {
                        HashSet<Territory> territories = new HashSet<Territory>();
                        territories.add(myUnitTerritory);
                        landRoutesMap.put(potentialTerritory, territories);
                    }
                    if (moveMap.containsKey(potentialTerritory)) {
                        moveMap.get(potentialTerritory).addMaxUnit(myLandUnit);
                    } else {
                        ProAttackTerritoryData moveTerritoryData = new ProAttackTerritoryData(potentialTerritory);
                        moveTerritoryData.addMaxUnit(myLandUnit);
                        moveMap.put(potentialTerritory, moveTerritoryData);
                    }
                    if (unitMoveMap.containsKey(myLandUnit)) {
                        unitMoveMap.get(myLandUnit).add(potentialTerritory);
                        continue;
                    }
                    HashSet<Territory> unitMoveTerritories = new HashSet<Territory>();
                    unitMoveTerritories.add(potentialTerritory);
                    unitMoveMap.put(myLandUnit, unitMoveTerritories);
                }
            }
        }
    }

    private void findAirMoveOptions(PlayerID player, List<Territory> myUnitTerritories, Map<Territory, ProAttackTerritoryData> moveMap, Map<Unit, Set<Territory>> unitMoveMap, Match<Territory> moveToTerritoryMatch, List<Territory> enemyTerritories, boolean isCombatMove, boolean isCheckingEnemyAttacks, boolean isIgnoringRelationships) {
        GameData data = this.ai.getGameData();
        HashSet<Territory> possibleCarrierTerritories = new HashSet<Territory>();
        if (isCheckingEnemyAttacks || !isCombatMove) {
            HashMap<Unit, Set<Territory>> unitMoveMap2 = new HashMap<Unit, Set<Territory>>();
            this.findNavalMoveOptions(player, myUnitTerritories, new HashMap<Territory, ProAttackTerritoryData>(), unitMoveMap2, new HashMap<Unit, Set<Territory>>(), Matches.TerritoryIsWater, enemyTerritories, false, true);
            for (Unit u : unitMoveMap2.keySet()) {
                if (!Matches.UnitIsCarrier.match(u)) continue;
                possibleCarrierTerritories.addAll((Collection)unitMoveMap2.get(u));
            }
            for (Territory t : data.getMap().getTerritories()) {
                if (!t.getUnits().someMatch(Matches.UnitIsAlliedCarrier(player, data))) continue;
                possibleCarrierTerritories.add(t);
            }
        }
        for (Territory myUnitTerritory : myUnitTerritories) {
            List<Unit> myAirUnits = myUnitTerritory.getUnits().getMatches(ProMatches.unitCanBeMovedAndIsOwnedAir(player, isCombatMove));
            for (Unit myAirUnit : myAirUnits) {
                int range = TripleAUnit.get(myAirUnit).getMovementLeft();
                if (isCheckingEnemyAttacks) {
                    range = UnitAttachment.get(myAirUnit.getType()).getMovement(player);
                    if (Matches.UnitCanBeGivenBonusMovementByFacilitiesInItsTerritory(myUnitTerritory, player, data).match(myAirUnit)) {
                        ++range;
                    }
                }
                Set<Territory> possibleMoveTerritories = data.getMap().getNeighbors(myUnitTerritory, range, ProMatches.territoryCanMoveAirUnits(player, data, isCombatMove));
                if (isIgnoringRelationships) {
                    possibleMoveTerritories = data.getMap().getNeighbors(myUnitTerritory, range, ProMatches.territoryCanPotentiallyMoveAirUnits(player, data, isCombatMove));
                }
                possibleMoveTerritories.add(myUnitTerritory);
                HashSet<Territory> potentialTerritories = new HashSet<Territory>(Match.getMatches(possibleMoveTerritories, moveToTerritoryMatch));
                if (!isCombatMove && Matches.UnitCanLandOnCarrier.match(myAirUnit)) {
                    potentialTerritories.addAll(Match.getMatches(possibleMoveTerritories, Matches.territoryIsInList(possibleCarrierTerritories)));
                }
                for (Territory potentialTerritory : potentialTerritories) {
                    int myRouteLength;
                    int remainingMoves;
                    Route myRoute;
                    Match<Territory> canFlyOverMatch = ProMatches.territoryCanMoveAirUnitsAndNoAA(player, data, isCombatMove);
                    if (isCheckingEnemyAttacks) {
                        canFlyOverMatch = ProMatches.territoryCanMoveAirUnits(player, data, isCombatMove);
                    }
                    if ((myRoute = data.getMap().getRoute_IgnoreEnd(myUnitTerritory, potentialTerritory, canFlyOverMatch)) == null || (remainingMoves = range - (myRouteLength = myRoute.numberOfSteps())) < 0) continue;
                    if (isCombatMove && (remainingMoves < myRouteLength || myUnitTerritory.isWater())) {
                        Set<Territory> possibleLandingTerritories = data.getMap().getNeighbors(potentialTerritory, remainingMoves, canFlyOverMatch);
                        List<Territory> landingTerritories = Match.getMatches(possibleLandingTerritories, ProMatches.territoryCanLandAirUnits(player, data, isCombatMove, enemyTerritories));
                        List<Object> carrierTerritories = new ArrayList();
                        if (Matches.UnitCanLandOnCarrier.match(myAirUnit)) {
                            carrierTerritories = Match.getMatches(possibleLandingTerritories, Matches.territoryIsInList(possibleCarrierTerritories));
                        }
                        if (landingTerritories.isEmpty() && carrierTerritories.isEmpty()) continue;
                    }
                    if (moveMap.containsKey(potentialTerritory)) {
                        moveMap.get(potentialTerritory).addMaxUnit(myAirUnit);
                    } else {
                        ProAttackTerritoryData moveTerritoryData = new ProAttackTerritoryData(potentialTerritory);
                        moveTerritoryData.addMaxUnit(myAirUnit);
                        moveMap.put(potentialTerritory, moveTerritoryData);
                    }
                    if (unitMoveMap.containsKey(myAirUnit)) {
                        unitMoveMap.get(myAirUnit).add(potentialTerritory);
                        continue;
                    }
                    HashSet<Territory> unitMoveTerritories = new HashSet<Territory>();
                    unitMoveTerritories.add(potentialTerritory);
                    unitMoveMap.put(myAirUnit, unitMoveTerritories);
                }
            }
        }
    }

    private void findAmphibMoveOptions(PlayerID player, List<Territory> myUnitTerritories, Map<Territory, ProAttackTerritoryData> moveMap, List<ProAmphibData> transportMapList, Map<Territory, Set<Territory>> landRoutesMap, Match<Territory> moveAmphibToTerritoryMatch, List<Territory> enemyTerritories, boolean isCombatMove, boolean isCheckingEnemyAttacks, boolean isIgnoringRelationships) {
        Map<Territory, Set<Territory>> transportMap;
        GameData data = this.ai.getGameData();
        for (Territory myUnitTerritory : myUnitTerritories) {
            List<Unit> myTransportUnits = myUnitTerritory.getUnits().getMatches(ProMatches.unitCanBeMovedAndIsOwnedTransport(player, isCombatMove));
            CompositeMatchAnd<Territory> unloadAmphibTerritoryMatch = new CompositeMatchAnd<Territory>(ProMatches.territoryCanMoveLandUnits(player, data, isCombatMove), moveAmphibToTerritoryMatch);
            if (isIgnoringRelationships) {
                unloadAmphibTerritoryMatch = new CompositeMatchAnd(ProMatches.territoryCanPotentiallyMoveLandUnits(player, data, isCombatMove), moveAmphibToTerritoryMatch);
            }
            for (Unit myTransportUnit : myTransportUnits) {
                int movesLeft = TripleAUnit.get(myTransportUnit).getMovementLeft();
                if (isCheckingEnemyAttacks) {
                    movesLeft = UnitAttachment.get(myTransportUnit.getType()).getMovement(player);
                    if (Matches.UnitCanBeGivenBonusMovementByFacilitiesInItsTerritory(myUnitTerritory, player, data).match(myTransportUnit)) {
                        ++movesLeft;
                    }
                }
                ProAmphibData proTransportData = new ProAmphibData(myTransportUnit);
                transportMapList.add(proTransportData);
                HashSet<Territory> currentTerritories = new HashSet<Territory>();
                currentTerritories.add(myUnitTerritory);
                while (movesLeft >= 0) {
                    HashSet<Territory> nextTerritories = new HashSet<Territory>();
                    for (Territory currentTerritory : currentTerritories) {
                        Set<Territory> possibleNeighborTerritories = data.getMap().getNeighbors(currentTerritory, ProMatches.territoryCanMoveSeaUnitsThrough(player, data, isCombatMove));
                        for (Territory possibleNeighborTerritory : possibleNeighborTerritories) {
                            if (MoveValidator.validateCanal(new Route(currentTerritory, possibleNeighborTerritory), Collections.singletonList(myTransportUnit), player, data) != null) continue;
                            nextTerritories.add(possibleNeighborTerritory);
                        }
                        ArrayList<Unit> units = new ArrayList<Unit>();
                        HashSet<Territory> myUnitsToLoadTerritories = new HashSet<Territory>();
                        if (TransportTracker.isTransporting(myTransportUnit)) {
                            units.addAll(TransportTracker.transporting(myTransportUnit));
                        } else if (Matches.territoryHasEnemySeaUnits(player, data).invert().match(currentTerritory)) {
                            Set<Territory> possibleLoadTerritories = data.getMap().getNeighbors(currentTerritory);
                            for (Territory possibleLoadTerritory : possibleLoadTerritories) {
                                List<Unit> possibleUnits = possibleLoadTerritory.getUnits().getMatches(ProMatches.unitIsOwnedTransportableUnitAndCanBeLoaded(player, isCombatMove));
                                if (isCheckingEnemyAttacks) {
                                    possibleUnits = possibleLoadTerritory.getUnits().getMatches(ProMatches.unitIsOwnedCombatTransportableUnit(player));
                                }
                                for (Unit possibleUnit : possibleUnits) {
                                    if (UnitAttachment.get(possibleUnit.getType()).getTransportCost() > UnitAttachment.get(myTransportUnit.getType()).getTransportCapacity()) continue;
                                    units.add(possibleUnit);
                                    myUnitsToLoadTerritories.add(possibleLoadTerritory);
                                }
                            }
                        }
                        if (units.isEmpty()) continue;
                        HashSet<Territory> seaMoveTerritories = new HashSet<Territory>();
                        seaMoveTerritories.add(currentTerritory);
                        if (movesLeft > 0) {
                            Set<Territory> neighborTerritories = data.getMap().getNeighbors(currentTerritory, movesLeft, ProMatches.territoryCanMoveSeaUnitsThrough(player, data, isCombatMove));
                            if (isCheckingEnemyAttacks) {
                                neighborTerritories = data.getMap().getNeighbors(currentTerritory, movesLeft, ProMatches.territoryCanMoveSeaUnits(player, data, isCombatMove));
                            }
                            for (Territory neighborTerritory : neighborTerritories) {
                                Route myRoute = data.getMap().getRoute_IgnoreEnd(currentTerritory, neighborTerritory, ProMatches.territoryCanMoveSeaUnitsThrough(player, data, isCombatMove));
                                if (myRoute == null || MoveValidator.validateCanal(myRoute, Collections.singletonList(myTransportUnit), player, data) != null) continue;
                                seaMoveTerritories.add(neighborTerritory);
                            }
                        }
                        HashSet<Territory> amphibTerritories = new HashSet<Territory>();
                        for (Territory seaMoveTerritory : seaMoveTerritories) {
                            amphibTerritories.addAll(data.getMap().getNeighbors(seaMoveTerritory, unloadAmphibTerritoryMatch));
                        }
                        proTransportData.addTerritories(amphibTerritories, myUnitsToLoadTerritories);
                        proTransportData.addSeaTerritories(seaMoveTerritories, myUnitsToLoadTerritories, data);
                    }
                    currentTerritories.clear();
                    currentTerritories.addAll(nextTerritories);
                    --movesLeft;
                }
            }
        }
        for (ProAmphibData proTransportData : transportMapList) {
            transportMap = proTransportData.getTransportMap();
            ArrayList<Territory> transportTerritoriesToRemove = new ArrayList<Territory>();
            for (Territory t : transportMap.keySet()) {
                Set<Territory> transportMoveTerritories = transportMap.get(t);
                Set<Territory> landMoveTerritories = landRoutesMap.get(t);
                if (landMoveTerritories == null) continue;
                transportMoveTerritories.removeAll(landMoveTerritories);
                if (!transportMoveTerritories.isEmpty()) continue;
                transportTerritoriesToRemove.add(t);
            }
            for (Territory t : transportTerritoriesToRemove) {
                transportMap.remove(t);
            }
        }
        for (ProAmphibData proTransportData : transportMapList) {
            transportMap = proTransportData.getTransportMap();
            Unit transport = proTransportData.getTransport();
            for (Territory moveTerritory : transportMap.keySet()) {
                Set<Territory> territoriesCanLoadFrom = transportMap.get(moveTerritory);
                ArrayList<Unit> alreadyAddedToMaxAmphibUnits = new ArrayList();
                if (moveMap.containsKey(moveTerritory)) {
                    alreadyAddedToMaxAmphibUnits = moveMap.get(moveTerritory).getMaxAmphibUnits();
                }
                List<Unit> amphibUnits = this.transportUtils.getUnitsToTransportFromTerritories(player, transport, territoriesCanLoadFrom, alreadyAddedToMaxAmphibUnits);
                if (isCheckingEnemyAttacks) {
                    amphibUnits = this.transportUtils.getUnitsToTransportFromTerritories(player, transport, territoriesCanLoadFrom, alreadyAddedToMaxAmphibUnits, ProMatches.unitIsOwnedCombatTransportableUnit(player));
                }
                if (moveMap.containsKey(moveTerritory)) {
                    moveMap.get(moveTerritory).addMaxAmphibUnits(amphibUnits);
                    continue;
                }
                ProAttackTerritoryData moveTerritoryData = new ProAttackTerritoryData(moveTerritory);
                moveTerritoryData.addMaxAmphibUnits(amphibUnits);
                moveMap.put(moveTerritory, moveTerritoryData);
            }
        }
    }

    private void findBombardOptions(PlayerID player, List<Territory> myUnitTerritories, Map<Territory, ProAttackTerritoryData> moveMap, Map<Unit, Set<Territory>> bombardMap, List<ProAmphibData> transportMapList, boolean isCheckingEnemyAttacks) {
        GameData data = this.ai.getGameData();
        HashSet<Territory> unloadFromTerritories = new HashSet<Territory>();
        HashSet<Territory> unloadToTerritories = new HashSet<Territory>();
        for (ProAmphibData amphibData : transportMapList) {
            unloadFromTerritories.addAll(amphibData.getSeaTransportMap().keySet());
            unloadToTerritories.addAll(amphibData.getTransportMap().keySet());
        }
        for (Territory myUnitTerritory : myUnitTerritories) {
            List<Unit> mySeaUnits = myUnitTerritory.getUnits().getMatches(ProMatches.unitCanBeMovedAndIsOwnedBombard(player));
            for (Unit mySeaUnit : mySeaUnits) {
                int range = TripleAUnit.get(mySeaUnit).getMovementLeft();
                if (isCheckingEnemyAttacks) {
                    range = UnitAttachment.get(mySeaUnit.getType()).getMovement(player);
                    if (Matches.UnitCanBeGivenBonusMovementByFacilitiesInItsTerritory(myUnitTerritory, player, data).match(mySeaUnit)) {
                        ++range;
                    }
                }
                Set<Territory> potentialTerritories = data.getMap().getNeighbors(myUnitTerritory, range, ProMatches.territoryCanMoveSeaUnits(player, data, true));
                potentialTerritories.add(myUnitTerritory);
                potentialTerritories.retainAll(unloadFromTerritories);
                for (Territory bombardFromTerritory : potentialTerritories) {
                    int myRouteLength;
                    Route myRoute = data.getMap().getRoute(myUnitTerritory, bombardFromTerritory, ProMatches.territoryCanMoveSeaUnitsThrough(player, data, true));
                    if (isCheckingEnemyAttacks) {
                        myRoute = data.getMap().getRoute(myUnitTerritory, bombardFromTerritory, ProMatches.territoryCanMoveSeaUnits(player, data, true));
                    }
                    if (myRoute == null || MoveValidator.validateCanal(myRoute, Collections.singletonList(mySeaUnit), player, data) != null || (myRouteLength = myRoute.numberOfSteps()) > range) continue;
                    HashSet<Territory> bombardToTerritories = new HashSet<Territory>(data.getMap().getNeighbors(bombardFromTerritory));
                    bombardToTerritories.retainAll(unloadToTerritories);
                    for (Territory bombardToTerritory : bombardToTerritories) {
                        if (!moveMap.containsKey(bombardToTerritory)) continue;
                        moveMap.get(bombardToTerritory).addMaxBombardUnit(mySeaUnit);
                        moveMap.get(bombardToTerritory).addBombardOptionsMap(mySeaUnit, bombardFromTerritory);
                    }
                    if (bombardMap.containsKey(mySeaUnit)) {
                        bombardMap.get(mySeaUnit).addAll(bombardToTerritories);
                        continue;
                    }
                    bombardMap.put(mySeaUnit, bombardToTerritories);
                }
            }
        }
    }

    public List<ProAttackTerritoryData> removeTerritoriesThatCantBeConquered(PlayerID player, Map<Territory, ProAttackTerritoryData> attackMap, Map<Unit, Set<Territory>> unitAttackMap, Map<Unit, Set<Territory>> transportAttackMap, boolean isIgnoringRelationships) {
        ProAttackTerritoryData patd;
        LogUtils.log(Level.FINE, "Removing territories that can't be conquered");
        GameData data = this.ai.getGameData();
        if (!Properties.getLow_Luck(data)) {
            WIN_PERCENTAGE = 90.0;
            MIN_WIN_PERCENTAGE = 65.0;
        }
        ArrayList<Territory> territoriesToRemove = new ArrayList<Territory>();
        for (Territory t : attackMap.keySet()) {
            patd = attackMap.get(t);
            List<Unit> defenders = Match.getMatches(patd.getMaxEnemyDefenders(player, data), ProMatches.unitIsEnemyAndNotAA(player, data));
            if (isIgnoringRelationships) {
                defenders = new ArrayList<Unit>(t.getUnits().getUnits());
            }
            patd.setMaxBattleResult(this.battleUtils.estimateAttackBattleResults(player, t, patd.getMaxUnits(), defenders, new HashSet<Unit>()));
            if (patd.getMaxBattleResult().getWinPercentage() < WIN_PERCENTAGE && !patd.getMaxAmphibUnits().isEmpty()) {
                HashSet<Unit> combinedUnits = new HashSet<Unit>(patd.getMaxUnits());
                combinedUnits.addAll(patd.getMaxAmphibUnits());
                patd.setMaxBattleResult(this.battleUtils.estimateAttackBattleResults(player, t, new ArrayList<Unit>(combinedUnits), defenders, patd.getMaxBombardUnits()));
                patd.setNeedAmphibUnits(true);
            }
            if (!(patd.getMaxBattleResult().getWinPercentage() < MIN_WIN_PERCENTAGE)) continue;
            territoriesToRemove.add(t);
        }
        Collections.sort(territoriesToRemove);
        for (Territory t : territoriesToRemove) {
            patd = attackMap.get(t);
            HashSet<Unit> combinedUnits = new HashSet<Unit>(patd.getMaxUnits());
            combinedUnits.addAll(patd.getMaxAmphibUnits());
            LogUtils.log(Level.FINER, "Removing territory that we can't successfully attack: " + t + ", maxWin%=" + patd.getMaxBattleResult().getWinPercentage() + ", maxAttackers=" + combinedUnits.size());
            attackMap.remove(t);
            for (Set<Territory> territories : unitAttackMap.values()) {
                territories.remove(t);
            }
            for (Set<Territory> territories : transportAttackMap.values()) {
                territories.remove(t);
            }
        }
        return new ArrayList<ProAttackTerritoryData>(attackMap.values());
    }
}

