/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.proAI.util;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.Properties;
import games.strategy.triplea.ai.proAI.ProAI;
import games.strategy.triplea.ai.proAI.ProAttackTerritoryData;
import games.strategy.triplea.ai.proAI.ProBattleResultData;
import games.strategy.triplea.ai.proAI.ProPlaceTerritory;
import games.strategy.triplea.ai.proAI.ProPurchaseTerritory;
import games.strategy.triplea.ai.proAI.util.LogUtils;
import games.strategy.triplea.ai.proAI.util.ProMatches;
import games.strategy.triplea.ai.proAI.util.ProPurchaseUtils;
import games.strategy.triplea.ai.proAI.util.ProUtils;
import games.strategy.triplea.delegate.BattleCalculator;
import games.strategy.triplea.delegate.DiceRoll;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.MoveValidator;
import games.strategy.triplea.delegate.TerritoryEffectHelper;
import games.strategy.triplea.delegate.UnitBattleComparator;
import games.strategy.triplea.oddsCalculator.ta.AggregateResults;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class ProBattleUtils {
    private final ProAI ai;
    private final ProUtils utils;

    public ProBattleUtils(ProAI proAI, ProUtils utils) {
        this.ai = proAI;
        this.utils = utils;
    }

    public boolean checkForOverwhelmingWin(PlayerID player, Territory t, List<Unit> attackingUnits, List<Unit> defendingUnits) {
        GameData data = this.ai.getGameData();
        if (defendingUnits.isEmpty() && !attackingUnits.isEmpty()) {
            return true;
        }
        double power = this.estimatePower(defendingUnits.get(0).getOwner(), t, defendingUnits, attackingUnits, false);
        if (power == 0.0 && !attackingUnits.isEmpty()) {
            return true;
        }
        IntegerMap<UnitType> playerCostMap = BattleCalculator.getCostsForTUV(player, data);
        ArrayList<Unit> sortedUnitsList = new ArrayList<Unit>(attackingUnits);
        Collections.sort(sortedUnitsList, new UnitBattleComparator(false, playerCostMap, TerritoryEffectHelper.getEffects(t), data, false, false));
        Collections.reverse(sortedUnitsList);
        int attackPower = DiceRoll.getTotalPowerAndRolls(DiceRoll.getUnitPowerAndRollsForNormalBattles(sortedUnitsList, sortedUnitsList, defendingUnits, false, false, player, data, t, TerritoryEffectHelper.getEffects(t), false, null), data).getFirst();
        List<Unit> defendersWithHitPoints = Match.getMatches(defendingUnits, Matches.UnitIsInfrastructure.invert());
        int totalDefenderHitPoints = BattleCalculator.getTotalHitpointsLeft(defendersWithHitPoints);
        return attackPower / data.getDiceSides() >= totalDefenderHitPoints;
    }

    public double estimateStrengthDifference(Territory t, List<Unit> attackingUnits, List<Unit> defendingUnits) {
        if (attackingUnits.size() == 0) {
            return 0.0;
        }
        List<Unit> actualDefenders = Match.getMatches(defendingUnits, Matches.UnitIsInfrastructure.invert());
        if (actualDefenders.size() == 0) {
            return 100.0;
        }
        double attackerStrength = this.estimateStrength(attackingUnits.get(0).getOwner(), t, attackingUnits, actualDefenders, true);
        double defenderStrength = this.estimateStrength(actualDefenders.get(0).getOwner(), t, actualDefenders, attackingUnits, false);
        return (attackerStrength - defenderStrength) / Math.pow(defenderStrength, 0.85) * 50.0 + 50.0;
    }

    public double estimateStrength(PlayerID player, Territory t, List<Unit> myUnits, List<Unit> enemyUnits, boolean attacking) {
        GameData data = this.ai.getGameData();
        List<Unit> unitsThatCanFight = Match.getMatches(myUnits, Matches.UnitCanBeInBattle(attacking, !t.isWater(), data, 1, false, true, true));
        if (Properties.getTransportCasualtiesRestricted(data)) {
            unitsThatCanFight = Match.getMatches(unitsThatCanFight, Matches.UnitIsTransportButNotCombatTransport.invert());
        }
        int myHP = BattleCalculator.getTotalHitpointsLeft(unitsThatCanFight);
        double myPower = this.estimatePower(player, t, myUnits, enemyUnits, attacking);
        return (double)(2 * myHP) + myPower;
    }

    private double estimatePower(PlayerID player, Territory t, List<Unit> myUnits, List<Unit> enemyUnits, boolean attacking) {
        GameData data = this.ai.getGameData();
        List<Unit> unitsThatCanFight = Match.getMatches(myUnits, Matches.UnitCanBeInBattle(attacking, !t.isWater(), data, 1, false, true, true));
        IntegerMap<UnitType> playerCostMap = BattleCalculator.getCostsForTUV(player, data);
        ArrayList<Unit> sortedUnitsList = new ArrayList<Unit>(unitsThatCanFight);
        Collections.sort(sortedUnitsList, new UnitBattleComparator(!attacking, playerCostMap, TerritoryEffectHelper.getEffects(t), data, false, false));
        Collections.reverse(sortedUnitsList);
        int myPower = DiceRoll.getTotalPowerAndRolls(DiceRoll.getUnitPowerAndRollsForNormalBattles(sortedUnitsList, sortedUnitsList, enemyUnits, !attacking, false, player, data, t, TerritoryEffectHelper.getEffects(t), false, null), data).getFirst();
        return (double)myPower * 6.0 / (double)data.getDiceSides();
    }

    public ProBattleResultData estimateAttackBattleResults(PlayerID player, Territory t, List<Unit> attackingUnits, List<Unit> defendingUnits, Set<Unit> bombardingUnits) {
        ProBattleResultData result = this.checkIfNoAttackersOrDefenders(t, attackingUnits, defendingUnits);
        if (result != null) {
            return result;
        }
        double strengthDifference = this.estimateStrengthDifference(t, attackingUnits, defendingUnits);
        if (strengthDifference < 45.0) {
            return new ProBattleResultData(0.0, -999.0, false, new ArrayList<Unit>(), 1.0);
        }
        return this.callBattleCalculator(player, t, attackingUnits, defendingUnits, bombardingUnits, true);
    }

    public ProBattleResultData estimateDefendBattleResults(PlayerID player, Territory t, List<Unit> attackingUnits, List<Unit> defendingUnits, Set<Unit> bombardingUnits) {
        ProBattleResultData result = this.checkIfNoAttackersOrDefenders(t, attackingUnits, defendingUnits);
        if (result != null) {
            return result;
        }
        double strengthDifference = this.estimateStrengthDifference(t, attackingUnits, defendingUnits);
        if (strengthDifference > 55.0) {
            boolean isLandAndCanOnlyBeAttackedByAir = !t.isWater() && Match.allMatch(attackingUnits, Matches.UnitIsAir);
            return new ProBattleResultData(100.0 + strengthDifference, 999.0 + strengthDifference, !isLandAndCanOnlyBeAttackedByAir, attackingUnits, 1.0);
        }
        return this.callBattleCalculator(player, t, attackingUnits, defendingUnits, bombardingUnits, false);
    }

    public ProBattleResultData calculateBattleResults(PlayerID player, Territory t, List<Unit> attackingUnits, List<Unit> defendingUnits, Set<Unit> bombardingUnits, boolean isAttacker) {
        ProBattleResultData result = this.checkIfNoAttackersOrDefenders(t, attackingUnits, defendingUnits);
        if (result != null) {
            return result;
        }
        return this.callBattleCalculator(player, t, attackingUnits, defendingUnits, bombardingUnits, isAttacker);
    }

    private ProBattleResultData checkIfNoAttackersOrDefenders(Territory t, List<Unit> attackingUnits, List<Unit> defendingUnits) {
        boolean isLandAndCanOnlyBeAttackedByAir;
        GameData data = this.ai.getGameData();
        boolean hasNoDefenders = Match.noneMatch(defendingUnits, Matches.UnitIsNotInfrastructure);
        boolean bl = isLandAndCanOnlyBeAttackedByAir = !t.isWater() && Match.allMatch(attackingUnits, Matches.UnitIsAir);
        if (attackingUnits.size() == 0) {
            return new ProBattleResultData();
        }
        if (hasNoDefenders && isLandAndCanOnlyBeAttackedByAir) {
            return new ProBattleResultData();
        }
        if (hasNoDefenders) {
            return new ProBattleResultData(100.0, 0.1, true, attackingUnits, 0.0);
        }
        if (Properties.getSubRetreatBeforeBattle(data) && Match.allMatch(defendingUnits, Matches.UnitIsSub) && Match.noneMatch(attackingUnits, Matches.UnitIsDestroyer)) {
            return new ProBattleResultData();
        }
        return null;
    }

    public ProBattleResultData callBattleCalculator(PlayerID player, Territory t, List<Unit> attackingUnits, List<Unit> defendingUnits, Set<Unit> bombardingUnits, boolean isAttacker) {
        if (this.ai.isGameStopped()) {
            return new ProBattleResultData();
        }
        GameData data = this.ai.getGameData();
        AggregateResults results = null;
        int minArmySize = Math.min(attackingUnits.size(), defendingUnits.size());
        int runCount = Math.max(16, 100 - minArmySize);
        results = isAttacker ? this.ai.getCalc().setCalculateDataAndCalculate(player, t.getOwner(), t, attackingUnits, defendingUnits, new ArrayList<Unit>(bombardingUnits), TerritoryEffectHelper.getEffects(t), runCount) : this.ai.getCalc().setCalculateDataAndCalculate(attackingUnits.get(0).getOwner(), player, t, attackingUnits, defendingUnits, new ArrayList<Unit>(bombardingUnits), TerritoryEffectHelper.getEffects(t), runCount);
        double winPercentage = results.getAttackerWinPercent() * 100.0;
        List<Unit> averageUnitsRemaining = results.GetAverageAttackingUnitsRemaining();
        List<Unit> mainCombatAttackers = Match.getMatches(attackingUnits, Matches.UnitCanBeInBattle(true, !t.isWater(), data, 1, false, true, true));
        List<Unit> mainCombatDefenders = Match.getMatches(defendingUnits, Matches.UnitCanBeInBattle(false, !t.isWater(), data, 1, false, true, true));
        double TUVswing = results.getAverageTUVswing(player, mainCombatAttackers, t.getOwner(), mainCombatDefenders, data);
        if (isAttacker && Matches.TerritoryIsNeutralButNotWater.match(t)) {
            IntegerMap<UnitType> playerCostMap = BattleCalculator.getCostsForTUV(player, data);
            double attackingUnitValue = BattleCalculator.getTUV(mainCombatAttackers, playerCostMap);
            double remainingUnitValue = results.getAverageTUVofUnitsLeftOver(playerCostMap, playerCostMap).getFirst();
            TUVswing = remainingUnitValue - attackingUnitValue;
        }
        List<Unit> defendingTransportedUnits = Match.getMatches(defendingUnits, Matches.unitIsBeingTransported());
        if (t.isWater() && !defendingTransportedUnits.isEmpty()) {
            IntegerMap<UnitType> playerCostMap = BattleCalculator.getCostsForTUV(player, data);
            double transportedUnitValue = BattleCalculator.getTUV(defendingTransportedUnits, playerCostMap);
            TUVswing += transportedUnitValue * winPercentage / 100.0;
        }
        ArrayList<Territory> tList = new ArrayList<Territory>();
        tList.add(t);
        if (Match.allMatch(tList, Matches.TerritoryIsLand)) {
            return new ProBattleResultData(winPercentage, TUVswing, Match.someMatch(averageUnitsRemaining, Matches.UnitIsLand), averageUnitsRemaining, results.getAverageBattleRoundsFought());
        }
        return new ProBattleResultData(winPercentage, TUVswing, !averageUnitsRemaining.isEmpty(), averageUnitsRemaining, results.getAverageBattleRoundsFought());
    }

    public boolean territoryHasLocalLandSuperiority(Territory t, int distance, PlayerID player) {
        return this.territoryHasLocalLandSuperiority(t, distance, player, new HashMap<Territory, ProPurchaseTerritory>());
    }

    public boolean territoryHasLocalLandSuperiority(Territory t, int distance, PlayerID player, Map<Territory, ProPurchaseTerritory> purchaseTerritories) {
        GameData data = this.ai.getGameData();
        if (t == null) {
            return true;
        }
        for (int i = 2; i <= distance; ++i) {
            Set<Territory> nearbyTerritoriesForEnemy = data.getMap().getNeighbors(t, i, ProMatches.territoryCanMoveLandUnits(player, data, false));
            nearbyTerritoriesForEnemy.add(t);
            ArrayList<Unit> enemyUnits = new ArrayList<Unit>();
            for (Territory nearbyTerritory : nearbyTerritoriesForEnemy) {
                enemyUnits.addAll(nearbyTerritory.getUnits().getMatches(ProMatches.unitIsEnemyNotNeutral(player, data)));
            }
            Set<Territory> nearbyTerritoriesForAllied = data.getMap().getNeighbors(t, i - 1, ProMatches.territoryCanMoveLandUnits(player, data, false));
            nearbyTerritoriesForAllied.add(t);
            ArrayList<Unit> alliedUnits = new ArrayList<Unit>();
            for (Territory nearbyTerritory : nearbyTerritoriesForAllied) {
                alliedUnits.addAll(nearbyTerritory.getUnits().getMatches(Matches.isUnitAllied(player, data)));
            }
            for (Territory purchaseTerritory : purchaseTerritories.keySet()) {
                for (ProPlaceTerritory ppt : purchaseTerritories.get(purchaseTerritory).getCanPlaceTerritories()) {
                    if (!nearbyTerritoriesForAllied.contains(ppt.getTerritory())) continue;
                    alliedUnits.addAll(ppt.getPlaceUnits());
                }
            }
            double strengthDifference = this.estimateStrengthDifference(t, enemyUnits, alliedUnits);
            LogUtils.log(Level.FINEST, t + ", current enemy land strengthDifference=" + strengthDifference + ", distance=" + i + ", enemySize=" + enemyUnits.size() + ", alliedSize=" + alliedUnits.size());
            if (!(strengthDifference > 50.0)) continue;
            return false;
        }
        return true;
    }

    public boolean territoryHasLocalLandSuperiorityAfterMoves(Territory t, int distance, PlayerID player, Map<Territory, ProAttackTerritoryData> moveMap) {
        GameData data = this.ai.getGameData();
        Set<Territory> nearbyTerritoriesForEnemy = data.getMap().getNeighbors(t, distance, ProMatches.territoryCanMoveLandUnits(player, data, false));
        nearbyTerritoriesForEnemy.add(t);
        ArrayList<Unit> enemyUnits = new ArrayList<Unit>();
        for (Territory nearbyTerritory : nearbyTerritoriesForEnemy) {
            enemyUnits.addAll(nearbyTerritory.getUnits().getMatches(ProMatches.unitIsEnemyNotNeutral(player, data)));
        }
        Set<Territory> nearbyTerritoriesForAllied = data.getMap().getNeighbors(t, distance - 1, ProMatches.territoryCanMoveLandUnits(player, data, false));
        nearbyTerritoriesForAllied.add(t);
        ArrayList<Unit> alliedUnits = new ArrayList<Unit>();
        for (Territory nearbyTerritory : nearbyTerritoriesForAllied) {
            if (moveMap.get(nearbyTerritory) == null) continue;
            alliedUnits.addAll(moveMap.get(nearbyTerritory).getAllDefenders());
        }
        double strengthDifference = this.estimateStrengthDifference(t, enemyUnits, alliedUnits);
        LogUtils.log(Level.FINEST, t + ", current enemy land strengthDifference=" + strengthDifference + ", enemySize=" + enemyUnits.size() + ", alliedSize=" + alliedUnits.size());
        return !(strengthDifference > 50.0);
    }

    public boolean territoryHasLocalNavalSuperiority(Territory t, PlayerID player, Map<Territory, ProPurchaseTerritory> purchaseTerritories, List<Unit> unitsToPlace) {
        GameData data = this.ai.getGameData();
        int landDistance = this.utils.getClosestEnemyLandTerritoryDistanceOverWater(data, player, t);
        if (landDistance <= 0) {
            landDistance = 10;
        }
        int enemyDistance = Math.max(3, landDistance + 1);
        int alliedDistance = (enemyDistance + 1) / 2;
        Set<Territory> nearbyTerritories = data.getMap().getNeighbors(t, enemyDistance);
        List<Territory> nearbyLandTerritories = Match.getMatches(nearbyTerritories, Matches.TerritoryIsLand);
        Set<Territory> nearbyEnemySeaTerritories = data.getMap().getNeighbors(t, enemyDistance, Matches.TerritoryIsWater);
        nearbyEnemySeaTerritories.add(t);
        Set<Territory> nearbyAlliedSeaTerritories = data.getMap().getNeighbors(t, alliedDistance, Matches.TerritoryIsWater);
        nearbyAlliedSeaTerritories.add(t);
        ArrayList<Unit> enemyUnitsInSeaTerritories = new ArrayList<Unit>();
        ArrayList<Unit> enemyUnitsInLandTerritories = new ArrayList<Unit>();
        ArrayList<Unit> myUnitsInSeaTerritories = new ArrayList<Unit>();
        ArrayList<Unit> alliedUnitsInSeaTerritories = new ArrayList<Unit>();
        for (Territory nearbyLandTerritory : nearbyLandTerritories) {
            enemyUnitsInLandTerritories.addAll(nearbyLandTerritory.getUnits().getMatches(ProMatches.unitIsEnemyAir(player, data)));
        }
        for (Territory nearbySeaTerritory : nearbyEnemySeaTerritories) {
            int routeLength;
            Route route;
            List<Unit> enemySeaUnits = nearbySeaTerritory.getUnits().getMatches(ProMatches.unitIsEnemyNotLand(player, data));
            if (enemySeaUnits.isEmpty() || (route = data.getMap().getRoute_IgnoreEnd(t, nearbySeaTerritory, Matches.TerritoryIsWater)) == null || MoveValidator.validateCanal(route, enemySeaUnits, enemySeaUnits.get(0).getOwner(), data) != null || (routeLength = route.numberOfSteps()) > enemyDistance) continue;
            enemyUnitsInSeaTerritories.addAll(enemySeaUnits);
        }
        for (Territory nearbySeaTerritory : nearbyAlliedSeaTerritories) {
            myUnitsInSeaTerritories.addAll(nearbySeaTerritory.getUnits().getMatches(ProMatches.unitIsOwnedNotLand(player, data)));
            myUnitsInSeaTerritories.addAll(ProPurchaseUtils.getPlaceUnits(nearbySeaTerritory, purchaseTerritories));
            alliedUnitsInSeaTerritories.addAll(nearbySeaTerritory.getUnits().getMatches(ProMatches.unitIsAlliedNotOwned(player, data)));
        }
        LogUtils.log(Level.FINEST, t + ", enemyDistance=" + enemyDistance + ", alliedDistance=" + alliedDistance + ", enemyAirUnits=" + enemyUnitsInLandTerritories + ", enemySeaUnits=" + enemyUnitsInSeaTerritories + ", mySeaUnits=" + myUnitsInSeaTerritories);
        ArrayList<Unit> myUnits = new ArrayList<Unit>(myUnitsInSeaTerritories);
        myUnits.addAll(unitsToPlace);
        myUnits.addAll(alliedUnitsInSeaTerritories);
        ArrayList<Unit> enemyAttackers = new ArrayList<Unit>(enemyUnitsInSeaTerritories);
        enemyAttackers.addAll(enemyUnitsInLandTerritories);
        double defenseStrengthDifference = this.estimateStrengthDifference(t, enemyAttackers, myUnits);
        LogUtils.log(Level.FINEST, t + ", current enemy naval attack strengthDifference=" + defenseStrengthDifference + ", enemySize=" + enemyAttackers.size() + ", alliedSize=" + myUnits.size());
        double attackStrengthDifference = this.estimateStrengthDifference(t, myUnits, enemyUnitsInSeaTerritories);
        LogUtils.log(Level.FINEST, t + ", current allied naval attack strengthDifference=" + (attackStrengthDifference += 0.5 * this.estimateStrengthDifference(t, alliedUnitsInSeaTerritories, enemyUnitsInSeaTerritories)) + ", alliedSize=" + myUnits.size() + ", enemySize=" + enemyUnitsInSeaTerritories.size());
        return defenseStrengthDifference < 50.0 && attackStrengthDifference > 50.0;
    }
}

