/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.proAI.util;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.Properties;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.AbstractMoveDelegate;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.TerritoryEffectHelper;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.CompositeMatchOr;
import games.strategy.util.Match;
import java.util.Collection;
import java.util.List;

public class ProMatches {
    public static Match<Territory> territoryCanLandAirUnits(final PlayerID player, final GameData data, final boolean isCombatMove, final List<Territory> enemyTerritories) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchAnd<Territory> match = new CompositeMatchAnd<Territory>(Matches.airCanLandOnThisAlliedNonConqueredLandTerritory(player, data), Matches.TerritoryIsPassableAndNotRestrictedAndOkByRelationships(player, data, isCombatMove, false, false, true, true), Matches.territoryIsInList(enemyTerritories).invert());
                return ((Match)match).match(t);
            }
        };
    }

    public static Match<Territory> territoryCanMoveAirUnits(final PlayerID player, final GameData data, final boolean isCombatMove) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchAnd<Territory> match = new CompositeMatchAnd<Territory>(Matches.territoryDoesNotCostMoneyToEnter(data), Matches.TerritoryIsPassableAndNotRestrictedAndOkByRelationships(player, data, isCombatMove, false, false, true, false));
                return ((Match)match).match(t);
            }
        };
    }

    public static Match<Territory> territoryCanPotentiallyMoveAirUnits(final PlayerID player, final GameData data, boolean isCombatMove) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchAnd<Territory> match = new CompositeMatchAnd<Territory>(Matches.territoryDoesNotCostMoneyToEnter(data), Matches.TerritoryIsPassableAndNotRestricted(player, data));
                return ((Match)match).match(t);
            }
        };
    }

    public static Match<Territory> territoryCanMoveAirUnitsAndNoAA(final PlayerID player, final GameData data, final boolean isCombatMove) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchAnd<Territory> match = new CompositeMatchAnd<Territory>(ProMatches.territoryCanMoveAirUnits(player, data, isCombatMove), Matches.territoryHasEnemyAAforAnything(player, data).invert());
                return ((Match)match).match(t);
            }
        };
    }

    public static Match<Territory> territoryCanMoveSpecificLandUnit(final PlayerID player, final GameData data, final boolean isCombatMove, final Unit u) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchAnd<Territory> territoryMatch = new CompositeMatchAnd<Territory>(Matches.territoryDoesNotCostMoneyToEnter(data), Matches.TerritoryIsPassableAndNotRestrictedAndOkByRelationships(player, data, isCombatMove, true, false, false, false));
                Match<Unit> unitMatch = Matches.unitIsOfTypes(TerritoryEffectHelper.getUnitTypesForUnitsNotAllowedIntoTerritory(t)).invert();
                return ((Match)territoryMatch).match(t) && unitMatch.match(u);
            }
        };
    }

    public static Match<Territory> territoryCanPotentiallyMoveSpecificLandUnit(final PlayerID player, final GameData data, boolean isCombatMove, final Unit u) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchAnd<Territory> territoryMatch = new CompositeMatchAnd<Territory>(Matches.territoryDoesNotCostMoneyToEnter(data), Matches.TerritoryIsPassableAndNotRestricted(player, data));
                Match<Unit> unitMatch = Matches.unitIsOfTypes(TerritoryEffectHelper.getUnitTypesForUnitsNotAllowedIntoTerritory(t)).invert();
                return ((Match)territoryMatch).match(t) && unitMatch.match(u);
            }
        };
    }

    public static Match<Territory> territoryCanMoveLandUnits(final PlayerID player, final GameData data, final boolean isCombatMove) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchAnd<Territory> match = new CompositeMatchAnd<Territory>(Matches.territoryDoesNotCostMoneyToEnter(data), Matches.TerritoryIsPassableAndNotRestrictedAndOkByRelationships(player, data, isCombatMove, true, false, false, false));
                return ((Match)match).match(t);
            }
        };
    }

    public static Match<Territory> territoryCanPotentiallyMoveLandUnits(final PlayerID player, final GameData data, boolean isCombatMove) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchAnd<Territory> match = new CompositeMatchAnd<Territory>(Matches.TerritoryIsLand, Matches.territoryDoesNotCostMoneyToEnter(data), Matches.TerritoryIsPassableAndNotRestricted(player, data));
                return ((Match)match).match(t);
            }
        };
    }

    public static Match<Territory> territoryCanMoveLandUnitsAndIsAllied(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchAnd<Territory> match = new CompositeMatchAnd<Territory>(Matches.isTerritoryAllied(player, data), ProMatches.territoryCanMoveLandUnits(player, data, false));
                return ((Match)match).match(t);
            }
        };
    }

    public static Match<Territory> territoryCanMoveLandUnitsAndIsEnemy(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchAnd<Territory> match = new CompositeMatchAnd<Territory>(Matches.isTerritoryEnemy(player, data), ProMatches.territoryCanMoveLandUnits(player, data, true));
                return ((Match)match).match(t);
            }
        };
    }

    public static Match<Territory> territoryCanMoveLandUnitsThrough(final PlayerID player, final GameData data, final Unit u, final Territory startTerritory, final boolean isCombatMove, final List<Territory> enemyTerritories) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchAnd<Territory> match = new CompositeMatchAnd<Territory>(ProMatches.territoryCanMoveSpecificLandUnit(player, data, isCombatMove, u), Matches.isTerritoryAllied(player, data), Matches.territoryHasNoEnemyUnits(player, data), Matches.territoryIsInList(enemyTerritories).invert());
                if (isCombatMove && Matches.UnitCanBlitz.match(u) && TerritoryEffectHelper.unitKeepsBlitz(u, startTerritory)) {
                    CompositeMatchAnd alliedWithNoEnemiesMatch = new CompositeMatchAnd(Matches.isTerritoryAllied(player, data), Matches.territoryHasNoEnemyUnits(player, data));
                    CompositeMatchOr alliedOrBlitzableMatch = new CompositeMatchOr(alliedWithNoEnemiesMatch, ProMatches.territoryIsBlitzable(player, data, u));
                    match = new CompositeMatchAnd(ProMatches.territoryCanMoveSpecificLandUnit(player, data, isCombatMove, u), alliedOrBlitzableMatch, Matches.territoryIsInList(enemyTerritories).invert());
                }
                return ((Match)match).match(t);
            }
        };
    }

    public static Match<Territory> territoryCanMoveLandUnitsThroughIgnoreEnemyUnits(final PlayerID player, final GameData data, final Unit u, final Territory startTerritory, final boolean isCombatMove, final List<Territory> enemyTerritories) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchAnd<Territory> match = new CompositeMatchAnd<Territory>(ProMatches.territoryCanMoveSpecificLandUnit(player, data, isCombatMove, u), Matches.isTerritoryAllied(player, data), Matches.territoryIsInList(enemyTerritories).invert());
                if (isCombatMove && Matches.UnitCanBlitz.match(u) && TerritoryEffectHelper.unitKeepsBlitz(u, startTerritory)) {
                    CompositeMatchOr alliedOrBlitzableMatch = new CompositeMatchOr(Matches.isTerritoryAllied(player, data), ProMatches.territoryIsBlitzable(player, data, u));
                    match = new CompositeMatchAnd(ProMatches.territoryCanMoveSpecificLandUnit(player, data, isCombatMove, u), alliedOrBlitzableMatch, Matches.territoryIsInList(enemyTerritories).invert());
                }
                return ((Match)match).match(t);
            }
        };
    }

    public static Match<Territory> territoryIsBlitzable(final PlayerID player, final GameData data, final Unit u) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return Matches.TerritoryIsBlitzable(player, data).match(t) && TerritoryEffectHelper.unitKeepsBlitz(u, t);
            }
        };
    }

    public static Match<Territory> territoryCanMoveSeaUnits(final PlayerID player, final GameData data, final boolean isCombatMove) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                boolean navalMayNotNonComIntoControlled;
                boolean bl = navalMayNotNonComIntoControlled = Properties.getWW2V2(data) || Properties.getNavalUnitsMayNotNonCombatMoveIntoControlledSeaZones(data);
                if (!isCombatMove && navalMayNotNonComIntoControlled && Matches.isTerritoryEnemyAndNotUnownedWater(player, data).match(t)) {
                    return false;
                }
                CompositeMatchAnd<Territory> match = new CompositeMatchAnd<Territory>(Matches.territoryDoesNotCostMoneyToEnter(data), Matches.TerritoryIsPassableAndNotRestrictedAndOkByRelationships(player, data, isCombatMove, false, true, false, false));
                return ((Match)match).match(t);
            }
        };
    }

    public static Match<Territory> territoryCanMoveSeaUnitsThrough(final PlayerID player, final GameData data, final boolean isCombatMove) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchAnd<Territory> match = new CompositeMatchAnd<Territory>(ProMatches.territoryCanMoveSeaUnits(player, data, isCombatMove), Matches.territoryHasNoEnemyUnits(player, data));
                return ((Match)match).match(t);
            }
        };
    }

    public static Match<Territory> territoryCanMoveSeaUnitsAndNotInList(final PlayerID player, final GameData data, final boolean isCombatMove, final List<Territory> notTerritories) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchAnd<Territory> match = new CompositeMatchAnd<Territory>(ProMatches.territoryCanMoveSeaUnits(player, data, isCombatMove), Matches.territoryIsNotInList(notTerritories));
                return ((Match)match).match(t);
            }
        };
    }

    public static Match<Territory> territoryCanMoveSeaUnitsThroughOrClearedAndNotInList(final PlayerID player, final GameData data, final boolean isCombatMove, final List<Territory> clearedTerritories, final List<Territory> notTerritories) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchAnd<Territory> match = new CompositeMatchAnd<Territory>(ProMatches.territoryCanMoveSeaUnits(player, data, isCombatMove), ProMatches.territoryHasNoEnemyUnitsOrCleared(player, data, clearedTerritories), Matches.territoryIsNotInList(notTerritories));
                return ((Match)match).match(t);
            }
        };
    }

    public static Match<Territory> territoryHasEnemyUnitsOrCantBeHeld(final PlayerID player, final GameData data, final List<Territory> territoriesThatCantBeHeld) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchOr<Territory> match = new CompositeMatchOr<Territory>(Matches.territoryHasEnemyUnits(player, data), Matches.territoryIsInList(territoriesThatCantBeHeld));
                return ((Match)match).match(t);
            }
        };
    }

    public static Match<Territory> territoryHasPotentialEnemyUnits(final PlayerID player, final GameData data, final List<PlayerID> players) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchOr<Territory> match = new CompositeMatchOr<Territory>(Matches.territoryHasEnemyUnits(player, data), Matches.territoryHasUnitsThatMatch(Matches.unitOwnedBy(players)));
                return ((Match)match).match(t);
            }
        };
    }

    public static Match<Territory> territoryHasNoEnemyUnitsOrCleared(final PlayerID player, final GameData data, final List<Territory> clearedTerritories) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchOr<Territory> match = new CompositeMatchOr<Territory>(Matches.territoryHasNoEnemyUnits(player, data), Matches.territoryIsInList(clearedTerritories));
                return ((Match)match).match(t);
            }
        };
    }

    public static Match<Territory> territoryIsEnemyOrHasEnemyUnitsOrCantBeHeld(final PlayerID player, final GameData data, final List<Territory> territoriesThatCantBeHeld) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchOr<Territory> match = new CompositeMatchOr<Territory>(Matches.isTerritoryEnemyAndNotUnownedWater(player, data), Matches.territoryHasEnemyUnits(player, data), Matches.territoryIsInList(territoriesThatCantBeHeld));
                return ((Match)match).match(t);
            }
        };
    }

    public static Match<Territory> territoryHasInfraFactoryAndIsLand(PlayerID player) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchAnd<Unit> infraFactoryMatch = new CompositeMatchAnd<Unit>(Matches.UnitCanProduceUnits, Matches.UnitIsInfrastructure);
                CompositeMatchAnd<Territory> match = new CompositeMatchAnd<Territory>(Matches.TerritoryIsLand, Matches.territoryHasUnitsThatMatch(infraFactoryMatch));
                return ((Match)match).match(t);
            }
        };
    }

    public static Match<Territory> territoryHasInfraFactoryAndIsEnemyLand(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchAnd<Territory> match = new CompositeMatchAnd<Territory>(ProMatches.territoryHasInfraFactoryAndIsLand(player), Matches.isTerritoryEnemy(player, data));
                return ((Match)match).match(t);
            }
        };
    }

    public static Match<Territory> territoryHasInfraFactoryAndIsOwnedByPlayersOrCantBeHeld(final PlayerID player, GameData data, final List<PlayerID> players, final List<Territory> territoriesThatCantBeHeld) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchAnd ownedAndCantBeHeld = new CompositeMatchAnd(Matches.isTerritoryOwnedBy(player), Matches.territoryIsInList(territoriesThatCantBeHeld));
                CompositeMatchOr enemyOrOwnedCantBeHeld = new CompositeMatchOr(Matches.isTerritoryOwnedBy(players), ownedAndCantBeHeld);
                CompositeMatchAnd<Territory> match = new CompositeMatchAnd<Territory>(ProMatches.territoryHasInfraFactoryAndIsLand(player), enemyOrOwnedCantBeHeld);
                return ((Match)match).match(t);
            }
        };
    }

    public static Match<Territory> territoryHasInfraFactoryAndIsNotConqueredOwnedLand(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchAnd<Territory> match = new CompositeMatchAnd<Territory>(ProMatches.territoryIsNotConqueredOwnedLand(player, data), ProMatches.territoryHasInfraFactoryAndIsOwnedLand(player));
                return ((Match)match).match(t);
            }
        };
    }

    public static Match<Territory> territoryHasInfraFactoryAndIsOwnedLand(final PlayerID player) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchAnd<Unit> infraFactoryMatch = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitCanProduceUnits, Matches.UnitIsInfrastructure);
                CompositeMatchAnd<Territory> match = new CompositeMatchAnd<Territory>(Matches.isTerritoryOwnedBy(player), Matches.TerritoryIsLand, Matches.territoryHasUnitsThatMatch(infraFactoryMatch));
                return ((Match)match).match(t);
            }
        };
    }

    public static Match<Territory> territoryHasInfraFactoryAndIsAlliedLand(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchAnd<Unit> infraFactoryMatch = new CompositeMatchAnd<Unit>(Matches.UnitCanProduceUnits, Matches.UnitIsInfrastructure);
                CompositeMatchAnd<Territory> match = new CompositeMatchAnd<Territory>(Matches.isTerritoryAllied(player, data), Matches.TerritoryIsLand, Matches.territoryHasUnitsThatMatch(infraFactoryMatch));
                return ((Match)match).match(t);
            }
        };
    }

    public static Match<Territory> territoryHasInfraFactoryAndIsOwnedLandAdjacentToSea(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchAnd<Territory> match = new CompositeMatchAnd<Territory>(ProMatches.territoryHasInfraFactoryAndIsOwnedLand(player), Matches.territoryHasNeighborMatching(data, Matches.TerritoryIsWater));
                return ((Match)match).match(t);
            }
        };
    }

    public static Match<Territory> territoryHasNoInfraFactoryAndIsNotConqueredOwnedLand(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchAnd<Territory> match = new CompositeMatchAnd<Territory>(ProMatches.territoryIsNotConqueredOwnedLand(player, data), ProMatches.territoryHasInfraFactoryAndIsOwnedLand(player).invert());
                return ((Match)match).match(t);
            }
        };
    }

    public static Match<Territory> territoryHasNeighborOwnedByAndHasLandUnit(final GameData data, PlayerID player, final List<PlayerID> players) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchAnd<Territory> territoryMatch = new CompositeMatchAnd<Territory>(Matches.isTerritoryOwnedBy(players), Matches.territoryHasUnitsThatMatch(Matches.UnitIsLand));
                Match<Territory> match = Matches.territoryHasNeighborMatching(data, territoryMatch);
                return match.match(t);
            }
        };
    }

    public static Match<Territory> territoryIsAlliedLandAndHasNoEnemyNeighbors(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchAnd alliedLand = new CompositeMatchAnd(ProMatches.territoryCanMoveLandUnits(player, data, false), Matches.isTerritoryAllied(player, data));
                Match<Territory> hasNoEnemyNeighbors = Matches.territoryHasNeighborMatching(data, ProMatches.territoryIsEnemyNotNeutralLand(player, data)).invert();
                CompositeMatchAnd<Territory> match = new CompositeMatchAnd<Territory>(alliedLand, hasNoEnemyNeighbors);
                return ((Match)match).match(t);
            }
        };
    }

    public static Match<Territory> territoryIsEnemyLand(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchAnd<Territory> match = new CompositeMatchAnd<Territory>(ProMatches.territoryCanMoveLandUnits(player, data, false), Matches.isTerritoryEnemy(player, data));
                return ((Match)match).match(t);
            }
        };
    }

    public static Match<Territory> territoryIsEnemyNotNeutralLand(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchAnd<Territory> match = new CompositeMatchAnd<Territory>(ProMatches.territoryIsEnemyLand(player, data), Matches.TerritoryIsNeutralButNotWater.invert());
                return ((Match)match).match(t);
            }
        };
    }

    public static Match<Territory> territoryIsOrAdjacentToEnemyNotNeutralLand(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchAnd<Territory> isMatch = new CompositeMatchAnd<Territory>(ProMatches.territoryIsEnemyLand(player, data), Matches.TerritoryIsNeutralButNotWater.invert());
                CompositeMatchAnd adjacentMatch = new CompositeMatchAnd(ProMatches.territoryCanMoveLandUnits(player, data, false), Matches.territoryHasNeighborMatching(data, isMatch));
                CompositeMatchOr<Territory> match = new CompositeMatchOr<Territory>(isMatch, adjacentMatch);
                return ((Match)match).match(t);
            }
        };
    }

    public static Match<Territory> territoryIsEnemyNotNeutralOrAllied(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchAnd alliedLand = new CompositeMatchAnd(Matches.TerritoryIsLand, Matches.isTerritoryAllied(player, data));
                CompositeMatchOr<Territory> match = new CompositeMatchOr<Territory>(ProMatches.territoryIsEnemyNotNeutralLand(player, data), alliedLand);
                return ((Match)match).match(t);
            }
        };
    }

    public static Match<Territory> territoryIsEnemyOrCantBeHeld(final PlayerID player, final GameData data, final List<Territory> territoriesThatCantBeHeld) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchOr<Territory> match = new CompositeMatchOr<Territory>(Matches.isTerritoryEnemyAndNotUnownedWater(player, data), Matches.territoryIsInList(territoriesThatCantBeHeld));
                return ((Match)match).match(t);
            }
        };
    }

    public static Match<Territory> territoryIsPotentialEnemy(final PlayerID player, final GameData data, final List<PlayerID> players) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchOr<Territory> match = new CompositeMatchOr<Territory>(Matches.isTerritoryEnemyAndNotUnownedWater(player, data), Matches.isTerritoryOwnedBy(players));
                return ((Match)match).match(t);
            }
        };
    }

    public static Match<Territory> territoryIsPotentialEnemyOrHasPotentialEnemyUnits(final PlayerID player, final GameData data, final List<PlayerID> players) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchOr<Territory> match = new CompositeMatchOr<Territory>(ProMatches.territoryIsPotentialEnemy(player, data, players), ProMatches.territoryHasPotentialEnemyUnits(player, data, players));
                return ((Match)match).match(t);
            }
        };
    }

    public static Match<Territory> territoryIsEnemyOrCantBeHeldAndIsAdjacentToMyLandUnits(final PlayerID player, final GameData data, final List<Territory> territoriesThatCantBeHeld) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                CompositeMatchAnd<Unit> myUnitIsLand = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsLand);
                CompositeMatchAnd territoryIsLandAndAdjacentToMyLandUnits = new CompositeMatchAnd(Matches.TerritoryIsLand, Matches.territoryHasNeighborMatching(data, Matches.territoryHasUnitsThatMatch(myUnitIsLand)));
                CompositeMatchAnd<Territory> match = new CompositeMatchAnd<Territory>(territoryIsLandAndAdjacentToMyLandUnits, ProMatches.territoryIsEnemyOrCantBeHeld(player, data, territoriesThatCantBeHeld));
                return ((Match)match).match(t);
            }
        };
    }

    public static Match<Territory> territoryIsNotConqueredAlliedLand(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                if (AbstractMoveDelegate.getBattleTracker(data).wasConquered(t)) {
                    return false;
                }
                CompositeMatchAnd<Territory> match = new CompositeMatchAnd<Territory>(Matches.isTerritoryAllied(player, data), Matches.TerritoryIsLand);
                return ((Match)match).match(t);
            }
        };
    }

    public static Match<Territory> territoryIsNotConqueredOwnedLand(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                if (AbstractMoveDelegate.getBattleTracker(data).wasConquered(t)) {
                    return false;
                }
                CompositeMatchAnd<Territory> match = new CompositeMatchAnd<Territory>(Matches.isTerritoryOwnedBy(player), Matches.TerritoryIsLand);
                return ((Match)match).match(t);
            }
        };
    }

    public static Match<Territory> territoryIsWaterAndAdjacentToOwnedFactory(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                Match<Territory> hasOwnedFactoryNeighbor = Matches.territoryHasNeighborMatching(data, ProMatches.territoryHasInfraFactoryAndIsOwnedLand(player));
                CompositeMatchAnd<Territory> match = new CompositeMatchAnd<Territory>(hasOwnedFactoryNeighbor, ProMatches.territoryCanMoveSeaUnits(player, data, true));
                return ((Match)match).match(t);
            }
        };
    }

    public static Match<Unit> unitCanBeMovedAndIsOwned(final PlayerID player) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                CompositeMatchAnd<Unit> match = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.unitHasMovementLeft);
                return ((Match)match).match(u);
            }
        };
    }

    public static Match<Unit> unitCanBeMovedAndIsOwnedAir(final PlayerID player, final boolean isCombatMove) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                if (isCombatMove && Matches.UnitCanNotMoveDuringCombatMove.match(u)) {
                    return false;
                }
                CompositeMatchAnd<Unit> match = new CompositeMatchAnd<Unit>(ProMatches.unitCanBeMovedAndIsOwned(player), Matches.UnitIsAir);
                return ((Match)match).match(u);
            }
        };
    }

    public static Match<Unit> unitCanBeMovedAndIsOwnedLand(final PlayerID player, final boolean isCombatMove) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                if (isCombatMove && Matches.UnitCanNotMoveDuringCombatMove.match(u)) {
                    return false;
                }
                CompositeMatchAnd<Unit> match = new CompositeMatchAnd<Unit>(ProMatches.unitCanBeMovedAndIsOwned(player), Matches.UnitIsLand, Matches.unitIsBeingTransported().invert());
                return ((Match)match).match(u);
            }
        };
    }

    public static Match<Unit> unitCanBeMovedAndIsOwnedSea(final PlayerID player, final boolean isCombatMove) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                if (isCombatMove && Matches.UnitCanNotMoveDuringCombatMove.match(u)) {
                    return false;
                }
                CompositeMatchAnd<Unit> match = new CompositeMatchAnd<Unit>(ProMatches.unitCanBeMovedAndIsOwned(player), Matches.UnitIsSea);
                return ((Match)match).match(u);
            }
        };
    }

    public static Match<Unit> unitCanBeMovedAndIsOwnedTransport(final PlayerID player, final boolean isCombatMove) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                if (isCombatMove && Matches.UnitCanNotMoveDuringCombatMove.match(u)) {
                    return false;
                }
                CompositeMatchAnd<Unit> match = new CompositeMatchAnd<Unit>(ProMatches.unitCanBeMovedAndIsOwned(player), Matches.UnitIsTransport);
                return ((Match)match).match(u);
            }
        };
    }

    public static Match<Unit> unitCanBeMovedAndIsOwnedBombard(final PlayerID player) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                if (Matches.UnitCanNotMoveDuringCombatMove.match(u)) {
                    return false;
                }
                CompositeMatchAnd<Unit> match = new CompositeMatchAnd<Unit>(ProMatches.unitCanBeMovedAndIsOwned(player), Matches.unitCanBombard(player));
                return ((Match)match).match(u);
            }
        };
    }

    public static Match<Unit> unitCanBeMovedAndIsOwnedNonCombatInfra(final PlayerID player) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                CompositeMatchAnd<Unit> match = new CompositeMatchAnd<Unit>(ProMatches.unitCanBeMovedAndIsOwned(player), Matches.UnitCanNotMoveDuringCombatMove, Matches.UnitIsInfrastructure);
                return ((Match)match).match(u);
            }
        };
    }

    public static Match<Unit> unitCantBeMovedAndIsAlliedDefender(final PlayerID player, final GameData data, final Territory t) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                CompositeMatchAnd myUnitHasNoMovementMatch = new CompositeMatchAnd(Matches.unitIsOwnedBy(player), Matches.unitHasMovementLeft.invert());
                CompositeMatchAnd alliedUnitMatch = new CompositeMatchAnd(Matches.unitIsOwnedBy(player).invert(), Matches.isUnitAllied(player, data), Matches.unitIsBeingTransportedByOrIsDependentOfSomeUnitInThisList(t.getUnits().getUnits(), null, player, data, false).invert());
                CompositeMatchOr<Unit> match = new CompositeMatchOr<Unit>(myUnitHasNoMovementMatch, alliedUnitMatch);
                return ((Match)match).match(u);
            }
        };
    }

    public static Match<Unit> unitCantBeMovedAndIsAlliedDefenderAndNotInfra(final PlayerID player, final GameData data, final Territory t) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                CompositeMatchAnd<Unit> match = new CompositeMatchAnd<Unit>(ProMatches.unitCantBeMovedAndIsAlliedDefender(player, data, t), Matches.UnitIsNotInfrastructure);
                return ((Match)match).match(u);
            }
        };
    }

    public static Match<Unit> unitIsAlliedLandAndNotInfra(final PlayerID player, final GameData data) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                CompositeMatchAnd<Unit> match = new CompositeMatchAnd<Unit>(Matches.UnitIsLand, Matches.isUnitAllied(player, data), Matches.UnitIsNotInfrastructure);
                return ((Match)match).match(u);
            }
        };
    }

    public static Match<Unit> unitIsAlliedNotLand(final PlayerID player, final GameData data) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                CompositeMatchAnd<Unit> match = new CompositeMatchAnd<Unit>(Matches.UnitIsNotLand, Matches.isUnitAllied(player, data));
                return ((Match)match).match(u);
            }
        };
    }

    public static Match<Unit> unitIsAlliedNotOwned(final PlayerID player, final GameData data) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                CompositeMatchAnd<Unit> match = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player).invert(), Matches.isUnitAllied(player, data));
                return ((Match)match).match(u);
            }
        };
    }

    public static Match<Unit> unitIsAlliedNotOwnedAir(final PlayerID player, final GameData data) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                CompositeMatchAnd<Unit> match = new CompositeMatchAnd<Unit>(ProMatches.unitIsAlliedNotOwned(player, data), Matches.UnitIsAir);
                return ((Match)match).match(u);
            }
        };
    }

    public static Match<Unit> unitIsAlliedAir(final PlayerID player, final GameData data) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                CompositeMatchAnd<Unit> match = new CompositeMatchAnd<Unit>(Matches.isUnitAllied(player, data), Matches.UnitIsAir);
                return ((Match)match).match(u);
            }
        };
    }

    public static Match<Unit> unitIsEnemyAir(final PlayerID player, final GameData data) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                CompositeMatchAnd<Unit> match = new CompositeMatchAnd<Unit>(Matches.enemyUnit(player, data), Matches.UnitIsAir);
                return ((Match)match).match(u);
            }
        };
    }

    public static Match<Unit> unitIsEnemyAndNotAA(final PlayerID player, final GameData data) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                CompositeMatchAnd<Unit> match = new CompositeMatchAnd<Unit>(Matches.enemyUnit(player, data), Matches.UnitIsAAforAnything.invert());
                return ((Match)match).match(u);
            }
        };
    }

    public static Match<Unit> unitIsEnemyAndNotInfa(final PlayerID player, final GameData data) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                CompositeMatchAnd<Unit> match = new CompositeMatchAnd<Unit>(Matches.enemyUnit(player, data), Matches.UnitIsNotInfrastructure);
                return ((Match)match).match(u);
            }
        };
    }

    public static Match<Unit> unitIsEnemyLand(final PlayerID player, final GameData data) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                CompositeMatchAnd<Unit> match = new CompositeMatchAnd<Unit>(Matches.enemyUnit(player, data), Matches.UnitIsLand);
                return ((Match)match).match(u);
            }
        };
    }

    public static Match<Unit> unitIsEnemyNotLand(final PlayerID player, final GameData data) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                CompositeMatchAnd<Unit> match = new CompositeMatchAnd<Unit>(Matches.enemyUnit(player, data), Matches.UnitIsNotLand);
                return ((Match)match).match(u);
            }
        };
    }

    public static Match<Unit> unitIsEnemyNotNeutral(final PlayerID player, final GameData data) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                CompositeMatchAnd<Unit> match = new CompositeMatchAnd<Unit>(Matches.enemyUnit(player, data), ProMatches.unitIsNeutral().invert());
                return ((Match)match).match(u);
            }
        };
    }

    public static Match<Unit> unitIsEnemySea(final PlayerID player, final GameData data) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                CompositeMatchAnd<Unit> match = new CompositeMatchAnd<Unit>(Matches.enemyUnit(player, data), Matches.UnitIsSea);
                return ((Match)match).match(u);
            }
        };
    }

    public static Match<Unit> unitIsNeutral() {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                return u.getOwner().isNull();
            }
        };
    }

    public static Match<Unit> unitIsOwnedAir(final PlayerID player) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                CompositeMatchAnd<Unit> match = new CompositeMatchAnd<Unit>(Matches.unitOwnedBy(player), Matches.UnitIsAir);
                return ((Match)match).match(u);
            }
        };
    }

    public static Match<Unit> unitIsOwnedAndMatchesTypeAndIsTransporting(final PlayerID player, final UnitType unitType) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                CompositeMatchAnd<Unit> match = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.unitIsOfType(unitType), Matches.unitIsTransporting());
                return ((Match)match).match(u);
            }
        };
    }

    public static Match<Unit> unitIsOwnedAndMatchesTypeAndNotTransporting(final PlayerID player, final UnitType unitType) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                CompositeMatchAnd<Unit> match = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.unitIsOfType(unitType), Matches.unitIsTransporting().invert());
                return ((Match)match).match(u);
            }
        };
    }

    public static final Match<Unit> UnitIsOwnedCarrier(final PlayerID player) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                UnitAttachment ua = UnitAttachment.get(u.getType());
                return ua.getCarrierCapacity() != -1 && Matches.unitIsOwnedBy(player).match(u);
            }
        };
    }

    public static Match<Unit> unitIsOwnedLand(final PlayerID player) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                CompositeMatchAnd<Unit> match = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsLand);
                return ((Match)match).match(u);
            }
        };
    }

    public static Match<Unit> unitIsOwnedNotLand(final PlayerID player, GameData data) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                CompositeMatchAnd<Unit> match = new CompositeMatchAnd<Unit>(Matches.UnitIsNotLand, Matches.unitIsOwnedBy(player));
                return ((Match)match).match(u);
            }
        };
    }

    public static Match<Unit> unitIsOwnedTransport(final PlayerID player) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                CompositeMatchAnd<Unit> match = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsTransport);
                return ((Match)match).match(u);
            }
        };
    }

    public static Match<Unit> unitIsOwnedTransportableUnit(final PlayerID player) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                CompositeMatchAnd<Unit> match = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitCanBeTransported, Matches.UnitCanMove);
                return ((Match)match).match(u);
            }
        };
    }

    public static Match<Unit> unitIsOwnedCombatTransportableUnit(final PlayerID player) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                CompositeMatchAnd<Unit> match = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitCanBeTransported, Matches.UnitCanNotMoveDuringCombatMove.invert(), Matches.UnitCanMove);
                return ((Match)match).match(u);
            }
        };
    }

    public static Match<Unit> unitIsOwnedTransportableUnitAndCanBeLoaded(final PlayerID player, final boolean isCombatMove) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                if (isCombatMove && Matches.UnitCanNotMoveDuringCombatMove.match(u)) {
                    return false;
                }
                CompositeMatchAnd<Unit> match = new CompositeMatchAnd<Unit>(ProMatches.unitIsOwnedTransportableUnit(player), Matches.unitHasNotMoved, Matches.unitHasMovementLeft, Matches.unitIsBeingTransported().invert());
                return ((Match)match).match(u);
            }
        };
    }

    public static Match<Unit> unitWhichRequiresUnitsHasRequiredUnits(PlayerID player, final Territory t) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit unitWhichRequiresUnits) {
                if (!Matches.UnitRequiresUnitsOnCreation.match(unitWhichRequiresUnits)) {
                    return true;
                }
                Collection<Unit> unitsAtStartOfTurnInProducer = t.getUnits().getUnits();
                if (Matches.UnitWhichRequiresUnitsHasRequiredUnitsInList(unitsAtStartOfTurnInProducer).match(unitWhichRequiresUnits)) {
                    return true;
                }
                if (t.isWater() && Matches.UnitIsSea.match(unitWhichRequiresUnits)) {
                    for (Territory neighbor : t.getData().getMap().getNeighbors(t, Matches.TerritoryIsLand)) {
                        Collection<Unit> unitsAtStartOfTurnInCurrent = neighbor.getUnits().getUnits();
                        if (!Matches.UnitWhichRequiresUnitsHasRequiredUnitsInList(unitsAtStartOfTurnInCurrent).match(unitWhichRequiresUnits)) continue;
                        return true;
                    }
                }
                return false;
            }
        };
    }
}

