/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.proAI.util;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.ai.proAI.ProAI;
import games.strategy.triplea.ai.proAI.ProAttackTerritoryData;
import games.strategy.triplea.ai.proAI.util.LogUtils;
import games.strategy.triplea.ai.proAI.util.ProMatches;
import games.strategy.triplea.ai.proAI.util.ProUtils;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.MoveValidator;
import games.strategy.triplea.delegate.TransportTracker;
import games.strategy.triplea.delegate.remote.IMoveDelegate;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class ProMoveUtils {
    private final ProAI ai;
    private final ProUtils utils;

    public ProMoveUtils(ProAI ai, ProUtils utils) {
        this.ai = ai;
        this.utils = utils;
    }

    public void calculateMoveRoutes(PlayerID player, boolean areNeutralsPassableByAir, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, Map<Territory, ProAttackTerritoryData> attackMap, boolean isCombatMove) {
        GameData data = this.ai.getGameData();
        Map<Unit, Territory> unitTerritoryMap = this.utils.createUnitTerritoryMap(player);
        HashSet<Unit> amphibUnits = new HashSet<Unit>();
        for (Territory t : attackMap.keySet()) {
            amphibUnits.addAll(attackMap.get(t).getAmphibAttackMap().keySet());
            for (Unit transport : attackMap.get(t).getAmphibAttackMap().keySet()) {
                amphibUnits.addAll((Collection)attackMap.get(t).getAmphibAttackMap().get(transport));
            }
        }
        for (Territory t : attackMap.keySet()) {
            for (Unit u : attackMap.get(t).getUnits()) {
                Map<Unit, Collection<Unit>> carrierMustMoveWith;
                Territory startTerritory;
                if (amphibUnits.contains(u) || (startTerritory = unitTerritoryMap.get(u)) == null || startTerritory.equals(t)) continue;
                ArrayList<Unit> unitList = new ArrayList<Unit>();
                unitList.add(u);
                moveUnits.add(unitList);
                if (Matches.UnitIsCarrier.match(u) && (carrierMustMoveWith = MoveValidator.carrierMustMoveWith(startTerritory.getUnits().getUnits(), startTerritory, data, player)).containsKey(u)) {
                    unitList.addAll(carrierMustMoveWith.get(u));
                }
                Route route = null;
                if (Match.someMatch(unitList, Matches.UnitIsSea)) {
                    route = data.getMap().getRoute_IgnoreEnd(startTerritory, t, ProMatches.territoryCanMoveSeaUnitsThrough(player, data, isCombatMove));
                } else if (Match.allMatch(unitList, Matches.UnitIsLand)) {
                    route = data.getMap().getRoute_IgnoreEnd(startTerritory, t, ProMatches.territoryCanMoveLandUnitsThrough(player, data, u, startTerritory, isCombatMove, new ArrayList<Territory>()));
                } else if (Match.allMatch(unitList, Matches.UnitIsAir)) {
                    route = data.getMap().getRoute_IgnoreEnd(startTerritory, t, ProMatches.territoryCanMoveAirUnitsAndNoAA(player, data, isCombatMove));
                }
                if (route == null) {
                    LogUtils.log(Level.WARNING, data.getSequence().getRound() + "-" + data.getSequence().getStep().getName() + ": route is null " + startTerritory + " to " + t + ", units=" + unitList);
                }
                moveRoutes.add(route);
            }
        }
    }

    public void calculateAmphibRoutes(PlayerID player, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, List<Collection<Unit>> transportsToLoad, Map<Territory, ProAttackTerritoryData> attackMap, boolean isCombatMove) {
        GameData data = this.ai.getGameData();
        Map<Unit, Territory> unitTerritoryMap = this.utils.createUnitTerritoryMap(player);
        for (Territory t : attackMap.keySet()) {
            Map<Unit, List<Unit>> amphibAttackMap = attackMap.get(t).getAmphibAttackMap();
            for (Unit transport : amphibAttackMap.keySet()) {
                int movesLeft = TripleAUnit.get(transport).getMovementLeft();
                Territory transportTerritory = unitTerritoryMap.get(transport);
                ArrayList<Unit> loadedUnits = new ArrayList<Unit>();
                ArrayList remainingUnitsToLoad = new ArrayList();
                if (TransportTracker.isTransporting(transport)) {
                    loadedUnits.addAll((Collection)amphibAttackMap.get(transport));
                } else {
                    remainingUnitsToLoad.addAll(amphibAttackMap.get(transport));
                }
                while (movesLeft >= 0) {
                    if (Matches.territoryHasEnemyUnits(player, data).invert().match(transportTerritory)) {
                        ArrayList<Unit> unitsToRemove = new ArrayList<Unit>();
                        for (Unit amphibUnit : remainingUnitsToLoad) {
                            if (data.getMap().getDistance(transportTerritory, unitTerritoryMap.get(amphibUnit)) != 1) continue;
                            moveUnits.add(Collections.singletonList(amphibUnit));
                            transportsToLoad.add(Collections.singletonList(transport));
                            Route route = new Route(unitTerritoryMap.get(amphibUnit), transportTerritory);
                            moveRoutes.add(route);
                            unitsToRemove.add(amphibUnit);
                            loadedUnits.add(amphibUnit);
                        }
                        for (Unit u : unitsToRemove) {
                            remainingUnitsToLoad.remove(u);
                        }
                    }
                    Territory unloadTerritory = attackMap.get(t).getTransportTerritoryMap().get(transport);
                    int distanceFromEnd = data.getMap().getDistance(transportTerritory, t);
                    if (t.isWater()) {
                        ++distanceFromEnd;
                    }
                    if (movesLeft > 0 && (distanceFromEnd > 1 || !remainingUnitsToLoad.isEmpty() || unloadTerritory != null && !unloadTerritory.equals(transportTerritory))) {
                        Set<Territory> neighbors = data.getMap().getNeighbors(transportTerritory, ProMatches.territoryCanMoveSeaUnitsThrough(player, data, isCombatMove));
                        Territory territoryToMoveTo = null;
                        int minUnitDistance = Integer.MAX_VALUE;
                        int maxDistanceFromEnd = Integer.MIN_VALUE;
                        for (Territory neighbor : neighbors) {
                            if (MoveValidator.validateCanal(new Route(transportTerritory, neighbor), Collections.singletonList(transport), player, data) != null) continue;
                            int distanceFromUnloadTerritory = 0;
                            if (unloadTerritory != null) {
                                distanceFromUnloadTerritory = data.getMap().getDistance_IgnoreEndForCondition(neighbor, unloadTerritory, ProMatches.territoryCanMoveSeaUnitsThrough(player, data, isCombatMove));
                            }
                            int neighborDistanceFromEnd = data.getMap().getDistance_IgnoreEndForCondition(neighbor, t, ProMatches.territoryCanMoveSeaUnitsThrough(player, data, isCombatMove));
                            if (t.isWater()) {
                                ++neighborDistanceFromEnd;
                            }
                            int maxUnitDistance = 0;
                            for (Unit u : remainingUnitsToLoad) {
                                int distance = data.getMap().getDistance(neighbor, unitTerritoryMap.get(u));
                                if (distance <= maxUnitDistance) continue;
                                maxUnitDistance = distance;
                            }
                            if (neighborDistanceFromEnd > movesLeft || maxUnitDistance > minUnitDistance || distanceFromUnloadTerritory >= movesLeft || maxUnitDistance >= minUnitDistance && (maxUnitDistance <= 1 || neighborDistanceFromEnd <= maxDistanceFromEnd) && (maxUnitDistance > 1 || neighborDistanceFromEnd >= maxDistanceFromEnd)) continue;
                            territoryToMoveTo = neighbor;
                            minUnitDistance = maxUnitDistance;
                            if (neighborDistanceFromEnd <= maxDistanceFromEnd) continue;
                            maxDistanceFromEnd = neighborDistanceFromEnd;
                        }
                        if (territoryToMoveTo != null) {
                            ArrayList<Unit> unitsToMove = new ArrayList<Unit>();
                            unitsToMove.add(transport);
                            unitsToMove.addAll(loadedUnits);
                            moveUnits.add(unitsToMove);
                            transportsToLoad.add(null);
                            Route route = new Route(transportTerritory, territoryToMoveTo);
                            moveRoutes.add(route);
                            transportTerritory = territoryToMoveTo;
                        }
                    }
                    --movesLeft;
                }
                if (!remainingUnitsToLoad.isEmpty()) {
                    LogUtils.log(Level.WARNING, data.getSequence().getRound() + "-" + data.getSequence().getStep().getName() + ": " + t + ", remainingUnitsToLoad=" + remainingUnitsToLoad);
                }
                attackMap.get(t).getTransportTerritoryMap().put(transport, transportTerritory);
                if (loadedUnits.isEmpty() || t.isWater()) continue;
                moveUnits.add(loadedUnits);
                transportsToLoad.add(null);
                Route route = new Route(transportTerritory, t);
                moveRoutes.add(route);
            }
        }
    }

    public void calculateBombardMoveRoutes(PlayerID player, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, Map<Territory, ProAttackTerritoryData> attackMap) {
        GameData data = this.ai.getGameData();
        Map<Unit, Territory> unitTerritoryMap = this.utils.createUnitTerritoryMap(player);
        for (Territory t : attackMap.keySet()) {
            for (Unit u : attackMap.get(t).getBombardTerritoryMap().keySet()) {
                Territory bombardFromTerritory = attackMap.get(t).getBombardTerritoryMap().get(u);
                Territory startTerritory = unitTerritoryMap.get(u);
                if (startTerritory.equals(bombardFromTerritory)) continue;
                ArrayList<Unit> unitList = new ArrayList<Unit>();
                unitList.add(u);
                moveUnits.add(unitList);
                Route route = null;
                if (Match.allMatch(unitList, ProMatches.unitCanBeMovedAndIsOwnedSea(player, true))) {
                    route = data.getMap().getRoute_IgnoreEnd(startTerritory, bombardFromTerritory, ProMatches.territoryCanMoveSeaUnitsThrough(player, data, true));
                }
                moveRoutes.add(route);
            }
        }
    }

    public void doMove(List<Collection<Unit>> moveUnits, List<Route> moveRoutes, List<Collection<Unit>> transportsToLoad, IMoveDelegate moveDel, boolean isSimulation) {
        int i;
        GameData data = this.ai.getGameData();
        if (transportsToLoad == null) {
            block0: for (i = 0; i < moveRoutes.size(); ++i) {
                Route r = moveRoutes.get(i);
                for (int j = i + 1; j < moveRoutes.size(); ++j) {
                    Route r2 = moveRoutes.get(j);
                    if (!r.equals(r2)) continue;
                    moveUnits.get(j).addAll(moveUnits.get(i));
                    moveUnits.remove(i);
                    moveRoutes.remove(i);
                    --i;
                    continue block0;
                }
            }
        }
        for (i = 0; i < moveRoutes.size(); ++i) {
            if (!isSimulation) {
                this.utils.pause();
            }
            if (moveRoutes.get(i) == null || moveRoutes.get(i).getEnd() == null || moveRoutes.get(i).getStart() == null) {
                LogUtils.log(Level.WARNING, data.getSequence().getRound() + "-" + data.getSequence().getStep().getName() + ": route not valid " + moveRoutes.get(i) + " units: " + moveUnits.get(i));
                continue;
            }
            String result = transportsToLoad == null || transportsToLoad.get(i) == null ? moveDel.move(moveUnits.get(i), moveRoutes.get(i)) : moveDel.move(moveUnits.get(i), moveRoutes.get(i), transportsToLoad.get(i));
            if (result == null) continue;
            LogUtils.log(Level.WARNING, data.getSequence().getRound() + "-" + data.getSequence().getStep().getName() + ": could not move " + moveUnits.get(i) + " over " + moveRoutes.get(i) + " because: " + result);
        }
    }
}

