/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.proAI.util;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.NamedAttachable;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionFrontier;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.ai.proAI.ProAI;
import games.strategy.triplea.ai.proAI.ProPlaceTerritory;
import games.strategy.triplea.ai.proAI.ProPurchaseOption;
import games.strategy.triplea.ai.proAI.ProPurchaseTerritory;
import games.strategy.triplea.ai.proAI.simulate.ProDummyDelegateBridge;
import games.strategy.triplea.ai.proAI.util.LogUtils;
import games.strategy.triplea.ai.proAI.util.ProMatches;
import games.strategy.triplea.attatchments.RulesAttachment;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.AbstractPlaceDelegate;
import games.strategy.triplea.delegate.BattleCalculator;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.OriginalOwnerTracker;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class ProPurchaseUtils {
    private final ProAI ai;

    public ProPurchaseUtils(ProAI proAI) {
        this.ai = proAI;
    }

    public void findPurchaseOptions(PlayerID player, List<ProPurchaseOption> landPurchaseOptions, List<ProPurchaseOption> airPurchaseOptions, List<ProPurchaseOption> seaPurchaseOptions, List<ProPurchaseOption> factoryPurchaseOptions, List<ProPurchaseOption> specialPurchaseOptions) {
        LogUtils.log(Level.FINE, "Find all purchase options");
        GameData data = this.ai.getGameData();
        List<ProductionRule> rules = player.getProductionFrontier().getRules();
        for (ProductionRule rule : rules) {
            ProPurchaseOption purchaseOption;
            NamedAttachable resourceOrUnit = rule.getResults().keySet().iterator().next();
            if (!(resourceOrUnit instanceof UnitType)) continue;
            UnitType unitType = (UnitType)resourceOrUnit;
            if (UnitAttachment.get(unitType).getMovement(player) <= 0 && !UnitAttachment.get(unitType).getCanProduceUnits() || Matches.UnitTypeHasMaxBuildRestrictions.match(unitType) || Matches.UnitTypeConsumesUnitsOnCreation.match(unitType) || Matches.UnitTypeCanNotMoveDuringCombatMove.match(unitType) || UnitAttachment.get(unitType).getIsSuicide()) {
                purchaseOption = new ProPurchaseOption(rule, unitType, player, data);
                specialPurchaseOptions.add(purchaseOption);
                LogUtils.log(Level.FINER, "Special: " + purchaseOption);
                continue;
            }
            if (Matches.UnitTypeCanProduceUnits.match(unitType) && Matches.UnitTypeIsInfrastructure.match(unitType)) {
                purchaseOption = new ProPurchaseOption(rule, unitType, player, data);
                factoryPurchaseOptions.add(purchaseOption);
                LogUtils.log(Level.FINER, "Factory: " + purchaseOption);
                continue;
            }
            if (Matches.UnitTypeIsLand.match(unitType)) {
                purchaseOption = new ProPurchaseOption(rule, unitType, player, data);
                landPurchaseOptions.add(purchaseOption);
                LogUtils.log(Level.FINER, "Land: " + purchaseOption);
                continue;
            }
            if (Matches.UnitTypeIsAir.match(unitType)) {
                purchaseOption = new ProPurchaseOption(rule, unitType, player, data);
                airPurchaseOptions.add(purchaseOption);
                LogUtils.log(Level.FINER, "Air: " + purchaseOption);
                continue;
            }
            if (!Matches.UnitTypeIsSea.match(unitType)) continue;
            purchaseOption = new ProPurchaseOption(rule, unitType, player, data);
            seaPurchaseOptions.add(purchaseOption);
            LogUtils.log(Level.FINER, "Sea: " + purchaseOption);
        }
    }

    public List<ProPurchaseOption> findPurchaseOptionsForTerritory(PlayerID player, List<ProPurchaseOption> purchaseOptions, Territory t) {
        ArrayList<ProPurchaseOption> result = new ArrayList<ProPurchaseOption>();
        for (ProPurchaseOption ppo : purchaseOptions) {
            if (!this.canTerritoryUsePurchaseOption(player, ppo, t)) continue;
            result.add(ppo);
        }
        return result;
    }

    public boolean canTerritoryUsePurchaseOption(PlayerID player, ProPurchaseOption ppo, Territory t) {
        if (ppo == null) {
            return false;
        }
        List<Unit> units = ppo.getUnitType().create(ppo.getQuantity(), player, true);
        return this.canUnitsBePlaced(units, player, t);
    }

    public boolean canUnitsBePlaced(List<Unit> units, PlayerID player, Territory t) {
        GameData data = this.ai.getGameData();
        AbstractPlaceDelegate placeDelegate = (AbstractPlaceDelegate)data.getDelegateList().getDelegate("place");
        ProDummyDelegateBridge bridge = new ProDummyDelegateBridge(this.ai, player, data);
        placeDelegate.setDelegateBridgeAndPlayer(bridge);
        String s = placeDelegate.canUnitsBePlaced(t, units, player);
        return s == null;
    }

    public void removePurchaseOptionsByCostAndProductionAndLimits(PlayerID player, GameData data, List<ProPurchaseOption> purchaseOptions, int PUsRemaining, int remainingUnitProduction, List<Unit> unitsToPlace, Map<Territory, ProPurchaseTerritory> purchaseTerritories) {
        Iterator<ProPurchaseOption> it = purchaseOptions.iterator();
        while (it.hasNext()) {
            ProPurchaseOption ppo = it.next();
            if (ppo.getCost() > PUsRemaining || ppo.getQuantity() > remainingUnitProduction) {
                it.remove();
                continue;
            }
            int maxBuilt = ppo.getMaxBuiltPerPlayer();
            UnitType type = ppo.getUnitType();
            if (maxBuilt == 0) {
                it.remove();
                continue;
            }
            if (maxBuilt <= 0) continue;
            int currentlyBuilt = 0;
            CompositeMatchAnd<Unit> unitTypeOwnedBy = new CompositeMatchAnd<Unit>(Matches.unitIsOfType(type), Matches.unitIsOwnedBy(player));
            List<Territory> allTerritories = data.getMap().getTerritories();
            for (Territory t : allTerritories) {
                currentlyBuilt += t.getUnits().countMatches(unitTypeOwnedBy);
            }
            currentlyBuilt += Match.countMatches(unitsToPlace, unitTypeOwnedBy);
            for (Territory t : purchaseTerritories.keySet()) {
                for (ProPlaceTerritory placeTerritory : purchaseTerritories.get(t).getCanPlaceTerritories()) {
                    currentlyBuilt += Match.countMatches(placeTerritory.getPlaceUnits(), unitTypeOwnedBy);
                }
            }
            int allowedBuild = maxBuilt - currentlyBuilt;
            if (allowedBuild - ppo.getQuantity() >= 0) continue;
            it.remove();
        }
    }

    public ProPurchaseOption randomizePurchaseOption(Map<ProPurchaseOption, Double> purchaseEfficiencies, String type) {
        LogUtils.log(Level.FINEST, "Select purchase option for " + type);
        double totalEfficiency = 0.0;
        for (Double efficiency : purchaseEfficiencies.values()) {
            totalEfficiency += efficiency.doubleValue();
        }
        LinkedHashMap<ProPurchaseOption, Double> purchasePercentages = new LinkedHashMap<ProPurchaseOption, Double>();
        double upperBound = 0.0;
        for (ProPurchaseOption ppo : purchaseEfficiencies.keySet()) {
            double chance = purchaseEfficiencies.get(ppo) / totalEfficiency * 100.0;
            purchasePercentages.put(ppo, upperBound += chance);
            LogUtils.log(Level.FINEST, ppo.getUnitType().getName() + ", probability=" + chance + ", upperBound=" + upperBound);
        }
        double randomNumber = Math.random() * 100.0;
        LogUtils.log(Level.FINEST, "Random number: " + randomNumber);
        for (ProPurchaseOption ppo : purchasePercentages.keySet()) {
            if (!(randomNumber <= (Double)purchasePercentages.get(ppo))) continue;
            return ppo;
        }
        return (ProPurchaseOption)purchasePercentages.keySet().iterator().next();
    }

    public List<Unit> findMaxPurchaseDefenders(PlayerID player, Territory t, List<ProPurchaseOption> landPurchaseOptions) {
        LogUtils.log(Level.FINE, "Find max purchase defenders for " + t.getName());
        GameData data = this.ai.getGameData();
        Resource PUs = data.getResourceList().getResource("PUs");
        int PUsRemaining = player.getResources().getQuantity(PUs);
        List<ProPurchaseOption> purchaseOptionsForTerritory = this.findPurchaseOptionsForTerritory(player, landPurchaseOptions, t);
        ProPurchaseOption bestDefenseOption = null;
        double maxDefenseEfficiency = 0.0;
        for (ProPurchaseOption ppo : purchaseOptionsForTerritory) {
            if (!(ppo.getDefenseEfficiency() > maxDefenseEfficiency) || ppo.getCost() > PUsRemaining) continue;
            bestDefenseOption = ppo;
            maxDefenseEfficiency = ppo.getDefenseEfficiency();
        }
        ArrayList<Unit> placeUnits = new ArrayList<Unit>();
        if (bestDefenseOption != null) {
            LogUtils.log(Level.FINER, "Best defense option: " + bestDefenseOption.getUnitType().getName());
            int PUsSpent = 0;
            for (int remainingUnitProduction = this.getUnitProduction(t, data, player); bestDefenseOption.getCost() <= PUsRemaining - PUsSpent && remainingUnitProduction >= bestDefenseOption.getQuantity(); remainingUnitProduction -= bestDefenseOption.getQuantity()) {
                PUsSpent += bestDefenseOption.getCost();
                placeUnits.addAll(bestDefenseOption.getUnitType().create(bestDefenseOption.getQuantity(), player, true));
            }
            LogUtils.log(Level.FINER, "Potential purchased defenders: " + placeUnits);
        }
        return placeUnits;
    }

    public double getMinCostPerHitPoint(PlayerID player, List<ProPurchaseOption> landPurchaseOptions) {
        double minCostPerHitPoint = Double.MAX_VALUE;
        for (ProPurchaseOption ppo : landPurchaseOptions) {
            if (!(ppo.getCostPerHitPoint() < minCostPerHitPoint)) continue;
            minCostPerHitPoint = ppo.getCostPerHitPoint();
        }
        return minCostPerHitPoint;
    }

    public Map<Territory, ProPurchaseTerritory> findPurchaseTerritories(PlayerID player) {
        LogUtils.log(Level.FINE, "Find all purchase territories");
        GameData data = this.ai.getGameData();
        RulesAttachment ra = (RulesAttachment)player.getAttachment("rulesAttatchment");
        List<Object> ownedAndNotConqueredFactoryTerritories = new ArrayList();
        ownedAndNotConqueredFactoryTerritories = ra != null && ra.getPlacementAnyTerritory() ? data.getMap().getTerritoriesOwnedBy(player) : Match.getMatches(data.getMap().getTerritories(), ProMatches.territoryHasInfraFactoryAndIsNotConqueredOwnedLand(player, data));
        ownedAndNotConqueredFactoryTerritories = Match.getMatches(ownedAndNotConqueredFactoryTerritories, ProMatches.territoryCanMoveLandUnits(player, data, false));
        HashMap<Territory, ProPurchaseTerritory> purchaseTerritories = new HashMap<Territory, ProPurchaseTerritory>();
        for (Territory territory : ownedAndNotConqueredFactoryTerritories) {
            int unitProduction = this.getUnitProduction(territory, data, player);
            ProPurchaseTerritory ppt = new ProPurchaseTerritory(territory, data, player, unitProduction);
            purchaseTerritories.put(territory, ppt);
            LogUtils.log(Level.FINER, ppt.toString());
        }
        return purchaseTerritories;
    }

    public int getUnitProduction(Territory territory, GameData data, PlayerID player) {
        CompositeMatchAnd<Unit> factoryMatch = new CompositeMatchAnd<Unit>(Matches.UnitIsOwnedAndIsFactoryOrCanProduceUnits(player), Matches.unitIsBeingTransported().invert());
        if (territory.isWater()) {
            factoryMatch.add(Matches.UnitIsLand.invert());
        } else {
            factoryMatch.add(Matches.UnitIsSea.invert());
        }
        List<Unit> factoryUnits = territory.getUnits().getMatches(factoryMatch);
        TerritoryAttachment ta = TerritoryAttachment.get(territory);
        boolean originalFactory = ta == null ? false : ta.getOriginalFactory();
        boolean playerIsOriginalOwner = factoryUnits.size() > 0 ? player.equals(this.getOriginalFactoryOwner(territory, player)) : false;
        RulesAttachment ra = (RulesAttachment)player.getAttachment("rulesAttatchment");
        if (originalFactory && playerIsOriginalOwner) {
            if (ra != null && ra.getMaxPlacePerTerritory() != -1) {
                return Math.max(0, ra.getMaxPlacePerTerritory());
            }
            return Integer.MAX_VALUE;
        }
        if (ra != null && ra.getPlacementAnyTerritory()) {
            return Integer.MAX_VALUE;
        }
        return TripleAUnit.getProductionPotentialOfTerritory(territory.getUnits().getUnits(), territory, player, data, true, true);
    }

    private PlayerID getOriginalFactoryOwner(Territory territory, PlayerID player) {
        List<Unit> factoryUnits = territory.getUnits().getMatches(Matches.UnitCanProduceUnits);
        if (factoryUnits.size() == 0) {
            throw new IllegalStateException("No factory in territory:" + territory);
        }
        for (Unit factory2 : factoryUnits) {
            if (!player.equals(OriginalOwnerTracker.getOriginalOwner(factory2))) continue;
            return OriginalOwnerTracker.getOriginalOwner(factory2);
        }
        Unit factory = (Unit)factoryUnits.iterator().next();
        return OriginalOwnerTracker.getOriginalOwner(factory);
    }

    public static Comparator<Unit> getCostComparator() {
        return new Comparator<Unit>(){

            @Override
            public int compare(Unit o1, Unit o2) {
                return Double.compare(ProPurchaseUtils.getCost(o1.getType(), o1.getOwner(), o1.getData()), ProPurchaseUtils.getCost(o2.getType(), o2.getOwner(), o2.getData()));
            }
        };
    }

    public static double getCost(UnitType unitType, PlayerID player, GameData data) {
        if (unitType == null) {
            throw new IllegalArgumentException("null unit type");
        }
        if (player == null) {
            throw new IllegalArgumentException("null player id");
        }
        Resource PUs = data.getResourceList().getResource("PUs");
        ProductionRule rule = ProPurchaseUtils.getProductionRule(unitType, player, data);
        if (rule == null) {
            IntegerMap<UnitType> playerCostMap = BattleCalculator.getCostsForTUV(player, data);
            return playerCostMap.getInt(unitType);
        }
        return (double)rule.getCosts().getInt(PUs) / (double)rule.getResults().totalValues();
    }

    public static ProductionRule getProductionRule(UnitType unitType, PlayerID player, GameData data) {
        if (unitType == null) {
            throw new IllegalArgumentException("null unit type");
        }
        if (player == null) {
            throw new IllegalArgumentException("null player id");
        }
        ProductionFrontier frontier = player.getProductionFrontier();
        if (frontier == null) {
            return null;
        }
        for (ProductionRule rule : frontier) {
            if (rule.getResults().getInt(unitType) <= 0) continue;
            return rule;
        }
        return null;
    }

    public static List<Unit> getPlaceUnits(Territory t, Map<Territory, ProPurchaseTerritory> purchaseTerritories) {
        ArrayList<Unit> placeUnits = new ArrayList<Unit>();
        if (purchaseTerritories == null) {
            return placeUnits;
        }
        for (Territory purchaseTerritory : purchaseTerritories.keySet()) {
            for (ProPlaceTerritory ppt : purchaseTerritories.get(purchaseTerritory).getCanPlaceTerritories()) {
                if (!t.equals(ppt.getTerritory())) continue;
                placeUnits.addAll(ppt.getPlaceUnits());
            }
        }
        return placeUnits;
    }
}

