/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.proAI.util;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.ai.proAI.ProAI;
import games.strategy.triplea.ai.proAI.util.ProBattleUtils;
import games.strategy.triplea.ai.proAI.util.ProMatches;
import games.strategy.triplea.ai.proAI.util.ProUtils;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.MoveValidator;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProTerritoryValueUtils {
    private final ProAI ai;
    private final ProUtils utils;
    private final ProBattleUtils battleUtils;

    public ProTerritoryValueUtils(ProAI ai, ProUtils utils, ProBattleUtils battleUtils) {
        this.ai = ai;
        this.utils = utils;
        this.battleUtils = battleUtils;
    }

    public double findTerritoryAttackValue(PlayerID player, Territory t, double minCostPerHitPoint) {
        GameData data = this.ai.getGameData();
        int isEnemyFactory = ProMatches.territoryHasInfraFactoryAndIsEnemyLand(player, data).match(t) ? 1 : 0;
        double value = 3 * TerritoryAttachment.getProduction(t) * (isEnemyFactory + 1);
        if (!t.isWater() && t.getOwner().isNull()) {
            double strength = this.battleUtils.estimateStrength(t.getOwner(), t, new ArrayList<Unit>(t.getUnits().getUnits()), new ArrayList<Unit>(), false);
            double TUVSwing = -(strength / 8.0) * minCostPerHitPoint;
            value += TUVSwing;
        }
        return value;
    }

    public Map<Territory, Double> findTerritoryValues(PlayerID player, double minCostPerHitPoint, List<Territory> territoriesThatCantBeHeld, List<Territory> territoriesToAttack) {
        double capitalOrFactoryValue;
        GameData data = this.ai.getGameData();
        List<Territory> allTerritories = data.getMap().getTerritories();
        HashSet<Territory> enemyCapitalsAndFactories = new HashSet<Territory>();
        enemyCapitalsAndFactories.addAll(Match.getMatches(allTerritories, ProMatches.territoryHasInfraFactoryAndIsOwnedByPlayersOrCantBeHeld(player, data, this.utils.getPotentialEnemyPlayers(player), territoriesThatCantBeHeld)));
        int numPotentialEnemyTerritories = Match.countMatches(allTerritories, Matches.isTerritoryOwnedBy(this.utils.getPotentialEnemyPlayers(player)));
        if (enemyCapitalsAndFactories.size() * 2 >= numPotentialEnemyTerritories) {
            enemyCapitalsAndFactories.clear();
        }
        enemyCapitalsAndFactories.addAll(this.utils.getLiveEnemyCapitals(data, player));
        enemyCapitalsAndFactories.removeAll(territoriesToAttack);
        int maxLandMassSize = 1;
        for (Territory t : allTerritories) {
            int landMassSize;
            if (t.isWater() || (landMassSize = 1 + data.getMap().getNeighbors(t, 6, ProMatches.territoryCanPotentiallyMoveLandUnits(player, data, true)).size()) <= maxLandMassSize) continue;
            maxLandMassSize = landMassSize;
        }
        HashMap<Territory, Double> enemyCapitalsAndFactoriesMap = new HashMap<Territory, Double>();
        for (Territory t : enemyCapitalsAndFactories) {
            int factoryProduction = 0;
            if (ProMatches.territoryHasInfraFactoryAndIsLand(player).match(t)) {
                factoryProduction = TerritoryAttachment.getProduction(t);
            }
            double playerProduction = 0.0;
            TerritoryAttachment ta = TerritoryAttachment.get(t);
            if (ta != null && ta.isCapital()) {
                playerProduction = this.utils.getPlayerProduction(t.getOwner(), data);
            }
            int isNeutral = t.getOwner().isNull() ? 1 : 0;
            int landMassSize = 1 + data.getMap().getNeighbors(t, 6, ProMatches.territoryCanPotentiallyMoveLandUnits(player, data, true)).size();
            double value = Math.sqrt((double)factoryProduction + Math.sqrt(playerProduction)) * 32.0 / (double)(1 + 3 * isNeutral) * (double)landMassSize / (double)maxLandMassSize;
            enemyCapitalsAndFactoriesMap.put(t, value);
        }
        HashMap<Territory, Double> territoryValueMap = new HashMap<Territory, Double>();
        for (Territory t : allTerritories) {
            if (!t.isWater() && !territoriesThatCantBeHeld.contains(t)) {
                ArrayList<Double> values = new ArrayList<Double>();
                for (Territory enemyCapitalOrFactory : enemyCapitalsAndFactoriesMap.keySet()) {
                    int distance = data.getMap().getDistance(t, enemyCapitalOrFactory, ProMatches.territoryCanPotentiallyMoveLandUnits(player, data, true));
                    if (distance <= 0) continue;
                    values.add((Double)enemyCapitalsAndFactoriesMap.get(enemyCapitalOrFactory) / Math.pow(2.0, distance));
                }
                Collections.sort(values, Collections.reverseOrder());
                capitalOrFactoryValue = 0.0;
                for (int i = 0; i < values.size(); ++i) {
                    capitalOrFactoryValue += (Double)values.get(i) / Math.pow(2.0, i);
                }
                double nearbyEnemyValue = 0.0;
                Set<Territory> nearbyTerritories = data.getMap().getNeighbors(t, 2, ProMatches.territoryCanPotentiallyMoveLandUnits(player, data, true));
                List<Territory> nearbyEnemyTerritories = Match.getMatches(nearbyTerritories, ProMatches.territoryIsEnemyOrCantBeHeld(player, data, territoriesThatCantBeHeld));
                nearbyEnemyTerritories.removeAll(territoriesToAttack);
                for (Territory nearbyEnemyTerritory : nearbyEnemyTerritories) {
                    int distance = data.getMap().getDistance(t, nearbyEnemyTerritory, ProMatches.territoryCanPotentiallyMoveLandUnits(player, data, true));
                    if (distance <= 0) continue;
                    double value = TerritoryAttachment.getProduction(nearbyEnemyTerritory);
                    if (nearbyEnemyTerritory.getOwner().isNull()) {
                        value = this.findTerritoryAttackValue(player, nearbyEnemyTerritory, minCostPerHitPoint) / 3.0;
                    } else if (ProMatches.territoryIsAlliedLandAndHasNoEnemyNeighbors(player, data).match(nearbyEnemyTerritory)) {
                        value *= 0.1;
                    }
                    if (!(value > 0.0)) continue;
                    nearbyEnemyValue += value / Math.pow(2.0, distance);
                }
                int landMassSize = 1 + data.getMap().getNeighbors(t, 6, ProMatches.territoryCanPotentiallyMoveLandUnits(player, data, true)).size();
                double value = nearbyEnemyValue * (double)landMassSize / (double)maxLandMassSize + capitalOrFactoryValue;
                if (ProMatches.territoryHasInfraFactoryAndIsLand(player).match(t)) {
                    value *= 1.1;
                }
                territoryValueMap.put(t, value);
                continue;
            }
            if (t.isWater()) continue;
            territoryValueMap.put(t, 0.0);
        }
        for (Territory t : allTerritories) {
            if (!territoriesThatCantBeHeld.contains(t) && t.isWater() && !data.getMap().getNeighbors(t, Matches.TerritoryIsWater).isEmpty()) {
                ArrayList<Double> values = new ArrayList<Double>();
                for (Territory enemyCapitalOrFactory : enemyCapitalsAndFactoriesMap.keySet()) {
                    int distance;
                    Route route = data.getMap().getRoute_IgnoreEnd(t, enemyCapitalOrFactory, ProMatches.territoryCanMoveSeaUnits(player, data, true));
                    if (route == null || MoveValidator.validateCanal(route, null, player, data) != null || (distance = route.numberOfSteps()) <= 0) continue;
                    values.add((Double)enemyCapitalsAndFactoriesMap.get(enemyCapitalOrFactory) / Math.pow(2.0, distance));
                }
                Collections.sort(values, Collections.reverseOrder());
                capitalOrFactoryValue = 0.0;
                for (int i = 0; i < values.size(); ++i) {
                    capitalOrFactoryValue += (Double)values.get(i) / Math.pow(2.0, i);
                }
                double nearbyLandValue = 0.0;
                Set<Territory> nearbyTerritories = data.getMap().getNeighbors(t, 3);
                List<Territory> nearbyLandTerritories = Match.getMatches(nearbyTerritories, ProMatches.territoryCanPotentiallyMoveLandUnits(player, data, false));
                nearbyLandTerritories.removeAll(territoriesToAttack);
                for (Territory nearbyLandTerritory : nearbyLandTerritories) {
                    int distance;
                    Route route = data.getMap().getRoute_IgnoreEnd(t, nearbyLandTerritory, ProMatches.territoryCanMoveSeaUnits(player, data, true));
                    if (route == null || MoveValidator.validateCanal(route, null, player, data) != null || (distance = route.numberOfSteps()) <= 0 || distance > 3) continue;
                    if (ProMatches.territoryIsEnemyOrCantBeHeld(player, data, territoriesThatCantBeHeld).match(nearbyLandTerritory)) {
                        double value = TerritoryAttachment.getProduction(nearbyLandTerritory);
                        if (nearbyLandTerritory.getOwner().isNull()) {
                            value = this.findTerritoryAttackValue(player, nearbyLandTerritory, minCostPerHitPoint);
                        }
                        nearbyLandValue += value;
                    }
                    nearbyLandValue += ((Double)territoryValueMap.get(nearbyLandTerritory)).doubleValue();
                }
                double value = capitalOrFactoryValue / 100.0 + nearbyLandValue / 10.0;
                territoryValueMap.put(t, value);
                continue;
            }
            if (!t.isWater()) continue;
            territoryValueMap.put(t, 0.0);
        }
        return territoryValueMap;
    }

    public Map<Territory, Double> findSeaTerritoryValues(PlayerID player, List<Territory> territoriesThatCantBeHeld) {
        GameData data = this.ai.getGameData();
        List<Territory> allTerritories = data.getMap().getTerritories();
        HashMap<Territory, Double> territoryValueMap = new HashMap<Territory, Double>();
        for (Territory t : allTerritories) {
            if (!territoriesThatCantBeHeld.contains(t) && t.isWater() && !data.getMap().getNeighbors(t, Matches.TerritoryIsWater).isEmpty()) {
                double nearbySeaProductionValue = 0.0;
                Set<Territory> nearbySeaTerritories = data.getMap().getNeighbors(t, 4, ProMatches.territoryCanMoveSeaUnits(player, data, true));
                List<Territory> nearbyEnemySeaTerritories = Match.getMatches(nearbySeaTerritories, ProMatches.territoryIsEnemyOrCantBeHeld(player, data, territoriesThatCantBeHeld));
                for (Territory nearbyEnemySeaTerritory : nearbyEnemySeaTerritories) {
                    int distance;
                    Route route = data.getMap().getRoute_IgnoreEnd(t, nearbyEnemySeaTerritory, ProMatches.territoryCanMoveSeaUnits(player, data, true));
                    if (route == null || MoveValidator.validateCanal(route, null, player, data) != null || (distance = route.numberOfSteps()) <= 0) continue;
                    nearbySeaProductionValue += (double)TerritoryAttachment.getProduction(nearbyEnemySeaTerritory) / Math.pow(2.0, distance);
                }
                double nearbyEnemySeaUnitValue = 0.0;
                List<Territory> nearbyEnemySeaUnitTerritories = Match.getMatches(nearbySeaTerritories, Matches.territoryHasEnemyUnits(player, data));
                for (Territory nearbyEnemySeaTerritory : nearbyEnemySeaUnitTerritories) {
                    int distance;
                    Route route = data.getMap().getRoute_IgnoreEnd(t, nearbyEnemySeaTerritory, ProMatches.territoryCanMoveSeaUnits(player, data, true));
                    if (route == null || MoveValidator.validateCanal(route, null, player, data) != null || (distance = route.numberOfSteps()) <= 0) continue;
                    nearbyEnemySeaUnitValue += (double)nearbyEnemySeaTerritory.getUnits().countMatches(Matches.unitIsEnemyOf(data, player)) / Math.pow(2.0, distance);
                }
                double value = 100.0 * nearbySeaProductionValue + nearbyEnemySeaUnitValue;
                territoryValueMap.put(t, value);
                continue;
            }
            if (!t.isWater()) continue;
            territoryValueMap.put(t, 0.0);
        }
        return territoryValueMap;
    }
}

