/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.proAI.util;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.ai.AdvancedUtils;
import games.strategy.triplea.ai.proAI.ProAI;
import games.strategy.triplea.ai.proAI.ProAttackTerritoryData;
import games.strategy.triplea.ai.proAI.ProPurchaseOption;
import games.strategy.triplea.ai.proAI.util.ProMatches;
import games.strategy.triplea.ai.proAI.util.ProUtils;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.attatchments.UnitSupportAttachment;
import games.strategy.triplea.delegate.AirMovementValidator;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.TransportTracker;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProTransportUtils {
    private final ProAI ai;
    private final ProUtils utils;

    public ProTransportUtils(ProAI ai, ProUtils utils) {
        this.ai = ai;
        this.utils = utils;
    }

    public int findMaxMovementForTransports(List<ProPurchaseOption> seaTransportPurchaseOptions) {
        int maxMovement = 2;
        boolean maxTransportEfficiency = false;
        for (ProPurchaseOption ppo : seaTransportPurchaseOptions) {
            if (!(ppo.getTransportEfficiency() > 0.0)) continue;
            maxMovement = ppo.getMovement();
        }
        return maxMovement;
    }

    public int findNumUnitsThatCanBeTransported(PlayerID player, Territory t) {
        GameData data = this.ai.getGameData();
        int numUnitsToLoad = 0;
        Set<Territory> neighbors = data.getMap().getNeighbors(t, Matches.TerritoryIsLand);
        for (Territory neighbor : neighbors) {
            numUnitsToLoad += Match.getMatches(neighbor.getUnits().getUnits(), ProMatches.unitIsOwnedTransportableUnit(player)).size();
        }
        return numUnitsToLoad;
    }

    public List<Unit> getUnitsToTransportThatCantMoveToHigherValue(PlayerID player, Unit transport, Set<Territory> territoriesToLoadFrom, List<Unit> unitsToIgnore, Map<Territory, ProAttackTerritoryData> moveMap, Map<Unit, Set<Territory>> unitMoveMap, double value) {
        ArrayList<Unit> unitsToIgnoreOrHaveBetterLandMove = new ArrayList<Unit>(unitsToIgnore);
        if (!TransportTracker.isTransporting(transport)) {
            ArrayList<Unit> units = new ArrayList<Unit>();
            for (Territory loadFrom : territoriesToLoadFrom) {
                units.addAll(loadFrom.getUnits().getMatches(ProMatches.unitIsOwnedTransportableUnitAndCanBeLoaded(player, true)));
            }
            units.removeAll(unitsToIgnore);
            block1: for (Unit u : units) {
                if (unitMoveMap.get(u) == null) continue;
                for (Territory t : unitMoveMap.get(u)) {
                    if (moveMap.get(t) == null || !(moveMap.get(t).getValue() > value)) continue;
                    unitsToIgnoreOrHaveBetterLandMove.add(u);
                    continue block1;
                }
            }
        }
        return this.getUnitsToTransportFromTerritories(player, transport, territoriesToLoadFrom, unitsToIgnoreOrHaveBetterLandMove);
    }

    public List<Unit> getUnitsToTransportFromTerritories(PlayerID player, Unit transport, Set<Territory> territoriesToLoadFrom, List<Unit> unitsToIgnore) {
        return this.getUnitsToTransportFromTerritories(player, transport, territoriesToLoadFrom, unitsToIgnore, ProMatches.unitIsOwnedTransportableUnitAndCanBeLoaded(player, true));
    }

    public List<Unit> getUnitsToTransportFromTerritories(final PlayerID player, Unit transport, Set<Territory> territoriesToLoadFrom, List<Unit> unitsToIgnore, Match<Unit> validUnitMatch) {
        ArrayList<Unit> selectedUnits = new ArrayList<Unit>();
        if (TransportTracker.isTransporting(transport)) {
            selectedUnits.addAll(TransportTracker.transporting(transport));
        } else {
            ArrayList<Unit> units = new ArrayList<Unit>();
            for (Territory loadFrom : territoriesToLoadFrom) {
                units.addAll(loadFrom.getUnits().getMatches(validUnitMatch));
            }
            units.removeAll(unitsToIgnore);
            Collections.sort(units, new Comparator<Unit>(){

                @Override
                public int compare(Unit o1, Unit o2) {
                    Set<UnitSupportAttachment> supportAttachments1 = UnitSupportAttachment.get(o1.getType());
                    int maxSupport1 = 0;
                    for (UnitSupportAttachment usa : supportAttachments1) {
                        if (!usa.getAllied() || !usa.getOffence() || usa.getBonus() <= maxSupport1) continue;
                        maxSupport1 = usa.getBonus();
                    }
                    int attack1 = UnitAttachment.get(o1.getType()).getAttack(player) + maxSupport1;
                    Set<UnitSupportAttachment> supportAttachments2 = UnitSupportAttachment.get(o2.getType());
                    int maxSupport2 = 0;
                    for (UnitSupportAttachment usa : supportAttachments2) {
                        if (!usa.getAllied() || !usa.getOffence() || usa.getBonus() <= maxSupport2) continue;
                        maxSupport2 = usa.getBonus();
                    }
                    int attack2 = UnitAttachment.get(o2.getType()).getAttack(player) + maxSupport2;
                    return attack2 - attack1;
                }
            });
            selectedUnits.addAll(this.selectUnitsToTransportFromList(transport, units));
        }
        return selectedUnits;
    }

    public List<Unit> selectUnitsToTransportFromList(Unit transport, List<Unit> units) {
        ArrayList<Unit> selectedUnits = new ArrayList<Unit>();
        int capacity = UnitAttachment.get(transport.getType()).getTransportCapacity();
        int capacityCount = 0;
        for (Unit unit : units) {
            int cost = UnitAttachment.get(unit.getType()).getTransportCost();
            if (cost > capacity - capacityCount) continue;
            selectedUnits.add(unit);
            if ((capacityCount += cost) < capacity) continue;
            break;
        }
        return selectedUnits;
    }

    public int findUnitsTransportCost(List<Unit> units) {
        int transportCost = 0;
        for (Unit unit : units) {
            transportCost += UnitAttachment.get(unit.getType()).getTransportCost();
        }
        return transportCost;
    }

    public boolean validateCarrierCapacity(PlayerID player, Territory t, List<Unit> existingUnits, Unit newUnit) {
        GameData data = this.ai.getGameData();
        int capacity = AirMovementValidator.carrierCapacity(existingUnits, t);
        List<Unit> airUnits = Match.getMatches(existingUnits, ProMatches.unitIsAlliedAir(player, data));
        airUnits.add(newUnit);
        for (Unit airUnit : airUnits) {
            UnitAttachment ua = UnitAttachment.get(airUnit.getType());
            int cost = ua.getCarrierCost();
            if (cost == -1) continue;
            capacity -= cost;
        }
        return capacity >= 0;
    }

    public int getUnusedLocalCarrierCapacity(PlayerID player, Territory t, List<Unit> unitsToPlace) {
        GameData data = this.ai.getGameData();
        Set<Territory> nearbyTerritories = data.getMap().getNeighbors(t, 2, ProMatches.territoryCanMoveAirUnits(player, data, false));
        nearbyTerritories.add(t);
        ArrayList<Unit> ownedNearbyUnits = new ArrayList<Unit>();
        int capacity = 0;
        for (Territory nearbyTerritory : nearbyTerritories) {
            List<Unit> units = nearbyTerritory.getUnits().getMatches(Matches.unitIsOwnedBy(player));
            if (nearbyTerritory.equals(t)) {
                units.addAll(unitsToPlace);
            }
            ownedNearbyUnits.addAll(units);
            capacity += AirMovementValidator.carrierCapacity(units, t);
        }
        List<Unit> airUnits = Match.getMatches(ownedNearbyUnits, ProMatches.unitIsOwnedAir(player));
        for (Unit airUnit : airUnits) {
            UnitAttachment ua = UnitAttachment.get(airUnit.getType());
            int cost = ua.getCarrierCost();
            if (cost == -1) continue;
            capacity -= cost;
        }
        return capacity;
    }

    public int getUnusedCarrierCapacity(PlayerID player, Territory t, List<Unit> unitsToPlace) {
        ArrayList<Unit> units = new ArrayList<Unit>(unitsToPlace);
        units.addAll(t.getUnits().getUnits());
        int capacity = AirMovementValidator.carrierCapacity(units, t);
        List<Unit> airUnits = Match.getMatches(units, ProMatches.unitIsOwnedAir(player));
        for (Unit airUnit : airUnits) {
            UnitAttachment ua = UnitAttachment.get(airUnit.getType());
            int cost = ua.getCarrierCost();
            if (cost == -1) continue;
            capacity -= cost;
        }
        return capacity;
    }

    public static List<Unit> InterleaveUnits_CarriersAndPlanes(List<Unit> units, int planesThatDontNeedToLand) {
        if (!Match.someMatch(units, Matches.UnitIsCarrier) || !Match.someMatch(units, Matches.UnitCanLandOnCarrier)) {
            return units;
        }
        ArrayList<Unit> result = new ArrayList<Unit>(units);
        Unit seekedCarrier = null;
        int indexToPlaceCarrierAt = -1;
        int spaceLeftOnSeekedCarrier = -1;
        int processedPlaneCount = 0;
        ArrayList<Unit> filledCarriers = new ArrayList<Unit>();
        for (int i = result.size() - 1; i >= 0; --i) {
            Unit unit = result.get(i);
            UnitAttachment ua = UnitAttachment.get(unit.getUnitType());
            if (ua.getCarrierCost() <= 0 && i != 0) continue;
            if (processedPlaneCount < planesThatDontNeedToLand && i > 0) {
                ++processedPlaneCount;
                continue;
            }
            if (seekedCarrier == null && i > 0) {
                int seekedCarrierIndex = AdvancedUtils.getIndexOfLastUnitMatching(result, new CompositeMatchAnd<Unit>(Matches.UnitIsCarrier, Matches.isNotInList(filledCarriers)), result.size() - 1);
                if (seekedCarrierIndex == -1) break;
                seekedCarrier = result.get(seekedCarrierIndex);
                indexToPlaceCarrierAt = i + 1;
                spaceLeftOnSeekedCarrier = UnitAttachment.get(seekedCarrier.getUnitType()).getCarrierCapacity();
            }
            if (ua.getCarrierCost() > 0) {
                spaceLeftOnSeekedCarrier -= ua.getCarrierCost();
            }
            if (indexToPlaceCarrierAt <= 0 || spaceLeftOnSeekedCarrier > 0 && i != 0) continue;
            if (spaceLeftOnSeekedCarrier < 0) {
                ++i;
            }
            if (result.indexOf(seekedCarrier) < i) {
                result.remove(seekedCarrier);
                result.add(indexToPlaceCarrierAt - 1, seekedCarrier);
                --i;
                filledCarriers.add(seekedCarrier);
                seekedCarrier = AdvancedUtils.getLastUnitMatching(result, new CompositeMatchAnd<Unit>(Matches.UnitIsCarrier, Matches.isNotInList(filledCarriers)), result.size() - 1);
                if (seekedCarrier == null) break;
                indexToPlaceCarrierAt = i;
                spaceLeftOnSeekedCarrier = UnitAttachment.get(seekedCarrier.getUnitType()).getCarrierCapacity();
                continue;
            }
            int oldIndex = result.indexOf(seekedCarrier);
            int carrierPlaceLocation = indexToPlaceCarrierAt;
            result.remove(seekedCarrier);
            if (oldIndex < indexToPlaceCarrierAt) {
                --carrierPlaceLocation;
            }
            result.add(carrierPlaceLocation, seekedCarrier);
            filledCarriers.add(seekedCarrier);
            ArrayList<Unit> planesBetweenHereAndCarrier = new ArrayList<Unit>();
            for (int i2 = i; i2 < carrierPlaceLocation; ++i2) {
                Unit unit2 = result.get(i2);
                UnitAttachment ua2 = UnitAttachment.get(unit2.getUnitType());
                if (ua2.getCarrierCost() <= 0) continue;
                planesBetweenHereAndCarrier.add(unit2);
            }
            Collections.reverse(planesBetweenHereAndCarrier);
            int planeMoveCount = 0;
            for (Unit plane : planesBetweenHereAndCarrier) {
                result.remove(plane);
                result.add(carrierPlaceLocation - 1, plane);
                ++planeMoveCount;
            }
            seekedCarrier = AdvancedUtils.getLastUnitMatching(result, new CompositeMatchAnd<Unit>(Matches.UnitIsCarrier, Matches.isNotInList(filledCarriers)), result.size() - 1);
            if (seekedCarrier == null) break;
            indexToPlaceCarrierAt = carrierPlaceLocation - planeMoveCount;
            spaceLeftOnSeekedCarrier = UnitAttachment.get(seekedCarrier.getUnitType()).getCarrierCapacity();
        }
        return result;
    }
}

