/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.proAI.util;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameStep;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.RelationshipTracker;
import games.strategy.engine.data.RelationshipType;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.Properties;
import games.strategy.triplea.ai.proAI.ProAI;
import games.strategy.triplea.ai.proAI.util.ProMatches;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.ui.AbstractUIContext;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProUtils {
    private final ProAI ai;

    public ProUtils(ProAI ai) {
        this.ai = ai;
    }

    public Map<Unit, Territory> createUnitTerritoryMap(PlayerID player) {
        List<Territory> allTerritories = this.ai.getGameData().getMap().getTerritories();
        List<Territory> myUnitTerritories = Match.getMatches(allTerritories, Matches.territoryHasUnitsOwnedBy(player));
        HashMap<Unit, Territory> unitTerritoryMap = new HashMap<Unit, Territory>();
        for (Territory t : myUnitTerritories) {
            List<Unit> myUnits = t.getUnits().getMatches(Matches.unitIsOwnedBy(player));
            for (Unit u : myUnits) {
                unitTerritoryMap.put(u, t);
            }
        }
        return unitTerritoryMap;
    }

    public List<PlayerID> getEnemyPlayers(PlayerID player) {
        GameData data = this.ai.getGameData();
        ArrayList<PlayerID> enemyPlayers = new ArrayList<PlayerID>();
        for (PlayerID players : data.getPlayerList().getPlayers()) {
            if (data.getRelationshipTracker().isAllied(player, players)) continue;
            enemyPlayers.add(players);
        }
        return enemyPlayers;
    }

    public List<PlayerID> getAlliedPlayers(PlayerID player) {
        GameData data = this.ai.getGameData();
        ArrayList<PlayerID> alliedPlayers = new ArrayList<PlayerID>();
        for (PlayerID players : data.getPlayerList().getPlayers()) {
            if (!data.getRelationshipTracker().isAllied(player, players)) continue;
            alliedPlayers.add(players);
        }
        return alliedPlayers;
    }

    public List<PlayerID> getPotentialEnemyPlayers(PlayerID player) {
        GameData data = this.ai.getGameData();
        List<PlayerID> otherPlayers = data.getPlayerList().getPlayers();
        Iterator<PlayerID> it = otherPlayers.iterator();
        while (it.hasNext()) {
            PlayerID otherPlayer = it.next();
            RelationshipType relation = data.getRelationshipTracker().getRelationshipType(player, otherPlayer);
            if (!Matches.RelationshipTypeIsAllied.match(relation) && !this.isNeutralPlayer(otherPlayer)) continue;
            it.remove();
        }
        return otherPlayers;
    }

    public double getPlayerProduction(PlayerID player, GameData data) {
        int rVal = 0;
        for (Territory place : data.getMap().getTerritories()) {
            if (!place.getOwner().equals(player) || !Matches.territoryCanCollectIncomeFrom(player, data).match(place)) continue;
            rVal += TerritoryAttachment.getProduction(place);
        }
        return rVal *= Properties.getPU_Multiplier(data);
    }

    public List<Territory> getLiveEnemyCapitals(GameData data, PlayerID player) {
        ArrayList<Territory> enemyCapitals = new ArrayList<Territory>();
        List<PlayerID> ePlayers = this.getEnemyPlayers(player);
        for (PlayerID otherPlayer : ePlayers) {
            enemyCapitals.addAll(TerritoryAttachment.getAllCurrentlyOwnedCapitals(otherPlayer, data));
        }
        enemyCapitals.retainAll(Match.getMatches(enemyCapitals, Matches.TerritoryIsNotImpassableToLandUnits(player, data)));
        enemyCapitals.retainAll(Match.getMatches(enemyCapitals, Matches.isTerritoryOwnedBy(this.getPotentialEnemyPlayers(player))));
        return enemyCapitals;
    }

    public List<Territory> getLiveAlliedCapitals(GameData data, PlayerID player) {
        ArrayList<Territory> capitals = new ArrayList<Territory>();
        List<PlayerID> players = this.getAlliedPlayers(player);
        for (PlayerID alliedPlayer : players) {
            capitals.addAll(TerritoryAttachment.getAllCurrentlyOwnedCapitals(alliedPlayer, data));
        }
        capitals.retainAll(Match.getMatches(capitals, Matches.TerritoryIsNotImpassableToLandUnits(player, data)));
        capitals.retainAll(Match.getMatches(capitals, Matches.isTerritoryAllied(player, data)));
        return capitals;
    }

    public int getClosestEnemyLandTerritoryDistance(GameData data, PlayerID player, Territory t) {
        Set<Territory> landTerritories = data.getMap().getNeighbors(t, 9, ProMatches.territoryCanPotentiallyMoveLandUnits(player, data, true));
        List<Territory> enemyLandTerritories = Match.getMatches(landTerritories, Matches.isTerritoryOwnedBy(this.getPotentialEnemyPlayers(player)));
        int minDistance = 10;
        for (Territory enemyLandTerritory : enemyLandTerritories) {
            int distance = data.getMap().getDistance(t, enemyLandTerritory, ProMatches.territoryCanPotentiallyMoveLandUnits(player, data, true));
            if (distance >= minDistance) continue;
            minDistance = distance;
        }
        if (minDistance < 10) {
            return minDistance;
        }
        return -1;
    }

    public int getClosestEnemyOrNeutralLandTerritoryDistance(GameData data, PlayerID player, Territory t, Map<Territory, Double> territoryValueMap) {
        Set<Territory> landTerritories = data.getMap().getNeighbors(t, 9, ProMatches.territoryCanPotentiallyMoveLandUnits(player, data, true));
        List<Territory> enemyLandTerritories = Match.getMatches(landTerritories, Matches.isTerritoryOwnedBy(this.getEnemyPlayers(player)));
        int minDistance = 10;
        for (Territory enemyLandTerritory : enemyLandTerritories) {
            if (territoryValueMap.get(enemyLandTerritory) <= 0.0) continue;
            int distance = data.getMap().getDistance(t, enemyLandTerritory, ProMatches.territoryCanPotentiallyMoveLandUnits(player, data, true));
            if (enemyLandTerritory.getOwner().isNull()) {
                ++distance;
            }
            if (distance >= minDistance) continue;
            minDistance = distance;
        }
        if (minDistance < 10) {
            return minDistance;
        }
        return -1;
    }

    public int getClosestEnemyLandTerritoryDistanceOverWater(GameData data, PlayerID player, Territory t) {
        Set<Territory> neighborTerritories = data.getMap().getNeighbors(t, 9);
        List<Territory> enemyOrAdjacentLandTerritories = Match.getMatches(neighborTerritories, ProMatches.territoryIsOrAdjacentToEnemyNotNeutralLand(player, data));
        int minDistance = 10;
        for (Territory enemyLandTerritory : enemyOrAdjacentLandTerritories) {
            int distance = data.getMap().getDistance_IgnoreEndForCondition(t, enemyLandTerritory, Matches.TerritoryIsWater);
            if (distance <= 0 || distance >= minDistance) continue;
            minDistance = distance;
        }
        if (minDistance < 10) {
            return minDistance;
        }
        return -1;
    }

    public boolean isFFA(GameData data, PlayerID player) {
        RelationshipTracker relationshipTracker = data.getRelationshipTracker();
        Set<PlayerID> enemies = relationshipTracker.getEnemies(player);
        for (PlayerID enemy : enemies) {
            if (!relationshipTracker.isAtWarWithAnyOfThesePlayers(enemy, enemies)) continue;
            return true;
        }
        return false;
    }

    public boolean isNeutralPlayer(PlayerID player) {
        GameData data = this.ai.getGameData();
        for (GameStep gameStep : data.getSequence()) {
            if (!player.equals(gameStep.getPlayerID())) continue;
            return false;
        }
        return true;
    }

    public void pause() {
        try {
            Thread.sleep(AbstractUIContext.getAIPauseDuration());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

