/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.strongAI;

import games.strategy.engine.data.DefaultNamed;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.NamedAttachable;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.RepairRule;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.TechnologyFrontier;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.gamePlayer.IGamePlayer;
import games.strategy.net.GUID;
import games.strategy.triplea.Properties;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.ai.AbstractAI;
import games.strategy.triplea.ai.AdvancedUtils;
import games.strategy.triplea.ai.strongAI.SUtils;
import games.strategy.triplea.ai.strongAI.StrengthEvaluator;
import games.strategy.triplea.attatchments.RulesAttachment;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.AirMovementValidator;
import games.strategy.triplea.delegate.BattleDelegate;
import games.strategy.triplea.delegate.DelegateFinder;
import games.strategy.triplea.delegate.IBattle;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.MoveValidator;
import games.strategy.triplea.delegate.TechAdvance;
import games.strategy.triplea.delegate.TransportTracker;
import games.strategy.triplea.delegate.dataObjects.BattleListing;
import games.strategy.triplea.delegate.dataObjects.PlaceableUnits;
import games.strategy.triplea.delegate.remote.IAbstractPlaceDelegate;
import games.strategy.triplea.delegate.remote.IBattleDelegate;
import games.strategy.triplea.delegate.remote.IMoveDelegate;
import games.strategy.triplea.delegate.remote.IPurchaseDelegate;
import games.strategy.triplea.delegate.remote.ITechDelegate;
import games.strategy.triplea.player.ITripleaPlayer;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.CompositeMatchOr;
import games.strategy.util.IntegerMap;
import games.strategy.util.InverseMatch;
import games.strategy.util.Match;
import games.strategy.util.Tuple;
import games.strategy.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class StrongAI
extends AbstractAI
implements IGamePlayer,
ITripleaPlayer {
    private static final Logger s_logger = Logger.getLogger(StrongAI.class.getName());
    private Territory m_factTerr = null;
    private Territory m_seaTerr = null;
    private Territory m_myCapital = null;
    private List<Territory> m_transportDropOffLocales = new ArrayList<Territory>();
    private final boolean m_AE = false;
    private boolean m_transports_may_die = true;
    private boolean m_cap_danger = false;
    private boolean m_natObjective = false;
    private boolean m_bought_Attack_Ships = false;
    private boolean m_keep_Ships_At_Base = false;
    private boolean m_bought_Transports = false;
    private boolean m_onOffense = false;
    private HashMap<Territory, Territory> amphibMap = new HashMap();
    private HashMap<Territory, Collection<Unit>> shipsMovedMap = new HashMap();
    private final Collection<Territory> m_seaTerrAttacked = new ArrayList<Territory>();
    private final Collection<Territory> m_landTerrAttacked = new ArrayList<Territory>();
    private final Collection<Territory> m_impassableTerrs = new ArrayList<Territory>();
    public static final Match<Unit> Transporting = new Match<Unit>(){

        @Override
        public boolean match(Unit o) {
            return TripleAUnit.get(o).getTransporting().size() > 0;
        }
    };

    public StrongAI(String name, String type) {
        super(name, type);
    }

    private void set_onOffense(boolean value) {
        this.m_onOffense = value;
    }

    private boolean get_onOffense() {
        return this.m_onOffense;
    }

    private void getEdition() {
        GameData data = this.getPlayerBridge().getGameData();
        this.m_transports_may_die = !Properties.getTransportCasualtiesRestricted(data);
        this.m_natObjective = Properties.getNationalObjectives(data);
    }

    private void setImpassableTerrs(PlayerID player) {
        GameData data = this.getPlayerBridge().getGameData();
        this.m_impassableTerrs.clear();
        for (Territory t : data.getMap().getTerritories()) {
            if (!Matches.TerritoryIsPassableAndNotRestricted(player, data).invert().match(t) || !Matches.TerritoryIsLand.match(t)) continue;
            this.m_impassableTerrs.add(t);
        }
    }

    private Collection<Territory> getImpassableTerrs() {
        return this.m_impassableTerrs;
    }

    private boolean transportsMayDieFirst() {
        return this.m_transports_may_die;
    }

    private void setAttackShipPurchase(boolean doBuyAttackShip) {
        this.m_bought_Attack_Ships = doBuyAttackShip;
    }

    private boolean getAttackShipPurchase() {
        return this.m_bought_Attack_Ships;
    }

    private void setDidPurchaseTransports(boolean didBuyTransports) {
        this.m_bought_Transports = didBuyTransports;
    }

    private boolean getDidPurchaseTransports() {
        return this.m_bought_Transports;
    }

    private void setTransportDropOffLocales(List<Territory> transportDropOffLocales) {
        this.m_transportDropOffLocales = transportDropOffLocales;
    }

    private List<Territory> getTransportDropOffLocales() {
        return this.m_transportDropOffLocales;
    }

    private void setSeaTerrAttacked(Collection<Territory> seaTerr) {
        this.m_seaTerrAttacked.addAll(seaTerr);
    }

    private void clearSeaTerrAttacked() {
        this.m_seaTerrAttacked.clear();
    }

    private List<Territory> getSeaTerrAttacked() {
        ArrayList<Territory> seaTerr = new ArrayList<Territory>(this.m_seaTerrAttacked);
        return seaTerr;
    }

    private void setLandTerrAttacked(Collection<Territory> landTerr) {
        this.m_landTerrAttacked.addAll(landTerr);
    }

    private void clearLandTerrAttacked() {
        this.m_landTerrAttacked.clear();
    }

    private List<Territory> getLandTerrAttacked() {
        ArrayList<Territory> landTerr = new ArrayList<Territory>(this.m_landTerrAttacked);
        return landTerr;
    }

    private void setSeaTerr(Territory seaTerr) {
        this.m_seaTerr = seaTerr;
    }

    private Territory getSeaTerr() {
        return this.m_seaTerr;
    }

    private void setKeepShipsAtBase(boolean keep) {
        this.m_keep_Ships_At_Base = keep;
    }

    private boolean getKeepShipsAtBase() {
        return this.m_keep_Ships_At_Base;
    }

    private boolean useProductionData() {
        return false;
    }

    private void setFactory(Territory t) {
        this.m_factTerr = t;
    }

    private Territory getFactory() {
        return this.m_factTerr;
    }

    private HashMap<Territory, Territory> getAmphibMap() {
        return this.amphibMap;
    }

    private void setAmphibMap(HashMap<Territory, Territory> xAmphibMap) {
        this.amphibMap = xAmphibMap;
    }

    private HashMap<Territory, Collection<Unit>> getShipsMovedMap() {
        return this.shipsMovedMap;
    }

    private void setShipsMovedMap(HashMap<Territory, Collection<Unit>> xMovedMap) {
        this.shipsMovedMap = xMovedMap;
    }

    private void setCapDanger(Boolean danger) {
        this.m_cap_danger = danger;
    }

    private boolean getCapDanger() {
        return this.m_cap_danger;
    }

    private boolean getNationalObjectives() {
        return this.m_natObjective;
    }

    @Override
    protected void tech(ITechDelegate techDelegate, GameData data, PlayerID player) {
        if (!Properties.getWW2V3TechModel(data)) {
            return;
        }
        long last = System.currentTimeMillis();
        s_logger.fine("Doing Tech ");
        Territory myCapitol = TerritoryAttachment.getFirstOwnedCapitalOrFirstUnownedCapital(player, data);
        float eStrength = SUtils.getStrengthOfPotentialAttackers(myCapitol, data, player, false, true, null);
        float myStrength = SUtils.strength(myCapitol.getUnits().getUnits(), false, false, false);
        List<Territory> areaStrength = SUtils.getNeighboringLandTerritories(data, player, myCapitol);
        for (Territory areaTerr : areaStrength) {
            myStrength += SUtils.strength(areaTerr.getUnits().getUnits(), false, false, false) * 0.75f;
        }
        boolean capDanger = myStrength < eStrength * 1.25f + 3.0f;
        Resource pus = data.getResourceList().getResource("PUs");
        int PUs = player.getResources().getQuantity(pus);
        Resource techtokens = data.getResourceList().getResource("techTokens");
        int TechTokens = player.getResources().getQuantity(techtokens);
        int TokensToBuy = 0;
        if (!capDanger && TechTokens < 3 && (double)PUs > Math.random() * 160.0) {
            TokensToBuy = 1;
        }
        if (TechTokens > 0 || TokensToBuy > 0) {
            List<TechnologyFrontier> cats = TechAdvance.getPlayerTechCategories(data, player);
            if (data.getTechnologyFrontier().isEmpty()) {
                if (Math.random() > 0.35) {
                    techDelegate.rollTech(TechTokens + TokensToBuy, cats.get(1), TokensToBuy, null);
                } else {
                    techDelegate.rollTech(TechTokens + TokensToBuy, cats.get(0), TokensToBuy, null);
                }
            } else {
                int rand = (int)(Math.random() * (double)cats.size());
                techDelegate.rollTech(TechTokens + TokensToBuy, cats.get(rand), TokensToBuy, null);
            }
        }
        long now = System.currentTimeMillis();
        s_logger.finest("Time Taken " + (now - last));
    }

    private Route getAmphibRoute(final PlayerID player, final boolean nonCombat) {
        CompositeMatchAnd<Territory> routeCond;
        Match<Territory> endMatch;
        if (!this.isAmphibAttack(player, false)) {
            return null;
        }
        final GameData data = this.getPlayerBridge().getGameData();
        Territory ourCapitol = TerritoryAttachment.getFirstOwnedCapitalOrFirstUnownedCapital(player, data);
        Route withNoEnemy = SUtils.findNearest(ourCapitol, endMatch = new Match<Territory>(){

            @Override
            public boolean match(Territory o) {
                boolean impassable = TerritoryAttachment.get(o) != null && TerritoryAttachment.get(o).getIsImpassible();
                boolean isLandableOn = false;
                isLandableOn = nonCombat ? Matches.isTerritoryAllied(player, data).match(o) : !Matches.isTerritoryAllied(player, data).match(o);
                return !impassable && !o.isWater() && SUtils.hasLandRouteToEnemyOwnedCapitol(o, player, data) && isLandableOn;
            }
        }, routeCond = new CompositeMatchAnd<Territory>(Matches.TerritoryIsWater, Matches.territoryHasNoEnemyUnits(player, data)), data);
        if (withNoEnemy != null && withNoEnemy.getLength() > 0) {
            return withNoEnemy;
        }
        Route route = SUtils.findNearest(ourCapitol, endMatch, Matches.TerritoryIsWater, data);
        if (route == null || route.getLength() == 0) {
            return null;
        }
        return route;
    }

    private boolean isAmphibAttack(PlayerID player, boolean requireWaterFactory) {
        List<Territory> factories;
        List<Territory> waterFactories;
        GameData data = this.getPlayerBridge().getGameData();
        Territory capitol = TerritoryAttachment.getFirstOwnedCapitalOrFirstUnownedCapital(player, this.getPlayerBridge().getGameData());
        if (capitol == null || !capitol.getOwner().equals(player)) {
            return false;
        }
        if (requireWaterFactory && (waterFactories = SUtils.stripLandLockedTerr(data, factories = SUtils.findTersWithUnitsMatching(data, player, Matches.UnitCanProduceUnits))).isEmpty()) {
            return false;
        }
        boolean amphibPlayer = !SUtils.hasLandRouteToEnemyOwnedCapitol(capitol, player, data);
        int totProduction = 0;
        int allProduction = 0;
        if (amphibPlayer) {
            List<Territory> allFactories = SUtils.findTersWithUnitsMatching(data, player, Matches.UnitCanProduceUnits);
            for (Territory checkFactory : allFactories) {
                boolean isLandRoute = SUtils.hasLandRouteToEnemyOwnedCapitol(checkFactory, player, data);
                int factProduction = TripleAUnit.getProductionPotentialOfTerritory(checkFactory.getUnits().getUnits(), checkFactory, player, data, false, true);
                allProduction += factProduction;
                if (!isLandRoute) continue;
                totProduction += factProduction;
            }
        }
        amphibPlayer = amphibPlayer ? totProduction * 5 < allProduction * 2 : false;
        return amphibPlayer;
    }

    private HashMap<Territory, Float> determineCapDanger(PlayerID player, GameData data) {
        float threatFactor = 1.05f;
        float enemyStrength = 0.0f;
        float ourStrength = 0.0f;
        boolean capDanger = false;
        HashMap<Territory, Float> factMap = new HashMap<Territory, Float>();
        Territory myCapital = TerritoryAttachment.getFirstOwnedCapitalOrFirstUnownedCapital(player, data);
        if (myCapital == null) {
            return factMap;
        }
        List<Territory> factories = SUtils.findTersWithUnitsMatching(data, player, Matches.UnitCanProduceUnits);
        if (!factories.contains(myCapital)) {
            factories.add(myCapital);
        }
        boolean tFirst = this.transportsMayDieFirst();
        for (Territory factory : factories) {
            enemyStrength = SUtils.getStrengthOfPotentialAttackers(myCapital, data, player, tFirst, false, null);
            factMap.put(factory, Float.valueOf(enemyStrength));
        }
        float capPotential = factMap.get(myCapital).floatValue();
        ourStrength = SUtils.strength(myCapital.getUnits().getUnits(), false, false, tFirst);
        if (capPotential > (ourStrength += 2.0f) * 1.05f) {
            capDanger = true;
        }
        this.setCapDanger(capDanger);
        return factMap;
    }

    @Override
    protected void move(boolean nonCombat, IMoveDelegate moveDel, GameData data, PlayerID player) {
        if (nonCombat) {
            this.doNonCombatMove(moveDel, player);
        } else {
            this.doCombatMove(moveDel, player);
        }
        this.pause();
    }

    protected void doNonCombatMove(IMoveDelegate moveDel, PlayerID player) {
        GameData data = this.getPlayerBridge().getGameData();
        boolean foundOwnedUnits = false;
        for (Territory ter : data.getMap().getTerritories()) {
            if (!ter.getUnits().someMatch(Matches.unitIsOwnedBy(player))) continue;
            foundOwnedUnits = true;
            break;
        }
        if (!foundOwnedUnits) {
            return;
        }
        Long last = System.currentTimeMillis();
        ArrayList<Collection<Unit>> moveUnits = new ArrayList<Collection<Unit>>();
        ArrayList<Route> moveRoutes = new ArrayList<Route>();
        ArrayList<Collection<Unit>> transportsToLoad = new ArrayList<Collection<Unit>>();
        s_logger.fine("Start NonCombat for: " + player.getName());
        s_logger.fine("populateTransportLoad");
        this.populateTransportLoad(true, data, moveUnits, moveRoutes, transportsToLoad, player);
        this.doMove(moveUnits, moveRoutes, transportsToLoad, moveDel);
        moveRoutes.clear();
        moveUnits.clear();
        transportsToLoad.clear();
        Long now = System.currentTimeMillis();
        s_logger.finest("Time Taken " + (now - last));
        last = now;
        s_logger.fine("protectOurAllies");
        this.protectOurAllies(true, data, moveUnits, moveRoutes, player);
        this.doMove(moveUnits, moveRoutes, null, moveDel);
        moveRoutes.clear();
        moveUnits.clear();
        now = System.currentTimeMillis();
        s_logger.finest("Time Taken " + (now - last));
        last = now;
        s_logger.fine("planesToCarriers");
        this.planesToCarriers(data, moveUnits, moveRoutes, player);
        this.doMove(moveUnits, moveRoutes, null, moveDel);
        moveRoutes.clear();
        moveUnits.clear();
        now = System.currentTimeMillis();
        s_logger.finest("Time Taken " + (now - last));
        last = now;
        s_logger.fine("bomberNonComMove");
        this.bomberNonComMove(data, moveUnits, moveRoutes, player);
        this.doMove(moveUnits, moveRoutes, null, moveDel);
        moveRoutes.clear();
        moveUnits.clear();
        now = System.currentTimeMillis();
        s_logger.finest("Time Taken " + (now - last));
        last = now;
        this.determineCapDanger(player, data);
        s_logger.fine("populateNonComTransportMove");
        this.populateNonComTransportMove(data, moveUnits, moveRoutes, player);
        this.doMove(moveUnits, moveRoutes, null, moveDel);
        moveRoutes.clear();
        moveUnits.clear();
        now = System.currentTimeMillis();
        s_logger.finest("Time Taken " + (now - last));
        last = now;
        s_logger.fine("populateTransportUnLoadNonCom");
        this.populateTransportUnloadNonCom(true, data, moveUnits, moveRoutes, player);
        this.doMove(moveUnits, moveRoutes, null, moveDel);
        moveUnits.clear();
        moveRoutes.clear();
        now = System.currentTimeMillis();
        s_logger.finest("Time Taken " + (now - last));
        last = now;
        s_logger.fine("checkUnMovedTransports");
        this.checkUnmovedTransports(data, moveUnits, moveRoutes, player);
        this.doMove(moveUnits, moveRoutes, null, moveDel);
        moveUnits.clear();
        moveRoutes.clear();
        now = System.currentTimeMillis();
        s_logger.finest("Time Taken " + (now - last));
        last = now;
        s_logger.fine("bringShipsToTransports");
        this.bringShipsToTransports(data, moveUnits, moveRoutes, player);
        this.doMove(moveUnits, moveRoutes, null, moveDel);
        moveUnits.clear();
        moveRoutes.clear();
        now = System.currentTimeMillis();
        s_logger.finest("Time Taken " + (now - last));
        last = now;
        s_logger.fine("populateNonCombatSea");
        this.populateNonCombatSea(true, data, moveUnits, moveRoutes, player);
        this.doMove(moveUnits, moveRoutes, null, moveDel);
        moveUnits.clear();
        moveRoutes.clear();
        now = System.currentTimeMillis();
        s_logger.finest("Time Taken " + (now - last));
        last = now;
        s_logger.fine("stopBlitzAttack");
        this.stopBlitzAttack(data, moveUnits, moveRoutes, player);
        this.doMove(moveUnits, moveRoutes, null, moveDel);
        moveUnits.clear();
        moveRoutes.clear();
        now = System.currentTimeMillis();
        s_logger.finest("Time Taken " + (now - last));
        last = now;
        s_logger.fine("populateNonCombat");
        this.populateNonCombat(data, moveUnits, moveRoutes, player);
        this.doMove(moveUnits, moveRoutes, null, moveDel);
        moveUnits.clear();
        moveRoutes.clear();
        now = System.currentTimeMillis();
        s_logger.finest("Time Taken " + (now - last));
        last = now;
        s_logger.fine("movePlanesHomeNonCom");
        this.movePlanesHomeNonCom(moveUnits, moveRoutes, player, data);
        this.doMove(moveUnits, moveRoutes, null, moveDel);
        moveUnits.clear();
        moveRoutes.clear();
        now = System.currentTimeMillis();
        s_logger.finest("Time Taken " + (now - last));
        last = now;
        s_logger.fine("CheckPlanes");
        this.CheckPlanes(data, moveUnits, moveRoutes, player);
        this.doMove(moveUnits, moveRoutes, null, moveDel);
        moveUnits.clear();
        moveRoutes.clear();
        transportsToLoad.clear();
        now = System.currentTimeMillis();
        s_logger.finest("Time Taken " + (now - last));
        last = now;
        s_logger.fine("secondLookSea");
        this.secondLookSea(data, moveUnits, moveRoutes, player);
        this.doMove(moveUnits, moveRoutes, null, moveDel);
        moveUnits.clear();
        moveRoutes.clear();
        now = System.currentTimeMillis();
        s_logger.finest("Time Taken " + (now - last));
        last = now;
        s_logger.fine("populateTransportLoad");
        this.populateTransportLoad(true, data, moveUnits, moveRoutes, transportsToLoad, player);
        this.doMove(moveUnits, moveRoutes, transportsToLoad, moveDel);
        moveRoutes.clear();
        moveUnits.clear();
        transportsToLoad.clear();
        now = System.currentTimeMillis();
        s_logger.finest("Time Taken " + (now - last));
        last = now;
        s_logger.fine("populateTransportUnloadNonCom");
        this.populateTransportUnloadNonCom(false, data, moveUnits, moveRoutes, player);
        this.doMove(moveUnits, moveRoutes, null, moveDel);
        moveUnits.clear();
        moveRoutes.clear();
        now = System.currentTimeMillis();
        s_logger.finest("Time Taken " + (now - last));
        last = now;
        s_logger.fine("nonCombatPlanes");
        this.nonCombatPlanes(data, player, moveUnits, moveRoutes);
        this.doMove(moveUnits, moveRoutes, null, moveDel);
        moveUnits.clear();
        moveRoutes.clear();
        now = System.currentTimeMillis();
        s_logger.finest("Time Taken " + (now - last));
        last = now;
        s_logger.fine("secondNonCombat");
        this.secondNonCombat(moveUnits, moveRoutes, player, data);
        this.doMove(moveUnits, moveRoutes, null, moveDel);
        moveUnits.clear();
        moveRoutes.clear();
        now = System.currentTimeMillis();
        s_logger.finest("Time Taken " + (now - last));
        last = now;
        s_logger.fine("populateFinalTransportUnload");
        this.populateFinalTransportUnload(data, moveUnits, moveRoutes, player);
        this.doMove(moveUnits, moveRoutes, null, moveDel);
        now = System.currentTimeMillis();
        s_logger.finest("Time Taken " + (now - last));
        last = now;
        s_logger.fine("Finished NonCombat for: " + player.getName());
        s_logger.fine("populateFinalMoveToCoast");
        this.populateFinalMoveToCoast(data, moveUnits, moveRoutes, player);
        this.doMove(moveUnits, moveRoutes, null, moveDel);
        moveUnits.clear();
        moveRoutes.clear();
        now = System.currentTimeMillis();
        s_logger.finest("Time Taken " + (now - last));
        last = now;
        s_logger.fine("populateMoveUnusedTransportsToFillLocation");
        this.populateMoveUnusedTransportsToFillLocation(data, moveUnits, moveRoutes, player);
        this.doMove(moveUnits, moveRoutes, null, moveDel);
        moveUnits.clear();
        moveRoutes.clear();
        now = System.currentTimeMillis();
        s_logger.finest("Time Taken " + (now - last));
        last = now;
    }

    private void doCombatMove(IMoveDelegate moveDel, PlayerID player) {
        GameData data = this.getPlayerBridge().getGameData();
        boolean foundOwnedUnits = false;
        for (Territory ter : data.getMap().getTerritories()) {
            if (ter.getUnits().getMatches(Matches.unitIsOwnedBy(player)).size() <= 0) continue;
            foundOwnedUnits = true;
            break;
        }
        if (!foundOwnedUnits) {
            return;
        }
        this.getEdition();
        this.setImpassableTerrs(player);
        this.m_myCapital = TerritoryAttachment.getFirstOwnedCapitalOrFirstUnownedCapital(player, data);
        this.clearSeaTerrAttacked();
        this.clearLandTerrAttacked();
        ArrayList<Collection<Unit>> moveUnits = new ArrayList<Collection<Unit>>();
        ArrayList<Route> moveRoutes = new ArrayList<Route>();
        ArrayList<Collection<Unit>> transportsToLoad = new ArrayList<Collection<Unit>>();
        this.determineCapDanger(player, data);
        s_logger.fine("Start Combat for: " + player.getName());
        Long last = System.currentTimeMillis();
        s_logger.fine("Defend Start and End of Transport Chain");
        this.defendTransportingLocations(data, moveUnits, moveRoutes, player);
        this.doMove(moveUnits, moveRoutes, null, moveDel);
        if (!moveUnits.isEmpty() || !moveRoutes.isEmpty()) {
            s_logger.finer("moving " + moveUnits);
            s_logger.finer("Route " + moveRoutes);
        }
        moveUnits.clear();
        moveRoutes.clear();
        Long now = System.currentTimeMillis();
        s_logger.finest("Time Taken " + (now - last));
        last = now;
        s_logger.fine("Sea Combat Move");
        this.populateCombatMoveSea(data, moveUnits, moveRoutes, player);
        this.doMove(moveUnits, moveRoutes, null, moveDel);
        if (!moveUnits.isEmpty() || !moveRoutes.isEmpty()) {
            s_logger.finer("moving " + moveUnits);
            s_logger.finer("Route " + moveRoutes);
        }
        moveUnits.clear();
        moveRoutes.clear();
        now = System.currentTimeMillis();
        s_logger.finest("Time Taken " + (now - last));
        last = now;
        s_logger.fine("populateTransportLoad");
        this.populateTransportLoad(false, data, moveUnits, moveRoutes, transportsToLoad, player);
        this.doMove(moveUnits, moveRoutes, transportsToLoad, moveDel);
        if (!moveUnits.isEmpty() || !moveRoutes.isEmpty()) {
            s_logger.finer("moving " + moveUnits);
            s_logger.finer("Route " + moveRoutes);
        }
        moveUnits.clear();
        moveRoutes.clear();
        now = System.currentTimeMillis();
        s_logger.finest("Time Taken " + (now - last));
        last = now;
        s_logger.fine("protectOurAllies");
        this.protectOurAllies(true, data, moveUnits, moveRoutes, player);
        this.doMove(moveUnits, moveRoutes, null, moveDel);
        if (!moveUnits.isEmpty() || !moveRoutes.isEmpty()) {
            s_logger.finer("moving " + moveUnits);
            s_logger.finer("Route " + moveRoutes);
        }
        moveRoutes.clear();
        moveUnits.clear();
        now = System.currentTimeMillis();
        s_logger.finest("Time Taken " + (now - last));
        last = now;
        s_logger.fine("Special Transport Move");
        this.specialTransportMove(data, moveUnits, moveRoutes, player);
        this.doMove(moveUnits, moveRoutes, null, moveDel);
        if (!moveUnits.isEmpty() || !moveRoutes.isEmpty()) {
            s_logger.finer("moving " + moveUnits);
            s_logger.finer("Route " + moveRoutes);
        }
        moveRoutes.clear();
        moveUnits.clear();
        now = System.currentTimeMillis();
        s_logger.finest("Time Taken " + (now - last));
        last = now;
        s_logger.fine("Quick transport Unload");
        this.quickTransportUnload(data, moveUnits, moveRoutes, player);
        this.doMove(moveUnits, moveRoutes, null, moveDel);
        if (!moveUnits.isEmpty() || !moveRoutes.isEmpty()) {
            s_logger.finer("moving " + moveUnits);
            s_logger.finer("Route " + moveRoutes);
        }
        moveRoutes.clear();
        moveUnits.clear();
        now = System.currentTimeMillis();
        s_logger.finest("Time Taken " + (now - last));
        last = now;
        s_logger.fine("Amphib Map Unload");
        this.amphibMapUnload(data, moveUnits, moveRoutes, player);
        this.doMove(moveUnits, moveRoutes, null, moveDel);
        if (!moveUnits.isEmpty() || !moveRoutes.isEmpty()) {
            s_logger.finer("moving " + moveUnits);
            s_logger.finer("Route " + moveRoutes);
        }
        moveRoutes.clear();
        moveUnits.clear();
        now = System.currentTimeMillis();
        s_logger.finest("Time Taken " + (now - last));
        last = now;
        s_logger.fine("firstTransportMove");
        this.firstTransportMove(data, moveUnits, moveRoutes, player);
        this.doMove(moveUnits, moveRoutes, null, moveDel);
        if (!moveUnits.isEmpty() || !moveRoutes.isEmpty()) {
            s_logger.finer("moving " + moveUnits);
            s_logger.finer("Route " + moveRoutes);
        }
        moveRoutes.clear();
        moveUnits.clear();
        now = System.currentTimeMillis();
        s_logger.finest("Time Taken " + (now - last));
        last = now;
        s_logger.fine("Populate Transport Move");
        this.populateTransportMove(data, moveUnits, moveRoutes, player);
        this.doMove(moveUnits, moveRoutes, null, moveDel);
        if (!moveUnits.isEmpty() || !moveRoutes.isEmpty()) {
            s_logger.finer("moving " + moveUnits);
            s_logger.finer("Route " + moveRoutes);
        }
        moveUnits.clear();
        moveRoutes.clear();
        now = System.currentTimeMillis();
        s_logger.finest("Time Taken " + (now - last));
        last = now;
        s_logger.fine("Amphib Map Unload");
        this.amphibMapUnload(data, moveUnits, moveRoutes, player);
        this.doMove(moveUnits, moveRoutes, null, moveDel);
        if (!moveUnits.isEmpty() || !moveRoutes.isEmpty()) {
            s_logger.finer("moving " + moveUnits);
            s_logger.finer("Route " + moveRoutes);
        }
        moveRoutes.clear();
        moveUnits.clear();
        now = System.currentTimeMillis();
        s_logger.finest("Time Taken " + (now - last));
        last = now;
        s_logger.fine("Populate Transport Unload");
        this.populateTransportUnload(data, moveUnits, moveRoutes, player);
        this.doMove(moveUnits, moveRoutes, null, moveDel);
        if (!moveUnits.isEmpty() || !moveRoutes.isEmpty()) {
            s_logger.finer("moving " + moveUnits);
            s_logger.finer("Route " + moveRoutes);
        }
        moveRoutes.clear();
        moveUnits.clear();
        now = System.currentTimeMillis();
        s_logger.finest("Time Taken " + (now - last));
        last = now;
        s_logger.fine("Regular Combat Move");
        this.populateCombatMove(data, moveUnits, moveRoutes, player);
        this.doMove(moveUnits, moveRoutes, null, moveDel);
        if (!moveUnits.isEmpty() || !moveRoutes.isEmpty()) {
            s_logger.finer("moving " + moveUnits);
            s_logger.finer("Route " + moveRoutes);
        }
        moveUnits.clear();
        moveRoutes.clear();
        now = System.currentTimeMillis();
        s_logger.finest("Time Taken " + (now - last));
        last = now;
        s_logger.fine("Special Plane Attack");
        this.specialPlaneAttack(data, moveUnits, moveRoutes, player);
        this.doMove(moveUnits, moveRoutes, null, moveDel);
        if (!moveUnits.isEmpty() || !moveRoutes.isEmpty()) {
            s_logger.finer("moving " + moveUnits);
            s_logger.finer("Route " + moveRoutes);
        }
        now = System.currentTimeMillis();
        s_logger.finest("Time Taken " + (now - last));
        last = now;
    }

    @Override
    protected void battle(IBattleDelegate battleDelegate, GameData data, PlayerID player) {
        long start = System.currentTimeMillis();
        s_logger.fine("Doing Battles");
        while (true) {
            BattleListing listing;
            if ((listing = battleDelegate.getBattles()).getBattles().isEmpty()) {
                long now = System.currentTimeMillis();
                s_logger.finest("Time Taken " + (now - start));
                return;
            }
            this.set_onOffense(true);
            for (Map.Entry<IBattle.BattleType, Collection<Territory>> entry : listing.getBattles().entrySet()) {
                for (Territory current : entry.getValue()) {
                    String error = battleDelegate.fightBattle(current, entry.getKey().isBombingRun(), entry.getKey());
                    if (error == null) continue;
                    s_logger.fine(error);
                }
            }
            this.set_onOffense(false);
        }
    }

    private void planesToCarriers(GameData data, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, PlayerID player) {
        CompositeMatchAnd<Unit> ownedAC = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsCarrier);
        CompositeMatchAnd<Unit> fighterUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitCanLandOnCarrier);
        CompositeMatchAnd<Territory> noNeutralOrAA = new CompositeMatchAnd<Territory>(SUtils.TerritoryIsNotImpassableToAirUnits(data), Matches.territoryHasEnemyAAforCombatOnly(player, data).invert());
        List<Territory> ACTerrs = SUtils.findTersWithUnitsMatching(data, player, Matches.UnitIsCarrier);
        List<Territory> myFighterTerr = SUtils.findTersWithUnitsMatching(data, player, Matches.UnitCanLandOnCarrier);
        ArrayList<Unit> alreadyMoved = new ArrayList<Unit>();
        BattleDelegate delegate = DelegateFinder.battleDelegate(data);
        for (Territory ACTerr : ACTerrs) {
            List<Unit> ACUnits = ACTerr.getUnits().getMatches(ownedAC);
            int carrierSpace = 0;
            for (Unit carrier1 : ACUnits) {
                carrierSpace += UnitAttachment.get(carrier1.getType()).getCarrierCapacity();
            }
            List<Unit> ACFighters = ACTerr.getUnits().getMatches(fighterUnit);
            int fighterSpaceUsed = 0;
            for (Unit fighter1 : ACFighters) {
                fighterSpaceUsed += UnitAttachment.get(fighter1.getType()).getCarrierCost();
            }
            int availSpace = carrierSpace - fighterSpaceUsed;
            ACUnits.removeAll(alreadyMoved);
            if (ACUnits.size() == 0 || availSpace <= 0) continue;
            for (Territory f : myFighterTerr) {
                Route fACRoute;
                if (f == ACTerr) continue;
                if (Matches.TerritoryIsLand.match(f) && SUtils.doesLandExistAt(f, data, false)) {
                    Set<Territory> nextNeighbors = data.getMap().getNeighbors(f, Matches.territoryHasNoAlliedUnits(player, data).invert());
                    for (Territory nTerr : nextNeighbors) {
                        float eStrength;
                        float strength = SUtils.strength(nTerr.getUnits().getUnits(), false, false, true);
                        if (!(strength > (eStrength = SUtils.getStrengthOfPotentialAttackers(nTerr, data, player, true, true, null)))) continue;
                    }
                }
                Territory fTerr = f;
                if (Matches.TerritoryIsLand.match(f) && delegate.getBattleTracker().wasBattleFought(f)) {
                    fTerr = SUtils.getClosestWaterTerr(f, ACTerr, data, player, false);
                }
                if ((fACRoute = data.getMap().getWaterRoute(ACTerr, fTerr)) == null) continue;
                List<Unit> myFighters = f.getUnits().getMatches(fighterUnit);
                myFighters.removeAll(alreadyMoved);
                if (myFighters.isEmpty()) continue;
                IntegerMap<Unit> fighterMoveMap = new IntegerMap<Unit>();
                for (Unit f1 : myFighters) {
                    fighterMoveMap.put(f1, TripleAUnit.get(f1).getMovementLeft());
                }
                SUtils.reorder(myFighters, fighterMoveMap, false);
                int fACDist = fACRoute.getLength();
                int fightMove = MoveValidator.getMaxMovement(myFighters);
                if (AirMovementValidator.canLand(myFighters, ACTerr, player, data)) {
                    Route fACRoute2 = data.getMap().getRoute(f, ACTerr, noNeutralOrAA);
                    if (fACRoute2 == null || fACRoute2.getLength() > fightMove) continue;
                    moveUnits.add(myFighters);
                    moveRoutes.add(fACRoute2);
                    alreadyMoved.addAll(myFighters);
                    alreadyMoved.addAll(ACUnits);
                    continue;
                }
                int ACMove = MoveValidator.getLeastMovement(ACUnits);
                Route fACRoute2 = SUtils.getMaxSeaRoute(data, ACTerr, fTerr, player, false, ACMove);
                if (fACRoute2 == null || fACRoute2.getEnd() == null) continue;
                Territory targetTerr = fACRoute2.getEnd();
                Route fighterRoute = data.getMap().getRoute(f, targetTerr, noNeutralOrAA);
                if (fighterRoute == null || fACDist > fightMove + ACMove) continue;
                Iterator<Unit> fighterIter = myFighters.iterator();
                ArrayList<Unit> fighters = new ArrayList<Unit>();
                while (fighterIter.hasNext()) {
                    Unit fighter = fighterIter.next();
                    if (!MoveValidator.hasEnoughMovement(fighter, fighterRoute)) continue;
                    fighters.add(fighter);
                }
                if (fighters.size() <= 0) continue;
                moveUnits.add(myFighters);
                moveRoutes.add(fighterRoute);
                alreadyMoved.addAll(myFighters);
                moveUnits.add(ACUnits);
                moveRoutes.add(fACRoute2);
                alreadyMoved.addAll(ACUnits);
            }
        }
    }

    private void checkUnmovedTransports(GameData data, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, PlayerID player) {
        CompositeMatchAnd transUnit = new CompositeMatchAnd(Matches.UnitIsTransport);
        CompositeMatchAnd<Unit> ourTransUnit = new CompositeMatchAnd<Unit>(transUnit, Matches.unitIsOwnedBy(player), Matches.transportIsNotTransporting(), Matches.unitHasNotMoved);
        List<Territory> transTerr = SUtils.findTersWithUnitsMatching(data, player, ourTransUnit);
        List<Territory> ourFactories = SUtils.findTersWithUnitsMatching(data, player, Matches.UnitCanProduceUnits);
        ArrayList<Territory> ourSeaSpots = new ArrayList<Territory>();
        CompositeMatchAnd<Unit> ourLandUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsLand, Matches.UnitIsNotInfrastructure);
        if (transTerr.isEmpty()) {
            return;
        }
        ArrayList alreadyMoved = new ArrayList();
        ArrayList ourEnemyTerr = new ArrayList();
        ArrayList ourFriendlyTerr = new ArrayList();
        ArrayList moveToTerr = new ArrayList();
        moveToTerr.addAll(ourEnemyTerr);
        moveToTerr.addAll(ourFriendlyTerr);
        HashMap<Territory, Territory> connectTerr = new HashMap<Territory, Territory>();
        for (Territory xT : ourFactories) {
            Set<Territory> factNeighbors = data.getMap().getNeighbors(xT, Matches.TerritoryIsWater);
            for (Territory factTest : factNeighbors) {
                connectTerr.put(factTest, xT);
            }
            ourSeaSpots.addAll(factNeighbors);
        }
        List<Territory> allTerr = SUtils.allAlliedTerritories(data, player);
        allTerr.removeAll(ourFactories);
        ArrayList<Territory> otherNonSeaSpots = new ArrayList<Territory>();
        for (Territory xT2 : allTerr) {
            boolean hasWater = SUtils.isWaterAt(xT2, data);
            Route nearestRoute = SUtils.findNearest(xT2, Matches.territoryHasEnemyUnits(player, data), Matches.isTerritoryAllied(player, data), data);
            if (!hasWater || nearestRoute != null && nearestRoute.getLength() <= 4 && !nearestRoute.crossesWater()) continue;
            otherNonSeaSpots.add(xT2);
        }
        Territory closestT = null;
        for (Territory t : transTerr) {
            List<Unit> ourTransports = t.getUnits().getMatches(ourTransUnit);
            ourTransports.removeAll(alreadyMoved);
            if (ourTransports.isEmpty()) continue;
            int maxTransDistance = MoveValidator.getLeastMovement(ourTransports);
            IntegerMap<Territory> distMap = new IntegerMap<Territory>();
            IntegerMap<Territory> unitsMap = new IntegerMap<Territory>();
            if (!ourSeaSpots.contains(t)) {
                for (Territory t2 : ourSeaSpots) {
                    Route thisRoute = SUtils.getMaxSeaRoute(data, t, t2, player, false, maxTransDistance);
                    int thisDist = 0;
                    thisDist = thisRoute == null ? 100 : thisRoute.getLength();
                    int numUnits = t2.getUnits().getMatches(ourLandUnit).size() + 6;
                    distMap.put(t2, thisDist);
                    unitsMap.put(t2, numUnits);
                }
            }
            for (Territory checkAnother : otherNonSeaSpots) {
                int thisDist = 0;
                int numUnits = checkAnother.getUnits().getMatches(ourLandUnit).size();
                Territory qTerr = SUtils.getClosestWaterTerr(checkAnother, t, data, player, false);
                thisDist = data.getMap().getWaterDistance(t, qTerr);
                if (thisDist == -1) {
                    thisDist = 100;
                }
                connectTerr.put(qTerr, checkAnother);
                distMap.put(qTerr, thisDist);
                unitsMap.put(qTerr, numUnits);
            }
            Set allWaterTerr = distMap.keySet();
            int score = 0;
            int bestScore = 0;
            for (Territory waterTerr : allWaterTerr) {
                score = unitsMap.getInt(waterTerr) - distMap.getInt(waterTerr);
                int numTrans = waterTerr.getUnits().getMatches(ourTransUnit).size();
                if (waterTerr == t) {
                    Territory landTerr = (Territory)connectTerr.get(t);
                    int moveNum = (numTrans * 2 - unitsMap.getInt(waterTerr)) / 2;
                    int score2 = 0;
                    int bestScore2 = 0;
                    Territory newTerr = null;
                    for (Territory waterTerr2 : allWaterTerr) {
                        if (waterTerr2 == waterTerr || landTerr == connectTerr.get(waterTerr2) || (score2 = unitsMap.getInt(waterTerr2) - distMap.getInt(waterTerr2)) <= bestScore2) continue;
                        bestScore2 = score2;
                        newTerr = waterTerr2;
                    }
                    Route goRoute = SUtils.getMaxSeaRoute(data, t, newTerr, player, false, maxTransDistance);
                    if (goRoute == null) continue;
                    ArrayList<Unit> tmpTrans = new ArrayList<Unit>();
                    for (int i = 0; i < Math.min(moveNum, numTrans); ++i) {
                        Unit trans2 = ourTransports.get(i);
                        tmpTrans.add(trans2);
                    }
                    if (moveNum <= 0 || tmpTrans.isEmpty()) continue;
                    ourTransports.removeAll(tmpTrans);
                    moveUnits.add(tmpTrans);
                    moveRoutes.add(goRoute);
                    alreadyMoved.addAll(tmpTrans);
                    continue;
                }
                if (score <= bestScore) continue;
                bestScore = score;
                closestT = waterTerr;
            }
            if (closestT != null && t != closestT && !ourTransports.isEmpty()) {
                int maxTDist = MoveValidator.getLeastMovement(ourTransports);
                Route ourRoute = SUtils.getMaxSeaRoute(data, t, closestT, player, false, maxTDist);
                moveUnits.add(ourTransports);
                moveRoutes.add(ourRoute);
            }
            closestT = null;
        }
    }

    private void populateTransportLoad(boolean nonCombat, GameData data, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, List<Collection<Unit>> transportsToLoad, PlayerID player) {
        CompositeMatchAnd owned = new CompositeMatchAnd(Matches.unitIsOwnedBy(player));
        CompositeMatchAnd landUnit = new CompositeMatchAnd(owned, Matches.UnitCanBeTransported, Matches.UnitCanMove, Matches.UnitIsNotInfrastructure);
        CompositeMatchAnd<Unit> transUnit = new CompositeMatchAnd<Unit>(owned, Matches.UnitIsTransport);
        List<Territory> transTerr = SUtils.findTersWithUnitsMatching(data, player, Matches.UnitIsTransport);
        if (transTerr.isEmpty()) {
            return;
        }
        ArrayList<Territory> myTerritories = new ArrayList<Territory>();
        for (Territory t : transTerr) {
            for (Territory t2 : data.getMap().getNeighbors(t)) {
                if (!Matches.isTerritoryAllied(player, data).match(t2)) continue;
                myTerritories.add(t2);
            }
        }
        Unit transport = null;
        int badGuyDist = 0;
        int badGuyFactDist = 0;
        ArrayList transportsFilled = new ArrayList();
        for (Territory checkThis : myTerritories) {
            List<Unit> unitsTmp;
            List<Unit> unitsToLoad;
            Route xRoute = null;
            boolean isLand = SUtils.doesLandExistAt(checkThis, data, true);
            boolean landRoute = false;
            if (isLand) {
                landRoute = SUtils.landRouteToEnemyCapital(checkThis, xRoute, data, player);
            }
            if ((unitsToLoad = SUtils.sortTransportUnits(unitsTmp = checkThis.getUnits().getMatches(new CompositeMatchAnd<Unit>(landUnit, Matches.unitHasNotMoved)))).size() == 0) continue;
            int maxMovement = MoveValidator.getMaxMovement(unitsToLoad);
            Set<Territory> xNeighbors = data.getMap().getNeighbors(checkThis);
            if (isLand) {
                CompositeMatchAnd<Territory> noWaterEnemy = new CompositeMatchAnd<Territory>(Matches.TerritoryIsNotImpassableToLandUnits(player, data), Matches.isTerritoryEnemyAndNotUnownedWaterOrImpassibleOrRestricted(player, data));
                CompositeMatchAnd<Territory> noWaterAllied = new CompositeMatchAnd<Territory>(Matches.TerritoryIsNotImpassableToLandUnits(player, data), Matches.isTerritoryAllied(player, data));
                Route badGuyDR = SUtils.findNearest(checkThis, noWaterEnemy, noWaterAllied, data);
                Route badGuyFactory = SUtils.findNearest(checkThis, Matches.territoryIsEnemyNonNeutralAndHasEnemyUnitMatching(data, player, Matches.UnitCanProduceUnits), Matches.TerritoryIsNotImpassableToLandUnits(player, data), data);
                badGuyFactDist = badGuyFactory == null ? 100 : badGuyFactory.getLength();
                badGuyDist = badGuyDR == null ? 100 : badGuyDR.getLength();
                if (landRoute) {
                    --badGuyDist;
                }
                if (badGuyFactDist <= 4 * maxMovement && badGuyDist <= 3 * maxMovement) continue;
            }
            for (Territory neighbor : xNeighbors) {
                if (!neighbor.isWater()) continue;
                ArrayList<Unit> units = new ArrayList<Unit>();
                List<Unit> transportUnits = neighbor.getUnits().getMatches(transUnit);
                transportUnits.removeAll(transportsFilled);
                ArrayList<Unit> finalTransUnits = new ArrayList<Unit>();
                if (transportUnits.size() == 0) continue;
                int transCount = transportUnits.size();
                for (int j = transCount - 1; j >= 0; --j) {
                    transport = transportUnits.get(j);
                    int free = TransportTracker.getAvailableCapacity(transport);
                    if (free <= 0) {
                        transportUnits.remove(j);
                        continue;
                    }
                    Iterator<Unit> iter = unitsToLoad.iterator();
                    boolean addOne = false;
                    while (iter.hasNext() && free > 0) {
                        Unit current = iter.next();
                        UnitAttachment ua = UnitAttachment.get(current.getType());
                        if (ua.getIsAir() || ua.getTransportCost() > free) continue;
                        iter.remove();
                        free -= ua.getTransportCost();
                        units.add(current);
                        addOne = true;
                    }
                    if (!addOne) continue;
                    finalTransUnits.add(transport);
                }
                if (units.size() <= 0) continue;
                Route route = data.getMap().getRoute(checkThis, neighbor);
                moveUnits.add(units);
                moveRoutes.add(route);
                transportsToLoad.add(finalTransUnits);
                transportsFilled.addAll(finalTransUnits);
                unitsToLoad.removeAll(units);
            }
        }
    }

    private void populateNonComTransportMove(GameData data, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, PlayerID player) {
        boolean tFirst = this.transportsMayDieFirst();
        CompositeMatchAnd transUnit = new CompositeMatchAnd(Matches.UnitIsTransport);
        CompositeMatchAnd<Unit> ourTransUnit = new CompositeMatchAnd<Unit>(transUnit, Matches.unitIsOwnedBy(player), Matches.unitHasNotMoved);
        List<Territory> transTerr2 = SUtils.findTersWithUnitsMatching(data, player, Matches.UnitIsTransport);
        if (transTerr2.isEmpty()) {
            return;
        }
        HashMap<Territory, Float> rankMap = SUtils.rankAmphibReinforcementTerritories(data, null, player, tFirst);
        ArrayList<Territory> targetTerrs = new ArrayList<Territory>(rankMap.keySet());
        ArrayList<Unit> unitsAlreadyMoved = new ArrayList<Unit>();
        Route amphibRoute = this.getAmphibRoute(player, true);
        boolean isAmphib = this.isAmphibAttack(player, false);
        if (isAmphib && amphibRoute != null && amphibRoute.getEnd() != null) {
            Territory quickDumpTerr = amphibRoute.getEnd();
            float remainingStrengthNeeded = 1000.0f;
            SUtils.inviteTransports(true, quickDumpTerr, 1000.0f, unitsAlreadyMoved, moveUnits, moveRoutes, data, player, tFirst, false, null);
        }
        float distanceFactor = 0.85f;
        List<Territory> allAlliedWithEnemyNeighbor = SUtils.getTerritoriesWithEnemyNeighbor(data, player, true, false);
        allAlliedWithEnemyNeighbor.retainAll(targetTerrs);
        SUtils.reorder(allAlliedWithEnemyNeighbor, rankMap, true);
        for (Territory aT : allAlliedWithEnemyNeighbor) {
            SUtils.inviteTransports(true, aT, 1000.0f, unitsAlreadyMoved, moveUnits, moveRoutes, data, player, tFirst, false, null);
        }
        if (amphibRoute != null) {
            for (Territory tT : transTerr2) {
                int tDist;
                Route dockSeaRoute;
                Territory amphibDockTerr = amphibRoute.getTerritoryAtStep(amphibRoute.getLength() - 2);
                if (amphibDockTerr == null) continue;
                List<Unit> transUnits = tT.getUnits().getMatches(Matches.transportIsTransporting());
                transUnits.removeAll(unitsAlreadyMoved);
                if (transUnits.isEmpty() || (dockSeaRoute = SUtils.getMaxSeaRoute(data, tT, amphibDockTerr, player, false, tDist = MoveValidator.getMaxMovement(transUnits))) == null) continue;
                Iterator<Unit> tIter = transUnits.iterator();
                ArrayList<Unit> addUnits = new ArrayList<Unit>();
                while (tIter.hasNext()) {
                    Unit transport = tIter.next();
                    if (!MoveValidator.hasEnoughMovement(transport, dockSeaRoute)) continue;
                    addUnits.add(transport);
                    addUnits.addAll(TransportTracker.transporting(transport));
                }
                s_logger.fine("pnct " + addUnits);
                s_logger.fine("pnct " + dockSeaRoute);
                moveUnits.add(addUnits);
                moveRoutes.add(dockSeaRoute);
                unitsAlreadyMoved.addAll(addUnits);
            }
        }
        for (Territory t : transTerr2) {
            ArrayList<Unit> ourLandingUnits = new ArrayList<Unit>();
            List<Unit> mytrans = t.getUnits().getMatches(ourTransUnit);
            mytrans.removeAll(unitsAlreadyMoved);
            Iterator<Unit> mytransIter = mytrans.iterator();
            while (mytransIter.hasNext()) {
                Unit thisTrans = mytransIter.next();
                if (TransportTracker.isTransporting(thisTrans)) {
                    ourLandingUnits.addAll(TransportTracker.transporting(thisTrans));
                    continue;
                }
                mytransIter.remove();
            }
            if (mytrans.isEmpty()) continue;
            HashMap<Territory, Float> rankMap2 = new HashMap<Territory, Float>(rankMap);
            for (Territory target : targetTerrs) {
                Float rankValue = rankMap2.get(target);
                Territory newGoTerr = SUtils.getSafestWaterTerr(target, t, null, data, player, false, tFirst);
                if (newGoTerr == null) continue;
                int thisDist = data.getMap().getWaterDistance(t, newGoTerr);
                float multiplier = (float)Math.exp(0.85f * (float)(thisDist - 2));
                if (thisDist <= 2) continue;
                rankValue = Float.valueOf(rankValue.floatValue() - rankValue.floatValue() * multiplier);
                rankMap2.put(target, rankValue);
            }
            SUtils.reorder(targetTerrs, rankMap2, true);
            int tDistance = MoveValidator.getMaxMovement(mytrans);
            Iterator tTIter = targetTerrs.iterator();
            while (tTIter.hasNext() && !mytrans.isEmpty()) {
                Territory target = (Territory)tTIter.next();
                Set<Territory> targetNeighbors = data.getMap().getNeighbors(target, Matches.TerritoryIsWater);
                if (targetNeighbors.contains(t)) {
                    unitsAlreadyMoved.addAll(mytrans);
                    mytrans.clear();
                    continue;
                }
                Territory seaTarget = SUtils.getSafestWaterTerr(target, t, null, data, player, false, tFirst);
                if (seaTarget == null) continue;
                Route seaRoute = SUtils.getMaxSeaRoute(data, t, seaTarget, player, false, tDistance);
                if (seaRoute == null) {
                    HashMap<Match<Territory>, Integer> matches = new HashMap<Match<Territory>, Integer>();
                    matches.put(new CompositeMatchAnd(Matches.TerritoryIsWater, Matches.territoryHasAlliedUnits(player, data)), 2);
                    matches.put(new CompositeMatchAnd(Matches.TerritoryIsWater, Matches.territoryHasNoEnemyUnits(player, data)), 3);
                    matches.put(Matches.TerritoryIsWater, 6);
                    seaRoute = data.getMap().getCompositeRoute(t, seaTarget, matches);
                    if (seaRoute == null || (seaRoute = SUtils.TrimRoute_BeforeFirstTerWithEnemyUnits(seaRoute, tDistance, player, data)) == null) continue;
                    float transportsStrength = SUtils.strength(mytrans, false, true, tFirst);
                    float existingTerStrength = 0.0f;
                    float newStrength = 0.0f;
                    if (seaRoute.getLength() > 1) {
                        existingTerStrength = SUtils.strength(seaRoute.getEnd().getUnits().getMatches(Matches.UnitIsSea), false, true, tFirst);
                    }
                    newStrength = transportsStrength + existingTerStrength;
                    if (SUtils.getStrengthOfPotentialAttackers(seaRoute.getEnd(), data, player, tFirst, false, new ArrayList<Territory>()) > newStrength) continue;
                }
                Iterator<Unit> transIter = mytrans.iterator();
                ArrayList<Unit> moveTransports = new ArrayList<Unit>();
                ArrayList<Unit> moveLoad = new ArrayList<Unit>();
                while (transIter.hasNext()) {
                    Unit transport = transIter.next();
                    if (!MoveValidator.hasEnoughMovement(transport, seaRoute)) continue;
                    moveTransports.add(transport);
                    moveLoad.addAll(TripleAUnit.get(transport).getTransporting());
                }
                if (moveTransports.isEmpty()) continue;
                moveTransports.addAll(moveLoad);
                moveUnits.add(moveTransports);
                moveRoutes.add(seaRoute);
                mytrans.clear();
            }
        }
    }

    private void quickTransportUnload(GameData data, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, PlayerID player) {
        CompositeMatchAnd<Unit> loadedTransport = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsTransport, Matches.transportIsTransporting());
        CompositeMatchAnd<Territory> friendlyWaterTerr = new CompositeMatchAnd<Territory>(Matches.TerritoryIsWater, Matches.territoryHasUnitsOwnedBy(player));
        CompositeMatchAnd landPassable = new CompositeMatchAnd(Matches.TerritoryIsLand, Matches.TerritoryIsPassableAndNotRestricted(player, data));
        CompositeMatchAnd<Territory> enemyLandWithWater = new CompositeMatchAnd<Territory>(landPassable, Matches.isTerritoryEnemy(player, data), Matches.territoryHasWaterNeighbor(data));
        CompositeMatchAnd<Unit> myBlitzUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitCanBlitz);
        CompositeMatchAnd<Unit> myLandUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsLand);
        ArrayList<Territory> emptyEnemyTerrs = new ArrayList<Territory>();
        ArrayList<Unit> unitsAlreadyMoved = new ArrayList<Unit>();
        for (Territory emptyEnemyTerr : data.getMap().getTerritories()) {
            if (!((Match)enemyLandWithWater).match(emptyEnemyTerr) || !Matches.territoryIsEmptyOfCombatUnits(data, player).match(emptyEnemyTerr) || !Matches.TerritoryIsNotImpassable.match(emptyEnemyTerr)) continue;
            emptyEnemyTerrs.add(emptyEnemyTerr);
        }
        for (Territory enemyTerr : emptyEnemyTerrs) {
            Set<Territory> transTerrs = data.getMap().getNeighbors(enemyTerr, friendlyWaterTerr);
            List<Territory> landNeighborTerrs = SUtils.getNeighboringLandTerritories(data, player, enemyTerr);
            Iterator<Territory> lNIter = landNeighborTerrs.iterator();
            block2: while (lNIter.hasNext()) {
                float defenseStrength;
                Territory thisTerr = lNIter.next();
                float eAttackStrength = SUtils.getStrengthOfPotentialAttackers(enemyTerr, data, player, false, true, null);
                if (eAttackStrength > (defenseStrength = SUtils.strength(thisTerr.getUnits().getUnits(), false, false, false)) * 1.1f - 2.0f || Matches.territoryIsAlliedAndHasAlliedUnitMatching(data, player, Matches.UnitCanProduceUnits).match(thisTerr) && eAttackStrength > defenseStrength) {
                    lNIter.remove();
                    continue;
                }
                if (!Matches.territoryHasAlliedNeighborWithAlliedUnitMatching(data, player, Matches.UnitCanProduceUnits).match(thisTerr)) continue;
                Set<Territory> myFactNeighbors = data.getMap().getNeighbors(thisTerr, Matches.territoryIsAlliedAndHasAlliedUnitMatching(data, player, Matches.UnitCanProduceUnits));
                for (Territory newTerr : myFactNeighbors) {
                    float defenseStrength2;
                    float eAttackStrength2 = SUtils.getStrengthOfPotentialAttackers(newTerr, data, player, false, true, null);
                    if (!(eAttackStrength2 > (defenseStrength2 = SUtils.strength(newTerr.getUnits().getUnits(), false, false, false)))) continue;
                    lNIter.remove();
                    continue block2;
                }
            }
            Iterator<Territory> lNIter2 = landNeighborTerrs.iterator();
            boolean attacked = false;
            while (lNIter2.hasNext() && !attacked) {
                Territory thisTerr = lNIter2.next();
                List<Unit> myBlitzers = thisTerr.getUnits().getMatches(myBlitzUnit);
                myBlitzers.removeAll(unitsAlreadyMoved);
                if (myBlitzers.isEmpty()) continue;
                Unit blitzUnit = myBlitzers.get(0);
                Route goRoute = data.getMap().getRoute(thisTerr, enemyTerr);
                if (goRoute == null) continue;
                moveUnits.add(Collections.singletonList(blitzUnit));
                moveRoutes.add(goRoute);
                unitsAlreadyMoved.add(blitzUnit);
                attacked = true;
            }
            Iterator<Territory> lNIter3 = landNeighborTerrs.iterator();
            while (lNIter3.hasNext() && !attacked) {
                Territory thisTerr = lNIter3.next();
                List<Unit> myAttackers = thisTerr.getUnits().getMatches(myLandUnit);
                myAttackers.removeAll(unitsAlreadyMoved);
                if (myAttackers.isEmpty()) continue;
                Unit attackUnit = myAttackers.get(0);
                Route goRoute = data.getMap().getRoute(thisTerr, enemyTerr);
                if (goRoute == null) continue;
                moveUnits.add(Collections.singletonList(attackUnit));
                moveRoutes.add(goRoute);
                unitsAlreadyMoved.add(attackUnit);
                attacked = true;
            }
            Iterator<Territory> transIter = transTerrs.iterator();
            while (transIter.hasNext() && !attacked) {
                Territory transTerr = transIter.next();
                List<Unit> loadedTransports = transTerr.getUnits().getMatches(loadedTransport);
                loadedTransports.removeAll(unitsAlreadyMoved);
                if (loadedTransports.isEmpty()) continue;
                Unit transport = loadedTransports.get(0);
                List<Unit> loadedUnits = TripleAUnit.get(transport).getTransporting();
                Route dumpRoute = data.getMap().getRoute(transTerr, enemyTerr);
                if (dumpRoute == null) continue;
                moveUnits.add(loadedUnits);
                moveRoutes.add(dumpRoute);
                unitsAlreadyMoved.add(transport);
                attacked = true;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void specialTransportMove(GameData data, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, PlayerID player) {
        HashMap<Territory, Territory> amphibMap = new HashMap<Territory, Territory>();
        CompositeMatchAnd<Unit> transUnit = new CompositeMatchAnd<Unit>(Matches.UnitIsTransport, Matches.transportIsTransporting());
        CompositeMatchAnd landPassable = new CompositeMatchAnd(Matches.TerritoryIsLand, Matches.TerritoryIsPassableAndNotRestricted(player, data));
        CompositeMatchAnd<Territory> enemyEmpty = new CompositeMatchAnd<Territory>(Matches.isTerritoryEnemy(player, data), Matches.territoryHasEnemyLandUnits(player, data).invert(), landPassable, Matches.territoryHasWaterNeighbor(data));
        CompositeMatchAnd<Territory> enemyTarget = new CompositeMatchAnd<Territory>(Matches.isTerritoryEnemy(player, data), Matches.territoryHasWaterNeighbor(data), Matches.TerritoryIsNotImpassable);
        List<Territory> transTerr = SUtils.findTersWithUnitsMatching(data, player, transUnit);
        if (transTerr.isEmpty()) {
            s_logger.fine("Transports not found on entire map for player: " + player.getName());
            return;
        }
        List<Territory> seaTerrAttacked = this.getSeaTerrAttacked();
        boolean tFirst = this.transportsMayDieFirst();
        ArrayList<Territory> inRangeTerr = new ArrayList<Territory>();
        ArrayList<Territory> oneUnitTerr = new ArrayList<Territory>();
        for (Territory startTerr : transTerr) {
            Set<Territory> enemyTerr = data.getMap().getNeighbors(startTerr, 3);
            for (Territory eCheck : enemyTerr) {
                if (!inRangeTerr.contains(eCheck) && ((Match)enemyEmpty).match(eCheck)) {
                    inRangeTerr.add(eCheck);
                    continue;
                }
                if (oneUnitTerr.contains(eCheck) || !((Match)enemyTarget).match(eCheck) || eCheck.getUnits().countMatches(Matches.UnitIsLand) >= 3 || SUtils.doesLandExistAt(eCheck, data, false)) continue;
                oneUnitTerr.add(eCheck);
            }
        }
        if (inRangeTerr.isEmpty() && oneUnitTerr.isEmpty()) {
            return;
        }
        ArrayList<Territory> ourFriendlyTerr = new ArrayList<Territory>();
        ArrayList<Territory> ourEnemyTerr = new ArrayList<Territory>();
        HashMap<Territory, Float> rankMap = SUtils.rankTerritories(data, ourFriendlyTerr, ourEnemyTerr, seaTerrAttacked, player, tFirst, false, false);
        Set<Territory> rankTerr = rankMap.keySet();
        inRangeTerr.retainAll(rankTerr);
        oneUnitTerr.retainAll(rankTerr);
        SUtils.reorder(inRangeTerr, rankMap, true);
        SUtils.reorder(oneUnitTerr, rankMap, true);
        ArrayList<Territory> landTerrConquered = new ArrayList<Territory>();
        ArrayList<Unit> unitsAlreadyMoved = new ArrayList<Unit>();
        Route goRoute = new Route();
        for (Territory landTerr : inRangeTerr) {
            PlayerID ePlayer = landTerr.getOwner();
            float myAttackPotential = SUtils.getStrengthOfPotentialAttackers(landTerr, data, ePlayer, tFirst, true, null);
            myAttackPotential += (float)(TerritoryAttachment.getProduction(landTerr) * 2);
            for (Territory sourceTerr : transTerr) {
                int tDist;
                Territory goTerr = SUtils.getSafestWaterTerr(landTerr, sourceTerr, seaTerrAttacked, data, player, false, tFirst);
                if (goTerr == null && (goTerr = SUtils.getClosestWaterTerr(landTerr, sourceTerr, data, player, false)) == null) continue;
                List<Unit> transports = sourceTerr.getUnits().getMatches(transUnit);
                transports.removeAll(unitsAlreadyMoved);
                if (transports.isEmpty() || (goRoute = SUtils.getMaxSeaRoute(data, sourceTerr, goTerr, player, false, tDist = MoveValidator.getMaxMovement(transports))) == null || goRoute.getEnd() != goTerr) continue;
                ArrayList<Unit> unitsToMove = new ArrayList<Unit>();
                if (Matches.territoryHasEnemyNonNeutralNeighborWithEnemyUnitMatching(data, player, Matches.UnitCanProduceUnits).match(goTerr) || Matches.territoryHasEnemyNonNeutralNeighborWithEnemyUnitMatching(data, player, Matches.UnitCanProduceUnits).match(landTerr)) {
                    unitsToMove.addAll(transports);
                    for (Unit transport : transports) {
                        unitsToMove.addAll(TransportTracker.transporting(transport));
                    }
                } else {
                    Unit unit = transports.get(0);
                    unitsToMove.addAll(TransportTracker.transporting(unit));
                    unitsToMove.add(unit);
                }
                landTerrConquered.add(landTerr);
                moveUnits.add(unitsToMove);
                moveRoutes.add(goRoute);
                unitsAlreadyMoved.addAll(unitsToMove);
            }
        }
        for (Territory easyTerr : oneUnitTerr) {
            float mySeaStrength;
            float myAttackStrength;
            void var32_44;
            float eStrength = SUtils.strength(easyTerr.getUnits().getMatches(Matches.enemyUnit(player, data)), false, false, tFirst);
            float strengthNeeded = eStrength * 1.35f + 3.0f;
            ArrayList<Collection<Unit>> xMoveUnits = new ArrayList<Collection<Unit>>();
            ArrayList<Route> xMoveRoutes = new ArrayList<Route>();
            ArrayList<Unit> xAlreadyMoved = new ArrayList<Unit>(unitsAlreadyMoved);
            float transStrength = SUtils.inviteTransports(false, easyTerr, strengthNeeded, xAlreadyMoved, xMoveUnits, xMoveRoutes, data, player, tFirst, true, seaTerrAttacked);
            int transCount = 0;
            for (Collection collection : xMoveUnits) {
                transCount += collection.size();
            }
            int routeNumbers = xMoveRoutes.size();
            Object var32_42 = null;
            if (routeNumbers > 0) {
                Territory territory = ((Route)xMoveRoutes.get(routeNumbers - 1)).getEnd();
            }
            if (transStrength < 1.0f) continue;
            strengthNeeded -= transStrength;
            strengthNeeded = Math.max(strengthNeeded, 3.0f);
            float BBStrength = 0.0f;
            if (var32_44 != null) {
                BBStrength = SUtils.inviteBBEscort((Territory)var32_44, strengthNeeded, xAlreadyMoved, xMoveUnits, xMoveRoutes, data, player);
            }
            float planeStrength = 0.0f;
            if (strengthNeeded > 0.0f) {
                planeStrength = SUtils.invitePlaneAttack(false, false, easyTerr, strengthNeeded, xAlreadyMoved, xMoveUnits, xMoveRoutes, data, player);
            }
            if (!((myAttackStrength = BBStrength + transStrength + planeStrength) > eStrength + 1.0f)) continue;
            moveUnits.addAll(xMoveUnits);
            moveRoutes.addAll(xMoveRoutes);
            for (Route checkRoute : moveRoutes) {
                Territory tTerr = checkRoute.getEnd();
                amphibMap.put(tTerr, easyTerr);
            }
            unitsAlreadyMoved.addAll(xAlreadyMoved);
            landTerrConquered.add(easyTerr);
            if (var32_44 == null) continue;
            float seaPotential = SUtils.getStrengthOfPotentialAttackers((Territory)var32_44, data, player, tFirst, false, seaTerrAttacked);
            float f = mySeaStrength = tFirst ? (float)transCount : 0.0f;
            if (!((mySeaStrength += BBStrength) < seaPotential * 0.8f - 2.0f)) continue;
            float remainingStrengthNeeded = mySeaStrength > 0.5f ? seaPotential * 0.8f - 2.0f - mySeaStrength : seaPotential * 0.8f;
            SUtils.inviteShipAttack((Territory)var32_44, remainingStrengthNeeded, unitsAlreadyMoved, moveUnits, moveRoutes, data, player, false, tFirst, false);
        }
        this.setAmphibMap(amphibMap);
        this.setLandTerrAttacked(landTerrConquered);
    }

    private void firstTransportMove(GameData data, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, PlayerID player) {
        CompositeMatchAnd transUnit = new CompositeMatchAnd(Matches.UnitIsTransport);
        CompositeMatchAnd<Unit> transportingUnit = new CompositeMatchAnd<Unit>(transUnit, Matches.unitIsOwnedBy(player), Matches.transportIsTransporting());
        CompositeMatchAnd<Territory> landPassable = new CompositeMatchAnd<Territory>(Matches.TerritoryIsLand, Matches.TerritoryIsPassableAndNotRestricted(player, data));
        CompositeMatchAnd<Territory> routeCondition = new CompositeMatchAnd<Territory>(Matches.TerritoryIsWater);
        ArrayList unitsAlreadyMoved = new ArrayList();
        Territory capitol = TerritoryAttachment.getFirstOwnedCapitalOrFirstUnownedCapital(player, data);
        if (!this.isAmphibAttack(player, false) || !Matches.territoryHasWaterNeighbor(data).match(capitol)) {
            return;
        }
        Set<Territory> waterCapNeighbors = data.getMap().getNeighbors(capitol, Matches.TerritoryIsWater);
        if (waterCapNeighbors.isEmpty()) {
            return;
        }
        Territory waterCap = waterCapNeighbors.iterator().next();
        Route goRoute = SUtils.findNearest(waterCap, Matches.isTerritoryEnemyAndNotUnownedWaterOrImpassibleOrRestricted(player, data), routeCondition, data);
        if (goRoute == null || goRoute.getEnd() == null) {
            return;
        }
        Territory endTerr = goRoute.getEnd();
        ArrayList<Territory> waterTerrs = new ArrayList<Territory>();
        waterTerrs.addAll(data.getMap().getNeighbors(endTerr, 20));
        Set<Territory> xWaterTerrs = data.getMap().getNeighbors(endTerr, 3);
        waterTerrs.removeAll(xWaterTerrs);
        Iterator wIter = waterTerrs.iterator();
        while (wIter.hasNext()) {
            Territory waterTerr = (Territory)wIter.next();
            if (!Matches.TerritoryIsLand.match(waterTerr) && !Matches.territoryHasNoAlliedUnits(player, data).match(waterTerr)) continue;
            wIter.remove();
        }
        for (Territory myTerr : waterTerrs) {
            int maxDistance;
            Route seaRoute;
            Set<Territory> neighborList = data.getMap().getNeighbors(myTerr, landPassable);
            Iterator<Territory> nIter = neighborList.iterator();
            while (nIter.hasNext()) {
                Territory nTerr = nIter.next();
                if (SUtils.hasLandRouteToEnemyOwnedCapitol(nTerr, player, data)) continue;
                nIter.remove();
            }
            if (!neighborList.isEmpty()) continue;
            List<Territory> neighborList2 = SUtils.getExactNeighbors(myTerr, 2, player, data, true);
            boolean skipTerr = false;
            for (Territory nTerr : neighborList2) {
                if (!SUtils.hasLandRouteToEnemyOwnedCapitol(nTerr, player, data)) continue;
                skipTerr = true;
            }
            if (skipTerr) continue;
            Territory closeTerr = SUtils.getClosestWaterTerr(endTerr, myTerr, data, player, true);
            List<Unit> transUnits = myTerr.getUnits().getMatches(transportingUnit);
            transUnits.removeAll(unitsAlreadyMoved);
            if (transUnits.isEmpty() || (seaRoute = SUtils.getMaxSeaRoute(data, myTerr, closeTerr, player, true, maxDistance = MoveValidator.getMaxMovement(transUnits))) == null) continue;
            ArrayList<Unit> transportedUnits = new ArrayList<Unit>();
            for (Unit transport : transUnits) {
                transportedUnits.addAll(TransportTracker.transporting(transport));
            }
            transUnits.addAll(transportedUnits);
            moveUnits.add(transUnits);
            moveRoutes.add(seaRoute);
        }
    }

    private void defendTransportingLocations(GameData data, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, PlayerID player) {
        ArrayList<Unit> shipTemp;
        Unit ship;
        Iterator<Unit> shipIter;
        List<Unit> myWarships;
        float ourNeighborsStrength;
        CompositeMatchAnd<Unit> ourWarshipsZ;
        CompositeMatchAnd<Territory> routeCondition = new CompositeMatchAnd<Territory>(Matches.TerritoryIsWater);
        CompositeMatchAnd<Territory> endCondition = new CompositeMatchAnd<Territory>(Matches.isTerritoryEnemyAndNotUnownedWaterOrImpassibleOrRestricted(player, data), Matches.TerritoryIsLand);
        CompositeMatchAnd<Territory> endCondition2 = new CompositeMatchAnd<Territory>(Matches.territoryHasLandRouteToEnemyCapital(data, player), Matches.isTerritoryEnemyAndNotUnownedWaterOrImpassibleOrRestricted(player, data), Matches.TerritoryIsLand);
        CompositeMatchAnd<Unit> ourWarships = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsSea, Matches.unitHasDefenseThatIsMoreThanOrEqualTo(1), Matches.UnitIsNotSub, Matches.UnitIsNotTransport);
        CompositeMatchAnd<Unit> enemyWarships = new CompositeMatchAnd<Unit>(Matches.unitIsEnemyOf(data, player), Matches.UnitIsSea, Matches.unitCanAttack(player));
        CompositeMatchAnd<Unit> enemyAir = new CompositeMatchAnd<Unit>(Matches.unitIsEnemyOf(data, player), Matches.UnitIsAir, Matches.unitCanAttack(player));
        CompositeMatchAnd<Unit> enemyAttackStuff = new CompositeMatchAnd<Unit>(Matches.unitIsEnemyOf(data, player), Matches.unitCanAttack(player));
        Territory capitol = TerritoryAttachment.getFirstOwnedCapitalOrFirstUnownedCapital(player, data);
        if (!this.isAmphibAttack(player, false) || !Matches.territoryHasWaterNeighbor(data).match(capitol)) {
            return;
        }
        Set<Territory> waterCapNeighbors = data.getMap().getNeighbors(capitol, Matches.TerritoryIsWater);
        if (waterCapNeighbors.isEmpty()) {
            return;
        }
        ArrayList<Unit> unitsAlreadyMoved = new ArrayList<Unit>();
        for (Unit u : data.getUnits().getUnits()) {
            if (!u.getOwner().equals(player) || TripleAUnit.get(u).getMovementLeft() >= 1) continue;
            unitsAlreadyMoved.add(u);
        }
        Territory waterCap = waterCapNeighbors.iterator().next();
        Route goRoute = SUtils.findNearest(waterCap, endCondition, routeCondition, data);
        Route goRoute2 = SUtils.findNearest(waterCap, endCondition2, routeCondition, data);
        if (goRoute == null) {
            return;
        }
        Territory startTerr = goRoute.getStart();
        Territory endTerr = goRoute.getStart();
        Territory firstEndTerr = goRoute.getStart();
        if (goRoute.getLength() > 1) {
            endTerr = goRoute.getTerritoryAtStep(goRoute.getLength() - 2);
        }
        if (goRoute2 != null && goRoute2.getLength() > 1) {
            firstEndTerr = goRoute2.getTerritoryAtStep(goRoute2.getLength() - 2);
        } else if (goRoute.getLength() > 1) {
            firstEndTerr = goRoute.getTerritoryAtStep(goRoute.getLength() - 2);
        }
        ArrayList<Territory> TransportDropOffLocales = new ArrayList<Territory>(this.getTransportDropOffLocales());
        if (TransportDropOffLocales.isEmpty()) {
            ArrayList<Territory> firstEndTerrs = new ArrayList<Territory>();
            firstEndTerrs.add(firstEndTerr);
            this.setTransportDropOffLocales(firstEndTerrs);
        } else {
            firstEndTerr = (Territory)TransportDropOffLocales.get(0);
        }
        ArrayList<Collection<Unit>> xUnits = new ArrayList<Collection<Unit>>();
        ArrayList<Route> xRoutes = new ArrayList<Route>();
        List<Territory> terrsWithEnemyWarships = SUtils.findUnitTerr(data, player, enemyWarships);
        List<Territory> terrsWithEnemyAir = SUtils.findUnitTerr(data, player, enemyAir);
        List<Territory> terrsWithEnemyAttackStuff = SUtils.findUnitTerr(data, player, enemyAttackStuff);
        Set<Territory> startTerrNeighborsW = data.getMap().getNeighbors(startTerr, 2);
        Set<Territory> endTerrNeighborsW = data.getMap().getNeighbors(endTerr, 2);
        Set<Territory> firstEndTerrNeighborsW = data.getMap().getNeighbors(firstEndTerr, 2);
        Set<Territory> startTerrNeighborsA = data.getMap().getNeighbors(startTerr, 3);
        Set<Territory> endTerrNeighborsA = data.getMap().getNeighbors(endTerr, 3);
        Set<Territory> firstEndTerrNeighborsA = data.getMap().getNeighbors(firstEndTerr, 3);
        Set<Territory> startFar = data.getMap().getNeighbors(startTerr, 4);
        Set<Territory> firstEndFar = data.getMap().getNeighbors(firstEndTerr, 4);
        startTerrNeighborsW.retainAll(terrsWithEnemyWarships);
        startTerrNeighborsA.retainAll(terrsWithEnemyAir);
        endTerrNeighborsW.retainAll(terrsWithEnemyWarships);
        endTerrNeighborsA.retainAll(terrsWithEnemyAir);
        firstEndTerrNeighborsW.retainAll(terrsWithEnemyWarships);
        firstEndTerrNeighborsA.retainAll(terrsWithEnemyAir);
        startFar.retainAll(terrsWithEnemyAttackStuff);
        firstEndFar.retainAll(terrsWithEnemyAttackStuff);
        float startNeededStrength = 1.0f + SUtils.getStrengthOfPotentialAttackers(startTerr, data, player, false, false, null);
        float endNeededStrength = 1.0f + SUtils.getStrengthOfPotentialAttackers(endTerr, data, player, false, false, null);
        float firstEndNeededStrength = 1.0f + SUtils.getStrengthOfPotentialAttackers(firstEndTerr, data, player, false, false, null);
        startNeededStrength = Math.max(startNeededStrength, (float)(5 * startTerrNeighborsW.size()));
        startNeededStrength = Math.max(startNeededStrength, (float)(3 * startTerrNeighborsA.size()));
        endNeededStrength = Math.max(endNeededStrength, (float)(5 * endTerrNeighborsW.size()));
        endNeededStrength = Math.max(endNeededStrength, (float)(3 * endTerrNeighborsA.size()));
        firstEndNeededStrength = Math.max(firstEndNeededStrength, (float)(5 * firstEndTerrNeighborsW.size()));
        firstEndNeededStrength = Math.max(firstEndNeededStrength, (float)(3 * firstEndTerrNeighborsA.size()));
        if (Matches.TerritoryIsWater.match(startTerr) && Matches.territoryHasNoEnemyUnits(player, data).match(startTerr) && startNeededStrength > 0.0f) {
            ourWarshipsZ = new CompositeMatchAnd<Unit>(ourWarships, Matches.unitIsInTerritory(startTerr).invert(), Matches.unitIsInTerritory(firstEndTerr).invert(), Matches.unitIsInTerritory(endTerr).invert());
            ourNeighborsStrength = SUtils.inviteShipAttack(startTerr, startNeededStrength, new ArrayList<Unit>(unitsAlreadyMoved), new ArrayList<Collection<Unit>>(), new ArrayList<Route>(), data, player, false, false, false, ourWarshipsZ);
            if ((ourNeighborsStrength += SUtils.strengthOfTerritory(data, startTerr, player, false, true, false, false)) < startNeededStrength * 0.8f && startNeededStrength > 3.0f || ourNeighborsStrength > startNeededStrength * 1.4f + 1.0f) {
                startNeededStrength = data.getSequence().getRound() <= 2 || startFar.isEmpty() ? 0.0f : (firstEndTerr.equals(startTerr) ? 8.0f : 1.0f);
            }
            if (Matches.territoryHasUnitsThatMatch(ourWarships).match(startTerr)) {
                myWarships = startTerr.getUnits().getMatches(ourWarships);
                Collections.shuffle(myWarships);
                shipIter = myWarships.iterator();
                while (shipIter.hasNext() && startNeededStrength > 0.0f) {
                    ship = shipIter.next();
                    TripleAUnit.get(ship).setAlreadyMoved(TripleAUnit.get(ship).getMaxMovementAllowed());
                    ArrayList<Unit> shipTemp2 = new ArrayList<Unit>();
                    shipTemp2.add(ship);
                    startNeededStrength = Math.max(0.0f, startNeededStrength - SUtils.strength(shipTemp2, false, true, false));
                }
            }
            if (startNeededStrength > 0.0f) {
                CompositeMatchAnd<Unit> ourWarshipsX = new CompositeMatchAnd<Unit>(ourWarships);
                if (endNeededStrength > 1.0f && !startTerr.equals(endTerr)) {
                    ourWarshipsX.addInverse(Matches.unitIsInTerritory(endTerr));
                }
                SUtils.inviteShipAttack(startTerr, startNeededStrength, unitsAlreadyMoved, xUnits, xRoutes, data, player, false, false, false, ourWarshipsX);
                moveUnits.addAll(xUnits);
                moveRoutes.addAll(xRoutes);
            }
            xUnits.clear();
            xRoutes.clear();
        }
        if (!firstEndTerr.equals(startTerr) && Matches.TerritoryIsWater.match(firstEndTerr) && Matches.territoryHasNoEnemyUnits(player, data).match(firstEndTerr) && firstEndNeededStrength > 0.0f) {
            ourWarshipsZ = new CompositeMatchAnd(ourWarships, Matches.unitIsInTerritory(firstEndTerr).invert(), Matches.unitIsInTerritory(endTerr).invert());
            ourNeighborsStrength = SUtils.inviteShipAttack(firstEndTerr, firstEndNeededStrength, new ArrayList<Unit>(unitsAlreadyMoved), new ArrayList<Collection<Unit>>(), new ArrayList<Route>(), data, player, false, false, false, ourWarshipsZ);
            if ((ourNeighborsStrength += SUtils.strengthOfTerritory(data, firstEndTerr, player, false, true, false, false)) < firstEndNeededStrength * 0.9f && firstEndNeededStrength > 3.0f || ourNeighborsStrength > firstEndNeededStrength * 1.4f + 1.0f || data.getSequence().getRound() <= 2) {
                firstEndNeededStrength = data.getSequence().getRound() <= 2 || firstEndFar.isEmpty() ? 0.0f : 8.0f;
            }
            if (Matches.territoryHasUnitsThatMatch(ourWarships).match(firstEndTerr)) {
                myWarships = firstEndTerr.getUnits().getMatches(ourWarships);
                Collections.shuffle(myWarships);
                shipIter = myWarships.iterator();
                while (shipIter.hasNext() && firstEndNeededStrength > 0.0f) {
                    ship = shipIter.next();
                    int x = UnitAttachment.get(TripleAUnit.get(ship).getType()).getMovement(player);
                    TripleAUnit.get(ship).setAlreadyMoved(x);
                    shipTemp = new ArrayList<Unit>();
                    shipTemp.add(ship);
                    firstEndNeededStrength = Math.max(0.0f, firstEndNeededStrength - SUtils.strength(shipTemp, false, true, false));
                }
            }
            if (firstEndNeededStrength > 0.0f) {
                SUtils.inviteShipAttack(firstEndTerr, firstEndNeededStrength, unitsAlreadyMoved, xUnits, xRoutes, data, player, false, false, false, ourWarships);
                moveUnits.addAll(xUnits);
                moveRoutes.addAll(xRoutes);
            }
            xUnits.clear();
            xRoutes.clear();
        }
        if (!endTerr.equals(startTerr) && !endTerr.equals(firstEndTerr) && Matches.TerritoryIsWater.match(endTerr) && Matches.territoryHasNoEnemyUnits(player, data).match(endTerr) && endNeededStrength > 0.0f) {
            ourWarshipsZ = new CompositeMatchAnd(ourWarships, Matches.unitIsInTerritory(endTerr).invert());
            ourNeighborsStrength = SUtils.inviteShipAttack(endTerr, endNeededStrength, new ArrayList<Unit>(unitsAlreadyMoved), new ArrayList<Collection<Unit>>(), new ArrayList<Route>(), data, player, false, false, false, ourWarshipsZ);
            if ((ourNeighborsStrength += SUtils.strengthOfTerritory(data, endTerr, player, false, true, false, false)) < endNeededStrength * 0.9f && endNeededStrength > 3.0f || ourNeighborsStrength > endNeededStrength * 1.4f + 1.0f || data.getSequence().getRound() <= 2) {
                endNeededStrength = data.getSequence().getRound() <= 3 ? 0.0f : 1.0f;
            }
            if (Matches.territoryHasUnitsThatMatch(ourWarships).match(endTerr)) {
                myWarships = endTerr.getUnits().getMatches(ourWarships);
                Collections.shuffle(myWarships);
                shipIter = myWarships.iterator();
                while (shipIter.hasNext() && endNeededStrength > 0.0f) {
                    ship = shipIter.next();
                    int x = UnitAttachment.get(TripleAUnit.get(ship).getType()).getMovement(player);
                    TripleAUnit.get(ship).setAlreadyMoved(x);
                    shipTemp = new ArrayList();
                    shipTemp.add(ship);
                    endNeededStrength = Math.max(0.0f, endNeededStrength - SUtils.strength(shipTemp, false, true, false));
                }
            }
            if (endNeededStrength > 0.0f) {
                SUtils.inviteShipAttack(endTerr, endNeededStrength, unitsAlreadyMoved, xUnits, xRoutes, data, player, false, false, false, ourWarships);
                moveUnits.addAll(xUnits);
                moveRoutes.addAll(xRoutes);
            }
            xUnits.clear();
            xRoutes.clear();
        }
    }

    private void populateTransportMove(GameData data, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, PlayerID player) {
        List<Territory> occTransTerr;
        this.setImpassableTerrs(player);
        Collection<Territory> impassableTerrs = this.getImpassableTerrs();
        boolean tFirst = this.transportsMayDieFirst();
        Route amphibRoute = this.getAmphibRoute(player, false);
        CompositeMatchAnd transUnit = new CompositeMatchAnd(Matches.UnitIsTransport);
        CompositeMatchAnd<Unit> transportingUnit = new CompositeMatchAnd<Unit>(transUnit, Matches.unitIsOwnedBy(player), Matches.transportIsTransporting());
        List<Territory> alreadyAttacked = this.getLandTerrAttacked();
        ArrayList<Unit> unitsAlreadyMoved = new ArrayList<Unit>();
        HashMap<Territory, Territory> amphibMap = new HashMap<Territory, Territory>();
        for (Unit u : data.getUnits().getUnits()) {
            if (!u.getOwner().equals(player) || TripleAUnit.get(u).getMovementLeft() >= 1) continue;
            unitsAlreadyMoved.add(u);
        }
        List<Territory> seaTerrAttacked = this.getSeaTerrAttacked();
        alreadyAttacked.addAll(seaTerrAttacked);
        Territory amphibAttackTerr = null;
        if (amphibRoute != null) {
            amphibAttackTerr = amphibRoute.getEnd();
        }
        if ((occTransTerr = SUtils.findTersWithUnitsMatching(data, player, transportingUnit)) == null || occTransTerr.isEmpty()) {
            return;
        }
        IntegerMap<Territory> transCountMap = new IntegerMap<Territory>();
        for (Territory transTerr : occTransTerr) {
            transCountMap.put(transTerr, transTerr.getUnits().countMatches(transportingUnit));
        }
        SUtils.reorder(occTransTerr, transCountMap, true);
        ArrayList<Territory> ourFriendlyTerr = new ArrayList<Territory>();
        ArrayList<Territory> ourEnemyTerr = new ArrayList<Territory>();
        HashMap<Territory, Float> landTerrMap = SUtils.rankTerritories(data, ourFriendlyTerr, ourEnemyTerr, seaTerrAttacked, player, tFirst, true, false);
        block2: for (Territory transTerr : occTransTerr) {
            List<Unit> ourTransports = transTerr.getUnits().getMatches(transportingUnit);
            ourTransports.removeAll(unitsAlreadyMoved);
            if (ourTransports.isEmpty()) continue;
            int tmpDistance = MoveValidator.getMaxMovement(ourTransports);
            Set<Territory> transTerrNeighbors = data.getMap().getNeighbors(transTerr, tmpDistance + 1);
            ArrayList<Territory> tmpTerrList = new ArrayList<Territory>(transTerrNeighbors);
            Iterator tTIter = tmpTerrList.iterator();
            while (tTIter.hasNext()) {
                Territory tmpTerr = (Territory)tTIter.next();
                if (!Matches.TerritoryIsWater.match(tmpTerr) && !Matches.TerritoryIsPassableAndNotRestricted(player, data).invert().match(tmpTerr) && !Matches.territoryHasWaterNeighbor(data).invert().match(tmpTerr)) continue;
                tTIter.remove();
            }
            HashMap<Territory, Float> landTerrMap2 = new HashMap<Territory, Float>(landTerrMap);
            int minDist = 0;
            Iterator cFIter = tmpTerrList.iterator();
            while (cFIter.hasNext()) {
                Territory safeTerr;
                Territory lT = (Territory)cFIter.next();
                if (Matches.isTerritoryAllied(player, data).match(lT) && Matches.territoryHasEnemyLandNeighbor(data, player).invert().match(lT)) {
                    float testPotential = SUtils.getStrengthOfPotentialAttackers(lT, data, player, tFirst, true, null);
                    if (testPotential <= 1.0f) {
                        cFIter.remove();
                        continue;
                    }
                } else if (Matches.isTerritoryAllied(player, data).match(lT)) {
                    cFIter.remove();
                    continue;
                }
                if ((safeTerr = SUtils.getClosestWaterTerr(lT, transTerr, data, player, tFirst)) == null || !landTerrMap2.containsKey(lT)) {
                    cFIter.remove();
                    continue;
                }
                minDist = data.getMap().getWaterDistance(transTerr, safeTerr);
                if (minDist > tmpDistance || minDist == -1) {
                    cFIter.remove();
                    continue;
                }
                if (!lT.equals(amphibAttackTerr)) continue;
                Float amphibValue = Float.valueOf(landTerrMap2.get(lT).floatValue() + 20.0f);
                landTerrMap2.put(lT, amphibValue);
            }
            if (tmpTerrList.isEmpty()) continue;
            SUtils.reorder(tmpTerrList, landTerrMap2, true);
            ArrayList<Territory> tTerrNeighbors = new ArrayList<Territory>(data.getMap().getNeighbors(transTerr));
            tTerrNeighbors.removeAll(impassableTerrs);
            int tDist = MoveValidator.getMaxMovement(ourTransports);
            for (Territory targetTerr : tmpTerrList) {
                float strengthDiff;
                boolean weCanWin;
                Route targetRoute;
                ArrayList<Collection<Unit>> xUnits = new ArrayList<Collection<Unit>>();
                ArrayList<Route> xRoutes = new ArrayList<Route>();
                ArrayList<Unit> xMoved = new ArrayList<Unit>(unitsAlreadyMoved);
                float defendingStrength = 0.0f;
                float planeStrength = 0.0f;
                float blitzStrength = 0.0f;
                float landStrength = 0.0f;
                float BBStrength = 0.0f;
                float ourShipStrength = 0.0f;
                Territory targetTerr2 = null;
                ourTransports.removeAll(unitsAlreadyMoved);
                if (ourTransports.isEmpty()) continue block2;
                Iterator<Unit> tIter = ourTransports.iterator();
                if (tTerrNeighbors.contains(targetTerr) && Matches.isTerritoryEnemy(player, data).match(targetTerr)) {
                    Route shortRoute = data.getMap().getRoute(transTerr, targetTerr);
                    if (shortRoute != null) {
                        float ourQuickStrength;
                        List<Unit> qUnits;
                        float eShortPotential = SUtils.getStrengthOfPotentialAttackers(targetTerr, data, player, tFirst, true, alreadyAttacked);
                        ArrayList<Unit> tLoadUnits = new ArrayList<Unit>();
                        float eShortStrength = SUtils.strength(targetTerr.getUnits().getMatches(Matches.enemyUnit(player, data)), false, false, tFirst);
                        float goStrength = (eShortStrength + 0.2f * eShortPotential) * 1.45f + 2.0f;
                        ArrayList<Unit> qtransMoved = new ArrayList<Unit>();
                        for (ourQuickStrength = 0.0f; tIter.hasNext() && ourQuickStrength < goStrength; ourQuickStrength += SUtils.strength(qUnits, true, false, tFirst)) {
                            Unit transport = tIter.next();
                            qUnits = TripleAUnit.get(transport).getTransporting();
                            tLoadUnits.addAll(qUnits);
                            qtransMoved.add(transport);
                        }
                        if (ourQuickStrength == 0.0f) continue;
                        ArrayList<Unit> qAMoved = new ArrayList<Unit>(unitsAlreadyMoved);
                        ArrayList<Collection<Unit>> qunitMoved = new ArrayList<Collection<Unit>>();
                        ArrayList<Route> qRoutes = new ArrayList<Route>();
                        float qPlaneStrength = 0.0f;
                        float qBBStrength = 0.0f;
                        float qBlitzStrength = 0.0f;
                        float qLandStrength = 0.0f;
                        if (ourQuickStrength < eShortStrength + 0.25f * eShortPotential) {
                            qBBStrength = SUtils.inviteBBEscort(transTerr, goStrength - ourQuickStrength, qAMoved, qunitMoved, qRoutes, data, player);
                            qPlaneStrength = SUtils.invitePlaneAttack(false, false, targetTerr, goStrength - (ourQuickStrength += qBBStrength), qAMoved, qunitMoved, qRoutes, data, player);
                            qBlitzStrength = SUtils.inviteBlitzAttack(false, targetTerr, goStrength - (ourQuickStrength += qPlaneStrength), qAMoved, qunitMoved, qRoutes, data, player, true, true);
                            qLandStrength = SUtils.inviteLandAttack(false, targetTerr, goStrength - (ourQuickStrength += qBlitzStrength), qAMoved, qunitMoved, qRoutes, data, player, false, Matches.territoryHasEnemyNonNeutralNeighborWithEnemyUnitMatching(data, player, Matches.UnitCanProduceUnits).match(targetTerr), alreadyAttacked);
                            ourQuickStrength += qLandStrength;
                        }
                        if (ourQuickStrength >= eShortStrength * 1.05f + 2.0f + eShortPotential) {
                            if (qBBStrength + qPlaneStrength + qBlitzStrength + qLandStrength > 0.0f) {
                                moveUnits.addAll(qunitMoved);
                                moveRoutes.addAll(qRoutes);
                                s_logger.finer("PTMa moving " + qunitMoved);
                                s_logger.finer("PTMa route " + qRoutes);
                                unitsAlreadyMoved.addAll(qAMoved);
                            }
                            moveUnits.add(tLoadUnits);
                            moveRoutes.add(shortRoute);
                            s_logger.finer("PTMb moving " + tLoadUnits);
                            s_logger.finer("PTMb route " + shortRoute);
                            unitsAlreadyMoved.addAll(tLoadUnits);
                            unitsAlreadyMoved.addAll(qtransMoved);
                        }
                    }
                } else {
                    targetTerr2 = SUtils.getSafestWaterTerr(targetTerr, transTerr, seaTerrAttacked, data, player, false, tFirst);
                }
                if (targetTerr2 == null || data.getMap().getWaterDistance(transTerr, targetTerr2) > 2 || (targetRoute = SUtils.getMaxSeaRoute(data, transTerr, targetTerr2, player, false, tDist)) == null || targetRoute.getEnd() == null) continue;
                ArrayList<Unit> defendingUnits = new ArrayList<Unit>();
                float enemyStrengthAtTarget = 0.0f;
                if (tFirst) {
                    ourShipStrength = (float)ourTransports.size() * 1.0f;
                }
                ArrayList<Unit> landUnits = new ArrayList<Unit>();
                for (Unit transport : ourTransports) {
                    landUnits.addAll(TransportTracker.transporting(transport));
                }
                float ourInvasionStrength = SUtils.strength(landUnits, true, false, tFirst);
                float xDefendingPotential = 0.0f;
                if (Matches.isTerritoryAllied(player, data).match(targetTerr)) {
                    defendingStrength = SUtils.getStrengthOfPotentialAttackers(targetTerr, data, player, tFirst, true, alreadyAttacked);
                    float alliedStrength = SUtils.strength(targetTerr.getUnits().getUnits(), false, false, tFirst);
                    ourInvasionStrength += alliedStrength * 1.35f + 6.0f;
                } else {
                    defendingUnits.addAll(targetTerr.getUnits().getMatches(Matches.enemyUnit(player, data)));
                    defendingStrength = SUtils.strength(defendingUnits, false, false, tFirst);
                    xDefendingPotential = SUtils.getStrengthOfPotentialAttackers(targetTerr, data, player, tFirst, true, alreadyAttacked);
                    float minStrengthNeeded = defendingStrength * 1.65f + 3.0f - ourInvasionStrength + xDefendingPotential * 0.25f;
                    BBStrength = SUtils.inviteBBEscort(targetTerr2, minStrengthNeeded, xMoved, xUnits, xRoutes, data, player);
                    blitzStrength = SUtils.inviteBlitzAttack(false, targetTerr, minStrengthNeeded -= BBStrength, xMoved, xUnits, xRoutes, data, player, true, false);
                    landStrength = SUtils.inviteLandAttack(false, targetTerr, minStrengthNeeded -= blitzStrength, xMoved, xUnits, xRoutes, data, player, true, false, alreadyAttacked);
                    planeStrength = SUtils.invitePlaneAttack(false, false, targetTerr, minStrengthNeeded -= landStrength, xMoved, xUnits, xRoutes, data, player);
                    minStrengthNeeded -= planeStrength;
                    ourInvasionStrength += BBStrength + blitzStrength + landStrength + planeStrength;
                }
                if (!(weCanWin = ourInvasionStrength > defendingStrength * 1.1f + Math.max(0.25f * xDefendingPotential, 2.0f))) continue;
                float compareStrength = 0.0f;
                ourShipStrength += BBStrength * 2.0f;
                List<Unit> enemyShipsAtTarget = targetTerr2.getUnits().getMatches(Matches.enemyUnit(player, data));
                enemyStrengthAtTarget = SUtils.strength(enemyShipsAtTarget, false, true, tFirst);
                List<Unit> shipsAtTarget = targetTerr2.getUnits().getMatches(Matches.alliedUnit(player, data));
                ourShipStrength += SUtils.strength(shipsAtTarget, false, true, tFirst);
                if (!(enemyStrengthAtTarget <= (compareStrength = ourShipStrength * 1.25f + ((ourShipStrength += SUtils.inviteShipAttack(targetTerr2, (strengthDiff = enemyStrengthAtTarget - ourShipStrength) * 2.5f, xMoved, xUnits, xRoutes, data, player, false, tFirst, false)) > 2.0f ? 3.0f : 0.0f))) && !(enemyStrengthAtTarget < 2.0f)) continue;
                alreadyAttacked.add(targetTerr);
                unitsAlreadyMoved.addAll(ourTransports);
                alreadyAttacked.add(targetTerr2);
                amphibMap.put(targetTerr2, targetTerr);
                if (transTerr != targetTerr2) {
                    ourTransports.addAll(landUnits);
                    moveUnits.add(new LinkedList<Unit>(ourTransports));
                    moveRoutes.add(targetRoute);
                    s_logger.finer("PTM moving " + ourTransports + " To land at " + targetTerr);
                    s_logger.finer("PTM route " + targetRoute);
                }
                if (xUnits.size() > 0) {
                    moveUnits.addAll(xUnits);
                    moveRoutes.addAll(xRoutes);
                    s_logger.finer("PTM moving " + xUnits + "to assist in invasion of " + targetTerr);
                    s_logger.finer("PTM route " + xRoutes);
                    unitsAlreadyMoved.addAll(xMoved);
                }
                if (!(enemyStrengthAtTarget > 2.0f)) continue;
                float checkStrength = ourShipStrength - SUtils.strength(shipsAtTarget, false, true, tFirst);
                ArrayList<Unit> markUnits = new ArrayList<Unit>();
                Iterator<Unit> shipIter = shipsAtTarget.iterator();
                while (shipIter.hasNext() && checkStrength * 1.2f + 2.0f < enemyStrengthAtTarget) {
                    Unit unitX = shipIter.next();
                    checkStrength += SUtils.uStrength(unitX, false, true, tFirst);
                    markUnits.add(unitX);
                }
                if (markUnits.size() <= 0) continue;
                unitsAlreadyMoved.addAll(markUnits);
            }
        }
        this.setAmphibMap(amphibMap);
    }

    private void amphibMapUnload(GameData data, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, PlayerID player) {
        CompositeMatchAnd<Unit> transportingUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsTransport, Matches.transportIsTransporting());
        HashMap<Territory, Territory> amphibMap = this.getAmphibMap();
        Set<Territory> invadeFrom = amphibMap.keySet();
        for (Territory transTerr : invadeFrom) {
            Territory targetTerr = amphibMap.get(transTerr);
            List<Unit> transports = transTerr.getUnits().getMatches(transportingUnit);
            ArrayList<Unit> tUnits = new ArrayList<Unit>();
            for (Unit transport : transports) {
                tUnits.addAll(TransportTracker.transporting(transport));
            }
            Route tRoute = data.getMap().getRoute(transTerr, targetTerr);
            if (tRoute == null || tRoute.getLength() != 1) continue;
            moveUnits.add(tUnits);
            moveRoutes.add(tRoute);
        }
    }

    private void populateTransportUnloadNonCom(boolean onlyMoved, GameData data, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, PlayerID player) {
        List<Territory> transTerr;
        CompositeMatchAnd<Unit> transUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsTransport);
        if (onlyMoved) {
            transUnit = new CompositeMatchAnd(transUnit, Matches.unitHasMoved);
        }
        if ((transTerr = SUtils.findTersWithUnitsMatching(data, player, transUnit)).isEmpty()) {
            return;
        }
        ArrayList unitsAlreadyMoved = new ArrayList();
        Territory capitol = TerritoryAttachment.getFirstOwnedCapitalOrFirstUnownedCapital(player, data);
        boolean capDanger = this.getCapDanger();
        boolean tFirst = this.transportsMayDieFirst();
        ArrayList ourFriendlyTerr = new ArrayList();
        HashMap<Territory, Float> rankMap = SUtils.rankAmphibReinforcementTerritories(data, null, player, tFirst);
        if (!capDanger) {
            rankMap.remove(capitol);
            ourFriendlyTerr.remove(capitol);
        }
        List<Territory> ourTerrNextToEnemyTerr = SUtils.getTerritoriesWithEnemyNeighbor(data, player, true, false);
        SUtils.removeNonAmphibTerritories(ourTerrNextToEnemyTerr, data);
        if (ourTerrNextToEnemyTerr.size() > 1) {
            SUtils.reorder(ourTerrNextToEnemyTerr, rankMap, true);
        }
        for (Territory xT : transTerr) {
            ArrayList<Territory> xTNeighbors = new ArrayList<Territory>(data.getMap().getNeighbors(xT, Matches.isTerritoryAllied(player, data)));
            xTNeighbors.retainAll(ourTerrNextToEnemyTerr);
            if (xTNeighbors.isEmpty()) continue;
            SUtils.reorder(xTNeighbors, rankMap, true);
            Territory landingTerr = (Territory)xTNeighbors.get(0);
            Route landingRoute = data.getMap().getRoute(xT, landingTerr);
            List<Unit> transUnits = xT.getUnits().getMatches(transUnit);
            Iterator<Unit> tIter = transUnits.iterator();
            ArrayList<Unit> landingUnits = new ArrayList<Unit>();
            while (tIter.hasNext()) {
                Unit transport = tIter.next();
                if (TransportTracker.transporting(transport) == null) continue;
                landingUnits.addAll(TransportTracker.transporting(transport));
            }
            if (landingUnits.isEmpty()) continue;
            moveUnits.add(landingUnits);
            moveRoutes.add(landingRoute);
            unitsAlreadyMoved.addAll(landingUnits);
        }
    }

    private void populateTransportUnload(GameData data, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, PlayerID player) {
        boolean tFirst = this.transportsMayDieFirst();
        int size = data.getMap().getTerritories().size();
        Territory[] eTerr = new Territory[size];
        float[] eStrength = new float[size];
        float eS = 0.0f;
        CompositeMatchAnd enemyUnit = new CompositeMatchAnd(Matches.enemyUnit(player, data));
        CompositeMatchAnd<Unit> landAndOwned = new CompositeMatchAnd<Unit>(Matches.UnitIsLand, Matches.unitIsOwnedBy(player));
        CompositeMatchAnd landAndEnemy = new CompositeMatchAnd(Matches.UnitIsLand, enemyUnit);
        CompositeMatchAnd airEnemyUnit = new CompositeMatchAnd(enemyUnit, Matches.UnitIsAir);
        CompositeMatchOr<Unit> landOrAirEnemy = new CompositeMatchOr<Unit>(landAndEnemy, airEnemyUnit);
        CompositeMatchAnd<Unit> transportingUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsTransport, Transporting);
        CompositeMatchAnd<Unit> enemyfactories = new CompositeMatchAnd<Unit>(Matches.UnitCanProduceUnits, enemyUnit);
        CompositeMatchAnd<Unit> transporting = new CompositeMatchAnd<Unit>(Matches.UnitIsTransport, Matches.transportIsTransporting());
        float remainingStrength = 100.0f;
        List<Territory> transTerr = SUtils.findTersWithUnitsMatching(data, player, transporting);
        if (transTerr.isEmpty()) {
            return;
        }
        List<Territory> enemyCaps = SUtils.findUnitTerr(data, player, enemyfactories);
        ArrayList<Territory> tempECaps = new ArrayList<Territory>(enemyCaps);
        ArrayList unitsAlreadyMoved = new ArrayList();
        ArrayList<Territory> ourFriendlyTerr = new ArrayList<Territory>();
        ArrayList<Territory> ourEnemyTerr = new ArrayList<Territory>();
        ArrayList<Territory> alreadyAttacked = new ArrayList<Territory>();
        HashMap<Territory, Float> rankMap = SUtils.rankTerritories(data, ourFriendlyTerr, ourEnemyTerr, null, player, tFirst, true, false);
        CompositeMatchAnd<Territory> enemyLand = new CompositeMatchAnd<Territory>(Matches.isTerritoryEnemy(player, data), Matches.TerritoryIsLand, Matches.TerritoryIsNotImpassable);
        for (Territory qT : tempECaps) {
            Set<Territory> nTerr = data.getMap().getNeighbors(qT, enemyLand);
            if (nTerr.size() <= 0) continue;
            enemyCaps.addAll(nTerr);
        }
        enemyCaps.retainAll(rankMap.keySet());
        SUtils.reorder(enemyCaps, rankMap, true);
        ArrayList<Unit> xAlreadyMoved = new ArrayList<Unit>();
        ArrayList<Collection<Unit>> xMoveUnits = new ArrayList<Collection<Unit>>();
        ArrayList<Route> xMoveRoutes = new ArrayList<Route>();
        for (Territory eC : enemyCaps) {
            Set<Territory> neighborTerr = data.getMap().getNeighbors(eC, Matches.TerritoryIsWater);
            List<Unit> capUnits = eC.getUnits().getMatches(landOrAirEnemy);
            float capStrength = SUtils.strength(capUnits, false, false, tFirst);
            float invadeStrength = SUtils.strength(eC.getUnits().getMatches(Matches.unitIsOwnedBy(player)), true, false, tFirst);
            if (Matches.isTerritoryFriendly(player, data).match(eC)) {
                for (Territory nF : neighborTerr) {
                    ArrayList<Unit> quickLandingUnits = new ArrayList<Unit>();
                    List<Unit> nFTrans = nF.getUnits().getMatches(transportingUnit);
                    for (Unit transport : nFTrans) {
                        quickLandingUnits.addAll(TransportTracker.transporting(transport));
                    }
                    Route quickLandRoute = new Route();
                    quickLandRoute.setStart(nF);
                    quickLandRoute.add(eC);
                    moveUnits.add(quickLandingUnits);
                    moveRoutes.add(quickLandRoute);
                    unitsAlreadyMoved.addAll(quickLandingUnits);
                    if (!transTerr.contains(nF)) continue;
                    transTerr.remove(nF);
                }
            }
            for (Territory nT : neighborTerr) {
                if (nT.getUnits().someMatch(transportingUnit)) {
                    float attackFactor;
                    List<Unit> specialLandUnits = nT.getUnits().getMatches(landAndOwned);
                    specialLandUnits.removeAll(unitsAlreadyMoved);
                    if (specialLandUnits.isEmpty()) continue;
                    invadeStrength = SUtils.strength(specialLandUnits, true, false, tFirst);
                    Set<Territory> attackNeighbors = data.getMap().getNeighbors(eC, Matches.isTerritoryFriendly(player, data));
                    float localStrength = 0.0f;
                    for (Territory aN : attackNeighbors) {
                        if (aN.isWater()) continue;
                        List<Unit> localUnits = aN.getUnits().getMatches(landAndOwned);
                        localUnits.removeAll(unitsAlreadyMoved);
                        if (localUnits.isEmpty()) continue;
                        localStrength += SUtils.strength(localUnits, true, false, tFirst);
                        xMoveUnits.add(localUnits);
                        Route localRoute = data.getMap().getLandRoute(aN, eC);
                        xMoveRoutes.add(localRoute);
                        xAlreadyMoved.addAll(localUnits);
                    }
                    float ourStrength = invadeStrength + localStrength;
                    remainingStrength = capStrength * 2.2f + 5.0f - ourStrength;
                    xAlreadyMoved.addAll(unitsAlreadyMoved);
                    float blitzStrength = SUtils.inviteBlitzAttack(false, eC, remainingStrength, xAlreadyMoved, xMoveUnits, xMoveRoutes, data, player, true, true);
                    float planeStrength = SUtils.invitePlaneAttack(false, false, eC, remainingStrength -= blitzStrength, xAlreadyMoved, xMoveUnits, xMoveRoutes, data, player);
                    remainingStrength -= planeStrength;
                    List<Territory> alliedTerr = SUtils.getNeighboringLandTerritories(data, player, eC);
                    float alliedStrength = 0.0f;
                    CompositeMatchAnd<Unit> alliedButNotMyUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player).invert(), Matches.alliedUnit(player, data));
                    for (Territory aCheck : alliedTerr) {
                        alliedStrength += SUtils.strength(aCheck.getUnits().getMatches(alliedButNotMyUnit), true, false, tFirst);
                    }
                    float f = attackFactor = alliedStrength > 0.75f * capStrength ? 0.92f : 1.04f;
                    if (invadeStrength + localStrength + blitzStrength + planeStrength >= attackFactor * capStrength) {
                        Route specialRoute = data.getMap().getRoute(nT, eC);
                        moveUnits.add(specialLandUnits);
                        moveRoutes.add(specialRoute);
                        unitsAlreadyMoved.addAll(specialLandUnits);
                        moveUnits.addAll(xMoveUnits);
                        moveRoutes.addAll(xMoveRoutes);
                        for (Collection collection : xMoveUnits) {
                            unitsAlreadyMoved.addAll(collection);
                        }
                        if (transTerr.contains(nT)) {
                            transTerr.remove(nT);
                        }
                        alreadyAttacked.add(eC);
                    }
                }
                xMoveUnits.clear();
                xMoveRoutes.clear();
                xAlreadyMoved.clear();
            }
        }
        for (Territory t : transTerr) {
            List<Unit> transUnits = t.getUnits().getMatches(transportingUnit);
            transUnits.removeAll(unitsAlreadyMoved);
            List<Unit> units = t.getUnits().getMatches(landAndOwned);
            units.removeAll(unitsAlreadyMoved);
            float ourStrength = SUtils.strength(units, true, false, tFirst);
            if (units.size() == 0) continue;
            List<Territory> enemy = SUtils.getNeighboringEnemyLandTerritories(data, player, t);
            ArrayList<Territory> enemyCopy = new ArrayList<Territory>(enemy);
            Map<Unit, Collection<Unit>> transMap = TransportTracker.transporting(transUnits);
            int i = 0;
            Iterator<Territory> i$ = enemy.iterator();
            while (i$.hasNext()) {
                Territory t2;
                eTerr[i] = t2 = i$.next();
                eStrength[i] = SUtils.strength(t2.getUnits().getMatches(landOrAirEnemy), false, false, tFirst);
                int n = i++;
                eStrength[n] = eStrength[n] - SUtils.strength(t2.getUnits().getMatches(Matches.unitIsOwnedBy(player)), true, false, tFirst);
            }
            float tmpStrength = 0.0f;
            Territory tmpTerr = null;
            for (int j2 = 0; j2 < i - 1; ++j2) {
                tmpTerr = eTerr[j2];
                tmpStrength = eStrength[j2];
                Set<Territory> badFactTerr = data.getMap().getNeighbors(tmpTerr, Matches.territoryIsEnemyNonNeutralAndHasEnemyUnitMatching(data, player, Matches.UnitCanProduceUnits));
                if (badFactTerr.size() > 0 && tmpStrength * 1.1f + 5.0f <= eStrength[j2 + 1] || !(tmpStrength < eStrength[j2 + 1])) continue;
                eTerr[j2] = eTerr[j2 + 1];
                eStrength[j2] = eStrength[j2 + 1];
                eTerr[j2 + 1] = tmpTerr;
                eStrength[j2 + 1] = tmpStrength;
            }
            for (Territory x : enemyCopy) {
                if (!Matches.isTerritoryEnemy(player, data).match(x) || !Matches.territoryIsEmptyOfCombatUnits(data, player).match(x)) continue;
                float topStrength = eStrength[0];
                float winStrength = 0.0f;
                float newStrength = ourStrength;
                for (int jC = 0; jC < enemy.size() - 1; ++jC) {
                    if (!enemy.contains(eTerr[jC]) || !(newStrength > (topStrength = eStrength[jC])) || winStrength != 0.0f) continue;
                    winStrength = topStrength;
                }
                Iterator<Unit> transIter = transUnits.iterator();
                boolean gotOne = false;
                while (transIter.hasNext() && !gotOne) {
                    float f;
                    Collection<Unit> transportUnits;
                    Unit transport = transIter.next();
                    if (!TransportTracker.isTransporting(transport) || transport == null || (transportUnits = transMap.get(transport)) == null || !(newStrength - (f = SUtils.strength(transportUnits, true, false, tFirst)) > winStrength)) continue;
                    Route xRoute = data.getMap().getRoute(t, x);
                    moveUnits.add(transportUnits);
                    moveRoutes.add(xRoute);
                    unitsAlreadyMoved.addAll(transportUnits);
                    enemy.remove(x);
                    ourStrength -= f;
                    gotOne = true;
                    alreadyAttacked.add(x);
                }
            }
            for (int j = 0; j < i; ++j) {
                float landStrength;
                boolean bl;
                units.removeAll(unitsAlreadyMoved);
                xAlreadyMoved.addAll(unitsAlreadyMoved);
                float ourStrength2 = ourStrength;
                eS = eStrength[j];
                Territory invadeTerr = eTerr[j];
                if (!enemy.contains(invadeTerr)) continue;
                float strengthNeeded = 2.15f * eS + 3.0f;
                float airStrength = 0.0f;
                float rStrength = strengthNeeded - (ourStrength2 += 0.0f);
                float planeStrength = SUtils.invitePlaneAttack(true, false, invadeTerr, rStrength, xAlreadyMoved, xMoveUnits, xMoveRoutes, data, player);
                rStrength -= planeStrength;
                float blitzStrength = SUtils.inviteBlitzAttack(false, invadeTerr, rStrength, xAlreadyMoved, xMoveUnits, xMoveRoutes, data, player, true, false);
                boolean bl2 = bl = planeStrength + blitzStrength + (landStrength = SUtils.inviteLandAttack(false, invadeTerr, rStrength -= blitzStrength, xAlreadyMoved, xMoveUnits, xMoveRoutes, data, player, true, false, alreadyAttacked)) + ourStrength > eS * 1.15f + 2.0f;
                if (bl) {
                    Route route = new Route();
                    route.setStart(t);
                    route.add(invadeTerr);
                    moveUnits.add(units);
                    moveRoutes.add(route);
                    unitsAlreadyMoved.addAll(units);
                    moveUnits.addAll(xMoveUnits);
                    moveRoutes.addAll(xMoveRoutes);
                    for (Collection collection : xMoveUnits) {
                        unitsAlreadyMoved.addAll(collection);
                    }
                    alreadyAttacked.add(invadeTerr);
                }
                xAlreadyMoved.clear();
                xMoveUnits.clear();
                xMoveRoutes.clear();
            }
        }
    }

    private void doMove(List<Collection<Unit>> moveUnits, List<Route> moveRoutes, List<Collection<Unit>> transportsToLoad, IMoveDelegate moveDel) {
        for (int i = 0; i < moveRoutes.size(); ++i) {
            this.pause();
            if (moveRoutes.get(i) == null || moveRoutes.get(i).getEnd() == null || moveRoutes.get(i).getStart() == null) {
                s_logger.fine("Route not valid" + moveRoutes.get(i) + " units:" + moveUnits.get(i));
                continue;
            }
            String result = transportsToLoad == null ? moveDel.move(moveUnits.get(i), moveRoutes.get(i)) : moveDel.move(moveUnits.get(i), moveRoutes.get(i), transportsToLoad.get(i));
            if (result == null) continue;
            s_logger.fine("could not move " + moveUnits.get(i) + " over " + moveRoutes.get(i) + " because : " + result + "\n");
        }
    }

    private boolean markFactoryUnits(GameData data, PlayerID player, Collection<Unit> unitsAlreadyMoved) {
        float capStrengthNeeded;
        Unit capUnit;
        HashMap<Territory, Float> capMap = this.determineCapDanger(player, data);
        Territory myCapital = TerritoryAttachment.getFirstOwnedCapitalOrFirstUnownedCapital(player, data);
        List<Unit> myCapUnits = myCapital.getUnits().getMatches(Matches.unitIsOwnedBy(player));
        List<Unit> alliedCapUnits = myCapital.getUnits().getMatches(Matches.alliedUnit(player, data));
        float alliedCapStrength = SUtils.strength(alliedCapUnits, false, false, true);
        Iterator<Unit> capUnitIter = myCapUnits.iterator();
        float actualAlliedStrength = alliedCapStrength - SUtils.strength(myCapUnits, false, false, true);
        for (capStrengthNeeded = capMap.get(myCapital).floatValue() - actualAlliedStrength; capUnitIter.hasNext() && capStrengthNeeded > 0.0f; capStrengthNeeded -= SUtils.uStrength(capUnit, false, false, true)) {
            capUnit = capUnitIter.next();
            unitsAlreadyMoved.add(capUnit);
        }
        boolean capDanger = capStrengthNeeded > 0.0f;
        return capDanger;
    }

    private void markBaseShips(GameData data, PlayerID player, List<Unit> alreadyMoved) {
        if (this.getKeepShipsAtBase() && this.getSeaTerr() != null) {
            Set<Territory> baseTerrs = data.getMap().getNeighbors(this.getSeaTerr(), Matches.TerritoryIsWater);
            for (Territory bT : baseTerrs) {
                alreadyMoved.addAll(bT.getUnits().getMatches(Matches.unitIsOwnedBy(player)));
            }
        }
    }

    private void specialPlaneAttack(GameData data, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, PlayerID player) {
        final HashSet alreadyMoved = new HashSet();
        boolean tFirst = this.transportsMayDieFirst();
        CompositeMatchAnd notAlreadyMoved = new CompositeMatchAnd(new Match<Unit>(){

            @Override
            public boolean match(Unit o) {
                return !alreadyMoved.contains(o);
            }
        });
        CompositeMatchAnd ownedUnit = new CompositeMatchAnd(Matches.unitIsOwnedBy(player));
        CompositeMatchAnd HasntMoved2 = new CompositeMatchAnd(Matches.unitIsOwnedBy(player), Matches.unitHasNotMoved, notAlreadyMoved);
        CompositeMatchAnd ownedAndNotMoved = new CompositeMatchAnd(ownedUnit, Matches.unitHasNotMoved);
        CompositeMatchAnd<Unit> airAttackUnit = new CompositeMatchAnd<Unit>(ownedAndNotMoved, Matches.UnitIsAir);
        CompositeMatchAnd<Unit> enemySubUnit = new CompositeMatchAnd<Unit>(Matches.enemyUnit(player, data), Matches.UnitIsSub);
        CompositeMatchAnd<Unit> fighterUnit = new CompositeMatchAnd<Unit>(Matches.UnitCanLandOnCarrier, HasntMoved2);
        CompositeMatchAnd<Unit> bomberUnit = new CompositeMatchAnd<Unit>(Matches.UnitIsStrategicBomber, HasntMoved2);
        CompositeMatchAnd<Unit> destroyerUnit = new CompositeMatchAnd<Unit>(ownedUnit, Matches.UnitIsDestroyer);
        CompositeMatchAnd<Territory> noEnemyAA = new CompositeMatchAnd<Territory>(Matches.territoryHasEnemyAAforCombatOnly(player, data).invert(), Matches.TerritoryIsNotImpassable);
        List<Territory> myAirTerr = SUtils.findUnitTerr(data, player, airAttackUnit);
        ArrayList<Unit> unitsAlreadyMoved = new ArrayList<Unit>();
        float planeStrength = 0.0f;
        float shipStrength = 0.0f;
        for (Territory AttackFrom : myAirTerr) {
            List<Unit> myFighters = AttackFrom.getUnits().getMatches(fighterUnit);
            float myFighterStrength = SUtils.strength(myFighters, true, false, false);
            List<Unit> myBombers = AttackFrom.getUnits().getMatches(bomberUnit);
            float myBomberStrength = SUtils.strength(myBombers, true, false, false);
            float myTotalStrength = myFighterStrength + myBomberStrength;
            Set<Territory> myNeighbors = data.getMap().getNeighbors(AttackFrom);
            Set<Territory> enemyNeighbors = data.getMap().getNeighbors(AttackFrom, Matches.territoryHasEnemyUnits(player, data));
            for (Territory check2 : myNeighbors) {
                Set<Territory> check2Terr = data.getMap().getNeighbors(check2, Matches.territoryHasEnemyUnits(player, data));
                if (check2Terr == null || check2Terr.size() <= 0) continue;
                for (Territory enemyOnly : check2Terr) {
                    if (enemyNeighbors.contains(enemyOnly)) continue;
                    enemyNeighbors.add(enemyOnly);
                }
            }
            ArrayList<Territory> waterEnemies = new ArrayList<Territory>();
            for (Territory w : enemyNeighbors) {
                if (!w.isWater()) continue;
                waterEnemies.add(w);
                List<Unit> eUnits = w.getUnits().getMatches(Matches.enemyUnit(player, data));
                float waterStrength = SUtils.strength(eUnits, false, true, tFirst);
                float ourWaterStrength = 0.0f;
                if (w.getUnits().allMatch(enemySubUnit) && Properties.getAirAttackSubRestricted(data)) {
                    List<Territory> destroyerTerr = SUtils.findOurShips(w, data, player, destroyerUnit);
                    boolean dAttacked = false;
                    if (destroyerTerr.size() > 0) {
                        for (Territory dT : destroyerTerr) {
                            List<Unit> destroyers;
                            int n;
                            Route dRoute = SUtils.getMaxSeaRoute(data, dT, w, player, true, n = MoveValidator.getLeastMovement(destroyers = dT.getUnits().getMatches(destroyerUnit)));
                            if (dRoute == null || dRoute.getLength() > 2) continue;
                            ArrayList<Unit> dUnits = new ArrayList<Unit>();
                            for (Unit d : destroyers) {
                                if (!MoveValidator.hasEnoughMovement(d, dRoute)) continue;
                                dUnits.add(d);
                            }
                            if (dUnits.size() <= 0) continue;
                            moveUnits.add(dUnits);
                            moveRoutes.add(dRoute);
                            unitsAlreadyMoved.addAll(dUnits);
                            dAttacked = true;
                            ourWaterStrength += SUtils.strength(dUnits, true, false, tFirst);
                        }
                    }
                    if (!dAttacked) continue;
                    float stillNeeded = waterStrength * 2.25f + 4.0f - ourWaterStrength;
                    planeStrength = SUtils.invitePlaneAttack(false, false, w, stillNeeded, unitsAlreadyMoved, moveUnits, moveRoutes, data, player);
                    stillNeeded -= planeStrength;
                    continue;
                }
                float stillNeeded = waterStrength * 2.25f + 4.0f;
                ArrayList<Collection<Unit>> xMoveUnits = new ArrayList<Collection<Unit>>();
                ArrayList<Route> xMoveRoutes = new ArrayList<Route>();
                ArrayList<Unit> xMoved = new ArrayList<Unit>(unitsAlreadyMoved);
                planeStrength = SUtils.invitePlaneAttack(false, false, w, stillNeeded, xMoved, xMoveUnits, xMoveRoutes, data, player);
                stillNeeded -= planeStrength;
                if (!((stillNeeded -= (shipStrength = SUtils.inviteShipAttack(w, stillNeeded, xMoved, xMoveUnits, xMoveRoutes, data, player, true, tFirst, false))) <= 1.0f)) continue;
                moveUnits.addAll(xMoveUnits);
                moveRoutes.addAll(xMoveRoutes);
                for (Collection collection : xMoveUnits) {
                    unitsAlreadyMoved.addAll(collection);
                }
            }
            enemyNeighbors.removeAll(waterEnemies);
            myFighters.removeAll(unitsAlreadyMoved);
            myBombers.removeAll(unitsAlreadyMoved);
            myFighterStrength = SUtils.strength(myFighters, true, false, tFirst);
            myBomberStrength = SUtils.strength(myBombers, true, false, tFirst);
            myTotalStrength = myFighterStrength + myBomberStrength;
            for (Territory badGuys : enemyNeighbors) {
                List<Unit> enemyUnits = badGuys.getUnits().getMatches(Matches.enemyUnit(player, data));
                float badGuyStrength = 0.0f;
                badGuyStrength = badGuys.isWater() ? SUtils.strength(enemyUnits, false, true, tFirst) : SUtils.strength(enemyUnits, false, false, tFirst);
                int badGuyCount = enemyUnits.size();
                float needStrength = 2.4f * badGuyStrength + 3.0f;
                float actualStrength = 0.0f;
                ArrayList<Unit> myAttackers = new ArrayList<Unit>();
                ArrayList<Unit> myAttackers2 = new ArrayList<Unit>();
                ArrayList<Unit> allUnits = new ArrayList<Unit>();
                allUnits.addAll(myFighters);
                allUnits.addAll(myBombers);
                HashMap<PlayerID, IntegerMap<UnitType>> hashMap = SUtils.getPlayerCostMap(data);
                boolean weWinTUV = SUtils.calculateTUVDifference(badGuys, allUnits, enemyUnits, hashMap, player, data, false, Properties.getAirAttackSubRestricted(data), tFirst);
                if (!(myTotalStrength > needStrength) || !weWinTUV) continue;
                int actualAttackers = 0;
                Route myRoute = data.getMap().getRoute(AttackFrom, badGuys, noEnemyAA);
                if (myRoute == null || myRoute.getEnd() == null) continue;
                if (!myFighters.isEmpty() && AirMovementValidator.canLand(myFighters, myRoute.getEnd(), player, data)) {
                    for (Unit f : myFighters) {
                        if (!(actualStrength < needStrength)) continue;
                        myAttackers.add(f);
                        actualStrength += SUtils.airstrength(f, true);
                        ++actualAttackers;
                    }
                    if (actualAttackers > 0 && actualStrength > needStrength) {
                        moveUnits.add(myAttackers);
                        moveRoutes.add(myRoute);
                        alreadyMoved.addAll(myAttackers);
                        myFighters.removeAll(myAttackers);
                    }
                }
                if (actualStrength > needStrength && actualAttackers > badGuyCount + 1 || myBombers.size() == 0 || myRoute.getEnd() == null || myBombers.isEmpty() || !AirMovementValidator.canLand(myBombers, myRoute.getEnd(), player, data)) continue;
                for (Unit b : myBombers) {
                    if (!(actualStrength < needStrength) && actualAttackers > badGuyCount + 1) continue;
                    myAttackers2.add(b);
                    actualStrength += SUtils.airstrength(b, true);
                }
                if (myAttackers.size() <= 0) continue;
                moveUnits.add(myAttackers2);
                moveRoutes.add(myRoute);
                alreadyMoved.addAll(myAttackers2);
                myBombers.removeAll(myAttackers2);
            }
        }
    }

    private void protectOurAllies(boolean nonCombat, GameData data, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, PlayerID player) {
        CompositeMatchAnd<Unit> landUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsLand, Matches.UnitIsNotInfrastructure);
        CompositeMatchAnd<Unit> carrierUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsCarrier);
        CompositeMatchAnd<Unit> fighterUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitCanLandOnCarrier);
        if (!nonCombat) {
            landUnit.add(Matches.UnitCanNotMoveDuringCombatMove.invert());
            carrierUnit.add(Matches.UnitCanNotMoveDuringCombatMove.invert());
            fighterUnit.add(Matches.UnitCanNotMoveDuringCombatMove.invert());
        }
        ArrayList<Territory> threats = new ArrayList<Territory>();
        boolean tFirst = this.transportsMayDieFirst();
        boolean noncombat = true;
        ArrayList<Unit> unitsAlreadyMoved = new ArrayList<Unit>();
        Territory myCapital = TerritoryAttachment.getFirstOwnedCapitalOrFirstUnownedCapital(player, data);
        boolean alliedCapDanger = SUtils.threatToAlliedCapitals(data, player, threats, tFirst);
        List<Territory> seaTerrAttacked = this.getSeaTerrAttacked();
        List<Territory> alreadyAttacked = Collections.emptyList();
        if (alliedCapDanger) {
            ArrayList<Territory> threatRemoved = new ArrayList<Territory>();
            float planeStrength = 0.0f;
            for (Territory threatTerr : threats) {
                Set<Territory> allThreats = data.getMap().getNeighbors(threatTerr, Matches.isTerritoryEnemyAndNotUnownedWaterOrImpassibleOrRestricted(player, data));
                HashMap<Territory, Float> threatMap = new HashMap<Territory, Float>();
                for (Territory checkThreat : allThreats) {
                    float eStrength = SUtils.strength(checkThreat.getUnits().getMatches(Matches.enemyUnit(player, data)), false, false, tFirst);
                    threatMap.put(checkThreat, Float.valueOf(eStrength));
                }
                ArrayList<Territory> allThreatTerr = new ArrayList<Territory>(allThreats);
                SUtils.reorder(allThreatTerr, threatMap, true);
                ArrayList<Collection<Unit>> xMovesKeep = new ArrayList<Collection<Unit>>();
                ArrayList<Route> xRoutesKeep = new ArrayList<Route>();
                ArrayList<Unit> xMovedKeep = new ArrayList<Unit>();
                for (Territory checkThreat : allThreatTerr) {
                    float eStrength = ((Float)threatMap.get(checkThreat)).floatValue();
                    ArrayList<Collection<Unit>> arrayList = new ArrayList<Collection<Unit>>();
                    ArrayList<Route> xRoutes = new ArrayList<Route>();
                    ArrayList<Unit> xMovedUnits = new ArrayList<Unit>();
                    xMovedUnits.addAll(xMovedKeep);
                    float needStrength = eStrength * 1.25f + 3.0f;
                    needStrength = SUtils.inviteLandAttack(false, checkThreat, needStrength, xMovedUnits, arrayList, xRoutes, data, player, true, true, alreadyAttacked);
                    needStrength = SUtils.inviteTransports(false, checkThreat, needStrength, xMovedUnits, arrayList, xRoutes, data, player, tFirst, false, seaTerrAttacked);
                    needStrength = SUtils.inviteBlitzAttack(false, checkThreat, needStrength, xMovedUnits, arrayList, xRoutes, data, player, true, true);
                    float thisPlaneStrength = SUtils.invitePlaneAttack(false, false, checkThreat, needStrength, xMovedUnits, arrayList, xRoutes, data, player);
                    planeStrength += thisPlaneStrength;
                    if (!((needStrength -= thisPlaneStrength) < 0.0f)) continue;
                    threatRemoved.add(checkThreat);
                    xMovedKeep.addAll(xMovedUnits);
                    xMovesKeep.addAll(arrayList);
                    xRoutesKeep.addAll(xRoutes);
                }
                float newThreat = SUtils.getStrengthOfPotentialAttackers(threatTerr, data, player, tFirst, true, threatRemoved);
                float alliedStrength = SUtils.strength(threatTerr.getUnits().getUnits(), false, false, tFirst) + planeStrength;
                if (!(alliedStrength < newThreat)) continue;
                for (Collection collection : xMovesKeep) {
                    moveUnits.add(collection);
                }
                moveRoutes.addAll(xRoutesKeep);
                unitsAlreadyMoved.addAll(xMovedKeep);
            }
            if (SUtils.shipThreatToTerr(myCapital, data, player, tFirst) > 2) {
                List<Territory> fighterTerr = SUtils.findOnlyMyShips(myCapital, data, player, carrierUnit);
                for (Territory fT : fighterTerr) {
                    List<Unit> fighterUnits = fT.getUnits().getMatches(fighterUnit);
                    fighterUnits.removeAll(unitsAlreadyMoved);
                    unitsAlreadyMoved.addAll(fighterUnits);
                }
                List<Territory> transportTerr = SUtils.findOnlyMyShips(myCapital, data, player, Matches.UnitIsTransport);
                if (tFirst) {
                    for (Territory tranTerr : transportTerr) {
                        unitsAlreadyMoved.addAll(tranTerr.getUnits().getMatches(Matches.UnitIsTransport));
                    }
                }
            }
            for (Territory testCap : threats) {
                float remainingStrengthNeeded = SUtils.getStrengthOfPotentialAttackers(testCap, data, player, tFirst, true, null);
                float blitzStrength = SUtils.inviteBlitzAttack(true, testCap, remainingStrengthNeeded -= SUtils.strength(testCap.getUnits().getUnits(), false, false, tFirst), unitsAlreadyMoved, moveUnits, moveRoutes, data, player, false, true);
                planeStrength = SUtils.invitePlaneAttack(true, false, testCap, remainingStrengthNeeded -= blitzStrength, unitsAlreadyMoved, moveUnits, moveRoutes, data, player);
                remainingStrengthNeeded -= planeStrength;
                Set<Territory> copyOne = data.getMap().getNeighbors(testCap, 1);
                for (Territory moveFrom : copyOne) {
                    if (moveFrom.isWater() || !moveFrom.getUnits().someMatch(landUnit)) continue;
                    List<Unit> helpUnits = moveFrom.getUnits().getMatches(landUnit);
                    Route aRoute = data.getMap().getRoute(moveFrom, testCap, Matches.territoryHasEnemyAAforCombatOnly(player, data).invert());
                    if (aRoute == null) continue;
                    if (MoveValidator.hasEnoughMovement(helpUnits, aRoute)) {
                        moveUnits.add(helpUnits);
                        moveRoutes.add(aRoute);
                        unitsAlreadyMoved.addAll(helpUnits);
                        continue;
                    }
                    ArrayList<Unit> workList = new ArrayList<Unit>();
                    for (Unit unit : helpUnits) {
                        if (!MoveValidator.hasEnoughMovement(unit, aRoute)) continue;
                        workList.add(unit);
                    }
                    if (workList.size() <= 0) continue;
                    moveUnits.add(workList);
                    moveRoutes.add(aRoute);
                    unitsAlreadyMoved.addAll(workList);
                }
                if (SUtils.isWaterAt(testCap, data)) {
                    SUtils.inviteTransports(true, testCap, remainingStrengthNeeded, unitsAlreadyMoved, moveUnits, moveRoutes, data, player, tFirst, false, null);
                    continue;
                }
                Set<Territory> testCapNeighbors = data.getMap().getNeighbors(testCap, Matches.isTerritoryAllied(player, data));
                for (Territory tCN : testCapNeighbors) {
                    SUtils.inviteTransports(true, tCN, remainingStrengthNeeded, unitsAlreadyMoved, moveUnits, moveRoutes, data, player, tFirst, false, null);
                }
            }
        }
    }

    private void bringShipsToTransports(GameData data, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, PlayerID player) {
        boolean tFirst = this.transportsMayDieFirst();
        HashSet<Unit> alreadyMoved = new HashSet<Unit>();
        CompositeMatchAnd ownedUnit = new CompositeMatchAnd(Matches.unitIsOwnedBy(player));
        CompositeMatchAnd<Unit> mySeaAirUnit = new CompositeMatchAnd<Unit>(ownedUnit, Matches.UnitIsNotTransport);
        CompositeMatchAnd myCarrierUnit = new CompositeMatchAnd(ownedUnit, Matches.UnitIsCarrier);
        CompositeMatchAnd<Unit> myAirUnit = new CompositeMatchAnd<Unit>(ownedUnit, Matches.UnitCanLandOnCarrier);
        CompositeMatchOr<Unit> myCarrierGroup = new CompositeMatchOr<Unit>(myCarrierUnit, myAirUnit);
        CompositeMatchAnd<Unit> alliedTransport = new CompositeMatchAnd<Unit>(Matches.alliedUnit(player, data), Matches.UnitIsTransport);
        CompositeMatchAnd alliedSeaAttackUnit = new CompositeMatchAnd(Matches.alliedUnit(player, data), Matches.UnitIsSea, Matches.UnitIsNotTransport);
        CompositeMatchAnd alliedAirAttackUnit = new CompositeMatchAnd(Matches.alliedUnit(player, data), Matches.UnitIsAir);
        CompositeMatchOr<Unit> alliedSeaAirAttackUnit = new CompositeMatchOr<Unit>(alliedSeaAttackUnit, alliedAirAttackUnit);
        HashMap<Territory, Collection<Unit>> shipsMap = new HashMap<Territory, Collection<Unit>>();
        int allShips = 0;
        int enemyShips = 0;
        List<PlayerID> ePlayers = SUtils.getEnemyPlayers(data, player);
        PlayerID ePTemp = ePlayers.get(0);
        List<PlayerID> alliedPlayers = SUtils.getEnemyPlayers(data, ePTemp);
        for (PlayerID ePlayer : ePlayers) {
            enemyShips += this.countSeaUnits(data, ePlayer);
        }
        for (PlayerID aPlayer : alliedPlayers) {
            allShips += this.countSeaUnits(data, aPlayer);
        }
        List<Territory> alliedTransTerr = SUtils.findUnitTerr(data, player, alliedTransport);
        HashMap<Territory, Float> attackAtTrans = new HashMap<Territory, Float>();
        Iterator<Territory> aTIter = alliedTransTerr.iterator();
        while (aTIter.hasNext()) {
            Territory aT = aTIter.next();
            float aTEStrength = SUtils.getStrengthOfPotentialAttackers(aT, data, player, tFirst, false, null);
            if (aTEStrength < 2.0f) {
                aTIter.remove();
                continue;
            }
            attackAtTrans.put(aT, Float.valueOf(aTEStrength));
        }
        SUtils.reorder(alliedTransTerr, attackAtTrans, true);
        for (Territory sendToTrans : alliedTransTerr) {
            float enemyStrength;
            float targetStrength = enemyStrength * 1.25f + ((enemyStrength = ((Float)attackAtTrans.get(sendToTrans)).floatValue()) > 2.0f ? 3.0f : 0.0f);
            float strengthAdded = 0.0f;
            if (tFirst) {
                strengthAdded += SUtils.strength(sendToTrans.getUnits().getMatches(Matches.UnitIsTransport), false, true, tFirst);
            }
            List<Unit> mySeaUnits = sendToTrans.getUnits().getMatches(mySeaAirUnit);
            mySeaUnits.removeAll(alreadyMoved);
            List<Unit> alliedSeaUnits = sendToTrans.getUnits().getMatches(alliedSeaAirAttackUnit);
            alliedSeaUnits.removeAll(mySeaUnits);
            float alliedStrength = SUtils.strength(alliedSeaUnits, false, true, tFirst);
            strengthAdded += alliedStrength;
            if ((targetStrength -= alliedStrength) <= 0.0f) continue;
            ArrayList<Collection<Unit>> xUnits = new ArrayList<Collection<Unit>>();
            ArrayList<Unit> xMoved = new ArrayList<Unit>(alreadyMoved);
            ArrayList<Route> xRoutes = new ArrayList<Route>();
            Iterator<Unit> mySeaIter = mySeaUnits.iterator();
            while (mySeaIter.hasNext() && targetStrength <= 0.0f) {
                Unit myUnit = mySeaIter.next();
                if (((Match)myAirUnit).match(myUnit)) continue;
                float uStrength = 0.0f;
                if (Matches.UnitIsCarrier.match(myUnit)) {
                    ArrayList<Unit> carrierGroup = new ArrayList<Unit>(sendToTrans.getUnits().getMatches(myCarrierGroup));
                    uStrength = SUtils.strength(carrierGroup, false, true, tFirst);
                    xMoved.addAll(carrierGroup);
                } else {
                    uStrength = SUtils.uStrength(myUnit, false, true, tFirst);
                    xMoved.add(myUnit);
                }
                targetStrength -= uStrength;
                strengthAdded += uStrength;
            }
            float shipStrength = SUtils.inviteShipAttack(sendToTrans, targetStrength, xMoved, xUnits, xRoutes, data, player, false, tFirst, false);
            strengthAdded += shipStrength;
            moveUnits.addAll(xUnits);
            moveRoutes.addAll(xRoutes);
            alreadyMoved.addAll(xMoved);
        }
        int totShipMoves = moveUnits.size();
        for (int i = 0; i < totShipMoves; ++i) {
            Collection<Unit> newUnits = moveUnits.get(i);
            Route thisRoute = moveRoutes.get(i);
            Territory endTerr = thisRoute.getEnd();
            if (shipsMap.containsKey(endTerr)) {
                newUnits.addAll(shipsMap.get(endTerr));
            }
            shipsMap.put(endTerr, newUnits);
        }
        this.setShipsMovedMap(shipsMap);
    }

    private void secondLookSea(GameData data, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, PlayerID player) {
        CompositeMatchAnd ownedUnit = new CompositeMatchAnd(Matches.unitIsOwnedBy(player));
        CompositeMatchAnd<Unit> enemySeaUnit = new CompositeMatchAnd<Unit>(Matches.UnitIsSea, Matches.enemyUnit(player, data));
        CompositeMatchAnd<Unit> seaAttackUnit = new CompositeMatchAnd<Unit>(ownedUnit, Matches.UnitIsSea, Matches.UnitIsNotTransport);
        CompositeMatchAnd<Unit> transportUnit = new CompositeMatchAnd<Unit>(ownedUnit, Matches.UnitIsTransport);
        CompositeMatchAnd airAttackUnit = new CompositeMatchAnd(ownedUnit, Matches.UnitIsAir);
        CompositeMatchOr<Unit> seaAirAttackUnit = new CompositeMatchOr<Unit>(seaAttackUnit, airAttackUnit);
        CompositeMatchAnd alliedSeaAttackUnit = new CompositeMatchAnd(Matches.alliedUnit(player, data), Matches.UnitIsSea, Matches.unitIsOwnedBy(player).invert());
        CompositeMatchAnd alliedAirAttackUnit = new CompositeMatchAnd(Matches.alliedUnit(player, data), Matches.UnitIsAir, Matches.unitIsOwnedBy(player).invert());
        CompositeMatchAnd<Unit> alliedTransport = new CompositeMatchAnd<Unit>(Matches.alliedUnit(player, data), Matches.UnitIsTransport, Matches.unitIsOwnedBy(player).invert());
        CompositeMatchOr<Unit> alliedSeaAirAttackUnit = new CompositeMatchOr<Unit>(alliedSeaAttackUnit, alliedAirAttackUnit);
        CompositeMatchAnd<Territory> routeCond = new CompositeMatchAnd<Territory>(Matches.TerritoryIsWater, Matches.territoryHasNoEnemyUnits(player, data));
        CompositeMatchAnd<Territory> endCond = new CompositeMatchAnd<Territory>(Matches.TerritoryIsWater, Matches.territoryHasEnemyUnits(player, data));
        List<Territory> seaAttackTerr = SUtils.findTersWithUnitsMatching(data, player, seaAttackUnit);
        boolean tFirst = this.transportsMayDieFirst();
        HashMap<Territory, Collection<Unit>> shipsMap = this.getShipsMovedMap();
        ArrayList<Unit> alreadyMoved = new ArrayList<Unit>();
        for (Territory moveTerr : seaAttackTerr) {
            Route eRoute2;
            boolean alliedUnitsPresent;
            int moveDist;
            if (shipsMap.containsKey(moveTerr)) {
                alreadyMoved.addAll(shipsMap.get(moveTerr));
            }
            List<Unit> attackUnits = moveTerr.getUnits().getMatches(seaAirAttackUnit);
            attackUnits.removeAll(alreadyMoved);
            if (attackUnits.isEmpty() || (moveDist = MoveValidator.getLeastMovement(attackUnits)) == 0) continue;
            List<Unit> transportUnits = moveTerr.getUnits().getMatches(transportUnit);
            boolean transportUnitsPresent = transportUnits.size() > 0;
            List<Unit> alliedTransports = moveTerr.getUnits().getMatches(alliedTransport);
            float thisThreat = SUtils.getStrengthOfPotentialAttackers(moveTerr, data, player, tFirst, false, null);
            float myStrength = SUtils.strength(attackUnits, false, true, tFirst);
            float alliedStrength = SUtils.strength(moveTerr.getUnits().getMatches(alliedSeaAirAttackUnit), false, true, tFirst);
            boolean bl = alliedUnitsPresent = alliedStrength > 0.0f || alliedTransports.size() > 0;
            if (!(alliedUnitsPresent && alliedStrength > thisThreat * 0.75f || thisThreat == 0.0f) && (alliedUnitsPresent || transportUnitsPresent)) continue;
            int maxUnits = 100;
            Route eRoute = SUtils.findNearestMaxContaining(moveTerr, endCond, routeCond, enemySeaUnit, 100, data);
            if (eRoute == null) continue;
            if (MoveValidator.validateCanal(eRoute, null, player, data) == null && eRoute.getLength() > moveDist) {
                Route changeRoute = new Route();
                changeRoute.setStart(moveTerr);
                for (int i = 1; i <= moveDist; ++i) {
                    changeRoute.add(eRoute.getTerritories().get(i));
                }
                eRoute = changeRoute;
            }
            if (MoveValidator.validateCanal(eRoute, null, player, data) == null || (eRoute2 = SUtils.getMaxSeaRoute(data, moveTerr, eRoute.getEnd(), player, false, moveDist)) == null || eRoute2.getEnd() == null) continue;
            float endStrength = SUtils.getStrengthOfPotentialAttackers(eRoute2.getEnd(), data, player, tFirst, false, null);
            Route xRoute = new Route();
            if (myStrength > endStrength) {
                xRoute = eRoute2;
            } else {
                eRoute2.getTerritories().remove(eRoute2.getEnd());
                float endStrength2 = SUtils.getStrengthOfPotentialAttackers(eRoute2.getEnd(), data, player, tFirst, false, null);
                float myStrength2 = SUtils.strength(eRoute2.getEnd().getUnits().getMatches(Matches.alliedUnit(player, data)), false, true, tFirst);
                xRoute = (myStrength2 += myStrength) > endStrength2 * 0.65f ? eRoute2 : null;
            }
            if (xRoute == null) continue;
            ArrayList<Unit> tUnits = new ArrayList<Unit>();
            if (MoveValidator.hasEnoughMovement(attackUnits, xRoute)) {
                tUnits.addAll(attackUnits);
            } else {
                for (Unit moveUnit : attackUnits) {
                    if (!MoveValidator.hasEnoughMovement(moveUnit, xRoute)) continue;
                    tUnits.add(moveUnit);
                }
            }
            if (tUnits.size() <= 0) continue;
            moveUnits.add(tUnits);
            moveRoutes.add(xRoute);
        }
    }

    private void populateNonCombatSea(boolean nonCombat, GameData data, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, PlayerID player) {
        boolean tFirst = this.transportsMayDieFirst();
        this.setImpassableTerrs(player);
        Collection<Territory> impassableTerrs = this.getImpassableTerrs();
        final HashSet<Unit> alreadyMoved = new HashSet<Unit>();
        Territory myCapital = TerritoryAttachment.getFirstOwnedCapitalOrFirstUnownedCapital(player, data);
        HashMap<Territory, Collection<Unit>> shipsMovedMap = this.getShipsMovedMap();
        CompositeMatchAnd notAlreadyMoved = new CompositeMatchAnd(new Match<Unit>(){

            @Override
            public boolean match(Unit o) {
                return !alreadyMoved.contains(o);
            }
        });
        CompositeMatchAnd ownedUnit = new CompositeMatchAnd(Matches.unitIsOwnedBy(player));
        CompositeMatchAnd<Unit> ownedAC = new CompositeMatchAnd<Unit>(ownedUnit, Matches.UnitIsCarrier);
        CompositeMatchAnd HasntMoved2 = new CompositeMatchAnd(Matches.unitHasNotMoved, notAlreadyMoved);
        CompositeMatchAnd<Unit> enemySeaUnit = new CompositeMatchAnd<Unit>(Matches.UnitIsSea, Matches.enemyUnit(player, data));
        CompositeMatchAnd<Unit> seaAttackUnit = new CompositeMatchAnd<Unit>(ownedUnit, Matches.UnitIsSea, Matches.UnitIsNotTransport);
        CompositeMatchAnd<Unit> airAttackUnit = new CompositeMatchAnd<Unit>(ownedUnit, Matches.UnitIsAir);
        CompositeMatchOr<Unit> seaAirAttackUnit = new CompositeMatchOr<Unit>(seaAttackUnit, airAttackUnit);
        CompositeMatchAnd<Unit> seaAirAttackUnitNotMoved = new CompositeMatchAnd<Unit>(seaAirAttackUnit, HasntMoved2);
        CompositeMatchAnd<Unit> fighterUnit = new CompositeMatchAnd<Unit>(Matches.UnitCanLandOnCarrier, ownedUnit, HasntMoved2);
        CompositeMatchAnd<Unit> bomberUnit = new CompositeMatchAnd<Unit>(Matches.UnitIsStrategicBomber, ownedUnit, HasntMoved2);
        CompositeMatchAnd<Unit> carrierCanMove = new CompositeMatchAnd<Unit>(Matches.unitHasNotMoved, ownedAC);
        CompositeMatchAnd alliedSeaAttackUnit = new CompositeMatchAnd(Matches.alliedUnit(player, data), Matches.UnitIsSea);
        CompositeMatchAnd alliedAirAttackUnit = new CompositeMatchAnd(Matches.alliedUnit(player, data), Matches.UnitIsAir);
        CompositeMatchOr<Unit> alliedSeaAirAttackUnit = new CompositeMatchOr<Unit>(alliedSeaAttackUnit, alliedAirAttackUnit);
        CompositeMatchAnd<Territory> noNeutralOrAA = new CompositeMatchAnd<Territory>(Matches.TerritoryIsNotImpassable, Matches.territoryHasEnemyAAforCombatOnly(player, data).invert());
        CompositeMatchAnd<Territory> noEnemyWater = new CompositeMatchAnd<Territory>(Matches.TerritoryIsWater, Matches.territoryHasNoEnemyUnits(player, data));
        CompositeMatchAnd<Territory> enemyWater = new CompositeMatchAnd<Territory>(Matches.TerritoryIsWater, Matches.territoryHasEnemyUnits(player, data));
        List<Territory> seaAttackTerr = SUtils.findTersWithUnitsMatching(data, player, seaAttackUnit);
        List<Territory> enemySeaTerr = SUtils.findUnitTerr(data, player, enemySeaUnit);
        ArrayList<Territory> skippedTerr = new ArrayList<Territory>();
        ArrayList<Unit> xMoved = new ArrayList<Unit>();
        this.markBaseShips(data, player, xMoved);
        Territory seaFactTerr = this.getSeaTerr();
        if (xMoved.size() > 0) {
            Set<Territory> neighborList = data.getMap().getNeighbors(myCapital, Matches.TerritoryIsWater);
            ArrayList<Route> xR = new ArrayList<Route>();
            ArrayList<Collection<Unit>> xM = new ArrayList<Collection<Unit>>();
            ArrayList<Unit> xAM = new ArrayList<Unit>();
            int maxShips = 0;
            Territory maxShipTerr = null;
            Territory maxStrengthTerr = null;
            float maxStrength = 0.0f;
            float goStrength = 1000.0f;
            for (Territory nT : neighborList) {
                float thisStrength = SUtils.inviteShipAttack(nT, 1000.0f, xAM, xM, xR, data, player, false, tFirst, true);
                int unitCount = xAM.size();
                if (unitCount > maxShips) {
                    maxShipTerr = nT;
                    maxShips = unitCount;
                }
                if (thisStrength > maxStrength) {
                    maxStrengthTerr = nT;
                    maxStrength = thisStrength;
                }
                xAM.clear();
                xM.clear();
                xR.clear();
            }
            if (maxStrengthTerr != null) {
                SUtils.inviteShipAttack(maxStrengthTerr, 1000.0f, alreadyMoved, moveUnits, moveRoutes, data, player, false, tFirst, true);
                s_logger.finer("PNCS consolidate with purchase: units not specified ");
                seaFactTerr = maxStrengthTerr;
                this.setSeaTerr(seaFactTerr);
            } else if (maxShipTerr != null) {
                SUtils.inviteShipAttack(maxShipTerr, 1000.0f, alreadyMoved, moveUnits, moveRoutes, data, player, false, tFirst, true);
                s_logger.finer("PNCS consolidate with purchase2: units not specified ");
                seaFactTerr = maxShipTerr;
                this.setSeaTerr(seaFactTerr);
            }
        } else if (seaFactTerr != null) {
            float seaFactStrength = SUtils.getStrengthOfPotentialAttackers(seaFactTerr, data, player, tFirst, false, null);
            List<Unit> seaUnitsPurchased = player.getUnits().getMatches(Matches.UnitIsSea);
            if ((seaFactStrength -= SUtils.strength(seaUnitsPurchased, false, true, tFirst)) > 0.0f) {
                SUtils.inviteShipAttack(seaFactTerr, seaFactStrength, alreadyMoved, moveUnits, moveRoutes, data, player, false, tFirst, true);
                s_logger.finer("PNCS defend purchase: units not specified ");
            }
        }
        alreadyMoved.addAll(xMoved);
        List<Territory> transTerr = SUtils.findTersWithUnitsMatching(data, player, Matches.UnitIsTransport);
        IntegerMap<Territory> transMap = new IntegerMap<Territory>();
        HashMap<Territory, Float> transStrengthMap = new HashMap<Territory, Float>();
        for (Territory tT : transTerr) {
            float tStrength = SUtils.getStrengthOfPotentialAttackers(tT, data, player, tFirst, false, null);
            int tUnits = tT.getUnits().countMatches(Matches.UnitIsTransport);
            transMap.put(tT, tUnits);
            transStrengthMap.put(tT, Float.valueOf(tStrength));
        }
        SUtils.reorder(transTerr, transMap, true);
        ArrayList<Territory> transTerr2 = new ArrayList<Territory>(transTerr);
        for (Territory trans : transTerr2) {
            Collection<Unit> ourAttackUnits = trans.getUnits().getUnits();
            float eStrength = ((Float)transStrengthMap.get(trans)).floatValue();
            if (eStrength < 0.5f) {
                transTerr.remove(trans);
            }
            float strengthNeeded = eStrength;
            ArrayList<Unit> alreadyCounted = new ArrayList<Unit>();
            for (Unit aUnit : ourAttackUnits) {
                UnitType uT = aUnit.getType();
                if (strengthNeeded <= 0.0f || alreadyCounted.contains(aUnit) || Matches.UnitTypeCanLandOnCarrier.match(uT)) continue;
                if (Matches.UnitTypeIsCarrier.match(uT)) {
                    strengthNeeded -= SUtils.uStrength(aUnit, false, true, tFirst);
                    int numFighters = UnitAttachment.get(uT).getCarrierCapacity();
                    for (Unit aUnit2 : ourAttackUnits) {
                        if (alreadyCounted.contains(aUnit2) || !Matches.UnitTypeCanLandOnCarrier.match(uT) || numFighters <= 0) continue;
                        strengthNeeded -= SUtils.uStrength(aUnit2, false, true, tFirst);
                        alreadyCounted.add(aUnit2);
                        --numFighters;
                    }
                    alreadyCounted.add(aUnit);
                    continue;
                }
                strengthNeeded -= SUtils.uStrength(aUnit, false, true, tFirst);
                alreadyCounted.add(aUnit);
            }
            s_logger.finer("PNCS stationary to defend transports " + alreadyCounted + " at " + trans);
            alreadyMoved.addAll(alreadyCounted);
        }
        Route eShipRoute = SUtils.findNearest(myCapital, enemyWater, noEnemyWater, data);
        Territory goHere = null;
        if (eShipRoute != null && eShipRoute.getLength() <= 5) {
            goHere = eShipRoute.getEnd();
        }
        float alliedStrength = 0.0f;
        float badGuyStrength = 0.0f;
        float ownedStrength = 0.0f;
        for (Territory myTerr : seaAttackTerr) {
            Route eRoute;
            List<Unit> myAttackUnits = myTerr.getUnits().getMatches(seaAirAttackUnit);
            List<Unit> alliedAttackUnits = myTerr.getUnits().getMatches(alliedSeaAirAttackUnit);
            if (shipsMovedMap.containsKey(myTerr)) {
                alreadyMoved.addAll(shipsMovedMap.get(myTerr));
            }
            boolean keepGoing = true;
            badGuyStrength = SUtils.getStrengthOfPotentialAttackers(myTerr, data, player, tFirst, false, null);
            ownedStrength = SUtils.strength(myAttackUnits, false, true, tFirst);
            alliedStrength = SUtils.strength(alliedAttackUnits, false, true, tFirst);
            if (alliedStrength > 1.0f && alliedStrength + 6.0f > badGuyStrength * 0.65f && badGuyStrength > 2.0f) {
                Set<Territory> bgSourceTerr = data.getMap().getNeighbors(myTerr, 2);
                bgSourceTerr.removeAll(impassableTerrs);
                Territory mainSourceTerr = null;
                for (Territory bgSource : bgSourceTerr) {
                    List<Unit> bgUnits;
                    float bgTerrStrength;
                    if (!Matches.TerritoryIsWater.match(bgSource) || !Matches.territoryHasEnemyUnits(player, data).match(bgSource) || !((bgTerrStrength = SUtils.strength(bgUnits = bgSource.getUnits().getMatches(Matches.enemyUnit(player, data)), true, true, tFirst)) > 0.5f * badGuyStrength)) continue;
                    mainSourceTerr = bgSource;
                }
                if (mainSourceTerr != null) {
                    Set<Territory> sourceNeighbors = data.getMap().getNeighbors(mainSourceTerr, 2);
                    sourceNeighbors.removeAll(impassableTerrs);
                    float maxStrength = 0.0f;
                    Territory maxStrengthTerr = null;
                    for (Territory sN : sourceNeighbors) {
                        float quickStrength;
                        if (!Matches.TerritoryIsWater.match(sN) || !Matches.territoryHasNoAlliedUnits(player, data).invert().match(sN) || skippedTerr.contains(sN)) continue;
                        List<Unit> sNUnits = sN.getUnits().getMatches(Matches.alliedUnit(player, data));
                        sNUnits.removeAll(alreadyMoved);
                        if (sNUnits.size() == 0 || !((quickStrength = SUtils.strength(sNUnits, false, true, tFirst)) > maxStrength)) continue;
                        maxStrength = quickStrength;
                        maxStrengthTerr = sN;
                    }
                    if (maxStrengthTerr != null) {
                        float newBadGuyStrength = badGuyStrength * 0.75f - maxStrength;
                        SUtils.inviteShipAttack(maxStrengthTerr, newBadGuyStrength, alreadyMoved, moveUnits, moveRoutes, data, player, false, tFirst, false);
                        s_logger.finer("PNCS consolidate threatened units?: units not specified. at" + maxStrengthTerr);
                        alreadyMoved.addAll(maxStrengthTerr.getUnits().getMatches(Matches.alliedUnit(player, data)));
                    }
                }
                keepGoing = false;
            }
            if (!keepGoing) {
                skippedTerr.add(myTerr);
                continue;
            }
            Route quickRoute = null;
            int minSeaDist = 100;
            int moveDist = MoveValidator.getLeastMovement(myAttackUnits);
            if (badGuyStrength > alliedStrength * 1.65f + 3.0f) {
                Set<Territory> myMoveNeighbors = data.getMap().getNeighbors(myTerr, 2);
                myMoveNeighbors.removeAll(impassableTerrs);
                HashMap<Territory, Float> MNmap = new HashMap<Territory, Float>();
                for (Territory MNterr : myMoveNeighbors) {
                    if (!MNterr.isWater() || Matches.territoryHasEnemyUnits(player, data).match(MNterr)) continue;
                    float enemyStrength = SUtils.getStrengthOfPotentialAttackers(MNterr, data, player, tFirst, true, null);
                    float MNStrength = SUtils.strength(MNterr.getUnits().getMatches(Matches.alliedUnit(player, data)), false, true, tFirst);
                    MNmap.put(MNterr, Float.valueOf(enemyStrength - (MNStrength += ownedStrength)));
                }
                Set MNterrs = MNmap.keySet();
                ArrayList MNterrs2 = new ArrayList(MNterrs);
                SUtils.reorder(MNterrs2, MNmap, true);
                Iterator MNIter = MNterrs2.iterator();
                boolean MNdone = false;
                goHere = null;
                while (MNIter.hasNext() && !MNdone) {
                    Territory MNterr = (Territory)MNIter.next();
                    if (!(ownedStrength + ((Float)MNmap.get(MNterr)).floatValue() < 0.0f) || (quickRoute = SUtils.getMaxSeaRoute(data, myTerr, MNterr, player, false, moveDist)) == null || quickRoute.getEnd() != MNterr) continue;
                    goHere = MNterr;
                    MNdone = true;
                }
                if (goHere != null) {
                    s_logger.finer("PNCS consolidate threatend units2?: " + myAttackUnits + " route " + quickRoute);
                    moveUnits.add(myAttackUnits);
                    moveRoutes.add(quickRoute);
                    alreadyMoved.addAll(myAttackUnits);
                    continue;
                }
            }
            for (Territory badSeaTerr : enemySeaTerr) {
                int newDist;
                Route seaCheckRoute = SUtils.getMaxSeaRoute(data, myTerr, badSeaTerr, player, false, moveDist);
                if (seaCheckRoute == null || (newDist = seaCheckRoute.getLength()) >= minSeaDist) continue;
                goHere = badSeaTerr;
                minSeaDist = newDist;
                quickRoute = seaCheckRoute;
            }
            myAttackUnits.removeAll(alreadyMoved);
            Iterator<Unit> checkIter = myAttackUnits.iterator();
            while (checkIter.hasNext()) {
                Unit checkOne = checkIter.next();
                if (Matches.unitHasNotMoved.match(checkOne)) continue;
                checkIter.remove();
            }
            if (myAttackUnits.size() > 0 && goHere != null && quickRoute != null) {
                float goHereStrength = SUtils.getStrengthOfPotentialAttackers(goHere, data, player, tFirst, false, null);
                float ourStrength = SUtils.strength(myAttackUnits, false, true, tFirst) + SUtils.strength(goHere.getUnits().getMatches(alliedSeaAirAttackUnit), false, true, tFirst);
                if (ourStrength >= goHereStrength * 0.75f) {
                    s_logger.finer("PNCS move towards enemy?  " + myAttackUnits + " in " + goHere + " route " + quickRoute);
                    moveUnits.add(myAttackUnits);
                    moveRoutes.add(quickRoute);
                    alreadyMoved.addAll(myAttackUnits);
                } else {
                    skippedTerr.add(myTerr);
                }
            } else {
                skippedTerr.add(myTerr);
            }
            goHere = null;
            if (badGuyStrength != 0.0f || (eRoute = SUtils.findNearest(myTerr, enemyWater, noEnemyWater, data)) == null) continue;
            int eLength = eRoute.getLength();
            if (eRoute.getEnd() == null) continue;
            boolean moveForward = false;
            ArrayList<Unit> canGoUnits = new ArrayList<Unit>(myAttackUnits);
            canGoUnits.removeAll(alreadyMoved);
            ownedStrength = SUtils.strength(canGoUnits, false, true, tFirst);
            Territory theTarget = null;
            if (eLength <= 4) {
                float xtraEStrength;
                Territory endTerr = eRoute.getEnd();
                float eStrength = SUtils.strength(endTerr.getUnits().getUnits(), false, true, tFirst);
                float potentialStrength = eStrength * 0.75f + 0.25f * (xtraEStrength = SUtils.getStrengthOfPotentialAttackers(endTerr, data, player, tFirst, false, null));
                if (ownedStrength > potentialStrength) {
                    theTarget = eRoute.getTerritories().get(eRoute.getLength() - 1);
                    moveForward = true;
                }
            } else {
                theTarget = eRoute.getTerritories().get(2);
                float eStrength = SUtils.getStrengthOfPotentialAttackers(theTarget, data, player, tFirst, false, null);
                if (ownedStrength > eStrength * 0.65f) {
                    moveForward = true;
                } else {
                    theTarget = eRoute.getTerritories().get(1);
                    float xEStrength = SUtils.getStrengthOfPotentialAttackers(theTarget, data, player, tFirst, false, null);
                    if (ownedStrength > xEStrength * 0.45f) {
                        moveForward = true;
                    }
                }
            }
            if (!moveForward) continue;
            moveDist = MoveValidator.getLeastMovement(canGoUnits);
            Route canGoRoute = SUtils.getMaxSeaRoute(data, myTerr, theTarget, player, false, moveDist);
            s_logger.finer("PNCS move towards enemy2?: " + canGoUnits + " at " + eRoute.getEnd() + " route " + canGoRoute);
            moveUnits.add(canGoUnits);
            moveRoutes.add(canGoRoute);
            alreadyMoved.addAll(canGoUnits);
        }
        HashMap<Territory, Float> enemyMap = new HashMap<Territory, Float>();
        List<Territory> enemyTerr = SUtils.findUnitTerr(data, player, enemySeaUnit);
        for (Territory t2 : enemyTerr) {
            enemyMap.put(t2, Float.valueOf(SUtils.strength(t2.getUnits().getMatches(enemySeaUnit), false, true, tFirst)));
        }
        SUtils.reorder(enemyTerr, enemyMap, true);
        for (Territory enemy : enemyTerr) {
            List<Territory> ourShipTerrs = SUtils.findOurShips(enemy, data, player);
            for (Territory shipTerr : ourShipTerrs) {
                if (!shipTerr.isWater()) continue;
                if (data.getMap().getNeighbors(shipTerr, enemyWater).size() > 0) {
                    skippedTerr.add(shipTerr);
                    continue;
                }
                List<Territory> Neighbors2 = SUtils.getExactNeighbors(shipTerr, 2, player, data, false);
                boolean continueOn = true;
                for (Territory N2 : Neighbors2) {
                    if (!((Match)enemyWater).match(N2)) continue;
                    continueOn = false;
                }
                if (!continueOn) {
                    skippedTerr.add(shipTerr);
                    continue;
                }
                float eS1 = SUtils.getStrengthOfPotentialAttackers(shipTerr, data, player, tFirst, true, null);
                Set<Territory> lookAroundTerr = data.getMap().getNeighbors(shipTerr, 5);
                lookAroundTerr.removeAll(impassableTerrs);
                ArrayList<Territory> hasEnemyShips = new ArrayList<Territory>();
                for (Territory eShipTerr : lookAroundTerr) {
                    if (!((Match)enemyWater).match(eShipTerr)) continue;
                    hasEnemyShips.add(eShipTerr);
                }
                List<Unit> moveableUnits = shipTerr.getUnits().getMatches(seaAirAttackUnitNotMoved);
                moveableUnits.removeAll(alreadyMoved);
                Iterator<Unit> mUIter = moveableUnits.iterator();
                while (mUIter.hasNext()) {
                    Unit mU = mUIter.next();
                    if (MoveValidator.hasEnoughMovement(mU, 1)) continue;
                    mUIter.remove();
                }
                List<Unit> unMoveableUnits = shipTerr.getUnits().getMatches(Matches.unitHasMoved);
                float unmoveableStrength = SUtils.strength(unMoveableUnits, false, true, tFirst);
                if (unmoveableStrength < eS1 * 0.65f) {
                    float testStrength = unmoveableStrength;
                    ArrayList<Unit> leaveUnits = new ArrayList<Unit>();
                    for (Unit leaveUnit : moveableUnits) {
                        if (!(testStrength < eS1 * 0.65f)) continue;
                        float addOn = SUtils.uStrength(leaveUnit, false, true, tFirst);
                        leaveUnits.add(leaveUnit);
                        testStrength += addOn;
                    }
                    moveableUnits.removeAll(leaveUnits);
                }
                if (moveableUnits.size() <= 0 || hasEnemyShips.size() != 1) continue;
                float moveableStrength = SUtils.strength(moveableUnits, false, true, tFirst);
                Territory enemyShipTerr = (Territory)hasEnemyShips.get(0);
                Route nRoute = data.getMap().getWaterRoute(shipTerr, enemyShipTerr);
                if (nRoute == null) continue;
                int moveDist = MoveValidator.getLeastMovement(moveableUnits);
                if (MoveValidator.validateCanal(nRoute, null, player, data) != null) {
                    nRoute = SUtils.getMaxSeaRoute(data, shipTerr, enemyShipTerr, player, false, moveDist);
                    if (nRoute != null) continue;
                    continue;
                }
                Route nRoute2 = new Route();
                int goLength = nRoute.getLength();
                Territory goPoint = moveDist >= goLength ? nRoute.getEnd() : nRoute.getTerritories().get(moveDist);
                float goPointStrength = SUtils.getStrengthOfPotentialAttackers(goPoint, data, player, tFirst, false, null);
                if (goPoint != nRoute.getEnd()) {
                    nRoute2.setStart(shipTerr);
                    for (int i = 1; i <= moveDist; ++i) {
                        nRoute2.add(nRoute.getTerritories().get(i));
                    }
                    nRoute = nRoute2;
                }
                if (!(goPointStrength * 0.55f < moveableStrength)) continue;
                s_logger.finer("PNCS moving units unknown reason?: " + moveableUnits + " route " + nRoute2);
                moveUnits.add(moveableUnits);
                moveRoutes.add(nRoute2);
                alreadyMoved.addAll(moveableUnits);
            }
        }
        ArrayList<Territory> dontMoveFrom = new ArrayList<Territory>();
        for (Territory check1 : skippedTerr) {
            for (Territory check2 : skippedTerr) {
                int swapDist;
                Route swapRoute;
                if (check1 == check2 || dontMoveFrom.contains(check2)) continue;
                int check1Dist = SUtils.distanceToEnemy(check1, data, player, true);
                int check2Dist = SUtils.distanceToEnemy(check2, data, player, true);
                Territory start = null;
                Territory stop = null;
                if (check1Dist > check2Dist) {
                    start = check2;
                    stop = check1;
                } else {
                    start = check1;
                    stop = check2;
                }
                List<Unit> swapUnits = start.getUnits().getMatches(seaAirAttackUnitNotMoved);
                swapUnits.removeAll(alreadyMoved);
                if (swapUnits.isEmpty() || (swapRoute = SUtils.getMaxSeaRoute(data, start, stop, player, false, swapDist = MoveValidator.getLeastMovement(swapUnits))) == null) continue;
                if (!(swapRoute.getEnd() != null && swapRoute.getEnd().getUnits().someMatch(ownedAC) || start.getUnits().someMatch(carrierCanMove))) {
                    swapUnits.removeAll(start.getUnits().getMatches(airAttackUnit));
                }
                if (swapUnits.isEmpty()) continue;
                s_logger.finer("PNCS consolidate fleet " + swapUnits + " to " + stop + " route " + swapRoute);
                moveUnits.add(swapUnits);
                moveRoutes.add(swapRoute);
                alreadyMoved.addAll(swapUnits);
                dontMoveFrom.add(stop);
            }
        }
        List<Territory> fTerr = SUtils.findUnitTerr(data, player, fighterUnit);
        List<Territory> bTerr = SUtils.findUnitTerr(data, player, bomberUnit);
        ArrayList<Territory> allTerr = new ArrayList<Territory>();
        if (fTerr != null) {
            allTerr.addAll(fTerr);
        }
        if (bTerr != null) {
            allTerr.addAll(bTerr);
        }
        if (nonCombat) {
            for (Territory newTerr : allTerr) {
                boolean canLand;
                boolean enemyFound = false;
                Set<Territory> sNewTerr = data.getMap().getNeighbors(newTerr, 2);
                sNewTerr.removeAll(impassableTerrs);
                for (Territory cEnemyTerr : sNewTerr) {
                    if (!Matches.territoryHasEnemyUnits(player, data).match(cEnemyTerr)) continue;
                    enemyFound = true;
                }
                if (enemyFound) continue;
                Territory capTerr = null;
                boolean minDist = false;
                Territory goPoint = SUtils.getAlliedLandTerrNextToEnemyCapital(0, capTerr, newTerr, data, player);
                Route capRoute = data.getMap().getRoute(newTerr, goPoint, noNeutralOrAA);
                if (capRoute == null) continue;
                int cRLen = capRoute.getLength();
                boolean foundit = false;
                Territory BtargetTerr = null;
                Territory FtargetTerr = null;
                List<Territory> cRTerrs = capRoute.getTerritories();
                for (int i = cRLen - 1; i >= 0; --i) {
                    goPoint = cRTerrs.get(i);
                    float testStrength = SUtils.getStrengthOfPotentialAttackers(goPoint, data, player, tFirst, true, null);
                    float ourStrength = SUtils.strength(goPoint.getUnits().getMatches(Matches.alliedUnit(player, data)), false, false, tFirst);
                    if (ourStrength > 0.65f * testStrength && i <= 4 && Matches.isTerritoryAllied(player, data).match(goPoint)) {
                        FtargetTerr = goPoint;
                        foundit = true;
                    }
                    if (!(ourStrength > 0.65f * testStrength) || i > 6 || !Matches.isTerritoryAllied(player, data).match(goPoint)) continue;
                    BtargetTerr = goPoint;
                    foundit = true;
                }
                if (!foundit) continue;
                List<Unit> fAirUnits = newTerr.getUnits().getMatches(fighterUnit);
                fAirUnits.removeAll(alreadyMoved);
                List<Unit> bombUnits = newTerr.getUnits().getMatches(bomberUnit);
                bombUnits.removeAll(alreadyMoved);
                Route BcapRoute = data.getMap().getRoute(newTerr, BtargetTerr, noNeutralOrAA);
                Route FcapRoute = data.getMap().getRoute(newTerr, FtargetTerr, noNeutralOrAA);
                if (BcapRoute != null && bombUnits.size() > 0 && AirMovementValidator.canLand(bombUnits, BtargetTerr, player, data)) {
                    canLand = true;
                    for (Unit b1 : bombUnits) {
                        if (!canLand) continue;
                        canLand = SUtils.airUnitIsLandable(b1, newTerr, BtargetTerr, player, data);
                    }
                    if (canLand) {
                        s_logger.finer("PNCS send bomber to ECap: " + bombUnits + " route " + BcapRoute);
                        moveRoutes.add(BcapRoute);
                        moveUnits.add(bombUnits);
                        alreadyMoved.addAll(bombUnits);
                    }
                }
                if (FcapRoute == null || fAirUnits.size() <= 0 || newTerr.getUnits().someMatch(ownedAC) || !AirMovementValidator.canLand(fAirUnits, FtargetTerr, player, data)) continue;
                canLand = true;
                for (Unit f1 : fAirUnits) {
                    if (!canLand) continue;
                    canLand = SUtils.airUnitIsLandable(f1, newTerr, FtargetTerr, player, data);
                }
                if (!canLand) continue;
                s_logger.finer("PNCS send fighter to ECap: " + fAirUnits + " route " + FcapRoute);
                moveRoutes.add(FcapRoute);
                moveUnits.add(fAirUnits);
                alreadyMoved.addAll(fAirUnits);
            }
        }
    }

    private void nonCombatPlanes(GameData data, PlayerID player, List<Collection<Unit>> moveUnits, List<Route> moveRoutes) {
        List<Territory> acTerr1;
        BattleDelegate delegate = DelegateFinder.battleDelegate(data);
        CompositeMatchAnd ownedUnit = new CompositeMatchAnd(Matches.unitIsOwnedBy(player));
        CompositeMatchAnd<Unit> ACOwned = new CompositeMatchAnd<Unit>(ownedUnit, Matches.UnitIsCarrier);
        CompositeMatchAnd<Unit> ACAllied = new CompositeMatchAnd<Unit>(Matches.alliedUnit(player, data), Matches.UnitIsCarrier);
        CompositeMatchAnd<Unit> fighterAndAllied = new CompositeMatchAnd<Unit>(Matches.alliedUnit(player, data), Matches.UnitCanLandOnCarrier);
        CompositeMatchAnd<Unit> fighterAndOwned = new CompositeMatchAnd<Unit>(ownedUnit, Matches.UnitCanLandOnCarrier);
        ArrayList<Unit> unitsAlreadyMoved = new ArrayList<Unit>();
        CompositeMatchAnd<Territory> notNeutralOrAA = new CompositeMatchAnd<Territory>(Matches.TerritoryIsNotImpassable, Matches.territoryHasEnemyAAforCombatOnly(player, data).invert());
        ArrayList<Territory> alliedThreats = new ArrayList<Territory>();
        boolean tFirst = this.transportsMayDieFirst();
        boolean alliedDanger = SUtils.threatToAlliedCapitals(data, player, alliedThreats, tFirst);
        if (alliedDanger) {
            for (Territory aThreat : alliedThreats) {
                if (!aThreat.getUnits().someMatch(fighterAndOwned)) continue;
                unitsAlreadyMoved.addAll(aThreat.getUnits().getMatches(fighterAndOwned));
            }
        }
        if ((acTerr1 = SUtils.ACTerritory(player, data)).size() == 0) {
            return;
        }
        IntegerMap<Territory> acSpaceMap = new IntegerMap<Territory>();
        HashMap<Territory, Float> acAttackMap = new HashMap<Territory, Float>();
        for (Territory ACMap : acTerr1) {
            float ACMapStrength = SUtils.getStrengthOfPotentialAttackers(ACMap, data, player, tFirst, false, null);
            acAttackMap.put(ACMap, Float.valueOf(ACMapStrength));
        }
        SUtils.reorder(acTerr1, acAttackMap, true);
        for (Territory ACMap : acTerr1) {
            List<Unit> ACMapUnits = ACMap.getUnits().getMatches(ACOwned);
            int ownedCarrierSpace = 0;
            for (Unit carrier1 : ACMapUnits) {
                ownedCarrierSpace += UnitAttachment.get(carrier1.getType()).getCarrierCapacity();
            }
            List<Unit> ACAlliedMapUnits = ACMap.getUnits().getMatches(ACAllied);
            int alliedCarrierSpace = 0;
            for (Unit carrier1 : ACAlliedMapUnits) {
                alliedCarrierSpace += UnitAttachment.get(carrier1.getType()).getCarrierCapacity();
            }
            List<Unit> ACfighterUnits = ACMap.getUnits().getMatches(fighterAndOwned);
            List<Unit> ACAlliedfighterUnits = ACMap.getUnits().getMatches(fighterAndAllied);
            int xAlliedSpace = Math.max(ACAlliedfighterUnits.size() - alliedCarrierSpace, 0);
            int aSpace = ownedCarrierSpace - ACfighterUnits.size() - xAlliedSpace;
            acSpaceMap.put(ACMap, aSpace);
        }
        List<Territory> myFighterTerr = SUtils.findTersWithUnitsMatching(data, player, Matches.UnitCanLandOnCarrier);
        myFighterTerr.removeAll(acTerr1);
        for (Territory t : myFighterTerr) {
            List<Unit> tPlanes = t.getUnits().getMatches(fighterAndOwned);
            if (tPlanes.size() <= 0) continue;
            for (Territory acT : acTerr1) {
                int availSpace;
                Route acRoute = data.getMap().getRoute(t, acT, notNeutralOrAA);
                if (acRoute == null) continue;
                ArrayList<Unit> fMoveUnits = new ArrayList<Unit>();
                for (Unit fUnit : tPlanes) {
                    if (!MoveValidator.hasEnoughMovement(fUnit, acRoute)) continue;
                    fMoveUnits.add(fUnit);
                }
                if (fMoveUnits.size() == 0) continue;
                ArrayList<Unit> tempUnits = new ArrayList<Unit>();
                if (availSpace > 0) {
                    Iterator fIter = fMoveUnits.iterator();
                    for (availSpace = acSpaceMap.getInt(acT); availSpace > 0 && fIter.hasNext(); --availSpace) {
                        Unit fMoveUnit = (Unit)fIter.next();
                        tempUnits.add(fMoveUnit);
                    }
                    if (tempUnits.size() <= 0) continue;
                    moveUnits.add(tempUnits);
                    moveRoutes.add(acRoute);
                    unitsAlreadyMoved.addAll(tempUnits);
                    acSpaceMap.put(acT, availSpace);
                    continue;
                }
                if ((availSpace >= 0 || !t.isWater()) && !delegate.getBattleTracker().wasBattleFought(t)) continue;
                ArrayList alreadyMoved = new ArrayList();
                List<Unit> myFighters = acT.getUnits().getMatches(fighterAndOwned);
                int maxPass = 0;
                int fightersNum = myFighters.size();
                while (availSpace < 0 && maxPass <= fightersNum) {
                    Route nearRoute;
                    int max = 0;
                    ++maxPass;
                    Iterator<Unit> iter = myFighters.iterator();
                    Unit moveIt = null;
                    while (iter.hasNext()) {
                        int left;
                        Unit unit = iter.next();
                        if (alreadyMoved.contains(unit) || (left = TripleAUnit.get(unit).getMovementLeft()) < max) continue;
                        max = left;
                        moveIt = unit;
                    }
                    if (moveIt == null || (nearRoute = SUtils.findNearest(acT, Matches.isTerritoryAllied(player, data), notNeutralOrAA, data)) == null || !MoveValidator.hasEnoughMovement(moveIt, nearRoute)) continue;
                    moveUnits.add(Collections.singleton(moveIt));
                    moveRoutes.add(nearRoute);
                    alreadyMoved.contains(moveIt);
                    acSpaceMap.put(acT, ++availSpace);
                    myFighters.remove(moveIt);
                }
            }
        }
    }

    private void populateCombatMoveSea(GameData data, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, PlayerID player) {
        boolean isAmphib = this.isAmphibAttack(player, false);
        boolean attackShipsPurchased = this.getAttackShipPurchase();
        boolean tFirst = this.transportsMayDieFirst();
        final HashSet<Unit> unitsAlreadyMoved = new HashSet<Unit>();
        ArrayList attackUnits = new ArrayList();
        CompositeMatchAnd notAlreadyMoved = new CompositeMatchAnd(new Match<Unit>(){

            @Override
            public boolean match(Unit o) {
                return !unitsAlreadyMoved.contains(o);
            }
        });
        for (Unit u : data.getUnits().getUnits()) {
            if (!u.getOwner().equals(player) || TripleAUnit.get(u).getMovementLeft() >= 1) continue;
            unitsAlreadyMoved.add(u);
        }
        CompositeMatchAnd ownedUnit = new CompositeMatchAnd(Matches.unitIsOwnedBy(player));
        CompositeMatchAnd seaUnit = new CompositeMatchAnd(ownedUnit, Matches.UnitIsSea, notAlreadyMoved);
        CompositeMatchAnd airUnit = new CompositeMatchAnd(ownedUnit, Matches.UnitIsAir, notAlreadyMoved);
        CompositeMatchOr<Unit> seaAirUnit = new CompositeMatchOr<Unit>(seaUnit, airUnit);
        CompositeMatchAnd<Unit> alliedSeaUnit = new CompositeMatchAnd<Unit>(Matches.alliedUnit(player, data), Matches.UnitIsSea);
        CompositeMatchAnd alliedAirUnit = new CompositeMatchAnd(Matches.alliedUnit(player, data), Matches.UnitIsAir);
        CompositeMatchOr alliedSeaAirUnit = new CompositeMatchOr(alliedAirUnit, alliedSeaUnit);
        CompositeMatchOr<Unit> alliedSeaAirUnitNotOwned = new CompositeMatchOr<Unit>(alliedSeaAirUnit, ownedUnit);
        CompositeMatchAnd<Unit> enemySeaUnit = new CompositeMatchAnd<Unit>(Matches.enemyUnit(player, data), Matches.UnitIsSea);
        CompositeMatchAnd<Unit> enemyNonTransport = new CompositeMatchAnd<Unit>(enemySeaUnit, Matches.UnitIsNotTransport);
        CompositeMatchAnd<Unit> enemySub = new CompositeMatchAnd<Unit>(enemySeaUnit, Matches.UnitIsSub);
        ArrayList<Territory> seaTerrAttacked = new ArrayList<Territory>();
        ArrayList attackRoute = new ArrayList();
        float attackFactor = 1.68f;
        if (isAmphib) {
            attackFactor = 1.68f;
        }
        HashMap<Territory, Float> sortTerritories = new HashMap<Territory, Float>();
        ArrayList<Territory> enemyTerr = new ArrayList<Territory>();
        for (Territory t : data.getMap().getTerritories()) {
            if (!t.isWater() || !t.getUnits().someMatch(enemySeaUnit)) continue;
            sortTerritories.put(t, Float.valueOf(SUtils.strength(t.getUnits().getMatches(Matches.enemyUnit(player, data)), false, true, tFirst)));
            enemyTerr.add(t);
        }
        SUtils.reorder(enemyTerr, sortTerritories, true);
        int maxShipCount = 0;
        Territory maxShipsTerr = null;
        Territory seaPlaceFact = null;
        Territory myCapital = this.m_myCapital;
        if (attackShipsPurchased) {
            ArrayList<Collection<Unit>> xMoves2 = new ArrayList<Collection<Unit>>();
            ArrayList<Route> xRoutes2 = new ArrayList<Route>();
            ArrayList<Unit> xAlreadyMoved2 = new ArrayList<Unit>(unitsAlreadyMoved);
            seaPlaceFact = this.getSeaTerr();
            if (seaPlaceFact == null) {
                for (Territory bestTarget : SUtils.findTersWithUnitsMatching(data, player, Matches.UnitCanProduceUnits)) {
                    int thisShipCount = SUtils.shipThreatToTerr(bestTarget, data, player, tFirst);
                    if (thisShipCount <= maxShipCount) continue;
                    seaPlaceFact = bestTarget;
                    maxShipCount = thisShipCount;
                }
            } else {
                maxShipCount = SUtils.shipThreatToTerr(seaPlaceFact, data, player, tFirst);
            }
            boolean attackGroup = false;
            if (myCapital != null && seaPlaceFact != null) {
                List<Territory> eSTerr = SUtils.findUnits(seaPlaceFact, data, enemySeaUnit, 3);
                float totStrengthEnemyShips = 0.0f;
                int maxUnitCount = 0;
                int totUnitCount = 0;
                float maxStrength = 0.0f;
                Territory largestGroupTerr = null;
                ArrayList<Unit> largestGroup = new ArrayList();
                for (Territory eST : eSTerr) {
                    List<Unit> enemyGroup = eST.getUnits().getMatches(enemySeaUnit);
                    totUnitCount += enemyGroup.size();
                    float thisGroupStrength = SUtils.strength(enemyGroup, false, true, tFirst);
                    totStrengthEnemyShips += thisGroupStrength;
                    if (!(thisGroupStrength > maxStrength)) continue;
                    maxStrength = thisGroupStrength;
                    largestGroupTerr = eST;
                    maxUnitCount = enemyGroup.size();
                    largestGroup = enemyGroup;
                }
                if (largestGroupTerr != null) {
                    float remainingStrength = totStrengthEnemyShips * 1.25f + 2.0f;
                    float shipStrength = SUtils.inviteShipAttack(largestGroupTerr, remainingStrength, xAlreadyMoved2, xMoves2, xRoutes2, data, player, true, tFirst, tFirst);
                    float planeStrength = SUtils.invitePlaneAttack(false, false, largestGroupTerr, remainingStrength -= shipStrength, xAlreadyMoved2, xMoves2, xRoutes2, data, player);
                    remainingStrength -= planeStrength;
                    float thisAttackStrength = shipStrength + planeStrength;
                    if (thisAttackStrength > maxStrength) {
                        int remainingShips;
                        float newStrength = totStrengthEnemyShips - thisAttackStrength;
                        ArrayList<Unit> ourShips = new ArrayList<Unit>();
                        for (Collection collection : xMoves2) {
                            ourShips.addAll(collection);
                        }
                        IntegerMap<UnitType> ourUnits = SUtils.convertListToMap(ourShips);
                        IntegerMap<UnitType> integerMap = SUtils.convertListToMap(largestGroup);
                        List<PlayerID> ePlayers = SUtils.getEnemyPlayers(data, player);
                        PlayerID playerID = ePlayers.get(0);
                        boolean bl = SUtils.quickBattleEstimator(ourUnits, integerMap, player, playerID, true, Properties.getAirAttackSubRestricted(data));
                        float adjustedStrength = SUtils.strength(player.getUnits().getMatches(seaAirUnit), true, true, tFirst);
                        if (newStrength < adjustedStrength) {
                            attackGroup = true;
                        } else if (bl && (remainingShips = totUnitCount - (maxUnitCount - integerMap.totalValues())) <= player.getUnits().getMatches(seaAirUnit).size() - 2) {
                            attackGroup = true;
                        }
                        if (attackGroup) {
                            s_logger.finer("SCM moving " + xMoves2 + " to attack big threat on sea factory: " + xRoutes2);
                            moveUnits.addAll(xMoves2);
                            moveRoutes.addAll(xRoutes2);
                            unitsAlreadyMoved.addAll(xAlreadyMoved2);
                            seaTerrAttacked.add(largestGroupTerr);
                        }
                    }
                }
                int localMax = 0;
                int localShipCount = 0;
                for (Territory x : data.getMap().getNeighbors(seaPlaceFact, Matches.TerritoryIsWater)) {
                    localShipCount = x.getUnits().countMatches(alliedSeaUnit);
                    if (localShipCount <= localMax) continue;
                    maxShipsTerr = x;
                    localMax = localShipCount;
                }
                if (maxShipsTerr != null) {
                    List<Territory> shipTerrAtCapitol = SUtils.findOnlyMyShips(seaPlaceFact, data, player, Matches.UnitIsSea);
                    for (Territory xT : shipTerrAtCapitol) {
                        int n;
                        Route route;
                        float shipBuildupTerStrength = SUtils.strength(maxShipsTerr.getUnits().getMatches(Matches.UnitIsSea), false, true, tFirst);
                        float shipBuildupTerEnemyStrength = SUtils.getStrengthOfPotentialAttackers(maxShipsTerr, data, player, tFirst, false, new ArrayList<Territory>());
                        Route route2 = this.getAmphibRoute(player, false);
                        if (shipBuildupTerStrength >= shipBuildupTerEnemyStrength && (route2 == null || !data.getMap().getNeighbors(maxShipsTerr).contains(route2.getEnd()))) break;
                        List<Unit> myShips = xT.getUnits().getMatches(Matches.unitIsOwnedBy(player));
                        myShips.removeAll(unitsAlreadyMoved);
                        if (myShips.isEmpty() || (route = SUtils.getMaxSeaRoute(data, xT, maxShipsTerr, player, true, n = MoveValidator.getLeastMovement(myShips))) == null || myShips.size() <= 0) continue;
                        s_logger.finer("SCM moving " + myShips + " to consolidate at factory Route: " + route);
                        moveUnits.add(myShips);
                        moveRoutes.add(route);
                        unitsAlreadyMoved.addAll(myShips);
                        seaTerrAttacked.add(maxShipsTerr);
                        enemyTerr.remove(maxShipsTerr);
                    }
                }
            }
        }
        for (Territory t2 : enemyTerr) {
            boolean alliedSuperiority;
            boolean destroyerAttacked;
            ArrayList<Collection<Unit>> xMoves = new ArrayList<Collection<Unit>>();
            ArrayList<Route> xRoutes = new ArrayList<Route>();
            ArrayList<Unit> xAlreadyMoved = new ArrayList<Unit>(unitsAlreadyMoved);
            Territory enemy = t2;
            float enemyStrength = ((Float)sortTerritories.get(enemy)).floatValue();
            List<Unit> enemySubs = t2.getUnits().getMatches(enemySub);
            float subStrength = SUtils.strength(enemySubs, false, true, tFirst);
            float strengthNeeded = attackFactor * enemyStrength + 3.0f;
            float ourStrength = 0.0f;
            float alliedStrength = 0.0f;
            float maxStrengthNeeded = 2.4f * enemyStrength + 3.0f;
            float minStrengthNeeded = strengthNeeded;
            attackUnits.clear();
            attackRoute.clear();
            float planeStrength = 0.0f;
            boolean AttackShipsPresent = enemy.getUnits().someMatch(enemyNonTransport);
            boolean shipsAttacked = false;
            boolean foundEnemyUnitWithDefense = false;
            for (Unit enemyUnit : enemy.getUnits().getUnits()) {
                if (UnitAttachment.get(enemyUnit.getUnitType()).getDefense(enemyUnit.getOwner()) <= 0) continue;
                foundEnemyUnitWithDefense = true;
            }
            if (!AttackShipsPresent || !foundEnemyUnitWithDefense) {
                boolean bl;
                boolean bl2;
                if (!tFirst || !foundEnemyUnitWithDefense) {
                    minStrengthNeeded = 1.0f;
                    maxStrengthNeeded = 1.0f;
                }
                planeStrength = SUtils.invitePlaneAttack(false, false, enemy, minStrengthNeeded, xAlreadyMoved, xMoves, xRoutes, data, player);
                maxStrengthNeeded -= planeStrength;
                minStrengthNeeded -= planeStrength;
                boolean bl3 = bl2 = planeStrength > 0.0f;
                if (maxStrengthNeeded > 0.0f) {
                    float shipStrength = SUtils.inviteShipAttack(enemy, maxStrengthNeeded, xAlreadyMoved, xMoves, xRoutes, data, player, true, tFirst, tFirst);
                    if (planeStrength == 0.0f) {
                        for (Collection collection : xMoves) {
                            for (Unit thisUnit : collection) {
                                if (!Matches.UnitIsNotTransport.match(thisUnit)) continue;
                                bl = true;
                            }
                        }
                    }
                    minStrengthNeeded -= shipStrength;
                    maxStrengthNeeded -= shipStrength;
                }
                if (!bl || !(minStrengthNeeded <= 0.0f)) continue;
                seaTerrAttacked.add(enemy);
                moveRoutes.addAll(xRoutes);
                for (Collection collection : xMoves) {
                    moveUnits.add(collection);
                }
                s_logger.finer("SCM moving " + xMoves + " to attack undefendables: " + xRoutes);
                unitsAlreadyMoved.addAll(xAlreadyMoved);
                continue;
            }
            boolean bl = Properties.getAirAttackSubRestricted(data);
            boolean enemySubsOnly = enemy.getUnits().allMatch(Matches.UnitIsSub);
            float f = 0.0f;
            float f2 = 0.0f;
            if (enemySubsOnly && !bl) {
                planeStrength = SUtils.invitePlaneAttack(false, false, enemy, minStrengthNeeded, xAlreadyMoved, xMoves, xRoutes, data, player);
                minStrengthNeeded -= planeStrength;
                if (planeStrength <= 0.0f) {
                    f = SUtils.inviteShipAttack(enemy, minStrengthNeeded, xAlreadyMoved, xMoves, xRoutes, data, player, true, tFirst, tFirst);
                    minStrengthNeeded -= f;
                }
            } else {
                if (bl && subStrength > 0.0f) {
                    f2 = SUtils.inviteShipAttack(enemy, 1.0f, xAlreadyMoved, xMoves, xRoutes, data, player, true, tFirst, tFirst, Matches.UnitIsDestroyer);
                    minStrengthNeeded -= f2;
                }
                f = SUtils.inviteShipAttack(enemy, minStrengthNeeded, xAlreadyMoved, xMoves, xRoutes, data, player, true, tFirst, tFirst);
                minStrengthNeeded -= f;
                f += f2;
                planeStrength = SUtils.invitePlaneAttack(false, false, enemy, minStrengthNeeded, xAlreadyMoved, xMoves, xRoutes, data, player);
                minStrengthNeeded -= planeStrength;
            }
            if (f > 0.0f) {
                shipsAttacked = true;
            }
            ourStrength += f;
            alliedStrength = ourStrength += planeStrength;
            if (minStrengthNeeded > 0.0f) {
                Set<Territory> alliedCheck = data.getMap().getNeighbors(enemy, 2);
                for (Territory qAlliedCheck : alliedCheck) {
                    List<Unit> qAlliedUnits = qAlliedCheck.getUnits().getMatches(alliedSeaAirUnitNotOwned);
                    alliedStrength += SUtils.strength(qAlliedUnits, true, true, tFirst);
                }
            }
            boolean bl4 = destroyerAttacked = f2 > 0.0f;
            if (!bl && !shipsAttacked) {
                strengthNeeded -= subStrength;
                maxStrengthNeeded -= subStrength * 2.4f + 3.0f;
            }
            if ((maxStrengthNeeded -= ourStrength) > 0.0f) {
                f = SUtils.inviteShipAttack(enemy, maxStrengthNeeded, xAlreadyMoved, xMoves, xRoutes, data, player, true, tFirst, tFirst);
                ourStrength += f;
            }
            boolean weCanAttack = bl && enemySubsOnly ? destroyerAttacked : true;
            boolean bl5 = alliedSuperiority = alliedStrength > strengthNeeded;
            if (!weCanAttack || !(ourStrength > strengthNeeded) && (!alliedSuperiority || !(ourStrength > 0.86f * strengthNeeded))) continue;
            s_logger.finer("SCM moving " + xMoves + " to attack " + enemy + " route: " + xRoutes);
            seaTerrAttacked.add(enemy);
            moveRoutes.addAll(xRoutes);
            moveUnits.addAll(xMoves);
            unitsAlreadyMoved.addAll(xAlreadyMoved);
        }
        this.setSeaTerrAttacked(seaTerrAttacked);
    }

    private void CheckPlanes(GameData data, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, PlayerID player) {
        final BattleDelegate delegate = DelegateFinder.battleDelegate(data);
        CompositeMatchAnd<Territory> canLand = new CompositeMatchAnd<Territory>(Matches.isTerritoryAllied(player, data), new Match<Territory>(){

            @Override
            public boolean match(Territory o) {
                return !delegate.getBattleTracker().wasConquered(o);
            }
        });
        CompositeMatchAnd<Unit> bomberUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsStrategicBomber);
        CompositeMatchAnd<Territory> routeCondition = new CompositeMatchAnd<Territory>(Matches.territoryHasEnemyAAforCombatOnly(player, data).invert(), Matches.TerritoryIsPassableAndNotRestricted(player, data));
        CompositeMatchAnd<Unit> fighterUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitCanLandOnCarrier);
        Territory myCapital = TerritoryAttachment.getFirstOwnedCapitalOrFirstUnownedCapital(player, data);
        List<Object> planeTerr = new ArrayList();
        planeTerr = SUtils.TerritoryOnlyPlanes(data, player);
        planeTerr.remove(myCapital);
        if (planeTerr.size() == 0) {
            return;
        }
        for (Territory territory : planeTerr) {
            List<Unit> airUnits = territory.getUnits().getMatches(fighterUnit);
            List<Unit> bombUnits = territory.getUnits().getMatches(bomberUnit);
            ArrayList<Unit> sendFighters = new ArrayList<Unit>();
            ArrayList<Unit> sendBombers = new ArrayList<Unit>();
            Route route2 = SUtils.findNearestNotEmpty(territory, canLand, routeCondition, data);
            if (route2 == null) continue;
            int sendNum = 0;
            for (Unit f : airUnits) {
                if (!MoveValidator.hasEnoughMovement(f, route2)) continue;
                sendFighters.add(f);
                ++sendNum;
            }
            if (sendNum > 0) {
                moveUnits.add(sendFighters);
                moveRoutes.add(route2);
            }
            sendNum = 0;
            for (Unit b : bombUnits) {
                if (!MoveValidator.hasEnoughMovement(b, route2)) continue;
                sendBombers.add(b);
                ++sendNum;
            }
            if (sendNum <= 0) continue;
            moveUnits.add(sendBombers);
            moveRoutes.add(route2);
        }
    }

    private void stopBlitzAttack(GameData data, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, PlayerID player) {
        boolean noChangeOnPass;
        this.setImpassableTerrs(player);
        Collection<Territory> impassableTerrs = this.getImpassableTerrs();
        CompositeMatchAnd<Unit> alliedLandUnit = new CompositeMatchAnd<Unit>(Matches.alliedUnit(player, data), Matches.UnitIsLand);
        CompositeMatchAnd<Unit> blitzBlocker = new CompositeMatchAnd<Unit>(Matches.alliedUnit(player, data), Matches.UnitCanNotProduceUnits, Matches.UnitIsNotInfrastructure, Matches.UnitIsNotAA);
        CompositeMatchAnd<Unit> anyUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitCanNotProduceUnits, Matches.UnitIsNotInfrastructure, Matches.UnitIsNotAA);
        boolean capDanger = this.getCapDanger();
        boolean tFirst = this.transportsMayDieFirst();
        Territory myCapital = TerritoryAttachment.getFirstOwnedCapitalOrFirstUnownedCapital(player, data);
        ArrayList<Route> blitzTerrRoutes = new ArrayList<Route>();
        float enemyStrength = SUtils.getStrengthOfPotentialAttackers(myCapital, data, player, tFirst, false, null);
        float ourStrength = SUtils.strength(myCapital.getUnits().getUnits(), false, false, tFirst);
        ArrayList<Territory> TerrToBlock = new ArrayList<Territory>();
        List<Territory> possBlitzTerr = SUtils.possibleBlitzTerritories(myCapital, data, player);
        ArrayList<Territory> cantBlockList = new ArrayList<Territory>();
        for (Territory pB : possBlitzTerr) {
            if (!Matches.isTerritoryEnemy(player, data).match(pB)) continue;
            cantBlockList.addAll(data.getMap().getNeighbors(pB, Matches.territoryHasEnemyBlitzUnits(player, data)));
        }
        cantBlockList.removeAll(possBlitzTerr);
        float blitzStrength = SUtils.determineEnemyBlitzStrength(myCapital, blitzTerrRoutes, null, data, player);
        boolean bl = noChangeOnPass = blitzStrength > 0.0f;
        while (noChangeOnPass) {
            boolean listChanged = false;
            for (Route bRoute : blitzTerrRoutes) {
                Territory midTerr;
                if (bRoute == null || cantBlockList.contains(bRoute.getStart()) || TerrToBlock.contains(midTerr = bRoute.getTerritories().get(1)) || !Matches.isTerritoryFriendly(player, data).match(midTerr)) continue;
                listChanged = true;
                TerrToBlock.add(midTerr);
            }
            if (!listChanged) {
                noChangeOnPass = false;
            }
            blitzTerrRoutes.clear();
            SUtils.determineEnemyBlitzStrength(myCapital, blitzTerrRoutes, TerrToBlock, data, player);
        }
        if (blitzStrength == 0.0f) {
            return;
        }
        if (enemyStrength - blitzStrength < ourStrength) {
            capDanger = false;
        }
        List<Territory> capNeighbors = SUtils.getNeighboringLandTerritories(data, player, myCapital);
        ArrayList<Territory> capDoNotUse = new ArrayList<Territory>();
        Iterator<Territory> capIter = capNeighbors.iterator();
        while (capIter.hasNext()) {
            Territory thisCapTerr = capIter.next();
            if (thisCapTerr.getUnits().countMatches(blitzBlocker) > 1) continue;
            capIter.remove();
            capDoNotUse.add(thisCapTerr);
        }
        ArrayList<Unit> alreadyMoved = new ArrayList<Unit>();
        ArrayList<Territory> goBlockTerr = new ArrayList<Territory>();
        HashMap<Territory, Float> blockTerrMap = new HashMap<Territory, Float>();
        for (Territory blockTerr : TerrToBlock) {
            List<Territory> myNeighbors = SUtils.getNeighboringLandTerritories(data, player, blockTerr);
            myNeighbors.removeAll(capDoNotUse);
            myNeighbors.removeAll(goBlockTerr);
            for (Territory myTerr : myNeighbors) {
                float attackStrength = SUtils.getStrengthOfPotentialAttackers(myTerr, data, player, tFirst, true, null);
                blockTerrMap.put(myTerr, Float.valueOf(attackStrength));
            }
            goBlockTerr.addAll(myNeighbors);
        }
        SUtils.reorder(goBlockTerr, blockTerrMap, false);
        if (capDanger) {
            goBlockTerr.remove(myCapital);
        }
        for (Territory moveFrom : goBlockTerr) {
            List<Unit> ourUnits = moveFrom.getUnits().getMatches(anyUnit);
            List<Unit> alliedUnits = moveFrom.getUnits().getMatches(Matches.alliedUnit(player, data));
            float eStrength = ((Float)blockTerrMap.get(moveFrom)).floatValue();
            float aStrength = SUtils.strength(alliedUnits, false, false, true);
            Set<Territory> moveFromNeighbors = data.getMap().getNeighbors(moveFrom, Matches.territoryHasNoEnemyUnits(player, data));
            moveFromNeighbors.removeAll(impassableTerrs);
            moveFromNeighbors.retainAll(TerrToBlock);
            if (moveFromNeighbors.isEmpty()) continue;
            Iterator<Territory> neighborIter = moveFromNeighbors.iterator();
            if (!(aStrength > eStrength) || ourUnits.size() <= 1) continue;
            Iterator<Unit> ourIter = ourUnits.iterator();
            while (ourIter.hasNext() && ourUnits.size() > 1 && aStrength > eStrength && neighborIter.hasNext()) {
                Unit unit = ourIter.next();
                Territory moveHere = neighborIter.next();
                Route moveRoute = data.getMap().getLandRoute(moveFrom, moveHere);
                if (moveRoute == null || !MoveValidator.hasEnoughMovement(unit, moveRoute)) continue;
                moveUnits.add(Collections.singleton(unit));
                moveRoutes.add(moveRoute);
                alreadyMoved.add(unit);
                neighborIter.remove();
                TerrToBlock.remove(moveHere);
                aStrength -= SUtils.uStrength(unit, false, false, tFirst);
            }
        }
        if (TerrToBlock.size() > 0) {
            Iterator bIter = TerrToBlock.iterator();
            while (bIter.hasNext()) {
                float strengthNeeded = 1.0f;
                Territory moveHere = (Territory)bIter.next();
                float bStrength = SUtils.inviteBlitzAttack(true, moveHere, 1.0f, alreadyMoved, moveUnits, moveRoutes, data, player, false, capDanger);
                if (!(bStrength > 0.0f)) continue;
                bIter.remove();
            }
        }
        if (TerrToBlock.size() > 0) {
            for (Territory xTerr : goBlockTerr) {
                Set<Territory> goBTerrs = data.getMap().getNeighbors(xTerr, Matches.territoryHasNoEnemyUnits(player, data));
                goBTerrs.removeAll(impassableTerrs);
                goBTerrs.retainAll(TerrToBlock);
                if (goBTerrs.isEmpty()) continue;
                List<Unit> ourUnits = xTerr.getUnits().getMatches(anyUnit);
                List<Unit> alliedUnits = xTerr.getUnits().getMatches(alliedLandUnit);
                boolean canGo = alliedUnits.size() > ourUnits.size() || alliedUnits.size() > 1;
                ourUnits.removeAll(alreadyMoved);
                if (!canGo || ourUnits.size() == 0 || !canGo) continue;
                Iterator<Territory> goBIter = goBTerrs.iterator();
                Iterator<Unit> unitIter = ourUnits.iterator();
                boolean movedIn = false;
                while (unitIter.hasNext() && goBIter.hasNext() && alliedUnits.size() > 1) {
                    Unit nextUnit;
                    Territory goTerr = goBIter.next();
                    Route unitRoute = data.getMap().getLandRoute(xTerr, goTerr);
                    if (unitRoute == null || !MoveValidator.hasEnoughMovement(nextUnit = unitIter.next(), unitRoute)) continue;
                    moveUnits.add(Collections.singleton(nextUnit));
                    moveRoutes.add(unitRoute);
                    alreadyMoved.add(nextUnit);
                    TerrToBlock.remove(goTerr);
                    unitIter.remove();
                    alliedUnits.remove(nextUnit);
                }
            }
        }
        if (TerrToBlock.size() > 0) {
            for (Territory checkAgain : TerrToBlock) {
                float strengthNeeded = 1.0f;
                SUtils.invitePlaneAttack(true, false, checkAgain, 1.0f, alreadyMoved, moveUnits, moveRoutes, data, player);
            }
        }
    }

    private void SetCapGarrison(Territory myCapital, PlayerID player, float totalInvasion, Collection<Unit> alreadyMoved) {
        CompositeMatchAnd<Unit> landUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsNotSea, Matches.UnitIsNotAA, Matches.UnitIsNotInfrastructure, Matches.unitHasNotMoved.invert());
        List<Unit> myCapUnits = myCapital.getUnits().getMatches(landUnit);
        float capGarrisonStrength = 0.0f;
        for (Unit x : myCapUnits) {
            if (!(capGarrisonStrength * 0.9f - 3.0f <= totalInvasion)) continue;
            capGarrisonStrength += SUtils.uStrength(x, false, false, false);
            alreadyMoved.add(x);
        }
        if (capGarrisonStrength < totalInvasion) {
            CompositeMatchAnd<Unit> landUnit2 = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsNotSea, Matches.UnitIsNotAA, Matches.UnitIsNotInfrastructure, Matches.unitHasNotMoved);
            List<Unit> myCapUnits2 = myCapital.getUnits().getMatches(landUnit2);
            for (Unit x : myCapUnits2) {
                if (!(capGarrisonStrength * 0.9f - 3.0f <= totalInvasion)) continue;
                capGarrisonStrength += SUtils.uStrength(x, false, false, false);
                alreadyMoved.add(x);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void populateNonCombat(GameData data, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, PlayerID player) {
        float ourStrength = 0.0f;
        float attackerStrength = 0.0f;
        float totalInvasion = 0.0f;
        float ourCapStrength = 0.0f;
        boolean capDanger = false;
        boolean tFirst = this.transportsMayDieFirst();
        ArrayList<Territory> emptiedTerr = new ArrayList<Territory>();
        ArrayList<Territory> fortifiedTerr = new ArrayList<Territory>();
        List<Territory> alliedTerr = SUtils.allAlliedTerritories(data, player);
        Territory myCapital = TerritoryAttachment.getFirstOwnedCapitalOrFirstUnownedCapital(player, data);
        ArrayList<Object> movedInto = new ArrayList<Object>();
        ArrayList<Unit> alreadyMoved = new ArrayList<Unit>();
        CompositeMatchAnd<Territory> moveThrough = new CompositeMatchAnd<Territory>(Matches.TerritoryIsPassableAndNotRestricted(player, data), Matches.TerritoryIsNotNeutralButCouldBeWater, Matches.TerritoryIsLand);
        CompositeMatchAnd<Unit> landUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsNotSea, Matches.UnitIsNotAA, Matches.UnitIsNotInfrastructure, Matches.UnitCanNotProduceUnits, Matches.unitHasNotMoved);
        CompositeMatchAnd<Unit> infantryUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsInfantry);
        CompositeMatchAnd<Unit> airUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsAir);
        CompositeMatchAnd<Unit> alliedUnit = new CompositeMatchAnd<Unit>(Matches.alliedUnit(player, data), Matches.UnitIsLand);
        CompositeMatchAnd<Unit> myTransportUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsTransport);
        for (Unit u : data.getUnits().getUnits()) {
            if (!u.getOwner().equals(player) || TripleAUnit.get(u).getMovementLeft() >= 1) continue;
            alreadyMoved.add(u);
        }
        List<Territory> alreadyAttacked = Collections.emptyList();
        float dangerFactor = 1.05f;
        ourCapStrength = SUtils.strength(myCapital.getUnits().getUnits(), false, false, tFirst);
        totalInvasion = SUtils.getStrengthOfPotentialAttackers(myCapital, data, player, tFirst, true, null);
        StrengthEvaluator capStrEval = StrengthEvaluator.evalStrengthAt(data, player, myCapital, false, true, tFirst, true);
        boolean directCapDanger = totalInvasion > ourCapStrength * 0.95f - 3.0f;
        capDanger = capStrEval.inDanger(1.05f);
        List<Territory> badNeighbors = SUtils.getNeighboringEnemyLandTerritories(data, player, myCapital);
        List<Territory> myNeighbors = SUtils.getNeighboringLandTerritories(data, player, myCapital);
        for (Territory neighborTerr : myNeighbors) {
            Unit oneUnit;
            int leastMove;
            List<Unit> myUnits;
            List<Territory> nextNeighbors = SUtils.getNeighboringEnemyLandTerritories(data, player, neighborTerr);
            nextNeighbors.removeAll(badNeighbors);
            if (nextNeighbors.size() <= 0 || (myUnits = neighborTerr.getUnits().getMatches(landUnit)).size() <= 0 || (leastMove = MoveValidator.getLeastMovement(myUnits)) <= 0) continue;
            List<Unit> infUnits = neighborTerr.getUnits().getMatches(infantryUnit);
            if (infUnits.size() > 0) {
                oneUnit = infUnits.get(0);
                s_logger.finer("PNC stationary " + oneUnit + "in " + neighborTerr + " defend around capital");
                alreadyMoved.add(oneUnit);
                continue;
            }
            oneUnit = myUnits.get(0);
            s_logger.finer("PNC stationary " + oneUnit + "in " + neighborTerr + " defend around capital");
            alreadyMoved.add(oneUnit);
        }
        HashMap<Territory, Float> SNeighbor = new HashMap<Territory, Float>();
        for (Territory xNeighbor : myNeighbors) {
            SNeighbor.put(xNeighbor, Float.valueOf(SUtils.getStrengthOfPotentialAttackers(xNeighbor, data, player, tFirst, true, null)));
        }
        SUtils.reorder(myNeighbors, SNeighbor, false);
        HashMap<Object, Float> addStrength = new HashMap<Object, Float>();
        for (Territory qT : alliedTerr) {
            addStrength.put(qT, Float.valueOf(0.0f));
        }
        if (directCapDanger) {
            for (Territory tx3 : myNeighbors) {
                if (ourCapStrength * 1.05f - 3.0f > totalInvasion) continue;
                float stayAboveStrength = ((Float)SNeighbor.get(tx3)).floatValue() * 0.75f;
                List<Unit> allUnits = tx3.getUnits().getMatches(landUnit);
                float currStrength = SUtils.strength(allUnits, false, false, tFirst);
                if (currStrength < stayAboveStrength) continue;
                ArrayList<Unit> sendIn = new ArrayList<Unit>();
                Iterator<Unit> uIter = allUnits.iterator();
                while (uIter.hasNext() && ourCapStrength * 1.05f - 3.0f <= totalInvasion && currStrength > stayAboveStrength) {
                    Unit x = uIter.next();
                    float uStrength = SUtils.uStrength(x, false, false, tFirst);
                    ourCapStrength += uStrength;
                    currStrength -= uStrength;
                    sendIn.add(x);
                }
                Route quickRoute = data.getMap().getLandRoute(tx3, myCapital);
                moveUnits.add(sendIn);
                moveRoutes.add(quickRoute);
                s_logger.finer("PNC defend capital " + sendIn + " route " + quickRoute);
                alreadyMoved.addAll(sendIn);
            }
            ArrayList<Collection<Unit>> xMoveUnits = new ArrayList<Collection<Unit>>();
            ArrayList<Route> xMoveRoutes = new ArrayList<Route>();
            float remainingStrengthNeeded = (totalInvasion - (ourCapStrength * 1.05f - 3.0f)) * 1.05f;
            float blitzStrength = 0.0f;
            float planeStrength = 0.0f;
            float transStrength = 0.0f;
            float landStrength = 0.0f;
            if (remainingStrengthNeeded > 0.0f) {
                blitzStrength = SUtils.inviteBlitzAttack(true, myCapital, remainingStrengthNeeded, alreadyMoved, xMoveUnits, xMoveRoutes, data, player, false, true);
            }
            if ((remainingStrengthNeeded -= blitzStrength) > 0.0f) {
                planeStrength = SUtils.invitePlaneAttack(true, false, myCapital, remainingStrengthNeeded, alreadyMoved, xMoveUnits, xMoveRoutes, data, player);
            }
            if ((remainingStrengthNeeded -= planeStrength) > 0.0f) {
                landStrength -= SUtils.inviteLandAttack(true, myCapital, remainingStrengthNeeded, alreadyMoved, xMoveUnits, xMoveRoutes, data, player, false, true, alreadyAttacked);
            }
            remainingStrengthNeeded -= landStrength;
            List<Unit> myCapUnits = myCapital.getUnits().getMatches(landUnit);
            s_logger.finer("PNC defend capital-abandon surrounding " + xMoveUnits + " route " + xMoveRoutes);
            moveUnits.addAll(xMoveUnits);
            moveRoutes.addAll(xMoveRoutes);
            alreadyMoved.addAll(myCapUnits);
            boolean bl = capDanger = totalInvasion > (ourCapStrength += blitzStrength + planeStrength + landStrength + 0.0f);
        }
        if (capDanger) {
            List<Territory> outerTerrs = SUtils.getExactNeighbors(myCapital, 3, player, data, false);
            Iterator<Territory> outerIter = outerTerrs.iterator();
            HashMap<Territory, Float> outerMap = new HashMap<Territory, Float>();
            HashMap<Territory, Float> outerEMap = new HashMap<Territory, Float>();
            while (outerIter.hasNext()) {
                Territory outerTerr = outerIter.next();
                if (outerTerr.isWater() || Matches.isTerritoryAllied(player, data).match(outerTerr) || data.getMap().getLandRoute(outerTerr, myCapital) == null) {
                    outerIter.remove();
                }
                float myStrength = SUtils.strength(outerTerr.getUnits().getMatches(landUnit), false, false, tFirst);
                float outerEStrength = SUtils.getStrengthOfPotentialAttackers(myCapital, data, player, tFirst, true, null);
                outerMap.put(outerTerr, Float.valueOf(myStrength));
                outerEMap.put(outerTerr, Float.valueOf(outerEStrength));
            }
            SUtils.reorder(outerTerrs, outerEMap, false);
            float strengthNeeded = capStrEval.strengthMissing(1.05f);
            for (Territory outerTerr : outerTerrs) {
                List<Territory> oTNeighbors = SUtils.getNeighboringLandTerritories(data, player, outerTerr);
                HashMap<Territory, Float> oTNMap = new HashMap<Territory, Float>();
                int checkDist = data.getMap().getLandDistance(outerTerr, myCapital);
                Iterator<Territory> oTNIter = oTNeighbors.iterator();
                while (oTNIter.hasNext()) {
                    Territory oTN = oTNIter.next();
                    int oTNDist = data.getMap().getLandDistance(oTN, myCapital);
                    float oTNEStrength = SUtils.getStrengthOfPotentialAttackers(oTN, data, player, tFirst, true, null);
                    if (checkDist > oTNDist) {
                        oTNMap.put(oTN, Float.valueOf(oTNEStrength));
                        continue;
                    }
                    oTNIter.remove();
                }
                SUtils.reorder(oTNeighbors, oTNMap, false);
                float outerEStrength = SUtils.getStrengthOfPotentialAttackers(outerTerr, data, player, tFirst, true, null);
                List<Unit> ourOuterUnits = outerTerr.getUnits().getMatches(landUnit);
                ourOuterUnits.removeAll(alreadyMoved);
                List<Unit> ourPlanes = outerTerr.getUnits().getMatches(airUnit);
                ourPlanes.removeAll(alreadyMoved);
                float thisTerrStrength = SUtils.strength(outerTerr.getUnits().getUnits(), false, false, tFirst);
                float diffStrength = outerEStrength - thisTerrStrength;
                boolean EAdvantage = diffStrength > 1.5f * thisTerrStrength;
                for (Territory oTN : oTNeighbors) {
                    Route oTNRoute = data.getMap().getLandRoute(outerTerr, oTN);
                    if (oTNRoute == null) continue;
                    if (EAdvantage && ourOuterUnits.size() > 1 && strengthNeeded > 0.0f) {
                        moveUnits.add(ourOuterUnits);
                        moveRoutes.add(oTNRoute);
                        s_logger.finer("PNC move towards capital " + ourOuterUnits + " route " + oTNRoute);
                        alreadyMoved.addAll(ourOuterUnits);
                        float f = SUtils.strength(ourOuterUnits, false, false, tFirst);
                        strengthNeeded -= f;
                        diffStrength += f;
                        continue;
                    }
                    if (ourOuterUnits.size() <= 1) continue;
                    Iterator<Unit> iterator = ourOuterUnits.iterator();
                    ArrayList<Unit> addUnits = new ArrayList<Unit>();
                    while (diffStrength < 0.0f && strengthNeeded > 0.0f && iterator.hasNext()) {
                        Unit oUnit = iterator.next();
                        float oStrength = SUtils.uStrength(oUnit, false, false, tFirst);
                        addUnits.add(oUnit);
                        strengthNeeded -= oStrength;
                        diffStrength += oStrength;
                    }
                    if (addUnits.size() <= 1) continue;
                    moveUnits.add(addUnits);
                    moveRoutes.add(oTNRoute);
                    s_logger.finer("PNC move towards capital2? " + addUnits + " route " + oTNRoute);
                    alreadyMoved.addAll(addUnits);
                }
            }
        } else {
            this.SetCapGarrison(myCapital, player, totalInvasion, alreadyMoved);
        }
        List<Territory> possBlitzTerr = SUtils.possibleBlitzTerritories(myCapital, data, player);
        for (Territory pB : possBlitzTerr) {
            if (Matches.isTerritoryEnemy(player, data).match(pB)) continue;
            List<Unit> ourUnits = pB.getUnits().getMatches(landUnit);
            if (ourUnits.isEmpty()) {
                float strengthNeeded = 1.0f;
                SUtils.inviteLandAttack(true, pB, 1.0f, alreadyMoved, moveUnits, moveRoutes, data, player, false, false, alreadyAttacked);
                continue;
            }
            if (MoveValidator.getLeastMovement(ourUnits) <= 0) continue;
            Unit dontMoveUnit = ourUnits.get(0);
            s_logger.finer("PNC stationary  " + dontMoveUnit + " to prevent blitz though " + pB);
            alreadyMoved.add(dontMoveUnit);
        }
        for (Territory t : alliedTerr) {
            Route rC;
            Territory endTerr;
            if (Matches.TerritoryIsWater.match(t) || !Matches.territoryHasLandUnitsOwnedBy(player).match(t)) continue;
            CompositeMatchAnd<Unit> blitzUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitCanBlitz);
            CompositeMatchAnd<Territory> enemyPassableNotWater = new CompositeMatchAnd<Territory>(Matches.isTerritoryEnemy(player, data), Matches.TerritoryIsPassableAndNotRestricted(player, data), Matches.TerritoryIsLand);
            CompositeMatchAnd<Territory> enemyPassableNotWaterNotNeutral = new CompositeMatchAnd<Territory>(enemyPassableNotWater, Matches.TerritoryIsNotNeutralButCouldBeWater);
            CompositeMatchAnd<Territory> routeCondition = new CompositeMatchAnd<Territory>(Matches.TerritoryIsPassableAndNotRestricted(player, data), Matches.isTerritoryAllied(player, data));
            List<Unit> blitzUnits = t.getUnits().getMatches(blitzUnit);
            blitzUnits.removeAll(alreadyMoved);
            Route goRoute = SUtils.findNearest(t, enemyPassableNotWater, routeCondition, data);
            if (goRoute != null && Matches.TerritoryIsNeutralButNotWater.match(endTerr = goRoute.getEnd())) {
                float pValue = TerritoryAttachment.getProduction(endTerr);
                float enemyStrength = SUtils.strength(endTerr.getUnits().getUnits(), false, false, tFirst);
                Route xRoute = SUtils.findNearest(t, enemyPassableNotWaterNotNeutral, routeCondition, data);
                if (enemyStrength > pValue * 9.0f) {
                    goRoute = xRoute;
                } else {
                    if (xRoute != null && xRoute.getEnd() != null) {
                        Territory realEnemy = xRoute.getEnd();
                        float eValue = TerritoryAttachment.getProduction(realEnemy);
                        Set<Territory> neutralNeighbors = data.getMap().getNeighbors(endTerr, enemyPassableNotWater);
                        for (Territory territory : neutralNeighbors) {
                            float testStrength;
                            int xValue = TerritoryAttachment.getProduction(territory);
                            if (Matches.TerritoryIsNeutralButNotWater.match(territory) && (testStrength = SUtils.strength(endTerr.getUnits().getUnits(), false, false, tFirst)) > (float)xValue) {
                                xValue = 0;
                            }
                            pValue += (float)xValue;
                        }
                        Set<Territory> enemyNeighbors = data.getMap().getNeighbors(realEnemy, enemyPassableNotWater);
                        for (Territory nTerr : enemyNeighbors) {
                            eValue += (float)TerritoryAttachment.getProduction(nTerr);
                        }
                        if (pValue < eValue) {
                            goRoute = xRoute;
                        }
                    }
                    Territory lastTerr = goRoute.getEnd();
                    if (Matches.isTerritoryEnemy(player, data).match(lastTerr)) {
                        lastTerr = goRoute.getTerritories().get(goRoute.getLength() - 1);
                        goRoute = data.getMap().getRoute(t, lastTerr, Matches.isTerritoryAllied(player, data));
                    }
                }
            }
            CompositeMatchAnd<Unit> moveOfType = new CompositeMatchAnd<Unit>(new Match[0]);
            moveOfType.add(Matches.unitIsOwnedBy(player));
            moveOfType.add(Matches.UnitIsNotAA);
            moveOfType.add(Matches.UnitCanNotProduceUnits);
            moveOfType.add(Matches.UnitIsNotInfrastructure);
            moveOfType.add(Matches.UnitIsLand);
            List<Unit> units = t.getUnits().getMatches(moveOfType);
            units.removeAll(alreadyMoved);
            if (units.size() == 0) continue;
            int minDistance = Integer.MAX_VALUE;
            Territory to = null;
            ourStrength = SUtils.strength(t.getUnits().getUnits(), false, false, tFirst) + ((Float)addStrength.get(t)).floatValue();
            attackerStrength = SUtils.getStrengthOfPotentialAttackers(t, data, player, tFirst, false, null);
            if ((t.getUnits().someMatch(Matches.UnitCanProduceUnits) || t.getUnits().someMatch(Matches.UnitIsInfrastructure)) && t != myCapital) {
                if (attackerStrength > ourStrength + 5.0f) {
                    List<Territory> myNeighbors2 = SUtils.getNeighboringLandTerritories(data, player, t);
                    if (capDanger) {
                        myNeighbors2.remove(myCapital);
                    }
                    for (Territory t3 : myNeighbors2) {
                        List<Unit> allUnits = t3.getUnits().getMatches(moveOfType);
                        ArrayList<Unit> arrayList = new ArrayList<Unit>();
                        for (Unit x2 : allUnits) {
                            if (!(ourStrength - 5.0f < attackerStrength) || alreadyMoved.contains(x2)) continue;
                            ourStrength += SUtils.uStrength(x2, false, false, tFirst);
                            arrayList.add(x2);
                        }
                        if (arrayList.isEmpty()) continue;
                        Route quickRoute = data.getMap().getLandRoute(t3, t);
                        addStrength.put(t, Float.valueOf(((Float)addStrength.get(t)).floatValue() + SUtils.strength(arrayList, false, false, tFirst)));
                        moveUnits.add(arrayList);
                        moveRoutes.add(quickRoute);
                        s_logger.finer("PNC defend factory/AA " + arrayList + " route " + quickRoute);
                        alreadyMoved.addAll(arrayList);
                        movedInto.add(t);
                    }
                }
                float tmpStrength = 0.0f;
                List<Unit> tUnits = t.getUnits().getMatches(Matches.unitIsOwnedBy(player));
                ArrayList<Collection<Unit>> tGoUnits = new ArrayList<Collection<Unit>>();
                SUtils.breakUnitsBySpeed(tGoUnits, data, player, tUnits);
                for (Collection collection : tGoUnits) {
                    Iterator tUnitIter = collection.iterator();
                    while (tmpStrength < attackerStrength && tUnitIter.hasNext()) {
                        Unit xUnit = (Unit)tUnitIter.next();
                        s_logger.finer("PNC stationary defend factory/AA " + xUnit + " in " + t);
                        alreadyMoved.add(xUnit);
                        tmpStrength += SUtils.uStrength(xUnit, false, false, tFirst);
                    }
                }
            }
            List<Territory> myENeighbors = SUtils.getNeighboringEnemyLandTerritories(data, player, t);
            Route retreatRoute = null;
            if (myENeighbors.size() == 0 && ourCapStrength * 1.08f + 5.0f < totalInvasion && t != myCapital && data.getMap().getLandRoute(t, myCapital) != null) {
                List<Territory> myNeighbors3 = SUtils.getNeighboringLandTerritories(data, player, t);
                myNeighbors3.remove(myCapital);
                int minCapDist = 100;
                Object var48_106 = null;
                for (Territory myTerr : myNeighbors3) {
                    int n = data.getMap().getLandDistance(myTerr, myCapital);
                    if (n >= minCapDist) continue;
                    minCapDist = n;
                    Territory territory = myTerr;
                    retreatRoute = data.getMap().getLandRoute(t, myTerr);
                }
                if (retreatRoute != null) {
                    List<Unit> myMoveUnits = t.getUnits().getMatches(landUnit);
                    myMoveUnits.removeAll(alreadyMoved);
                    int totUnits2 = myMoveUnits.size();
                    ArrayList<Unit> arrayList = new ArrayList<Unit>();
                    for (int i3 = 0; i3 < totUnits2; ++i3) {
                        if (!(ourCapStrength * 1.08f + 5.0f < totalInvasion)) continue;
                        Unit moveThisUnit = myMoveUnits.get(i3);
                        ourCapStrength += 0.5f * SUtils.uStrength(moveThisUnit, true, false, tFirst);
                        arrayList.add(moveThisUnit);
                    }
                    if (arrayList.size() > 0) {
                        void var48_107;
                        addStrength.put(var48_107, Float.valueOf(((Float)addStrength.get(var48_107)).floatValue() + SUtils.strength(arrayList, false, false, tFirst)));
                        moveRoutes.add(retreatRoute);
                        moveUnits.add(arrayList);
                        s_logger.finer("PNC retreat to capital " + arrayList + " route " + retreatRoute);
                        alreadyMoved.addAll(arrayList);
                        movedInto.add(var48_107);
                    }
                }
            }
            if (fortifiedTerr.contains(t)) continue;
            if (attackerStrength > ourStrength * 1.85f + 6.0f && !movedInto.contains(t)) {
                List<Territory> myFriendTerr = SUtils.getNeighboringLandTerritories(data, player, t);
                boolean maxUnits = false;
                boolean bl = false;
                Territory mergeTerr = null;
                for (Territory territory : myFriendTerr) {
                    void var48_110;
                    if (emptiedTerr.contains(territory)) continue;
                    List<Territory> badGuysTerr = SUtils.getNeighboringEnemyLandTerritories(data, player, territory);
                    if (badGuysTerr.size() > 0) {
                        var48_110 += 4;
                    }
                    float fTerrAttackers = SUtils.getStrengthOfPotentialAttackers(territory, data, player, tFirst, true, null);
                    StrengthEvaluator strEval = StrengthEvaluator.evalStrengthAt(data, player, territory, false, true, tFirst, true);
                    if (fTerrAttackers > 8.0f && fTerrAttackers < (strEval.getAlliedStrengthInRange() + ourStrength) * 1.05f) {
                        var48_110 += 4;
                    } else if (fTerrAttackers > 0.0f && fTerrAttackers < (strEval.getAlliedStrengthInRange() + ourStrength) * 1.05f) {
                        ++var48_110;
                    }
                    if ((var48_110 += territory.getUnits().getMatches(alliedUnit).size()) <= maxUnits) continue;
                    maxUnits = var48_110;
                    mergeTerr = territory;
                }
                if (mergeTerr != null) {
                    Route myRetreatRoute = data.getMap().getLandRoute(t, mergeTerr);
                    List<Unit> list = t.getUnits().getMatches(landUnit);
                    int totUnits3 = list.size();
                    for (int i4 = totUnits3 - 1; i4 >= 0; --i4) {
                        Unit u4 = list.get(i4);
                        if (!alreadyMoved.contains(u4)) continue;
                        list.remove(u4);
                    }
                    addStrength.put(mergeTerr, Float.valueOf(((Float)addStrength.get(mergeTerr)).floatValue() + SUtils.strength(list, false, false, tFirst)));
                    moveUnits.add(list);
                    moveRoutes.add(myRetreatRoute);
                    s_logger.finer("PNC consolidating units? " + list + " route " + myRetreatRoute);
                    alreadyMoved.addAll(list);
                    fortifiedTerr.add(mergeTerr);
                    movedInto.add(mergeTerr);
                    emptiedTerr.add(t);
                }
            }
            if (goRoute == null && (goRoute = SUtils.findNearest(t, Matches.territoryIsEnemyNonNeutralAndHasEnemyUnitMatching(data, player, Matches.UnitCanProduceUnits), routeCondition, data)) != null) {
                Territory endGoTerr = goRoute.getTerritories().get(goRoute.getLength() - 1);
                goRoute = data.getMap().getRoute(t, endGoTerr, routeCondition);
            }
            boolean isAmphib = this.isAmphibAttack(player, false);
            if (goRoute == null && isAmphib) {
                if (Matches.territoryIsAlliedAndHasAlliedUnitMatching(data, player, Matches.UnitCanProduceUnits).match(t)) continue;
                List<Territory> transportTerrs = SUtils.findOnlyMyShips(t, data, player, Matches.UnitIsTransport);
                if (transportTerrs.size() > 0) {
                    IntegerMap<Territory> integerMap = new IntegerMap<Territory>();
                    for (Territory xTransTerr : transportTerrs) {
                        integerMap.put(xTransTerr, xTransTerr.getUnits().countMatches(myTransportUnit));
                    }
                    SUtils.reorder(transportTerrs, integerMap, true);
                }
                for (Territory tTerr : transportTerrs) {
                    boolean bl;
                    List<Territory> myLandTerrs = SUtils.getNeighboringLandTerritories(data, player, tTerr);
                    boolean bl2 = false;
                    Iterator<Territory> mLIter = myLandTerrs.iterator();
                    while (mLIter.hasNext() && !bl) {
                        Territory mLT = mLIter.next();
                        goRoute = data.getMap().getRoute(t, mLT, Matches.TerritoryIsNotImpassableToLandUnits(player, data));
                        if (goRoute == null) continue;
                        bl = true;
                        to = mLT;
                    }
                }
                if (goRoute == null) continue;
            }
            if (goRoute == null) continue;
            int newDistance = goRoute.getLength();
            ArrayList<Collection<Unit>> arrayList = new ArrayList<Collection<Unit>>();
            ArrayList<Unit> moveableUnits = new ArrayList<Unit>(units);
            moveableUnits.removeAll(alreadyMoved);
            SUtils.breakUnitsBySpeed(arrayList, data, player, moveableUnits);
            if (to != null && Integer.MAX_VALUE <= newDistance + 1 && units.size() > 0 && (rC = data.getMap().getRoute(t, to, moveThrough)) != null) {
                goRoute = rC;
            }
            for (Collection collection : arrayList) {
                int maxDist = MoveValidator.getMaxMovement(collection);
                if (maxDist == 0) {
                    alreadyMoved.addAll(collection);
                    continue;
                }
                Route newRoute2 = new Route();
                if (goRoute.getLength() < maxDist) {
                    newRoute2 = goRoute;
                } else {
                    Iterator<Territory> newIter = goRoute.iterator();
                    newRoute2.setStart(t);
                    newIter.next();
                    while (newIter.hasNext() && newRoute2.getLength() < maxDist) {
                        Territory oneTerr = newIter.next();
                        if (!Matches.isTerritoryAllied(player, data).match(oneTerr)) continue;
                        newRoute2.add(oneTerr);
                    }
                }
                if (newRoute2.getLength() < 1) continue;
                moveUnits.add(collection);
                moveRoutes.add(newRoute2);
                s_logger.finer("PNC move towards:default " + collection + " route " + newRoute2);
                alreadyMoved.addAll(collection);
                Territory endPoint = newRoute2.getEnd();
                if (movedInto.contains(endPoint)) continue;
                movedInto.add(endPoint);
            }
        }
    }

    private void secondNonCombat(List<Collection<Unit>> moveUnits, List<Route> moveRoutes, PlayerID player, GameData data) {
        ArrayList alreadyMoved = new ArrayList();
        boolean tFirst = this.transportsMayDieFirst();
        CompositeMatchAnd<Unit> unMovedLand = new CompositeMatchAnd<Unit>(Matches.UnitIsLand, Matches.UnitIsNotAA, Matches.UnitCanNotProduceUnits, Matches.UnitIsNotInfrastructure);
        CompositeMatchAnd<Unit> ourUnMovedLand = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), unMovedLand, Matches.unitHasNotMoved);
        List<Territory> unMovedLandTerr = SUtils.findTersWithUnitsMatching(data, player, ourUnMovedLand);
        HashMap<Territory, Float> landMap = new HashMap<Territory, Float>();
        List<Territory> ourOwnedTerr = SUtils.allAlliedTerritories(data, player);
        for (Territory ourTerr : ourOwnedTerr) {
            float eStrength = SUtils.getStrengthOfPotentialAttackers(ourTerr, data, player, tFirst, true, null);
            float myStrength = SUtils.strength(ourTerr.getUnits().getUnits(), false, false, tFirst);
            float diffStrength = eStrength - myStrength;
            landMap.put(ourTerr, Float.valueOf(diffStrength));
        }
        List<Territory> myFactories = Match.getMatches(SUtils.findTersWithUnitsMatching(data, player, Matches.UnitCanProduceUnits), Matches.isTerritoryAllied(player, data));
        for (Territory factTerr : myFactories) {
            float diffStrength = ((Float)landMap.get(factTerr)).floatValue();
            if (!(diffStrength > 0.0f)) continue;
            List<Territory> landNeighbors = SUtils.getNeighboringLandTerritories(data, player, factTerr);
            ArrayList<Territory> grabFromTerr = new ArrayList<Territory>();
            for (Territory lN : landNeighbors) {
                if (!unMovedLandTerr.contains(lN)) continue;
                grabFromTerr.add(lN);
            }
            SUtils.reorder(grabFromTerr, landMap, false);
            Iterator grabIter = grabFromTerr.iterator();
            while (grabIter.hasNext() && diffStrength > 0.0f) {
                float availStrength;
                float f;
                Territory availTerr = (Territory)grabIter.next();
                List<Unit> availUnits = SUtils.sortTransportUnits(availTerr.getUnits().getMatches(ourUnMovedLand));
                availUnits.removeAll(alreadyMoved);
                Iterator<Unit> availIter = availUnits.iterator();
                ArrayList<Unit> moveThese = new ArrayList<Unit>();
                for (availStrength = -((Float)landMap.get(availTerr)).floatValue(); availIter.hasNext() && diffStrength > 0.0f && availStrength > 0.0f; diffStrength -= f, availStrength -= f) {
                    Unit moveOne = availIter.next();
                    f = SUtils.uStrength(moveOne, false, false, tFirst);
                    moveThese.add(moveOne);
                }
                landMap.put(availTerr, Float.valueOf(-availStrength));
                Route aRoute = data.getMap().getLandRoute(availTerr, factTerr);
                moveUnits.add(moveThese);
                moveRoutes.add(aRoute);
                alreadyMoved.addAll(moveThese);
            }
            landMap.put(factTerr, Float.valueOf(diffStrength));
        }
        CompositeMatchAnd<Territory> endCondition = new CompositeMatchAnd<Territory>(Matches.territoryHasEnemyUnits(player, data), Matches.TerritoryIsNotNeutralButCouldBeWater, Matches.TerritoryIsLand);
        for (Territory ownedTerr : unMovedLandTerr) {
            Route closestERoute;
            float diffStrength;
            if (ownedTerr.isWater() || !ownedTerr.getOwner().equals(player) || !((diffStrength = -((Float)landMap.get(ownedTerr)).floatValue()) > 0.0f) || ownedTerr.getUnits().getMatches(unMovedLand).size() <= 1 || !data.getMap().getNeighbors(ownedTerr, endCondition).isEmpty() || (closestERoute = SUtils.findNearest(ownedTerr, endCondition, Matches.TerritoryIsNotImpassableToLandUnits(player, data), data)) == null || closestERoute.getEnd() == null) continue;
            List<Unit> ourOwnedUnits = ownedTerr.getUnits().getMatches(ourUnMovedLand);
            ourOwnedUnits.removeAll(alreadyMoved);
            if (ourOwnedUnits.isEmpty()) continue;
            ArrayList<Collection<Unit>> ourOwnedUnits2 = new ArrayList<Collection<Unit>>();
            SUtils.breakUnitsBySpeed(ourOwnedUnits2, data, player, ourOwnedUnits);
            Territory targetTerr = closestERoute.getEnd();
            float goTerrStrength = SUtils.strength(targetTerr.getUnits().getMatches(Matches.alliedUnit(player, data)), false, false, tFirst);
            float goTerrEStrength = SUtils.getStrengthOfPotentialAttackers(targetTerr, data, player, tFirst, true, null);
            float goDiffStrength = goTerrEStrength - goTerrStrength;
            if (goDiffStrength - diffStrength > 8.0f) continue;
            for (Collection collection : ourOwnedUnits2) {
                Iterator unitIter = collection.iterator();
                int moveDist = MoveValidator.getLeastMovement(collection);
                ArrayList<Unit> moveThese = new ArrayList<Unit>();
                Territory realTargetTerr = closestERoute.getTerritories().get(closestERoute.getLength() - 1);
                Route targetRoute = new Route();
                if (moveDist < closestERoute.getLength()) {
                    realTargetTerr = closestERoute.getTerritories().get(moveDist);
                }
                targetRoute = data.getMap().getRoute(ownedTerr, realTargetTerr, Matches.isTerritoryAllied(player, data));
                while (unitIter.hasNext() && diffStrength > 0.0f) {
                    Unit oneUnit = (Unit)unitIter.next();
                    diffStrength -= SUtils.uStrength(oneUnit, false, false, tFirst);
                    moveThese.add(oneUnit);
                }
                moveUnits.add(moveThese);
                moveRoutes.add(targetRoute);
                alreadyMoved.addAll(moveThese);
                landMap.put(ownedTerr, Float.valueOf(-diffStrength));
            }
        }
        CompositeMatchAnd ownedUnit = new CompositeMatchAnd(Matches.unitIsOwnedBy(player));
        CompositeMatchAnd<Unit> ourFactory = new CompositeMatchAnd<Unit>(ownedUnit, Matches.UnitCanProduceUnits);
        CompositeMatchAnd<Unit> moveableFactory = new CompositeMatchAnd<Unit>(ourFactory, Matches.UnitCanMove, Matches.unitHasMovementLeft);
        List<Territory> moveableFactoryTerritories = SUtils.findUnitTerr(data, player, moveableFactory);
        if (!moveableFactoryTerritories.isEmpty()) {
            CompositeMatchAnd<Territory> endConditionEnemyLand = new CompositeMatchAnd<Territory>(Matches.isTerritoryEnemy(player, data), Matches.TerritoryIsNotImpassable, Matches.TerritoryIsLand);
            CompositeMatchAnd<Territory> routeConditionLand = new CompositeMatchAnd<Territory>(Matches.isTerritoryAllied(player, data), Matches.TerritoryIsNotImpassable, Matches.TerritoryIsLand);
            List<Territory> owned = SUtils.allOurTerritories(data, player);
            List<Territory> existingFactories = SUtils.findTersWithUnitsMatching(data, player, Matches.UnitCanProduceUnits);
            owned.removeAll(existingFactories);
            List<Territory> isWaterConvoy = SUtils.onlyWaterTerr(data, owned);
            owned.removeAll(isWaterConvoy);
            CompositeMatchAnd<Territory> goodFactTerr = new CompositeMatchAnd<Territory>(Matches.TerritoryIsNotImpassableToLandUnits(player, data), Matches.isTerritoryOwnedBy(player));
            for (Territory territory : moveableFactoryTerritories) {
                List<Unit> moveableFactories = territory.getUnits().getMatches(moveableFactory);
                if (moveableFactories.size() <= 0 || territory.getUnits().getMatches(ourFactory).size() <= 1) continue;
                ArrayList<Territory> goodNeighbors = new ArrayList<Territory>(data.getMap().getNeighbors(territory, goodFactTerr));
                goodNeighbors.retainAll(owned);
                Collections.shuffle(goodNeighbors);
                IntegerMap<Territory> terrValue = new IntegerMap<Territory>();
                for (Territory moveFactToTerr : goodNeighbors) {
                    Route r;
                    int territoryValue = 0;
                    territoryValue += Math.random() < 0.4 ? 1 : 0;
                    territoryValue += Math.random() < 0.4 ? 1 : 0;
                    if (SUtils.hasLandRouteToEnemyOwnedCapitol(moveFactToTerr, player, data)) {
                        territoryValue += 3;
                    }
                    if (SUtils.findNearest(moveFactToTerr, Matches.territoryIsEnemyNonNeutralAndHasEnemyUnitMatching(data, player, Matches.UnitCanProduceUnits), Matches.TerritoryIsNotImpassableToLandUnits(player, data), data) != null) {
                        ++territoryValue;
                    }
                    if (Matches.territoryHasWaterNeighbor(data).match(moveFactToTerr)) {
                        territoryValue += 3;
                    }
                    territoryValue = (r = SUtils.findNearest(moveFactToTerr, endConditionEnemyLand, routeConditionLand, data)) != null ? (territoryValue += 10 - r.getLength()) : ((r = SUtils.findNearest(moveFactToTerr, endConditionEnemyLand, Matches.TerritoryIsWater, data)) != null ? (territoryValue += 8 - r.getLength()) : (territoryValue -= 115));
                    territoryValue += 4 * TerritoryAttachment.getProduction(moveFactToTerr);
                    List<Territory> weOwnAll = SUtils.getNeighboringEnemyLandTerritories(data, player, moveFactToTerr);
                    List<Territory> isWater = SUtils.onlyWaterTerr(data, weOwnAll);
                    weOwnAll.removeAll(isWater);
                    Iterator<Territory> weOwnAllIter = weOwnAll.iterator();
                    while (weOwnAllIter.hasNext()) {
                        Territory tempFact = weOwnAllIter.next();
                        if (!Matches.TerritoryIsNeutralButNotWater.match(tempFact) && !Matches.TerritoryIsImpassable.match(tempFact)) continue;
                        weOwnAllIter.remove();
                    }
                    territoryValue -= 15 * weOwnAll.size();
                    if (TerritoryAttachment.getProduction(moveFactToTerr) < 2) {
                        territoryValue -= 100;
                    }
                    if (TerritoryAttachment.getProduction(moveFactToTerr) < 1) {
                        territoryValue -= 100;
                    }
                    terrValue.put(moveFactToTerr, territoryValue);
                }
                SUtils.reorder(goodNeighbors, terrValue, true);
                if (goodNeighbors.size() == 0) continue;
                int i = 0;
                int j = 0;
                int diff = territory.getUnits().getMatches(ourFactory).size() - moveableFactories.size();
                for (Unit factoryUnit : moveableFactories) {
                    if (diff < 1 && j >= moveableFactories.size() - 1) continue;
                    if (i >= goodNeighbors.size()) {
                        i = 0;
                    }
                    moveRoutes.add(data.getMap().getRoute(territory, (Territory)goodNeighbors.get(i)));
                    moveUnits.add(Collections.singleton(factoryUnit));
                    ++i;
                    ++j;
                }
            }
        }
    }

    private void movePlanesHomeNonCom(List<Collection<Unit>> moveUnits, List<Route> moveRoutes, PlayerID player, GameData data) {
        IMoveDelegate delegateRemote = (IMoveDelegate)this.getPlayerBridge().getRemoteDelegate();
        CompositeMatchAnd<Unit> alliedFactory = new CompositeMatchAnd<Unit>(Matches.alliedUnit(player, data), Matches.UnitCanProduceUnits);
        CompositeMatchAnd<Unit> fighterUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitCanLandOnCarrier);
        CompositeMatchAnd<Unit> bomberUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitCanLandOnCarrier.invert(), Matches.UnitIsAir);
        CompositeMatchAnd<Unit> alliedFighterUnit = new CompositeMatchAnd<Unit>(Matches.alliedUnit(player, data), Matches.UnitCanLandOnCarrier);
        CompositeMatchAnd<Unit> carrierUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsCarrier);
        CompositeMatchAnd<Unit> alliedACUnit = new CompositeMatchAnd<Unit>(Matches.alliedUnit(player, data), Matches.UnitIsCarrier);
        CompositeMatchAnd<Territory> noEnemyNeighbor = new CompositeMatchAnd<Territory>(Matches.isTerritoryAllied(player, data), Matches.territoryHasEnemyLandNeighbor(data, player).invert());
        CompositeMatchAnd<Territory> noNeutralOrAA = new CompositeMatchAnd<Territory>(Matches.TerritoryIsNotNeutralButCouldBeWater, Matches.territoryHasEnemyAAforCombatOnly(player, data).invert(), Matches.TerritoryIsNotImpassable);
        ArrayList<Unit> alreadyMoved = new ArrayList<Unit>();
        ArrayList<Territory> alreadyCheck = new ArrayList<Territory>();
        final BattleDelegate delegate = DelegateFinder.battleDelegate(data);
        CompositeMatchAnd<Territory> canLand = new CompositeMatchAnd<Territory>(Matches.isTerritoryAllied(player, data), new Match<Territory>(){

            @Override
            public boolean match(Territory o) {
                return !delegate.getBattleTracker().wasConquered(o);
            }
        });
        CompositeMatchAnd<Territory> routeCondition = new CompositeMatchAnd<Territory>(Matches.territoryHasEnemyAAforCombatOnly(player, data).invert(), Matches.TerritoryIsPassableAndNotRestricted(player, data));
        Territory myCapital = TerritoryAttachment.getFirstOwnedCapitalOrFirstUnownedCapital(player, data);
        List<Territory> alliedFactories = SUtils.findUnitTerr(data, player, alliedFactory);
        for (Territory tBomb : delegateRemote.getTerritoriesWhereAirCantLand()) {
            Route bomberRoute;
            List<Unit> bomberUnits = tBomb.getUnits().getMatches(bomberUnit);
            bomberUnits.removeAll(alreadyMoved);
            ArrayList<Unit> sendBombers = new ArrayList<Unit>();
            alreadyCheck.add(tBomb);
            for (Unit bU : bomberUnits) {
                boolean landable;
                if (bU == null || !(landable = SUtils.airUnitIsLandable(bU, tBomb, myCapital, player, data))) continue;
                sendBombers.add(bU);
            }
            if (sendBombers.size() > 0 && tBomb != myCapital && (bomberRoute = data.getMap().getRoute(tBomb, myCapital, noNeutralOrAA)) != null && bomberRoute.getEnd() != null && AirMovementValidator.canLand(sendBombers, bomberRoute.getEnd(), player, data)) {
                moveRoutes.add(bomberRoute);
                moveUnits.add(sendBombers);
                alreadyMoved.addAll(sendBombers);
            }
            bomberUnits.removeAll(sendBombers);
            Iterator<Unit> bUIter = bomberUnits.iterator();
            while (bUIter.hasNext()) {
                Route bomberRoute3;
                boolean landedOne = false;
                Unit bU = bUIter.next();
                if (bU == null) continue;
                for (Territory aFactory : alliedFactories) {
                    Route bomberFactoryRoute = data.getMap().getRoute(tBomb, aFactory, noNeutralOrAA);
                    if (bomberFactoryRoute == null || !MoveValidator.hasEnoughMovement(bU, bomberFactoryRoute) || landedOne) continue;
                    moveUnits.add(Collections.singleton(bU));
                    moveRoutes.add(bomberFactoryRoute);
                    alreadyMoved.add(bU);
                    bUIter.remove();
                    landedOne = true;
                }
                if (landedOne) continue;
                Route goodBomberRoute = SUtils.findNearest(tBomb, noEnemyNeighbor, noNeutralOrAA, data);
                if (goodBomberRoute != null && MoveValidator.hasEnoughMovement(bU, goodBomberRoute)) {
                    moveUnits.add(Collections.singleton(bU));
                    moveRoutes.add(goodBomberRoute);
                    alreadyMoved.add(bU);
                    bUIter.remove();
                    landedOne = true;
                }
                if (landedOne) continue;
                Route bomberRoute2 = SUtils.findNearestNotEmpty(tBomb, canLand, routeCondition, data);
                if (bomberRoute2 != null && MoveValidator.hasEnoughMovement(bU, bomberRoute2)) {
                    moveRoutes.add(bomberRoute2);
                    moveUnits.add(Collections.singleton(bU));
                    alreadyMoved.add(bU);
                    bUIter.remove();
                    landedOne = true;
                }
                if (landedOne || (bomberRoute3 = SUtils.findNearest(tBomb, canLand, noNeutralOrAA, data)) == null || !MoveValidator.hasEnoughMovement(bU, bomberRoute3)) continue;
                ArrayList<Unit> qAdd = new ArrayList<Unit>();
                qAdd.add(bU);
                moveRoutes.add(bomberRoute3);
                moveUnits.add(qAdd);
                alreadyMoved.add(bU);
                bUIter.remove();
            }
        }
        ArrayList<Territory> ourFriendlyTerr = new ArrayList<Territory>();
        ArrayList<Territory> ourEnemyTerr = new ArrayList<Territory>();
        HashMap<Object, Object> rankMap = new HashMap();
        rankMap = SUtils.rankTerritories(data, ourFriendlyTerr, ourEnemyTerr, null, player, false, false, true);
        Collection<Territory> badPlaneTerrs = delegateRemote.getTerritoriesWhereAirCantLand();
        for (Territory tFight : badPlaneTerrs) {
            Iterator fIter;
            ArrayList<Unit> fighterUnits = new ArrayList<Unit>(tFight.getUnits().getMatches(fighterUnit));
            fighterUnits.removeAll(alreadyMoved);
            if (fighterUnits.isEmpty()) continue;
            ArrayList<Unit> ACUnits = new ArrayList<Unit>(tFight.getUnits().getMatches(carrierUnit));
            int carrierSpace = 0;
            for (Unit carrier1 : ACUnits) {
                carrierSpace += UnitAttachment.get(carrier1.getType()).getCarrierCapacity();
            }
            ArrayList<Unit> alliedACUnits = new ArrayList<Unit>(tFight.getUnits().getMatches(alliedACUnit));
            int alliedCarrierSpace = 0;
            for (Unit carrier1 : alliedACUnits) {
                alliedCarrierSpace += UnitAttachment.get(carrier1.getType()).getCarrierCapacity();
            }
            ArrayList<Unit> alliedFighters = new ArrayList<Unit>(tFight.getUnits().getMatches(alliedFighterUnit));
            alliedFighters.removeAll(fighterUnits);
            int totFighters = fighterUnits.size();
            int alliedFighterSpace = 0;
            for (Unit fighter1 : fighterUnits) {
                totFighters += UnitAttachment.get(fighter1.getType()).getCarrierCost();
            }
            for (Unit fighter1 : alliedFighters) {
                alliedFighterSpace += UnitAttachment.get(fighter1.getType()).getCarrierCost();
            }
            ArrayList<Collection<Unit>> fighterList = new ArrayList<Collection<Unit>>();
            SUtils.breakUnitsBySpeed(fighterList, data, player, fighterUnits);
            int needToLand = fighterUnits.size();
            if (carrierSpace > 0) {
                fIter = fighterList.iterator();
                while (fIter.hasNext() && carrierSpace > 0) {
                    Collection newFighters = (Collection)fIter.next();
                    Iterator nFIter = newFighters.iterator();
                    while (nFIter.hasNext() && carrierSpace > 0) {
                        Unit markFighter = (Unit)nFIter.next();
                        carrierSpace -= UnitAttachment.get(markFighter.getType()).getCarrierCost();
                        nFIter.remove();
                        --needToLand;
                    }
                }
            }
            fIter = fighterList.iterator();
            while (needToLand > 0 && fIter.hasNext()) {
                Collection fighterGroup = (Collection)fIter.next();
                if (fighterGroup.isEmpty()) continue;
                int flightDistance = MoveValidator.getMaxMovement(fighterGroup);
                Set<Territory> allTerr = data.getMap().getNeighbors(tFight, flightDistance);
                List<Territory> landingZones = Match.getMatches(allTerr, canLand);
                SUtils.reorder(landingZones, rankMap, false);
                Iterator<Territory> lzIter = landingZones.iterator();
                for (Territory t : landingZones) {
                    s_logger.fine("possible" + t + " " + rankMap.get(t));
                }
                while (needToLand > 0 && lzIter.hasNext() && !fighterGroup.isEmpty()) {
                    Route landingRoute;
                    Territory landingZone = lzIter.next();
                    s_logger.fine("trying" + landingZone + " " + rankMap.get(landingZone));
                    if (!Matches.TerritoryIsPassableAndNotRestricted(player, data).match(landingZone) || !AirMovementValidator.canLand(fighterGroup, landingZone, player, data) || (landingRoute = data.getMap().getRoute(tFight, landingZone, noNeutralOrAA)) == null || !MoveValidator.hasEnoughMovement((Collection<Unit>)fighterGroup, landingRoute)) continue;
                    Iterator fIter2 = fighterGroup.iterator();
                    ArrayList<Unit> landThese = new ArrayList<Unit>();
                    boolean landSome = false;
                    while (needToLand > 0 && fIter2.hasNext()) {
                        Unit fighter = (Unit)fIter2.next();
                        landThese.add(fighter);
                        fIter2.remove();
                        landSome = true;
                        s_logger.fine("Added: " + fighter + "; Left To Land: " + --needToLand);
                    }
                    if (!landSome) continue;
                    moveUnits.add(landThese);
                    moveRoutes.add(landingRoute);
                    alreadyMoved.addAll(landThese);
                }
            }
        }
    }

    private void bomberNonComMove(GameData data, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, PlayerID player) {
        BattleDelegate delegate = DelegateFinder.battleDelegate(data);
        CompositeMatchAnd<Unit> myBomberUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsStrategicBomber);
        CompositeMatchAnd<Unit> alliedFactory = new CompositeMatchAnd<Unit>(Matches.alliedUnit(player, data), Matches.UnitCanProduceUnits);
        CompositeMatchOr<Territory> waterOrLand = new CompositeMatchOr<Territory>(Matches.TerritoryIsWater, Matches.TerritoryIsLand);
        List<Territory> alliedFactories = SUtils.findUnitTerr(data, player, alliedFactory);
        List<Territory> bomberTerrs = SUtils.findTersWithUnitsMatching(data, player, Matches.UnitIsStrategicBomber);
        if (bomberTerrs.isEmpty()) {
            return;
        }
        Iterator<Territory> bTerrIter = bomberTerrs.iterator();
        while (bTerrIter.hasNext()) {
            Territory bTerr = bTerrIter.next();
            Route bRoute = SUtils.findNearest(bTerr, Matches.territoryHasEnemyUnits(player, data), waterOrLand, data);
            if (bRoute != null && (bRoute.getLength() >= 4 || !Matches.TerritoryIsLand.match(bTerr) || delegate.getBattleTracker().wasBattleFought(bTerr))) continue;
            bTerrIter.remove();
        }
        if (bomberTerrs.isEmpty()) {
            return;
        }
        ArrayList<Unit> unitsAlreadyMoved = new ArrayList<Unit>();
        IntegerMap<Territory> shipMap = new IntegerMap<Territory>();
        HashMap<Territory, Float> strengthMap = new HashMap<Territory, Float>();
        for (Territory aF : alliedFactories) {
            Route distToEnemy;
            if (delegate.getBattleTracker().wasConquered(aF) || (distToEnemy = SUtils.findNearest(aF, Matches.territoryHasEnemyUnits(player, data), waterOrLand, data)) == null || distToEnemy.getEnd() == null) continue;
            int eDist = distToEnemy.getLength();
            shipMap.put(aF, eDist);
            float eStrength = SUtils.getStrengthOfPotentialAttackers(aF, data, player, true, false, null);
            strengthMap.put(aF, Float.valueOf(eStrength));
        }
        ArrayList checkTerrs = new ArrayList(shipMap.keySet());
        if (!checkTerrs.isEmpty()) {
            List<Unit> bUnits;
            Route bRoute;
            SUtils.reorder(checkTerrs, shipMap, false);
            for (Territory checkTerr : checkTerrs) {
                for (Territory bTerr : bomberTerrs) {
                    bRoute = data.getMap().getRoute(bTerr, checkTerr, waterOrLand);
                    if (bRoute == null || bRoute.getEnd() == null) continue;
                    bUnits = bTerr.getUnits().getMatches(myBomberUnit);
                    bUnits.removeAll(unitsAlreadyMoved);
                    if (bUnits.isEmpty()) continue;
                    if (MoveValidator.hasEnoughMovement(bUnits, bRoute)) {
                        moveUnits.add(bUnits);
                        moveRoutes.add(bRoute);
                        unitsAlreadyMoved.addAll(bUnits);
                        continue;
                    }
                    for (Unit bomber : bUnits) {
                        if (!MoveValidator.hasEnoughMovement(bomber, bRoute)) continue;
                        moveUnits.add(Collections.singleton(bomber));
                        moveRoutes.add(bRoute);
                        unitsAlreadyMoved.add(bomber);
                    }
                }
            }
            checkTerrs.clear();
            checkTerrs.addAll(strengthMap.keySet());
            SUtils.reorder(checkTerrs, strengthMap, true);
            for (Territory checkTerr : checkTerrs) {
                for (Territory bTerr : bomberTerrs) {
                    bRoute = data.getMap().getRoute(bTerr, checkTerr, SUtils.TerritoryIsNotImpassableToAirUnits(data));
                    if (bRoute == null || bRoute.getEnd() == null) continue;
                    bUnits = bTerr.getUnits().getMatches(myBomberUnit);
                    bUnits.removeAll(unitsAlreadyMoved);
                    if (bUnits.isEmpty()) continue;
                    if (MoveValidator.hasEnoughMovement(bUnits, bRoute)) {
                        moveUnits.add(bUnits);
                        moveRoutes.add(bRoute);
                        unitsAlreadyMoved.addAll(bUnits);
                        continue;
                    }
                    for (Unit bomber : bUnits) {
                        if (!MoveValidator.hasEnoughMovement(bomber, bRoute)) continue;
                        moveUnits.add(Collections.singleton(bomber));
                        moveRoutes.add(bRoute);
                        unitsAlreadyMoved.add(bomber);
                    }
                }
            }
        }
    }

    /*
     * Could not resolve type clashes
     */
    private void populateCombatMove(GameData data, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, PlayerID player) {
        this.setImpassableTerrs(player);
        Collection<Territory> impassableTerrs = this.getImpassableTerrs();
        HashMap<PlayerID, IntegerMap<UnitType>> costMap = SUtils.getPlayerCostMap(data);
        boolean aggressive = SUtils.determineAggressiveAttack(data, player, 1.4f);
        float maxAttackFactor = 2.0f;
        float attackFactor = 1.73f;
        float attackFactor2 = 1.11f;
        final HashSet<Unit> unitsAlreadyMoved = new HashSet<Unit>();
        List<Territory> enemyOwned = SUtils.getNeighboringEnemyLandTerritories(data, player, true);
        enemyOwned.removeAll(impassableTerrs);
        boolean tFirst = this.transportsMayDieFirst();
        List<Territory> alreadyAttacked = this.getLandTerrAttacked();
        Territory myCapital = TerritoryAttachment.getFirstOwnedCapitalOrFirstUnownedCapital(player, data);
        float eCapStrength = SUtils.getStrengthOfPotentialAttackers(myCapital, data, player, tFirst, false, null);
        float ourStrength = SUtils.strength(myCapital.getUnits().getUnits(), false, false, tFirst);
        boolean capDanger = eCapStrength > ourStrength;
        boolean ownMyCapital = myCapital.getOwner() == player;
        ArrayList<Territory> emptyBadTerr = new ArrayList<Territory>();
        float remainingStrengthNeeded = 0.0f;
        List<Territory> liveEnemyCaps = SUtils.getLiveEnemyCapitals(data, player);
        CompositeMatchAnd<Unit> attackable = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsLand, Matches.UnitIsNotAA, Matches.UnitCanMove, Matches.UnitCanNotProduceUnits, Matches.UnitIsNotInfrastructure, Matches.UnitCanNotMoveDuringCombatMove.invert(), new Match<Unit>(){

            @Override
            public boolean match(Unit o) {
                return !unitsAlreadyMoved.contains(o);
            }
        });
        CompositeMatchAnd alliedNotOwned = new CompositeMatchAnd(Matches.alliedUnit(player, data), new InverseMatch<Unit>(Matches.unitIsOwnedBy(player)));
        CompositeMatchAnd alliedAirUnit = new CompositeMatchAnd(alliedNotOwned, Matches.UnitIsAir);
        CompositeMatchAnd alliedLandUnit = new CompositeMatchAnd(alliedNotOwned, Matches.UnitIsLand, Matches.UnitIsNotAA, Matches.UnitCanNotProduceUnits, Matches.UnitIsNotInfrastructure);
        CompositeMatchOr<Unit> alliedAirLandUnitNotOwned = new CompositeMatchOr<Unit>(alliedAirUnit, alliedLandUnit);
        CompositeMatchAnd<Unit> blitzUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitCanBlitz);
        CompositeMatchAnd<Unit> enemyLandAirUnit = new CompositeMatchAnd<Unit>(Matches.UnitIsNotSea, Matches.UnitIsNotAA, Matches.UnitCanNotProduceUnits, Matches.UnitIsNotInfrastructure);
        CompositeMatchAnd<Territory> enemyTerr = new CompositeMatchAnd<Territory>(Matches.isTerritoryEnemyAndNotUnownedWaterOrImpassibleOrRestricted(player, data), Matches.TerritoryIsNotImpassableToLandUnits(player, data));
        if (!ownMyCapital) {
            attackFactor = 0.78f;
            enemyOwned.remove(myCapital);
        }
        List<Territory> bigProblem2 = SUtils.getNeighboringEnemyLandTerritories(data, player, myCapital);
        HashMap<Territory, Float> sortProblems = new HashMap<Territory, Float>();
        int numTerrProblem = 0;
        int realProblems = 0;
        float xStrength = 0.0f;
        Territory xTerr = null;
        HashMap<Territory, Float> enemyMap = new HashMap<Territory, Float>();
        Territory maxAttackTerr = SUtils.landAttackMap(data, player, enemyMap);
        if (maxAttackTerr == null) {
            return;
        }
        SUtils.reorder(enemyOwned, enemyMap, true);
        float aggregateStrength = 0.0f;
        Iterator<Territory> bPIter = bigProblem2.iterator();
        while (bPIter.hasNext()) {
            Territory bPTerr = bPIter.next();
            if (!Matches.TerritoryIsNeutralButNotWater.match(bPTerr)) continue;
            bPIter.remove();
        }
        for (Territory tProb : bigProblem2) {
            xStrength = !tProb.getUnits().someMatch(Matches.enemyUnit(player, data)) ? 0.0f : SUtils.strength(tProb.getUnits().getUnits(), false, false, tFirst);
            aggregateStrength += xStrength;
            if (xStrength > 10.0f) {
                ++realProblems;
            }
            sortProblems.put(tProb, Float.valueOf(xStrength));
            ++numTerrProblem;
        }
        SUtils.reorder(bigProblem2, sortProblems, true);
        List<Territory> seaTerrAttacked = this.getSeaTerrAttacked();
        ArrayList<Collection<Unit>> xMoveUnits = new ArrayList<Collection<Unit>>();
        ArrayList<Route> xMoveRoutes = new ArrayList<Route>();
        ArrayList<Unit> xAlreadyMoved = new ArrayList<Unit>();
        if (!ownMyCapital) {
            List<Territory> attackFrom = SUtils.getNeighboringLandTerritories(data, player, myCapital);
            float badCapStrength = SUtils.strength(myCapital.getUnits().getUnits(), false, false, tFirst);
            float capStrength = 0.0f;
            for (Territory checkCap : attackFrom) {
                List<Unit> units = checkCap.getUnits().getMatches(attackable);
                capStrength += SUtils.strength(units, true, false, tFirst);
            }
            float xRS = 1000.0f;
            boolean groundUnits = 1000.0f - (xRS -= SUtils.inviteBlitzAttack(false, myCapital, xRS, xAlreadyMoved, xMoveUnits, xMoveRoutes, data, player, true, true)) > 1.0f;
            xRS -= SUtils.invitePlaneAttack(false, false, myCapital, xRS, xAlreadyMoved, xMoveUnits, xMoveRoutes, data, player);
            if ((capStrength += 1000.0f - (xRS -= SUtils.inviteTransports(false, myCapital, xRS, xAlreadyMoved, xMoveUnits, xMoveRoutes, data, player, tFirst, false, seaTerrAttacked))) > badCapStrength * 0.78f) {
                for (Object owned : attackFrom) {
                    List<Unit> units = ((Territory)owned).getUnits().getMatches(attackable);
                    if (units.size() <= 0) continue;
                    unitsAlreadyMoved.addAll(units);
                    moveUnits.add(units);
                    moveRoutes.add(data.getMap().getRoute((Territory)owned, myCapital));
                    alreadyAttacked.add(myCapital);
                    groundUnits = true;
                }
                if (groundUnits) {
                    moveUnits.addAll(xMoveUnits);
                    moveRoutes.addAll(xMoveRoutes);
                    unitsAlreadyMoved.addAll(xAlreadyMoved);
                }
            }
        }
        xMoveUnits.clear();
        xMoveRoutes.clear();
        xAlreadyMoved.clear();
        if (capDanger) {
            List<Territory> eCapTerrs = SUtils.getNeighboringEnemyLandTerritories(data, player, myCapital);
            Iterator<Territory> eCIter = eCapTerrs.iterator();
            while (eCIter.hasNext()) {
                Territory noNeutralTerr = eCIter.next();
                if (!Matches.TerritoryIsNeutralButNotWater.match(noNeutralTerr)) continue;
                eCIter.remove();
            }
            HashMap<Territory, Float> eCapMap = new HashMap<Territory, Float>();
            float maxStrength = 0.0f;
            for (Territory eCapTerr : eCapTerrs) {
                List<Unit> eCapUnits = eCapTerr.getUnits().getMatches(Matches.enemyUnit(player, data));
                float eStrength = SUtils.strength(eCapUnits, false, false, tFirst);
                eCapMap.put(eCapTerr, Float.valueOf(eStrength));
                if (!(eStrength > maxStrength)) continue;
                maxStrength = eStrength;
            }
            SUtils.reorder(eCapTerrs, eCapMap, true);
            ArrayList<Collection<Unit>> tempMoves = new ArrayList<Collection<Unit>>();
            ArrayList<Route> tempRoutes = new ArrayList<Route>();
            ArrayList<Unit> tempAMoved = new ArrayList<Unit>();
            ArrayList<Territory> capThreatElim = new ArrayList<Territory>(alreadyAttacked);
            xAlreadyMoved.addAll(unitsAlreadyMoved);
            float strengthForAttack = 0.0f;
            float capAttackFactor = 1.45f;
            if (eCapTerrs.size() > 1) {
                capAttackFactor = 1.25f;
            }
            for (Territory killTerr : eCapTerrs) {
                float realEStrength = ((Float)eCapMap.get(killTerr)).floatValue();
                float sNeeded = realEStrength * capAttackFactor + 5.0f;
                float blitzS = SUtils.inviteBlitzAttack(false, killTerr, sNeeded, xAlreadyMoved, xMoveUnits, xMoveRoutes, data, player, true, true);
                float planeS = SUtils.invitePlaneAttack(false, false, killTerr, sNeeded -= blitzS, xAlreadyMoved, xMoveUnits, xMoveRoutes, data, player);
                float landS = SUtils.inviteLandAttack(false, killTerr, sNeeded -= planeS, xAlreadyMoved, xMoveUnits, xMoveRoutes, data, player, true, true, alreadyAttacked);
                float transS = SUtils.inviteTransports(false, killTerr, sNeeded -= landS, xAlreadyMoved, xMoveUnits, xMoveRoutes, data, player, tFirst, false, seaTerrAttacked);
                sNeeded -= transS;
                strengthForAttack = blitzS + planeS + landS + transS;
                if (strengthForAttack > realEStrength * 0.92f + 2.0f) {
                    tempMoves.addAll(xMoveUnits);
                    tempRoutes.addAll(xMoveRoutes);
                    tempAMoved.addAll(xAlreadyMoved);
                    capThreatElim.add(killTerr);
                }
                xMoveUnits.clear();
                xMoveRoutes.clear();
                xAlreadyMoved.clear();
                xAlreadyMoved.addAll(unitsAlreadyMoved);
                xAlreadyMoved.addAll(tempAMoved);
            }
            float xCapThreat = SUtils.getStrengthOfPotentialAttackers(myCapital, data, player, tFirst, true, capThreatElim);
            Collection<Unit> alliedCapUnits = myCapital.getUnits().getUnits();
            Collection<Unit> purchaseUnits = player.getUnits().getUnits();
            float newStrength = SUtils.strength(purchaseUnits, false, false, tFirst);
            for (Collection xUnits : tempMoves) {
                alliedCapUnits.removeAll(xUnits);
            }
            float strengthLeft = SUtils.strength(alliedCapUnits, false, false, tFirst);
            if ((newStrength += strengthLeft) > xCapThreat * 0.92f) {
                alreadyAttacked.addAll(capThreatElim);
                for (Collection tM : tempMoves) {
                    moveUnits.add(tM);
                }
                moveRoutes.addAll(tempRoutes);
                unitsAlreadyMoved.addAll(tempAMoved);
                capDanger = false;
            } else {
                capDanger = this.markFactoryUnits(data, player, unitsAlreadyMoved);
                if (capDanger) {
                    Collection<Unit> allFactoryUnits = myCapital.getUnits().getUnits();
                    float myTotalStrength = SUtils.strength(allFactoryUnits, false, false, tFirst);
                    Collection<Unit> newUnits = player.getUnits().getUnits();
                    myTotalStrength += SUtils.strength(newUnits, false, false, tFirst) * 0.75f;
                }
            }
        } else {
            this.SetCapGarrison(myCapital, player, eCapStrength, unitsAlreadyMoved);
        }
        xMoveUnits.clear();
        xMoveRoutes.clear();
        xAlreadyMoved.clear();
        CompositeMatchAnd ownedUnit = new CompositeMatchAnd(Matches.unitIsOwnedBy(player));
        CompositeMatchAnd<Unit> ourFactory = new CompositeMatchAnd<Unit>(ownedUnit, Matches.UnitCanProduceUnits);
        CompositeMatchAnd<Unit> moveableFactory = new CompositeMatchAnd<Unit>(ourFactory, Matches.UnitCanMove, Matches.UnitCanNotMoveDuringCombatMove.invert());
        List<Territory> moveableFactoryTerritories = SUtils.findUnitTerr(data, player, moveableFactory);
        if (!moveableFactoryTerritories.isEmpty()) {
            Object owned;
            CompositeMatchAnd<Territory> endConditionEnemyLand = new CompositeMatchAnd<Territory>(Matches.isTerritoryEnemy(player, data), Matches.TerritoryIsNotImpassable, Matches.TerritoryIsLand);
            CompositeMatchAnd<Territory> routeConditionLand = new CompositeMatchAnd<Territory>(Matches.isTerritoryAllied(player, data), Matches.TerritoryIsNotImpassable, Matches.TerritoryIsLand);
            owned = SUtils.allOurTerritories(data, player);
            List<Territory> existingFactories = SUtils.findTersWithUnitsMatching(data, player, Matches.UnitCanProduceUnits);
            owned.removeAll(existingFactories);
            List<Territory> isWaterConvoy = SUtils.onlyWaterTerr(data, (List<Territory>)owned);
            owned.removeAll(isWaterConvoy);
            CompositeMatchAnd<Territory> goodFactTerr = new CompositeMatchAnd<Territory>(Matches.TerritoryIsNotImpassableToLandUnits(player, data), Matches.isTerritoryOwnedBy(player));
            for (Territory moveableFactoryTerr : moveableFactoryTerritories) {
                List<Unit> moveableFactories = moveableFactoryTerr.getUnits().getMatches(moveableFactory);
                if (moveableFactories.size() <= 0 || moveableFactoryTerr.getUnits().getMatches(ourFactory).size() <= 1) continue;
                ArrayList<Territory> goodNeighbors = new ArrayList<Territory>(data.getMap().getNeighbors(moveableFactoryTerr, goodFactTerr));
                goodNeighbors.retainAll((Collection<?>)owned);
                Collections.shuffle(goodNeighbors);
                IntegerMap<Territory> terrValue = new IntegerMap<Territory>();
                for (Territory moveFactToTerr : goodNeighbors) {
                    Route r;
                    int territoryValue = 0;
                    if (SUtils.hasLandRouteToEnemyOwnedCapitol(moveFactToTerr, player, data)) {
                        territoryValue += 3;
                    }
                    if (SUtils.findNearest(moveFactToTerr, Matches.territoryIsEnemyNonNeutralAndHasEnemyUnitMatching(data, player, Matches.UnitCanProduceUnits), Matches.TerritoryIsNotImpassableToLandUnits(player, data), data) != null) {
                        ++territoryValue;
                    }
                    if (Matches.territoryHasWaterNeighbor(data).match(moveFactToTerr)) {
                        territoryValue += 3;
                    }
                    territoryValue = (r = SUtils.findNearest(moveFactToTerr, endConditionEnemyLand, routeConditionLand, data)) != null ? (territoryValue += 10 - r.getLength()) : ((r = SUtils.findNearest(moveFactToTerr, endConditionEnemyLand, Matches.TerritoryIsWater, data)) != null ? (territoryValue += 8 - r.getLength()) : (territoryValue -= 115));
                    territoryValue += 4 * TerritoryAttachment.getProduction(moveFactToTerr);
                    List<Territory> weOwnAll = SUtils.getNeighboringEnemyLandTerritories(data, player, moveFactToTerr);
                    List<Territory> isWater = SUtils.onlyWaterTerr(data, weOwnAll);
                    weOwnAll.removeAll(isWater);
                    Iterator<Territory> weOwnAllIter = weOwnAll.iterator();
                    while (weOwnAllIter.hasNext()) {
                        Territory tempFact = weOwnAllIter.next();
                        if (!Matches.TerritoryIsNeutralButNotWater.match(tempFact) && !Matches.TerritoryIsImpassable.match(tempFact)) continue;
                        weOwnAllIter.remove();
                    }
                    territoryValue -= 15 * weOwnAll.size();
                    if (TerritoryAttachment.getProduction(moveFactToTerr) < 2) {
                        territoryValue -= 100;
                    }
                    if (TerritoryAttachment.getProduction(moveFactToTerr) < 1) {
                        territoryValue -= 100;
                    }
                    terrValue.put(moveFactToTerr, territoryValue);
                }
                SUtils.reorder(goodNeighbors, terrValue, true);
                if (goodNeighbors.size() == 0) continue;
                int i = 0;
                int j = 0;
                int diff = moveableFactoryTerr.getUnits().getMatches(ourFactory).size() - moveableFactories.size();
                for (Unit factoryUnit : moveableFactories) {
                    if (diff < 1 && j >= moveableFactories.size() - 1) continue;
                    if (i >= goodNeighbors.size()) {
                        i = 0;
                    }
                    moveRoutes.add(data.getMap().getRoute(moveableFactoryTerr, (Territory)goodNeighbors.get(i)));
                    moveUnits.add(Collections.singleton(factoryUnit));
                    ++i;
                    ++j;
                }
            }
        }
        ArrayList<Territory> ourFriendlyTerr = new ArrayList<Territory>();
        ArrayList<Territory> ourEnemyTerr = new ArrayList<Territory>();
        HashMap<Territory, Float> rankMap = SUtils.rankTerritories(data, ourFriendlyTerr, ourEnemyTerr, null, player, tFirst, false, false);
        SUtils.reorder(liveEnemyCaps, rankMap, true);
        for (Territory badCapitol : liveEnemyCaps) {
            xMoveUnits.clear();
            xMoveRoutes.clear();
            xAlreadyMoved.clear();
            xAlreadyMoved.addAll(unitsAlreadyMoved);
            Collection<Unit> badCapUnits = badCapitol.getUnits().getUnits();
            float badCapStrength = SUtils.strength(badCapUnits, false, false, tFirst);
            float alliedCapStrength = 0.0f;
            float ourXStrength = 0.0f;
            List<Territory> alliedCapTerr = SUtils.getNeighboringLandTerritories(data, player, badCapitol);
            ArrayList<Unit> alliedCUnits = new ArrayList<Unit>();
            ArrayList<Unit> ourCUnits = new ArrayList<Unit>();
            if (!alliedCapTerr.isEmpty()) {
                for (Territory aT : alliedCapTerr) {
                    alliedCUnits.addAll(aT.getUnits().getMatches(alliedAirLandUnitNotOwned));
                    ourCUnits.addAll(aT.getUnits().getMatches(attackable));
                }
                ourCUnits.removeAll(unitsAlreadyMoved);
                alliedCapStrength += SUtils.strength(alliedCUnits, true, false, tFirst);
                ourXStrength += SUtils.strength(ourCUnits, true, false, tFirst);
            }
            remainingStrengthNeeded = badCapStrength * 2.5f + 8.0f;
            float blitzStrength = SUtils.inviteBlitzAttack(false, badCapitol, remainingStrengthNeeded, xAlreadyMoved, xMoveUnits, xMoveRoutes, data, player, true, true);
            float transStrength = SUtils.inviteTransports(false, badCapitol, remainingStrengthNeeded -= blitzStrength, xAlreadyMoved, xMoveUnits, xMoveRoutes, data, player, tFirst, false, seaTerrAttacked);
            float airStrength = SUtils.invitePlaneAttack(false, false, badCapitol, remainingStrengthNeeded -= transStrength, xAlreadyMoved, xMoveUnits, xMoveRoutes, data, player);
            remainingStrengthNeeded -= airStrength;
            float addLandStrength = blitzStrength + transStrength;
            if (ourXStrength < 1.0f && addLandStrength < 1.0f) continue;
            float additionalStrength = addLandStrength + airStrength;
            ourXStrength += additionalStrength;
            ArrayList<Unit> invasionUnits = ourCUnits;
            for (Collection invaders : xMoveUnits) {
                invasionUnits.addAll(invaders);
            }
            boolean weWin = SUtils.calculateTUVDifference(badCapitol, invasionUnits, badCapUnits, costMap, player, data, aggressive, Properties.getAirAttackSubRestricted(data), tFirst);
            if (weWin || alliedCapStrength > badCapStrength * 1.1f + 3.0f && ourXStrength > 0.82f * badCapStrength + 3.0f) {
                enemyOwned.remove(badCapitol);
                for (Territory aT2 : alliedCapTerr) {
                    List<Unit> ourCUnits2 = aT2.getUnits().getMatches(attackable);
                    ourCUnits2.removeAll(unitsAlreadyMoved);
                    moveUnits.add(ourCUnits2);
                    Route aR = data.getMap().getLandRoute(aT2, badCapitol);
                    moveRoutes.add(aR);
                    unitsAlreadyMoved.addAll(ourCUnits2);
                }
                moveUnits.addAll(xMoveUnits);
                moveRoutes.addAll(xMoveRoutes);
                unitsAlreadyMoved.addAll(xAlreadyMoved);
                alreadyAttacked.add(badCapitol);
            }
            weWin = false;
            xMoveUnits.clear();
            xMoveRoutes.clear();
            xAlreadyMoved.clear();
        }
        enemyOwned.removeAll(alreadyAttacked);
        enemyOwned.retainAll(rankMap.keySet());
        SUtils.reorder(enemyOwned, rankMap, true);
        block17: for (Territory enemy : enemyOwned) {
            xMoveUnits.clear();
            xMoveRoutes.clear();
            xAlreadyMoved.clear();
            xAlreadyMoved.addAll(unitsAlreadyMoved);
            float eStrength = SUtils.strength(enemy.getUnits().getUnits(), false, false, tFirst);
            if (!(eStrength < 0.5f)) continue;
            boolean taken = false;
            Set<Territory> nextTerrs = data.getMap().getNeighbors(enemy, enemyTerr);
            Iterator<Territory> nTIter = nextTerrs.iterator();
            while (nTIter.hasNext()) {
                Territory nTcheck = nTIter.next();
                if (!Matches.TerritoryIsImpassableToLandUnits(player, data).match(nTcheck)) continue;
                nTIter.remove();
            }
            HashMap<Territory, Float> canBeTaken = new HashMap<Territory, Float>();
            for (Territory nextOne : nextTerrs) {
                List<Territory> myGoodNeighbors = SUtils.getNeighboringLandTerritories(data, player, nextOne);
                if (myGoodNeighbors.size() > 0) continue;
                List<Unit> totUnits = nextOne.getUnits().getMatches(enemyLandAirUnit);
                float thisStrength = SUtils.strength(totUnits, false, false, tFirst);
                canBeTaken.put(nextOne, Float.valueOf(thisStrength));
            }
            Set blitzTerrs = canBeTaken.keySet();
            for (Territory attackFrom : data.getMap().getNeighbors(enemy, Matches.territoryHasLandUnitsOwnedBy(player))) {
                if (taken) continue block17;
                List<Unit> aBlitzUnits = attackFrom.getUnits().getMatches(blitzUnit);
                aBlitzUnits.removeAll(unitsAlreadyMoved);
                Territory findOne = null;
                if (canBeTaken.size() > 0) {
                    for (Territory attackTo : blitzTerrs) {
                        if (!(((Float)canBeTaken.get(attackTo)).floatValue() < 1.0f)) continue;
                        findOne = attackTo;
                    }
                }
                if (findOne != null && !aBlitzUnits.isEmpty()) {
                    for (Territory bT : blitzTerrs) {
                        if (!(((Float)canBeTaken.get(bT)).floatValue() < 4.0f)) continue;
                        Route newRoute = new Route();
                        newRoute.setStart(attackFrom);
                        newRoute.add(enemy);
                        newRoute.add(bT);
                        Unit deleteThisOne = null;
                        for (Unit tank : aBlitzUnits) {
                            if (deleteThisOne != null) continue;
                            moveUnits.add(Collections.singleton(tank));
                            moveRoutes.add(newRoute);
                            unitsAlreadyMoved.add(tank);
                            deleteThisOne = tank;
                            alreadyAttacked.add(enemy);
                            emptyBadTerr.remove(enemy);
                        }
                        aBlitzUnits.remove(deleteThisOne);
                    }
                    continue;
                }
                List<Unit> unitsSorted = SUtils.sortTransportUnits(attackFrom.getUnits().getMatches(attackable));
                unitsSorted.removeAll(unitsAlreadyMoved);
                Iterator<Unit> i$ = unitsSorted.iterator();
                if (!i$.hasNext()) continue;
                Unit unit = i$.next();
                moveRoutes.add(data.getMap().getRoute(attackFrom, enemy));
                if (attackFrom.isWater()) {
                    List<Unit> units2 = attackFrom.getUnits().getMatches(Matches.unitIsLandAndOwnedBy(player));
                    moveUnits.add(Util.difference(units2, unitsAlreadyMoved));
                    unitsAlreadyMoved.addAll(units2);
                } else {
                    moveUnits.add(Collections.singleton(unit));
                }
                unitsAlreadyMoved.add(unit);
                alreadyAttacked.add(enemy);
                emptyBadTerr.add(enemy);
                taken = true;
            }
        }
        ourStrength = 0.0f;
        float badStrength = 0.0f;
        bigProblem2.removeAll(alreadyAttacked);
        SUtils.reorder(bigProblem2, rankMap, true);
        xAlreadyMoved.clear();
        xMoveUnits.clear();
        xMoveRoutes.clear();
        for (Territory badTerr : bigProblem2) {
            xMoveUnits.clear();
            xMoveRoutes.clear();
            xAlreadyMoved.clear();
            Collection<Unit> enemyUnits = badTerr.getUnits().getUnits();
            badStrength = SUtils.strength(enemyUnits, false, false, tFirst);
            if (badStrength > 0.0f) {
                ourStrength = 0.0f;
                ArrayList<Territory> capitalAttackTerr = new ArrayList<Territory>(data.getMap().getNeighbors(badTerr, Matches.territoryHasLandUnitsOwnedBy(player)));
                ArrayList<Unit> capSaverUnits = new ArrayList<Unit>();
                for (Territory capSavers : capitalAttackTerr) {
                    capSaverUnits.addAll(capSavers.getUnits().getMatches(attackable));
                }
                capSaverUnits.removeAll(unitsAlreadyMoved);
                remainingStrengthNeeded = badStrength * attackFactor + 4.0f - (ourStrength += SUtils.strength(capSaverUnits, true, false, tFirst));
                xAlreadyMoved.addAll(capSaverUnits);
                xAlreadyMoved.addAll(unitsAlreadyMoved);
                float blitzStrength = SUtils.inviteBlitzAttack(false, badTerr, remainingStrengthNeeded, xAlreadyMoved, xMoveUnits, xMoveRoutes, data, player, true, false);
                float seaStrength = SUtils.inviteTransports(false, badTerr, remainingStrengthNeeded -= blitzStrength, xAlreadyMoved, xMoveUnits, xMoveRoutes, data, player, tFirst, false, seaTerrAttacked);
                float planeStrength = SUtils.invitePlaneAttack(false, false, badTerr, remainingStrengthNeeded -= seaStrength, xAlreadyMoved, xMoveUnits, xMoveRoutes, data, player);
                if ((ourStrength += blitzStrength + seaStrength) < 1.0f) continue;
                ourStrength += planeStrength;
                ArrayList<Unit> allMyUnits = new ArrayList<Unit>(capSaverUnits);
                for (Collection xUnits : xMoveUnits) {
                    allMyUnits.addAll(xUnits);
                }
                boolean weWin = SUtils.calculateTUVDifference(badTerr, allMyUnits, enemyUnits, costMap, player, data, aggressive, Properties.getAirAttackSubRestricted(data), tFirst);
                if (weWin) {
                    if (bigProblem2.size() > 1) {
                        maxAttackFactor = 1.54f;
                    }
                    remainingStrengthNeeded = maxAttackFactor * badStrength + 3.0f;
                    float landStrength = SUtils.inviteLandAttack(false, badTerr, remainingStrengthNeeded, unitsAlreadyMoved, moveUnits, moveRoutes, data, player, true, false, alreadyAttacked);
                    blitzStrength = SUtils.inviteBlitzAttack(false, badTerr, remainingStrengthNeeded -= landStrength, unitsAlreadyMoved, moveUnits, moveRoutes, data, player, true, false);
                    planeStrength = SUtils.invitePlaneAttack(false, false, badTerr, remainingStrengthNeeded -= blitzStrength, unitsAlreadyMoved, moveUnits, moveRoutes, data, player);
                    seaStrength = SUtils.inviteTransports(false, badTerr, remainingStrengthNeeded -= planeStrength, unitsAlreadyMoved, moveUnits, moveRoutes, data, player, tFirst, false, seaTerrAttacked);
                    remainingStrengthNeeded -= seaStrength;
                }
                weWin = false;
            }
            xMoveUnits.clear();
            xMoveRoutes.clear();
            xAlreadyMoved.clear();
        }
        float maxEStrength = enemyMap.get(maxAttackTerr).floatValue();
        PlayerID maxAPlayer = maxAttackTerr.getOwner();
        float myAttackStrength = SUtils.getStrengthOfPotentialAttackers(maxAttackTerr, data, maxAPlayer, tFirst, false, null);
        Route enemyRoute = SUtils.findNearest(maxAttackTerr, Matches.territoryIsAlliedAndHasAlliedUnitMatching(data, player, Matches.UnitCanProduceUnits), Matches.TerritoryIsNotImpassableToLandUnits(player, data), data);
        if (enemyRoute == null || myAttackStrength > maxEStrength) {
            // empty if block
        }
        float alliedStrength = 0.0f;
        SUtils.reorder(enemyOwned, rankMap, true);
        enemyOwned.removeAll(alreadyAttacked);
        for (Territory enemy : enemyOwned) {
            xMoveUnits.clear();
            xMoveRoutes.clear();
            xAlreadyMoved.clear();
            Collection<Unit> eUnits = enemy.getUnits().getUnits();
            float enemyStrength = SUtils.strength(eUnits, false, false, tFirst);
            float pValue = TerritoryAttachment.getProduction(enemy);
            if (Matches.TerritoryIsNeutralButNotWater.match(enemy) && enemyStrength > pValue * 9.0f && Math.random() < 0.9) continue;
            if (enemyStrength > 0.0f) {
                List<Territory> enemyLandTerr;
                ourStrength = 0.0f;
                alliedStrength = 0.0f;
                Set<Territory> attackFrom = data.getMap().getNeighbors(enemy, Matches.territoryHasNoEnemyUnits(player, data));
                attackFrom.removeAll(impassableTerrs);
                HashMap<Territory, Float> strengthMap = new HashMap<Territory, Float>();
                alreadyAttacked.add(enemy);
                for (Territory aCheck : attackFrom) {
                    strengthMap.put(aCheck, Float.valueOf(SUtils.getStrengthOfPotentialAttackers(aCheck, data, player, tFirst, true, alreadyAttacked)));
                }
                ArrayList<Unit> dontMoveWithUnits = new ArrayList<Unit>();
                ArrayList<Territory> attackList = new ArrayList<Territory>(attackFrom);
                SUtils.reorder(attackList, strengthMap, false);
                ArrayList<Unit> myAUnits = new ArrayList<Unit>();
                for (Territory checkTerr2 : attackList) {
                    float strengthLimit = 0.0f;
                    if (Matches.territoryIsAlliedAndHasAlliedUnitMatching(data, player, Matches.UnitCanProduceUnits).match(checkTerr2)) {
                        strengthLimit = ((Float)strengthMap.get(checkTerr2)).floatValue();
                        List<Unit> ourFactUnits = checkTerr2.getUnits().getMatches(Matches.UnitIsNotSea);
                        ourFactUnits.removeAll(unitsAlreadyMoved);
                        float factStrength = SUtils.strength(ourFactUnits, false, false, tFirst);
                        if (strengthLimit * 0.5f > factStrength + (float)TerritoryAttachment.getProduction(checkTerr2) * 3.0f) {
                            strengthLimit = 0.0f;
                        }
                    }
                    List<Unit> goodUnits = checkTerr2.getUnits().getMatches(attackable);
                    goodUnits.removeAll(unitsAlreadyMoved);
                    Iterator<Unit> goodUIter = goodUnits.iterator();
                    Route gRoute = data.getMap().getLandRoute(checkTerr2, enemy);
                    if (gRoute == null || goodUnits.isEmpty()) continue;
                    while (goodUIter.hasNext()) {
                        Unit goodUnit = goodUIter.next();
                        if (MoveValidator.hasEnoughMovement(goodUnit, gRoute) && !(strengthLimit > 0.0f)) continue;
                        goodUIter.remove();
                        dontMoveWithUnits.add(goodUnit);
                        strengthLimit -= SUtils.uStrength(goodUnit, false, false, tFirst);
                    }
                    ourStrength += SUtils.strength(goodUnits, true, false, tFirst);
                    List<Unit> aUnits = checkTerr2.getUnits().getMatches(alliedAirLandUnitNotOwned);
                    aUnits.removeAll(goodUnits);
                    aUnits.removeAll(unitsAlreadyMoved);
                    alliedStrength += SUtils.strength(aUnits, true, false, tFirst);
                    myAUnits.addAll(goodUnits);
                }
                float xRS = 1000.0f;
                xAlreadyMoved.addAll(unitsAlreadyMoved);
                xAlreadyMoved.addAll(myAUnits);
                float blitzStrength = SUtils.inviteBlitzAttack(false, enemy, xRS, xAlreadyMoved, xMoveUnits, xMoveRoutes, data, player, true, false);
                float planeStrength = SUtils.invitePlaneAttack(false, false, enemy, xRS -= blitzStrength, xAlreadyMoved, xMoveUnits, xMoveRoutes, data, player);
                xRS -= planeStrength;
                if ((ourStrength += blitzStrength) < 1.0f) continue;
                ourStrength += planeStrength;
                ArrayList<Unit> allMyUnits = new ArrayList<Unit>(myAUnits);
                for (Collection xUnits : xMoveUnits) {
                    allMyUnits.addAll(xUnits);
                }
                boolean weWin = false;
                if (Matches.TerritoryIsNeutralButNotWater.match(enemy)) {
                    if (ourStrength > 1.11f * enemyStrength + 3.0f) {
                        weWin = true;
                    }
                } else {
                    weWin = SUtils.calculateTUVDifference(enemy, allMyUnits, eUnits, costMap, player, data, aggressive, Properties.getAirAttackSubRestricted(data), tFirst);
                }
                if (!weWin) {
                    alreadyAttacked.remove(enemy);
                    continue;
                }
                weWin = false;
                remainingStrengthNeeded = attackFactor * enemyStrength + 4.0f;
                if (attackFrom.size() == 1 && (enemyLandTerr = SUtils.getNeighboringEnemyLandTerritories(data, player, xTerr = (Territory)attackList.get(0))).size() == 1) {
                    remainingStrengthNeeded = maxAttackFactor * enemyStrength + 4.0f;
                }
                float landStrength2 = SUtils.inviteLandAttack(false, enemy, remainingStrengthNeeded, unitsAlreadyMoved, moveUnits, moveRoutes, data, player, true, false, alreadyAttacked);
                float blitzStrength2 = SUtils.inviteBlitzAttack(false, enemy, remainingStrengthNeeded -= landStrength2, unitsAlreadyMoved, moveUnits, moveRoutes, data, player, true, false);
                float planeStrength2 = SUtils.invitePlaneAttack(false, false, enemy, remainingStrengthNeeded -= blitzStrength2, unitsAlreadyMoved, moveUnits, moveRoutes, data, player);
                float seaStrength2 = SUtils.inviteTransports(false, enemy, remainingStrengthNeeded -= planeStrength2, unitsAlreadyMoved, moveUnits, moveRoutes, data, player, tFirst, false, seaTerrAttacked);
                remainingStrengthNeeded -= seaStrength2;
            }
            xMoveUnits.clear();
            xMoveRoutes.clear();
            xAlreadyMoved.clear();
        }
        this.populateBomberCombat(data, unitsAlreadyMoved, moveUnits, moveRoutes, player);
    }

    private void populateFinalTransportUnload(GameData data, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, PlayerID player) {
        this.setImpassableTerrs(player);
        boolean tFirst = this.transportsMayDieFirst();
        CompositeMatchAnd<Unit> myTransport = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsTransport);
        CompositeMatchAnd<Unit> transports = new CompositeMatchAnd<Unit>(Matches.transportIsTransporting(), myTransport);
        List<Territory> transTerr = SUtils.findTersWithUnitsMatching(data, player, transports);
        if (transTerr.isEmpty()) {
            return;
        }
        ArrayList<Territory> ourFriendlyTerr = new ArrayList<Territory>();
        ArrayList<Territory> ourEnemyTerr = new ArrayList<Territory>();
        HashMap<Territory, Float> rankMap = SUtils.rankTerritories(data, ourFriendlyTerr, ourEnemyTerr, null, player, tFirst, true, true);
        for (Territory t : transTerr) {
            List<Territory> unloadTerr;
            List<Unit> myTransports = t.getUnits().getMatches(myTransport);
            ArrayList<Unit> loadedUnits = new ArrayList<Unit>();
            Iterator<Unit> tIter = myTransports.iterator();
            while (tIter.hasNext()) {
                Unit transport = tIter.next();
                if (!TransportTracker.isTransporting(transport)) {
                    tIter.remove();
                    continue;
                }
                loadedUnits.addAll(TransportTracker.transporting(transport));
            }
            if (myTransports.isEmpty() || loadedUnits.isEmpty() || (unloadTerr = SUtils.getNeighboringLandTerritories(data, player, t)).isEmpty()) continue;
            SUtils.reorder(unloadTerr, rankMap, true);
            Territory landOn = unloadTerr.get(0);
            Route landRoute = data.getMap().getRoute(t, landOn);
            if (landRoute == null) continue;
            moveUnits.add(loadedUnits);
            moveRoutes.add(landRoute);
        }
    }

    private void populateFinalMoveToCoast(final GameData data, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, final PlayerID player) {
        Match<Territory> territoryIsOwnedByXOrAllyAndIsPort = new Match<Territory>(){

            @Override
            public boolean match(Territory ter) {
                if (!data.getRelationshipTracker().isAllied(player, ter.getOwner())) {
                    return false;
                }
                return !data.getMap().getNeighbors(ter, Matches.TerritoryIsWater).isEmpty();
            }
        };
        for (Territory ter : data.getMap().getTerritoriesOwnedBy(player)) {
            List<Unit> landThreats;
            List<Unit> unmovedUnits;
            if (ter.isWater() || data.getMap().getNeighbors(ter, Matches.TerritoryIsWater).size() > 0 || SUtils.findNearest(ter, new CompositeMatchAnd<Territory>(Matches.isTerritoryEnemyAndNotUnownedWaterOrImpassibleOrRestricted(player, data), Matches.TerritoryIsLand), Matches.TerritoryIsNotImpassableToLandUnits(player, data), data) != null || (unmovedUnits = ter.getUnits().getMatches(new CompositeMatchAnd<Unit>(Matches.unitHasMovementLeft, Matches.UnitIsNotAA, Matches.UnitCanBeTransported, Matches.unitIsOwnedBy(player)))).isEmpty() || (landThreats = SUtils.findAttackers(ter, 25, new HashSet<Integer>(), player, data, new CompositeMatchAnd<Unit>(Matches.UnitIsLand, Matches.unitIsEnemyOf(data, player)), Match.ALWAYS_MATCH, new ArrayList<Territory>(), new ArrayList<Route>(), false)).size() > 0) continue;
            DefaultNamed closestPortTer = null;
            int closestDistance = Integer.MAX_VALUE;
            for (Territory portTer : data.getMap().getTerritories()) {
                int distance;
                Route passableLandRoute;
                if (portTer.isWater() || !territoryIsOwnedByXOrAllyAndIsPort.match(portTer) || (passableLandRoute = data.getMap().getRoute(ter, portTer, new CompositeMatchAnd<Territory>(Matches.TerritoryIsLand, Matches.TerritoryIsNotImpassable))) == null || (distance = passableLandRoute.getLength()) >= closestDistance) continue;
                closestPortTer = portTer;
                closestDistance = distance;
            }
            if (closestPortTer == null || closestPortTer.equals(ter)) continue;
            int slowestUnitMovement = AdvancedUtils.getSlowestMovementUnitInList(unmovedUnits);
            Route passableLandRoute = data.getMap().getRoute(ter, (Territory)closestPortTer, new CompositeMatchAnd<Territory>(Matches.TerritoryIsLand, Matches.TerritoryIsNotImpassable));
            if (passableLandRoute != null) {
                passableLandRoute = AdvancedUtils.trimRouteBeforeFirstTerWithEnemyUnits(passableLandRoute, slowestUnitMovement, player, data);
            }
            if (passableLandRoute == null) continue;
            moveUnits.add(unmovedUnits);
            moveRoutes.add(passableLandRoute);
        }
    }

    private void populateMoveUnusedTransportsToFillLocation(GameData data, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, PlayerID player) {
        Territory ourCap = TerritoryAttachment.getFirstOwnedCapitalOrFirstUnownedCapital(player, data);
        if (!this.isAmphibAttack(player, false) || !Matches.territoryHasWaterNeighbor(data).match(ourCap)) {
            return;
        }
        CompositeMatchAnd<Unit> unusedTransportMatch = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsTransport, Matches.transportIsNotTransporting(), Matches.unitHasMovementLeft, Matches.unitHasNotMoved);
        for (Territory ter : data.getMap().getTerritoriesOwnedBy(player)) {
            if (ter.isWater() || data.getMap().getNeighbors(ter, Matches.TerritoryIsWater).isEmpty() || SUtils.findNearest(ter, new CompositeMatchAnd<Territory>(Matches.isTerritoryEnemyAndNotUnownedWaterOrImpassibleOrRestricted(player, data), Matches.TerritoryIsLand), Matches.TerritoryIsNotImpassableToLandUnits(player, data), data) != null) continue;
            int transportSpaceNeededForTerUnits = 0;
            for (Unit unit : ter.getUnits().getMatches(new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsLand, Matches.UnitCanBeTransported, Matches.UnitIsNotAA))) {
                int transportCost = UnitAttachment.get(unit.getUnitType()).getTransportCost();
                if (transportCost <= 0) continue;
                transportSpaceNeededForTerUnits += transportCost;
            }
            int transportSpaceLeftNearby = 0;
            for (Territory seaTer : AdvancedUtils.getTerritoriesWithinXDistanceOfYMatchingZ(data, ter, 3, Matches.TerritoryIsWater)) {
                for (Unit transport : seaTer.getUnits().getMatches(unusedTransportMatch)) {
                    transportSpaceLeftNearby += UnitAttachment.get(transport.getUnitType()).getTransportCapacity();
                }
            }
            if (transportSpaceLeftNearby >= transportSpaceNeededForTerUnits) continue;
            boolean foundAnyUnusedTransports = false;
            for (Territory seaTer : data.getMap().getTerritories()) {
                if (!seaTer.isWater()) continue;
                ArrayList<Unit> unitsToMoveToTer = new ArrayList<Unit>();
                for (Unit unusedTransport : seaTer.getUnits().getMatches(unusedTransportMatch)) {
                    if (transportSpaceNeededForTerUnits <= transportSpaceLeftNearby) break;
                    unitsToMoveToTer.add(unusedTransport);
                    transportSpaceLeftNearby += UnitAttachment.get(unusedTransport.getUnitType()).getTransportCapacity();
                }
                if (unitsToMoveToTer.isEmpty()) continue;
                int slowestUnitMovement = AdvancedUtils.getSlowestMovementUnitInList(unitsToMoveToTer);
                HashMap<Match<Territory>, Integer> matches = new HashMap<Match<Territory>, Integer>();
                matches.put(new CompositeMatchAnd(Matches.TerritoryIsWater, Matches.territoryHasAlliedUnits(player, data)), 2);
                matches.put(new CompositeMatchAnd(Matches.TerritoryIsWater, Matches.territoryHasNoEnemyUnits(player, data)), 3);
                matches.put(Matches.TerritoryIsWater, 6);
                Route seaRoute = data.getMap().getCompositeRoute(seaTer, data.getMap().getNeighbors(ter, Matches.TerritoryIsWater).iterator().next(), matches);
                if (seaRoute != null) {
                    seaRoute = AdvancedUtils.trimRouteBeforeFirstTerWithEnemyUnits(seaRoute, slowestUnitMovement, player, data);
                }
                if (seaRoute == null) continue;
                foundAnyUnusedTransports = true;
                moveUnits.add(unitsToMoveToTer);
                moveRoutes.add(seaRoute);
            }
            if (foundAnyUnusedTransports) continue;
            break;
        }
        for (Territory seaTer : data.getMap().getTerritories()) {
            if (!seaTer.isWater()) continue;
            ArrayList<Unit> unitsToMoveToTer = new ArrayList<Unit>();
            for (Unit unusedTransport : seaTer.getUnits().getMatches(unusedTransportMatch)) {
                unitsToMoveToTer.add(unusedTransport);
            }
            if (unitsToMoveToTer.isEmpty()) continue;
            int slowestUnitMovement = AdvancedUtils.getSlowestMovementUnitInList(unitsToMoveToTer);
            HashMap<Match<Territory>, Integer> matches = new HashMap<Match<Territory>, Integer>();
            matches.put(new CompositeMatchAnd(Matches.TerritoryIsWater, Matches.territoryHasAlliedUnits(player, data)), 2);
            matches.put(new CompositeMatchAnd(Matches.TerritoryIsWater, Matches.territoryHasNoEnemyUnits(player, data)), 3);
            matches.put(Matches.TerritoryIsWater, 6);
            Route seaRoute = data.getMap().getCompositeRoute(seaTer, data.getMap().getNeighbors(ourCap, Matches.TerritoryIsWater).iterator().next(), matches);
            if (seaRoute != null) {
                seaRoute = AdvancedUtils.trimRouteBeforeFirstTerWithEnemyUnits(seaRoute, slowestUnitMovement, player, data);
            }
            if (seaRoute == null) continue;
            moveUnits.add(unitsToMoveToTer);
            moveRoutes.add(seaRoute);
        }
    }

    private void populateBomberCombat(GameData data, Collection<Unit> unitsAlreadyMoved, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, PlayerID player) {
        CompositeMatchAnd<Unit> ownBomber = new CompositeMatchAnd<Unit>(Matches.UnitIsStrategicBomber, Matches.unitIsOwnedBy(player), Matches.unitHasNotMoved);
        CompositeMatchAnd routeCond = new CompositeMatchAnd(Matches.TerritoryIsNotImpassable, Matches.territoryHasEnemyAAforCombatOnly(player, data).invert());
        ArrayList<Unit> alreadyMoved = new ArrayList<Unit>();
        IntegerMap<Territory> bomberImpactMap = new IntegerMap<Territory>();
        ArrayList<Territory> enemyFactories = new ArrayList<Territory>();
        boolean unitProduction = Properties.getDamageFromBombingDoneToUnitsInsteadOfTerritories(data);
        for (Territory xT : data.getMap().getTerritories()) {
            if (!Matches.territoryIsEnemyNonNeutralAndHasEnemyUnitMatching(data, player, Matches.UnitCanProduceUnitsAndCanBeDamaged).match(xT)) continue;
            enemyFactories.add(xT);
        }
        int factProduction = 0;
        for (Territory eFact : enemyFactories) {
            factProduction = unitProduction ? TripleAUnit.getProductionPotentialOfTerritory(eFact.getUnits().getUnits(), eFact, eFact.getOwner(), data, true, true) : TerritoryAttachment.getProduction(eFact);
            bomberImpactMap.put(eFact, factProduction);
        }
        SUtils.reorder(enemyFactories, bomberImpactMap, true);
        List<Territory> bomberTerrs = SUtils.findTersWithUnitsMatching(data, player, Matches.UnitIsStrategicBomber);
        for (Territory t : enemyFactories) {
            int bombable = bomberImpactMap.getInt(t);
            int bombersDeployed = 0;
            for (Territory bombTerr : bomberTerrs) {
                List<Unit> bombers = t.getUnits().getMatches(ownBomber);
                bombers.removeAll(alreadyMoved);
                if (bombers.isEmpty()) continue;
                CompositeMatchOr<Territory> routeCondOrEnd = new CompositeMatchOr<Territory>(routeCond, Matches.territoryIs(t));
                Route bombRoute = data.getMap().getRoute(t, bombTerr, routeCondOrEnd);
                if (bombRoute == null || bombRoute.getEnd() == null || bombable <= 0) continue;
                Iterator bIter = bombers.iterator();
                while (bIter.hasNext() && bombable > 0) {
                    Unit bomber = (Unit)bIter.next();
                    if (bomber == null || !AirMovementValidator.canLand(Collections.singleton(bomber), bombTerr, player, data)) continue;
                    moveUnits.add(Collections.singleton(bomber));
                    moveRoutes.add(bombRoute);
                    alreadyMoved.add(bomber);
                    UnitAttachment bA = UnitAttachment.get(bomber.getUnitType());
                    if (++bombersDeployed % 6 == 0) continue;
                    bombable -= bA.getAttackRolls(player) * 3;
                }
            }
        }
    }

    private int countTransports(GameData data, PlayerID player) {
        CompositeMatchAnd<Unit> ownedTransport = new CompositeMatchAnd<Unit>(Matches.UnitIsTransport, Matches.unitIsOwnedBy(player));
        int sum = 0;
        for (Territory t : data.getMap()) {
            sum += t.getUnits().countMatches(ownedTransport);
        }
        return sum;
    }

    private int countLandUnits(GameData data, PlayerID player) {
        CompositeMatchAnd<Unit> ownedLandUnit = new CompositeMatchAnd<Unit>(Matches.UnitIsLand, Matches.unitIsOwnedBy(player));
        int sum = 0;
        for (Territory t : data.getMap()) {
            sum += t.getUnits().countMatches(ownedLandUnit);
        }
        return sum;
    }

    private int countSeaUnits(GameData data, PlayerID player) {
        CompositeMatchAnd<Unit> ownedSeaUnit = new CompositeMatchAnd<Unit>(Matches.UnitIsSea, Matches.unitIsOwnedBy(player), Matches.UnitIsNotTransport);
        int sum = 0;
        for (Territory t : data.getMap()) {
            sum += t.getUnits().countMatches(ownedSeaUnit);
        }
        return sum;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void purchase(boolean purchaseForBid, int PUsToSpend, IPurchaseDelegate purchaseDelegate, GameData data, PlayerID player) {
        void var96_167;
        void var96_166;
        void var96_165;
        void var96_164;
        void var96_163;
        void var96_159;
        void var96_158;
        int n;
        int n2;
        boolean noCapitalThreat;
        void var96_150;
        int n3;
        Territory myCapWaterTerr;
        Territory closestEnemyCapitol;
        UnitType x;
        NamedAttachable resourceOrUnit;
        long last = System.currentTimeMillis();
        s_logger.fine("Doing Purchase ");
        if (PUsToSpend == 0 && player.getResources().getQuantity(data.getResourceList().getResource("PUs")) == 0) {
            return;
        }
        int currentRound = data.getSequence().getRound();
        int highPrice = 0;
        List<ProductionRule> rules = player.getProductionFrontier().getRules();
        IntegerMap<ProductionRule> purchase = new IntegerMap<ProductionRule>();
        ArrayList<ProductionRule> landProductionRules = new ArrayList<ProductionRule>();
        ArrayList<ProductionRule> airProductionRules = new ArrayList<ProductionRule>();
        ArrayList<ProductionRule> seaProductionRules = new ArrayList<ProductionRule>();
        ArrayList<ProductionRule> transportProductionRules = new ArrayList<ProductionRule>();
        ArrayList<ProductionRule> subProductionRules = new ArrayList<ProductionRule>();
        IntegerMap<ProductionRule> bestAttack = new IntegerMap<ProductionRule>();
        IntegerMap<ProductionRule> bestDefense = new IntegerMap<ProductionRule>();
        IntegerMap<ProductionRule> bestTransport = new IntegerMap<ProductionRule>();
        IntegerMap<ProductionRule> bestMaxUnits = new IntegerMap<ProductionRule>();
        IntegerMap<ProductionRule> bestMobileAttack = new IntegerMap<ProductionRule>();
        ProductionRule carrierRule = null;
        ProductionRule fighterRule = null;
        int carrierFighterLimit = 0;
        int maxFighterAttack = 0;
        float averageSeaMove = 0.0f;
        Resource pus = data.getResourceList().getResource("PUs");
        boolean isAmphib = this.isAmphibAttack(player, true);
        this.setDidPurchaseTransports(false);
        for (ProductionRule ruleCheck : rules) {
            int thisFighterAttack;
            int thisFighterLimit;
            int costCheck = ruleCheck.getCosts().getInt(pus);
            resourceOrUnit = ruleCheck.getResults().keySet().iterator().next();
            if (!(resourceOrUnit instanceof UnitType) || UnitAttachment.get(x = (UnitType)resourceOrUnit).getMovement(player) < 1 && !UnitAttachment.get(x).getCanProduceUnits() || !(UnitAttachment.get(x).getAttack(player) - UnitAttachment.get(x).getDefense(player) < 3 && UnitAttachment.get(x).getDefense(player) - UnitAttachment.get(x).getAttack(player) < 3 && UnitAttachment.get(x).getDefense(player) >= 1 || UnitAttachment.get(x).getCanProduceUnits() || UnitAttachment.get(x).getTransportCapacity() > 0 && Matches.UnitTypeIsSea.match(x)) && (Matches.UnitTypeIsAir.match(x) && !airProductionRules.isEmpty() || Matches.UnitTypeIsSea.match(x) && !seaProductionRules.isEmpty() || !Matches.UnitTypeCanProduceUnits.match(x) && !landProductionRules.isEmpty() && !Matches.UnitTypeIsAir.match(x) && !Matches.UnitTypeIsSea.match(x)) || Matches.UnitTypeHasMaxBuildRestrictions.match(x) || Matches.UnitTypeConsumesUnitsOnCreation.match(x)) continue;
            if (Matches.UnitTypeIsAir.match(x)) {
                airProductionRules.add(ruleCheck);
            } else if (Matches.UnitTypeIsSea.match(x)) {
                seaProductionRules.add(ruleCheck);
                averageSeaMove += (float)UnitAttachment.get(x).getMovement(player);
            } else if (!Matches.UnitTypeCanProduceUnits.match(x)) {
                if (costCheck > highPrice) {
                    highPrice = costCheck;
                }
                landProductionRules.add(ruleCheck);
            }
            if (Matches.UnitTypeCanTransport.match(x) && Matches.UnitTypeIsSea.match(x) && UnitAttachment.get(x).getTransportCapacity() > 1) {
                transportProductionRules.add(ruleCheck);
            }
            if (Matches.UnitTypeIsSub.match(x)) {
                subProductionRules.add(ruleCheck);
            }
            if (Matches.UnitTypeIsCarrier.match(x) && (thisFighterLimit = UnitAttachment.get(x).getCarrierCapacity()) >= carrierFighterLimit) {
                carrierRule = ruleCheck;
                carrierFighterLimit = thisFighterLimit;
            }
            if (!Matches.UnitTypeCanLandOnCarrier.match(x) || (thisFighterAttack = UnitAttachment.get(x).getAttack(player)) <= maxFighterAttack) continue;
            fighterRule = ruleCheck;
            maxFighterAttack = thisFighterAttack;
        }
        if ((double)(averageSeaMove / (float)seaProductionRules.size()) >= 1.8) {
            ArrayList seaProductionRulesCopy = new ArrayList(seaProductionRules);
            for (ProductionRule seaRule : seaProductionRulesCopy) {
                resourceOrUnit = seaRule.getResults().keySet().iterator().next();
                if (!(resourceOrUnit instanceof UnitType) || UnitAttachment.get(x = (UnitType)resourceOrUnit).getMovement(player) >= 2) continue;
                seaProductionRules.remove(seaRule);
            }
        }
        if (subProductionRules.size() > 0 && seaProductionRules.size() > 0 && (double)(subProductionRules.size() / seaProductionRules.size()) < 0.3) {
            seaProductionRules.removeAll(subProductionRules);
        }
        if (purchaseForBid) {
            int cost;
            boolean buyAttack;
            int buyLimit = PUsToSpend / 3;
            if (buyLimit == 0) {
                buyLimit = 1;
            }
            boolean landPurchase = true;
            boolean goTransports = false;
            List<Territory> enemyTerritoryBorderingOurTerrs = SUtils.getNeighboringEnemyLandTerritories(data, player);
            if (enemyTerritoryBorderingOurTerrs.isEmpty()) {
                landPurchase = false;
            }
            if (Math.random() > 0.25) {
                seaProductionRules.removeAll(subProductionRules);
            }
            if (PUsToSpend < 25) {
                if ((!isAmphib || Math.random() < 0.15) && landPurchase) {
                    SUtils.findPurchaseMix(bestAttack, bestDefense, bestTransport, bestMaxUnits, bestMobileAttack, landProductionRules, PUsToSpend, buyLimit, data, player, 2);
                } else {
                    landPurchase = false;
                    buyLimit = PUsToSpend / 5;
                    if (Math.random() > 0.4) {
                        SUtils.findPurchaseMix(bestAttack, bestDefense, bestTransport, bestMaxUnits, bestMobileAttack, seaProductionRules, PUsToSpend, buyLimit, data, player, 2);
                    } else {
                        goTransports = true;
                    }
                }
            } else if ((!isAmphib || Math.random() < 0.15) && landPurchase) {
                if (Math.random() > 0.8) {
                    SUtils.findPurchaseMix(bestAttack, bestDefense, bestTransport, bestMaxUnits, bestMobileAttack, landProductionRules, PUsToSpend, buyLimit, data, player, 2);
                }
            } else if (Math.random() < 0.35) {
                int fighterCost;
                int cost2;
                if (Math.random() > 0.55 && carrierRule != null && fighterRule != null && (cost2 = carrierRule.getCosts().getInt(pus)) + (fighterCost = fighterRule.getCosts().getInt(pus)) <= PUsToSpend) {
                    purchase.add(carrierRule, 1);
                    purchase.add(fighterRule, 1);
                    --carrierFighterLimit;
                    PUsToSpend -= cost2 + fighterCost;
                    while (PUsToSpend >= fighterCost && carrierFighterLimit > 0) {
                        purchase.add(fighterRule, 1);
                        --carrierFighterLimit;
                        PUsToSpend -= fighterCost;
                    }
                }
                int airPUs = PUsToSpend / 6;
                SUtils.findPurchaseMix(bestAttack, bestDefense, bestTransport, bestMaxUnits, bestMobileAttack, airProductionRules, airPUs, buyLimit, data, player, 2);
                buyAttack = Math.random() > 0.5;
                for (ProductionRule rule1 : airProductionRules) {
                    int buyThese = bestAttack.getInt(rule1);
                    int cost3 = rule1.getCosts().getInt(pus);
                    if (!buyAttack) {
                        buyThese = bestDefense.getInt(rule1);
                    }
                    PUsToSpend -= cost3 * buyThese;
                    while (PUsToSpend < 0 && buyThese > 0) {
                        --buyThese;
                        PUsToSpend += cost3;
                    }
                    if (buyThese <= 0) continue;
                    purchase.add(rule1, buyThese);
                }
                int landPUs = PUsToSpend;
                buyLimit = landPUs / 3;
                bestAttack.clear();
                bestDefense.clear();
                bestMaxUnits.clear();
                bestMobileAttack.clear();
                SUtils.findPurchaseMix(bestAttack, bestDefense, bestTransport, bestMaxUnits, bestMobileAttack, landProductionRules, landPUs, buyLimit, data, player, 2);
            } else {
                landPurchase = false;
                buyLimit = PUsToSpend / 8;
                seaProductionRules.addAll(airProductionRules);
                if (Math.random() > 0.45) {
                    SUtils.findPurchaseMix(bestAttack, bestDefense, bestTransport, bestMaxUnits, bestMobileAttack, seaProductionRules, PUsToSpend, buyLimit, data, player, 2);
                } else {
                    goTransports = true;
                }
            }
            ArrayList<ProductionRule> processRules = new ArrayList<ProductionRule>();
            if (landPurchase) {
                processRules.addAll(landProductionRules);
            } else if (goTransports) {
                processRules.addAll(transportProductionRules);
            } else {
                processRules.addAll(seaProductionRules);
            }
            buyAttack = Math.random() > 0.25;
            int buyThese = 0;
            int numBought = 0;
            for (ProductionRule rule1 : processRules) {
                cost = rule1.getCosts().getInt(pus);
                buyThese = goTransports ? PUsToSpend / cost : (buyAttack ? bestAttack.getInt(rule1) : (Math.random() <= 0.25 ? bestDefense.getInt(rule1) : bestMaxUnits.getInt(rule1)));
                PUsToSpend -= cost * buyThese;
                while (buyThese > 0 && PUsToSpend < 0) {
                    --buyThese;
                    PUsToSpend += cost;
                }
                if (buyThese <= 0) continue;
                numBought += buyThese;
                purchase.add(rule1, buyThese);
            }
            bestAttack.clear();
            bestDefense.clear();
            bestTransport.clear();
            bestMaxUnits.clear();
            bestMobileAttack.clear();
            if (PUsToSpend > 0) {
                buyLimit = PUsToSpend / 2;
                SUtils.findPurchaseMix(bestAttack, bestDefense, bestTransport, bestMaxUnits, bestMobileAttack, landProductionRules, PUsToSpend, buyLimit, data, player, 2);
                for (ProductionRule rule2 : landProductionRules) {
                    cost = rule2.getCosts().getInt(pus);
                    PUsToSpend -= cost * buyThese;
                    for (buyThese = bestDefense.getInt(rule2); buyThese > 0 && PUsToSpend < 0; --buyThese, PUsToSpend += cost) {
                    }
                    if (buyThese <= 0) continue;
                    purchase.add(rule2, buyThese);
                }
            }
            purchaseDelegate.purchase(purchase);
            return;
        }
        this.pause();
        boolean tFirst = this.transportsMayDieFirst();
        boolean shipCapitalThreat = false;
        isAmphib = this.isAmphibAttack(player, false);
        CompositeMatchAnd enemyUnit = new CompositeMatchAnd(Matches.enemyUnit(player, data));
        CompositeMatchAnd attackShip = new CompositeMatchAnd(Matches.UnitIsNotTransport, Matches.UnitIsSea);
        CompositeMatchAnd<Unit> enemyAttackShip = new CompositeMatchAnd<Unit>(enemyUnit, attackShip);
        CompositeMatchAnd<Unit> enemyFighter = new CompositeMatchAnd<Unit>(enemyUnit, Matches.UnitCanLandOnCarrier);
        CompositeMatchAnd<Unit> ourAttackShip = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), attackShip);
        CompositeMatchAnd<Unit> alliedAttackShip = new CompositeMatchAnd<Unit>(Matches.alliedUnit(player, data), attackShip);
        CompositeMatchAnd<Unit> enemyTransport = new CompositeMatchAnd<Unit>(enemyUnit, Matches.UnitIsTransport);
        CompositeMatchAnd<Unit> ourFactories = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitCanProduceUnits);
        CompositeMatchAnd<Unit> transUnit = new CompositeMatchAnd<Unit>(Matches.UnitIsTransport, Matches.unitIsOwnedBy(player));
        CompositeMatchAnd<Unit> fighter = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitCanLandOnCarrier);
        CompositeMatchAnd<Unit> alliedFighter = new CompositeMatchAnd<Unit>(Matches.alliedUnit(player, data), Matches.UnitCanLandOnCarrier);
        CompositeMatchAnd<Unit> transportableUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitCanBeTransported, Matches.UnitCanNotProduceUnits, Matches.UnitIsNotInfrastructure);
        CompositeMatchAnd<Unit> ACUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsCarrier);
        CompositeMatchAnd<Territory> enemyAndNoWater = new CompositeMatchAnd<Territory>(Matches.isTerritoryEnemyAndNotUnownedWaterOrImpassibleOrRestricted(player, data), Matches.TerritoryIsNotImpassableToLandUnits(player, data));
        CompositeMatchAnd<Territory> noEnemyOrWater = new CompositeMatchAnd<Territory>(Matches.isTerritoryAllied(player, data), Matches.TerritoryIsNotImpassableToLandUnits(player, data));
        CompositeMatchAnd<Territory> enemyOnWater = new CompositeMatchAnd<Territory>(Matches.TerritoryIsWater, Matches.territoryHasEnemyUnits(player, data));
        Territory myCapital = TerritoryAttachment.getFirstOwnedCapitalOrFirstUnownedCapital(player, data);
        boolean factPurchased = false;
        boolean isLand = SUtils.doesLandExistAt(myCapital, data, false);
        boolean skipShips = false;
        boolean buyTransports = true;
        boolean buyPlanesOnly = false;
        boolean buyOnePlane = false;
        boolean buyBattleShip = false;
        boolean buyOneShip = false;
        boolean buyCarrier = false;
        RulesAttachment ra = (RulesAttachment)player.getAttachment("rulesAttatchment");
        List<Object> factories = new ArrayList();
        factories = ra != null && ra.getPlacementAnyTerritory() ? SUtils.allOurTerritories(data, player) : SUtils.findUnitTerr(data, player, ourFactories);
        List<Territory> waterFactories = SUtils.stripLandLockedTerr(data, SUtils.findUnitTerr(data, player, ourFactories));
        List<Territory> enemyAttackShipTerr = SUtils.findUnitTerr(data, player, enemyAttackShip);
        List<Territory> ourAttackShipTerr = SUtils.findUnitTerr(data, player, alliedAttackShip);
        List<Territory> enemyTransportTerr = SUtils.findUnitTerr(data, player, enemyTransport);
        int capUnitCount = myCapital.getUnits().countMatches(transportableUnit);
        Set<Territory> capNeighbors = data.getMap().getNeighbors(myCapital, Matches.TerritoryIsWater);
        for (Territory capN : capNeighbors) {
            capUnitCount -= capN.getUnits().countMatches(transUnit) * 2;
        }
        int EASCount = 0;
        int OASCount = 0;
        int ETTCount = 0;
        int factoryCount = factories.size();
        int totTransports = this.countTransports(data, player);
        int totAttackSeaUnits = this.countSeaUnits(data, player);
        int totLandUnits = this.countLandUnits(data, player);
        int totEAttackSeaUnits = 0;
        List<PlayerID> enemyPlayers = SUtils.getEnemyPlayers(data, player);
        for (PlayerID ePlayer : enemyPlayers) {
            totEAttackSeaUnits += this.countSeaUnits(data, ePlayer);
        }
        int waterProduction = 0;
        for (Territory wFact : waterFactories) {
            waterProduction += TripleAUnit.getProductionPotentialOfTerritory(wFact.getUnits().getUnits(), wFact, player, data, false, true);
        }
        if (isAmphib && (waterProduction < 6 && PUsToSpend > 26 || waterProduction < 4 && PUsToSpend > 15 || waterProduction < 10 && PUsToSpend > 70 || waterProduction < 2 || Math.random() < 0.33 && PUsToSpend > 250)) {
            float risk = 0.0f;
            Territory waterFact = SUtils.findFactoryTerritory(data, player, 0.0f, true, true);
            if (waterFact != null) {
                waterProduction += TripleAUnit.getProductionPotentialOfTerritory(waterFact.getUnits().getUnits(), waterFact, player, data, false, true);
                for (ProductionRule factoryRule : rules) {
                    NamedAttachable resourceOrUnit2 = factoryRule.getResults().keySet().iterator().next();
                    if (!(resourceOrUnit2 instanceof UnitType)) continue;
                    UnitType factoryType = (UnitType)resourceOrUnit2;
                    int cost = factoryRule.getCosts().getInt(pus);
                    if (!Matches.UnitTypeCanProduceUnitsAndIsConstruction.match(factoryType) || PUsToSpend < cost || factPurchased) continue;
                    this.setFactory(waterFact);
                    purchase.add(factoryRule, 1);
                    PUsToSpend -= cost;
                    factPurchased = true;
                }
                if (factPurchased && (PUsToSpend < 16 || waterProduction <= 0)) {
                    purchaseDelegate.purchase(purchase);
                } else if (factPurchased) {
                    double random = Math.random();
                    SUtils.findPurchaseMix(bestAttack, bestDefense, bestTransport, bestMaxUnits, bestMobileAttack, seaProductionRules, PUsToSpend, waterProduction, data, player, 0);
                    for (ProductionRule rule1 : seaProductionRules) {
                        UnitType rule1UT;
                        int buyThese = 0;
                        int cost = rule1.getCosts().getInt(pus);
                        PUsToSpend -= cost * buyThese;
                        for (buyThese = random <= 0.4 ? bestDefense.getInt(rule1) : bestTransport.getInt(rule1); PUsToSpend < 0 && buyThese > 0; --buyThese, PUsToSpend += cost) {
                        }
                        if (buyThese <= 0) continue;
                        purchase.add(rule1, buyThese);
                        NamedAttachable resourceOrUnit3 = rule1.getResults().keySet().iterator().next();
                        if (!(resourceOrUnit3 instanceof UnitType) || !Matches.UnitTypeCanTransport.match(rule1UT = (UnitType)resourceOrUnit3) || buyThese <= 0) continue;
                        this.setDidPurchaseTransports(true);
                    }
                    purchaseDelegate.purchase(purchase);
                }
                long now = System.currentTimeMillis();
                s_logger.finest("Time Taken " + (now - last));
                return;
            }
        }
        if (isAmphib && !waterFactories.isEmpty() && (closestEnemyCapitol = SUtils.closestEnemyCapital(myCapital, data, player)) != null) {
            int capEDist = data.getMap().getDistance(myCapital, closestEnemyCapitol);
            Territory myClosestFactory = SUtils.closestToEnemyCapital(waterFactories, data, player, false);
            if (myClosestFactory != null) {
                int cFactEDist = data.getMap().getDistance(myClosestFactory, closestEnemyCapitol);
                if (cFactEDist >= capEDist) {
                    myClosestFactory = myCapital;
                }
                s_logger.fine("Capital: " + myCapital + "; Closest Enemy Capitol: " + closestEnemyCapitol + "; Closest Factory: " + myClosestFactory);
                int distFromFactoryToECap = data.getMap().getDistance(closestEnemyCapitol, myClosestFactory);
                distFromFactoryToECap = Math.max(distFromFactoryToECap, 3);
                ArrayList<Territory> cap3Neighbors = new ArrayList<Territory>(data.getMap().getNeighbors(myClosestFactory, distFromFactoryToECap));
                Iterator nIter = cap3Neighbors.iterator();
                while (nIter.hasNext()) {
                    Territory thisTerr = (Territory)nIter.next();
                    if (Matches.TerritoryIsLand.match(thisTerr)) {
                        nIter.remove();
                        continue;
                    }
                    int distToFactory = data.getMap().getDistance(myClosestFactory, thisTerr);
                    int distToECap = data.getMap().getDistance(closestEnemyCapitol, thisTerr);
                    if (distToECap + distToFactory <= distFromFactoryToECap + 2 || distToFactory <= 1) continue;
                    nIter.remove();
                }
                ArrayList<Unit> ourUnits = new ArrayList<Unit>();
                float totSeaThreat = 0.0f;
                for (Territory seaCapTerr : cap3Neighbors) {
                    ourUnits.addAll(seaCapTerr.getUnits().getMatches(alliedAttackShip));
                    totSeaThreat += SUtils.getStrengthOfPotentialAttackers(seaCapTerr, data, player, tFirst, false, null);
                }
            }
        }
        for (Territory EAST : enemyAttackShipTerr) {
            EASCount += EAST.getUnits().countMatches(enemyAttackShip);
            EASCount += EAST.getUnits().countMatches(enemyFighter);
        }
        for (Territory OAST : ourAttackShipTerr) {
            OASCount += OAST.getUnits().countMatches(alliedAttackShip);
            OASCount += OAST.getUnits().countMatches(alliedFighter);
        }
        for (Territory ETT : enemyTransportTerr) {
            ETTCount += ETT.getUnits().countMatches(enemyTransport);
        }
        boolean doBuyAttackShips = false;
        Territory factCheckTerr = myCapital;
        if (Matches.territoryHasWaterNeighbor(data).invert().match(myCapital)) {
            if (EASCount > OASCount + 2) {
                doBuyAttackShips = true;
            }
            if (EASCount > OASCount * 3) {
                buyPlanesOnly = true;
            }
            Iterator<Territory> wFIter = waterFactories.iterator();
            Territory factTerr = null;
            Territory lastGoodFactTerr = null;
            Territory newFactTerr = null;
            while (wFIter.hasNext() && factTerr == null) {
                newFactTerr = wFIter.next();
                if (TripleAUnit.getProductionPotentialOfTerritory(newFactTerr.getUnits().getUnits(), newFactTerr, player, data, false, true) > 2) {
                    lastGoodFactTerr = newFactTerr;
                    if (wFIter.hasNext() && Math.random() >= 0.5 || !wFIter.hasNext()) {
                        factTerr = newFactTerr;
                    }
                }
                if (!wFIter.hasNext() || factTerr != null || lastGoodFactTerr == null) continue;
                factTerr = lastGoodFactTerr;
            }
            factCheckTerr = factTerr != null ? factTerr : (!waterFactories.isEmpty() ? waterFactories.iterator().next() : null);
        }
        float strength1 = 0.0f;
        float strength2 = 0.0f;
        float airPotential = 0.0f;
        if (factCheckTerr != null && (myCapWaterTerr = SUtils.findASeaTerritoryToPlaceOn(factCheckTerr, data, player, tFirst)) != null) {
            strength1 = SUtils.getStrengthOfPotentialAttackers(myCapWaterTerr, data, player, tFirst, false, null);
            strength2 = SUtils.getStrengthOfPotentialAttackers(myCapWaterTerr, data, player, tFirst, true, null);
            airPotential = strength1 - strength2;
        }
        List<Territory> myShipTerrs = SUtils.findOnlyMyShips(myCapital, data, player, alliedAttackShip);
        int shipCount = 0;
        for (Territory shipT : myShipTerrs) {
            shipCount += shipT.getUnits().countMatches(alliedAttackShip);
        }
        int totPU = 0;
        int totProd = 0;
        int PUSea = 0;
        int PULand = 0;
        int maxShipThreat = 0;
        int currShipThreat = 0;
        int minDistanceToEnemy = 1000;
        boolean nonCapitolFactoryThreat = false;
        boolean seaAdvantageEnemy = (tFirst ? totTransports : 0) * 10 + totAttackSeaUnits * 10 < totEAttackSeaUnits * 9 + (tFirst ? ETTCount * 5 : 0);
        for (Territory territory : factories) {
            float factStrength;
            int thisFactProduction = TripleAUnit.getProductionPotentialOfTerritory(territory.getUnits().getUnits(), territory, player, data, false, true);
            totPU += thisFactProduction;
            totProd += TripleAUnit.getProductionPotentialOfTerritory(territory.getUnits().getUnits(), territory, player, data, true, true);
            if (!this.useProductionData()) {
                totProd = totPU;
            }
            if (isAmphib) {
                currShipThreat = SUtils.shipThreatToTerr(territory, data, player, tFirst);
                if (currShipThreat > 3 && !seaAdvantageEnemy || currShipThreat > 2 && seaAdvantageEnemy) {
                    if (territory == myCapital) {
                        this.setSeaTerr(myCapital);
                        shipCapitalThreat = true;
                    }
                    if (currShipThreat > maxShipThreat) {
                        maxShipThreat = currShipThreat;
                    }
                }
            } else {
                Route minDistRoute = SUtils.findNearest(territory, Matches.isTerritoryEnemyAndNotUnownedWaterOrImpassibleOrRestricted(player, data), Matches.TerritoryIsNotImpassableToLandUnits(player, data), data);
                int thisMinDist = 1000;
                if (minDistRoute != null) {
                    thisMinDist = minDistRoute.getLength();
                }
                minDistanceToEnemy = Math.min(thisMinDist, minDistanceToEnemy);
            }
            currShipThreat = 0;
            float factThreat = SUtils.getStrengthOfPotentialAttackers(territory, data, player, tFirst, true, null);
            if (!(factThreat > (factStrength = SUtils.strength(territory.getUnits().getUnits(), false, false, tFirst)))) continue;
            nonCapitolFactoryThreat = true;
        }
        int unitCount = 0;
        totPU = n3 = PUsToSpend;
        float purchaseT = 1.0f;
        if (isAmphib) {
            purchaseT = 0.5f;
        }
        List<Territory> ACTerrs = SUtils.ACTerritory(player, data);
        int ACCount = 0;
        int fighterCount = 0;
        for (Territory ACTerr : ACTerrs) {
            ACCount += ACTerr.getUnits().countMatches(ACUnit);
        }
        List<Territory> fighterTerrs = SUtils.findTersWithUnitsMatching(data, player, Matches.UnitCanLandOnCarrier);
        for (Territory fighterTerr : fighterTerrs) {
            fighterCount += fighterTerr.getUnits().countMatches(fighter);
        }
        if (ACCount > fighterCount) {
            buyOnePlane = true;
        }
        Territory capitol = TerritoryAttachment.getFirstOwnedCapitalOrFirstUnownedCapital(player, data);
        CompositeMatchAnd<Unit> ourFactoriesThatCanBeDamaged = new CompositeMatchAnd<Unit>(ourFactories, Matches.UnitCanBeDamaged);
        List<Territory> rfactories = Match.getMatches(SUtils.findUnitTerr(data, player, ourFactoriesThatCanBeDamaged), Matches.isTerritoryOwnedBy(player));
        List<Object> rrules = Collections.emptyList();
        if (player.getRepairFrontier() != null && Properties.getDamageFromBombingDoneToUnitsInsteadOfTerritories(data)) {
            rrules = player.getRepairFrontier().getRules();
            IntegerMap<RepairRule> repairMap = new IntegerMap<RepairRule>();
            HashMap<Unit, IntegerMap<RepairRule>> repair = new HashMap<Unit, IntegerMap<RepairRule>>();
            HashMap<Unit, Territory> unitsThatCanProduceNeedingRepair = new HashMap<Unit, Territory>();
            ArrayList<Unit> unitsThatAreDisabledNeedingRepair = new ArrayList<Unit>();
            CompositeMatchAnd ourDisabled = new CompositeMatchAnd(Matches.unitIsOwnedBy(player), Matches.UnitIsDisabled);
            int minimumUnitPrice = 3;
            int diff = 0;
            int totalDamage = 0;
            int capDamage = 0;
            int capProduction = 0;
            Unit capUnit = null;
            Territory capUnitTerritory = null;
            int maxUnits = (totPU - 1) / 3;
            int currentProduction = 0;
            int maxProduction = 0;
            Collections.shuffle(rfactories);
            for (Territory territory : rfactories) {
                if (!Matches.territoryIsOwnedAndHasOwnedUnitMatching(data, player, Matches.UnitCanProduceUnitsAndCanBeDamaged).match(territory)) continue;
                Unit unit = TripleAUnit.getBiggestProducer(Match.getMatches(territory.getUnits().getUnits(), ourFactoriesThatCanBeDamaged), territory, player, data, false);
                if (Matches.UnitHasTakenSomeBombingUnitDamage.match(unit)) {
                    unitsThatCanProduceNeedingRepair.put(unit, territory);
                }
                unitsThatAreDisabledNeedingRepair.addAll(Match.getMatches(territory.getUnits().getUnits(), ourDisabled));
                TripleAUnit tripleAUnit = (TripleAUnit)unit;
                maxProduction += TripleAUnit.getHowMuchCanUnitProduce(unit, territory, player, data, false, true);
                diff = tripleAUnit.getUnitDamage();
                totalDamage += diff;
                if (territory == capitol) {
                    capDamage += diff;
                    capProduction = TripleAUnit.getHowMuchCanUnitProduce(unit, territory, player, data, true, true);
                    capUnit = unit;
                    capUnitTerritory = territory;
                }
                currentProduction += TripleAUnit.getHowMuchCanUnitProduce(unit, territory, player, data, true, true);
            }
            rfactories.remove(capitol);
            unitsThatCanProduceNeedingRepair.remove(capUnit);
            if ((capProduction <= maxUnits / 2 || rfactories.isEmpty()) && capUnit != null) {
                for (RepairRule repairRule : rrules) {
                    void var96_149;
                    if (!capUnit.getUnitType().equals(repairRule.getResults().keySet().iterator().next()) || !Matches.territoryIsOwnedAndHasOwnedUnitMatching(data, player, Matches.UnitCanProduceUnitsAndCanBeDamaged).match(capitol)) continue;
                    TripleAUnit tripleAUnit = (TripleAUnit)capUnit;
                    diff = tripleAUnit.getUnitDamage();
                    int n4 = TripleAUnit.getHowMuchCanUnitProduce(capUnit, capUnitTerritory, player, data, false, true) - diff;
                    diff = !rfactories.isEmpty() ? Math.min(diff, maxUnits / 2 - n4 + 1) : Math.min(diff, maxUnits - n4);
                    if ((diff = Math.min(diff, (int)(var96_149 - 3))) <= 0) continue;
                    currentProduction = n4 >= 0 ? (currentProduction += diff) : (currentProduction += diff + n4);
                    repairMap.add(repairRule, diff);
                    repair.put(capUnit, repairMap);
                    purchaseDelegate.purchaseRepair(repair);
                    repair.clear();
                    repairMap.clear();
                    maxUnits = ((var96_149 -= diff) - true) / 3;
                }
            }
            for (int i = 0; currentProduction < maxUnits && i < 2; ++i) {
                for (RepairRule repairRule : rrules) {
                    for (Unit fixUnit : unitsThatCanProduceNeedingRepair.keySet()) {
                        if (fixUnit == null || !fixUnit.getType().equals(repairRule.getResults().keySet().iterator().next()) || !Matches.territoryIsOwnedAndHasOwnedUnitMatching(data, player, Matches.UnitCanProduceUnitsAndCanBeDamaged).match((Territory)unitsThatCanProduceNeedingRepair.get(fixUnit)) || currentProduction >= maxUnits) continue;
                        TripleAUnit taUnit = (TripleAUnit)fixUnit;
                        diff = taUnit.getUnitDamage();
                        int unitProductionAllowNegative = TripleAUnit.getHowMuchCanUnitProduce(fixUnit, (Territory)unitsThatCanProduceNeedingRepair.get(fixUnit), player, data, false, true) - diff;
                        if (i == 0) {
                            diff = unitProductionAllowNegative < 0 ? Math.min(diff, maxUnits - currentProduction - unitProductionAllowNegative) : Math.min(diff, maxUnits - currentProduction);
                        }
                        if ((diff = Math.min(diff, (int)(var96_150 - 3))) <= 0) continue;
                        currentProduction = unitProductionAllowNegative >= 0 ? (currentProduction += diff) : (currentProduction += diff + unitProductionAllowNegative);
                        repairMap.add(repairRule, diff);
                        repair.put(fixUnit, repairMap);
                        purchaseDelegate.purchaseRepair(repair);
                        repair.clear();
                        repairMap.clear();
                        maxUnits = ((var96_150 -= diff) - true) / 3;
                    }
                }
                rfactories.add(capitol);
                if (capUnit == null) continue;
                unitsThatCanProduceNeedingRepair.put(capUnit, capUnitTerritory);
            }
        }
        float realLandThreat = 0.0f;
        this.determineCapDanger(player, data);
        StrengthEvaluator capStrEvalLand = StrengthEvaluator.evalStrengthAt(data, player, myCapital, true, true, tFirst, true);
        boolean capDanger = this.getCapDanger();
        int fighterPresent = 0;
        if (capDanger && totProd > 0) {
            landProductionRules.addAll(airProductionRules);
            SUtils.findPurchaseMix(bestAttack, bestDefense, bestTransport, bestMaxUnits, bestMobileAttack, landProductionRules, (int)var96_150, totProd, data, player, 0);
            for (ProductionRule rule1 : landProductionRules) {
                void var96_151;
                int buyThese;
                int cost = rule1.getCosts().getInt(pus);
                var96_151 -= cost * buyThese;
                for (buyThese = bestDefense.getInt(rule1); var96_151 < 0 && buyThese > 0; --buyThese, var96_151 += cost) {
                }
                if (buyThese <= 0) continue;
                purchase.add(rule1, buyThese);
                unitCount += buyThese;
            }
            purchaseDelegate.purchase(purchase);
            long now = System.currentTimeMillis();
            s_logger.finest("Time Taken " + (now - last));
            return;
        }
        float PUNeeded = 0.0f;
        if (shipCapitalThreat) {
            PUNeeded = Properties.getWW2V3(data) ? (float)maxShipThreat * 5.5f : (float)maxShipThreat * 6.5f;
        }
        realLandThreat = capStrEvalLand.strengthMissing(0.85f);
        boolean bl = noCapitalThreat = capStrEvalLand.getEnemyStrengthInRange() < 0.5f;
        if (totEAttackSeaUnits + 2 < totAttackSeaUnits) {
            doBuyAttackShips = false;
        }
        if (isAmphib && shipCapitalThreat && (noCapitalThreat || realLandThreat < -4.0f)) {
            if (Math.random() > 0.8) {
                buyOnePlane = true;
            }
            if (nonCapitolFactoryThreat && Math.random() <= 0.7) {
                buyPlanesOnly = true;
                doBuyAttackShips = false;
            } else {
                buyBattleShip = true;
                doBuyAttackShips = true;
            }
            if (!tFirst) {
                buyTransports = false;
            }
        } else if (!isAmphib && noCapitalThreat) {
            if (Math.random() > 0.5) {
                buyOnePlane = true;
            }
            Route dRoute = SUtils.findNearest(myCapital, enemyAndNoWater, noEnemyOrWater, data);
            if (shipCapitalThreat && dRoute.getLength() > 3) {
                buyBattleShip = false;
            }
        } else if (!isAmphib && !isLand && (realLandThreat < -8.0f || noCapitalThreat)) {
            if (tFirst && maxShipThreat > 3 || !tFirst && maxShipThreat > 2) {
                doBuyAttackShips = true;
                purchaseT = 0.15f;
                buyTransports = false;
            } else if (capUnitCount > 14) {
                buyTransports = true;
                skipShips = false;
                purchaseT = 0.25f;
            }
        }
        if (isAmphib && isLand) {
            purchaseT = 0.6f;
            if (capUnitCount > 14) {
                buyTransports = true;
                purchaseT = 0.25f;
            }
            if (maxShipThreat > 3 || doBuyAttackShips && !tFirst) {
                buyTransports = false;
                purchaseT = 0.14f;
            }
            if (totTransports * 6 > totLandUnits) {
                buyTransports = false;
                if (!doBuyAttackShips) {
                    skipShips = true;
                }
                purchaseT = 1.0f;
            }
        }
        if (isAmphib && doBuyAttackShips && realLandThreat < 15.0f) {
            purchaseT = 0.0f;
        } else if (isAmphib && !isLand) {
            if (currentRound < 6 && Math.random() < (double)0.55f) {
                buyOneShip = true;
            }
            if (realLandThreat < 2.0f) {
                buyTransports = true;
                skipShips = false;
            }
            if (capUnitCount > 15 && realLandThreat < 0.0f) {
                purchaseT = 0.2f;
            } else if (capUnitCount > 12) {
                purchaseT = 0.49f;
            } else if (capUnitCount > 6) {
                purchaseT = 0.62f;
            } else if (totTransports * 3 > totLandUnits) {
                buyTransports = false;
                if (!doBuyAttackShips) {
                    skipShips = true;
                }
                purchaseT = 1.0f;
            } else {
                purchaseT = 0.64f;
            }
        }
        if (isAmphib && PUNeeded > (float)(var96_150 + 8) && Math.random() < 0.8) {
            n2 = Math.min((int)var96_150, (int)realLandThreat);
            purchaseT = 1.0f;
            buyTransports = false;
        }
        if (PUNeeded > 0.6f * (float)n2) {
            buyTransports = false;
            if (isAmphib && purchaseT != 0.0f && purchaseT != 1.0f) {
                purchaseT = realLandThreat <= 0.0f ? 0.18f : 0.54f;
                doBuyAttackShips = true;
            }
        }
        if (!isAmphib) {
            boolean noWater = !SUtils.isWaterAt(myCapital, data);
            purchaseT = 0.82f;
            if (Math.random() < 0.88 || realLandThreat > 4.0f) {
                purchaseT = 1.0f;
            }
            if (noWater) {
                purchaseT = 1.0f;
                skipShips = true;
            }
        }
        float fSpend = n2;
        PUSea = (int)(fSpend * (1.0f - purchaseT));
        PULand = n2 - PUSea;
        if (isAmphib & !doBuyAttackShips) {
            int transportableUnitsUsage = 0;
            List<Territory> myTerritories = SUtils.allAlliedTerritories(data, player);
            myTerritories.retainAll(Match.getMatches(myTerritories, Matches.territoryHasValidLandRouteTo(data, capitol)));
            for (Territory xTerr : myTerritories) {
                if (Matches.territoryHasEnemyLandNeighbor(data, player).match(xTerr)) continue;
                ArrayList<Unit> unitsOnTerr = new ArrayList<Unit>(xTerr.getUnits().getUnits());
                for (Unit unit : unitsOnTerr) {
                    UnitAttachment ua;
                    if (!((Match)transportableUnit).match(unit) || (ua = UnitAttachment.get(unit.getUnitType())) == null || ua.getTransportCost() < 0) continue;
                    transportableUnitsUsage += ua.getTransportCost();
                }
            }
            int transportCapacityLeftForAllTransportsTogether = 0;
            CompositeMatchAnd<Unit> myAvailableTransports = new CompositeMatchAnd<Unit>(Matches.UnitIsTransport, Matches.transportIsNotTransporting(), Matches.unitIsOwnedBy(player));
            List<Territory> myTransTerrs = SUtils.findTersWithUnitsMatching(data, player, myAvailableTransports);
            ArrayList<Territory> waterFactoriesByCap = new ArrayList<Territory>(waterFactories);
            waterFactoriesByCap.retainAll(myTerritories);
            for (Territory ter : myTransTerrs) {
                int closestWFact = 99999;
                for (Territory territory : waterFactoriesByCap) {
                    int n5 = data.getMap().getDistance(territory, ter, Matches.TerritoryIsLandOrWater);
                    if (n5 < 0 || closestWFact <= n5) continue;
                    closestWFact = n5;
                }
                if (closestWFact > 3) continue;
                for (Unit unit : ter.getUnits()) {
                    UnitAttachment unitAttachment;
                    if (!((Match)myAvailableTransports).match(unit) || (unitAttachment = UnitAttachment.get(unit.getUnitType())) == null || unitAttachment.getTransportCapacity() < 2) continue;
                    int transportCapacity = unitAttachment.getTransportCapacity();
                    transportCapacityLeftForAllTransportsTogether += transportCapacity;
                }
            }
            if (transportCapacityLeftForAllTransportsTogether > transportableUnitsUsage + 15) {
                skipShips = true;
                PULand = n2;
                PUSea = 0;
                buyTransports = false;
            } else if (transportCapacityLeftForAllTransportsTogether < transportableUnitsUsage) {
                buyTransports = true;
                skipShips = false;
                PULand = n2 - 12;
                PULand = Math.max(PULand, 0);
                PUSea = n2 - PULand;
                if (transportCapacityLeftForAllTransportsTogether + 6 < transportableUnitsUsage) {
                    PUSea = n2 - 12;
                    PUSea = Math.max(PUSea, 12);
                    PUSea = Math.max(PUSea, n2 / 2);
                    PUSea = Math.max(PUSea, 0);
                    PULand = n2 - PUSea;
                }
                if (transportCapacityLeftForAllTransportsTogether + 6 < transportableUnitsUsage / 2) {
                    PUSea = n2;
                    PUSea = Math.max(PUSea, 0);
                    PULand = n2 - PUSea;
                }
            }
        }
        boolean removeSubs = false;
        if (isAmphib) {
            CompositeMatchAnd<Unit> ourAirUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsAir);
            CompositeMatchAnd<Unit> enemyAirUnit = new CompositeMatchAnd<Unit>(Matches.enemyUnit(player, data), Matches.UnitIsAir);
            CompositeMatchAnd<Unit> alliedAirUnit = new CompositeMatchAnd<Unit>(Matches.alliedUnit(player, data), Matches.UnitIsAir);
            Set<Territory> myTerr = data.getMap().getNeighbors(myCapital, 6);
            Route amphibRoute = this.getAmphibRoute(player, false);
            if (amphibRoute != null && amphibRoute.getEnd() != null) {
                Territory amphibTerr = amphibRoute.getEnd();
                Set<Territory> amphibTerrs = data.getMap().getNeighbors(amphibTerr, 3);
                myTerr.addAll(amphibTerrs);
            }
            ArrayList<Unit> myShipsPlanes = new ArrayList<Unit>();
            ArrayList<Unit> enemyShipsPlanes = new ArrayList<Unit>();
            ArrayList<Unit> alliedShipsPlanes = new ArrayList<Unit>();
            boolean bl2 = false;
            boolean bl3 = false;
            for (Territory checkTerr : myTerr) {
                if (Matches.TerritoryIsWater.match(checkTerr)) {
                    myShipsPlanes.addAll(checkTerr.getUnits().getMatches(ourAttackShip));
                    myShipsPlanes.addAll(checkTerr.getUnits().getMatches(ourAirUnit));
                    alliedShipsPlanes.addAll(checkTerr.getUnits().getMatches(alliedAirUnit));
                    alliedShipsPlanes.addAll(checkTerr.getUnits().getMatches(alliedAttackShip));
                    List<Unit> enemyShips = checkTerr.getUnits().getMatches(enemyAttackShip);
                    enemyShipsPlanes.addAll(enemyShips);
                    var121_248 += enemyShips.size();
                    alliedShipsPlanes.removeAll(myShipsPlanes);
                }
                List<Unit> enemyPlanes = checkTerr.getUnits().getMatches(enemyAirUnit);
                enemyShipsPlanes.addAll(enemyPlanes);
                var122_293 += enemyPlanes.size();
            }
            int n6 = myShipsPlanes.size() + alliedShipsPlanes.size() / 2;
            int enemyTotUnits = enemyShipsPlanes.size();
            if (enemyTotUnits > 0 && n6 < enemyTotUnits + 2) {
                void var121_248;
                void var122_293;
                doBuyAttackShips = true;
                PUSea = n2;
                PULand = 0;
                if (var122_293 > var121_248) {
                    removeSubs = true;
                }
            }
        }
        int landConstant = 2;
        boolean highPriceLandUnits = false;
        if (n2 > 10 * totProd && !doBuyAttackShips) {
            if (Math.random() <= 0.85) {
                buyPlanesOnly = true;
            }
            buyCarrier = true;
            buyBattleShip = false;
        } else if (n2 > 5 * (totProd - 1)) {
            buyOnePlane = true;
        }
        boolean extraPUonPlanes = false;
        if (capDanger) {
            if (!isLand && !doBuyAttackShips) {
                PULand = n2;
                PUSea = 0;
            }
            extraPUonPlanes = true;
            buyTransports = false;
        }
        highPriceLandUnits = highPrice * totProd + 3 < PULand;
        boolean buyfactory = false;
        int maxPurch = n2 / 3;
        if (maxPurch > totProd + 4 && !isAmphib || maxPurch > totProd + 12) {
            buyfactory = true;
            landConstant = 2;
            buyOnePlane = true;
            highPriceLandUnits = true;
        }
        if (realLandThreat <= 0.0f && !doBuyAttackShips && !buyTransports && !isAmphib && maxPurch > totProd + 2) {
            highPriceLandUnits = true;
        }
        if (landConstant != 2 || highPriceLandUnits && PULand >= 35 || totProd == 0) {
            buyfactory = true;
        }
        if (isAmphib && !doBuyAttackShips && totTransports <= 15) {
            buyTransports = true;
        }
        if (highPriceLandUnits && (!isAmphib || isAmphib && !buyTransports && !doBuyAttackShips) && !buyPlanesOnly) {
            landProductionRules.addAll(airProductionRules);
        }
        int maxBuy = totProd - unitCount;
        int n7 = purchaseT < 0.7f ? maxBuy * 3 / 4 : (maxBuy = doBuyAttackShips ? 2 : 0);
        if (buyOnePlane) {
            --maxBuy;
        }
        if (isAmphib && !doBuyAttackShips) {
            List<Territory> myFTerrs = SUtils.findTersWithUnitsMatching(data, player, Matches.UnitCanLandOnCarrier);
            if (myFTerrs.isEmpty() && !buyOnePlane) {
                buyOnePlane = true;
                --maxBuy;
            }
            if (currentRound <= 4 && !buyOnePlane && Math.random() < 0.65) {
                buyOneShip = true;
                ++maxBuy;
            }
        }
        ArrayList<ProductionRule> newSeaProductionRules = new ArrayList<ProductionRule>(seaProductionRules);
        if (buyOneShip) {
            int n8;
            if (Math.random() > 0.25) {
                Iterator subRule = newSeaProductionRules.iterator();
                while (subRule.hasNext()) {
                    ProductionRule productionRule = (ProductionRule)subRule.next();
                    NamedAttachable namedAttachable = productionRule.getResults().keySet().iterator().next();
                    if (!(namedAttachable instanceof UnitType)) continue;
                    UnitType unitType = (UnitType)namedAttachable;
                    if (Matches.UnitTypeIsSub.match(unitType)) {
                        subRule.remove();
                        continue;
                    }
                    if (!Matches.UnitTypeIsSea.match(unitType) || !Matches.unitTypeCanAttack(player).invert().match(unitType)) continue;
                    subRule.remove();
                }
            }
            ProductionRule maxRule = null;
            boolean bl4 = false;
            if (Math.random() <= 0.5) {
                Iterator iterator = newSeaProductionRules.iterator();
                while (iterator.hasNext()) {
                    UnitType x3;
                    ProductionRule productionRule = (ProductionRule)iterator.next();
                    NamedAttachable resourceOrUnit5 = productionRule.getResults().keySet().iterator().next();
                    if (!(resourceOrUnit5 instanceof UnitType) || !Matches.UnitTypeHasMoreThanOneHitPointTotal.match(x3 = (UnitType)resourceOrUnit5)) continue;
                    iterator.remove();
                }
            }
            for (ProductionRule productionRule : newSeaProductionRules) {
                int shipcost = productionRule.getCosts().getInt(pus);
                if (maxRule != null || shipcost >= PUSea || !(Math.random() < 0.2) && !productionRule.equals(newSeaProductionRules.get(newSeaProductionRules.size() - 1))) continue;
                n8 = shipcost;
                maxRule = productionRule;
            }
            if (maxRule != null && n8 <= n2 && unitCount < totProd) {
                void var122_299;
                int n10 = PUSea / n8;
                n10 = unitCount + n10 <= totProd ? n10 : totProd - unitCount;
                int n11 = n2 - n8 * n10;
                if (n11 < 0) {
                    --var122_299;
                    n = n11 + n8;
                }
                if (!doBuyAttackShips) {
                    PUSea = 0;
                    PULand = n;
                }
                if (var122_299 > 0) {
                    UnitType maxRuleUT;
                    purchase.add(maxRule, (int)var122_299);
                    unitCount += var122_299;
                    NamedAttachable namedAttachable = maxRule.getResults().keySet().iterator().next();
                    if (namedAttachable instanceof UnitType && Matches.UnitTypeCanTransport.match(maxRuleUT = (UnitType)namedAttachable) && var122_299 > 0) {
                        this.setDidPurchaseTransports(true);
                    }
                }
            }
        }
        if (PUSea > 0 && (doBuyAttackShips || buyBattleShip) && maxBuy > 0 && unitCount < totProd) {
            if (isAmphib && !capDanger && maxShipThreat > 2) {
                PUSea = n;
            }
            if (unitCount < 2) {
                this.setAttackShipPurchase(true);
            }
            fighterPresent = myCapital.getUnits().countMatches(Matches.UnitCanLandOnCarrier);
            if (PUSea > 0) {
                int n12;
                int n13;
                int buyThese = 0;
                boolean bl5 = true;
                if (Math.random() <= 0.45) {
                    int n14 = 2;
                }
                if (Math.random() >= 0.65 && factoryCount == 1 && (double)PUNeeded > 0.75 * (double)n) {
                    int n15 = 3;
                }
                Route route = SUtils.findNearest(myCapital, enemyOnWater, Matches.TerritoryIsWater, data);
                boolean bl6 = false;
                if (route != null) {
                    n13 = route.getLength();
                }
                if (n13 > 3) {
                    n12 = 5;
                }
                if (buyBattleShip) {
                    for (ProductionRule BBRule : seaProductionRules) {
                        int BBcost;
                        void var96_155;
                        UnitType results;
                        NamedAttachable resourceOrUnit7 = BBRule.getResults().keySet().iterator().next();
                        if (!(resourceOrUnit7 instanceof UnitType) || !Matches.UnitTypeHasMoreThanOneHitPointTotal.match(results = (UnitType)resourceOrUnit7) || var96_155 < (BBcost = BBRule.getCosts().getInt(pus))) continue;
                        ++unitCount;
                        PUSea -= BBcost;
                        var96_155 -= BBcost;
                        purchase.add(BBRule, 1);
                        --maxBuy;
                    }
                }
                if (buyCarrier) {
                    int fighterCost;
                    boolean fighterBought;
                    void var96_156;
                    boolean carrierBought = false;
                    for (ProductionRule CarrierRule : seaProductionRules) {
                        int Carriercost;
                        UnitType results;
                        NamedAttachable resourceOrUnit8 = CarrierRule.getResults().keySet().iterator().next();
                        if (!(resourceOrUnit8 instanceof UnitType) || !Matches.UnitTypeIsCarrier.match(results = (UnitType)resourceOrUnit8) || var96_156 < (Carriercost = CarrierRule.getCosts().getInt(pus))) continue;
                        ++unitCount;
                        PUSea -= Carriercost;
                        var96_156 -= Carriercost;
                        purchase.add(CarrierRule, 1);
                        --maxBuy;
                        carrierBought = true;
                    }
                    if (carrierBought && var96_156 > 0 && unitCount < totProd && fighterRule != null && !(fighterBought = false) && var96_156 >= (fighterCost = fighterRule.getCosts().getInt(pus))) {
                        ++unitCount;
                        PUSea -= fighterCost;
                        void var96_157 = var96_156 - fighterCost;
                        purchase.add(fighterRule, 1);
                        --maxBuy;
                        fighterBought = true;
                    }
                }
                if (PUSea > 0) {
                    if (removeSubs) {
                        Iterator sPIter = seaProductionRules.iterator();
                        while (sPIter.hasNext()) {
                            UnitType subUnit;
                            ProductionRule shipRule = (ProductionRule)sPIter.next();
                            NamedAttachable resourceOrUnit9 = shipRule.getResults().keySet().iterator().next();
                            if (!(resourceOrUnit9 instanceof UnitType) || !Matches.UnitTypeIsSub.match(subUnit = (UnitType)resourceOrUnit9)) continue;
                            sPIter.remove();
                        }
                    }
                    SUtils.findPurchaseMix(bestAttack, bestDefense, bestTransport, bestMaxUnits, bestMobileAttack, seaProductionRules, PUSea, maxBuy, data, player, fighterPresent);
                    for (ProductionRule rule1 : seaProductionRules) {
                        switch (n12) {
                            case 1: {
                                buyThese = bestAttack.getInt(rule1);
                                break;
                            }
                            case 2: {
                                buyThese = bestDefense.getInt(rule1);
                                break;
                            }
                            case 3: {
                                buyThese = bestMaxUnits.getInt(rule1);
                                break;
                            }
                            case 5: {
                                buyThese = bestMobileAttack.getInt(rule1);
                            }
                        }
                        int cost = rule1.getCosts().getInt(pus);
                        int numToBuy = 0;
                        NamedAttachable resourceOrUnit10 = rule1.getResults().keySet().iterator().next();
                        if (!(resourceOrUnit10 instanceof UnitType)) continue;
                        UnitType results = (UnitType)resourceOrUnit10;
                        while (unitCount < totProd && var96_158 >= cost && PUSea >= cost && numToBuy < buyThese) {
                            int fighterCost;
                            boolean fighterBought;
                            PUSea -= cost;
                            ++numToBuy;
                            if (!Matches.UnitTypeIsCarrier.match(results) || fighterRule == null || (fighterBought = false) || (var96_158 -= cost) < (fighterCost = fighterRule.getCosts().getInt(pus)) || ++unitCount >= totProd) continue;
                            ++unitCount;
                            PUSea -= fighterCost;
                            var96_158 -= fighterCost;
                            purchase.add(fighterRule, 1);
                            fighterBought = true;
                        }
                        purchase.add(rule1, numToBuy);
                        if (!Matches.UnitTypeCanTransport.match(results) || numToBuy <= 0) continue;
                        this.setDidPurchaseTransports(true);
                    }
                }
            }
            bestAttack.clear();
            bestDefense.clear();
            bestTransport.clear();
            bestMaxUnits.clear();
        }
        if (var96_158 >= 15) {
            int numFactory = 0;
            for (Territory territory : factories) {
                if (SUtils.hasLandRouteToEnemyOwnedCapitol(territory, player, data)) {
                    ++numFactory;
                }
                if (!SUtils.doesLandExistAt(territory, data, false)) continue;
                ArrayList<Territory> arrayList = new ArrayList<Territory>(data.getMap().getNeighbors(territory, 3));
                Iterator eFIter = arrayList.iterator();
                while (eFIter.hasNext()) {
                    Territory factTerr = (Territory)eFIter.next();
                    if (!Matches.territoryIsEnemyNonNeutralAndHasEnemyUnitMatching(data, player, Matches.UnitCanProduceUnits).invert().match(factTerr) && data.getMap().getLandRoute(territory, factTerr) != null) continue;
                    eFIter.remove();
                }
                numFactory += arrayList.size();
            }
            if (numFactory >= 2 && var96_158 < 60) {
                buyfactory = false;
            }
            if (numFactory >= 4 && var96_158 < 120) {
                buyfactory = false;
            }
            if (!buyfactory) {
                int n16;
                int n17 = 100;
                for (Territory territory : factories) {
                    Route landDistRoute = SUtils.findNearest(territory, Matches.isTerritoryEnemyAndNotUnownedWaterOrImpassibleOrRestricted(player, data), Matches.TerritoryIsNotImpassable, data);
                    if (landDistRoute == null || landDistRoute.getLength() >= n16) continue;
                    n16 = landDistRoute.getLength();
                }
                if (n16 > 5) {
                    buyfactory = true;
                }
            }
            if (maxPurch > totProd + 12 && highPriceLandUnits && PULand > 70 && PULand > 7 * totProd || totProd == 0) {
                buyfactory = true;
            }
            if (buyfactory) {
                for (ProductionRule productionRule : rules) {
                    NamedAttachable namedAttachable = productionRule.getResults().keySet().iterator().next();
                    if (!(namedAttachable instanceof UnitType)) continue;
                    UnitType factoryType = (UnitType)namedAttachable;
                    int cost = productionRule.getCosts().getInt(pus);
                    if (!Matches.UnitTypeCanProduceUnitsAndIsConstruction.match(factoryType) || var96_159 < cost || factPurchased) continue;
                    float riskFactor = 1.0f;
                    Territory factTerr = SUtils.findFactoryTerritory(data, player, 1.0f, buyfactory, false);
                    if (factTerr == null && totProd <= 0) {
                        factTerr = SUtils.findFactoryTerritory(data, player, 1.0f, buyfactory, true);
                    }
                    if (factTerr == null) continue;
                    this.setFactory(factTerr);
                    purchase.add(productionRule, 1);
                    var96_159 -= cost;
                    factPurchased = true;
                    if ((PULand -= cost) >= 0) continue;
                    PUSea = var96_159;
                }
            }
        }
        maxBuy = totProd - unitCount;
        maxBuy = (double)purchaseT > 0.25 ? maxBuy / 2 : maxBuy;
        if (buyTransports && maxBuy > 0 && !transportProductionRules.isEmpty()) {
            UnitType tRuleUT;
            void var123_330;
            void var96_160;
            void var123_329;
            ProductionRule tRule = (ProductionRule)transportProductionRules.get(0);
            int n18 = tRule.getCosts().getInt(pus);
            void var122_304 = var96_159 / n18;
            int n19 = Math.min((int)var122_304, maxBuy);
            boolean bl7 = false;
            for (PUSea = Math.min(PUSea, (int)(var96_159 - PULand)); unitCount < totProd && var96_160 >= n18 && PUSea >= n18 && var123_329 < n19; ++unitCount, var96_160 -= n18, PUSea -= n18, ++var123_329) {
            }
            if (airPotential > 1.0f && shipCount <= 2) {
                --var123_330;
                void var96_161 = var96_160 + n18;
                PUSea += n18;
                --unitCount;
                for (ProductionRule destroyerRule : seaProductionRules) {
                    void var96_162;
                    UnitType d;
                    NamedAttachable resourceOrUnit12 = destroyerRule.getResults().keySet().iterator().next();
                    if (!(resourceOrUnit12 instanceof UnitType) || !Matches.UnitTypeIsDestroyer.match(d = (UnitType)resourceOrUnit12)) continue;
                    int n20 = destroyerRule.getCosts().getInt(pus);
                    while (n20 >= var96_162 && unitCount < totProd) {
                        purchase.add(destroyerRule, 1);
                        var96_162 -= n20;
                        PUSea -= n20;
                        ++unitCount;
                    }
                }
            }
            purchase.add(tRule, (int)var123_330);
            NamedAttachable resourceOrUnit13 = tRule.getResults().keySet().iterator().next();
            if (resourceOrUnit13 instanceof UnitType && Matches.UnitTypeCanTransport.match(tRuleUT = (UnitType)resourceOrUnit13) && var123_330 > 0) {
                this.setDidPurchaseTransports(true);
            }
        }
        maxBuy = totProd - unitCount;
        maxBuy = buyOnePlane ? maxBuy - 1 : maxBuy;
        bestAttack.clear();
        bestDefense.clear();
        bestTransport.clear();
        bestMaxUnits.clear();
        bestMobileAttack.clear();
        if (!buyPlanesOnly && maxBuy > 0) {
            int n21;
            SUtils.findPurchaseMix(bestAttack, bestDefense, bestTransport, bestMaxUnits, bestMobileAttack, landProductionRules, PULand, maxBuy, data, player, fighterPresent);
            int buyThese = 0;
            boolean bl8 = true;
            if (Math.random() <= 0.65 || isLand && Math.random() > 0.8) {
                int n22 = 2;
            }
            if (Math.random() >= 0.25 && factoryCount >= 2 || nonCapitolFactoryThreat && Math.random() < 0.75) {
                int n23 = 3;
            }
            if (isAmphib && Math.random() < 0.9 || Math.random() < 0.25) {
                if (bestTransport.totalValues() + 3 >= bestMaxUnits.totalValues() && bestTransport.totalValues() > 0) {
                    int n24 = 4;
                } else {
                    int n25 = 3;
                }
            }
            if (!isAmphib && minDistanceToEnemy >= 4 && Math.random() >= 0.1 || minDistanceToEnemy >= 2 && Math.random() >= 0.85) {
                n21 = 5;
            }
            for (ProductionRule productionRule : landProductionRules) {
                int numToBuy;
                switch (n21) {
                    case 1: {
                        buyThese = bestAttack.getInt(productionRule);
                        break;
                    }
                    case 2: {
                        buyThese = bestDefense.getInt(productionRule);
                        break;
                    }
                    case 3: {
                        buyThese = bestMaxUnits.getInt(productionRule);
                        break;
                    }
                    case 4: {
                        buyThese = bestTransport.getInt(productionRule);
                        break;
                    }
                    case 5: {
                        buyThese = bestMobileAttack.getInt(productionRule);
                    }
                }
                int cost = productionRule.getCosts().getInt(pus);
                for (numToBuy = 0; unitCount < totProd && var96_163 >= 0 && var96_163 >= cost && PULand >= cost && numToBuy < buyThese; ++unitCount, var96_163 -= cost, PULand -= cost, ++numToBuy) {
                }
                purchase.add(productionRule, numToBuy);
            }
            bestAttack.clear();
            bestDefense.clear();
            bestTransport.clear();
            bestMaxUnits.clear();
            bestMobileAttack.clear();
        }
        maxBuy = totProd - unitCount;
        if ((buyPlanesOnly || buyOnePlane) && maxBuy > 0 && Math.random() < 0.6) {
            maxBuy = buyOnePlane && !buyPlanesOnly ? 1 : maxBuy;
            SUtils.findPurchaseMix(bestAttack, bestDefense, bestTransport, bestMaxUnits, bestMobileAttack, airProductionRules, (int)var96_163, maxBuy, data, player, fighterPresent);
            int buyThese = 0;
            boolean bl9 = true;
            if (Math.random() <= 0.5) {
                int n26 = 2;
            }
            if (Math.random() >= 0.5 && factoryCount > 2) {
                int n27 = 3;
            } else if (Math.random() > 0.25) {
                int n28 = 5;
            }
            for (ProductionRule productionRule : airProductionRules) {
                int numToBuy;
                void var121_273;
                switch (var121_273) {
                    case 1: {
                        buyThese = bestAttack.getInt(productionRule);
                        break;
                    }
                    case 2: {
                        buyThese = bestDefense.getInt(productionRule);
                        break;
                    }
                    case 3: {
                        buyThese = bestMaxUnits.getInt(productionRule);
                        break;
                    }
                    case 5: {
                        buyThese = bestMobileAttack.getInt(productionRule);
                    }
                }
                int cost = productionRule.getCosts().getInt(pus);
                for (numToBuy = 0; unitCount < totProd && var96_164 >= 0 && var96_164 >= cost && numToBuy < buyThese; ++numToBuy) {
                    ++unitCount;
                    var96_164 -= cost;
                    PULand -= cost;
                }
                purchase.add(productionRule, numToBuy);
            }
            bestAttack.clear();
            bestDefense.clear();
            bestTransport.clear();
            bestMaxUnits.clear();
            bestMobileAttack.clear();
        }
        if (isAmphib) {
            PUSea = var96_164;
            if (!transportProductionRules.isEmpty()) {
                ProductionRule transRule = (ProductionRule)transportProductionRules.get(0);
                int n29 = transRule.getCosts().getInt(pus);
                maxBuy = var96_164 / n29;
                if (n29 * (maxBuy = Math.max(1, maxBuy - 1)) <= var96_164) {
                    UnitType unitType;
                    purchase.add(transRule, maxBuy);
                    var96_165 = var96_164 - n29 * maxBuy;
                    NamedAttachable namedAttachable = transRule.getResults().keySet().iterator().next();
                    if (namedAttachable instanceof UnitType && Matches.UnitTypeCanTransport.match(unitType = (UnitType)namedAttachable) && maxBuy > 0) {
                        this.setDidPurchaseTransports(true);
                    }
                }
            }
        }
        bestAttack.clear();
        bestDefense.clear();
        bestTransport.clear();
        bestMaxUnits.clear();
        bestMobileAttack.clear();
        if (var96_165 > 0 && unitCount < totProd && extraPUonPlanes) {
            for (ProductionRule productionRule : rules) {
                UnitType plane;
                NamedAttachable namedAttachable;
                int n30 = productionRule.getCosts().getInt(pus);
                if (var96_166 < n30 || unitCount >= totProd || !((namedAttachable = productionRule.getResults().keySet().iterator().next()) instanceof UnitType) || !Matches.UnitTypeIsAir.match(plane = (UnitType)namedAttachable)) continue;
                if (capDanger && !Matches.unitTypeCanBombard(player).match(plane)) {
                    int buyThese;
                    int maxPlanes = totProd - unitCount;
                    void costPlanes = var96_166 / n30;
                    var96_166 -= maxPlanes * n30;
                    for (buyThese = Math.min(maxPlanes, (int)costPlanes); var96_166 < 0 && buyThese > 0; --buyThese, var96_166 += n30) {
                    }
                    if (buyThese <= 0) continue;
                    purchase.add(productionRule, buyThese);
                    continue;
                }
                if ((var96_166 -= n30) <= 0) continue;
                purchase.add(productionRule, 1);
                ++unitCount;
            }
        }
        bestAttack.clear();
        bestDefense.clear();
        bestTransport.clear();
        bestMaxUnits.clear();
        bestMobileAttack.clear();
        if (unitCount < totProd && var96_166 > 2) {
            int n31;
            SUtils.findPurchaseMix(bestAttack, bestDefense, bestTransport, bestMaxUnits, bestMobileAttack, landProductionRules, PULand, maxBuy, data, player, fighterPresent);
            int buyThese = 0;
            boolean bl10 = true;
            if (Math.random() <= 0.65 || isLand && Math.random() > 0.8) {
                int n32 = 2;
            }
            if (Math.random() >= 0.25 && factoryCount >= 2 || nonCapitolFactoryThreat && Math.random() < 0.75) {
                int n33 = 3;
            }
            if (isAmphib && Math.random() < 0.9 || Math.random() < 0.25) {
                if (bestTransport.totalValues() + 3 >= bestMaxUnits.totalValues() && bestTransport.totalValues() > 0) {
                    int n34 = 4;
                } else {
                    int n35 = 3;
                }
            }
            if (!isAmphib && minDistanceToEnemy >= 4 && Math.random() >= 0.1 || minDistanceToEnemy >= 2 && Math.random() >= 0.85) {
                n31 = 5;
            }
            for (ProductionRule productionRule : landProductionRules) {
                int numToBuy;
                switch (n31) {
                    case 1: {
                        buyThese = bestAttack.getInt(productionRule);
                        break;
                    }
                    case 2: {
                        buyThese = bestDefense.getInt(productionRule);
                        break;
                    }
                    case 3: {
                        buyThese = bestMaxUnits.getInt(productionRule);
                        break;
                    }
                    case 4: {
                        buyThese = bestTransport.getInt(productionRule);
                        break;
                    }
                    case 5: {
                        buyThese = bestMobileAttack.getInt(productionRule);
                    }
                }
                int cost = productionRule.getCosts().getInt(pus);
                for (numToBuy = 0; unitCount < totProd && var96_167 >= 0 && var96_167 >= cost && PULand >= cost && numToBuy < buyThese; ++unitCount, var96_167 -= cost, PULand -= cost, ++numToBuy) {
                }
                purchase.add(productionRule, numToBuy);
            }
        }
        if (unitCount < totProd && var96_167 > 0) {
            for (ProductionRule productionRule : rules) {
                int actualPNum;
                UnitType intResults;
                NamedAttachable namedAttachable;
                void var96_168;
                int n36 = productionRule.getCosts().getInt(pus);
                if (var96_168 < n36 || unitCount >= totProd || n36 < 1 || !((namedAttachable = productionRule.getResults().keySet().iterator().next()) instanceof UnitType) || Matches.UnitTypeIsSeaOrAir.match(intResults = (UnitType)namedAttachable) || Matches.UnitTypeIsInfrastructure.match(intResults) || Matches.UnitTypeIsAAforAnything.match(intResults) || n36 > var96_168 || unitCount >= totProd) continue;
                int purchaseNum = totProd - unitCount;
                void numLand = var96_168 / n36;
                var96_168 -= n36 * actualPNum;
                for (actualPNum = Math.min(purchaseNum, (int)numLand); var96_168 < 0 && actualPNum > 0; --actualPNum, var96_168 += n36) {
                }
                if (actualPNum <= 0) continue;
                purchase.add(productionRule, actualPNum);
                unitCount += actualPNum;
            }
        }
        long now = System.currentTimeMillis();
        s_logger.finest("Time Taken " + (now - last));
        purchaseDelegate.purchase(purchase);
    }

    @Override
    protected void place(boolean bid, IAbstractPlaceDelegate placeDelegate, GameData data, PlayerID player) {
        RulesAttachment ra;
        long last = System.currentTimeMillis();
        s_logger.fine("Doing Placement ");
        if (player.getUnits().isEmpty()) {
            return;
        }
        this.setImpassableTerrs(player);
        Collection<Territory> impassableTerrs = this.getImpassableTerrs();
        BattleDelegate delegate = DelegateFinder.battleDelegate(data);
        boolean tFirst = this.transportsMayDieFirst();
        CompositeMatchAnd ownedUnit = new CompositeMatchAnd(Matches.unitIsOwnedBy(player));
        CompositeMatchAnd<Unit> attackUnit = new CompositeMatchAnd<Unit>(Matches.UnitIsSea, Matches.UnitIsNotTransport);
        CompositeMatchAnd<Unit> transUnit = new CompositeMatchAnd<Unit>(Matches.UnitIsTransport);
        CompositeMatchAnd enemyUnit = new CompositeMatchAnd(Matches.enemyUnit(player, data));
        CompositeMatchAnd<Unit> enemyAttackUnit = new CompositeMatchAnd<Unit>(attackUnit, enemyUnit);
        CompositeMatchAnd<Unit> ourFactory = new CompositeMatchAnd<Unit>(ownedUnit, Matches.UnitCanProduceUnits);
        CompositeMatchAnd<Unit> landUnit = new CompositeMatchAnd<Unit>(ownedUnit, Matches.UnitIsLand, Matches.UnitIsNotInfrastructure, Matches.UnitCanNotProduceUnits);
        Territory capitol = TerritoryAttachment.getFirstOwnedCapitalOrFirstUnownedCapital(player, data);
        List<Territory> factoryTerritories = Match.getMatches(SUtils.findUnitTerr(data, player, ourFactory), Matches.isTerritoryOwnedBy(player));
        factoryTerritories.removeAll(impassableTerrs);
        if (bid) {
            ArrayList<Territory> ourFriendlyTerr = new ArrayList<Territory>();
            ArrayList<Territory> ourEnemyTerr = new ArrayList<Territory>();
            ArrayList<Territory> ourSemiRankedBidTerrs = new ArrayList<Territory>();
            List<Territory> ourTerrs = SUtils.allOurTerritories(data, player);
            ourTerrs.remove(capitol);
            HashMap<Territory, Float> rankMap = SUtils.rankTerritories(data, ourFriendlyTerr, ourEnemyTerr, null, player, tFirst, false, true);
            List<Territory> ourTerrWithEnemyNeighbors = SUtils.getTerritoriesWithEnemyNeighbor(data, player, false, false);
            SUtils.reorder(ourTerrWithEnemyNeighbors, rankMap, true);
            if (ourTerrWithEnemyNeighbors.contains(capitol)) {
                ourTerrWithEnemyNeighbors.remove(capitol);
                ourTerrWithEnemyNeighbors.add(capitol);
            }
            Territory bidLandTerr = null;
            if (ourTerrWithEnemyNeighbors.size() > 0) {
                bidLandTerr = ourTerrWithEnemyNeighbors.get(0);
            }
            if (bidLandTerr == null) {
                bidLandTerr = capitol;
            }
            if (player.getUnits().someMatch(Matches.UnitIsSea)) {
                Territory checkSeaTerr;
                Territory bidSeaTerr = null;
                Territory bidTransTerr = null;
                CompositeMatchAnd<Territory> waterFactoryWaterTerr = new CompositeMatchAnd<Territory>(Matches.TerritoryIsWater, Matches.territoryHasOwnedNeighborWithOwnedUnitMatching(data, player, Matches.UnitCanProduceUnits));
                List<Territory> enemySeaTerr = SUtils.findUnitTerr(data, player, enemyAttackUnit);
                List<Territory> isWaterTerr = SUtils.onlyWaterTerr(data, enemySeaTerr);
                enemySeaTerr.retainAll(isWaterTerr);
                Territory maxEnemySeaTerr = null;
                int maxUnits = 0;
                for (Territory seaTerr : enemySeaTerr) {
                    int unitCount = seaTerr.getUnits().countMatches(enemyAttackUnit);
                    if (unitCount <= maxUnits) continue;
                    maxUnits = unitCount;
                    maxEnemySeaTerr = seaTerr;
                }
                Route seaRoute = SUtils.findNearest(maxEnemySeaTerr, waterFactoryWaterTerr, Matches.TerritoryIsWater, data);
                if (seaRoute != null && (checkSeaTerr = seaRoute.getEnd()) != null) {
                    float bStrength;
                    float seaStrength = SUtils.getStrengthOfPotentialAttackers(checkSeaTerr, data, player, tFirst, false, null);
                    float aStrength = SUtils.strength(checkSeaTerr.getUnits().getUnits(), false, true, tFirst);
                    float totStrength = aStrength + (bStrength = SUtils.strength(player.getUnits().getMatches(attackUnit), false, true, tFirst));
                    if (totStrength > 0.9f * seaStrength) {
                        bidSeaTerr = checkSeaTerr;
                    }
                }
                for (Territory factCheck : factoryTerritories) {
                    if (bidSeaTerr == null) {
                        bidSeaTerr = SUtils.findASeaTerritoryToPlaceOn(factCheck, data, player, tFirst);
                    }
                    if (bidTransTerr != null) continue;
                    bidTransTerr = SUtils.findASeaTerritoryToPlaceOn(factCheck, data, player, tFirst);
                }
                this.placeSeaUnits(bid, data, bidSeaTerr, bidSeaTerr, placeDelegate, player);
            }
            if (player.getUnits().someMatch(Matches.UnitIsNotSea)) {
                ourSemiRankedBidTerrs.addAll(ourTerrWithEnemyNeighbors);
                ourTerrs.removeAll(ourTerrWithEnemyNeighbors);
                Collections.shuffle(ourTerrs);
                ourSemiRankedBidTerrs.addAll(ourTerrs);
                for (Territory noRouteTerr : ourTerrs) {
                    if (SUtils.distanceToEnemy(noRouteTerr, data, player, false) >= 1 || TerritoryAttachment.getProduction(noRouteTerr) >= 3) continue;
                    ourSemiRankedBidTerrs.remove(noRouteTerr);
                }
                List<Territory> isWaterTerr = SUtils.onlyWaterTerr(data, ourSemiRankedBidTerrs);
                ourSemiRankedBidTerrs.removeAll(isWaterTerr);
                ourSemiRankedBidTerrs.removeAll(impassableTerrs);
                int maxBidPerTerritory = 5;
                for (int bidCycle = 0; !player.getUnits().isEmpty() && bidCycle < 5; ++bidCycle) {
                    for (int i = 0; i <= ourSemiRankedBidTerrs.size() - 1; ++i) {
                        bidLandTerr = (Territory)ourSemiRankedBidTerrs.get(i);
                        this.placeAllWeCanOn(bid, data, null, bidLandTerr, placeDelegate, player);
                    }
                }
                if (!player.getUnits().isEmpty()) {
                    this.placeAllWeCanOn(bid, data, null, capitol, placeDelegate, player);
                }
            }
            return;
        }
        this.determineCapDanger(player, data);
        Territory specSeaTerr = this.getSeaTerr();
        boolean capDanger = this.getCapDanger();
        Territory factTerr = this.getFactory();
        if (factTerr != null) {
            this.placeAllWeCanOn(bid, data, factTerr, factTerr, placeDelegate, player);
        }
        if (capDanger && !impassableTerrs.contains(capitol)) {
            this.placeAllWeCanOn(bid, data, capitol, capitol, placeDelegate, player);
        }
        if ((ra = (RulesAttachment)player.getAttachment("rulesAttatchment")) != null && ra.getPlacementAnyTerritory() || bid) {
            factoryTerritories.addAll(SUtils.allOurTerritories(data, player));
        }
        ArrayList<Territory> cloneFactTerritories = new ArrayList<Territory>(factoryTerritories);
        for (Territory deleteBad : cloneFactTerritories) {
            if (!delegate.getBattleTracker().wasConquered(deleteBad)) continue;
            factoryTerritories.remove(deleteBad);
        }
        int minDist = 100;
        if (!factoryTerritories.contains(capitol)) {
            factoryTerritories.add(capitol);
        }
        factoryTerritories.removeAll(impassableTerrs);
        Territory seaPlaceAtTrans = null;
        Territory seaPlaceAtAttack = null;
        Territory landFactTerr = null;
        IntegerMap<Territory> landUnitFactories = new IntegerMap<Territory>();
        IntegerMap<Territory> transportFactories = new IntegerMap<Territory>();
        IntegerMap<Territory> seaAttackUnitFactories = new IntegerMap<Territory>();
        Route goRoute = new Route();
        int transUnitCount = player.getUnits().countMatches(transUnit);
        int seaAttackUnitCount = player.getUnits().countMatches(attackUnit);
        int fighterUnitCount = player.getUnits().countMatches(Matches.UnitCanLandOnCarrier);
        int carrierUnitCount = player.getUnits().countMatches(Matches.UnitIsCarrier);
        List<Territory> transTerr = SUtils.findTersWithUnitsMatching(data, player, Matches.UnitIsTransport);
        ArrayList<Territory> landNeighbors = new ArrayList<Territory>();
        for (Territory tT : transTerr) {
            landNeighbors.addAll(SUtils.getNeighboringLandTerritories(data, player, tT));
        }
        landNeighbors.retainAll(factoryTerritories);
        int maxUnits = 0;
        Territory maxUnitTerr = null;
        for (Territory unitFact : factoryTerritories) {
            int thisFactUnitCount = unitFact.getUnits().countMatches(landUnit);
            if (thisFactUnitCount > maxUnits) {
                maxUnits = thisFactUnitCount;
                maxUnitTerr = unitFact;
            }
            if (SUtils.landRouteToEnemyCapital(unitFact, goRoute, data, player)) {
                landUnitFactories.put(unitFact, 1);
                continue;
            }
            if (landNeighbors.contains(unitFact)) {
                landUnitFactories.put(unitFact, 2);
                continue;
            }
            landUnitFactories.put(unitFact, 0);
            transportFactories.put(unitFact, 0);
            seaAttackUnitFactories.put(unitFact, 0);
        }
        if (transportFactories.size() == 0) {
            for (Territory unitFact2 : factoryTerritories) {
                int shipThreat = SUtils.shipThreatToTerr(unitFact2, data, player, tFirst);
                if (tFirst && shipThreat < 2 && unitFact2 == maxUnitTerr) {
                    transportFactories.put(unitFact2, 2);
                    continue;
                }
                if (!tFirst && shipThreat <= 0 && unitFact2 == maxUnitTerr) {
                    transportFactories.put(unitFact2, 2);
                    continue;
                }
                if (!SUtils.isWaterAt(unitFact2, data) || Matches.territoryHasEnemyLandNeighbor(data, player).match(unitFact2)) continue;
                transportFactories.put(unitFact2, 0);
            }
        }
        if (seaAttackUnitFactories.size() == 0) {
            for (Territory unitFact3 : factoryTerritories) {
                if (!SUtils.isWaterAt(unitFact3, data)) continue;
                seaAttackUnitFactories.put(unitFact3, 0);
            }
        }
        ArrayList landFactories = new ArrayList(landUnitFactories.keySet());
        ArrayList<Territory> landRouteFactories = new ArrayList<Territory>();
        for (Territory landCheck : landFactories) {
            float totThreat = SUtils.getStrengthOfPotentialAttackers(landCheck, data, player, tFirst, false, null);
            float myStrength = SUtils.strength(landCheck.getUnits().getUnits(), false, false, tFirst);
            boolean landRoute = SUtils.landRouteToEnemyCapital(landCheck, goRoute, data, player);
            if (landCheck == capitol && totThreat > myStrength) {
                landUnitFactories.put(landCheck, 4);
                continue;
            }
            if (landCheck != capitol && totThreat > myStrength && !capDanger) {
                landUnitFactories.put(landCheck, 4);
                continue;
            }
            if (totThreat > myStrength + 5.0f) {
                landUnitFactories.put(landCheck, 3);
                continue;
            }
            if (totThreat - myStrength > -10.0f && totThreat > 8.0f) {
                landUnitFactories.put(landCheck, 1);
                landRouteFactories.add(landCheck);
                continue;
            }
            if (!landRoute) continue;
            landRouteFactories.add(landCheck);
        }
        Territory minTerr = null;
        for (Territory landCheck2 : landRouteFactories) {
            boolean landRoute2 = SUtils.landRouteToEnemyCapital(landCheck2, goRoute, data, player);
            goRoute = null;
            goRoute = SUtils.findNearest(landCheck2, Matches.territoryIsEnemyNonNeutralAndHasEnemyUnitMatching(data, player, Matches.UnitCanProduceUnits), Matches.TerritoryIsNotImpassableToLandUnits(player, data), data);
            if (landRoute2 && goRoute != null) {
                int lRDist = goRoute.getLength();
                if (lRDist >= minDist) continue;
                landUnitFactories.put(landCheck2, 1);
                minDist = lRDist;
                minTerr = landCheck2;
                continue;
            }
            if (goRoute == null) continue;
            landUnitFactories.put(landCheck2, 1);
        }
        if (minTerr != null) {
            landUnitFactories.put(minTerr, 3);
        }
        Set transFactories = transportFactories.keySet();
        float carrierFighterAddOn = 0.0f;
        if (carrierUnitCount > 0 && fighterUnitCount > 0) {
            carrierFighterAddOn += (float)fighterUnitCount * 3.5f;
        }
        if (transFactories.size() == 1 && seaAttackUnitFactories.size() == 1) {
            for (Territory oneFact : transFactories) {
                Territory checkFirst = SUtils.findASeaTerritoryToPlaceOn(oneFact, data, player, tFirst);
                seaPlaceAtTrans = SUtils.getSafestWaterTerr(oneFact, null, null, data, player, false, tFirst);
                if (checkFirst != null) {
                    float oneStrength = SUtils.getStrengthOfPotentialAttackers(checkFirst, data, player, tFirst, false, null);
                    float ourOneStrength = SUtils.strength(checkFirst.getUnits().getUnits(), false, true, tFirst);
                    if ((ourOneStrength += SUtils.strength(player.getUnits().getMatches(attackUnit), false, true, tFirst)) > oneStrength) {
                        seaPlaceAtTrans = checkFirst;
                    }
                }
                seaPlaceAtAttack = seaPlaceAtTrans;
            }
        } else if (transFactories.size() > 0) {
            for (Territory transCheck : transFactories) {
                float eSeaStrength;
                int unitsHere = transCheck.getUnits().countMatches(landUnit);
                Territory dropHere = SUtils.getSafestWaterTerr(transCheck, null, null, data, player, false, tFirst);
                if (dropHere == null || ((eSeaStrength = SUtils.getStrengthOfPotentialAttackers(dropHere, data, player, tFirst, true, null)) != 0.0f || unitsHere <= transUnitCount * 2) && (!(eSeaStrength > 5.0f) || !dropHere.getUnits().someMatch(Matches.UnitIsSea))) continue;
                seaPlaceAtTrans = dropHere;
                seaPlaceAtAttack = dropHere;
            }
        }
        Territory tempTerr = null;
        if (seaPlaceAtAttack == null) {
            Set seaAttackFactories = seaAttackUnitFactories.keySet();
            for (Territory checkAgain : seaAttackFactories) {
                int attackAdv = SUtils.shipThreatToTerr(checkAgain, data, player, tFirst);
                if (attackAdv <= 0 || (tempTerr = SUtils.getSafestWaterTerr(checkAgain, null, null, data, player, false, tFirst)) == null || attackAdv - 1 >= seaAttackUnitCount + tempTerr.getUnits().getMatches(attackUnit).size()) continue;
                seaPlaceAtAttack = tempTerr;
            }
        }
        Territory tmpSeaLoc = null;
        if (specSeaTerr != null) {
            tmpSeaLoc = SUtils.findASeaTerritoryToPlaceOn(specSeaTerr, data, player, tFirst);
        }
        if (tmpSeaLoc != null) {
            seaPlaceAtAttack = tmpSeaLoc;
        }
        if (!bid && capDanger) {
            landUnitFactories.put(capitol, 3);
        }
        landFactories.clear();
        landFactories.addAll(landUnitFactories.keySet());
        if (landUnitFactories.size() == 1) {
            Iterator<Object> i$ = landFactories.iterator();
            while (i$.hasNext()) {
                Territory theOne;
                seaPlaceAtTrans = landFactTerr = (theOne = (Territory)i$.next());
                seaPlaceAtAttack = landFactTerr;
                this.placeSeaUnits(bid, data, seaPlaceAtAttack, seaPlaceAtTrans, placeDelegate, player);
                this.placeAllWeCanOn(bid, data, null, landFactTerr, placeDelegate, player);
            }
        } else {
            for (int i = 4; i >= 0; --i) {
                for (Territory whichOne : landFactories) {
                    if (landUnitFactories.getInt(whichOne) != i) continue;
                    landFactTerr = whichOne;
                    if (seaPlaceAtTrans == null) {
                        Route whichRoute = SUtils.findNearest(whichOne, Matches.territoryHasEnemyLandNeighbor(data, player), Matches.TerritoryIsNotImpassableToLandUnits(player, data), data);
                        seaPlaceAtTrans = !Matches.territoryHasEnemyLandNeighbor(data, player).match(whichOne) && whichRoute != null && whichRoute.getLength() < 4 ? whichOne : capitol;
                    }
                    if (seaPlaceAtAttack == null) {
                        seaPlaceAtAttack = capitol;
                    }
                    this.placeSeaUnits(bid, data, seaPlaceAtAttack, seaPlaceAtTrans, placeDelegate, player);
                    this.placeAllWeCanOn(bid, data, null, landFactTerr, placeDelegate, player);
                }
            }
        }
        Collections.shuffle(factoryTerritories);
        for (Territory t : factoryTerritories) {
            Territory seaPlaceAt = SUtils.findASeaTerritoryToPlaceOn(t, data, player, tFirst);
            if (seaPlaceAt == null) {
                seaPlaceAt = seaPlaceAtTrans;
            }
            if (seaPlaceAt == null) {
                seaPlaceAt = t;
            }
            this.placeSeaUnits(bid, data, seaPlaceAt, seaPlaceAt, placeDelegate, player);
            this.placeAllWeCanOn(bid, data, null, t, placeDelegate, player);
        }
        long now = System.currentTimeMillis();
        s_logger.finest("Time Taken " + (now - last));
    }

    private void placeSeaUnits(boolean bid, GameData data, Territory seaPlaceAttack, Territory seaPlaceTrans, IAbstractPlaceDelegate placeDelegate, PlayerID player) {
        CompositeMatchAnd<Unit> attackUnit = new CompositeMatchAnd<Unit>(Matches.UnitIsSea, Matches.UnitIsNotTransport);
        List<Unit> seaUnits = player.getUnits().getMatches(attackUnit);
        List<Unit> transUnits = player.getUnits().getMatches(Matches.UnitIsTransport);
        List<Unit> airUnits = player.getUnits().getMatches(Matches.UnitCanLandOnCarrier);
        List<Unit> carrierUnits = player.getUnits().getMatches(Matches.UnitIsCarrier);
        if (carrierUnits.size() > 0 && airUnits.size() > 0 && (Properties.getProduceFightersOnCarriers(data) || Properties.getLHTRCarrierProductionRules(data) || bid)) {
            int carrierSpace = 0;
            for (Unit carrier1 : carrierUnits) {
                carrierSpace += UnitAttachment.get(carrier1.getType()).getCarrierCapacity();
            }
            Iterator<Unit> airIter = airUnits.iterator();
            while (airIter.hasNext() && carrierSpace > 0) {
                Unit airPlane = airIter.next();
                seaUnits.add(airPlane);
                carrierSpace -= UnitAttachment.get(airPlane.getType()).getCarrierCost();
            }
        }
        if (bid) {
            if (!seaUnits.isEmpty()) {
                this.doPlace(seaPlaceAttack, seaUnits, placeDelegate);
            }
            if (!transUnits.isEmpty()) {
                this.doPlace(seaPlaceTrans, transUnits, placeDelegate);
            }
            return;
        }
        if (seaUnits.isEmpty() && transUnits.isEmpty()) {
            return;
        }
        if (seaPlaceAttack == seaPlaceTrans) {
            seaUnits.addAll(transUnits);
            transUnits.clear();
        }
        PlaceableUnits pu = placeDelegate.getPlaceableUnits(seaUnits, seaPlaceAttack);
        int pLeft = 0;
        if (pu.getErrorMessage() != null) {
            return;
        }
        if (!seaUnits.isEmpty()) {
            pLeft = pu.getMaxUnits();
            if (pLeft == -1) {
                pLeft = Integer.MAX_VALUE;
            }
            int numPlace = Math.min(pLeft, seaUnits.size());
            pLeft -= numPlace;
            List<Unit> toPlace = seaUnits.subList(0, numPlace);
            this.doPlace(seaPlaceAttack, toPlace, placeDelegate);
        }
        if (!transUnits.isEmpty()) {
            PlaceableUnits pu2 = placeDelegate.getPlaceableUnits(transUnits, seaPlaceTrans);
            if (pu2.getErrorMessage() != null) {
                return;
            }
            pLeft = pu2.getMaxUnits();
            if (pLeft == -1) {
                pLeft = Integer.MAX_VALUE;
            }
            int numPlace = Math.min(pLeft, transUnits.size());
            List<Unit> toPlace = transUnits.subList(0, numPlace);
            this.doPlace(seaPlaceTrans, toPlace, placeDelegate);
        }
    }

    private void placeAllWeCanOn(boolean bid, GameData data, Territory factoryPlace, Territory placeAt, IAbstractPlaceDelegate placeDelegate, PlayerID player) {
        CompositeMatchOr<Unit> landOrAir = new CompositeMatchOr<Unit>(Matches.UnitIsAir, Matches.UnitIsLand);
        if (factoryPlace != null) {
            ArrayList<Unit> toPlace = new ArrayList<Unit>(player.getUnits().getMatches(Matches.UnitCanProduceUnitsAndIsConstruction));
            if (toPlace.size() == 1) {
                this.doPlace(factoryPlace, toPlace, placeDelegate);
                this.setFactory(null);
                return;
            }
            if (toPlace.size() > 1) {
                return;
            }
        }
        List<Unit> landUnits = player.getUnits().getMatches(landOrAir);
        Territory capitol = TerritoryAttachment.getFirstOwnedCapitalOrFirstUnownedCapital(player, data);
        PlaceableUnits pu3 = placeDelegate.getPlaceableUnits(landUnits, placeAt);
        if (pu3.getErrorMessage() != null) {
            return;
        }
        int placementLeft3 = pu3.getMaxUnits();
        if (placementLeft3 == -1) {
            placementLeft3 = Integer.MAX_VALUE;
        }
        if (bid) {
            placementLeft3 = 1;
        }
        if (bid && placeAt == capitol) {
            placementLeft3 = 1000;
        }
        if (!landUnits.isEmpty()) {
            int landPlaceCount = Math.min(placementLeft3, landUnits.size());
            placementLeft3 -= landPlaceCount;
            List<Unit> toPlace = landUnits.subList(0, landPlaceCount);
            this.doPlace(placeAt, toPlace, placeDelegate);
        }
    }

    private void doPlace(Territory where, Collection<Unit> toPlace, IAbstractPlaceDelegate del) {
        String message = del.placeUnits(new ArrayList<Unit>(toPlace), where);
        if (message != null) {
            s_logger.fine(message);
            s_logger.fine("Attempt was at:" + where + " with:" + toPlace);
        }
        this.pause();
    }

    @Override
    public boolean shouldBomberBomb(Territory territory) {
        GameData data = this.getPlayerBridge().getGameData();
        PlayerID ePlayer = territory.getOwner();
        List<PlayerID> attackPlayers = SUtils.getEnemyPlayers(data, ePlayer);
        boolean thisIsAnAttack = false;
        for (PlayerID player : attackPlayers) {
            CompositeMatchAnd<Unit> noBomberUnit = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsNotStrategicBomber);
            List<Unit> allAttackUnits = territory.getUnits().getMatches(noBomberUnit);
            if (allAttackUnits.isEmpty()) continue;
            thisIsAnAttack = true;
        }
        return !thisIsAnAttack;
    }

    @Override
    public Unit whatShouldBomberBomb(Territory territory, Collection<Unit> potentialTargets, Collection<Unit> bombers) {
        if (potentialTargets == null || potentialTargets.isEmpty()) {
            return null;
        }
        List<Unit> factories = Match.getMatches(potentialTargets, Matches.UnitCanProduceUnitsAndCanBeDamaged);
        if (factories.isEmpty()) {
            return potentialTargets.iterator().next();
        }
        return (Unit)factories.iterator().next();
    }

    @Override
    public boolean selectAttackSubs(Territory unitTerritory) {
        return true;
    }

    @Override
    public boolean selectAttackUnits(Territory unitTerritory) {
        return true;
    }

    @Override
    public boolean selectAttackTransports(Territory territory) {
        return true;
    }

    @Override
    public Collection<Unit> getNumberOfFightersToMoveToNewCarrier(Collection<Unit> fightersThatCanBeMoved, Territory from) {
        ArrayList<Unit> rVal = new ArrayList<Unit>();
        for (Unit fighter : fightersThatCanBeMoved) {
            rVal.add(fighter);
        }
        return rVal;
    }

    @Override
    public Territory selectTerritoryForAirToLand(Collection<Territory> candidates, Territory currentTerritory, String unitMessage) {
        return candidates.iterator().next();
    }

    @Override
    public boolean confirmMoveInFaceOfAA(Collection<Territory> aaFiringTerritories) {
        return false;
    }

    @Override
    public Territory selectBombardingTerritory(Unit unit, Territory unitTerritory, Collection<Territory> territories, boolean noneAvailable) {
        if (noneAvailable || territories.size() == 0) {
            return null;
        }
        Iterator<Territory> i$ = territories.iterator();
        if (i$.hasNext()) {
            Territory t = i$.next();
            return t;
        }
        return null;
    }

    @Override
    public Territory retreatQuery(GUID battleID, boolean submerge, Territory battleTerritory, Collection<Territory> possibleTerritories, String message) {
        float enemySeaStrength;
        if (battleTerritory == null) {
            return null;
        }
        GameData data = this.getPlayerBridge().getGameData();
        boolean tFirst = this.transportsMayDieFirst();
        boolean attacking = true;
        PlayerID player = this.getPlayerID();
        List<Unit> myUnits = battleTerritory.getUnits().getMatches(Matches.unitIsOwnedBy(player));
        List<Unit> defendingUnits = battleTerritory.getUnits().getMatches(Matches.enemyUnit(player, data));
        if (Matches.TerritoryIsLand.match(battleTerritory)) {
            float enemyStrength;
            float nonRetreatStrength;
            ArrayList<Unit> retreatUnits = new ArrayList<Unit>();
            ArrayList<Unit> nonRetreatUnits = new ArrayList<Unit>();
            for (Unit u : myUnits) {
                if (TripleAUnit.get(u).getWasAmphibious()) {
                    nonRetreatUnits.add(u);
                    continue;
                }
                retreatUnits.add(u);
            }
            float retreatStrength = SUtils.strength(retreatUnits, true, false, false);
            float totalStrength = retreatStrength + (nonRetreatStrength = SUtils.strength(nonRetreatUnits, true, false, false));
            if (totalStrength > (enemyStrength = SUtils.strength(defendingUnits, false, false, false)) * 1.05f) {
                return null;
            }
            Territory retreatTo = null;
            float retreatDiff = 0.0f;
            if (possibleTerritories.size() == 1) {
                retreatTo = possibleTerritories.iterator().next();
            } else {
                ArrayList<Territory> ourFriendlyTerr = new ArrayList<Territory>();
                ArrayList<Territory> ourEnemyTerr = new ArrayList<Territory>();
                HashMap<Territory, Float> rankMap = SUtils.rankTerritories(data, ourFriendlyTerr, ourEnemyTerr, null, player, false, false, true);
                if (ourFriendlyTerr.containsAll(possibleTerritories)) {
                    SUtils.reorder(ourFriendlyTerr, rankMap, true);
                }
                ourFriendlyTerr.retainAll(possibleTerritories);
                Territory myCapital = TerritoryAttachment.getFirstOwnedCapitalOrFirstUnownedCapital(player, data);
                for (Territory capTerr : ourFriendlyTerr) {
                    if (!Matches.territoryIsAlliedAndHasAlliedUnitMatching(data, player, Matches.UnitCanProduceUnits).match(capTerr)) continue;
                    boolean isMyCapital = myCapital.equals(capTerr);
                    float strength1 = SUtils.getStrengthOfPotentialAttackers(capTerr, data, player, false, true, null);
                    float ourstrength = SUtils.strengthOfTerritory(data, capTerr, player, false, false, false, true);
                    if (isMyCapital) {
                        ourstrength = SUtils.strength(player.getUnits().getUnits(), false, false, false);
                    }
                    if (!(ourstrength < strength1) || retreatTo != null && !isMyCapital) continue;
                    retreatTo = capTerr;
                }
                Iterator retreatTerrs = ourFriendlyTerr.iterator();
                if (retreatTo == null) {
                    while (retreatTerrs.hasNext()) {
                        Territory retreatTerr = (Territory)retreatTerrs.next();
                        float existingStrength = SUtils.strength(retreatTerr.getUnits().getUnits(), false, false, false);
                        float eRetreatStrength = SUtils.getStrengthOfPotentialAttackers(retreatTerr, data, player, false, true, null);
                        float firstDiff = eRetreatStrength - existingStrength;
                        if (!(firstDiff < 0.0f)) continue;
                        if ((firstDiff -= retreatStrength) < 0.0f) {
                            if (!(retreatDiff < firstDiff)) continue;
                            retreatTo = retreatTerr;
                            retreatDiff = firstDiff;
                            continue;
                        }
                        if (!(retreatDiff > firstDiff) && retreatTo != null) continue;
                        retreatTo = retreatTerr;
                        retreatDiff = firstDiff;
                    }
                }
            }
            return retreatTo;
        }
        CompositeMatchAnd<Unit> myShip = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsSea, Matches.unitIsNotSubmerged(data));
        CompositeMatchAnd<Unit> myPlane = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsAir);
        CompositeMatchAnd<Unit> enemyAirUnit = new CompositeMatchAnd<Unit>(Matches.enemyUnit(player, data), Matches.UnitIsNotLand);
        CompositeMatchAnd<Unit> enemySeaUnit = new CompositeMatchAnd<Unit>(Matches.enemyUnit(player, data), Matches.UnitIsSea);
        List<Unit> myShips = battleTerritory.getUnits().getMatches(myShip);
        List<Unit> myPlanes = battleTerritory.getUnits().getMatches(myPlane);
        float myShipStrength = SUtils.strength(myShips, true, true, tFirst);
        float myPlaneStrength = SUtils.strength(myPlanes, true, true, tFirst);
        float totalStrength = myShipStrength + myPlaneStrength;
        List<Unit> enemyAirUnits = battleTerritory.getUnits().getMatches(enemyAirUnit);
        List<Unit> enemySeaUnits = battleTerritory.getUnits().getMatches(enemySeaUnit);
        if (submerge && enemySeaUnits.isEmpty() && enemyAirUnits.size() > 0) {
            return battleTerritory;
        }
        float enemyAirStrength = SUtils.strength(enemyAirUnits, false, true, tFirst);
        float enemyStrength = enemyAirStrength + (enemySeaStrength = SUtils.strength(enemySeaUnits, false, true, tFirst));
        if (enemyStrength > totalStrength + 1.0f) {
            Territory retreatTo = null;
            if (possibleTerritories.size() > 0) {
                retreatTo = possibleTerritories.iterator().next();
            }
            return retreatTo;
        }
        return null;
    }

    @Override
    public HashMap<Territory, Collection<Unit>> scrambleUnitsQuery(Territory scrambleTo, Map<Territory, Tuple<Collection<Unit>, Collection<Unit>>> possibleScramblers) {
        return null;
    }

    @Override
    public Collection<Unit> selectUnitsQuery(Territory current, Collection<Unit> possible, String message) {
        return null;
    }

    @Override
    public int[] selectFixedDice(int numRolls, int hitAt, boolean hitOnlyIfEquals, String message, int diceSides) {
        int[] dice = new int[numRolls];
        for (int i = 0; i < numRolls; ++i) {
            dice[i] = (int)Math.ceil(Math.random() * (double)diceSides);
        }
        return dice;
    }
}

