/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.attatchments;

import games.strategy.engine.data.Attachable;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameParseException;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.annotations.GameProperty;
import games.strategy.engine.data.annotations.InternalDoNotExport;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.engine.random.IRandomStats;
import games.strategy.triplea.attatchments.AbstractConditionsAttachment;
import games.strategy.triplea.attatchments.ICondition;
import games.strategy.triplea.attatchments.RulesAttachment;
import games.strategy.triplea.attatchments.TriggerAttachment;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.triplea.player.ITripleaPlayer;
import games.strategy.util.Match;
import games.strategy.util.Tuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class AbstractTriggerAttachment
extends AbstractConditionsAttachment
implements ICondition {
    private static final long serialVersionUID = 5866039180681962697L;
    public static final String NOTIFICATION = "Notification";
    public static final String AFTER = "after";
    public static final String BEFORE = "before";
    private int m_uses = -1;
    @InternalDoNotExport
    private boolean m_usedThisRound = false;
    private String m_notification = null;
    private ArrayList<Tuple<String, String>> m_when = new ArrayList();
    public static Match<TriggerAttachment> availableUses = new Match<TriggerAttachment>(){

        @Override
        public boolean match(TriggerAttachment t) {
            return t.getUses() != 0;
        }
    };

    public AbstractTriggerAttachment(String name, Attachable attachable, GameData gameData) {
        super(name, attachable, gameData);
    }

    public static CompositeChange triggerSetUsedForThisRound(PlayerID player, IDelegateBridge aBridge) {
        CompositeChange change = new CompositeChange();
        for (TriggerAttachment ta : TriggerAttachment.getTriggers(player, aBridge.getData(), null)) {
            int currentUses;
            if (!ta.getUsedThisRound() || (currentUses = ta.getUses()) <= 0) continue;
            change.add(ChangeFactory.attachmentPropertyChange(ta, Integer.toString(currentUses - 1), "uses"));
            change.add(ChangeFactory.attachmentPropertyChange(ta, false, "usedThisRound"));
        }
        return change;
    }

    @Deprecated
    @GameProperty(xmlProperty=true, gameProperty=false, adds=true)
    public void setTrigger(String conditions) throws GameParseException {
        this.setConditions(conditions);
    }

    @Deprecated
    public List<RulesAttachment> getTrigger() {
        return this.getConditions();
    }

    @Deprecated
    public void clearTrigger() {
        this.clearConditions();
    }

    @Deprecated
    public void resetTrigger() {
        this.resetConditions();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setUses(String s) {
        this.m_uses = AbstractTriggerAttachment.getInt(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setUses(Integer u) {
        this.m_uses = u;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setUses(int u) {
        this.m_uses = u;
    }

    @GameProperty(xmlProperty=false, gameProperty=true, adds=false)
    public void setUsedThisRound(String s) {
        this.m_usedThisRound = AbstractTriggerAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=false, gameProperty=true, adds=false)
    public void setUsedThisRound(boolean usedThisRound) {
        this.m_usedThisRound = usedThisRound;
    }

    @GameProperty(xmlProperty=false, gameProperty=true, adds=false)
    public void setUsedThisRound(Boolean usedThisRound) {
        this.m_usedThisRound = usedThisRound;
    }

    public boolean getUsedThisRound() {
        return this.m_usedThisRound;
    }

    public void resetUsedThisRound() {
        this.m_usedThisRound = false;
    }

    public int getUses() {
        return this.m_uses;
    }

    public void resetUses() {
        this.m_uses = -1;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setWhen(String when) throws GameParseException {
        String[] s = when.split(":");
        if (s.length != 2) {
            throw new GameParseException("when must exist in 2 parts: \"before/after:stepName\"." + this.thisErrorMsg());
        }
        if (!s[0].equals(AFTER) && !s[0].equals(BEFORE)) {
            throw new GameParseException("when must start with: before or after" + this.thisErrorMsg());
        }
        this.m_when.add(new Tuple<String, String>(s[0], s[1]));
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setWhen(ArrayList<Tuple<String, String>> value) {
        this.m_when = value;
    }

    public ArrayList<Tuple<String, String>> getWhen() {
        return this.m_when;
    }

    public void clearWhen() {
        this.m_when.clear();
    }

    public void resetWhen() {
        this.m_when = new ArrayList();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setNotification(String sNotification) {
        if (sNotification == null) {
            this.m_notification = null;
            return;
        }
        this.m_notification = sNotification;
    }

    public String getNotification() {
        return this.m_notification;
    }

    public void resetNotification() {
        this.m_notification = null;
    }

    protected void use(IDelegateBridge aBridge) {
        if (!this.m_usedThisRound && this.m_uses > 0 && this.m_when.isEmpty()) {
            aBridge.addChange(ChangeFactory.attachmentPropertyChange(this, true, "usedThisRound"));
        }
    }

    protected boolean testChance(IDelegateBridge aBridge) {
        int hitTarget = this.getChanceToHit();
        int diceSides = this.getChanceDiceSides();
        if (diceSides <= 0 || hitTarget >= diceSides) {
            this.changeChanceDecrementOrIncrementOnSuccessOrFailure(aBridge, true, false);
            return true;
        }
        if (hitTarget <= 0) {
            this.changeChanceDecrementOrIncrementOnSuccessOrFailure(aBridge, false, false);
            return false;
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        int rollResult = aBridge.getRandom(diceSides, null, IRandomStats.DiceType.ENGINE, "Attempting the Trigger: " + MyFormatter.attachmentNameToText(this.getName())) + 1;
        boolean testChance = rollResult <= hitTarget;
        String notificationMessage = (testChance ? "Trigger Rolling is a Success!" : "Trigger Rolling is a Failure!") + " (Rolled at " + hitTarget + " out of " + diceSides + " Result: " + rollResult + "  for " + MyFormatter.attachmentNameToText(this.getName()) + ")";
        aBridge.getHistoryWriter().startEvent(notificationMessage);
        this.changeChanceDecrementOrIncrementOnSuccessOrFailure(aBridge, testChance, true);
        ((ITripleaPlayer)aBridge.getRemotePlayer(aBridge.getPlayerID())).reportMessage(notificationMessage, notificationMessage);
        return testChance;
    }

    public static Match<TriggerAttachment> isSatisfiedMatch(final HashMap<ICondition, Boolean> testedConditions) {
        return new Match<TriggerAttachment>(){

            @Override
            public boolean match(TriggerAttachment t) {
                return t.isSatisfied(testedConditions);
            }
        };
    }

    public static Match<TriggerAttachment> whenOrDefaultMatch(final String beforeOrAfter, final String stepName) {
        return new Match<TriggerAttachment>(){

            @Override
            public boolean match(TriggerAttachment t) {
                if (beforeOrAfter == null && stepName == null && t.getWhen().isEmpty()) {
                    return true;
                }
                if (beforeOrAfter != null && stepName != null && !t.getWhen().isEmpty()) {
                    for (Tuple<String, String> w : t.getWhen()) {
                        if (!beforeOrAfter.equals(w.getFirst()) || !stepName.equals(w.getSecond())) continue;
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public static Match<TriggerAttachment> notificationMatch() {
        return new Match<TriggerAttachment>(){

            @Override
            public boolean match(TriggerAttachment t) {
                return t.getNotification() != null;
            }
        };
    }

    protected static String getValueFromStringArrayForAllSubStrings(String[] s) {
        StringBuilder sb = new StringBuilder();
        for (String subString : s) {
            sb.append(":");
            sb.append(subString);
        }
        if (sb.length() > 0 && sb.substring(0, 1).equals(":")) {
            sb.replace(0, 1, "");
        }
        return sb.toString();
    }

    protected static String getValueFromStringArrayForAllExceptLastSubstring(String[] s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length - 1; ++i) {
            sb.append(":");
            sb.append(s[i]);
        }
        if (sb.length() > 0 && sb.substring(0, 1).equals(":")) {
            sb.replace(0, 1, "");
        }
        return sb.toString();
    }

    public static int getEachMultiple(AbstractTriggerAttachment t) {
        int eachMultiple = 1;
        for (RulesAttachment condition : t.getConditions()) {
            int tempEach = condition.getEachMultiple();
            if (tempEach <= eachMultiple) continue;
            eachMultiple = tempEach;
        }
        return eachMultiple;
    }

    @Override
    public void validate(GameData data) throws GameParseException {
        super.validate(data);
        if (this.m_conditions == null) {
            throw new GameParseException("must contain at least one condition: " + this.thisErrorMsg());
        }
    }
}

