/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.attatchments;

import games.strategy.engine.data.Attachable;
import games.strategy.engine.data.DefaultAttachment;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameParseException;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.data.annotations.GameProperty;
import games.strategy.triplea.delegate.Matches;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import games.strategy.util.Triple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class PlayerAttachment
extends DefaultAttachment {
    private static final long serialVersionUID = 1880755875866426270L;
    private int m_vps = 0;
    private int m_captureVps = 0;
    private int m_retainCapitalNumber = 1;
    private int m_retainCapitalProduceNumber = 1;
    private ArrayList<PlayerID> m_giveUnitControl = new ArrayList();
    private ArrayList<PlayerID> m_captureUnitOnEnteringBy = new ArrayList();
    private ArrayList<PlayerID> m_shareTechnology = new ArrayList();
    private ArrayList<PlayerID> m_helpPayTechCost = new ArrayList();
    private boolean m_destroysPUs = false;
    private boolean m_immuneToBlockade = false;
    private IntegerMap<Resource> m_suicideAttackResources = new IntegerMap();
    private HashSet<UnitType> m_suicideAttackTargets = null;
    private HashSet<Triple<Integer, String, HashSet<UnitType>>> m_placementLimit = new HashSet();
    private HashSet<Triple<Integer, String, HashSet<UnitType>>> m_movementLimit = new HashSet();
    private HashSet<Triple<Integer, String, HashSet<UnitType>>> m_attackingLimit = new HashSet();

    public static PlayerAttachment get(PlayerID p) {
        PlayerAttachment rVal = (PlayerAttachment)p.getAttachment("playerAttatchment");
        return rVal;
    }

    public static PlayerAttachment get(PlayerID p, String nameOfAttachment) {
        PlayerAttachment rVal = (PlayerAttachment)p.getAttachment(nameOfAttachment);
        if (rVal == null) {
            throw new IllegalStateException("No player attachment for:" + p.getName() + " with name:" + nameOfAttachment);
        }
        return rVal;
    }

    public PlayerAttachment(String name, Attachable attachable, GameData gameData) {
        super(name, attachable, gameData);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setPlacementLimit(String value) throws GameParseException {
        String[] s = value.split(":");
        if (s.length < 3) {
            throw new GameParseException("placementLimit must have 3 parts: count, type, unit list" + this.thisErrorMsg());
        }
        int max = PlayerAttachment.getInt(s[0]);
        if (max < 0) {
            throw new GameParseException("placementLimit count must have a positive number" + this.thisErrorMsg());
        }
        if (!(s[1].equals("owned") || s[1].equals("allied") || s[1].equals("total"))) {
            throw new GameParseException("placementLimit type must be: owned, allied, or total" + this.thisErrorMsg());
        }
        HashSet<UnitType> types = new HashSet<UnitType>();
        if (s[2].equalsIgnoreCase("all")) {
            types.addAll(this.getData().getUnitTypeList().getAllUnitTypes());
        } else {
            for (int i = 2; i < s.length; ++i) {
                UnitType ut = this.getData().getUnitTypeList().getUnitType(s[i]);
                if (ut == null) {
                    throw new GameParseException("No unit called: " + s[i] + this.thisErrorMsg());
                }
                types.add(ut);
            }
        }
        this.m_placementLimit.add(new Triple(max, s[1], types));
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setPlacementLimit(HashSet<Triple<Integer, String, HashSet<UnitType>>> value) {
        this.m_placementLimit = value;
    }

    public HashSet<Triple<Integer, String, HashSet<UnitType>>> getPlacementLimit() {
        return this.m_placementLimit;
    }

    public void clearPlacementLimit() {
        this.m_placementLimit.clear();
    }

    public void resetPlacementLimit() {
        this.m_placementLimit = new HashSet();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setMovementLimit(String value) throws GameParseException {
        String[] s = value.split(":");
        if (s.length < 3) {
            throw new GameParseException("movementLimit must have 3 parts: count, type, unit list" + this.thisErrorMsg());
        }
        int max = PlayerAttachment.getInt(s[0]);
        if (max < 0) {
            throw new GameParseException("movementLimit count must have a positive number" + this.thisErrorMsg());
        }
        if (!(s[1].equals("owned") || s[1].equals("allied") || s[1].equals("total"))) {
            throw new GameParseException("movementLimit type must be: owned, allied, or total" + this.thisErrorMsg());
        }
        HashSet<UnitType> types = new HashSet<UnitType>();
        if (s[2].equalsIgnoreCase("all")) {
            types.addAll(this.getData().getUnitTypeList().getAllUnitTypes());
        } else {
            for (int i = 2; i < s.length; ++i) {
                UnitType ut = this.getData().getUnitTypeList().getUnitType(s[i]);
                if (ut == null) {
                    throw new GameParseException("No unit called: " + s[i] + this.thisErrorMsg());
                }
                types.add(ut);
            }
        }
        this.m_movementLimit.add(new Triple(max, s[1], types));
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setMovementLimit(HashSet<Triple<Integer, String, HashSet<UnitType>>> value) {
        this.m_movementLimit = value;
    }

    public HashSet<Triple<Integer, String, HashSet<UnitType>>> getMovementLimit() {
        return this.m_movementLimit;
    }

    public void clearMovementLimit() {
        this.m_movementLimit.clear();
    }

    public void resetMovementLimit() {
        this.m_movementLimit = new HashSet();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setAttackingLimit(String value) throws GameParseException {
        String[] s = value.split(":");
        if (s.length < 3) {
            throw new GameParseException("attackingLimit must have 3 parts: count, type, unit list" + this.thisErrorMsg());
        }
        int max = PlayerAttachment.getInt(s[0]);
        if (max < 0) {
            throw new GameParseException("attackingLimit count must have a positive number" + this.thisErrorMsg());
        }
        if (!(s[1].equals("owned") || s[1].equals("allied") || s[1].equals("total"))) {
            throw new GameParseException("attackingLimit type must be: owned, allied, or total" + this.thisErrorMsg());
        }
        HashSet<UnitType> types = new HashSet<UnitType>();
        if (s[2].equalsIgnoreCase("all")) {
            types.addAll(this.getData().getUnitTypeList().getAllUnitTypes());
        } else {
            for (int i = 2; i < s.length; ++i) {
                UnitType ut = this.getData().getUnitTypeList().getUnitType(s[i]);
                if (ut == null) {
                    throw new GameParseException("No unit called: " + s[i] + this.thisErrorMsg());
                }
                types.add(ut);
            }
        }
        this.m_attackingLimit.add(new Triple(max, s[1], types));
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAttackingLimit(HashSet<Triple<Integer, String, HashSet<UnitType>>> value) {
        this.m_attackingLimit = value;
    }

    public HashSet<Triple<Integer, String, HashSet<UnitType>>> getAttackingLimit() {
        return this.m_attackingLimit;
    }

    public void clearAttackingLimit() {
        this.m_attackingLimit.clear();
    }

    public void resetAttackingLimit() {
        this.m_attackingLimit = new HashSet();
    }

    public static boolean getCanTheseUnitsMoveWithoutViolatingStackingLimit(String limitType, Collection<Unit> unitsMoving, Territory toMoveInto, PlayerID owner, GameData data) {
        HashSet<Triple<Integer, String, HashSet<UnitType>>> stackingLimits;
        PlayerAttachment pa = PlayerAttachment.get(owner);
        if (pa == null) {
            return true;
        }
        if (limitType.equals("movementLimit")) {
            stackingLimits = pa.getMovementLimit();
        } else if (limitType.equals("attackingLimit")) {
            stackingLimits = pa.getAttackingLimit();
        } else if (limitType.equals("placementLimit")) {
            stackingLimits = pa.getPlacementLimit();
        } else {
            throw new IllegalStateException("getCanTheseUnitsMoveWithoutViolatingStackingLimit does not allow limitType: " + limitType);
        }
        if (stackingLimits.isEmpty()) {
            return true;
        }
        for (Triple<Integer, String, HashSet<UnitType>> currentLimit : stackingLimits) {
            ArrayList<Unit> copyUnitsMoving = new ArrayList<Unit>(unitsMoving);
            int max = (Integer)currentLimit.getFirst();
            String type = (String)currentLimit.getSecond();
            HashSet<UnitType> unitsToTest = currentLimit.getThird();
            Collection<Unit> currentInTerritory = toMoveInto.getUnits().getUnits();
            if (type.equals("owned")) {
                currentInTerritory.removeAll(Match.getMatches(currentInTerritory, Matches.unitIsOwnedBy(owner).invert()));
                copyUnitsMoving.removeAll(Match.getMatches(copyUnitsMoving, Matches.unitIsOwnedBy(owner).invert()));
            } else if (type.equals("allied")) {
                currentInTerritory.removeAll(Match.getMatches(currentInTerritory, Matches.alliedUnit(owner, data).invert()));
                copyUnitsMoving.removeAll(Match.getMatches(copyUnitsMoving, Matches.alliedUnit(owner, data).invert()));
            }
            currentInTerritory.retainAll(Match.getMatches(currentInTerritory, Matches.unitIsOfTypes(unitsToTest)));
            copyUnitsMoving.retainAll(Match.getMatches(copyUnitsMoving, Matches.unitIsOfTypes(unitsToTest)));
            if (max >= currentInTerritory.size() + copyUnitsMoving.size()) continue;
            return false;
        }
        return true;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setSuicideAttackTargets(String value) throws GameParseException {
        String[] s;
        if (value == null) {
            this.m_suicideAttackTargets = null;
            return;
        }
        if (this.m_suicideAttackTargets == null) {
            this.m_suicideAttackTargets = new HashSet();
        }
        for (String u : s = value.split(":")) {
            UnitType ut = this.getData().getUnitTypeList().getUnitType(u);
            if (ut == null) {
                throw new GameParseException("suicideAttackTargets: no such unit called " + u + this.thisErrorMsg());
            }
            this.m_suicideAttackTargets.add(ut);
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setSuicideAttackTargets(HashSet<UnitType> value) {
        this.m_suicideAttackTargets = value;
    }

    public HashSet<UnitType> getSuicideAttackTargets() {
        return this.m_suicideAttackTargets;
    }

    public void clearSuicideAttackTargets() {
        this.m_suicideAttackTargets.clear();
    }

    public void resetSuicideAttackTargets() {
        this.m_suicideAttackTargets = null;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setSuicideAttackResources(String value) throws GameParseException {
        String[] s = value.split(":");
        if (s.length != 2) {
            throw new GameParseException("suicideAttackResources must have exactly 2 fields" + this.thisErrorMsg());
        }
        int attackValue = PlayerAttachment.getInt(s[0]);
        if (attackValue < 0) {
            throw new GameParseException("suicideAttackResources attack value must be positive" + this.thisErrorMsg());
        }
        Resource r = this.getData().getResourceList().getResource(s[1]);
        if (r == null) {
            throw new GameParseException("no such resource: " + s[1] + this.thisErrorMsg());
        }
        this.m_suicideAttackResources.put(r, attackValue);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setSuicideAttackResources(IntegerMap<Resource> value) {
        this.m_suicideAttackResources = value;
    }

    public IntegerMap<Resource> getSuicideAttackResources() {
        return this.m_suicideAttackResources;
    }

    public void clearSuicideAttackResources() {
        this.m_suicideAttackResources.clear();
    }

    public void resetSuicideAttackResources() {
        this.m_suicideAttackResources = new IntegerMap();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setVps(String value) {
        this.m_vps = PlayerAttachment.getInt(value);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setVps(Integer value) {
        this.m_vps = value;
    }

    public int getVps() {
        return this.m_vps;
    }

    public void resetVps() {
        this.m_vps = 0;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCaptureVps(String value) {
        this.m_captureVps = PlayerAttachment.getInt(value);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCaptureVps(Integer value) {
        this.m_captureVps = value;
    }

    public int getCaptureVps() {
        return this.m_captureVps;
    }

    public void resetCaptureVps() {
        this.m_captureVps = 0;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setRetainCapitalNumber(String value) {
        this.m_retainCapitalNumber = PlayerAttachment.getInt(value);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setRetainCapitalNumber(Integer value) {
        this.m_retainCapitalNumber = value;
    }

    public int getRetainCapitalNumber() {
        return this.m_retainCapitalNumber;
    }

    public void resetRetainCapitalNumber() {
        this.m_retainCapitalNumber = 1;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setRetainCapitalProduceNumber(String value) {
        this.m_retainCapitalProduceNumber = PlayerAttachment.getInt(value);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setRetainCapitalProduceNumber(Integer value) {
        this.m_retainCapitalProduceNumber = value;
    }

    public int getRetainCapitalProduceNumber() {
        return this.m_retainCapitalProduceNumber;
    }

    public void resetRetainCapitalProduceNumber() {
        this.m_retainCapitalProduceNumber = 1;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setGiveUnitControl(String value) throws GameParseException {
        String[] temp;
        for (String name : temp = value.split(":")) {
            PlayerID tempPlayer = this.getData().getPlayerList().getPlayerID(name);
            if (tempPlayer != null) {
                this.m_giveUnitControl.add(tempPlayer);
                continue;
            }
            if (name.equalsIgnoreCase("true") || name.equalsIgnoreCase("false")) {
                this.m_giveUnitControl.clear();
                continue;
            }
            throw new GameParseException("No player named: " + name + this.thisErrorMsg());
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setGiveUnitControl(ArrayList<PlayerID> value) {
        this.m_giveUnitControl = value;
    }

    public ArrayList<PlayerID> getGiveUnitControl() {
        return this.m_giveUnitControl;
    }

    public void clearGiveUnitControl() {
        this.m_giveUnitControl.clear();
    }

    public void resetGiveUnitControl() {
        this.m_giveUnitControl = new ArrayList();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setCaptureUnitOnEnteringBy(String value) throws GameParseException {
        String[] temp;
        for (String name : temp = value.split(":")) {
            PlayerID tempPlayer = this.getData().getPlayerList().getPlayerID(name);
            if (tempPlayer == null) {
                throw new GameParseException("No player named: " + name + this.thisErrorMsg());
            }
            this.m_captureUnitOnEnteringBy.add(tempPlayer);
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCaptureUnitOnEnteringBy(ArrayList<PlayerID> value) {
        this.m_captureUnitOnEnteringBy = value;
    }

    public ArrayList<PlayerID> getCaptureUnitOnEnteringBy() {
        return this.m_captureUnitOnEnteringBy;
    }

    public void clearCaptureUnitOnEnteringBy() {
        this.m_captureUnitOnEnteringBy.clear();
    }

    public void resetCaptureUnitOnEnteringBy() {
        this.m_captureUnitOnEnteringBy = new ArrayList();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setShareTechnology(String value) throws GameParseException {
        String[] temp;
        for (String name : temp = value.split(":")) {
            PlayerID tempPlayer = this.getData().getPlayerList().getPlayerID(name);
            if (tempPlayer == null) {
                throw new GameParseException("No player named: " + name + this.thisErrorMsg());
            }
            this.m_shareTechnology.add(tempPlayer);
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setShareTechnology(ArrayList<PlayerID> value) {
        this.m_shareTechnology = value;
    }

    public ArrayList<PlayerID> getShareTechnology() {
        return this.m_shareTechnology;
    }

    public void clearShareTechnology() {
        this.m_shareTechnology.clear();
    }

    public void resetShareTechnology() {
        this.m_shareTechnology = new ArrayList();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setHelpPayTechCost(String value) throws GameParseException {
        String[] temp;
        for (String name : temp = value.split(":")) {
            PlayerID tempPlayer = this.getData().getPlayerList().getPlayerID(name);
            if (tempPlayer == null) {
                throw new GameParseException("No player named: " + name + this.thisErrorMsg());
            }
            this.m_helpPayTechCost.add(tempPlayer);
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setHelpPayTechCost(ArrayList<PlayerID> value) {
        this.m_helpPayTechCost = value;
    }

    public ArrayList<PlayerID> getHelpPayTechCost() {
        return this.m_helpPayTechCost;
    }

    public void clearHelpPayTechCost() {
        this.m_helpPayTechCost.clear();
    }

    public void resetHelpPayTechCost() {
        this.m_helpPayTechCost = new ArrayList();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setDestroysPUs(String value) {
        this.m_destroysPUs = PlayerAttachment.getBool(value);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setDestroysPUs(Boolean value) {
        this.m_destroysPUs = value;
    }

    public boolean getDestroysPUs() {
        return this.m_destroysPUs;
    }

    public void resetDestroysPUs() {
        this.m_destroysPUs = false;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setImmuneToBlockade(String value) {
        this.m_immuneToBlockade = PlayerAttachment.getBool(value);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setImmuneToBlockade(Boolean value) {
        this.m_immuneToBlockade = value;
    }

    public boolean getImmuneToBlockade() {
        return this.m_immuneToBlockade;
    }

    public void resetImmuneToBlockade() {
        this.m_immuneToBlockade = false;
    }

    @Override
    public void validate(GameData data) throws GameParseException {
    }

    @Deprecated
    @GameProperty(xmlProperty=true, gameProperty=false, adds=false)
    public void setTakeUnitControl(String value) {
    }
}

