/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.attatchments;

import games.strategy.engine.data.Attachable;
import games.strategy.engine.data.DefaultAttachment;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameParseException;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.data.annotations.GameProperty;
import games.strategy.engine.data.annotations.InternalDoNotExport;
import games.strategy.triplea.Properties;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.GenericTechAdvance;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.TechAdvance;
import games.strategy.triplea.delegate.TechTracker;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TechAbilityAttachment
extends DefaultAttachment {
    private static final long serialVersionUID = 1866305599625384294L;
    public static final String ABILITY_CAN_BLITZ = "canBlitz";
    public static final String ABILITY_CAN_BOMBARD = "canBombard";
    private IntegerMap<UnitType> m_attackBonus = new IntegerMap();
    private IntegerMap<UnitType> m_defenseBonus = new IntegerMap();
    private IntegerMap<UnitType> m_movementBonus = new IntegerMap();
    private IntegerMap<UnitType> m_radarBonus = new IntegerMap();
    private IntegerMap<UnitType> m_airAttackBonus = new IntegerMap();
    private IntegerMap<UnitType> m_airDefenseBonus = new IntegerMap();
    private IntegerMap<UnitType> m_productionBonus = new IntegerMap();
    private int m_minimumTerritoryValueForProductionBonus = -1;
    private int m_repairDiscount = -1;
    private int m_warBondDiceSides = -1;
    private int m_warBondDiceNumber = 0;
    private IntegerMap<UnitType> m_rocketDiceNumber = new IntegerMap();
    private int m_rocketDistance = 0;
    private int m_rocketNumberPerTerritory = 0;
    private HashMap<UnitType, HashSet<String>> m_unitAbilitiesGained = new HashMap();
    private boolean m_airborneForces = false;
    private IntegerMap<UnitType> m_airborneCapacity = new IntegerMap();
    private HashSet<UnitType> m_airborneTypes = new HashSet();
    private int m_airborneDistance = 0;
    private HashSet<UnitType> m_airborneBases = new HashSet();
    private HashMap<String, HashSet<UnitType>> m_airborneTargettedByAA = new HashMap();
    private IntegerMap<UnitType> m_attackRollsBonus = new IntegerMap();
    private IntegerMap<UnitType> m_defenseRollsBonus = new IntegerMap();
    private IntegerMap<UnitType> m_bombingBonus = new IntegerMap();

    public static TechAbilityAttachment get(TechAdvance type) {
        TechAdvance hardCodedAdvance;
        if (type instanceof GenericTechAdvance && (hardCodedAdvance = ((GenericTechAdvance)type).getAdvance()) != null) {
            TechAbilityAttachment hardCodedTechAttachment = (TechAbilityAttachment)hardCodedAdvance.getAttachment("techAbilityAttachment");
            return hardCodedTechAttachment;
        }
        TechAbilityAttachment rVal = (TechAbilityAttachment)type.getAttachment("techAbilityAttachment");
        return rVal;
    }

    public static TechAbilityAttachment get(TechAdvance type, String nameOfAttachment) {
        TechAbilityAttachment rVal = (TechAbilityAttachment)type.getAttachment(nameOfAttachment);
        if (rVal == null) {
            throw new IllegalStateException("No technology attachment for:" + type.getName() + " with name:" + nameOfAttachment);
        }
        return rVal;
    }

    public TechAbilityAttachment(String name, Attachable attachable, GameData gameData) {
        super(name, attachable, gameData);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setAttackBonus(String value) throws GameParseException {
        String[] s = value.split(":");
        if (s.length <= 0 || s.length > 2) {
            throw new GameParseException("attackBonus can not be empty or have more than two fields" + this.thisErrorMsg());
        }
        String unitType = s[1];
        UnitType ut = this.getData().getUnitTypeList().getUnitType(unitType);
        if (ut == null) {
            throw new GameParseException("No unit called:" + unitType + this.thisErrorMsg());
        }
        int n = TechAbilityAttachment.getInt(s[0]);
        this.m_attackBonus.put(ut, n);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAttackBonus(IntegerMap<UnitType> value) {
        this.m_attackBonus = value;
    }

    public IntegerMap<UnitType> getAttackBonus() {
        return this.m_attackBonus;
    }

    public void clearAttackBonus() {
        this.m_attackBonus.clear();
    }

    public void resetAttackBonus() {
        this.m_attackBonus = new IntegerMap();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setDefenseBonus(String value) throws GameParseException {
        String[] s = value.split(":");
        if (s.length <= 0 || s.length > 2) {
            throw new GameParseException("defenseBonus can not be empty or have more than two fields" + this.thisErrorMsg());
        }
        String unitType = s[1];
        UnitType ut = this.getData().getUnitTypeList().getUnitType(unitType);
        if (ut == null) {
            throw new GameParseException("No unit called:" + unitType + this.thisErrorMsg());
        }
        int n = TechAbilityAttachment.getInt(s[0]);
        this.m_defenseBonus.put(ut, n);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setDefenseBonus(IntegerMap<UnitType> value) {
        this.m_defenseBonus = value;
    }

    public IntegerMap<UnitType> getDefenseBonus() {
        return this.m_defenseBonus;
    }

    public void clearDefenseBonus() {
        this.m_defenseBonus.clear();
    }

    public void resetDefenseBonus() {
        this.m_defenseBonus = new IntegerMap();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setMovementBonus(String value) throws GameParseException {
        String[] s = value.split(":");
        if (s.length <= 0 || s.length > 2) {
            throw new GameParseException("movementBonus can not be empty or have more than two fields" + this.thisErrorMsg());
        }
        String unitType = s[1];
        UnitType ut = this.getData().getUnitTypeList().getUnitType(unitType);
        if (ut == null) {
            throw new GameParseException("No unit called:" + unitType + this.thisErrorMsg());
        }
        int n = TechAbilityAttachment.getInt(s[0]);
        this.m_movementBonus.put(ut, n);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setMovementBonus(IntegerMap<UnitType> value) {
        this.m_movementBonus = value;
    }

    public IntegerMap<UnitType> getMovementBonus() {
        return this.m_movementBonus;
    }

    public void clearMovementBonus() {
        this.m_movementBonus.clear();
    }

    public void resetMovementBonus() {
        this.m_movementBonus = new IntegerMap();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setRadarBonus(String value) throws GameParseException {
        String[] s = value.split(":");
        if (s.length <= 0 || s.length > 2) {
            throw new GameParseException("radarBonus can not be empty or have more than two fields" + this.thisErrorMsg());
        }
        String unitType = s[1];
        UnitType ut = this.getData().getUnitTypeList().getUnitType(unitType);
        if (ut == null) {
            throw new GameParseException("No unit called:" + unitType + this.thisErrorMsg());
        }
        int n = TechAbilityAttachment.getInt(s[0]);
        this.m_radarBonus.put(ut, n);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setRadarBonus(IntegerMap<UnitType> value) {
        this.m_radarBonus = value;
    }

    public IntegerMap<UnitType> getRadarBonus() {
        return this.m_radarBonus;
    }

    public void clearRadarBonus() {
        this.m_radarBonus.clear();
    }

    public void resetRadarBonus() {
        this.m_radarBonus = new IntegerMap();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setAirAttackBonus(String value) throws GameParseException {
        String[] s = value.split(":");
        if (s.length <= 0 || s.length > 2) {
            throw new GameParseException("airAttackBonus can not be empty or have more than two fields" + this.thisErrorMsg());
        }
        String unitType = s[1];
        UnitType ut = this.getData().getUnitTypeList().getUnitType(unitType);
        if (ut == null) {
            throw new GameParseException("No unit called:" + unitType + this.thisErrorMsg());
        }
        int n = TechAbilityAttachment.getInt(s[0]);
        this.m_airAttackBonus.put(ut, n);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAirAttackBonus(IntegerMap<UnitType> value) {
        this.m_airAttackBonus = value;
    }

    public IntegerMap<UnitType> getAirAttackBonus() {
        return this.m_airAttackBonus;
    }

    public void clearAirAttackBonus() {
        this.m_airAttackBonus.clear();
    }

    public void resetAirAttackBonus() {
        this.m_airAttackBonus = new IntegerMap();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setAirDefenseBonus(String value) throws GameParseException {
        String[] s = value.split(":");
        if (s.length <= 0 || s.length > 2) {
            throw new GameParseException("airDefenseBonus can not be empty or have more than two fields" + this.thisErrorMsg());
        }
        String unitType = s[1];
        UnitType ut = this.getData().getUnitTypeList().getUnitType(unitType);
        if (ut == null) {
            throw new GameParseException("No unit called:" + unitType + this.thisErrorMsg());
        }
        int n = TechAbilityAttachment.getInt(s[0]);
        this.m_airDefenseBonus.put(ut, n);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAirDefenseBonus(IntegerMap<UnitType> value) {
        this.m_airDefenseBonus = value;
    }

    public IntegerMap<UnitType> getAirDefenseBonus() {
        return this.m_airDefenseBonus;
    }

    public void clearAirDefenseBonus() {
        this.m_airDefenseBonus.clear();
    }

    public void resetAirDefenseBonus() {
        this.m_airDefenseBonus = new IntegerMap();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setProductionBonus(String value) throws GameParseException {
        String[] s = value.split(":");
        if (s.length <= 0 || s.length > 2) {
            throw new GameParseException("productionBonus can not be empty or have more than two fields" + this.thisErrorMsg());
        }
        String unitType = s[1];
        UnitType ut = this.getData().getUnitTypeList().getUnitType(unitType);
        if (ut == null) {
            throw new GameParseException("No unit called:" + unitType + this.thisErrorMsg());
        }
        int n = TechAbilityAttachment.getInt(s[0]);
        this.m_productionBonus.put(ut, n);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setProductionBonus(IntegerMap<UnitType> value) {
        this.m_productionBonus = value;
    }

    public IntegerMap<UnitType> getProductionBonus() {
        return this.m_productionBonus;
    }

    public void clearProductionBonus() {
        this.m_productionBonus.clear();
    }

    public void resetProductionBonus() {
        this.m_productionBonus = new IntegerMap();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setMinimumTerritoryValueForProductionBonus(String value) throws GameParseException {
        int v = TechAbilityAttachment.getInt(value);
        if (v != -1 && (v < 0 || v > 10000)) {
            throw new GameParseException("minimumTerritoryValueForProductionBonus must be -1 (no effect), or be between 0 and 10000" + this.thisErrorMsg());
        }
        this.m_minimumTerritoryValueForProductionBonus = v;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setMinimumTerritoryValueForProductionBonus(Integer value) {
        this.m_minimumTerritoryValueForProductionBonus = value;
    }

    public int getMinimumTerritoryValueForProductionBonus() {
        return this.m_minimumTerritoryValueForProductionBonus;
    }

    public void resetMinimumTerritoryValueForProductionBonus() {
        this.m_minimumTerritoryValueForProductionBonus = -1;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setRepairDiscount(String value) throws GameParseException {
        int v = TechAbilityAttachment.getInt(value);
        if (v != -1 && (v < 0 || v > 100)) {
            throw new GameParseException("m_repairDiscount must be -1 (no effect), or be between 0 and 100" + this.thisErrorMsg());
        }
        this.m_repairDiscount = v;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setRepairDiscount(Integer value) {
        this.m_repairDiscount = value;
    }

    public int getRepairDiscount() {
        return this.m_repairDiscount;
    }

    public void resetRepairDiscount() {
        this.m_repairDiscount = -1;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setWarBondDiceSides(String value) throws GameParseException {
        int v = TechAbilityAttachment.getInt(value);
        if (v != -1 && (v < 0 || v > 200)) {
            throw new GameParseException("warBondDiceSides must be -1 (no effect), or be between 0 and 200" + this.thisErrorMsg());
        }
        this.m_warBondDiceSides = v;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setWarBondDiceSides(Integer value) {
        this.m_warBondDiceSides = value;
    }

    public int getWarBondDiceSides() {
        return this.m_warBondDiceSides;
    }

    public void resetWarBondDiceSides() {
        this.m_warBondDiceSides = -1;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setWarBondDiceNumber(String value) throws GameParseException {
        int v = TechAbilityAttachment.getInt(value);
        if (v < 0 || v > 100) {
            throw new GameParseException("warBondDiceNumber must be between 0 and 100" + this.thisErrorMsg());
        }
        this.m_warBondDiceNumber = v;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setWarBondDiceNumber(Integer value) {
        this.m_warBondDiceNumber = value;
    }

    public int getWarBondDiceNumber() {
        return this.m_warBondDiceNumber;
    }

    public void resetWarBondDiceNumber() {
        this.m_warBondDiceNumber = 0;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setRocketDiceNumber(String value) throws GameParseException {
        String[] s = value.split(":");
        if (s.length != 2) {
            throw new GameParseException("rocketDiceNumber must have two fields" + this.thisErrorMsg());
        }
        String unitType = s[1];
        UnitType ut = this.getData().getUnitTypeList().getUnitType(unitType);
        if (ut == null) {
            throw new GameParseException("No unit called:" + unitType + this.thisErrorMsg());
        }
        int n = TechAbilityAttachment.getInt(s[0]);
        this.m_rocketDiceNumber.put(ut, n);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setRocketDiceNumber(IntegerMap<UnitType> value) {
        this.m_rocketDiceNumber = value;
    }

    public IntegerMap<UnitType> getRocketDiceNumber() {
        return this.m_rocketDiceNumber;
    }

    public void clearRocketDiceNumber() {
        this.m_rocketDiceNumber.clear();
    }

    public void resetRocketDiceNumber() {
        this.m_rocketDiceNumber = new IntegerMap();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setRocketDistance(String value) throws GameParseException {
        int v = TechAbilityAttachment.getInt(value);
        if (v < 0 || v > 100) {
            throw new GameParseException("rocketDistance must be between 0 and 100" + this.thisErrorMsg());
        }
        this.m_rocketDistance = v;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setRocketDistance(Integer value) {
        this.m_rocketDistance = value;
    }

    public int getRocketDistance() {
        return this.m_rocketDistance;
    }

    public void resetRocketDistance() {
        this.m_rocketDistance = 0;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setRocketNumberPerTerritory(String value) throws GameParseException {
        int v = TechAbilityAttachment.getInt(value);
        if (v < 0 || v > 200) {
            throw new GameParseException("rocketNumberPerTerritory must be between 0 and 200" + this.thisErrorMsg());
        }
        this.m_rocketNumberPerTerritory = v;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setRocketNumberPerTerritory(Integer value) {
        this.m_rocketNumberPerTerritory = value;
    }

    public int getRocketNumberPerTerritory() {
        return this.m_rocketNumberPerTerritory;
    }

    public void resetRocketNumberPerTerritory() {
        this.m_rocketNumberPerTerritory = 0;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setUnitAbilitiesGained(String value) throws GameParseException {
        String[] s = value.split(":");
        if (s.length < 2) {
            throw new GameParseException("unitAbilitiesGained must list the unit type, then all abilities gained" + this.thisErrorMsg());
        }
        String unitType = s[0];
        UnitType ut = this.getData().getUnitTypeList().getUnitType(unitType);
        if (ut == null) {
            throw new GameParseException("No unit called:" + unitType + this.thisErrorMsg());
        }
        HashSet<String> abilities = this.m_unitAbilitiesGained.get(ut);
        if (abilities == null) {
            abilities = new HashSet();
        }
        for (int i = 1; i < s.length; ++i) {
            String ability = s[i];
            if (!ability.equals(ABILITY_CAN_BLITZ) && !ability.equals(ABILITY_CAN_BOMBARD)) {
                throw new GameParseException("unitAbilitiesGained so far only supports: canBlitz and canBombard" + this.thisErrorMsg());
            }
            abilities.add(ability);
        }
        this.m_unitAbilitiesGained.put(ut, abilities);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setUnitAbilitiesGained(HashMap<UnitType, HashSet<String>> value) {
        this.m_unitAbilitiesGained = value;
    }

    public HashMap<UnitType, HashSet<String>> getUnitAbilitiesGained() {
        return this.m_unitAbilitiesGained;
    }

    public void clearUnitAbilitiesGained() {
        this.m_unitAbilitiesGained.clear();
    }

    public void resetUnitAbilitiesGained() {
        this.m_unitAbilitiesGained = new HashMap();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAirborneForces(String value) throws GameParseException {
        this.m_airborneForces = TechAbilityAttachment.getBool(value);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAirborneForces(Boolean value) {
        this.m_airborneForces = value;
    }

    public boolean getAirborneForces() {
        return this.m_airborneForces;
    }

    public void resetAirborneForces() {
        this.m_airborneForces = false;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setAirborneCapacity(String value) throws GameParseException {
        String[] s = value.split(":");
        if (s.length <= 0 || s.length > 2) {
            throw new GameParseException("airborneCapacity can not be empty or have more than two fields" + this.thisErrorMsg());
        }
        String unitType = s[1];
        UnitType ut = this.getData().getUnitTypeList().getUnitType(unitType);
        if (ut == null) {
            throw new GameParseException("No unit called:" + unitType + this.thisErrorMsg());
        }
        int n = TechAbilityAttachment.getInt(s[0]);
        this.m_airborneCapacity.put(ut, n);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAirborneCapacity(IntegerMap<UnitType> value) {
        this.m_airborneCapacity = value;
    }

    public IntegerMap<UnitType> getAirborneCapacity() {
        return this.m_airborneCapacity;
    }

    public void clearAirborneCapacity() {
        this.m_airborneCapacity.clear();
    }

    public void resetAirborneCapacity() {
        this.m_airborneCapacity = new IntegerMap();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setAirborneTypes(String value) throws GameParseException {
        String[] s;
        for (String u : s = value.split(":")) {
            UnitType ut = this.getData().getUnitTypeList().getUnitType(u);
            if (ut == null) {
                throw new GameParseException("airborneTypes: no such unit type: " + u + this.thisErrorMsg());
            }
            this.m_airborneTypes.add(ut);
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAirborneTypes(HashSet<UnitType> value) {
        this.m_airborneTypes = value;
    }

    public HashSet<UnitType> getAirborneTypes() {
        return this.m_airborneTypes;
    }

    public void clearAirborneTypes() {
        this.m_airborneTypes.clear();
    }

    public void resetAirborneTypes() {
        this.m_airborneTypes = new HashSet();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAirborneDistance(String value) throws GameParseException {
        int v = TechAbilityAttachment.getInt(value);
        if (v < 0 || v > 100) {
            throw new GameParseException("airborneDistance must be between 0 and 100" + this.thisErrorMsg());
        }
        this.m_airborneDistance = v;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAirborneDistance(Integer value) {
        this.m_airborneDistance = value;
    }

    public int getAirborneDistance() {
        return this.m_airborneDistance;
    }

    public void resetAirborneDistance() {
        this.m_airborneDistance = 0;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setAirborneBases(String value) throws GameParseException {
        String[] s;
        for (String u : s = value.split(":")) {
            UnitType ut = this.getData().getUnitTypeList().getUnitType(u);
            if (ut == null) {
                throw new GameParseException("airborneBases: no such unit type: " + u + this.thisErrorMsg());
            }
            this.m_airborneBases.add(ut);
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAirborneBases(HashSet<UnitType> value) {
        this.m_airborneBases = value;
    }

    public HashSet<UnitType> getAirborneBases() {
        return this.m_airborneBases;
    }

    public void clearAirborneBases() {
        this.m_airborneBases.clear();
    }

    public void resetAirborneBases() {
        this.m_airborneBases = new HashSet();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setAirborneTargettedByAA(String value) throws GameParseException {
        String[] s = value.split(":");
        if (s.length < 2) {
            throw new GameParseException("airborneTargettedByAA must have at least two fields" + this.thisErrorMsg());
        }
        String aaType = s[0];
        HashSet<UnitType> unitTypes = new HashSet<UnitType>();
        for (int i = 1; i < s.length; ++i) {
            UnitType ut = this.getData().getUnitTypeList().getUnitType(s[i]);
            if (ut == null) {
                throw new GameParseException("airborneTargettedByAA: no such unit type: " + s[i] + this.thisErrorMsg());
            }
            unitTypes.add(ut);
        }
        this.m_airborneTargettedByAA.put(aaType, unitTypes);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAirborneTargettedByAA(HashMap<String, HashSet<UnitType>> value) {
        this.m_airborneTargettedByAA = value;
    }

    public HashMap<String, HashSet<UnitType>> getAirborneTargettedByAA() {
        return this.m_airborneTargettedByAA;
    }

    public void clearAirborneTargettedByAA() {
        this.m_airborneTargettedByAA.clear();
    }

    public void resetAirborneTargettedByAA() {
        this.m_airborneTargettedByAA = new HashMap();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setAttackRollsBonus(String value) throws GameParseException {
        String[] s = value.split(":");
        if (s.length <= 0 || s.length > 2) {
            throw new GameParseException("attackRollsBonus can not be empty or have more than two fields" + this.thisErrorMsg());
        }
        String unitType = s[1];
        UnitType ut = this.getData().getUnitTypeList().getUnitType(unitType);
        if (ut == null) {
            throw new GameParseException("No unit called:" + unitType + this.thisErrorMsg());
        }
        int n = TechAbilityAttachment.getInt(s[0]);
        this.m_attackRollsBonus.put(ut, n);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAttackRollsBonus(IntegerMap<UnitType> value) {
        this.m_attackRollsBonus = value;
    }

    public IntegerMap<UnitType> getAttackRollsBonus() {
        return this.m_attackRollsBonus;
    }

    public void clearAttackRollsBonus() {
        this.m_attackRollsBonus.clear();
    }

    public void resetAttackRollsBonus() {
        this.m_attackRollsBonus = new IntegerMap();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setDefenseRollsBonus(String value) throws GameParseException {
        String[] s = value.split(":");
        if (s.length <= 0 || s.length > 2) {
            throw new GameParseException("defenseRollsBonus can not be empty or have more than two fields" + this.thisErrorMsg());
        }
        String unitType = s[1];
        UnitType ut = this.getData().getUnitTypeList().getUnitType(unitType);
        if (ut == null) {
            throw new GameParseException("No unit called:" + unitType + this.thisErrorMsg());
        }
        int n = TechAbilityAttachment.getInt(s[0]);
        this.m_defenseRollsBonus.put(ut, n);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setDefenseRollsBonus(IntegerMap<UnitType> value) {
        this.m_defenseRollsBonus = value;
    }

    public IntegerMap<UnitType> getDefenseRollsBonus() {
        return this.m_defenseRollsBonus;
    }

    public void clearDefenseRollsBonus() {
        this.m_defenseRollsBonus.clear();
    }

    public void resetDefenseRollsBonus() {
        this.m_defenseRollsBonus = new IntegerMap();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setBombingBonus(String value) throws GameParseException {
        String[] s = value.split(":");
        if (s.length <= 0 || s.length > 2) {
            throw new GameParseException("bombingBonus can not be empty or have more than two fields" + this.thisErrorMsg());
        }
        String unitType = s[1];
        UnitType ut = this.getData().getUnitTypeList().getUnitType(unitType);
        if (ut == null) {
            throw new GameParseException("No unit called:" + unitType + this.thisErrorMsg());
        }
        int n = TechAbilityAttachment.getInt(s[0]);
        this.m_bombingBonus.put(ut, n);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setBombingBonus(IntegerMap<UnitType> value) {
        this.m_bombingBonus = value;
    }

    public IntegerMap<UnitType> getBombingBonus() {
        return this.m_bombingBonus;
    }

    public void clearBombingBonus() {
        this.m_bombingBonus.clear();
    }

    public void resetBombingBonus() {
        this.m_bombingBonus = new IntegerMap();
    }

    public static int getAttackBonus(UnitType ut, PlayerID player, GameData data) {
        int rVal = 0;
        for (TechAdvance ta : TechTracker.getCurrentTechAdvances(player, data)) {
            TechAbilityAttachment taa = TechAbilityAttachment.get(ta);
            if (taa == null) continue;
            rVal += taa.getAttackBonus().getInt(ut);
        }
        return rVal;
    }

    public static int getDefenseBonus(UnitType ut, PlayerID player, GameData data) {
        int rVal = 0;
        for (TechAdvance ta : TechTracker.getCurrentTechAdvances(player, data)) {
            TechAbilityAttachment taa = TechAbilityAttachment.get(ta);
            if (taa == null) continue;
            rVal += taa.getDefenseBonus().getInt(ut);
        }
        return rVal;
    }

    public static int getMovementBonus(UnitType ut, PlayerID player, GameData data) {
        int rVal = 0;
        for (TechAdvance ta : TechTracker.getCurrentTechAdvances(player, data)) {
            TechAbilityAttachment taa = TechAbilityAttachment.get(ta);
            if (taa == null) continue;
            rVal += taa.getMovementBonus().getInt(ut);
        }
        return rVal;
    }

    public static int getRadarBonus(UnitType ut, PlayerID player, GameData data) {
        int rVal = 0;
        for (TechAdvance ta : TechTracker.getCurrentTechAdvances(player, data)) {
            TechAbilityAttachment taa = TechAbilityAttachment.get(ta);
            if (taa == null) continue;
            rVal += taa.getRadarBonus().getInt(ut);
        }
        return rVal;
    }

    public static int getAirAttackBonus(UnitType ut, PlayerID player, GameData data) {
        int rVal = 0;
        for (TechAdvance ta : TechTracker.getCurrentTechAdvances(player, data)) {
            TechAbilityAttachment taa = TechAbilityAttachment.get(ta);
            if (taa == null) continue;
            rVal += taa.getAirAttackBonus().getInt(ut);
        }
        return rVal;
    }

    public static int getAirDefenseBonus(UnitType ut, PlayerID player, GameData data) {
        int rVal = 0;
        for (TechAdvance ta : TechTracker.getCurrentTechAdvances(player, data)) {
            TechAbilityAttachment taa = TechAbilityAttachment.get(ta);
            if (taa == null) continue;
            rVal += taa.getAirDefenseBonus().getInt(ut);
        }
        return rVal;
    }

    public static int getProductionBonus(UnitType ut, PlayerID player, GameData data) {
        int rVal = 0;
        for (TechAdvance ta : TechTracker.getCurrentTechAdvances(player, data)) {
            TechAbilityAttachment taa = TechAbilityAttachment.get(ta);
            if (taa == null) continue;
            rVal += taa.getProductionBonus().getInt(ut);
        }
        return rVal;
    }

    public static int getMinimumTerritoryValueForProductionBonus(PlayerID player, GameData data) {
        int rVal = -1;
        for (TechAdvance ta : TechTracker.getCurrentTechAdvances(player, data)) {
            int min;
            TechAbilityAttachment taa = TechAbilityAttachment.get(ta);
            if (taa == null || (min = taa.getMinimumTerritoryValueForProductionBonus()) == -1 || rVal != -1 && min >= rVal) continue;
            rVal = min;
        }
        return Math.max(0, rVal);
    }

    public static double getRepairDiscount(PlayerID player, GameData data) {
        double rVal = 1.0;
        for (TechAdvance ta : TechTracker.getCurrentTechAdvances(player, data)) {
            int min;
            TechAbilityAttachment taa = TechAbilityAttachment.get(ta);
            if (taa == null || (min = taa.getRepairDiscount()) == -1) continue;
            double fmin = min;
            rVal -= (fmin /= 100.0);
        }
        return Math.max(0.0, rVal);
    }

    public static int getWarBondDiceSides(PlayerID player, GameData data) {
        int rVal = 0;
        for (TechAdvance ta : TechTracker.getCurrentTechAdvances(player, data)) {
            int sides;
            TechAbilityAttachment taa = TechAbilityAttachment.get(ta);
            if (taa == null || (sides = taa.getWarBondDiceSides()) <= 0) continue;
            rVal += sides;
        }
        return Math.max(0, rVal);
    }

    public static int getWarBondDiceNumber(PlayerID player, GameData data) {
        int rVal = 0;
        for (TechAdvance ta : TechTracker.getCurrentTechAdvances(player, data)) {
            int number;
            TechAbilityAttachment taa = TechAbilityAttachment.get(ta);
            if (taa == null || (number = taa.getWarBondDiceNumber()) <= 0) continue;
            rVal += number;
        }
        return Math.max(0, rVal);
    }

    private static int getRocketDiceNumber(UnitType ut, PlayerID player, GameData data) {
        int rVal = 0;
        for (TechAdvance ta : TechTracker.getCurrentTechAdvances(player, data)) {
            TechAbilityAttachment taa = TechAbilityAttachment.get(ta);
            if (taa == null) continue;
            rVal += taa.getRocketDiceNumber().getInt(ut);
        }
        return rVal;
    }

    public static int getRocketDiceNumber(Collection<Unit> rockets, GameData data) {
        int rVal = 0;
        for (Unit u : rockets) {
            rVal += TechAbilityAttachment.getRocketDiceNumber(u.getType(), u.getOwner(), data);
        }
        return rVal;
    }

    public static int getRocketDistance(PlayerID player, GameData data) {
        int rVal = 0;
        for (TechAdvance ta : TechTracker.getCurrentTechAdvances(player, data)) {
            int distance;
            TechAbilityAttachment taa = TechAbilityAttachment.get(ta);
            if (taa == null || (distance = taa.getRocketDistance()) <= 0) continue;
            rVal += distance;
        }
        return Math.max(0, rVal);
    }

    public static int getRocketNumberPerTerritory(PlayerID player, GameData data) {
        int rVal = 0;
        for (TechAdvance ta : TechTracker.getCurrentTechAdvances(player, data)) {
            int number;
            TechAbilityAttachment taa = TechAbilityAttachment.get(ta);
            if (taa == null || (number = taa.getRocketNumberPerTerritory()) <= 0) continue;
            rVal += number;
        }
        return Math.max(0, rVal);
    }

    private static HashSet<String> getUnitAbilitiesGained(UnitType ut, PlayerID player, GameData data) {
        HashSet<String> rVal = new HashSet<String>();
        for (TechAdvance ta : TechTracker.getCurrentTechAdvances(player, data)) {
            HashSet<String> abilities;
            TechAbilityAttachment taa = TechAbilityAttachment.get(ta);
            if (taa == null || (abilities = taa.getUnitAbilitiesGained().get(ut)) == null) continue;
            rVal.addAll(abilities);
        }
        return rVal;
    }

    public static boolean getUnitAbilitiesGained(String filterForAbility, UnitType ut, PlayerID player, GameData data) {
        HashSet<String> abilities = TechAbilityAttachment.getUnitAbilitiesGained(ut, player, data);
        return abilities.contains(filterForAbility);
    }

    public static boolean getAllowAirborneForces(PlayerID player, GameData data) {
        for (TechAdvance ta : TechTracker.getCurrentTechAdvances(player, data)) {
            TechAbilityAttachment taa = TechAbilityAttachment.get(ta);
            if (taa == null || !taa.getAirborneForces()) continue;
            return true;
        }
        return false;
    }

    public static IntegerMap<UnitType> getAirborneCapacity(PlayerID player, GameData data) {
        IntegerMap<UnitType> capacityMap = new IntegerMap<UnitType>();
        for (TechAdvance ta : TechTracker.getCurrentTechAdvances(player, data)) {
            TechAbilityAttachment taa = TechAbilityAttachment.get(ta);
            if (taa == null) continue;
            capacityMap.add(taa.getAirborneCapacity());
        }
        return capacityMap;
    }

    public static int getAirborneCapacity(Collection<Unit> units, PlayerID player, GameData data) {
        IntegerMap<UnitType> capacityMap = TechAbilityAttachment.getAirborneCapacity(player, data);
        int rVal = 0;
        for (Unit u : units) {
            rVal += Math.max(0, capacityMap.getInt(u.getType()) - ((TripleAUnit)u).getLaunched());
        }
        return rVal;
    }

    public static Set<UnitType> getAirborneTypes(PlayerID player, GameData data) {
        HashSet<UnitType> airborneUnits = new HashSet<UnitType>();
        for (TechAdvance ta : TechTracker.getCurrentTechAdvances(player, data)) {
            TechAbilityAttachment taa = TechAbilityAttachment.get(ta);
            if (taa == null) continue;
            airborneUnits.addAll(taa.getAirborneTypes());
        }
        return airborneUnits;
    }

    public static int getAirborneDistance(PlayerID player, GameData data) {
        int rVal = 0;
        for (TechAdvance ta : TechTracker.getCurrentTechAdvances(player, data)) {
            TechAbilityAttachment taa = TechAbilityAttachment.get(ta);
            if (taa == null) continue;
            rVal += taa.getAirborneDistance();
        }
        return Math.max(0, rVal);
    }

    public static Set<UnitType> getAirborneBases(PlayerID player, GameData data) {
        HashSet<UnitType> airborneBases = new HashSet<UnitType>();
        for (TechAdvance ta : TechTracker.getCurrentTechAdvances(player, data)) {
            TechAbilityAttachment taa = TechAbilityAttachment.get(ta);
            if (taa == null) continue;
            airborneBases.addAll(taa.getAirborneBases());
        }
        return airborneBases;
    }

    public static HashMap<String, HashSet<UnitType>> getAirborneTargettedByAA(PlayerID player, GameData data) {
        HashMap<String, HashSet<UnitType>> rVal = new HashMap<String, HashSet<UnitType>>();
        for (TechAdvance ta : TechTracker.getCurrentTechAdvances(player, data)) {
            HashMap<String, HashSet<UnitType>> mapAA;
            TechAbilityAttachment taa = TechAbilityAttachment.get(ta);
            if (taa == null || (mapAA = taa.getAirborneTargettedByAA()) == null || mapAA.isEmpty()) continue;
            for (Map.Entry<String, HashSet<UnitType>> entry : mapAA.entrySet()) {
                HashSet<UnitType> current = rVal.get(entry.getKey());
                if (current == null) {
                    current = new HashSet();
                }
                current.addAll((Collection<UnitType>)entry.getValue());
                rVal.put(entry.getKey(), current);
            }
        }
        return rVal;
    }

    public static int getAttackRollsBonus(UnitType ut, PlayerID player, GameData data) {
        int rVal = 0;
        for (TechAdvance ta : TechTracker.getCurrentTechAdvances(player, data)) {
            TechAbilityAttachment taa = TechAbilityAttachment.get(ta);
            if (taa == null) continue;
            rVal += taa.getAttackRollsBonus().getInt(ut);
        }
        return rVal;
    }

    public static int getDefenseRollsBonus(UnitType ut, PlayerID player, GameData data) {
        int rVal = 0;
        for (TechAdvance ta : TechTracker.getCurrentTechAdvances(player, data)) {
            TechAbilityAttachment taa = TechAbilityAttachment.get(ta);
            if (taa == null) continue;
            rVal += taa.getDefenseRollsBonus().getInt(ut);
        }
        return rVal;
    }

    public static int getBombingBonus(UnitType ut, PlayerID player, GameData data) {
        int rVal = 0;
        for (TechAdvance ta : TechTracker.getCurrentTechAdvances(player, data)) {
            TechAbilityAttachment taa = TechAbilityAttachment.get(ta);
            if (taa == null) continue;
            rVal += taa.getBombingBonus().getInt(ut);
        }
        return rVal;
    }

    @InternalDoNotExport
    public static void setDefaultTechnologyAttachments(GameData data) throws GameParseException {
        for (TechAdvance techAdvance : TechAdvance.getTechAdvances(data)) {
            TechAdvance ta;
            if (techAdvance instanceof GenericTechAdvance) {
                TechAdvance adv = ((GenericTechAdvance)techAdvance).getAdvance();
                if (adv == null) continue;
                ta = adv;
            } else {
                ta = techAdvance;
            }
            String propertyString = ta.getProperty();
            TechAbilityAttachment taa = TechAbilityAttachment.get(ta);
            if (taa != null) continue;
            if (propertyString.equals("longRangeAir")) {
                taa = new TechAbilityAttachment("techAbilityAttachment", ta, data);
                ta.addAttachment("techAbilityAttachment", taa);
                List<UnitType> allAir = Match.getMatches(data.getUnitTypeList().getAllUnitTypes(), Matches.UnitTypeIsAir);
                for (UnitType air : allAir) {
                    taa.setMovementBonus("2:" + air.getName());
                }
                continue;
            }
            if (propertyString.equals("aARadar")) {
                taa = new TechAbilityAttachment("techAbilityAttachment", ta, data);
                ta.addAttachment("techAbilityAttachment", taa);
                List<UnitType> allAA = Match.getMatches(data.getUnitTypeList().getAllUnitTypes(), Matches.UnitTypeIsAAforAnything);
                for (UnitType aa : allAA) {
                    taa.setRadarBonus("1:" + aa.getName());
                }
                continue;
            }
            if (propertyString.equals("superSub")) {
                taa = new TechAbilityAttachment("techAbilityAttachment", ta, data);
                ta.addAttachment("techAbilityAttachment", taa);
                List<UnitType> allSubs = Match.getMatches(data.getUnitTypeList().getAllUnitTypes(), Matches.UnitTypeIsSub);
                for (UnitType sub : allSubs) {
                    taa.setAttackBonus("1:" + sub.getName());
                }
                continue;
            }
            if (propertyString.equals("jetPower")) {
                taa = new TechAbilityAttachment("techAbilityAttachment", ta, data);
                ta.addAttachment("techAbilityAttachment", taa);
                List<UnitType> allJets = Match.getMatches(data.getUnitTypeList().getAllUnitTypes(), new CompositeMatchAnd(Matches.UnitTypeIsAir, Matches.UnitTypeIsStrategicBomber.invert()));
                boolean ww2v3TechModel = Properties.getWW2V3TechModel(data);
                for (UnitType jet : allJets) {
                    if (ww2v3TechModel) {
                        taa.setAttackBonus("1:" + jet.getName());
                        continue;
                    }
                    taa.setDefenseBonus("1:" + jet.getName());
                }
                continue;
            }
            if (propertyString.equals("increasedFactoryProduction")) {
                taa = new TechAbilityAttachment("techAbilityAttachment", ta, data);
                ta.addAttachment("techAbilityAttachment", taa);
                List<UnitType> allFactories = Match.getMatches(data.getUnitTypeList().getAllUnitTypes(), Matches.UnitTypeCanProduceUnits);
                for (UnitType factory : allFactories) {
                    taa.setProductionBonus("2:" + factory.getName());
                    taa.setMinimumTerritoryValueForProductionBonus("3");
                    taa.setRepairDiscount("50");
                }
                continue;
            }
            if (propertyString.equals("warBonds")) {
                taa = new TechAbilityAttachment("techAbilityAttachment", ta, data);
                ta.addAttachment("techAbilityAttachment", taa);
                taa.setWarBondDiceSides(Integer.toString(data.getDiceSides()));
                taa.setWarBondDiceNumber("1");
                continue;
            }
            if (propertyString.equals("rocket")) {
                taa = new TechAbilityAttachment("techAbilityAttachment", ta, data);
                ta.addAttachment("techAbilityAttachment", taa);
                List<UnitType> allRockets = Match.getMatches(data.getUnitTypeList().getAllUnitTypes(), Matches.UnitTypeIsRocket);
                for (UnitType rocket : allRockets) {
                    taa.setRocketDiceNumber("1:" + rocket.getName());
                }
                taa.setRocketDistance("3");
                taa.setRocketNumberPerTerritory("1");
                continue;
            }
            if (propertyString.equals("destroyerBombard")) {
                taa = new TechAbilityAttachment("techAbilityAttachment", ta, data);
                ta.addAttachment("techAbilityAttachment", taa);
                List<UnitType> allDestroyers = Match.getMatches(data.getUnitTypeList().getAllUnitTypes(), Matches.UnitTypeIsDestroyer);
                for (UnitType destroyer : allDestroyers) {
                    taa.setUnitAbilitiesGained(destroyer.getName() + ":" + ABILITY_CAN_BOMBARD);
                }
                continue;
            }
            if (!propertyString.equals("heavyBomber")) continue;
            taa = new TechAbilityAttachment("techAbilityAttachment", ta, data);
            ta.addAttachment("techAbilityAttachment", taa);
            List<UnitType> allBombers = Match.getMatches(data.getUnitTypeList().getAllUnitTypes(), Matches.UnitTypeIsStrategicBomber);
            int heavyBomberDiceRollsTotal = Properties.getHeavyBomberDiceRolls(data);
            boolean heavyBombersLHTR = Properties.getLHTR_Heavy_Bombers(data);
            for (UnitType bomber : allBombers) {
                int heavyBomberDiceRollsBonus = heavyBomberDiceRollsTotal - UnitAttachment.get(bomber).getAttackRolls(PlayerID.NULL_PLAYERID);
                taa.setAttackRollsBonus(heavyBomberDiceRollsBonus + ":" + bomber.getName());
                if (!heavyBombersLHTR) continue;
                taa.setDefenseRollsBonus(heavyBomberDiceRollsBonus + ":" + bomber.getName());
                taa.setBombingBonus("1:" + bomber.getName());
            }
        }
    }

    @Override
    public void validate(GameData data) throws GameParseException {
        TechAdvance hardCodedAdvance;
        TechAdvance ta = (TechAdvance)this.getAttachedTo();
        if (ta instanceof GenericTechAdvance && (hardCodedAdvance = ((GenericTechAdvance)ta).getAdvance()) != null) {
            throw new GameParseException("A custom Generic Tech Advance naming a hardcoded tech, may not have a Tech Ability Attachment!" + this.thisErrorMsg());
        }
    }
}

