/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.attatchments;

import games.strategy.engine.data.Attachable;
import games.strategy.engine.data.DefaultAttachment;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameParseException;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.annotations.GameProperty;
import games.strategy.engine.data.annotations.InternalDoNotExport;
import games.strategy.triplea.delegate.GenericTechAdvance;
import games.strategy.triplea.delegate.TechAdvance;
import java.util.HashMap;

public class TechAttachment
extends DefaultAttachment {
    private static final long serialVersionUID = -8780929085456199961L;
    private int m_techCost = 5;
    private boolean m_heavyBomber = false;
    private boolean m_longRangeAir = false;
    private boolean m_jetPower = false;
    private boolean m_rocket = false;
    private boolean m_industrialTechnology = false;
    private boolean m_superSub = false;
    private boolean m_destroyerBombard = false;
    private boolean m_improvedArtillerySupport = false;
    private boolean m_paratroopers = false;
    private boolean m_increasedFactoryProduction = false;
    private boolean m_warBonds = false;
    private boolean m_mechanizedInfantry = false;
    private boolean m_aARadar = false;
    private boolean m_shipyards = false;
    @InternalDoNotExport
    private HashMap<String, Boolean> m_GenericTech = new HashMap();

    public static TechAttachment get(PlayerID id) {
        TechAttachment attachment = (TechAttachment)id.getAttachment("techAttatchment");
        if (attachment == null) {
            return new TechAttachment();
        }
        return attachment;
    }

    public static TechAttachment get(PlayerID id, String nameOfAttachment) {
        if (!nameOfAttachment.equals("techAttatchment")) {
            throw new IllegalStateException("TechAttachment may not yet get attachments not named:techAttatchment");
        }
        TechAttachment attachment = (TechAttachment)id.getAttachment(nameOfAttachment);
        if (attachment == null) {
            return new TechAttachment();
        }
        return attachment;
    }

    public TechAttachment(String name, Attachable attachable, GameData gameData) {
        super(name, attachable, gameData);
        this.setGenericTechs();
    }

    @Deprecated
    public TechAttachment() {
        super("techAttatchment", null, null);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setTechCost(String s) {
        this.m_techCost = TechAttachment.getInt(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setTechCost(Integer s) {
        this.m_techCost = s;
    }

    public void resetTechCost() {
        this.m_techCost = 5;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setHeavyBomber(String s) {
        this.m_heavyBomber = TechAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setHeavyBomber(Boolean s) {
        this.m_heavyBomber = s;
    }

    public void resetHeavyBomber() {
        this.m_heavyBomber = false;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setDestroyerBombard(String s) {
        this.m_destroyerBombard = TechAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setDestroyerBombard(Boolean s) {
        this.m_destroyerBombard = s;
    }

    public void resetDestroyerBombard() {
        this.m_destroyerBombard = false;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setLongRangeAir(String s) {
        this.m_longRangeAir = TechAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setLongRangeAir(Boolean s) {
        this.m_longRangeAir = s;
    }

    public void resetLongRangeAir() {
        this.m_longRangeAir = false;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setJetPower(String s) {
        this.m_jetPower = TechAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setJetPower(Boolean s) {
        this.m_jetPower = s;
    }

    public void resetJetPower() {
        this.m_jetPower = false;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setRocket(String s) {
        this.m_rocket = TechAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setRocket(Boolean s) {
        this.m_rocket = s;
    }

    public void resetRocket() {
        this.m_rocket = false;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIndustrialTechnology(String s) {
        this.m_industrialTechnology = TechAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIndustrialTechnology(Boolean s) {
        this.m_industrialTechnology = s;
    }

    public void resetIndustrialTechnology() {
        this.m_industrialTechnology = false;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setSuperSub(String s) {
        this.m_superSub = TechAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setSuperSub(Boolean s) {
        this.m_superSub = s;
    }

    public void resetSuperSub() {
        this.m_superSub = false;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setImprovedArtillerySupport(String s) {
        this.m_improvedArtillerySupport = TechAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setImprovedArtillerySupport(Boolean s) {
        this.m_improvedArtillerySupport = s;
    }

    public void resetImprovedArtillerySupport() {
        this.m_improvedArtillerySupport = false;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setParatroopers(String s) {
        this.m_paratroopers = TechAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setParatroopers(Boolean s) {
        this.m_paratroopers = s;
    }

    public void resetParatroopers() {
        this.m_paratroopers = false;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIncreasedFactoryProduction(String s) {
        this.m_increasedFactoryProduction = TechAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIncreasedFactoryProduction(Boolean s) {
        this.m_increasedFactoryProduction = s;
    }

    public void resetIncreasedFactoryProduction() {
        this.m_increasedFactoryProduction = false;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setWarBonds(String s) {
        this.m_warBonds = TechAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setWarBonds(Boolean s) {
        this.m_warBonds = s;
    }

    public void resetWarBonds() {
        this.m_warBonds = false;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setMechanizedInfantry(String s) {
        this.m_mechanizedInfantry = TechAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setMechanizedInfantry(Boolean s) {
        this.m_mechanizedInfantry = s;
    }

    public void resetMechanizedInfantry() {
        this.m_mechanizedInfantry = false;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAARadar(String s) {
        this.m_aARadar = TechAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAARadar(Boolean s) {
        this.m_aARadar = s;
    }

    public void resetAARadar() {
        this.m_aARadar = false;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setShipyards(String s) {
        this.m_shipyards = TechAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setShipyards(Boolean s) {
        this.m_shipyards = s;
    }

    public void resetShipyards() {
        this.m_shipyards = false;
    }

    public int getTechCost() {
        return this.m_techCost;
    }

    public boolean getHeavyBomber() {
        return this.m_heavyBomber;
    }

    public boolean getLongRangeAir() {
        return this.m_longRangeAir;
    }

    public boolean getJetPower() {
        return this.m_jetPower;
    }

    public boolean getRocket() {
        return this.m_rocket;
    }

    public boolean getIndustrialTechnology() {
        return this.m_industrialTechnology;
    }

    public boolean getSuperSub() {
        return this.m_superSub;
    }

    public boolean getDestroyerBombard() {
        return this.m_destroyerBombard;
    }

    public boolean getImprovedArtillerySupport() {
        return this.m_improvedArtillerySupport;
    }

    public boolean getParatroopers() {
        return this.m_paratroopers;
    }

    public boolean getIncreasedFactoryProduction() {
        return this.m_increasedFactoryProduction;
    }

    public boolean getWarBonds() {
        return this.m_warBonds;
    }

    public boolean getMechanizedInfantry() {
        return this.m_mechanizedInfantry;
    }

    public boolean getAARadar() {
        return this.m_aARadar;
    }

    public boolean getShipyards() {
        return this.m_shipyards;
    }

    @InternalDoNotExport
    private void setGenericTechs() {
        for (TechAdvance ta : this.getData().getTechnologyFrontier()) {
            if (!(ta instanceof GenericTechAdvance) || ((GenericTechAdvance)ta).getAdvance() != null) continue;
            this.m_GenericTech.put(ta.getProperty(), Boolean.FALSE);
        }
    }

    public Boolean hasGenericTech(String name) {
        return this.m_GenericTech.get(name);
    }

    @InternalDoNotExport
    public void setGenericTech(String name, Boolean value) {
        this.m_GenericTech.put(name, value);
    }

    @InternalDoNotExport
    public void setGenericTech(HashMap<String, Boolean> value) {
        this.m_GenericTech = value;
    }

    public HashMap<String, Boolean> getGenericTech() {
        return this.m_GenericTech;
    }

    public void clearGenericTech() {
        this.m_GenericTech.clear();
    }

    @Override
    public void validate(GameData data) throws GameParseException {
    }
}

