/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.attatchments;

import games.strategy.engine.data.Attachable;
import games.strategy.engine.data.DefaultAttachment;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameParseException;
import games.strategy.engine.data.TerritoryEffect;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.data.annotations.GameProperty;
import games.strategy.engine.data.annotations.InternalDoNotExport;
import games.strategy.util.IntegerMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class TerritoryEffectAttachment
extends DefaultAttachment {
    private static final long serialVersionUID = 6379810228136325991L;
    private IntegerMap<UnitType> m_combatDefenseEffect = new IntegerMap();
    private IntegerMap<UnitType> m_combatOffenseEffect = new IntegerMap();
    private ArrayList<UnitType> m_noBlitz = new ArrayList();
    private ArrayList<UnitType> m_unitsNotAllowed = new ArrayList();

    public TerritoryEffectAttachment(String name, Attachable attachable, GameData gameData) {
        super(name, attachable, gameData);
    }

    public static TerritoryEffectAttachment get(TerritoryEffect te) {
        TerritoryEffectAttachment rVal = (TerritoryEffectAttachment)te.getAttachment("territoryEffectAttachment");
        if (rVal == null) {
            throw new IllegalStateException("No territoryEffect attachment for:" + te.getName());
        }
        return rVal;
    }

    public static TerritoryEffectAttachment get(TerritoryEffect te, String nameOfAttachment) {
        TerritoryEffectAttachment rVal = (TerritoryEffectAttachment)te.getAttachment(nameOfAttachment);
        if (rVal == null) {
            throw new IllegalStateException("No territoryEffect attachment for:" + te.getName() + " with name:" + nameOfAttachment);
        }
        return rVal;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setCombatDefenseEffect(String combatDefenseEffect) throws GameParseException {
        this.setCombatEffect(combatDefenseEffect, true);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCombatDefenseEffect(IntegerMap<UnitType> value) {
        this.m_combatDefenseEffect = value;
    }

    public IntegerMap<UnitType> getCombatDefenseEffect() {
        return new IntegerMap<UnitType>(this.m_combatDefenseEffect);
    }

    public void clearCombatDefenseEffect() {
        this.m_combatDefenseEffect.clear();
    }

    public void resetCombatDefenseEffect() {
        this.m_combatDefenseEffect = new IntegerMap();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setCombatOffenseEffect(String combatOffenseEffect) throws GameParseException {
        this.setCombatEffect(combatOffenseEffect, false);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCombatOffenseEffect(IntegerMap<UnitType> value) {
        this.m_combatOffenseEffect = value;
    }

    public IntegerMap<UnitType> getCombatOffenseEffect() {
        return new IntegerMap<UnitType>(this.m_combatOffenseEffect);
    }

    public void clearCombatOffenseEffect() {
        this.m_combatOffenseEffect.clear();
    }

    public void resetCombatOffenseEffect() {
        this.m_combatOffenseEffect = new IntegerMap();
    }

    @InternalDoNotExport
    private void setCombatEffect(String combatEffect, boolean defending) throws GameParseException {
        String[] s = combatEffect.split(":");
        if (s.length < 2) {
            throw new GameParseException("combatDefenseEffect and combatOffenseEffect must have a count and at least one unitType" + this.thisErrorMsg());
        }
        Iterator<String> iter = Arrays.asList(s).iterator();
        int effect = TerritoryEffectAttachment.getInt(iter.next());
        while (iter.hasNext()) {
            String unitTypeToProduce = iter.next();
            UnitType ut = this.getData().getUnitTypeList().getUnitType(unitTypeToProduce);
            if (ut == null) {
                throw new GameParseException("No unit called:" + unitTypeToProduce + this.thisErrorMsg());
            }
            if (defending) {
                this.m_combatDefenseEffect.put(ut, effect);
                continue;
            }
            this.m_combatOffenseEffect.put(ut, effect);
        }
    }

    public int getCombatEffect(UnitType aType, boolean defending) {
        if (defending) {
            return this.m_combatDefenseEffect.getInt(aType);
        }
        return this.m_combatOffenseEffect.getInt(aType);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setNoBlitz(String noBlitzUnitTypes) throws GameParseException {
        String[] s = noBlitzUnitTypes.split(":");
        if (s.length < 1) {
            throw new GameParseException("noBlitz must have at least one unitType" + this.thisErrorMsg());
        }
        for (String unitTypeName : Arrays.asList(s)) {
            UnitType ut = this.getData().getUnitTypeList().getUnitType(unitTypeName);
            if (ut == null) {
                throw new GameParseException("No unit called:" + unitTypeName + this.thisErrorMsg());
            }
            this.m_noBlitz.add(ut);
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setNoBlitz(ArrayList<UnitType> value) {
        this.m_noBlitz = value;
    }

    public ArrayList<UnitType> getNoBlitz() {
        return new ArrayList<UnitType>(this.m_noBlitz);
    }

    public void clearNoBlitz() {
        this.m_noBlitz.clear();
    }

    public void resetNoBlitz() {
        this.m_noBlitz = new ArrayList();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setUnitsNotAllowed(String unitsNotAllowedUnitTypes) throws GameParseException {
        String[] s = unitsNotAllowedUnitTypes.split(":");
        if (s.length < 1) {
            throw new GameParseException("unitsNotAllowed must have at least one unitType" + this.thisErrorMsg());
        }
        for (String unitTypeName : s) {
            UnitType ut = this.getData().getUnitTypeList().getUnitType(unitTypeName);
            if (ut == null) {
                throw new GameParseException("No unit called:" + unitTypeName + this.thisErrorMsg());
            }
            this.m_unitsNotAllowed.add(ut);
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setUnitsNotAllowed(ArrayList<UnitType> value) {
        this.m_unitsNotAllowed = value;
    }

    public ArrayList<UnitType> getUnitsNotAllowed() {
        return new ArrayList<UnitType>(this.m_unitsNotAllowed);
    }

    public void clearUnitsNotAllowed() {
        this.m_unitsNotAllowed.clear();
    }

    public void resetUnitsNotAllowed() {
        this.m_unitsNotAllowed = new ArrayList();
    }

    @Override
    public void validate(GameData data) throws GameParseException {
    }
}

