/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.attatchments;

import games.strategy.engine.data.Attachable;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameParseException;
import games.strategy.engine.data.IAttachment;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.annotations.GameProperty;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.triplea.attatchments.AbstractTriggerAttachment;
import games.strategy.triplea.attatchments.AbstractUserActionAttachment;
import games.strategy.triplea.attatchments.ICondition;
import games.strategy.triplea.attatchments.TriggerAttachment;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.Match;
import games.strategy.util.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class UserActionAttachment
extends AbstractUserActionAttachment
implements ICondition {
    private static final long serialVersionUID = 5268397563276055355L;
    private ArrayList<Tuple<String, String>> m_activateTrigger = new ArrayList();

    public UserActionAttachment(String name, Attachable attachable, GameData gameData) {
        super(name, attachable, gameData);
    }

    public static Collection<UserActionAttachment> getUserActionAttachments(PlayerID player) {
        ArrayList<UserActionAttachment> returnList = new ArrayList<UserActionAttachment>();
        Map<String, IAttachment> map = player.getAttachments();
        for (Map.Entry<String, IAttachment> entry : map.entrySet()) {
            IAttachment a = entry.getValue();
            if (!a.getName().startsWith("userActionAttachment") || !(a instanceof UserActionAttachment)) continue;
            returnList.add((UserActionAttachment)a);
        }
        return returnList;
    }

    public static UserActionAttachment get(PlayerID player, String nameOfAttachment) {
        return UserActionAttachment.get(player, nameOfAttachment, null);
    }

    public static UserActionAttachment get(PlayerID player, String nameOfAttachment, Collection<PlayerID> playersToSearch) {
        UserActionAttachment rVal = (UserActionAttachment)player.getAttachment(nameOfAttachment);
        if (rVal == null) {
            if (playersToSearch == null) {
                throw new IllegalStateException("UserActionAttachment: No attachment for:" + player.getName() + " with name: " + nameOfAttachment);
            }
            for (PlayerID otherPlayer : playersToSearch) {
                if (otherPlayer == player || (rVal = (UserActionAttachment)otherPlayer.getAttachment(nameOfAttachment)) == null) continue;
                return rVal;
            }
            throw new IllegalStateException("UserActionAttachment: No attachment for:" + player.getName() + " with name: " + nameOfAttachment);
        }
        return rVal;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setActivateTrigger(String value) throws GameParseException {
        String[] s = value.split(":");
        if (s.length != 6) {
            throw new GameParseException("activateTrigger must have 6 parts: triggerName:numberOfTimes:useUses:testUses:testConditions:testChance" + this.thisErrorMsg());
        }
        TriggerAttachment trigger = null;
        for (PlayerID player : this.getData().getPlayerList().getPlayers()) {
            for (TriggerAttachment ta : TriggerAttachment.getTriggers(player, this.getData(), null)) {
                if (!ta.getName().equals(s[0])) continue;
                trigger = ta;
                break;
            }
            if (trigger == null) continue;
            break;
        }
        if (trigger == null) {
            throw new GameParseException("No TriggerAttachment named: " + s[0] + this.thisErrorMsg());
        }
        String options = value;
        options = options.replaceFirst(s[0] + ":", "");
        int numberOfTimes = UserActionAttachment.getInt(s[1]);
        if (numberOfTimes < 0) {
            throw new GameParseException("activateTrigger must be positive for the number of times to fire: " + s[1] + this.thisErrorMsg());
        }
        UserActionAttachment.getBool(s[2]);
        UserActionAttachment.getBool(s[3]);
        UserActionAttachment.getBool(s[4]);
        UserActionAttachment.getBool(s[5]);
        this.m_activateTrigger.add(new Tuple<String, String>(s[0], options));
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setActivateTrigger(ArrayList<Tuple<String, String>> value) {
        this.m_activateTrigger = value;
    }

    public ArrayList<Tuple<String, String>> getActivateTrigger() {
        return this.m_activateTrigger;
    }

    public void clearActivateTrigger() {
        this.m_activateTrigger.clear();
    }

    public void resetActivateTrigger() {
        this.m_activateTrigger = new ArrayList();
    }

    public static void fireTriggers(UserActionAttachment actionAttachment, HashMap<ICondition, Boolean> testedConditionsSoFar, IDelegateBridge aBridge) {
        GameData data = aBridge.getData();
        for (Tuple<String, String> tuple : actionAttachment.getActivateTrigger()) {
            TriggerAttachment toFire = null;
            for (PlayerID player : data.getPlayerList().getPlayers()) {
                for (TriggerAttachment ta : TriggerAttachment.getTriggers(player, data, null)) {
                    if (!ta.getName().equals(tuple.getFirst())) continue;
                    toFire = ta;
                    break;
                }
                if (toFire == null) continue;
                break;
            }
            HashSet<TriggerAttachment> toFireSet = new HashSet<TriggerAttachment>();
            toFireSet.add(toFire);
            String[] options = tuple.getSecond().split(":");
            int numberOfTimesToFire = UserActionAttachment.getInt(options[0]);
            boolean useUsesToFire = UserActionAttachment.getBool(options[1]);
            boolean testUsesToFire = UserActionAttachment.getBool(options[2]);
            boolean testConditionsToFire = UserActionAttachment.getBool(options[3]);
            boolean testChanceToFire = UserActionAttachment.getBool(options[4]);
            if (testConditionsToFire) {
                if (!testedConditionsSoFar.containsKey(toFire)) {
                    TriggerAttachment.collectTestsForAllTriggers(toFireSet, aBridge, new HashSet<ICondition>(testedConditionsSoFar.keySet()), testedConditionsSoFar);
                }
                if (!AbstractTriggerAttachment.isSatisfiedMatch(testedConditionsSoFar).match(toFire)) continue;
            }
            for (int i = 0; i < numberOfTimesToFire; ++i) {
                aBridge.getHistoryWriter().startEvent(MyFormatter.attachmentNameToText(actionAttachment.getName()) + " activates a trigger called: " + MyFormatter.attachmentNameToText(toFire.getName()));
                TriggerAttachment.fireTriggers(toFireSet, testedConditionsSoFar, aBridge, null, null, useUsesToFire, testUsesToFire, testChanceToFire, false);
            }
        }
    }

    public Set<PlayerID> getOtherPlayers() {
        HashSet<PlayerID> otherPlayers = new HashSet<PlayerID>();
        otherPlayers.add((PlayerID)this.getAttachedTo());
        otherPlayers.addAll(this.m_actionAccept);
        return otherPlayers;
    }

    public static Collection<UserActionAttachment> getValidActions(PlayerID player, HashMap<ICondition, Boolean> testedConditions, GameData data) {
        return Match.getMatches(UserActionAttachment.getUserActionAttachments(player), new CompositeMatchAnd(Matches.AbstractUserActionAttachmentCanBeAttempted(testedConditions)));
    }

    @Override
    public void validate(GameData data) throws GameParseException {
        super.validate(data);
    }
}

