/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.common.delegate.BaseEditDelegate;
import games.strategy.common.delegate.BaseTripleADelegate;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.pbem.PBEMMessagePoster;
import games.strategy.triplea.Properties;
import games.strategy.triplea.delegate.AbstractMoveExtendedDelegateState;
import games.strategy.triplea.delegate.AirThatCantLandUtil;
import games.strategy.triplea.delegate.BattleTracker;
import games.strategy.triplea.delegate.DelegateFinder;
import games.strategy.triplea.delegate.MovePerformer;
import games.strategy.triplea.delegate.MoveValidator;
import games.strategy.triplea.delegate.SpecialMoveDelegate;
import games.strategy.triplea.delegate.UndoableMove;
import games.strategy.triplea.delegate.UnitsThatCantFightUtil;
import games.strategy.triplea.delegate.dataObjects.MoveValidationResult;
import games.strategy.triplea.delegate.remote.IMoveDelegate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public abstract class AbstractMoveDelegate
extends BaseTripleADelegate
implements IMoveDelegate {
    protected List<UndoableMove> m_movesToUndo = new ArrayList<UndoableMove>();
    protected MovePerformer m_tempMovePerformer;

    @Override
    public void start() {
        super.start();
        if (this.m_tempMovePerformer != null) {
            this.m_tempMovePerformer.initialize(this);
            this.m_tempMovePerformer.resume();
            this.m_tempMovePerformer = null;
        }
    }

    @Override
    public void end() {
        super.end();
        this.m_movesToUndo.clear();
    }

    @Override
    public Serializable saveState() {
        AbstractMoveExtendedDelegateState state = new AbstractMoveExtendedDelegateState();
        state.superState = super.saveState();
        state.m_movesToUndo = this.m_movesToUndo;
        state.m_tempMovePerformer = this.m_tempMovePerformer;
        return state;
    }

    @Override
    public void loadState(Serializable state) {
        AbstractMoveExtendedDelegateState s = (AbstractMoveExtendedDelegateState)state;
        super.loadState(s.superState);
        if (s.m_movesToUndo != null) {
            this.m_movesToUndo = s.m_movesToUndo;
        }
        this.m_tempMovePerformer = s.m_tempMovePerformer;
    }

    @Override
    public List<UndoableMove> getMovesMade() {
        return new ArrayList<UndoableMove>(this.m_movesToUndo);
    }

    @Override
    public String undoMove(int moveIndex) {
        if (this.m_movesToUndo.isEmpty()) {
            return "No moves to undo";
        }
        if (moveIndex >= this.m_movesToUndo.size()) {
            return "Undo move index out of range";
        }
        UndoableMove moveToUndo = this.m_movesToUndo.get(moveIndex);
        if (!moveToUndo.getcanUndo()) {
            return moveToUndo.getReasonCantUndo();
        }
        moveToUndo.undo(this.getData(), this.m_bridge);
        this.m_movesToUndo.remove(moveIndex);
        this.updateUndoableMoveIndexes();
        return null;
    }

    private void updateUndoableMoveIndexes() {
        for (int i = 0; i < this.m_movesToUndo.size(); ++i) {
            this.m_movesToUndo.get(i).setIndex(i);
        }
    }

    protected void updateUndoableMoves(UndoableMove currentMove) {
        currentMove.initializeDependencies(this.m_movesToUndo);
        this.m_movesToUndo.add(currentMove);
        this.updateUndoableMoveIndexes();
    }

    protected PlayerID getUnitsOwner(Collection<Unit> units) {
        if (units.isEmpty() || !BaseEditDelegate.getEditMode(this.getData())) {
            return this.m_player;
        }
        return units.iterator().next().getOwner();
    }

    @Override
    public String move(Collection<Unit> units, Route route) {
        return this.move(units, route, Collections.<Unit>emptyList());
    }

    @Override
    public String move(Collection<Unit> units, Route route, Collection<Unit> transportsThatCanBeLoaded) {
        return this.move(units, route, transportsThatCanBeLoaded, new HashMap<Unit, Collection<Unit>>());
    }

    @Override
    public abstract String move(Collection<Unit> var1, Route var2, Collection<Unit> var3, Map<Unit, Collection<Unit>> var4);

    public static MoveValidationResult validateMove(MoveType moveType, Collection<Unit> units, Route route, PlayerID player, Collection<Unit> transportsToLoad, Map<Unit, Collection<Unit>> newDependents, boolean isNonCombat, List<UndoableMove> undoableMoves, GameData data) {
        if (moveType == MoveType.SPECIAL) {
            return SpecialMoveDelegate.validateMove(units, route, player, transportsToLoad, newDependents, isNonCombat, undoableMoves, data);
        }
        return MoveValidator.validateMove(units, route, player, transportsToLoad, newDependents, isNonCombat, undoableMoves, data);
    }

    @Override
    public Collection<Territory> getTerritoriesWhereAirCantLand(PlayerID player) {
        return new AirThatCantLandUtil(this.m_bridge).getTerritoriesWhereAirCantLand(player);
    }

    @Override
    public Collection<Territory> getTerritoriesWhereAirCantLand() {
        return new AirThatCantLandUtil(this.m_bridge).getTerritoriesWhereAirCantLand(this.m_player);
    }

    @Override
    public Collection<Territory> getTerritoriesWhereUnitsCantFight() {
        return new UnitsThatCantFightUtil(this.getData()).getTerritoriesWhereUnitsCantFight(this.m_player);
    }

    public Route getRouteUsedToMoveInto(Unit unit, Territory end) {
        return AbstractMoveDelegate.getRouteUsedToMoveInto(this.m_movesToUndo, unit, end);
    }

    public static Route getRouteUsedToMoveInto(List<UndoableMove> undoableMoves, Unit unit, Territory end) {
        ListIterator<UndoableMove> iter = undoableMoves.listIterator(undoableMoves.size());
        while (iter.hasPrevious()) {
            UndoableMove move = iter.previous();
            if (!move.getUnits().contains(unit) || !move.getRoute().getEnd().equals(end)) continue;
            return move.getRoute();
        }
        return null;
    }

    public static BattleTracker getBattleTracker(GameData data) {
        return DelegateFinder.battleDelegate(data).getBattleTracker();
    }

    protected boolean isWW2V2() {
        return Properties.getWW2V2(this.getData());
    }

    @Override
    public void setHasPostedTurnSummary(boolean hasPostedTurnSummary) {
    }

    @Override
    public boolean getHasPostedTurnSummary() {
        return false;
    }

    @Override
    public boolean postTurnSummary(PBEMMessagePoster poster, String title, boolean includeSaveGame) {
        return poster.post(this.m_bridge.getHistoryWriter(), title, includeSaveGame);
    }

    public abstract int PUsAlreadyLost(Territory var1);

    public abstract void PUsLost(Territory var1, int var2);

    public Class<IMoveDelegate> getRemoteType() {
        return IMoveDelegate.class;
    }

    public static enum MoveType {
        DEFAULT,
        SPECIAL;

    }
}

