/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.common.delegate.BaseTripleADelegate;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.message.IRemote;
import games.strategy.triplea.Properties;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.attatchments.PlayerAttachment;
import games.strategy.triplea.attatchments.RulesAttachment;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.AirMovementValidator;
import games.strategy.triplea.delegate.AirThatCantLandUtil;
import games.strategy.triplea.delegate.BattleTracker;
import games.strategy.triplea.delegate.DelegateFinder;
import games.strategy.triplea.delegate.GameStepPropertiesHelper;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.OriginalOwnerTracker;
import games.strategy.triplea.delegate.PlaceExtendedDelegateState;
import games.strategy.triplea.delegate.UndoablePlacement;
import games.strategy.triplea.delegate.dataObjects.PlaceableUnits;
import games.strategy.triplea.delegate.remote.IAbstractPlaceDelegate;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import games.strategy.util.Tuple;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractPlaceDelegate
extends BaseTripleADelegate
implements IAbstractPlaceDelegate {
    protected Map<Territory, Collection<Unit>> m_produced = new HashMap<Territory, Collection<Unit>>();
    protected List<UndoablePlacement> m_placements = new ArrayList<UndoablePlacement>();

    public void initialize(String name) {
        this.initialize(name, name);
    }

    @Override
    public void start() {
        super.start();
    }

    @Override
    public void end() {
        super.end();
        this.doAfterEnd();
    }

    protected void doAfterEnd() {
        PlayerID player = this.m_bridge.getPlayerID();
        Collection<Unit> units = player.getUnits().getUnits();
        GameData data = this.getData();
        if (!Properties.getUnplacedUnitsLive(data) && !units.isEmpty()) {
            this.m_bridge.getHistoryWriter().startEvent(MyFormatter.unitsToTextNoOwner(units) + " were produced but were not placed", units);
            Change change = ChangeFactory.removeUnits(player, units);
            this.m_bridge.addChange(change);
        }
        this.m_produced = new HashMap<Territory, Collection<Unit>>();
        this.m_placements.clear();
        if (GameStepPropertiesHelper.isRemoveAirThatCanNotLand(data)) {
            this.removeAirThatCantLand();
        }
    }

    @Override
    public boolean delegateCurrentlyRequiresUserInput() {
        return this.m_player != null && (this.m_player.getUnits().size() != 0 || this.getPlacementsMade() != 0);
    }

    protected void removeAirThatCantLand() {
        GameData data = this.getData();
        AirThatCantLandUtil util = new AirThatCantLandUtil(this.m_bridge);
        util.removeAirThatCantLand(this.m_player, false);
        for (PlayerID player : data.getPlayerList()) {
            if (player.equals(this.m_player)) continue;
            util.removeAirThatCantLand(player, false);
        }
    }

    @Override
    public Serializable saveState() {
        PlaceExtendedDelegateState state = new PlaceExtendedDelegateState();
        state.superState = super.saveState();
        state.m_produced = this.m_produced;
        state.m_placements = this.m_placements;
        return state;
    }

    @Override
    public void loadState(Serializable state) {
        PlaceExtendedDelegateState s = (PlaceExtendedDelegateState)state;
        super.loadState(s.superState);
        this.m_produced = s.m_produced;
        this.m_placements = s.m_placements;
    }

    protected Collection<Unit> getAlreadyProduced(Territory t) {
        ArrayList<Unit> rVal = new ArrayList<Unit>();
        if (this.m_produced.containsKey(t)) {
            rVal.addAll(this.m_produced.get(t));
        }
        return rVal;
    }

    @Override
    public int getPlacementsMade() {
        return this.m_placements.size();
    }

    void setProduced(Map<Territory, Collection<Unit>> produced) {
        this.m_produced = produced;
    }

    protected final Map<Territory, Collection<Unit>> getProduced() {
        return this.m_produced;
    }

    @Override
    public List<UndoablePlacement> getMovesMade() {
        return this.m_placements;
    }

    @Override
    public String undoMove(int moveIndex) {
        if (moveIndex < this.m_placements.size() && moveIndex >= 0) {
            UndoablePlacement undoPlace = this.m_placements.get(moveIndex);
            undoPlace.undo(this.getData(), this.m_bridge);
            this.m_placements.remove(moveIndex);
            this.updateUndoablePlacementIndexes();
        }
        return null;
    }

    protected void updateUndoablePlacementIndexes() {
        for (int i = 0; i < this.m_placements.size(); ++i) {
            this.m_placements.get(i).setIndex(i);
        }
    }

    @Override
    public PlaceableUnits getPlaceableUnits(Collection<Unit> units, Territory to) {
        String error = this.canProduce(to, units, this.m_player);
        if (error != null) {
            return new PlaceableUnits(error);
        }
        Collection<Unit> placeableUnits = this.getUnitsToBePlaced(to, units, this.m_player);
        int maxUnits = this.getMaxUnitsToBePlaced(placeableUnits, to, this.m_player, true);
        return new PlaceableUnits(placeableUnits, maxUnits);
    }

    @Override
    public String placeUnits(Collection<Unit> units, Territory at) {
        if (units == null || units.isEmpty()) {
            return null;
        }
        String error = this.isValidPlacement(units, at, this.m_player);
        if (error != null) {
            return error;
        }
        this.performPlace(new ArrayList<Unit>(units), at, this.m_player);
        return null;
    }

    protected void performPlace(Collection<Unit> units, Territory at, PlayerID player) {
        List<Territory> producers = this.getAllProducers(at, player, units);
        Collections.sort(producers, this.getBestProducerComparator(at, units, player));
        IntegerMap<Territory> maxPlaceableMap = this.getMaxUnitsToBePlacedMap(units, at, player, true);
        ArrayList<Unit> unitsLeftToPlace = new ArrayList<Unit>(units);
        Collections.sort(unitsLeftToPlace, this.getUnitConstructionComparator());
        for (Territory producer : producers) {
            if (unitsLeftToPlace.isEmpty()) break;
            ArrayList<Unit> unitsCanBePlacedByThisProducer = this.isUnitPlacementRestrictions() ? Match.getMatches(unitsLeftToPlace, this.unitWhichRequiresUnitsHasRequiredUnits(producer, true)) : new ArrayList<Unit>(unitsLeftToPlace);
            Collections.sort(unitsCanBePlacedByThisProducer, this.getHardestToPlaceWithRequiresUnitsRestrictions(true));
            int maxPlaceable = maxPlaceableMap.getInt(producer);
            if (maxPlaceable == 0) continue;
            int maxForThisProducer = this.getMaxUnitsToBePlacedFrom(producer, unitsCanBePlacedByThisProducer, at, player);
            if (maxForThisProducer == -1 || maxForThisProducer >= unitsCanBePlacedByThisProducer.size()) {
                this.performPlaceFrom(producer, unitsCanBePlacedByThisProducer, at, player);
                unitsLeftToPlace.removeAll(unitsCanBePlacedByThisProducer);
                continue;
            }
            int neededExtra = unitsCanBePlacedByThisProducer.size() - maxForThisProducer;
            if (maxPlaceable > maxForThisProducer) {
                this.freePlacementCapacity(producer, neededExtra, unitsCanBePlacedByThisProducer, at, player);
                int newMaxForThisProducer = this.getMaxUnitsToBePlacedFrom(producer, unitsCanBePlacedByThisProducer, at, player);
                if (newMaxForThisProducer != maxPlaceable && neededExtra > newMaxForThisProducer) {
                    throw new IllegalStateException("getMaxUnitsToBePlaced originally returned: " + maxPlaceable + ", \r\nWhich is not the same as it is returning after using freePlacementCapacity: " + newMaxForThisProducer + ", \r\nFor territory: " + at.getName() + ", Current Producer: " + producer.getName() + ", All Producers: " + producers + ", \r\nUnits Total: " + MyFormatter.unitsToTextNoOwner(units) + ", Units Left To Place By This Producer: " + MyFormatter.unitsToTextNoOwner(unitsCanBePlacedByThisProducer));
                }
            }
            List<Unit> placedUnits = Match.getNMatches(unitsCanBePlacedByThisProducer, maxPlaceable, Match.ALWAYS_MATCH);
            this.performPlaceFrom(producer, placedUnits, at, player);
            unitsLeftToPlace.removeAll(placedUnits);
        }
        if (!unitsLeftToPlace.isEmpty()) {
            throw new IllegalStateException("Not all units placed in: " + at.getName() + " units: " + unitsLeftToPlace);
        }
        if (Match.someMatch(units, Matches.UnitIsInfrastructure)) {
            this.m_bridge.getSoundChannelBroadcaster().playSoundForAll("placed_infrastructure", this.m_player.getName());
        } else if (Match.someMatch(units, Matches.UnitIsSea)) {
            this.m_bridge.getSoundChannelBroadcaster().playSoundForAll("placed_sea", this.m_player.getName());
        } else if (Match.someMatch(units, Matches.UnitIsAir)) {
            this.m_bridge.getSoundChannelBroadcaster().playSoundForAll("placed_air", this.m_player.getName());
        } else {
            this.m_bridge.getSoundChannelBroadcaster().playSoundForAll("placed_land", this.m_player.getName());
        }
    }

    protected void performPlaceFrom(Territory producer, Collection<Unit> placeableUnits, Territory at, PlayerID player) {
        CompositeChange change = new CompositeChange();
        boolean didIt = this.canWeConsumeUnits(placeableUnits, at, true, change);
        if (!didIt) {
            throw new IllegalStateException("Something wrong with consuming/upgrading units");
        }
        List<Unit> factoryAndInfrastructure = Match.getMatches(placeableUnits, Matches.UnitIsInfrastructure);
        if (!factoryAndInfrastructure.isEmpty()) {
            change.add(OriginalOwnerTracker.addOriginalOwnerChange(factoryAndInfrastructure, player));
        }
        String movedAirTranscriptTextForHistory = this.moveAirOntoNewCarriers(at, producer, placeableUnits, player, change);
        Change remove = ChangeFactory.removeUnits(player, placeableUnits);
        Change place = ChangeFactory.addUnits(at, placeableUnits);
        change.add(remove);
        change.add(place);
        UndoablePlacement current_placement = new UndoablePlacement(this.m_player, change, producer, at, placeableUnits);
        this.m_placements.add(current_placement);
        this.updateUndoablePlacementIndexes();
        String transcriptText = MyFormatter.unitsToTextNoOwner(placeableUnits) + " placed in " + at.getName();
        this.m_bridge.getHistoryWriter().startEvent(transcriptText, current_placement.getDescriptionObject());
        if (movedAirTranscriptTextForHistory != null) {
            this.m_bridge.getHistoryWriter().addChildToEvent(movedAirTranscriptTextForHistory);
        }
        this.m_bridge.addChange(change);
        this.updateProducedMap(producer, placeableUnits);
    }

    protected void updateProducedMap(Territory producer, Collection<Unit> additionallyProducedUnits) {
        Collection<Unit> newProducedUnits = this.getAlreadyProduced(producer);
        newProducedUnits.addAll(additionallyProducedUnits);
        this.m_produced.put(producer, newProducedUnits);
    }

    protected void removeFromProducedMap(Territory producer, Collection<Unit> unitsToRemove) {
        Collection<Unit> newProducedUnits = this.getAlreadyProduced(producer);
        newProducedUnits.removeAll(unitsToRemove);
        if (newProducedUnits.isEmpty()) {
            this.m_produced.remove(producer);
        } else {
            this.m_produced.put(producer, newProducedUnits);
        }
    }

    protected void freePlacementCapacity(Territory producer, int freeSize, Collection<Unit> unitsLeftToPlace, Territory at, PlayerID player) {
        int foundSpaceTotal = 0;
        ArrayList<UndoablePlacement> redoPlacements = new ArrayList<UndoablePlacement>();
        HashMap<Territory, Integer> redoPlacementsCount = new HashMap<Territory, Integer>();
        for (UndoablePlacement placement : this.m_placements) {
            Territory placeTerritory;
            if (!placement.getProducerTerritory().equals(producer) || !(placeTerritory = placement.getPlaceTerritory()).isWater() || placeTerritory.equals(producer) || this.isUnitPlacementRestrictions() && Match.someMatch(placement.getUnits(), Matches.UnitRequiresUnitsOnCreation)) continue;
            redoPlacements.add(placement);
            Integer integer = (Integer)redoPlacementsCount.get(placeTerritory);
            if (integer == null) {
                redoPlacementsCount.put(placeTerritory, placement.getUnits().size());
                continue;
            }
            redoPlacementsCount.put(placeTerritory, integer + placement.getUnits().size());
        }
        ArrayList<Tuple<UndoablePlacement, Territory>> splitPlacements = new ArrayList<Tuple<UndoablePlacement, Territory>>();
        for (Map.Entry entry : redoPlacementsCount.entrySet()) {
            Territory placeTerritory = (Territory)entry.getKey();
            int n = (Integer)entry.getValue();
            List<Territory> potentialNewProducers = this.getAllProducers(placeTerritory, player, unitsLeftToPlace);
            potentialNewProducers.remove(producer);
            Collections.sort(potentialNewProducers, this.getBestProducerComparator(placeTerritory, unitsLeftToPlace, player));
            int maxSpaceToBeFree = Math.min(n, freeSize - foundSpaceTotal);
            int spaceAlreadyFree = 0;
            for (Territory potentialNewProducerTerritory : potentialNewProducers) {
                int leftToPlace = this.getMaxUnitsToBePlacedFrom(potentialNewProducerTerritory, this.unitsPlacedInTerritorySoFar(placeTerritory), placeTerritory, player);
                if (leftToPlace == -1) {
                    leftToPlace = n;
                }
                for (UndoablePlacement placement : redoPlacements) {
                    if (!placement.getPlaceTerritory().equals(placeTerritory)) continue;
                    Collection<Unit> placedUnits = placement.getUnits();
                    int placementSize = placedUnits.size();
                    if (placementSize <= leftToPlace) {
                        placement.setProducerTerritory(potentialNewProducerTerritory);
                        this.removeFromProducedMap(producer, placedUnits);
                        this.updateProducedMap(potentialNewProducerTerritory, placedUnits);
                        spaceAlreadyFree += placementSize;
                    } else {
                        splitPlacements.add(new Tuple<UndoablePlacement, Territory>(placement, potentialNewProducerTerritory));
                    }
                    if (spaceAlreadyFree < maxSpaceToBeFree) continue;
                    break;
                }
                if (spaceAlreadyFree < maxSpaceToBeFree) continue;
                break;
            }
            if ((foundSpaceTotal += spaceAlreadyFree) < freeSize) continue;
            break;
        }
        boolean unusedSplitPlacments = false;
        ArrayList<UndoablePlacement> usedUnoablePlacements = new ArrayList<UndoablePlacement>();
        if (foundSpaceTotal < freeSize) {
            for (Tuple tuple : splitPlacements) {
                UndoablePlacement placement = (UndoablePlacement)tuple.getFirst();
                if (usedUnoablePlacements.contains(placement)) {
                    unusedSplitPlacments = true;
                    continue;
                }
                Territory newProducer = (Territory)tuple.getSecond();
                int leftToPlace = this.getMaxUnitsToBePlacedFrom(newProducer, unitsLeftToPlace, at, player);
                foundSpaceTotal += leftToPlace;
                ArrayList<Unit> unitsForOldProducer = new ArrayList<Unit>(placement.getUnits());
                ArrayList<Unit> unitsForNewProducer = new ArrayList<Unit>();
                for (Unit unit : unitsForOldProducer) {
                    if (leftToPlace == 0) break;
                    unitsForNewProducer.add(unit);
                    --leftToPlace;
                }
                unitsForOldProducer.removeAll(unitsForNewProducer);
                if (unitsForNewProducer.isEmpty()) continue;
                usedUnoablePlacements.add(placement);
                this.undoMove(placement.getIndex());
                this.performPlaceFrom(newProducer, unitsForNewProducer, placement.getPlaceTerritory(), player);
                this.performPlaceFrom(producer, unitsForOldProducer, placement.getPlaceTerritory(), player);
            }
        }
        if (foundSpaceTotal < freeSize && unusedSplitPlacments) {
            this.freePlacementCapacity(producer, freeSize - foundSpaceTotal, unitsLeftToPlace, at, player);
        }
    }

    protected String moveAirOntoNewCarriers(Territory at, Territory producer, Collection<Unit> units, PlayerID player, CompositeChange placeChange) {
        if (!at.isWater()) {
            return null;
        }
        if (!this.canMoveExistingFightersToNewCarriers() || AirThatCantLandUtil.isLHTRCarrierProduction(this.getData())) {
            return null;
        }
        if (Match.noneMatch(units, Matches.UnitIsCarrier)) {
            return null;
        }
        int capacity = AirMovementValidator.carrierCapacity(units, at);
        if ((capacity -= AirMovementValidator.carrierCost(units)) <= 0) {
            return null;
        }
        if (!Matches.TerritoryIsLand.match(producer)) {
            return null;
        }
        if (!producer.getUnits().someMatch(Matches.UnitCanProduceUnits)) {
            return null;
        }
        CompositeMatchAnd<Unit> ownedFighters = new CompositeMatchAnd<Unit>(Matches.UnitCanLandOnCarrier, Matches.unitIsOwnedBy(player));
        if (!producer.getUnits().someMatch(ownedFighters)) {
            return null;
        }
        if (this.wasConquered(producer)) {
            return null;
        }
        if (Match.someMatch(this.getAlreadyProduced(producer), Matches.UnitCanProduceUnits)) {
            return null;
        }
        List<Unit> fighters = producer.getUnits().getMatches(ownedFighters);
        while (fighters.size() > 0 && AirMovementValidator.carrierCost(fighters) > capacity) {
            fighters.remove(0);
        }
        if (fighters.size() == 0) {
            return null;
        }
        Collection<Unit> movedFighters = this.getRemotePlayer().getNumberOfFightersToMoveToNewCarrier(fighters, producer);
        if (movedFighters == null || movedFighters.isEmpty()) {
            return null;
        }
        Change change = ChangeFactory.moveUnits(producer, at, movedFighters);
        placeChange.add(change);
        String transcriptText = MyFormatter.unitsToTextNoOwner(movedFighters) + " moved from " + producer.getName() + " to " + at.getName();
        return transcriptText;
    }

    protected String isValidPlacement(Collection<Unit> units, Territory at, PlayerID player) {
        String error = this.playerHasEnoughUnits(units, at, player);
        if (error != null) {
            return error;
        }
        error = this.canProduce(at, units, player);
        if (error != null) {
            return error;
        }
        error = this.checkProduction(at, units, player);
        if (error != null) {
            return error;
        }
        error = this.canUnitsBePlaced(at, units, player);
        if (error != null) {
            return error;
        }
        return null;
    }

    String playerHasEnoughUnits(Collection<Unit> units, Territory at, PlayerID player) {
        if (!player.getUnits().getUnits().containsAll(units)) {
            return "Not enough units";
        }
        return null;
    }

    protected String canProduce(Territory to, Collection<Unit> units, PlayerID player) {
        List<Territory> producers = this.getAllProducers(to, player, units, true);
        if (producers.isEmpty()) {
            return "No factory in or adjacent to " + to.getName();
        }
        if (producers.size() == 1) {
            return this.canProduce((Territory)producers.iterator().next(), to, units, player);
        }
        ArrayList<Territory> failingProducers = new ArrayList<Territory>();
        String error = "";
        for (Territory producer : producers) {
            String errorP = this.canProduce(producer, to, units, player);
            if (errorP == null) continue;
            failingProducers.add(producer);
            if (producer.equals(to) && producer.isWater()) continue;
            error = error + ", " + errorP;
        }
        if (producers.size() == failingProducers.size()) {
            return "Adjacent territories to " + to.getName() + " cannot produce, due to: \n " + error.replaceFirst(", ", "");
        }
        return null;
    }

    protected String canProduce(Territory producer, Territory to, Collection<Unit> units, PlayerID player) {
        return this.canProduce(producer, to, units, player, false);
    }

    protected String canProduce(Territory producer, Territory to, Collection<Unit> units, PlayerID player, boolean simpleCheck) {
        ArrayList<Unit> testUnits = units == null ? new ArrayList<Unit>() : units;
        boolean canProduceInConquered = this.isPlacementAllowedInCapturedTerritory(player);
        if (!producer.getOwner().equals(player)) {
            if (producer.isWater() && Match.someMatch(testUnits, new CompositeMatchAnd(Matches.UnitIsSea, Matches.UnitIsConstruction))) {
                boolean ownedNeighbor = false;
                for (Territory current : this.getData().getMap().getNeighbors(to, Matches.TerritoryIsLand)) {
                    if (!current.getOwner().equals(player) || !canProduceInConquered && this.wasConquered(current)) continue;
                    ownedNeighbor = true;
                    break;
                }
                if (!ownedNeighbor) {
                    return producer.getName() + " is not owned by you, and you have no owned neighbors which can produce";
                }
            } else {
                return producer.getName() + " is not owned by you";
            }
        }
        if (!canProduceInConquered && this.wasConquered(producer)) {
            return producer.getName() + " was conquered this turn and cannot produce till next turn";
        }
        if (this.isPlayerAllowedToPlacementAnyTerritoryOwnedLand(player) && Matches.TerritoryIsLand.match(to) && Matches.isTerritoryOwnedBy(player).match(to)) {
            return null;
        }
        if (this.isPlayerAllowedToPlacementAnySeaZoneByOwnedLand(player) && Matches.TerritoryIsWater.match(to) && Matches.isTerritoryOwnedBy(player).match(producer)) {
            return null;
        }
        if (simpleCheck) {
            return null;
        }
        if (this.isUnitPlacementRestrictions() && !testUnits.isEmpty() && !Match.someMatch(testUnits, this.unitWhichRequiresUnitsHasRequiredUnits(producer, true))) {
            return "You do not have the required units to build in " + producer.getName();
        }
        if (to.isWater() && !this.isWW2V2() && !this.isUnitPlacementInEnemySeas() && to.getUnits().someMatch(Matches.enemyUnit(player, this.getData()))) {
            return "Cannot place sea units with enemy naval units";
        }
        if (this.wasOwnedUnitThatCanProduceUnitsOrIsFactoryInTerritoryAtStartOfStep(producer, player)) {
            return null;
        }
        if (Match.someMatch(testUnits, Matches.UnitIsConstruction)) {
            if (this.howManyOfEachConstructionCanPlace(to, producer, testUnits, player).totalValues() > 0) {
                return null;
            }
            return "No more Constructions Allowed in " + producer.getName();
        }
        if (Match.someMatch(this.getAlreadyProduced(producer), Matches.UnitCanProduceUnits) || Match.someMatch(this.getAlreadyProduced(to), Matches.UnitCanProduceUnits)) {
            return "Factory in " + producer.getName() + " cant produce until 1 turn after it is created";
        }
        return "No Factory in " + producer.getName();
    }

    protected List<Territory> getAllProducers(Territory to, PlayerID player, Collection<Unit> unitsToPlace, boolean simpleCheck) {
        ArrayList<Territory> producers = new ArrayList<Territory>();
        if (!to.isWater()) {
            if (simpleCheck || this.canProduce(to, to, unitsToPlace, player, simpleCheck) == null) {
                producers.add(to);
            }
            return producers;
        }
        if (this.canProduce(to, to, unitsToPlace, player, simpleCheck) == null) {
            producers.add(to);
        }
        for (Territory current : this.getData().getMap().getNeighbors(to, Matches.TerritoryIsLand)) {
            if (this.canProduce(current, to, unitsToPlace, player, simpleCheck) != null) continue;
            producers.add(current);
        }
        return producers;
    }

    protected String checkProduction(Territory to, Collection<Unit> units, PlayerID player) {
        List<Territory> producers = this.getAllProducers(to, player, units);
        if (producers.isEmpty()) {
            return "No factory in or adjacent to " + to.getName();
        }
        Collections.sort(producers, this.getBestProducerComparator(to, units, player));
        TerritoryAttachment ta = TerritoryAttachment.get(producers.iterator().next());
        if (!this.getCanAllUnitsWithRequiresUnitsBePlacedCorrectly(units, to)) {
            return "Cannot place more units which require units, than production capacity of territories with the required units";
        }
        int maxUnitsToBePlaced = this.getMaxUnitsToBePlaced(units, to, player, true);
        if (maxUnitsToBePlaced != -1 && maxUnitsToBePlaced < units.size()) {
            return "Cannot place " + units.size() + " more units in " + to.getName();
        }
        return null;
    }

    public String canUnitsBePlaced(Territory to, Collection<Unit> units, PlayerID player) {
        Collection<Unit> allowedUnits = this.getUnitsToBePlaced(to, units, player);
        if (allowedUnits == null || !allowedUnits.containsAll(units)) {
            return "Cannot place these units in " + to.getName();
        }
        IntegerMap<String> constructionMap = this.howManyOfEachConstructionCanPlace(to, to, units, player);
        for (Unit currentUnit : Match.getMatches(units, Matches.UnitIsConstruction)) {
            UnitAttachment ua = UnitAttachment.get(currentUnit.getUnitType());
            constructionMap.add(ua.getConstructionType(), -1);
        }
        if (!constructionMap.isPositive()) {
            return "Too many constructions in " + to.getName();
        }
        ArrayList<Territory> capitalsListOwned = new ArrayList<Territory>(TerritoryAttachment.getAllCurrentlyOwnedCapitals(player, this.getData()));
        if (!capitalsListOwned.contains(to) && this.isPlacementInCapitalRestricted(player)) {
            return "Cannot place these units outside of the capital";
        }
        if (to.isWater()) {
            String canLand = this.validateNewAirCanLandOnCarriers(to, units);
            if (canLand != null) {
                return canLand;
            }
        } else {
            if (!to.getOwner().equals(player)) {
                if (GameStepPropertiesHelper.isBid(this.getData())) {
                    PlayerAttachment pa = PlayerAttachment.get(to.getOwner());
                    if (!(pa != null && pa.getGiveUnitControl() != null && pa.getGiveUnitControl().contains(player) || to.getUnits().someMatch(Matches.unitIsOwnedBy(player)))) {
                        return "You don't own " + to.getName();
                    }
                } else {
                    return "You don't own " + to.getName();
                }
            }
            if (!Match.allMatch(units, Matches.UnitIsNotSea)) {
                return "Cant place sea units on land";
            }
        }
        if (!this.canWeConsumeUnits(units, to, false, null)) {
            return "Not Enough Units To Upgrade or Be Consumed";
        }
        ArrayList<UnitType> typesAlreadyChecked = new ArrayList<UnitType>();
        for (Unit currentUnit : units) {
            UnitType ut = currentUnit.getType();
            if (typesAlreadyChecked.contains(ut)) continue;
            typesAlreadyChecked.add(ut);
            int maxForThisType = UnitAttachment.getMaximumNumberOfThisUnitTypeToReachStackingLimit("placementLimit", ut, to, player, this.getData());
            if (Match.countMatches(units, Matches.unitIsOfType(ut)) <= maxForThisType) continue;
            return "UnitType " + ut.getName() + " is over stacking limit of " + maxForThisType;
        }
        if (!PlayerAttachment.getCanTheseUnitsMoveWithoutViolatingStackingLimit("placementLimit", units, to, player, this.getData())) {
            return "Units Can Not Go Over Stacking Limit";
        }
        if (!this.isUnitPlacementRestrictions()) {
            return null;
        }
        for (Unit currentUnit : units) {
            UnitAttachment ua = UnitAttachment.get(currentUnit.getUnitType());
            TerritoryAttachment ta = TerritoryAttachment.get(to);
            if (ua.getCanOnlyBePlacedInTerritoryValuedAtX() != -1 && ua.getCanOnlyBePlacedInTerritoryValuedAtX() > (ta == null ? 0 : ta.getProduction())) {
                return "Cannot place these units in " + to.getName() + " due to Unit Placement Restrictions on Territory Value";
            }
            String[] terrs = ua.getUnitPlacementRestrictions();
            Collection<Territory> listedTerrs = this.getListedTerritories(terrs);
            if (listedTerrs.contains(to)) {
                return "Cannot place these units in " + to.getName() + " due to Unit Placement Restrictions";
            }
            if (this.unitWhichRequiresUnitsHasRequiredUnits(to, false).invert().match(currentUnit)) {
                return "Cannot place these units in " + to.getName() + " as territory does not contain required units at start of turn";
            }
            if (!Matches.UnitCanOnlyPlaceInOriginalTerritories.match(currentUnit) || Matches.TerritoryIsOriginallyOwnedBy(player).match(to)) continue;
            return "Cannot place these units in " + to.getName() + " as territory is not originally owned";
        }
        return null;
    }

    protected Collection<Unit> getUnitsToBePlaced(Territory to, Collection<Unit> units, PlayerID player) {
        if (to.isWater()) {
            return this.getUnitsToBePlacedSea(to, units, player);
        }
        return this.getUnitsToBePlacedLand(to, units, player);
    }

    protected Collection<Unit> getUnitsToBePlacedSea(Territory to, Collection<Unit> units, PlayerID player) {
        return this.getUnitsToBePlacedAllDefault(to, units, player);
    }

    protected Collection<Unit> getUnitsToBePlacedLand(Territory to, Collection<Unit> units, PlayerID player) {
        return this.getUnitsToBePlacedAllDefault(to, units, player);
    }

    protected Collection<Unit> getUnitsToBePlacedAllDefault(Territory to, Collection<Unit> allUnits, PlayerID player) {
        boolean water = to.isWater();
        if (water && !this.isWW2V2() && !this.isUnitPlacementInEnemySeas() && to.getUnits().someMatch(Matches.enemyUnit(player, this.getData()))) {
            return null;
        }
        ArrayList<Unit> units = new ArrayList<Unit>(allUnits);
        units.removeAll(Match.getMatches(units, water ? Matches.UnitIsLand : Matches.UnitIsSea));
        ArrayList<Unit> placeableUnits = new ArrayList<Unit>();
        Collection<Unit> unitsAtStartOfTurnInTO = this.unitsAtStartOfStepInTerritory(to);
        Collection<Unit> allProducedUnits = this.unitsPlacedInTerritorySoFar(to);
        boolean isBid = GameStepPropertiesHelper.isBid(this.getData());
        boolean wasFactoryThereAtStart = this.wasOwnedUnitThatCanProduceUnitsOrIsFactoryInTerritoryAtStartOfStep(to, player);
        if (water || wasFactoryThereAtStart || !water && this.isPlayerAllowedToPlacementAnyTerritoryOwnedLand(player)) {
            placeableUnits.addAll(Match.getMatches(units, new CompositeMatchAnd(water ? Matches.UnitIsSea : Matches.UnitIsLand, Matches.UnitIsNotConstruction)));
            if (!water) {
                placeableUnits.addAll(Match.getMatches(units, new CompositeMatchAnd(Matches.UnitIsAir, Matches.UnitIsNotConstruction)));
            } else if ((isBid || this.canProduceFightersOnCarriers() || AirThatCantLandUtil.isLHTRCarrierProduction(this.getData())) && Match.someMatch(allProducedUnits, Matches.UnitIsCarrier) || (isBid || this.canProduceNewFightersOnOldCarriers() || AirThatCantLandUtil.isLHTRCarrierProduction(this.getData())) && Match.someMatch(to.getUnits().getUnits(), Matches.UnitIsCarrier)) {
                placeableUnits.addAll(Match.getMatches(units, new CompositeMatchAnd(Matches.UnitIsAir, Matches.UnitCanLandOnCarrier)));
            }
        }
        if (Match.someMatch(units, Matches.UnitIsConstruction)) {
            IntegerMap<String> constructionsMap = this.howManyOfEachConstructionCanPlace(to, to, units, player);
            ArrayList<Unit> skipUnits = new ArrayList<Unit>();
            for (Unit currentUnit : Match.getMatches(units, Matches.UnitIsConstruction)) {
                int maxUnits = this.howManyOfConstructionUnit(currentUnit, constructionsMap);
                if (maxUnits <= 0 || skipUnits.contains(currentUnit)) continue;
                placeableUnits.addAll(Match.getNMatches(units, maxUnits, Matches.unitIsOfType(currentUnit.getType())));
                skipUnits.addAll(Match.getMatches(units, Matches.unitIsOfType(currentUnit.getType())));
            }
        }
        if (Match.someMatch(placeableUnits, Matches.UnitConsumesUnitsOnCreation)) {
            List<Unit> unitsWhichConsume = Match.getMatches(placeableUnits, Matches.UnitConsumesUnitsOnCreation);
            for (Unit unit : unitsWhichConsume) {
                if (!Matches.UnitWhichConsumesUnitsHasRequiredUnits(unitsAtStartOfTurnInTO, to).invert().match(unit)) continue;
                placeableUnits.remove(unit);
            }
        }
        ArrayList<Unit> placeableUnits2 = new ArrayList<Unit>();
        ArrayList<UnitType> typesAlreadyChecked = new ArrayList<UnitType>();
        for (Unit currentUnit : placeableUnits) {
            UnitType ut = currentUnit.getType();
            if (typesAlreadyChecked.contains(ut)) continue;
            typesAlreadyChecked.add(ut);
            placeableUnits2.addAll(Match.getNMatches(placeableUnits, UnitAttachment.getMaximumNumberOfThisUnitTypeToReachStackingLimit("placementLimit", ut, to, player, this.getData()), Matches.unitIsOfType(ut)));
        }
        if (!this.isUnitPlacementRestrictions()) {
            return placeableUnits2;
        }
        ArrayList<Unit> placeableUnits3 = new ArrayList<Unit>();
        for (Unit currentUnit : placeableUnits2) {
            String[] terrs;
            Collection<Territory> listedTerrs;
            UnitAttachment ua = UnitAttachment.get(currentUnit.getUnitType());
            TerritoryAttachment ta = TerritoryAttachment.get(to);
            if (ua.getCanOnlyBePlacedInTerritoryValuedAtX() != -1 && ua.getCanOnlyBePlacedInTerritoryValuedAtX() > (ta == null ? 0 : ta.getProduction()) || this.unitWhichRequiresUnitsHasRequiredUnits(to, false).invert().match(currentUnit) || Matches.UnitCanOnlyPlaceInOriginalTerritories.match(currentUnit) && !Matches.TerritoryIsOriginallyOwnedBy(player).match(to) || (listedTerrs = this.getListedTerritories(terrs = ua.getUnitPlacementRestrictions())).contains(to)) continue;
            placeableUnits3.add(currentUnit);
        }
        return placeableUnits3;
    }

    protected boolean canWeConsumeUnits(Collection<Unit> units, Territory to, boolean actuallyDoIt, CompositeChange change) {
        boolean weCanConsume = true;
        Collection<Unit> unitsAtStartOfTurnInTO = this.unitsAtStartOfStepInTerritory(to);
        ArrayList<Unit> removedUnits = new ArrayList<Unit>();
        List<Unit> unitsWhichConsume = Match.getMatches(units, Matches.UnitConsumesUnitsOnCreation);
        for (Unit unit : unitsWhichConsume) {
            if (Matches.UnitWhichConsumesUnitsHasRequiredUnits(unitsAtStartOfTurnInTO, to).invert().match(unit)) {
                weCanConsume = false;
            }
            if (!weCanConsume) break;
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            IntegerMap<UnitType> requiredUnitsMap = ua.getConsumesUnits();
            Set<UnitType> requiredUnits = requiredUnitsMap.keySet();
            for (UnitType ut : requiredUnits) {
                int requiredNumber = requiredUnitsMap.getInt(ut);
                CompositeMatchAnd unitIsOwnedByAndOfTypeAndNotDamaged = new CompositeMatchAnd(Matches.unitIsOwnedBy(unit.getOwner()), Matches.unitIsOfType(ut), Matches.UnitHasNotTakenAnyBombingUnitDamage, Matches.UnitHasNotTakenAnyDamage, Matches.UnitIsNotDisabled);
                List<Unit> unitsBeingRemoved = Match.getNMatches(unitsAtStartOfTurnInTO, requiredNumber, unitIsOwnedByAndOfTypeAndNotDamaged);
                unitsAtStartOfTurnInTO.removeAll(unitsBeingRemoved);
                if (!actuallyDoIt || change == null) continue;
                Change remove = ChangeFactory.removeUnits(to, unitsBeingRemoved);
                change.add(remove);
                removedUnits.addAll(unitsBeingRemoved);
            }
        }
        if (weCanConsume && actuallyDoIt && change != null && !change.isEmpty()) {
            this.m_bridge.getHistoryWriter().startEvent("Units in " + to.getName() + " being upgraded or consumed: " + MyFormatter.unitsToTextNoOwner(removedUnits), removedUnits);
        }
        return weCanConsume;
    }

    protected int getMaxUnitsToBePlaced(Collection<Unit> units, Territory to, PlayerID player, boolean countSwitchedProductionToNeighbors) {
        IntegerMap<Territory> map = this.getMaxUnitsToBePlacedMap(units, to, player, countSwitchedProductionToNeighbors);
        int production = 0;
        for (Map.Entry<Territory, Integer> entry : map.entrySet()) {
            int prodT = entry.getValue();
            if (prodT == -1) {
                return -1;
            }
            production += prodT;
        }
        return production;
    }

    protected IntegerMap<Territory> getMaxUnitsToBePlacedMap(Collection<Unit> units, Territory to, PlayerID player, boolean countSwitchedProductionToNeighbors) {
        IntegerMap<Territory> rVal = new IntegerMap<Territory>();
        List<Territory> producers = this.getAllProducers(to, player, units);
        if (producers.isEmpty()) {
            return rVal;
        }
        Collections.sort(producers, this.getBestProducerComparator(to, units, player));
        ArrayList<Territory> notUsableAsOtherProducers = new ArrayList<Territory>();
        notUsableAsOtherProducers.addAll(producers);
        HashMap<Territory, Integer> currentAvailablePlacementForOtherProducers = new HashMap<Territory, Integer>();
        for (Territory producerTerritory : producers) {
            ArrayList<Unit> unitsCanBePlacedByThisProducer = this.isUnitPlacementRestrictions() ? Match.getMatches(units, this.unitWhichRequiresUnitsHasRequiredUnits(producerTerritory, true)) : new ArrayList<Unit>(units);
            int prodT = this.getMaxUnitsToBePlacedFrom(producerTerritory, unitsCanBePlacedByThisProducer, to, player, countSwitchedProductionToNeighbors, notUsableAsOtherProducers, currentAvailablePlacementForOtherProducers);
            rVal.put(producerTerritory, prodT);
        }
        return rVal;
    }

    protected int getMaxUnitsToBePlacedFrom(Territory producer, Collection<Unit> units, Territory to, PlayerID player) {
        return this.getMaxUnitsToBePlacedFrom(producer, units, to, player, false, null, null);
    }

    protected int getMaxUnitsToBePlacedFrom(Territory producer, Collection<Unit> units, Territory to, PlayerID player, boolean countSwitchedProductionToNeighbors, Collection<Territory> notUsableAsOtherProducers, Map<Territory, Integer> currentAvailablePlacementForOtherProducers) {
        ArrayList<Unit> unitsCanBePlacedByThisProducer;
        List<Unit> list = unitsCanBePlacedByThisProducer = this.isUnitPlacementRestrictions() ? Match.getMatches(units, this.unitWhichRequiresUnitsHasRequiredUnits(producer, true)) : new ArrayList<Unit>(units);
        if (unitsCanBePlacedByThisProducer.size() <= 0) {
            return 0;
        }
        TerritoryAttachment ta = TerritoryAttachment.get(producer);
        CompositeMatchAnd<Unit> factoryMatch = new CompositeMatchAnd<Unit>(Matches.UnitIsOwnedAndIsFactoryOrCanProduceUnits(player), Matches.unitIsBeingTransported().invert());
        if (producer.isWater()) {
            factoryMatch.add(Matches.UnitIsLand.invert());
        } else {
            factoryMatch.add(Matches.UnitIsSea.invert());
        }
        List<Unit> factoryUnits = producer.getUnits().getMatches(factoryMatch);
        boolean unitPlacementPerTerritoryRestricted = this.isUnitPlacementPerTerritoryRestricted();
        boolean originalFactory = ta == null ? false : ta.getOriginalFactory();
        boolean playerIsOriginalOwner = factoryUnits.size() > 0 ? this.m_player.equals(this.getOriginalFactoryOwner(producer)) : false;
        RulesAttachment ra = (RulesAttachment)player.getAttachment("rulesAttatchment");
        Collection<Unit> alreadProducedUnits = this.getAlreadyProduced(producer);
        int unitCountAlreadyProduced = alreadProducedUnits.size();
        if (originalFactory && playerIsOriginalOwner) {
            if (ra != null && ra.getMaxPlacePerTerritory() != -1) {
                return Math.max(0, ra.getMaxPlacePerTerritory() - unitCountAlreadyProduced);
            }
            return -1;
        }
        if (unitPlacementPerTerritoryRestricted && ra != null && ra.getPlacementPerTerritory() > 0) {
            int allowedPlacement = ra.getPlacementPerTerritory();
            int ownedUnitsInTerritory = Match.countMatches(to.getUnits().getUnits(), Matches.unitIsOwnedBy(player));
            if (ownedUnitsInTerritory >= allowedPlacement) {
                return 0;
            }
            if (ra.getMaxPlacePerTerritory() == -1) {
                return -1;
            }
            return Math.max(0, ra.getMaxPlacePerTerritory() - unitCountAlreadyProduced);
        }
        int production = 0;
        int maxConstructions = this.howManyOfEachConstructionCanPlace(to, producer, unitsCanBePlacedByThisProducer, player).totalValues();
        boolean wasFactoryThereAtStart = this.wasOwnedUnitThatCanProduceUnitsOrIsFactoryInTerritoryAtStartOfStep(producer, player);
        if (!wasFactoryThereAtStart) {
            if (ra != null && ra.getMaxPlacePerTerritory() > 0) {
                return Math.max(0, Math.min(maxConstructions, ra.getMaxPlacePerTerritory() - unitCountAlreadyProduced));
            }
            return Math.max(0, maxConstructions);
        }
        production = TripleAUnit.getProductionPotentialOfTerritory(this.unitsAtStartOfStepInTerritory(producer), producer, player, this.getData(), true, true);
        if (maxConstructions > 0) {
            production += maxConstructions;
        }
        if (production < 0) {
            return 0;
        }
        production += Match.countMatches(alreadProducedUnits, Matches.UnitIsConstruction);
        int unitCountHaveToAndHaveBeenBeProducedHere = unitCountAlreadyProduced;
        if (countSwitchedProductionToNeighbors && unitCountAlreadyProduced > 0) {
            if (notUsableAsOtherProducers == null) {
                throw new IllegalStateException("notUsableAsOtherProducers can not be null if countSwitchedProductionToNeighbors is true");
            }
            if (currentAvailablePlacementForOtherProducers == null) {
                throw new IllegalStateException("currentAvailablePlacementForOtherProducers can not be null if countSwitchedProductionToNeighbors is true");
            }
            int productionCanNotBeMoved = 0;
            int productionThatCanBeTakenOver = 0;
            for (UndoablePlacement placementMove : this.m_placements) {
                if (!placementMove.getProducerTerritory().equals(producer)) continue;
                Territory placeTerritory = placementMove.getPlaceTerritory();
                Collection<Unit> unitsPlacedByCurrentPlacementMove = placementMove.getUnits();
                if (!placeTerritory.isWater() || this.isUnitPlacementRestrictions() && Match.someMatch(unitsPlacedByCurrentPlacementMove, Matches.UnitRequiresUnitsOnCreation)) {
                    productionCanNotBeMoved += unitsPlacedByCurrentPlacementMove.size();
                } else {
                    int maxProductionThatCanBeTakenOverFromThisPlacement = unitsPlacedByCurrentPlacementMove.size();
                    int productionThatCanBeTakenOverFromThisPlacement = 0;
                    List<Territory> newPotentialOtherProducers = this.getAllProducers(placeTerritory, player, unitsCanBePlacedByThisProducer);
                    newPotentialOtherProducers.removeAll(notUsableAsOtherProducers);
                    Collections.sort(newPotentialOtherProducers, this.getBestProducerComparator(placeTerritory, unitsCanBePlacedByThisProducer, player));
                    for (Territory potentialOtherProducer : newPotentialOtherProducers) {
                        Integer potential = currentAvailablePlacementForOtherProducers.get(potentialOtherProducer);
                        if (potential == null) {
                            potential = this.getMaxUnitsToBePlacedFrom(potentialOtherProducer, this.unitsPlacedInTerritorySoFar(placeTerritory), placeTerritory, player);
                        }
                        if (potential == -1) {
                            currentAvailablePlacementForOtherProducers.put(potentialOtherProducer, potential);
                            productionThatCanBeTakenOverFromThisPlacement = maxProductionThatCanBeTakenOverFromThisPlacement;
                            break;
                        }
                        int needed = maxProductionThatCanBeTakenOverFromThisPlacement - productionThatCanBeTakenOverFromThisPlacement;
                        int surplus = potential - needed;
                        if (surplus > 0) {
                            currentAvailablePlacementForOtherProducers.put(potentialOtherProducer, surplus);
                            productionThatCanBeTakenOverFromThisPlacement += needed;
                        } else {
                            currentAvailablePlacementForOtherProducers.put(potentialOtherProducer, 0);
                            productionThatCanBeTakenOverFromThisPlacement += potential.intValue();
                            notUsableAsOtherProducers.add(potentialOtherProducer);
                        }
                        if (surplus < 0) continue;
                        break;
                    }
                    if (productionThatCanBeTakenOverFromThisPlacement > maxProductionThatCanBeTakenOverFromThisPlacement) {
                        throw new IllegalStateException("productionThatCanBeTakenOverFromThisPlacement should never be larger than maxProductionThatCanBeTakenOverFromThisPlacement");
                    }
                    productionThatCanBeTakenOver += productionThatCanBeTakenOverFromThisPlacement;
                }
                if (productionThatCanBeTakenOver < unitCountAlreadyProduced - productionCanNotBeMoved) continue;
                break;
            }
            unitCountHaveToAndHaveBeenBeProducedHere = Math.max(0, unitCountAlreadyProduced - productionThatCanBeTakenOver);
        }
        if (ra != null && ra.getMaxPlacePerTerritory() > 0) {
            return Math.max(0, Math.min(production - unitCountHaveToAndHaveBeenBeProducedHere, ra.getMaxPlacePerTerritory() - unitCountHaveToAndHaveBeenBeProducedHere));
        }
        return Math.max(0, production - unitCountHaveToAndHaveBeenBeProducedHere);
    }

    protected int getProduction(Territory territory) {
        TerritoryAttachment ta = TerritoryAttachment.get(territory);
        if (ta != null) {
            return ta.getProduction();
        }
        return 0;
    }

    public IntegerMap<String> howManyOfEachConstructionCanPlace(Territory to, Territory producer, Collection<Unit> units, PlayerID player) {
        if (!to.equals(producer) || units == null || units.isEmpty() || !Match.someMatch(units, Matches.UnitIsConstruction)) {
            return new IntegerMap<String>();
        }
        Collection<Unit> unitsAtStartOfTurnInTO = this.unitsAtStartOfStepInTerritory(to);
        Collection<Unit> unitsInTO = to.getUnits().getUnits();
        Collection<Unit> unitsPlacedAlready = this.getAlreadyProduced(to);
        IntegerMap<String> unitMapHeld = new IntegerMap<String>();
        IntegerMap<String> unitMapMaxType = new IntegerMap<String>();
        IntegerMap<String> unitMapTypePerTurn = new IntegerMap<String>();
        int maxFactory = Properties.getFactoriesPerCountry(this.getData());
        Iterator<Unit> unitHeldIter = Match.getMatches(units, Matches.UnitIsConstruction).iterator();
        TerritoryAttachment terrAttachment = TerritoryAttachment.get(to);
        int toProduction = 0;
        if (terrAttachment != null) {
            toProduction = terrAttachment.getProduction();
        }
        while (unitHeldIter.hasNext()) {
            String[] terrs;
            Collection<Territory> listedTerrs;
            Unit currentUnit = unitHeldIter.next();
            UnitAttachment ua = UnitAttachment.get(currentUnit.getUnitType());
            if (this.isUnitPlacementRestrictions() && ((listedTerrs = this.getListedTerritories(terrs = ua.getUnitPlacementRestrictions())).contains(to) || ua.getCanOnlyBePlacedInTerritoryValuedAtX() != -1 && ua.getCanOnlyBePlacedInTerritoryValuedAtX() > toProduction || this.unitWhichRequiresUnitsHasRequiredUnits(to, false).invert().match(currentUnit)) || Matches.UnitConsumesUnitsOnCreation.match(currentUnit) && Matches.UnitWhichConsumesUnitsHasRequiredUnits(unitsAtStartOfTurnInTO, to).invert().match(currentUnit)) continue;
            unitMapHeld.add(ua.getConstructionType(), 1);
            unitMapTypePerTurn.put(ua.getConstructionType(), ua.getConstructionsPerTerrPerTypePerTurn());
            if (ua.getConstructionType().equals("factory")) {
                unitMapMaxType.put(ua.getConstructionType(), maxFactory);
                continue;
            }
            unitMapMaxType.put(ua.getConstructionType(), ua.getMaxConstructionsPerTypePerTerr());
        }
        boolean moreWithoutFactory = Properties.getMoreConstructionsWithoutFactory(this.getData());
        boolean moreWithFactory = Properties.getMoreConstructionsWithFactory(this.getData());
        boolean unlimitedConstructions = Properties.getUnlimitedConstructions(this.getData());
        boolean wasFactoryThereAtStart = this.wasOwnedUnitThatCanProduceUnitsOrIsFactoryInTerritoryAtStartOfStep(to, player);
        IntegerMap<String> unitMapTO = new IntegerMap<String>();
        if (Match.someMatch(unitsInTO, Matches.UnitIsConstruction)) {
            for (Unit currentUnit : Match.getMatches(unitsInTO, Matches.UnitIsConstruction)) {
                UnitAttachment ua = UnitAttachment.get(currentUnit.getUnitType());
                unitMapTO.add(ua.getConstructionType(), 1);
            }
            for (String constructionType : unitMapHeld.keySet()) {
                int unitMax = unitMapMaxType.getInt(constructionType);
                if (wasFactoryThereAtStart && !constructionType.equals("factory") && !constructionType.endsWith("structure")) {
                    unitMax = Math.max(Math.max(unitMax, moreWithFactory ? toProduction : 0), unlimitedConstructions ? 10000 : 0);
                }
                if (!(wasFactoryThereAtStart || constructionType.equals("factory") || constructionType.endsWith("structure"))) {
                    unitMax = Math.max(Math.max(unitMax, moreWithoutFactory ? toProduction : 0), unlimitedConstructions ? 10000 : 0);
                }
                unitMapHeld.put(constructionType, Math.max(0, Math.min(unitMax - unitMapTO.getInt(constructionType), unitMapHeld.getInt(constructionType))));
            }
        }
        for (Unit currentUnit : Match.getMatches(unitsPlacedAlready, Matches.UnitIsConstruction)) {
            UnitAttachment ua = UnitAttachment.get(currentUnit.getUnitType());
            unitMapTypePerTurn.add(ua.getConstructionType(), -1);
        }
        IntegerMap<String> unitsAllowed = new IntegerMap<String>();
        for (String constructionType : unitMapHeld.keySet()) {
            int unitAllowed = Math.max(0, Math.min(unitMapTypePerTurn.getInt(constructionType), unitMapHeld.getInt(constructionType)));
            if (unitAllowed <= 0) continue;
            unitsAllowed.put(constructionType, unitAllowed);
        }
        return unitsAllowed;
    }

    public int howManyOfConstructionUnit(Unit unit, IntegerMap<String> constructionsMap) {
        UnitAttachment ua = UnitAttachment.get(unit.getUnitType());
        if (!ua.getIsConstruction() || ua.getConstructionsPerTerrPerTypePerTurn() < 1 || ua.getMaxConstructionsPerTypePerTerr() < 1) {
            return 0;
        }
        return Math.max(0, constructionsMap.getInt(ua.getConstructionType()));
    }

    public Match<Unit> unitWhichRequiresUnitsHasRequiredUnits(final Territory to, final boolean doNotCountNeighbors) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit unitWhichRequiresUnits) {
                if (!Matches.UnitRequiresUnitsOnCreation.match(unitWhichRequiresUnits)) {
                    return true;
                }
                Collection<Unit> unitsAtStartOfTurnInProducer = AbstractPlaceDelegate.this.unitsAtStartOfStepInTerritory(to);
                if (Matches.UnitWhichRequiresUnitsHasRequiredUnitsInList(unitsAtStartOfTurnInProducer).match(unitWhichRequiresUnits)) {
                    return true;
                }
                if (!doNotCountNeighbors && Matches.UnitIsSea.match(unitWhichRequiresUnits)) {
                    for (Territory current : AbstractPlaceDelegate.this.getAllProducers(to, AbstractPlaceDelegate.this.m_player, Collections.singletonList(unitWhichRequiresUnits), true)) {
                        Collection<Unit> unitsAtStartOfTurnInCurrent = AbstractPlaceDelegate.this.unitsAtStartOfStepInTerritory(current);
                        if (!Matches.UnitWhichRequiresUnitsHasRequiredUnitsInList(unitsAtStartOfTurnInCurrent).match(unitWhichRequiresUnits)) continue;
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public boolean getCanAllUnitsWithRequiresUnitsBePlacedCorrectly(Collection<Unit> units, Territory to) {
        if (!this.isUnitPlacementRestrictions() || !Match.someMatch(units, Matches.UnitRequiresUnitsOnCreation)) {
            return true;
        }
        IntegerMap<Territory> producersMap = this.getMaxUnitsToBePlacedMap(units, to, this.m_player, true);
        List<Territory> producers = this.getAllProducers(to, this.m_player, units);
        if (producers.isEmpty()) {
            return false;
        }
        Collections.sort(producers, this.getBestProducerComparator(to, units, this.m_player));
        ArrayList<Unit> unitsLeftToPlace = new ArrayList<Unit>(units);
        for (Territory t : producers) {
            if (unitsLeftToPlace.isEmpty()) {
                return true;
            }
            int productionHere = producersMap.getInt(t);
            List<Unit> canBePlacedHere = Match.getMatches(unitsLeftToPlace, this.unitWhichRequiresUnitsHasRequiredUnits(t, true));
            if (productionHere == -1 || productionHere >= canBePlacedHere.size()) {
                unitsLeftToPlace.removeAll(canBePlacedHere);
                continue;
            }
            Collections.sort(canBePlacedHere, this.getHardestToPlaceWithRequiresUnitsRestrictions(true));
            List<Unit> placedHere = Match.getNMatches(canBePlacedHere, productionHere, Match.ALWAYS_MATCH);
            unitsLeftToPlace.removeAll(placedHere);
        }
        return unitsLeftToPlace.isEmpty();
    }

    protected Comparator<Territory> getBestProducerComparator(final Territory to, final Collection<Unit> units, final PlayerID player) {
        return new Comparator<Territory>(){

            @Override
            public int compare(Territory t1, Territory t2) {
                int left2;
                if (t1 == t2 || t1.equals(t2)) {
                    return 0;
                }
                if (to == t1 || to.equals(t1)) {
                    return -1;
                }
                if (to == t2 || to.equals(t2)) {
                    return 1;
                }
                int left1 = AbstractPlaceDelegate.this.getMaxUnitsToBePlacedFrom(t1, units, to, player);
                if (left1 == (left2 = AbstractPlaceDelegate.this.getMaxUnitsToBePlacedFrom(t2, units, to, player))) {
                    return 0;
                }
                if (left1 == -1) {
                    return -1;
                }
                if (left2 == -1) {
                    return 1;
                }
                if (left1 > left2) {
                    return -1;
                }
                return 1;
            }
        };
    }

    protected Comparator<Unit> getUnitConstructionComparator() {
        return new Comparator<Unit>(){

            @Override
            public int compare(Unit u1, Unit u2) {
                boolean construction2;
                boolean construction1 = Matches.UnitIsConstruction.match(u1);
                if (construction1 == (construction2 = Matches.UnitIsConstruction.match(u2))) {
                    return 0;
                }
                if (construction1) {
                    return -1;
                }
                return 1;
            }
        };
    }

    protected Comparator<Unit> getHardestToPlaceWithRequiresUnitsRestrictions(final boolean sortConstructionsToFront) {
        return new Comparator<Unit>(){

            @Override
            public int compare(Unit u1, Unit u2) {
                int rus2;
                int rus1;
                int constructionSort;
                if (u1 == u2 || u1.equals(u2)) {
                    return 0;
                }
                UnitAttachment ua1 = UnitAttachment.get(u1.getType());
                UnitAttachment ua2 = UnitAttachment.get(u2.getType());
                if (ua1 == null && ua2 == null) {
                    return 0;
                }
                if (ua1 != null && ua2 == null) {
                    return -1;
                }
                if (ua1 == null && ua2 != null) {
                    return 1;
                }
                if (sortConstructionsToFront && (constructionSort = AbstractPlaceDelegate.this.getUnitConstructionComparator().compare(u1, u2)) != 0) {
                    return constructionSort;
                }
                ArrayList<String[]> ru1 = ua1.getRequiresUnits();
                ArrayList<String[]> ru2 = ua2.getRequiresUnits();
                int n = ru1 == null ? Integer.MAX_VALUE : (rus1 = ru1.isEmpty() ? Integer.MAX_VALUE : ru1.size());
                int n2 = ru2 == null ? Integer.MAX_VALUE : (rus2 = ru2.isEmpty() ? Integer.MAX_VALUE : ru2.size());
                if (rus1 == rus2) {
                    return 0;
                }
                if (rus1 < rus2) {
                    return -1;
                }
                return 1;
            }
        };
    }

    public Collection<Unit> unitsAtStartOfStepInTerritory(Territory to) {
        if (to == null) {
            return new ArrayList<Unit>();
        }
        Collection<Unit> unitsInTO = to.getUnits().getUnits();
        Collection<Unit> unitsPlacedAlready = this.getAlreadyProduced(to);
        if (Matches.TerritoryIsWater.match(to)) {
            for (Territory current : this.getAllProducers(to, this.m_player, null, true)) {
                unitsPlacedAlready.addAll(this.getAlreadyProduced(current));
            }
        }
        ArrayList<Unit> unitsAtStartOfTurnInTO = new ArrayList<Unit>(unitsInTO);
        unitsAtStartOfTurnInTO.removeAll(unitsPlacedAlready);
        return unitsAtStartOfTurnInTO;
    }

    public Collection<Unit> unitsPlacedInTerritorySoFar(Territory to) {
        if (to == null) {
            return new ArrayList<Unit>();
        }
        Collection<Unit> unitsInTO = to.getUnits().getUnits();
        Collection<Unit> unitsAtStartOfStep = this.unitsAtStartOfStepInTerritory(to);
        unitsInTO.removeAll(unitsAtStartOfStep);
        return unitsInTO;
    }

    public boolean wasOwnedUnitThatCanProduceUnitsOrIsFactoryInTerritoryAtStartOfStep(Territory to, PlayerID player) {
        Collection<Unit> unitsAtStartOfTurnInTO = this.unitsAtStartOfStepInTerritory(to);
        CompositeMatchAnd<Unit> factoryMatch = new CompositeMatchAnd<Unit>(Matches.UnitIsOwnedAndIsFactoryOrCanProduceUnits(player), Matches.unitIsBeingTransported().invert());
        if (to.isWater()) {
            factoryMatch.add(Matches.UnitIsLand.invert());
        } else {
            factoryMatch.add(Matches.UnitIsSea.invert());
        }
        return Match.countMatches(unitsAtStartOfTurnInTO, factoryMatch) > 0;
    }

    protected PlayerID getOriginalFactoryOwner(Territory territory) {
        List<Unit> factoryUnits = territory.getUnits().getMatches(Matches.UnitCanProduceUnits);
        if (factoryUnits.size() == 0) {
            throw new IllegalStateException("No factory in territory:" + territory);
        }
        for (Unit factory2 : factoryUnits) {
            if (!this.m_player.equals(OriginalOwnerTracker.getOriginalOwner(factory2))) continue;
            return OriginalOwnerTracker.getOriginalOwner(factory2);
        }
        Unit factory = (Unit)factoryUnits.iterator().next();
        return OriginalOwnerTracker.getOriginalOwner(factory);
    }

    protected String validateNewAirCanLandOnCarriers(Territory to, Collection<Unit> units) {
        int cost = AirMovementValidator.carrierCost(units);
        int capacity = AirMovementValidator.carrierCapacity(units, to);
        if (cost > (capacity += AirMovementValidator.carrierCapacity(to.getUnits().getUnits(), to))) {
            return "Not enough new carriers to land all the fighters";
        }
        return null;
    }

    @Override
    public Collection<Territory> getTerritoriesWhereAirCantLand() {
        return new AirThatCantLandUtil(this.m_bridge).getTerritoriesWhereAirCantLand(this.m_player);
    }

    protected boolean canProduceFightersOnCarriers() {
        return Properties.getProduceFightersOnCarriers(this.getData());
    }

    protected boolean canProduceNewFightersOnOldCarriers() {
        return Properties.getProduceNewFightersOnOldCarriers(this.getData());
    }

    protected boolean canMoveExistingFightersToNewCarriers() {
        return Properties.getMoveExistingFightersToNewCarriers(this.getData());
    }

    protected boolean isWW2V2() {
        return Properties.getWW2V2(this.getData());
    }

    protected boolean isUnitPlacementInEnemySeas() {
        return Properties.getUnitPlacementInEnemySeas(this.getData());
    }

    protected boolean wasConquered(Territory t) {
        BattleTracker tracker = DelegateFinder.battleDelegate(this.getData()).getBattleTracker();
        return tracker.wasConquered(t);
    }

    protected boolean isPlaceInAnyTerritory() {
        return Properties.getPlaceInAnyTerritory(this.getData());
    }

    protected boolean isUnitPlacementPerTerritoryRestricted() {
        return Properties.getUnitPlacementPerTerritoryRestricted(this.getData());
    }

    protected boolean isUnitPlacementRestrictions() {
        return Properties.getUnitPlacementRestrictions(this.getData());
    }

    protected List<Territory> getAllProducers(Territory to, PlayerID player, Collection<Unit> unitsToPlace) {
        return this.getAllProducers(to, player, unitsToPlace, false);
    }

    protected boolean isPlayerAllowedToPlacementAnyTerritoryOwnedLand(PlayerID player) {
        RulesAttachment ra;
        return this.isPlaceInAnyTerritory() && (ra = (RulesAttachment)player.getAttachment("rulesAttatchment")) != null && ra.getPlacementAnyTerritory();
    }

    protected boolean isPlayerAllowedToPlacementAnySeaZoneByOwnedLand(PlayerID player) {
        RulesAttachment ra;
        return this.isPlaceInAnyTerritory() && (ra = (RulesAttachment)player.getAttachment("rulesAttatchment")) != null && ra.getPlacementAnySeaZone();
    }

    protected boolean isPlacementAllowedInCapturedTerritory(PlayerID player) {
        RulesAttachment ra = (RulesAttachment)player.getAttachment("rulesAttatchment");
        return ra != null && ra.getPlacementCapturedTerritory();
    }

    protected boolean isPlacementInCapitalRestricted(PlayerID player) {
        RulesAttachment ra = (RulesAttachment)player.getAttachment("rulesAttatchment");
        return ra != null && ra.getPlacementInCapitalRestricted();
    }

    protected Collection<Territory> getListedTerritories(String[] list) {
        ArrayList<Territory> rVal = new ArrayList<Territory>();
        if (list == null) {
            return rVal;
        }
        for (String name : list) {
            Territory territory = this.getData().getMap().getTerritory(name);
            if (territory == null) {
                throw new IllegalStateException("Rules & Conditions: No territory called:" + name);
            }
            rVal.add(territory);
        }
        return rVal;
    }

    @Override
    public Class<? extends IRemote> getRemoteType() {
        return IAbstractPlaceDelegate.class;
    }
}

