/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.GameOverException;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.RouteScripted;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.engine.message.ConnectionLostException;
import games.strategy.net.GUID;
import games.strategy.triplea.Properties;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.AbstractBattle;
import games.strategy.triplea.delegate.BattleCalculator;
import games.strategy.triplea.delegate.BattleTracker;
import games.strategy.triplea.delegate.DiceRoll;
import games.strategy.triplea.delegate.ExecutionStack;
import games.strategy.triplea.delegate.IBattle;
import games.strategy.triplea.delegate.IExecutable;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.dataObjects.BattleRecord;
import games.strategy.triplea.delegate.dataObjects.CasualtyDetails;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.triplea.oddsCalculator.ta.BattleResults;
import games.strategy.triplea.ui.display.ITripleaDisplay;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class AirBattle
extends AbstractBattle {
    private static final long serialVersionUID = 4686241714027216395L;
    protected static final String AIR_BATTLE = "Air Battle";
    protected static final String INTERCEPTORS_LAUNCH = "Defender Launches Interceptors";
    protected static final String ATTACKERS_FIRE = "Attackers Fire";
    protected static final String DEFENDERS_FIRE = "Defenders Fire";
    protected static final String ATTACKERS_WITHDRAW = "Attackers Withdraw?";
    protected static final String DEFENDERS_WITHDRAW = "Defenders Withdraw?";
    protected final ExecutionStack m_stack = new ExecutionStack();
    protected List<String> m_steps;
    protected final Collection<Unit> m_defendingWaitingToDie = new ArrayList<Unit>();
    protected final Collection<Unit> m_attackingWaitingToDie = new ArrayList<Unit>();
    protected boolean m_intercept = false;
    protected final int m_maxRounds;

    public AirBattle(Territory battleSite, boolean bombingRaid, GameData data, PlayerID attacker, BattleTracker battleTracker) {
        super(battleSite, attacker, battleTracker, bombingRaid, bombingRaid ? IBattle.BattleType.AIR_RAID : IBattle.BattleType.AIR_BATTLE, data);
        this.m_isAmphibious = false;
        this.m_maxRounds = Properties.getAirBattleRounds(data);
        this.updateDefendingUnits();
    }

    protected void updateDefendingUnits() {
        this.m_defendingUnits = this.m_isBombingRun ? this.m_battleSite.getUnits().getMatches(AirBattle.defendingBombingRaidInterceptors(this.m_attacker, this.m_data)) : this.m_battleSite.getUnits().getMatches(AirBattle.defendingGroundSeaBattleInterceptors(this.m_attacker, this.m_data));
    }

    @Override
    public Change addAttackChange(Route route, Collection<Unit> units, HashMap<Unit, HashSet<Unit>> targets) {
        this.m_attackingUnits.addAll(units);
        return ChangeFactory.EMPTY_CHANGE;
    }

    @Override
    public void removeAttack(Route route, Collection<Unit> units) {
        this.m_attackingUnits.removeAll(units);
    }

    @Override
    public void fight(IDelegateBridge bridge) {
        this.removeUnitsThatNoLongerExist();
        if (this.m_stack.isExecuting()) {
            this.showBattle(bridge);
            this.m_stack.execute(bridge);
            return;
        }
        this.updateDefendingUnits();
        bridge.getHistoryWriter().startEvent("Air Battle in " + this.m_battleSite, this.m_battleSite);
        BattleCalculator.sortPreBattle(this.m_attackingUnits, this.m_data);
        BattleCalculator.sortPreBattle(this.m_defendingUnits, this.m_data);
        this.m_steps = this.determineStepStrings(true, bridge);
        this.showBattle(bridge);
        this.pushFightLoopOnStack(true, bridge);
        this.m_stack.execute(bridge);
    }

    private void pushFightLoopOnStack(boolean firstRun, IDelegateBridge bridge) {
        if (this.m_isOver) {
            return;
        }
        List<IExecutable> steps = this.getBattleExecutables(firstRun);
        Collections.reverse(steps);
        for (IExecutable step : steps) {
            this.m_stack.push(step);
        }
    }

    public static boolean shouldAirBattleUseAirCombatAttDefValues(boolean isForBombingRun) {
        if (isForBombingRun) {
            return true;
        }
        return true;
    }

    public boolean shouldFightAirBattle() {
        if (this.m_isBombingRun) {
            return Match.someMatch(this.m_attackingUnits, Matches.UnitIsStrategicBomber) && !this.m_defendingUnits.isEmpty();
        }
        return !this.m_attackingUnits.isEmpty() && !this.m_defendingUnits.isEmpty();
    }

    public boolean shouldEndBattleDueToMaxRounds() {
        return this.m_maxRounds > 0 && this.m_maxRounds <= this.m_round;
    }

    protected boolean canAttackerRetreat() {
        return !this.shouldEndBattleDueToMaxRounds() && this.shouldFightAirBattle() && Properties.getAirBattleAttackersCanRetreat(this.m_data);
    }

    protected boolean canDefenderRetreat() {
        return !this.shouldEndBattleDueToMaxRounds() && this.shouldFightAirBattle() && Properties.getAirBattleDefendersCanRetreat(this.m_data);
    }

    List<IExecutable> getBattleExecutables(boolean firstRun) {
        ArrayList<IExecutable> steps = new ArrayList<IExecutable>();
        if (this.shouldFightAirBattle()) {
            if (firstRun) {
                steps.add(new InterceptorsLaunch());
            }
            steps.add(new AttackersFire());
            steps.add(new DefendersFire());
            steps.add(new IExecutable(){
                private static final long serialVersionUID = -5575569705493214941L;

                @Override
                public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                    List<Unit> suicideUnits;
                    if (!AirBattle.this.m_intercept) {
                        return;
                    }
                    IntegerMap<UnitType> defenderCosts = BattleCalculator.getCostsForTUV(AirBattle.this.m_defender, AirBattle.this.m_data);
                    IntegerMap<UnitType> attackerCosts = BattleCalculator.getCostsForTUV(AirBattle.this.m_attacker, AirBattle.this.m_data);
                    AirBattle.this.m_attackingUnits.removeAll(AirBattle.this.m_attackingWaitingToDie);
                    AirBattle.this.remove(AirBattle.this.m_attackingWaitingToDie, bridge, AirBattle.this.m_battleSite);
                    AirBattle.this.m_defendingUnits.removeAll(AirBattle.this.m_defendingWaitingToDie);
                    AirBattle.this.remove(AirBattle.this.m_defendingWaitingToDie, bridge, AirBattle.this.m_battleSite);
                    int tuvLostAttacker = BattleCalculator.getTUV(AirBattle.this.m_attackingWaitingToDie, AirBattle.this.m_attacker, attackerCosts, AirBattle.this.m_data);
                    AirBattle.this.m_attackerLostTUV += tuvLostAttacker;
                    int tuvLostDefender = BattleCalculator.getTUV(AirBattle.this.m_defendingWaitingToDie, AirBattle.this.m_defender, defenderCosts, AirBattle.this.m_data);
                    AirBattle.this.m_defenderLostTUV += tuvLostDefender;
                    AirBattle.this.m_attackingWaitingToDie.clear();
                    AirBattle.this.m_defendingWaitingToDie.clear();
                    CompositeMatchAnd<Unit> attackerSuicide = new CompositeMatchAnd<Unit>(Matches.UnitIsSuicide);
                    if (AirBattle.this.m_isBombingRun) {
                        attackerSuicide.add(Matches.UnitIsNotStrategicBomber);
                    }
                    if (Match.someMatch(AirBattle.this.m_attackingUnits, attackerSuicide)) {
                        suicideUnits = Match.getMatches(AirBattle.this.m_attackingUnits, Matches.UnitIsSuicide);
                        AirBattle.this.m_attackingUnits.removeAll(suicideUnits);
                        AirBattle.this.remove(suicideUnits, bridge, AirBattle.this.m_battleSite);
                        tuvLostAttacker = BattleCalculator.getTUV(suicideUnits, AirBattle.this.m_attacker, attackerCosts, AirBattle.this.m_data);
                        AirBattle.this.m_attackerLostTUV += tuvLostAttacker;
                    }
                    if (Match.someMatch(AirBattle.this.m_defendingUnits, Matches.UnitIsSuicide)) {
                        suicideUnits = Match.getMatches(AirBattle.this.m_defendingUnits, Matches.UnitIsSuicide);
                        AirBattle.this.m_defendingUnits.removeAll(suicideUnits);
                        AirBattle.this.remove(suicideUnits, bridge, AirBattle.this.m_battleSite);
                        tuvLostDefender = BattleCalculator.getTUV(suicideUnits, AirBattle.this.m_defender, defenderCosts, AirBattle.this.m_data);
                        AirBattle.this.m_defenderLostTUV += tuvLostDefender;
                    }
                }
            });
        }
        steps.add(new IExecutable(){
            private static final long serialVersionUID = 3148193405425861565L;

            @Override
            public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                if (AirBattle.this.shouldFightAirBattle() && !AirBattle.this.shouldEndBattleDueToMaxRounds()) {
                    return;
                }
                AirBattle.this.makeBattle(bridge);
            }
        });
        steps.add(new IExecutable(){
            private static final long serialVersionUID = 3148193405425861565L;

            @Override
            public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                if (AirBattle.this.shouldFightAirBattle() && !AirBattle.this.shouldEndBattleDueToMaxRounds()) {
                    return;
                }
                AirBattle.this.end(bridge);
            }
        });
        steps.add(new IExecutable(){
            private static final long serialVersionUID = -5408702756335356985L;

            @Override
            public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                if (!AirBattle.this.m_isOver && AirBattle.this.canAttackerRetreat()) {
                    AirBattle.this.attackerRetreat(bridge);
                }
            }
        });
        steps.add(new IExecutable(){
            private static final long serialVersionUID = -7819137222487595113L;

            @Override
            public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                if (!AirBattle.this.m_isOver && AirBattle.this.canDefenderRetreat()) {
                    AirBattle.this.defenderRetreat(bridge);
                }
            }
        });
        final IExecutable loop = new IExecutable(){
            private static final long serialVersionUID = -5408702756335356985L;

            @Override
            public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                AirBattle.this.pushFightLoopOnStack(false, bridge);
            }
        };
        steps.add(new IExecutable(){
            private static final long serialVersionUID = -4136481765101946944L;

            @Override
            public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                if (!AirBattle.this.m_isOver) {
                    AirBattle.this.m_steps = AirBattle.this.determineStepStrings(false, bridge);
                    ITripleaDisplay display = AbstractBattle.getDisplay(bridge);
                    display.listBattleSteps(AirBattle.this.m_battleID, AirBattle.this.m_steps);
                    ++AirBattle.this.m_round;
                    if (!AirBattle.this.m_stack.isEmpty()) {
                        throw new IllegalStateException("Stack not empty:" + AirBattle.this.m_stack);
                    }
                    AirBattle.this.m_stack.push(loop);
                }
            }
        });
        return steps;
    }

    public List<String> determineStepStrings(boolean showFirstRun, IDelegateBridge bridge) {
        ArrayList<String> steps = new ArrayList<String>();
        if (showFirstRun) {
            steps.add(AIR_BATTLE);
            steps.add(INTERCEPTORS_LAUNCH);
        }
        steps.add(ATTACKERS_FIRE);
        steps.add(DEFENDERS_FIRE);
        if (this.canAttackerRetreat()) {
            steps.add(ATTACKERS_WITHDRAW);
        }
        if (this.canDefenderRetreat()) {
            steps.add(DEFENDERS_WITHDRAW);
        }
        return steps;
    }

    private void recordUnitsWereInAirBattle(Collection<Unit> units, IDelegateBridge bridge) {
        CompositeChange wasInAirBattleChange = new CompositeChange();
        for (Unit u : units) {
            wasInAirBattleChange.add(ChangeFactory.unitPropertyChange(u, true, "wasInAirBattle"));
        }
        if (!wasInAirBattleChange.isEmpty()) {
            bridge.addChange(wasInAirBattleChange);
        }
    }

    private void makeBattle(IDelegateBridge bridge) {
        if (this.m_isBombingRun) {
            this.recordUnitsWereInAirBattle(this.m_attackingUnits, bridge);
            this.recordUnitsWereInAirBattle(this.m_defendingUnits, bridge);
        }
        if (this.m_isBombingRun) {
            List<Unit> bombers = Match.getMatches(this.m_attackingUnits, Matches.UnitIsStrategicBomber);
            if (!bombers.isEmpty()) {
                IBattle dependentAirBattle;
                HashMap<Unit, HashSet<Unit>> targets = null;
                List<Unit> enemyTargetsTotal = this.m_battleSite.getUnits().getMatches(new CompositeMatchAnd<Unit>(Matches.enemyUnit(bridge.getPlayerID(), this.m_data), Matches.UnitIsAtMaxDamageOrNotCanBeDamaged(this.m_battleSite).invert(), Matches.unitIsBeingTransported().invert()));
                for (Unit unit : bombers) {
                    List<Unit> enemyTargets = Match.getMatches(enemyTargetsTotal, Matches.UnitIsLegalBombingTargetBy(unit));
                    if (enemyTargets.isEmpty()) continue;
                    Unit target = null;
                    if (enemyTargets.size() > 1 && Properties.getDamageFromBombingDoneToUnitsInsteadOfTerritories(this.m_data)) {
                        while (target == null) {
                            target = AirBattle.getRemote(bridge).whatShouldBomberBomb(this.m_battleSite, enemyTargets, Collections.singletonList(unit));
                        }
                    } else if (!enemyTargets.isEmpty()) {
                        target = (Unit)enemyTargets.iterator().next();
                    }
                    if (target != null) {
                        targets = new HashMap<Unit, HashSet<Unit>>();
                        targets.put(target, new HashSet<Unit>(Collections.singleton(unit)));
                    }
                    this.m_battleTracker.addBattle(new RouteScripted(this.m_battleSite), Collections.singleton(unit), true, this.m_attacker, bridge, null, null, targets, true);
                }
                IBattle battle = this.m_battleTracker.getPendingBattle(this.m_battleSite, true, null);
                IBattle dependent = this.m_battleTracker.getPendingBattle(this.m_battleSite, false, IBattle.BattleType.NORMAL);
                if (dependent != null) {
                    this.m_battleTracker.addDependency(dependent, battle);
                }
                if ((dependentAirBattle = this.m_battleTracker.getPendingBattle(this.m_battleSite, false, IBattle.BattleType.AIR_BATTLE)) != null) {
                    this.m_battleTracker.addDependency(dependentAirBattle, battle);
                }
            }
        } else if (!this.m_attackingUnits.isEmpty()) {
            // empty if block
        }
    }

    private void end(IDelegateBridge bridge) {
        String text;
        if (!this.m_attackingUnits.isEmpty()) {
            if (this.m_isBombingRun) {
                if (Match.someMatch(this.m_attackingUnits, Matches.UnitIsStrategicBomber)) {
                    this.m_whoWon = IBattle.WhoWon.ATTACKER;
                    this.m_battleResultDescription = this.m_defendingUnits.isEmpty() ? BattleRecord.BattleResultDescription.WON_WITHOUT_CONQUERING : BattleRecord.BattleResultDescription.WON_WITH_ENEMY_LEFT;
                    text = "Air Battle is over, the remaining bombers go on to their targets";
                    bridge.getSoundChannelBroadcaster().playSoundForAll("battle_air_successful", this.m_attacker.getName());
                } else {
                    this.m_whoWon = IBattle.WhoWon.DRAW;
                    this.m_battleResultDescription = BattleRecord.BattleResultDescription.STALEMATE;
                    text = "Air Battle is over, the bombers have all died";
                    bridge.getSoundChannelBroadcaster().playSoundForAll("battle_failure", this.m_attacker.getName());
                }
            } else if (this.m_defendingUnits.isEmpty()) {
                this.m_whoWon = IBattle.WhoWon.ATTACKER;
                this.m_battleResultDescription = BattleRecord.BattleResultDescription.WON_WITHOUT_CONQUERING;
                text = "Air Battle is over, the defenders have all died";
                bridge.getSoundChannelBroadcaster().playSoundForAll("battle_air_successful", this.m_attacker.getName());
            } else {
                this.m_whoWon = IBattle.WhoWon.DRAW;
                this.m_battleResultDescription = BattleRecord.BattleResultDescription.STALEMATE;
                text = "Air Battle is over, neither side is eliminated";
                bridge.getSoundChannelBroadcaster().playSoundForAll("battle_stalemate", this.m_attacker.getName());
            }
        } else {
            this.m_whoWon = IBattle.WhoWon.DEFENDER;
            this.m_battleResultDescription = BattleRecord.BattleResultDescription.LOST;
            text = "Air Battle is over, the attackers have all died";
            bridge.getSoundChannelBroadcaster().playSoundForAll("battle_failure", this.m_attacker.getName());
        }
        bridge.getHistoryWriter().addChildToEvent(text);
        this.m_battleTracker.getBattleRecords(this.m_data).addResultToBattle(this.m_attacker, this.m_battleID, this.m_defender, this.m_attackerLostTUV, this.m_defenderLostTUV, this.m_battleResultDescription, new BattleResults(this, this.m_data), 0);
        AirBattle.getDisplay(bridge).battleEnd(this.m_battleID, "Air Battle over");
        this.m_isOver = true;
        this.m_battleTracker.removeBattle(this);
    }

    public void finishBattleAndRemoveFromTrackerHeadless(IDelegateBridge bridge) {
        this.makeBattle(bridge);
        this.m_whoWon = IBattle.WhoWon.ATTACKER;
        this.m_battleResultDescription = BattleRecord.BattleResultDescription.NO_BATTLE;
        this.m_battleTracker.getBattleRecords(this.m_data).removeBattle(this.m_attacker, this.m_battleID);
        this.m_isOver = true;
        this.m_battleTracker.removeBattle(this);
    }

    private void attackerRetreat(IDelegateBridge bridge) {
        ArrayList<Territory> possible = new ArrayList<Territory>(2);
        possible.add(this.m_battleSite);
        if (!this.m_attackingUnits.isEmpty()) {
            this.queryRetreat(false, bridge, possible);
        }
    }

    private void defenderRetreat(IDelegateBridge bridge) {
        ArrayList<Territory> possible = new ArrayList<Territory>(2);
        possible.add(this.m_battleSite);
        if (!this.m_defendingUnits.isEmpty()) {
            this.queryRetreat(true, bridge, possible);
        }
    }

    private void queryRetreat(boolean defender, IDelegateBridge bridge, Collection<Territory> availableTerritories) {
        ArrayList<Unit> units;
        if (availableTerritories.isEmpty()) {
            return;
        }
        ArrayList<Unit> arrayList = units = defender ? new ArrayList<Unit>(this.m_defendingUnits) : new ArrayList(this.m_attackingUnits);
        if (units.isEmpty()) {
            return;
        }
        PlayerID retreatingPlayer = defender ? this.m_defender : this.m_attacker;
        String text = retreatingPlayer.getName() + " retreat?";
        String step = defender ? DEFENDERS_WITHDRAW : ATTACKERS_WITHDRAW;
        AirBattle.getDisplay(bridge).gotoBattleStep(this.m_battleID, step);
        Territory retreatTo = AirBattle.getRemote(retreatingPlayer, bridge).retreatQuery(this.m_battleID, false, this.m_battleSite, availableTerritories, text);
        if (retreatTo != null && !availableTerritories.contains(retreatTo)) {
            System.err.println("Invalid retreat selection :" + retreatTo + " not in " + MyFormatter.defaultNamedToTextList(availableTerritories));
            Thread.dumpStack();
            return;
        }
        if (retreatTo != null) {
            if (!this.m_headless) {
                bridge.getSoundChannelBroadcaster().playSoundForAll("battle_retreat_air", this.m_attacker.getName());
            }
            this.retreat(units, defender, bridge);
            String messageShort = retreatingPlayer.getName() + " retreats";
            String messageLong = retreatingPlayer.getName() + " retreats all units to " + retreatTo.getName();
            AirBattle.getDisplay(bridge).notifyRetreat(messageShort, messageLong, step, retreatingPlayer);
        }
    }

    private void retreat(Collection<Unit> retreating, boolean defender, IDelegateBridge bridge) {
        if (!defender) {
            Collection<IBattle> dependentBattles = this.m_battleTracker.getBlocked(this);
            this.removeFromDependents(retreating, bridge, dependentBattles, true);
        }
        String transcriptText = MyFormatter.unitsToText(retreating) + (defender ? " grounded" : " retreated");
        List units = defender ? this.m_defendingUnits : this.m_attackingUnits;
        units.removeAll(retreating);
        bridge.getHistoryWriter().addChildToEvent(transcriptText, new ArrayList<Unit>(retreating));
        this.recordUnitsWereInAirBattle(retreating, bridge);
    }

    private void showBattle(IDelegateBridge bridge) {
        String title = "Air Battle in " + this.m_battleSite.getName();
        AirBattle.getDisplay(bridge).showBattle(this.m_battleID, this.m_battleSite, title, this.m_attackingUnits, this.m_defendingUnits, null, null, null, Collections.<Unit, Collection<Unit>>emptyMap(), this.m_attacker, this.m_defender, this.isAmphibious(), this.getBattleType(), Collections.<Unit>emptySet());
        AirBattle.getDisplay(bridge).listBattleSteps(this.m_battleID, this.m_steps);
    }

    private static Match<Unit> unitHasAirDefenseGreaterThanZero() {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                return UnitAttachment.get(u.getType()).getAirDefense(u.getOwner()) > 0;
            }
        };
    }

    private static Match<Unit> unitHasAirAttackGreaterThanZero() {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                return UnitAttachment.get(u.getType()).getAirAttack(u.getOwner()) > 0;
            }
        };
    }

    public static Match<Unit> attackingGroundSeaBattleEscorts(PlayerID attacker, GameData data) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                CompositeMatchAnd<Unit> canIntercept = new CompositeMatchAnd<Unit>(Matches.unitCanAirBattle);
                return ((Match)canIntercept).match(u);
            }
        };
    }

    public static Match<Unit> defendingGroundSeaBattleInterceptors(final PlayerID attacker, final GameData data) {
        final boolean canScrambleIntoAirBattles = Properties.getCanScrambleIntoAirBattles(data);
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                CompositeMatchAnd<Unit> canIntercept = new CompositeMatchAnd<Unit>(Matches.unitCanAirBattle, Matches.unitIsEnemyOf(data, attacker), Matches.UnitWasInAirBattle.invert());
                if (!canScrambleIntoAirBattles) {
                    canIntercept.add(Matches.UnitWasScrambled.invert());
                }
                return ((Match)canIntercept).match(u);
            }
        };
    }

    public static Match<Unit> defendingBombingRaidInterceptors(final PlayerID attacker, final GameData data) {
        final boolean canScrambleIntoAirBattles = Properties.getCanScrambleIntoAirBattles(data);
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                CompositeMatchAnd<Unit> canIntercept = new CompositeMatchAnd<Unit>(Matches.unitCanIntercept, Matches.unitIsEnemyOf(data, attacker), Matches.UnitWasInAirBattle.invert());
                if (!canScrambleIntoAirBattles) {
                    canIntercept.add(Matches.UnitWasScrambled.invert());
                }
                return ((Match)canIntercept).match(u);
            }
        };
    }

    public static boolean territoryCouldPossiblyHaveAirBattleDefenders(Territory territory, PlayerID attacker, GameData data, boolean bombing) {
        boolean canScrambleToAirBattle = Properties.getCanScrambleIntoAirBattles(data);
        Match<Unit> defendingAirMatch = bombing ? AirBattle.defendingBombingRaidInterceptors(attacker, data) : AirBattle.defendingGroundSeaBattleInterceptors(attacker, data);
        int maxScrambleDistance = 0;
        if (canScrambleToAirBattle) {
            Iterator<UnitType> utIter = data.getUnitTypeList().iterator();
            while (utIter.hasNext()) {
                UnitAttachment ua = UnitAttachment.get(utIter.next());
                if (!ua.getCanScramble() || maxScrambleDistance >= ua.getMaxScrambleDistance()) continue;
                maxScrambleDistance = ua.getMaxScrambleDistance();
            }
        } else {
            return territory.getUnits().someMatch(defendingAirMatch);
        }
        return territory.getUnits().someMatch(defendingAirMatch) || Match.someMatch(data.getMap().getNeighbors(territory, maxScrambleDistance), Matches.territoryHasUnitsThatMatch(defendingAirMatch));
    }

    public static int getAirBattleRolls(Collection<Unit> units, boolean defending) {
        int rolls = 0;
        for (Unit u : units) {
            rolls += AirBattle.getAirBattleRolls(u, defending);
        }
        return rolls;
    }

    public static int getAirBattleRolls(Unit unit, boolean defending) {
        if (defending ? !AirBattle.unitHasAirDefenseGreaterThanZero().match(unit) : !AirBattle.unitHasAirAttackGreaterThanZero().match(unit)) {
            return 0;
        }
        return Math.max(0, defending ? UnitAttachment.get(unit.getType()).getDefenseRolls(unit.getOwner()) : UnitAttachment.get(unit.getType()).getAttackRolls(unit.getOwner()));
    }

    private void remove(Collection<Unit> killed, IDelegateBridge bridge, Territory battleSite) {
        if (killed.size() == 0) {
            return;
        }
        Collection<Unit> dependent = this.getDependentUnits(killed);
        killed.addAll(dependent);
        Change killedChange = ChangeFactory.removeUnits(battleSite, killed);
        String transcriptText = MyFormatter.unitsToText(killed) + " lost in " + battleSite.getName();
        bridge.getHistoryWriter().addChildToEvent(transcriptText, new ArrayList<Unit>(killed));
        bridge.addChange(killedChange);
        Collection<IBattle> dependentBattles = this.m_battleTracker.getBlocked(this);
        this.removeFromDependents(killed, bridge, dependentBattles, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCasualties(final GUID battleID, final IDelegateBridge bridge, String stepName, DiceRoll dice, final PlayerID hitPlayer, final PlayerID firingPlayer, CasualtyDetails details) {
        AirBattle.getDisplay(bridge).casualtyNotification(battleID, stepName, dice, hitPlayer, details.getKilled(), details.getDamaged(), Collections.<Unit, Collection<Unit>>emptyMap());
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractBattle.getRemote(firingPlayer, bridge).confirmEnemyCasualties(battleID, "Press space to continue", hitPlayer);
                }
                catch (ConnectionLostException cle) {
                }
                catch (GameOverException e) {
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        Thread t = new Thread(r, "Click to continue waiter");
        t.start();
        AirBattle.getRemote(hitPlayer, bridge).confirmOwnCasualties(battleID, "Press space to continue");
        try {
            bridge.leaveDelegateExecution();
            t.join();
        }
        catch (InterruptedException e) {
        }
        finally {
            bridge.enterDelegateExecution();
        }
    }

    private void removeFromDependents(Collection<Unit> units, IDelegateBridge bridge, Collection<IBattle> dependents, boolean withdrawn) {
        for (IBattle dependent : dependents) {
            dependent.unitsLostInPrecedingBattle(this, units, bridge, withdrawn);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.m_attackingUnits.isEmpty();
    }

    @Override
    public void unitsLostInPrecedingBattle(IBattle battle, Collection<Unit> units, IDelegateBridge bridge, boolean withdrawn) {
    }

    class DefendersFire
    implements IExecutable {
        private static final long serialVersionUID = -7277182945495744003L;
        DiceRoll m_dice;
        CasualtyDetails m_details;

        DefendersFire() {
        }

        @Override
        public void execute(ExecutionStack stack, IDelegateBridge bridge) {
            if (!AirBattle.this.m_intercept) {
                return;
            }
            IExecutable roll = new IExecutable(){
                private static final long serialVersionUID = 5953506121350176595L;

                @Override
                public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                    ArrayList<Unit> allEnemyUnitsAliveOrWaitingToDie = new ArrayList<Unit>();
                    allEnemyUnitsAliveOrWaitingToDie.addAll(AirBattle.this.m_attackingUnits);
                    allEnemyUnitsAliveOrWaitingToDie.addAll(AirBattle.this.m_attackingWaitingToDie);
                    DefendersFire.this.m_dice = AirBattle.shouldAirBattleUseAirCombatAttDefValues(AirBattle.this.m_isBombingRun) ? DiceRoll.airBattle(AirBattle.this.m_defendingUnits, true, AirBattle.this.m_defender, bridge, AirBattle.this, "Defenders Fire, ") : DiceRoll.rollDice(AirBattle.this.m_defendingUnits, true, AirBattle.this.m_defender, bridge, AirBattle.this, "Defenders Fire, ", AirBattle.this.m_territoryEffects, allEnemyUnitsAliveOrWaitingToDie);
                }
            };
            IExecutable calculateCasualties = new IExecutable(){
                private static final long serialVersionUID = 6658309931909306564L;

                @Override
                public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                    DefendersFire.this.m_details = BattleCalculator.selectCasualties(AirBattle.DEFENDERS_FIRE, AirBattle.this.m_attacker, AirBattle.this.m_attackingUnits, AirBattle.this.m_attackingUnits, AirBattle.this.m_defender, AirBattle.this.m_defendingUnits, false, new ArrayList<Unit>(), AirBattle.this.m_battleSite, null, bridge, AirBattle.DEFENDERS_FIRE, DefendersFire.this.m_dice, false, AirBattle.this.m_battleID, false, DefendersFire.this.m_dice.getHits(), true);
                    AirBattle.this.m_attackingWaitingToDie.addAll(DefendersFire.this.m_details.getKilled());
                    AirBattle.this.markDamaged(DefendersFire.this.m_details.getDamaged(), bridge, true);
                }
            };
            IExecutable notifyCasualties = new IExecutable(){
                private static final long serialVersionUID = 4461950841000674515L;

                @Override
                public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                    AirBattle.this.notifyCasualties(AirBattle.this.m_battleID, bridge, AirBattle.DEFENDERS_FIRE, DefendersFire.this.m_dice, AirBattle.this.m_attacker, AirBattle.this.m_defender, DefendersFire.this.m_details);
                }
            };
            stack.push(notifyCasualties);
            stack.push(calculateCasualties);
            stack.push(roll);
        }
    }

    class AttackersFire
    implements IExecutable {
        private static final long serialVersionUID = -5289634214875797408L;
        DiceRoll m_dice;
        CasualtyDetails m_details;

        AttackersFire() {
        }

        @Override
        public void execute(ExecutionStack stack, IDelegateBridge bridge) {
            if (!AirBattle.this.m_intercept) {
                return;
            }
            IExecutable roll = new IExecutable(){
                private static final long serialVersionUID = 6579019987019614374L;

                @Override
                public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                    ArrayList<Unit> allEnemyUnitsAliveOrWaitingToDie = new ArrayList<Unit>();
                    allEnemyUnitsAliveOrWaitingToDie.addAll(AirBattle.this.m_defendingUnits);
                    allEnemyUnitsAliveOrWaitingToDie.addAll(AirBattle.this.m_defendingWaitingToDie);
                    AttackersFire.this.m_dice = AirBattle.shouldAirBattleUseAirCombatAttDefValues(AirBattle.this.m_isBombingRun) ? DiceRoll.airBattle(AirBattle.this.m_attackingUnits, false, AirBattle.this.m_attacker, bridge, AirBattle.this, "Attackers Fire, ") : DiceRoll.rollDice(AirBattle.this.m_attackingUnits, false, AirBattle.this.m_attacker, bridge, AirBattle.this, "Attackers Fire, ", AirBattle.this.m_territoryEffects, allEnemyUnitsAliveOrWaitingToDie);
                }
            };
            IExecutable calculateCasualties = new IExecutable(){
                private static final long serialVersionUID = 4556409970663527142L;

                @Override
                public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                    AttackersFire.this.m_details = BattleCalculator.selectCasualties(AirBattle.ATTACKERS_FIRE, AirBattle.this.m_defender, AirBattle.this.m_defendingUnits, AirBattle.this.m_defendingUnits, AirBattle.this.m_attacker, AirBattle.this.m_attackingUnits, false, new ArrayList<Unit>(), AirBattle.this.m_battleSite, null, bridge, AirBattle.ATTACKERS_FIRE, AttackersFire.this.m_dice, true, AirBattle.this.m_battleID, false, AttackersFire.this.m_dice.getHits(), true);
                    AirBattle.this.m_defendingWaitingToDie.addAll(AttackersFire.this.m_details.getKilled());
                    AirBattle.this.markDamaged(AttackersFire.this.m_details.getDamaged(), bridge, true);
                }
            };
            IExecutable notifyCasualties = new IExecutable(){
                private static final long serialVersionUID = 4224354422817922451L;

                @Override
                public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                    AirBattle.this.notifyCasualties(AirBattle.this.m_battleID, bridge, AirBattle.ATTACKERS_FIRE, AttackersFire.this.m_dice, AirBattle.this.m_defender, AirBattle.this.m_attacker, AttackersFire.this.m_details);
                }
            };
            stack.push(notifyCasualties);
            stack.push(calculateCasualties);
            stack.push(roll);
        }
    }

    class InterceptorsLaunch
    implements IExecutable {
        private static final long serialVersionUID = 4300406315014471768L;

        InterceptorsLaunch() {
        }

        @Override
        public void execute(ExecutionStack stack, IDelegateBridge bridge) {
            this.getInterceptors(bridge);
            if (!AirBattle.this.m_defendingUnits.isEmpty()) {
                AirBattle.this.m_intercept = true;
                bridge.getSoundChannelBroadcaster().playSoundForAll("battle_air", AirBattle.this.m_attacker.getName());
            }
        }

        private void getInterceptors(IDelegateBridge bridge) {
            boolean groundedPlanesRetreated;
            Collection<Object> interceptors;
            if (AirBattle.this.m_isBombingRun) {
                interceptors = AbstractBattle.getRemote(AirBattle.this.m_defender, bridge).selectUnitsQuery(AirBattle.this.m_battleSite, new ArrayList<Unit>(AirBattle.this.m_defendingUnits), "Select Air to Intercept");
                groundedPlanesRetreated = false;
            } else if (Properties.getAirBattleDefendersCanRetreat(AirBattle.this.m_data)) {
                interceptors = AbstractBattle.getRemote(AirBattle.this.m_defender, bridge).selectUnitsQuery(AirBattle.this.m_battleSite, new ArrayList<Unit>(AirBattle.this.m_defendingUnits), "Select Air to Intercept");
                groundedPlanesRetreated = true;
            } else {
                interceptors = new ArrayList(AirBattle.this.m_defendingUnits);
                groundedPlanesRetreated = false;
            }
            if (interceptors != null && !AirBattle.this.m_defendingUnits.containsAll(interceptors)) {
                throw new IllegalStateException("Interceptors choose from outside of available units");
            }
            ArrayList<Unit> beingRemoved = new ArrayList<Unit>(AirBattle.this.m_defendingUnits);
            AirBattle.this.m_defendingUnits.clear();
            if (interceptors != null) {
                beingRemoved.removeAll(interceptors);
                AirBattle.this.m_defendingUnits.addAll(interceptors);
            }
            AbstractBattle.getDisplay(bridge).changedUnitsNotification(AirBattle.this.m_battleID, AirBattle.this.m_defender, beingRemoved, null, null);
            if (groundedPlanesRetreated) {
                AirBattle.this.retreat(beingRemoved, true, bridge);
            }
            if (!AirBattle.this.m_attackingUnits.isEmpty()) {
                bridge.getHistoryWriter().addChildToEvent(AirBattle.this.m_attacker.getName() + " attacks with " + AirBattle.this.m_attackingUnits.size() + " units heading to " + AirBattle.this.m_battleSite.getName(), new ArrayList(AirBattle.this.m_attackingUnits));
            }
            if (!AirBattle.this.m_defendingUnits.isEmpty()) {
                bridge.getHistoryWriter().addChildToEvent(AirBattle.this.m_defender.getName() + " launches " + AirBattle.this.m_defendingUnits.size() + " interceptors out of " + AirBattle.this.m_battleSite.getName(), new ArrayList(AirBattle.this.m_defendingUnits));
            }
        }
    }
}

