/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.common.delegate.BaseEditDelegate;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.NamedAttachable;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionFrontier;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.ResourceCollection;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.TerritoryEffect;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.engine.framework.GameRunner2;
import games.strategy.engine.random.IRandomStats;
import games.strategy.net.GUID;
import games.strategy.triplea.Properties;
import games.strategy.triplea.ai.weakAI.WeakAI;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.attatchments.UnitSupportAttachment;
import games.strategy.triplea.delegate.DiceRoll;
import games.strategy.triplea.delegate.Die;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.TerritoryEffectHelper;
import games.strategy.triplea.delegate.TransportTracker;
import games.strategy.triplea.delegate.UnitBattleComparator;
import games.strategy.triplea.delegate.UnitComparator;
import games.strategy.triplea.delegate.dataObjects.CasualtyDetails;
import games.strategy.triplea.delegate.dataObjects.CasualtyList;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.triplea.player.ITripleaPlayer;
import games.strategy.triplea.util.UnitCategory;
import games.strategy.triplea.util.UnitSeperator;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.IntegerMap;
import games.strategy.util.LinkedIntegerMap;
import games.strategy.util.Match;
import games.strategy.util.Triple;
import games.strategy.util.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class BattleCalculator {
    private static Map<String, List<UnitType>> oolCache = new ConcurrentHashMap<String, List<UnitType>>();

    public static void clearOOLCache() {
        oolCache.clear();
    }

    public static void sortPreBattle(List<Unit> units, GameData data) {
        Comparator<Unit> comparator = new Comparator<Unit>(){

            @Override
            public int compare(Unit u1, Unit u2) {
                if (u1.getUnitType().equals(u2.getUnitType())) {
                    return UnitComparator.getLowestToHighestMovementComparator().compare(u1, u2);
                }
                return u1.getUnitType().getName().compareTo(u2.getUnitType().getName());
            }
        };
        Collections.sort(units, comparator);
    }

    public static int getTotalHitpointsLeft(Collection<Unit> units) {
        if (units == null || units.isEmpty()) {
            return 0;
        }
        int rVal = 0;
        for (Unit u : units) {
            UnitAttachment ua = UnitAttachment.get(u.getType());
            rVal += ua.getHitPoints();
            rVal -= u.getHits();
        }
        return rVal;
    }

    public static int getTotalHitpointsLeft(Unit unit) {
        if (unit == null) {
            return 0;
        }
        UnitAttachment ua = UnitAttachment.get(unit.getType());
        return ua.getHitPoints() - unit.getHits();
    }

    public static int getNormalizedMetaPower(int power, int hitpoints, int diceSides) {
        return 2 * hitpoints + power * 6 / diceSides;
    }

    public static int getAAHits(Collection<Unit> units, IDelegateBridge bridge, int[] dice) {
        int attackingAirCount = Match.countMatches(units, Matches.UnitIsAir);
        int hitCount = 0;
        for (int i = 0; i < attackingAirCount; ++i) {
            if (1 <= dice[i]) continue;
            ++hitCount;
        }
        return hitCount;
    }

    public static CasualtyDetails getAACasualties(boolean defending, Collection<Unit> planes, Collection<Unit> allFriendlyUnits, Collection<Unit> defendingAA, Collection<Unit> allEnemyUnits, DiceRoll dice, IDelegateBridge bridge, PlayerID firingPlayer, PlayerID hitPlayer, GUID battleID, Territory terr, Collection<TerritoryEffect> territoryEffects, boolean amphibious, Collection<Unit> amphibiousLandAttackers) {
        if (planes.isEmpty()) {
            return new CasualtyDetails();
        }
        GameData data = bridge.getData();
        boolean allowMultipleHitsPerUnit = Match.allMatch(defendingAA, Matches.UnitAAShotDamageableInsteadOfKillingInstantly);
        if (BattleCalculator.isChooseAA(data)) {
            String text = "Select " + dice.getHits() + " casualties from aa fire in " + terr.getName();
            return BattleCalculator.selectCasualties(null, hitPlayer, planes, allFriendlyUnits, firingPlayer, allEnemyUnits, amphibious, amphibiousLandAttackers, terr, territoryEffects, bridge, text, dice, defending, battleID, false, dice.getHits(), allowMultipleHitsPerUnit);
        }
        if (Properties.getLow_Luck(data) || Properties.getLL_AA_ONLY(data)) {
            return BattleCalculator.getLowLuckAACasualties(defending, planes, defendingAA, dice, terr, bridge, allowMultipleHitsPerUnit);
        }
        if (BattleCalculator.isRollAAIndividually(data)) {
            return BattleCalculator.IndividuallyFiredAACasualties(defending, planes, defendingAA, dice, terr, bridge, allowMultipleHitsPerUnit);
        }
        if (BattleCalculator.isRandomAACasualties(data)) {
            return BattleCalculator.RandomAACasualties(planes, dice, bridge, allowMultipleHitsPerUnit);
        }
        return BattleCalculator.IndividuallyFiredAACasualties(defending, planes, defendingAA, dice, terr, bridge, allowMultipleHitsPerUnit);
    }

    public static Tuple<List<List<Unit>>, List<Unit>> categorizeLowLuckAirUnits(Collection<Unit> units, Territory location, int diceSides, int groupSize) {
        Set<UnitCategory> categorizedAir = UnitSeperator.categorize(units, null, false, true);
        ArrayList<ArrayList<Unit>> groupsOfSize = new ArrayList<ArrayList<Unit>>();
        ArrayList<Unit> toRoll = new ArrayList<Unit>();
        for (UnitCategory uc : categorizedAir) {
            int remainder = uc.getUnits().size() % groupSize;
            int splitPosition = uc.getUnits().size() - remainder;
            ArrayList<Unit> group = new ArrayList<Unit>(uc.getUnits().subList(0, splitPosition));
            if (!group.isEmpty()) {
                for (int i = 0; i < splitPosition; i += groupSize) {
                    ArrayList<Unit> miniGroup = new ArrayList<Unit>(uc.getUnits().subList(i, i + groupSize));
                    if (miniGroup.isEmpty()) continue;
                    groupsOfSize.add(miniGroup);
                }
            }
            toRoll.addAll(uc.getUnits().subList(splitPosition, uc.getUnits().size()));
        }
        return new Tuple<List<List<Unit>>, List<Unit>>(groupsOfSize, toRoll);
    }

    private static CasualtyDetails getLowLuckAACasualties(boolean defending, Collection<Unit> planes, Collection<Unit> defendingAA, DiceRoll dice, Territory location, IDelegateBridge bridge, boolean allowMultipleHitsPerUnit) {
        boolean tooManyHitsToDoGroups;
        HashSet<Unit> duplicatesCheckSet1 = new HashSet<Unit>(planes);
        if (planes.size() != duplicatesCheckSet1.size()) {
            throw new IllegalStateException("Duplicate Units Detected: Original List:" + planes + "  HashSet:" + duplicatesCheckSet1);
        }
        HashSet<Unit> duplicatesCheckSet2 = new HashSet<Unit>(defendingAA);
        if (defendingAA.size() != duplicatesCheckSet2.size()) {
            throw new IllegalStateException("Duplicate Units Detected: Original List:" + defendingAA + "  HashSet:" + duplicatesCheckSet2);
        }
        int hitsLeft = dice.getHits();
        if (hitsLeft <= 0) {
            return new CasualtyDetails();
        }
        CasualtyDetails finalCasualtyDetails = new CasualtyDetails();
        GameData data = bridge.getData();
        Tuple<Integer, Integer> attackThenDiceSides = DiceRoll.getAAattackAndMaxDiceSides(defendingAA, data, !defending);
        int highestAttack = attackThenDiceSides.getFirst();
        if (highestAttack < 1) {
            return new CasualtyDetails();
        }
        int chosenDiceSize = attackThenDiceSides.getSecond();
        Triple<Integer, Integer, Boolean> triple = DiceRoll.getTotalAAPowerThenHitsAndFillSortedDiceThenIfAllUseSameAttack(null, null, !defending, defendingAA, planes, data, false);
        boolean allSameAttackPower = triple.getThird();
        ArrayList<Unit> planesList = new ArrayList<Unit>();
        for (Unit plane : planes) {
            int hpLeft = allowMultipleHitsPerUnit ? UnitAttachment.get(plane.getType()).getHitPoints() - plane.getHits() : Math.min(1, UnitAttachment.get(plane.getType()).getHitPoints() - plane.getHits());
            for (int hp = 0; hp < hpLeft; ++hp) {
                planesList.add(plane);
            }
        }
        int groupSize = allSameAttackPower ? chosenDiceSize / highestAttack : chosenDiceSize;
        int numberOfGroupsByDiceSides = (int)Math.ceil((double)planesList.size() / (double)groupSize);
        boolean bl = tooManyHitsToDoGroups = hitsLeft > numberOfGroupsByDiceSides;
        if (!allSameAttackPower || tooManyHitsToDoGroups || chosenDiceSize % highestAttack != 0) {
            return BattleCalculator.RandomAACasualties(planes, dice, bridge, allowMultipleHitsPerUnit);
        }
        Tuple<List<List<Unit>>, List<Unit>> airSplit = BattleCalculator.categorizeLowLuckAirUnits(planesList, location, chosenDiceSize, groupSize);
        if (hitsLeft < airSplit.getFirst().size() + (int)Math.ceil((double)airSplit.getSecond().size() / (double)groupSize)) {
            ArrayList<Unit> tempPossibleHitUnits = new ArrayList<Unit>();
            for (List<Unit> group : airSplit.getFirst()) {
                tempPossibleHitUnits.add(group.get(0));
            }
            if (airSplit.getSecond().size() > 0) {
                ArrayList remainders = new ArrayList(airSplit.getSecond());
                if (remainders.size() == 1) {
                    tempPossibleHitUnits.add((Unit)remainders.remove(0));
                } else {
                    int numberOfRemainderGroups = (int)Math.ceil((double)remainders.size() / (double)groupSize);
                    int[] randomRemainder = bridge.getRandom(remainders.size(), numberOfRemainderGroups, null, IRandomStats.DiceType.ENGINE, "Deciding which planes should die due to AA fire");
                    int pos2 = 0;
                    for (int element : randomRemainder) {
                        tempPossibleHitUnits.add((Unit)remainders.remove((pos2 += element) % remainders.size()));
                    }
                }
            }
            int[] hitRandom = bridge.getRandom(tempPossibleHitUnits.size(), hitsLeft, null, IRandomStats.DiceType.ENGINE, "Deciding which planes should die due to AA fire");
            int pos = 0;
            for (int element : hitRandom) {
                Unit unitHit = (Unit)tempPossibleHitUnits.remove((pos += element) % tempPossibleHitUnits.size());
                if (allowMultipleHitsPerUnit && Collections.frequency(finalCasualtyDetails.getDamaged(), unitHit) < BattleCalculator.getTotalHitpointsLeft(unitHit) - 1) {
                    finalCasualtyDetails.addToDamaged(unitHit);
                    continue;
                }
                finalCasualtyDetails.addToKilled(unitHit);
            }
            hitsLeft = 0;
        } else {
            for (List<Unit> group : airSplit.getFirst()) {
                Unit unitHit = group.get(0);
                if (allowMultipleHitsPerUnit && Collections.frequency(finalCasualtyDetails.getDamaged(), unitHit) < BattleCalculator.getTotalHitpointsLeft(unitHit) - 1) {
                    finalCasualtyDetails.addToDamaged(unitHit);
                } else {
                    finalCasualtyDetails.addToKilled(unitHit);
                }
                --hitsLeft;
            }
            if (hitsLeft == airSplit.getSecond().size()) {
                for (Unit unitHit : airSplit.getSecond()) {
                    if (allowMultipleHitsPerUnit && Collections.frequency(finalCasualtyDetails.getDamaged(), unitHit) < BattleCalculator.getTotalHitpointsLeft(unitHit) - 1) {
                        finalCasualtyDetails.addToDamaged(unitHit);
                        continue;
                    }
                    finalCasualtyDetails.addToKilled(unitHit);
                }
                hitsLeft = 0;
            } else if (hitsLeft != 0) {
                int[] hitRandom = bridge.getRandom(airSplit.getSecond().size(), hitsLeft, null, IRandomStats.DiceType.ENGINE, "Deciding which planes should die due to AA fire");
                int pos = 0;
                for (int element : hitRandom) {
                    Unit unitHit = airSplit.getSecond().remove((pos += element) % airSplit.getSecond().size());
                    if (allowMultipleHitsPerUnit && Collections.frequency(finalCasualtyDetails.getDamaged(), unitHit) < BattleCalculator.getTotalHitpointsLeft(unitHit) - 1) {
                        finalCasualtyDetails.addToDamaged(unitHit);
                        continue;
                    }
                    finalCasualtyDetails.addToKilled(unitHit);
                }
                hitsLeft = 0;
            }
        }
        if (finalCasualtyDetails.size() != dice.getHits()) {
            throw new IllegalStateException("wrong number of casulaties, expected:" + dice + " but got: " + finalCasualtyDetails);
        }
        return finalCasualtyDetails;
    }

    public static CasualtyDetails RandomAACasualties(Collection<Unit> planes, DiceRoll dice, IDelegateBridge bridge, boolean allowMultipleHitsPerUnit) {
        HashSet<Unit> duplicatesCheckSet1 = new HashSet<Unit>(planes);
        if (planes.size() != duplicatesCheckSet1.size()) {
            throw new IllegalStateException("Duplicate Units Detected: Original List:" + planes + "  HashSet:" + duplicatesCheckSet1);
        }
        int hitsLeft = dice.getHits();
        if (hitsLeft <= 0) {
            return new CasualtyDetails();
        }
        CasualtyDetails finalCasualtyDetails = new CasualtyDetails();
        int planeHP = allowMultipleHitsPerUnit ? BattleCalculator.getTotalHitpointsLeft(planes) : planes.size();
        ArrayList<Unit> planesList = new ArrayList<Unit>();
        for (Unit plane : planes) {
            int hpLeft = allowMultipleHitsPerUnit ? UnitAttachment.get(plane.getType()).getHitPoints() - plane.getHits() : Math.min(1, UnitAttachment.get(plane.getType()).getHitPoints() - plane.getHits());
            for (int hp = 0; hp < hpLeft; ++hp) {
                planesList.add(plane);
            }
        }
        if (hitsLeft < planeHP) {
            int[] hitRandom = bridge.getRandom(planeHP, hitsLeft, null, IRandomStats.DiceType.ENGINE, "Deciding which planes should die due to AA fire");
            int pos = 0;
            for (int element : hitRandom) {
                Unit unitHit = (Unit)planesList.remove((pos += element) % planesList.size());
                if (allowMultipleHitsPerUnit && Collections.frequency(finalCasualtyDetails.getDamaged(), unitHit) < BattleCalculator.getTotalHitpointsLeft(unitHit) - 1) {
                    finalCasualtyDetails.addToDamaged(unitHit);
                    continue;
                }
                finalCasualtyDetails.addToKilled(unitHit);
            }
        } else {
            for (Unit plane : planesList) {
                if (finalCasualtyDetails.getKilled().contains(plane)) {
                    finalCasualtyDetails.addToDamaged(plane);
                    continue;
                }
                finalCasualtyDetails.addToKilled(plane);
            }
        }
        return finalCasualtyDetails;
    }

    public static CasualtyDetails IndividuallyFiredAACasualties(boolean defending, Collection<Unit> planes, Collection<Unit> defendingAA, DiceRoll dice, Territory location, IDelegateBridge bridge, boolean allowMultipleHitsPerUnit) {
        int planeHP;
        int n = planeHP = allowMultipleHitsPerUnit ? BattleCalculator.getTotalHitpointsLeft(planes) : planes.size();
        if (DiceRoll.getTotalAAattacks(defendingAA, planes, bridge.getData()) != planeHP) {
            return BattleCalculator.RandomAACasualties(planes, dice, bridge, allowMultipleHitsPerUnit);
        }
        Triple<Integer, Integer, Boolean> triple = DiceRoll.getTotalAAPowerThenHitsAndFillSortedDiceThenIfAllUseSameAttack(null, null, !defending, defendingAA, planes, bridge.getData(), false);
        boolean allSameAttackPower = triple.getThird();
        if (!allSameAttackPower) {
            return BattleCalculator.RandomAACasualties(planes, dice, bridge, allowMultipleHitsPerUnit);
        }
        Tuple<Integer, Integer> attackThenDiceSides = DiceRoll.getAAattackAndMaxDiceSides(defendingAA, bridge.getData(), !defending);
        int highestAttack = attackThenDiceSides.getFirst();
        CasualtyDetails finalCasualtyDetails = new CasualtyDetails();
        int hits = dice.getHits();
        ArrayList<Unit> planesList = new ArrayList<Unit>();
        for (Unit plane : planes) {
            int hpLeft = allowMultipleHitsPerUnit ? UnitAttachment.get(plane.getType()).getHitPoints() - plane.getHits() : Math.min(1, UnitAttachment.get(plane.getType()).getHitPoints() - plane.getHits());
            for (int hp = 0; hp < hpLeft; ++hp) {
                planesList.add(plane);
            }
        }
        if (hits > planeHP) {
            throw new IllegalStateException("Can not have more hits than number of die rolls");
        }
        if (hits < planeHP) {
            List<Die> rolls = dice.getRolls(highestAttack);
            for (int i = 0; i < rolls.size(); ++i) {
                Die die = rolls.get(i);
                if (die.getType() != Die.DieType.HIT) continue;
                Unit unit = (Unit)planesList.get(i);
                if (allowMultipleHitsPerUnit && Collections.frequency(finalCasualtyDetails.getDamaged(), unit) < BattleCalculator.getTotalHitpointsLeft(unit) - 1) {
                    finalCasualtyDetails.addToDamaged(unit);
                    continue;
                }
                finalCasualtyDetails.addToKilled(unit);
            }
        } else {
            for (Unit plane : planesList) {
                if (finalCasualtyDetails.getKilled().contains(plane)) {
                    finalCasualtyDetails.addToDamaged(plane);
                    continue;
                }
                finalCasualtyDetails.addToKilled(plane);
            }
        }
        return finalCasualtyDetails;
    }

    public static CasualtyDetails selectCasualties(String step, PlayerID player, Collection<Unit> targetsToPickFrom, Collection<Unit> friendlyUnits, PlayerID enemyPlayer, Collection<Unit> enemyUnits, boolean amphibious, Collection<Unit> amphibiousLandAttackers, Territory battlesite, Collection<TerritoryEffect> territoryEffects, IDelegateBridge bridge, String text, DiceRoll dice, boolean defending, GUID battleID, boolean headLess, int extraHits, boolean allowMultipleHitsPerUnit) {
        if (targetsToPickFrom.isEmpty()) {
            return new CasualtyDetails();
        }
        if (!friendlyUnits.containsAll(targetsToPickFrom)) {
            throw new IllegalStateException("friendlyUnits should but does not contain all units from targetsToPickFrom");
        }
        GameData data = bridge.getData();
        boolean isEditMode = BaseEditDelegate.getEditMode(data);
        ITripleaPlayer tripleaPlayer = player.isNull() ? new WeakAI(player.getName(), "Easy (AI)") : (ITripleaPlayer)bridge.getRemotePlayer(player);
        Map<Object, Object> dependents = headLess ? Collections.emptyMap() : BattleCalculator.getDependents(targetsToPickFrom, data);
        if (isEditMode && !headLess) {
            CasualtyDetails editSelection = tripleaPlayer.selectCasualties(targetsToPickFrom, dependents, 0, text, dice, player, friendlyUnits, enemyPlayer, enemyUnits, amphibious, amphibiousLandAttackers, new CasualtyList(), battleID, battlesite, allowMultipleHitsPerUnit);
            List<Unit> killed = editSelection.getKilled();
            if (BattleCalculator.isPartialAmphibiousRetreat(data)) {
                killed = BattleCalculator.killAmphibiousFirst(killed, targetsToPickFrom);
            }
            return editSelection;
        }
        if (dice.getHits() == 0) {
            return new CasualtyDetails(Collections.<Unit>emptyList(), Collections.<Unit>emptyList(), true);
        }
        int hitsRemaining = dice.getHits();
        if (BattleCalculator.isTransportCasualtiesRestricted(data)) {
            hitsRemaining = extraHits;
        }
        if (!isEditMode && BattleCalculator.allTargetsOneTypeOneHitPoint(targetsToPickFrom, dependents)) {
            ArrayList<Unit> killed = new ArrayList<Unit>();
            Iterator<Unit> iter = targetsToPickFrom.iterator();
            for (int i = 0; i < hitsRemaining && i < targetsToPickFrom.size(); ++i) {
                killed.add(iter.next());
            }
            return new CasualtyDetails(killed, Collections.<Unit>emptyList(), true);
        }
        IntegerMap<UnitType> costs = BattleCalculator.getCostsForTUV(player, data);
        Tuple<CasualtyList, List<Unit>> defaultCasualtiesAndSortedTargets = BattleCalculator.getDefaultCasualties(targetsToPickFrom, hitsRemaining, defending, player, friendlyUnits, enemyPlayer, enemyUnits, amphibious, amphibiousLandAttackers, battlesite, costs, territoryEffects, data, allowMultipleHitsPerUnit, true);
        CasualtyList defaultCasualties = defaultCasualtiesAndSortedTargets.getFirst();
        List<Unit> sortedTargetsToPickFrom = defaultCasualtiesAndSortedTargets.getSecond();
        if (sortedTargetsToPickFrom.size() != targetsToPickFrom.size() || !targetsToPickFrom.containsAll(sortedTargetsToPickFrom) || !sortedTargetsToPickFrom.containsAll(targetsToPickFrom)) {
            throw new IllegalStateException("sortedTargetsToPickFrom must contain the same units as targetsToPickFrom list");
        }
        int totalHitpoints = allowMultipleHitsPerUnit ? BattleCalculator.getTotalHitpointsLeft(sortedTargetsToPickFrom) : sortedTargetsToPickFrom.size();
        CasualtyDetails casualtySelection = hitsRemaining >= totalHitpoints ? new CasualtyDetails(defaultCasualties, true) : tripleaPlayer.selectCasualties(sortedTargetsToPickFrom, dependents, hitsRemaining, text, dice, player, friendlyUnits, enemyPlayer, enemyUnits, amphibious, amphibiousLandAttackers, defaultCasualties, battleID, battlesite, allowMultipleHitsPerUnit);
        List<Unit> killed = casualtySelection.getKilled();
        if (BattleCalculator.isPartialAmphibiousRetreat(data)) {
            killed = BattleCalculator.killAmphibiousFirst(killed, sortedTargetsToPickFrom);
        }
        List<Unit> damaged = casualtySelection.getDamaged();
        int numhits = killed.size();
        if (!allowMultipleHitsPerUnit) {
            damaged.clear();
        } else {
            for (Unit unit : killed) {
                UnitAttachment ua = UnitAttachment.get(unit.getType());
                int damageToUnit = Collections.frequency(damaged, unit);
                numhits += Math.max(0, Math.min(damageToUnit, ua.getHitPoints() - (1 + unit.getHits())));
                Iterator<Unit> iter = damaged.iterator();
                while (iter.hasNext()) {
                    if (!unit.equals(iter.next())) continue;
                    iter.remove();
                }
            }
        }
        if (!isEditMode && numhits + damaged.size() != (hitsRemaining > totalHitpoints ? totalHitpoints : hitsRemaining)) {
            tripleaPlayer.reportError("Wrong number of casualties selected");
            if (headLess) {
                System.err.println("Possible Infinite Loop: Wrong number of casualties selected: number of hits on units " + (numhits + damaged.size()) + " != number of hits to take " + (hitsRemaining > totalHitpoints ? totalHitpoints : hitsRemaining) + ", for " + casualtySelection.toString());
            }
            return BattleCalculator.selectCasualties(step, player, sortedTargetsToPickFrom, friendlyUnits, enemyPlayer, enemyUnits, amphibious, amphibiousLandAttackers, battlesite, territoryEffects, bridge, text, dice, defending, battleID, headLess, extraHits, allowMultipleHitsPerUnit);
        }
        if (!sortedTargetsToPickFrom.containsAll(killed) || !sortedTargetsToPickFrom.containsAll(damaged)) {
            tripleaPlayer.reportError("Cannot remove enough units of those types");
            if (headLess) {
                System.err.println("Possible Infinite Loop: Cannot remove enough units of those types: targets " + MyFormatter.unitsToTextNoOwner(sortedTargetsToPickFrom) + ", for " + casualtySelection.toString());
            }
            return BattleCalculator.selectCasualties(step, player, sortedTargetsToPickFrom, friendlyUnits, enemyPlayer, enemyUnits, amphibious, amphibiousLandAttackers, battlesite, territoryEffects, bridge, text, dice, defending, battleID, headLess, extraHits, allowMultipleHitsPerUnit);
        }
        return casualtySelection;
    }

    private static List<Unit> killAmphibiousFirst(List<Unit> killed, Collection<Unit> targets) {
        ArrayList<Unit> allAmphibUnits = new ArrayList<Unit>();
        ArrayList<Unit> killedNonAmphibUnits = new ArrayList<Unit>();
        ArrayList<UnitType> amphibTypes = new ArrayList<UnitType>();
        CompositeMatchAnd aMatch = new CompositeMatchAnd(Matches.UnitIsLand, Matches.UnitWasNotAmphibious);
        killedNonAmphibUnits.addAll(Match.getMatches(killed, aMatch));
        if (killedNonAmphibUnits.isEmpty()) {
            return killed;
        }
        allAmphibUnits.addAll(Match.getMatches(targets, Matches.UnitWasAmphibious));
        allAmphibUnits.removeAll(Match.getMatches(killed, Matches.UnitWasAmphibious));
        for (Unit unit : allAmphibUnits) {
            UnitType ut = unit.getType();
            if (amphibTypes.contains(ut)) continue;
            amphibTypes.add(ut);
        }
        for (Unit unit : killedNonAmphibUnits) {
            if (!amphibTypes.contains(unit.getType())) continue;
            List<Unit> oneAmphibUnit = Match.getNMatches(allAmphibUnits, 1, Matches.unitIsOfType(unit.getType()));
            if (oneAmphibUnit.size() > 0) {
                Unit amphibUnit = oneAmphibUnit.iterator().next();
                killed.remove(unit);
                killed.add(amphibUnit);
                allAmphibUnits.remove(amphibUnit);
                continue;
            }
            amphibTypes.remove(unit.getType());
        }
        return killed;
    }

    private static Tuple<CasualtyList, List<Unit>> getDefaultCasualties(Collection<Unit> targetsToPickFrom, int hits, boolean defending, PlayerID player, Collection<Unit> friendlyUnits, PlayerID enemyPlayer, Collection<Unit> enemyUnits, boolean amphibious, Collection<Unit> amphibiousLandAttackers, Territory battlesite, IntegerMap<UnitType> costs, Collection<TerritoryEffect> territoryEffects, GameData data, boolean allowMultipleHitsPerUnit, boolean bonus) {
        CasualtyList defaultCasualtySelection = new CasualtyList();
        List<Unit> sorted = BattleCalculator.sortUnitsForCasualtiesWithSupport(targetsToPickFrom, hits, defending, player, friendlyUnits, enemyPlayer, enemyUnits, amphibious, amphibiousLandAttackers, battlesite, costs, territoryEffects, data, allowMultipleHitsPerUnit, bonus);
        int numSelectedCasualties = 0;
        if (allowMultipleHitsPerUnit) {
            for (Unit unit : sorted) {
                if (numSelectedCasualties >= hits) {
                    return new Tuple<CasualtyList, List<Unit>>(defaultCasualtySelection, sorted);
                }
                UnitAttachment ua = UnitAttachment.get(unit.getType());
                int extraHP = Math.min(hits - numSelectedCasualties, ua.getHitPoints() - (1 + unit.getHits()));
                for (int i = 0; i < extraHP; ++i) {
                    ++numSelectedCasualties;
                    defaultCasualtySelection.addToDamaged(unit);
                }
            }
        }
        for (Unit unit : sorted) {
            if (numSelectedCasualties >= hits) {
                return new Tuple<CasualtyList, List<Unit>>(defaultCasualtySelection, sorted);
            }
            defaultCasualtySelection.addToKilled(unit);
            ++numSelectedCasualties;
        }
        return new Tuple<CasualtyList, List<Unit>>(defaultCasualtySelection, sorted);
    }

    public static List<Unit> sortUnitsForCasualtiesWithSupport(Collection<Unit> targetsToPickFrom, int hits, boolean defending, PlayerID player, Collection<Unit> friendlyUnits, PlayerID enemyPlayer, Collection<Unit> enemyUnits, boolean amphibious, Collection<Unit> amphibiousLandAttackers, Territory battlesite, IntegerMap<UnitType> costs, Collection<TerritoryEffect> territoryEffects, GameData data, boolean allowMultipleHitsPerUnit, boolean bonus) {
        if (!GameRunner2.getCasualtySelectionSlow()) {
            return BattleCalculator.sortUnitsForCasualtiesWithSupportNewWithCaching(targetsToPickFrom, hits, defending, player, friendlyUnits, enemyPlayer, enemyUnits, amphibious, amphibiousLandAttackers, battlesite, costs, territoryEffects, data, allowMultipleHitsPerUnit, bonus);
        }
        return BattleCalculator.sortUnitsForCasualtiesWithSupportBruteForce(targetsToPickFrom, hits, defending, player, friendlyUnits, enemyPlayer, enemyUnits, amphibious, amphibiousLandAttackers, battlesite, costs, territoryEffects, data, allowMultipleHitsPerUnit, bonus);
    }

    private static List<Unit> sortUnitsForCasualtiesWithSupportNewWithCaching(Collection<Unit> targetsToPickFrom, int hits, boolean defending, PlayerID player, Collection<Unit> friendlyUnits, PlayerID enemyPlayer, Collection<Unit> enemyUnits, boolean amphibious, Collection<Unit> amphibiousLandAttackers, Territory battlesite, IntegerMap<UnitType> costs, Collection<TerritoryEffect> territoryEffects, GameData data, boolean allowMultipleHitsPerUnit, boolean bonus) {
        ArrayList<UnitType> targetTypes = new ArrayList<UnitType>();
        for (Unit u : targetsToPickFrom) {
            targetTypes.add(u.getType());
        }
        ArrayList<UnitType> amphibTypes = new ArrayList<UnitType>();
        if (amphibiousLandAttackers != null) {
            for (Unit u : amphibiousLandAttackers) {
                amphibTypes.add(u.getType());
            }
        }
        int targetsHashCode = 1;
        for (UnitType ut : targetTypes) {
            targetsHashCode += ut.hashCode();
        }
        targetsHashCode *= 31;
        int amphibHashCode = 1;
        for (UnitType ut : amphibTypes) {
            amphibHashCode += ut.hashCode();
        }
        String key = player.getName() + "|" + battlesite.getName() + "|" + defending + "|" + amphibious + "|" + targetsHashCode + "|" + (amphibHashCode *= 31);
        List<UnitType> stored = oolCache.get(key);
        if (stored != null) {
            ArrayList<Unit> result = new ArrayList<Unit>();
            ArrayList<Unit> selectFrom = new ArrayList<Unit>(targetsToPickFrom);
            for (UnitType ut : stored) {
                Iterator it = selectFrom.iterator();
                while (it.hasNext()) {
                    Unit u = (Unit)it.next();
                    if (!ut.equals(u.getType())) continue;
                    result.add(u);
                    it.remove();
                }
            }
            return result;
        }
        ArrayList<Unit> sortedUnitsList = new ArrayList<Unit>(targetsToPickFrom);
        Collections.sort(sortedUnitsList, new UnitBattleComparator(defending, costs, territoryEffects, data, bonus, false));
        Collections.reverse(sortedUnitsList);
        UnitBattleComparator unitComparatorWithoutPrimaryPower = new UnitBattleComparator(defending, costs, territoryEffects, data, bonus, true);
        ArrayList<Unit> sortedWellEnoughUnitsList = new ArrayList<Unit>();
        HashMap<Unit, IntegerMap<Unit>> unitSupportPowerMap = new HashMap<Unit, IntegerMap<Unit>>();
        HashMap<Unit, IntegerMap<Unit>> unitSupportRollsMap = new HashMap<Unit, IntegerMap<Unit>>();
        Map<Unit, Tuple<Integer, Integer>> unitPowerAndRollsMap = DiceRoll.getUnitPowerAndRollsForNormalBattles(sortedUnitsList, sortedUnitsList, new ArrayList<Unit>(enemyUnits), defending, false, player, data, battlesite, territoryEffects, amphibious, amphibiousLandAttackers, unitSupportPowerMap, unitSupportRollsMap);
        Collections.reverse(sortedUnitsList);
        for (int i = 0; i < sortedUnitsList.size(); ++i) {
            IntegerMap unitSupportRollsMapForUnit;
            Unit worstUnit = null;
            int minPower = Integer.MAX_VALUE;
            HashSet<UnitType> unitTypes = new HashSet<UnitType>();
            for (Unit u : sortedUnitsList) {
                IntegerMap unitSupportRollsMapForUnit2;
                int addedPower;
                int powerWithoutSupport;
                Tuple<Integer, Integer> strengthAndRollsWithoutSupport;
                int powerWithSupport;
                HashMap<Unit, Tuple<Integer, Integer>> supportedUnitMap;
                if (unitTypes.contains(u.getType())) continue;
                unitTypes.add(u.getType());
                HashMap<Unit, Tuple<Integer, Integer>> currentUnitMap = new HashMap<Unit, Tuple<Integer, Integer>>();
                currentUnitMap.put(u, unitPowerAndRollsMap.get(u));
                int power = DiceRoll.getTotalPowerAndRolls(currentUnitMap, data).getFirst();
                IntegerMap unitSupportPowerMapForUnit = (IntegerMap)unitSupportPowerMap.get(u);
                if (unitSupportPowerMapForUnit != null) {
                    for (Unit supportedUnit : unitSupportPowerMapForUnit.keySet()) {
                        Tuple<Integer, Integer> strengthAndRolls = unitPowerAndRollsMap.get(supportedUnit);
                        if (strengthAndRolls == null) continue;
                        IntegerMap unitSupportRollsMapForUnit3 = (IntegerMap)unitSupportRollsMap.get(u);
                        if (unitSupportRollsMapForUnit3 != null) {
                            strengthAndRolls = new Tuple<Integer, Integer>(strengthAndRolls.getFirst(), strengthAndRolls.getSecond() - unitSupportRollsMapForUnit3.getInt(supportedUnit));
                        }
                        if (strengthAndRolls.getSecond() == 1) {
                            power += unitSupportPowerMapForUnit.getInt(supportedUnit);
                            continue;
                        }
                        supportedUnitMap = new HashMap();
                        supportedUnitMap.put(supportedUnit, strengthAndRolls);
                        powerWithSupport = DiceRoll.getTotalPowerAndRolls(supportedUnitMap, data).getFirst();
                        int strengthWithoutSupport = strengthAndRolls.getFirst() - unitSupportPowerMapForUnit.getInt(supportedUnit);
                        strengthAndRollsWithoutSupport = new Tuple<Integer, Integer>(strengthWithoutSupport, strengthAndRolls.getSecond());
                        supportedUnitMap.put(supportedUnit, strengthAndRollsWithoutSupport);
                        powerWithoutSupport = DiceRoll.getTotalPowerAndRolls(supportedUnitMap, data).getFirst();
                        addedPower = powerWithSupport - powerWithoutSupport;
                        power += addedPower;
                    }
                }
                if ((unitSupportRollsMapForUnit2 = (IntegerMap)unitSupportRollsMap.get(u)) != null) {
                    for (Unit supportedUnit : unitSupportRollsMapForUnit2.keySet()) {
                        Tuple<Integer, Integer> strengthAndRolls = unitPowerAndRollsMap.get(supportedUnit);
                        if (strengthAndRolls == null) continue;
                        supportedUnitMap = new HashMap<Unit, Tuple<Integer, Integer>>();
                        supportedUnitMap.put(supportedUnit, strengthAndRolls);
                        powerWithSupport = DiceRoll.getTotalPowerAndRolls(supportedUnitMap, data).getFirst();
                        int rollsWithoutSupport = strengthAndRolls.getSecond() - ((IntegerMap)unitSupportRollsMap.get(u)).getInt(supportedUnit);
                        strengthAndRollsWithoutSupport = new Tuple<Integer, Integer>(strengthAndRolls.getFirst(), rollsWithoutSupport);
                        supportedUnitMap.put(supportedUnit, strengthAndRollsWithoutSupport);
                        powerWithoutSupport = DiceRoll.getTotalPowerAndRolls(supportedUnitMap, data).getFirst();
                        addedPower = powerWithSupport - powerWithoutSupport;
                        power += addedPower;
                    }
                }
                if (power >= minPower && (power != minPower || unitComparatorWithoutPrimaryPower.compare(u, worstUnit) >= 0)) continue;
                worstUnit = u;
                minPower = power;
            }
            IntegerMap unitSupportPowerMapForUnit = (IntegerMap)unitSupportPowerMap.get(worstUnit);
            if (unitSupportPowerMapForUnit != null) {
                for (Unit supportedUnit : unitSupportPowerMapForUnit.keySet()) {
                    Tuple<Integer, Integer> strengthAndRolls = unitPowerAndRollsMap.get(supportedUnit);
                    if (strengthAndRolls == null) continue;
                    int strengthWithoutSupport = strengthAndRolls.getFirst() - unitSupportPowerMapForUnit.getInt(supportedUnit);
                    Tuple<Integer, Integer> strengthAndRollsWithoutSupport = new Tuple<Integer, Integer>(strengthWithoutSupport, strengthAndRolls.getSecond());
                    unitPowerAndRollsMap.put(supportedUnit, strengthAndRollsWithoutSupport);
                    sortedUnitsList.remove(supportedUnit);
                    sortedUnitsList.add(0, supportedUnit);
                }
            }
            if ((unitSupportRollsMapForUnit = (IntegerMap)unitSupportRollsMap.get(worstUnit)) != null) {
                for (Unit supportedUnit : unitSupportRollsMapForUnit.keySet()) {
                    Tuple<Integer, Integer> strengthAndRolls = unitPowerAndRollsMap.get(supportedUnit);
                    if (strengthAndRolls == null) continue;
                    int rollsWithoutSupport = strengthAndRolls.getSecond() - unitSupportRollsMapForUnit.getInt(supportedUnit);
                    Tuple<Integer, Integer> strengthAndRollsWithoutSupport = new Tuple<Integer, Integer>(strengthAndRolls.getFirst(), rollsWithoutSupport);
                    unitPowerAndRollsMap.put(supportedUnit, strengthAndRollsWithoutSupport);
                    sortedUnitsList.remove(supportedUnit);
                    sortedUnitsList.add(0, supportedUnit);
                }
            }
            sortedWellEnoughUnitsList.add(worstUnit);
            sortedUnitsList.remove(worstUnit);
            unitPowerAndRollsMap.remove(worstUnit);
            unitSupportPowerMap.remove(worstUnit);
            unitSupportRollsMap.remove(worstUnit);
        }
        sortedWellEnoughUnitsList.addAll(sortedUnitsList);
        ArrayList<UnitType> unitTypes = new ArrayList<UnitType>();
        for (Unit u : sortedWellEnoughUnitsList) {
            unitTypes.add(u.getType());
        }
        Iterator it = unitTypes.iterator();
        while (it.hasNext()) {
            oolCache.put(key, new ArrayList(unitTypes));
            UnitType unitTypeToRemove = (UnitType)it.next();
            targetTypes.remove(unitTypeToRemove);
            if (Collections.frequency(targetTypes, unitTypeToRemove) < Collections.frequency(amphibTypes, unitTypeToRemove)) {
                amphibTypes.remove(unitTypeToRemove);
            }
            targetsHashCode = 1;
            for (UnitType ut : targetTypes) {
                targetsHashCode += ut.hashCode();
            }
            targetsHashCode *= 31;
            amphibHashCode = 1;
            for (UnitType ut : amphibTypes) {
                amphibHashCode += ut.hashCode();
            }
            key = player.getName() + "|" + battlesite.getName() + "|" + defending + "|" + amphibious + "|" + targetsHashCode + "|" + (amphibHashCode *= 31);
            it.remove();
        }
        return sortedWellEnoughUnitsList;
    }

    private static List<Unit> sortUnitsForCasualtiesWithSupportNew(Collection<Unit> targetsToPickFrom, int hits, boolean defending, PlayerID player, Collection<Unit> friendlyUnits, PlayerID enemyPlayer, Collection<Unit> enemyUnits, boolean amphibious, Collection<Unit> amphibiousLandAttackers, Territory battlesite, IntegerMap<UnitType> costs, Collection<TerritoryEffect> territoryEffects, GameData data, boolean allowMultipleHitsPerUnit, boolean bonus) {
        ArrayList<Unit> sortedUnitsList = new ArrayList<Unit>(targetsToPickFrom);
        Collections.sort(sortedUnitsList, new UnitBattleComparator(defending, costs, territoryEffects, data, bonus, false));
        int numberOfUnitsWeMustSort = hits;
        int extraHP = 0;
        if (allowMultipleHitsPerUnit) {
            for (Unit unit : sortedUnitsList) {
                if ((extraHP += Math.max(0, UnitAttachment.get(unit.getType()).getHitPoints() - (1 + unit.getHits()))) < hits) continue;
                return sortedUnitsList;
            }
            numberOfUnitsWeMustSort = Math.max(extraHP, hits - extraHP);
        }
        if (hits > extraHP + sortedUnitsList.size()) {
            return sortedUnitsList;
        }
        Collections.reverse(sortedUnitsList);
        UnitBattleComparator unitComparatorWithoutPrimaryPower = new UnitBattleComparator(defending, costs, territoryEffects, data, bonus, true);
        ArrayList<Unit> sortedWellEnoughUnitsList = new ArrayList<Unit>();
        HashMap<Unit, IntegerMap<Unit>> unitSupportPowerMap = new HashMap<Unit, IntegerMap<Unit>>();
        HashMap<Unit, IntegerMap<Unit>> unitSupportRollsMap = new HashMap<Unit, IntegerMap<Unit>>();
        Map<Unit, Tuple<Integer, Integer>> unitPowerAndRollsMap = DiceRoll.getUnitPowerAndRollsForNormalBattles(sortedUnitsList, sortedUnitsList, new ArrayList<Unit>(enemyUnits), defending, false, player, data, battlesite, territoryEffects, amphibious, amphibiousLandAttackers, unitSupportPowerMap, unitSupportRollsMap);
        Collections.reverse(sortedUnitsList);
        for (int i = 0; i < numberOfUnitsWeMustSort; ++i) {
            IntegerMap unitSupportRollsMapForUnit;
            Unit worstUnit = null;
            int minPower = Integer.MAX_VALUE;
            HashSet<UnitType> unitTypes = new HashSet<UnitType>();
            for (Unit u : sortedUnitsList) {
                IntegerMap unitSupportRollsMapForUnit2;
                int addedPower;
                int powerWithoutSupport;
                Tuple<Integer, Integer> strengthAndRollsWithoutSupport;
                int powerWithSupport;
                HashMap<Unit, Tuple<Integer, Integer>> supportedUnitMap;
                if (unitTypes.contains(u.getType())) continue;
                unitTypes.add(u.getType());
                HashMap<Unit, Tuple<Integer, Integer>> currentUnitMap = new HashMap<Unit, Tuple<Integer, Integer>>();
                currentUnitMap.put(u, unitPowerAndRollsMap.get(u));
                int power = DiceRoll.getTotalPowerAndRolls(currentUnitMap, data).getFirst();
                IntegerMap unitSupportPowerMapForUnit = (IntegerMap)unitSupportPowerMap.get(u);
                if (unitSupportPowerMapForUnit != null) {
                    for (Unit supportedUnit : unitSupportPowerMapForUnit.keySet()) {
                        Tuple<Integer, Integer> strengthAndRolls = unitPowerAndRollsMap.get(supportedUnit);
                        if (strengthAndRolls == null) continue;
                        IntegerMap unitSupportRollsMapForUnit3 = (IntegerMap)unitSupportRollsMap.get(u);
                        if (unitSupportRollsMapForUnit3 != null) {
                            strengthAndRolls = new Tuple<Integer, Integer>(strengthAndRolls.getFirst(), strengthAndRolls.getSecond() - unitSupportRollsMapForUnit3.getInt(supportedUnit));
                        }
                        if (strengthAndRolls.getSecond() == 1) {
                            power += unitSupportPowerMapForUnit.getInt(supportedUnit);
                            continue;
                        }
                        supportedUnitMap = new HashMap();
                        supportedUnitMap.put(supportedUnit, strengthAndRolls);
                        powerWithSupport = DiceRoll.getTotalPowerAndRolls(supportedUnitMap, data).getFirst();
                        int strengthWithoutSupport = strengthAndRolls.getFirst() - unitSupportPowerMapForUnit.getInt(supportedUnit);
                        strengthAndRollsWithoutSupport = new Tuple<Integer, Integer>(strengthWithoutSupport, strengthAndRolls.getSecond());
                        supportedUnitMap.put(supportedUnit, strengthAndRollsWithoutSupport);
                        powerWithoutSupport = DiceRoll.getTotalPowerAndRolls(supportedUnitMap, data).getFirst();
                        addedPower = powerWithSupport - powerWithoutSupport;
                        power += addedPower;
                    }
                }
                if ((unitSupportRollsMapForUnit2 = (IntegerMap)unitSupportRollsMap.get(u)) != null) {
                    for (Unit supportedUnit : unitSupportRollsMapForUnit2.keySet()) {
                        Tuple<Integer, Integer> strengthAndRolls = unitPowerAndRollsMap.get(supportedUnit);
                        if (strengthAndRolls == null) continue;
                        supportedUnitMap = new HashMap<Unit, Tuple<Integer, Integer>>();
                        supportedUnitMap.put(supportedUnit, strengthAndRolls);
                        powerWithSupport = DiceRoll.getTotalPowerAndRolls(supportedUnitMap, data).getFirst();
                        int rollsWithoutSupport = strengthAndRolls.getSecond() - ((IntegerMap)unitSupportRollsMap.get(u)).getInt(supportedUnit);
                        strengthAndRollsWithoutSupport = new Tuple<Integer, Integer>(strengthAndRolls.getFirst(), rollsWithoutSupport);
                        supportedUnitMap.put(supportedUnit, strengthAndRollsWithoutSupport);
                        powerWithoutSupport = DiceRoll.getTotalPowerAndRolls(supportedUnitMap, data).getFirst();
                        addedPower = powerWithSupport - powerWithoutSupport;
                        power += addedPower;
                    }
                }
                if (power >= minPower && (power != minPower || unitComparatorWithoutPrimaryPower.compare(u, worstUnit) >= 0)) continue;
                worstUnit = u;
                minPower = power;
            }
            IntegerMap unitSupportPowerMapForUnit = (IntegerMap)unitSupportPowerMap.get(worstUnit);
            if (unitSupportPowerMapForUnit != null) {
                for (Unit supportedUnit : unitSupportPowerMapForUnit.keySet()) {
                    Tuple<Integer, Integer> strengthAndRolls = unitPowerAndRollsMap.get(supportedUnit);
                    if (strengthAndRolls == null) continue;
                    int strengthWithoutSupport = strengthAndRolls.getFirst() - unitSupportPowerMapForUnit.getInt(supportedUnit);
                    Tuple<Integer, Integer> strengthAndRollsWithoutSupport = new Tuple<Integer, Integer>(strengthWithoutSupport, strengthAndRolls.getSecond());
                    unitPowerAndRollsMap.put(supportedUnit, strengthAndRollsWithoutSupport);
                    sortedUnitsList.remove(supportedUnit);
                    sortedUnitsList.add(0, supportedUnit);
                }
            }
            if ((unitSupportRollsMapForUnit = (IntegerMap)unitSupportRollsMap.get(worstUnit)) != null) {
                for (Unit supportedUnit : unitSupportRollsMapForUnit.keySet()) {
                    Tuple<Integer, Integer> strengthAndRolls = unitPowerAndRollsMap.get(supportedUnit);
                    if (strengthAndRolls == null) continue;
                    int rollsWithoutSupport = strengthAndRolls.getSecond() - unitSupportRollsMapForUnit.getInt(supportedUnit);
                    Tuple<Integer, Integer> strengthAndRollsWithoutSupport = new Tuple<Integer, Integer>(strengthAndRolls.getFirst(), rollsWithoutSupport);
                    unitPowerAndRollsMap.put(supportedUnit, strengthAndRollsWithoutSupport);
                    sortedUnitsList.remove(supportedUnit);
                    sortedUnitsList.add(0, supportedUnit);
                }
            }
            sortedWellEnoughUnitsList.add(worstUnit);
            sortedUnitsList.remove(worstUnit);
            unitPowerAndRollsMap.remove(worstUnit);
            unitSupportPowerMap.remove(worstUnit);
            unitSupportRollsMap.remove(worstUnit);
        }
        sortedWellEnoughUnitsList.addAll(sortedUnitsList);
        return sortedWellEnoughUnitsList;
    }

    private static List<Unit> sortUnitsForCasualtiesWithSupportBruteForce(Collection<Unit> targetsToPickFrom, int hits, boolean defending, PlayerID player, Collection<Unit> friendlyUnits, PlayerID enemyPlayer, Collection<Unit> enemyUnits, boolean amphibious, Collection<Unit> amphibiousLandAttackers, Territory battlesite, IntegerMap<UnitType> costs, Collection<TerritoryEffect> territoryEffects, GameData data, boolean allowMultipleHitsPerUnit, boolean bonus) {
        ArrayList<Unit> sortedUnitsList = new ArrayList<Unit>(targetsToPickFrom);
        Collections.sort(sortedUnitsList, new UnitBattleComparator(defending, costs, territoryEffects, data, bonus, false));
        int numberOfUnitsWeMustSort = hits;
        int extraHP = 0;
        if (allowMultipleHitsPerUnit) {
            for (Unit unit : sortedUnitsList) {
                if ((extraHP += Math.max(0, UnitAttachment.get(unit.getType()).getHitPoints() - (1 + unit.getHits()))) < hits) continue;
                return sortedUnitsList;
            }
            numberOfUnitsWeMustSort = Math.max(extraHP, hits - extraHP);
        }
        if (hits > extraHP + sortedUnitsList.size()) {
            return sortedUnitsList;
        }
        UnitBattleComparator unitComparatorWithoutPrimaryPower = new UnitBattleComparator(defending, costs, territoryEffects, data, bonus, true);
        ArrayList<Unit> sortedWellEnoughUnitsList = new ArrayList<Unit>();
        for (int i = 0; i < numberOfUnitsWeMustSort; ++i) {
            Unit worstUnit = null;
            int maxPowerDifference = Integer.MIN_VALUE;
            HashSet<UnitType> unitTypes = new HashSet<UnitType>();
            for (Unit u : sortedUnitsList) {
                int enemyPower;
                if (unitTypes.contains(u.getType())) continue;
                unitTypes.add(u.getType());
                ArrayList<Unit> units = new ArrayList<Unit>(sortedUnitsList);
                units.remove(u);
                ArrayList<Unit> enemyUnitList = new ArrayList<Unit>(enemyUnits);
                Collections.reverse(units);
                int power = DiceRoll.getTotalPowerAndRolls(DiceRoll.getUnitPowerAndRollsForNormalBattles(units, units, enemyUnitList, defending, false, player, data, battlesite, territoryEffects, amphibious, amphibiousLandAttackers), data).getFirst();
                int powerDifference = power - (enemyPower = DiceRoll.getTotalPowerAndRolls(DiceRoll.getUnitPowerAndRollsForNormalBattles(enemyUnitList, enemyUnitList, units, !defending, false, enemyPlayer, data, battlesite, territoryEffects, amphibious, amphibiousLandAttackers), data).getFirst().intValue());
                if (powerDifference <= maxPowerDifference && (powerDifference != maxPowerDifference || unitComparatorWithoutPrimaryPower.compare(u, worstUnit) >= 0)) continue;
                worstUnit = u;
                maxPowerDifference = powerDifference;
            }
            sortedUnitsList.remove(worstUnit);
            sortedWellEnoughUnitsList.add(worstUnit);
        }
        sortedWellEnoughUnitsList.addAll(sortedUnitsList);
        return sortedWellEnoughUnitsList;
    }

    public static Map<Unit, Collection<Unit>> getDependents(Collection<Unit> targets, GameData data) {
        HashMap<Unit, Collection<Unit>> dependents = new HashMap<Unit, Collection<Unit>>();
        for (Unit target : targets) {
            dependents.put(target, TransportTracker.transportingAndUnloaded(target));
        }
        return dependents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IntegerMap<UnitType> getCostsForTUV(PlayerID player, GameData data) {
        Resource PUS;
        data.acquireReadLock();
        try {
            PUS = data.getResourceList().getResource("PUs");
        }
        finally {
            data.releaseReadLock();
        }
        IntegerMap<UnitType> costs = new IntegerMap<UnitType>();
        ProductionFrontier frontier = player.getProductionFrontier();
        if (frontier == null) {
            return BattleCalculator.getCostsForTuvForAllPlayersMergedAndAveraged(data);
        }
        for (ProductionRule rule : frontier.getRules()) {
            int costPerGroup = rule.getCosts().getInt(PUS);
            NamedAttachable resourceOrUnit = rule.getResults().keySet().iterator().next();
            if (!(resourceOrUnit instanceof UnitType)) continue;
            UnitType type = (UnitType)resourceOrUnit;
            int numberProduced = rule.getResults().getInt(type);
            int roundedCostPerSingle = (int)Math.ceil((double)costPerGroup / (double)numberProduced);
            costs.put(type, roundedCostPerSingle);
        }
        IntegerMap<UnitType> costsAll = BattleCalculator.getCostsForTuvForAllPlayersMergedAndAveraged(data);
        for (UnitType ut : costsAll.keySet()) {
            if (costs.keySet().contains(ut)) continue;
            costs.put(ut, costsAll.getInt(ut));
        }
        return costs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IntegerMap<UnitType> getCostsForTuvForAllPlayersMergedAndAveraged(GameData data) {
        Resource PUS;
        data.acquireReadLock();
        try {
            PUS = data.getResourceList().getResource("PUs");
        }
        finally {
            data.releaseReadLock();
        }
        IntegerMap<UnitType> costs = new IntegerMap<UnitType>();
        HashMap differentCosts = new HashMap();
        for (ProductionRule rule : data.getProductionRuleList().getProductionRules()) {
            NamedAttachable resourceOrUnit = rule.getResults().keySet().iterator().next();
            if (!(resourceOrUnit instanceof UnitType)) continue;
            UnitType ut = (UnitType)resourceOrUnit;
            int numberProduced = rule.getResults().getInt(ut);
            int costPerGroup = rule.getCosts().getInt(PUS);
            int roundedCostPerSingle = (int)Math.ceil((double)costPerGroup / (double)numberProduced);
            if (differentCosts.containsKey(ut)) {
                ((List)differentCosts.get(ut)).add(roundedCostPerSingle);
                continue;
            }
            ArrayList<Integer> listTemp = new ArrayList<Integer>();
            listTemp.add(roundedCostPerSingle);
            differentCosts.put(ut, listTemp);
        }
        for (UnitType ut : differentCosts.keySet()) {
            int totalCosts = 0;
            List costsForType = (List)differentCosts.get(ut);
            Iterator i$ = costsForType.iterator();
            while (i$.hasNext()) {
                int cost = (Integer)i$.next();
                totalCosts += cost;
            }
            int averagedCost = (int)Math.round((double)totalCosts / (double)costsForType.size());
            costs.put(ut, averagedCost);
        }
        return costs;
    }

    public static Map<PlayerID, Map<UnitType, ResourceCollection>> getResourceCostsForTUV(GameData data, boolean includeAverageForMissingUnits) {
        LinkedHashMap<PlayerID, Map<UnitType, ResourceCollection>> rVal = new LinkedHashMap<PlayerID, Map<UnitType, ResourceCollection>>();
        HashMap average = includeAverageForMissingUnits ? BattleCalculator.getResourceCostsForTUVForAllPlayersMergedAndAveraged(data) : new HashMap();
        List<PlayerID> players = data.getPlayerList().getPlayers();
        players.add(PlayerID.NULL_PLAYERID);
        for (PlayerID p : players) {
            ProductionFrontier frontier = p.getProductionFrontier();
            if (frontier == null) {
                rVal.put(p, average);
                continue;
            }
            Map<UnitType, ResourceCollection> current = rVal.get(p);
            if (current == null) {
                current = new LinkedHashMap<UnitType, ResourceCollection>();
                rVal.put(p, current);
            }
            for (ProductionRule rule : frontier.getRules()) {
                if (rule == null || rule.getResults() == null || rule.getResults().isEmpty() || rule.getCosts() == null || rule.getCosts().isEmpty()) continue;
                IntegerMap<NamedAttachable> unitMap = rule.getResults();
                ResourceCollection costPerGroup = new ResourceCollection(data, rule.getCosts());
                HashSet<UnitType> units = new HashSet<UnitType>();
                for (NamedAttachable resourceOrUnit : unitMap.keySet()) {
                    if (!(resourceOrUnit instanceof UnitType)) continue;
                    units.add((UnitType)resourceOrUnit);
                }
                if (units.isEmpty()) continue;
                int totalProduced = unitMap.totalValues();
                if (totalProduced == 1) {
                    current.put((UnitType)units.iterator().next(), costPerGroup);
                    continue;
                }
                if (totalProduced <= 1) continue;
                costPerGroup.discount(1.0 / (double)totalProduced);
                for (UnitType ut : units) {
                    current.put(ut, costPerGroup);
                }
            }
            for (UnitType ut : average.keySet()) {
                if (current.keySet().contains(ut)) continue;
                current.put(ut, (ResourceCollection)average.get(ut));
            }
        }
        rVal.put(null, average);
        return rVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<UnitType, ResourceCollection> getResourceCostsForTUVForAllPlayersMergedAndAveraged(GameData data) {
        Resource PUS;
        HashMap<UnitType, ResourceCollection> average = new HashMap<UnitType, ResourceCollection>();
        data.acquireReadLock();
        try {
            PUS = data.getResourceList().getResource("PUs");
        }
        finally {
            data.releaseReadLock();
        }
        IntegerMap<Resource> defaultMap = new IntegerMap<Resource>();
        defaultMap.put(PUS, 1);
        ResourceCollection defaultResources = new ResourceCollection(data, defaultMap);
        HashMap<UnitType, ArrayList<ResourceCollection>> backups = new HashMap<UnitType, ArrayList<ResourceCollection>>();
        HashMap backupAveraged = new HashMap();
        for (ProductionRule productionRule : data.getProductionRuleList().getProductionRules()) {
            if (productionRule == null || productionRule.getResults() == null || productionRule.getResults().isEmpty() || productionRule.getCosts() == null || productionRule.getCosts().isEmpty()) continue;
            IntegerMap<NamedAttachable> unitMap = productionRule.getResults();
            ResourceCollection costPerGroup = new ResourceCollection(data, productionRule.getCosts());
            HashSet<UnitType> units = new HashSet<UnitType>();
            for (NamedAttachable resourceOrUnit : unitMap.keySet()) {
                if (!(resourceOrUnit instanceof UnitType)) continue;
                units.add((UnitType)resourceOrUnit);
            }
            if (units.isEmpty()) continue;
            int totalProduced = unitMap.totalValues();
            if (totalProduced == 1) {
                UnitType ut = (UnitType)units.iterator().next();
                ArrayList<ResourceCollection> current = (ArrayList<ResourceCollection>)backups.get(ut);
                if (current == null) {
                    current = new ArrayList<ResourceCollection>();
                    backups.put(ut, current);
                }
                current.add(costPerGroup);
                continue;
            }
            if (totalProduced <= 1) continue;
            costPerGroup.discount(1.0 / (double)totalProduced);
            for (UnitType ut : units) {
                ArrayList<ResourceCollection> current = (ArrayList<ResourceCollection>)backups.get(ut);
                if (current == null) {
                    current = new ArrayList<ResourceCollection>();
                    backups.put(ut, current);
                }
                current.add(costPerGroup);
            }
        }
        for (Map.Entry entry : backups.entrySet()) {
            ResourceCollection avgCost = new ResourceCollection(((List)entry.getValue()).toArray(new ResourceCollection[((List)entry.getValue()).size()]), data);
            if (((List)entry.getValue()).size() > 1) {
                avgCost.discount(1.0 / (double)((List)entry.getValue()).size());
            }
            backupAveraged.put(entry.getKey(), avgCost);
        }
        Map<PlayerID, Map<UnitType, ResourceCollection>> allPlayersCurrent = BattleCalculator.getResourceCostsForTUV(data, false);
        allPlayersCurrent.remove(null);
        for (UnitType ut : data.getUnitTypeList().getAllUnitTypes()) {
            ArrayList<ResourceCollection> costs = new ArrayList<ResourceCollection>();
            for (Map<UnitType, ResourceCollection> entry : allPlayersCurrent.values()) {
                if (entry.get(ut) == null) continue;
                costs.add(entry.get(ut));
            }
            if (costs.isEmpty()) {
                ResourceCollection backup = (ResourceCollection)backupAveraged.get(ut);
                if (backup != null) {
                    costs.add(backup);
                } else {
                    costs.add(defaultResources);
                }
            }
            ResourceCollection avgCost = new ResourceCollection(costs.toArray(new ResourceCollection[costs.size()]), data);
            if (costs.size() > 1) {
                avgCost.discount(1.0 / (double)costs.size());
            }
            average.put(ut, avgCost);
        }
        return average;
    }

    public static int getTUV(Collection<Unit> units, IntegerMap<UnitType> costs) {
        int tuv = 0;
        for (Unit u : units) {
            int unitValue = costs.getInt(u.getType());
            tuv += unitValue;
        }
        return tuv;
    }

    public static int getTUV(Collection<Unit> units, PlayerID player, IntegerMap<UnitType> costs, GameData data) {
        List<Unit> playerUnits = Match.getMatches(units, Matches.alliedUnit(player, data));
        return BattleCalculator.getTUV(playerUnits, costs);
    }

    private static boolean allTargetsOneTypeOneHitPoint(Collection<Unit> targets, Map<Unit, Collection<Unit>> dependents) {
        UnitCategory unitCategory;
        Set<UnitCategory> categorized = UnitSeperator.categorize(targets, dependents, false, false);
        return categorized.size() == 1 && (unitCategory = categorized.iterator().next()).getHitPoints() - unitCategory.getDamaged() <= 1;
    }

    public static int getRolls(Collection<Unit> units, Territory location, PlayerID id, boolean defend, boolean bombing, Set<List<UnitSupportAttachment>> supportRulesFriendly, IntegerMap<UnitSupportAttachment> supportLeftFriendlyCopy, Set<List<UnitSupportAttachment>> supportRulesEnemy, IntegerMap<UnitSupportAttachment> supportLeftEnemyCopy, Collection<TerritoryEffect> territoryEffects) {
        int count = 0;
        for (Unit unit : units) {
            int unitRoll = BattleCalculator.getRolls(unit, location, id, defend, bombing, supportRulesFriendly, supportLeftFriendlyCopy, supportRulesEnemy, supportLeftEnemyCopy, territoryEffects);
            count += unitRoll;
        }
        return count;
    }

    public static int getRolls(Collection<Unit> units, Territory location, PlayerID id, boolean defend, boolean bombing, Collection<TerritoryEffect> territoryEffects) {
        return BattleCalculator.getRolls(units, location, id, defend, bombing, new HashSet<List<UnitSupportAttachment>>(), new IntegerMap<UnitSupportAttachment>(), new HashSet<List<UnitSupportAttachment>>(), new IntegerMap<UnitSupportAttachment>(), territoryEffects);
    }

    public static int getRolls(Unit unit, Territory location, PlayerID id, boolean defend, boolean bombing, Set<List<UnitSupportAttachment>> supportRulesFriendly, IntegerMap<UnitSupportAttachment> supportLeftFriendlyCopy, Set<List<UnitSupportAttachment>> supportRulesEnemy, IntegerMap<UnitSupportAttachment> supportLeftEnemyCopy, Collection<TerritoryEffect> territoryEffects) {
        UnitAttachment unitAttachment = UnitAttachment.get(unit.getType());
        int rolls = defend ? unitAttachment.getDefenseRolls(id) : unitAttachment.getAttackRolls(id);
        HashMap<UnitSupportAttachment, LinkedIntegerMap<Unit>> dummyEmptyMap = new HashMap<UnitSupportAttachment, LinkedIntegerMap<Unit>>();
        rolls += DiceRoll.getSupport(unit, supportRulesFriendly, supportLeftFriendlyCopy, dummyEmptyMap, null, false, true);
        rolls += DiceRoll.getSupport(unit, supportRulesEnemy, supportLeftEnemyCopy, dummyEmptyMap, null, false, true);
        rolls = Math.max(0, rolls);
        if (bombing) {
            return rolls;
        }
        int strength = defend ? unitAttachment.getDefense(unit.getOwner()) : unitAttachment.getAttack(unit.getOwner());
        strength += DiceRoll.getSupport(unit, supportRulesFriendly, supportLeftFriendlyCopy, dummyEmptyMap, null, true, false);
        strength += DiceRoll.getSupport(unit, supportRulesEnemy, supportLeftEnemyCopy, dummyEmptyMap, null, true, false);
        if ((strength += TerritoryEffectHelper.getTerritoryCombatBonus(unit.getType(), territoryEffects, defend)) <= 0) {
            rolls = 0;
        }
        return rolls;
    }

    public static int getRolls(Unit unit, Territory location, PlayerID id, boolean defend, boolean bombing, Collection<TerritoryEffect> territoryEffects) {
        return BattleCalculator.getRolls(unit, location, id, defend, bombing, new HashSet<List<UnitSupportAttachment>>(), new IntegerMap<UnitSupportAttachment>(), new HashSet<List<UnitSupportAttachment>>(), new IntegerMap<UnitSupportAttachment>(), territoryEffects);
    }

    private static boolean isTransportCasualtiesRestricted(GameData data) {
        return Properties.getTransportCasualtiesRestricted(data);
    }

    private static boolean isRandomAACasualties(GameData data) {
        return Properties.getRandomAACasualties(data);
    }

    private static boolean isRollAAIndividually(GameData data) {
        return Properties.getRollAAIndividually(data);
    }

    private static boolean isChooseAA(GameData data) {
        return Properties.getChoose_AA_Casualties(data);
    }

    private static boolean isPartialAmphibiousRetreat(GameData data) {
        return Properties.getPartialAmphibiousRetreat(data);
    }

    private BattleCalculator() {
    }

    public static int getUnitPowerForSorting(Unit current, boolean defending, GameData data, Collection<TerritoryEffect> territoryEffects) {
        boolean lhtrBombers = Properties.getLHTR_Heavy_Bombers(data);
        UnitAttachment ua = UnitAttachment.get(current.getType());
        int rolls = defending ? ua.getDefenseRolls(current.getOwner()) : ua.getAttackRolls(current.getOwner());
        int strengthWithoutSupport = 0;
        if (rolls > 1 && (lhtrBombers || ua.getChooseBestRoll())) {
            strengthWithoutSupport = defending ? ua.getDefense(current.getOwner()) : ua.getAttack(current.getOwner());
            strengthWithoutSupport += TerritoryEffectHelper.getTerritoryCombatBonus(current.getType(), territoryEffects, defending);
            strengthWithoutSupport = Math.min(Math.max(strengthWithoutSupport + 1, 0), data.getDiceSides());
        } else {
            for (int i = 0; i < rolls; ++i) {
                int tempStrength = defending ? ua.getDefense(current.getOwner()) : ua.getAttack(current.getOwner());
                strengthWithoutSupport += TerritoryEffectHelper.getTerritoryCombatBonus(current.getType(), territoryEffects, defending);
                strengthWithoutSupport += Math.min(Math.max(tempStrength, 0), data.getDiceSides());
            }
        }
        return strengthWithoutSupport;
    }
}

