/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.RelationshipTracker;
import games.strategy.engine.data.RelationshipType;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.net.GUID;
import games.strategy.triplea.Properties;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.attatchments.PlayerAttachment;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.AirBattle;
import games.strategy.triplea.delegate.FinishedBattle;
import games.strategy.triplea.delegate.IBattle;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.MustFightBattle;
import games.strategy.triplea.delegate.NonFightingBattle;
import games.strategy.triplea.delegate.OriginalOwnerTracker;
import games.strategy.triplea.delegate.StrategicBombingRaidBattle;
import games.strategy.triplea.delegate.UndoableMove;
import games.strategy.triplea.delegate.dataObjects.BattleListing;
import games.strategy.triplea.delegate.dataObjects.BattleRecord;
import games.strategy.triplea.delegate.dataObjects.BattleRecords;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.triplea.oddsCalculator.ta.BattleResults;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.CompositeMatchOr;
import games.strategy.util.IntegerMap;
import games.strategy.util.InverseMatch;
import games.strategy.util.Match;
import games.strategy.util.Tuple;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BattleTracker
implements Serializable {
    private static final long serialVersionUID = 8806010984321554662L;
    private final Set<IBattle> m_pendingBattles = new HashSet<IBattle>();
    private final Map<IBattle, HashSet<IBattle>> m_dependencies = new HashMap<IBattle, HashSet<IBattle>>();
    private final Set<Territory> m_conquered = new HashSet<Territory>();
    private final Set<Territory> m_blitzed = new HashSet<Territory>();
    private final Set<Territory> m_foughBattles = new HashSet<Territory>();
    private final Set<Territory> m_bombardedFromTerritories = new HashSet<Territory>();
    private final HashMap<Territory, Map<Territory, Collection<Unit>>> m_finishedBattlesUnitAttackFromMap = new HashMap();
    private final Set<Territory> m_noBombardAllowed = new HashSet<Territory>();
    private final Map<Territory, Collection<Unit>> m_defendingAirThatCanNotLand = new HashMap<Territory, Collection<Unit>>();
    private BattleRecords m_battleRecords = null;
    private final Collection<Tuple<Tuple<PlayerID, PlayerID>, Tuple<RelationshipType, RelationshipType>>> m_relationshipChangesThisTurn = new ArrayList<Tuple<Tuple<PlayerID, PlayerID>, Tuple<RelationshipType, RelationshipType>>>();

    public boolean hasPendingBattle(Territory t, boolean bombing) {
        return this.getPendingBattle(t, bombing, null) != null;
    }

    void addToConquered(Collection<Territory> territories) {
        this.m_conquered.addAll(territories);
    }

    void addToConquered(Territory territory) {
        this.m_conquered.add(territory);
    }

    public boolean wasConquered(Territory t) {
        return this.m_conquered.contains(t);
    }

    public Set<Territory> getConquered() {
        return this.m_conquered;
    }

    public boolean wasBlitzed(Territory t) {
        return this.m_blitzed.contains(t);
    }

    public boolean wasBattleFought(Territory t) {
        return this.m_foughBattles.contains(t);
    }

    public boolean noBombardAllowedFromHere(Territory t) {
        return this.m_noBombardAllowed.contains(t);
    }

    public void addNoBombardAllowedFromHere(Territory t) {
        this.m_noBombardAllowed.add(t);
    }

    public HashMap<Territory, Map<Territory, Collection<Unit>>> getFinishedBattlesUnitAttackFromMap() {
        return this.m_finishedBattlesUnitAttackFromMap;
    }

    public void addRelationshipChangesThisTurn(PlayerID p1, PlayerID p2, RelationshipType oldRelation, RelationshipType newRelation) {
        this.m_relationshipChangesThisTurn.add(new Tuple<Tuple<PlayerID, PlayerID>, Tuple<RelationshipType, RelationshipType>>(new Tuple<PlayerID, PlayerID>(p1, p2), new Tuple<RelationshipType, RelationshipType>(oldRelation, newRelation)));
    }

    public boolean didAllThesePlayersJustGoToWarThisTurn(PlayerID p1, Collection<Unit> enemyUnits, GameData data) {
        HashSet<PlayerID> enemies = new HashSet<PlayerID>();
        for (Unit u : Match.getMatches(enemyUnits, Matches.unitIsEnemyOf(data, p1))) {
            enemies.add(u.getOwner());
        }
        for (PlayerID e : enemies) {
            if (this.didThesePlayersJustGoToWarThisTurn(p1, e)) continue;
            return false;
        }
        return true;
    }

    public boolean didThesePlayersJustGoToWarThisTurn(PlayerID p1, PlayerID p2) {
        for (Tuple<Tuple<PlayerID, PlayerID>, Tuple<RelationshipType, RelationshipType>> t : this.m_relationshipChangesThisTurn) {
            Tuple<PlayerID, PlayerID> players = t.getFirst();
            if (!players.getFirst().equals(p1) ? !players.getSecond().equals(p1) || !players.getFirst().equals(p2) : !players.getSecond().equals(p2)) continue;
            Tuple<RelationshipType, RelationshipType> relations = t.getSecond();
            if (Matches.RelationshipTypeIsAtWar.match(relations.getFirst()) || !Matches.RelationshipTypeIsAtWar.match(relations.getSecond())) continue;
            return true;
        }
        return false;
    }

    void clearFinishedBattles(IDelegateBridge bridge) {
        for (IBattle battle : new ArrayList<IBattle>(this.m_pendingBattles)) {
            if (!FinishedBattle.class.isAssignableFrom(battle.getClass())) continue;
            FinishedBattle finished = (FinishedBattle)battle;
            this.m_finishedBattlesUnitAttackFromMap.put(finished.getTerritory(), finished.getAttackingFromMap());
            finished.fight(bridge);
        }
    }

    public void clearEmptyAirBattleAttacks(IDelegateBridge bridge) {
        for (IBattle battle : new ArrayList<IBattle>(this.m_pendingBattles)) {
            if (!AirBattle.class.isAssignableFrom(battle.getClass())) continue;
            AirBattle airBattle = (AirBattle)battle;
            airBattle.updateDefendingUnits();
            if (!airBattle.getDefendingUnits().isEmpty()) continue;
            airBattle.finishBattleAndRemoveFromTrackerHeadless(bridge);
        }
    }

    public void undoBattle(Route route, Collection<Unit> units, PlayerID player, IDelegateBridge bridge) {
        for (IBattle battle : new ArrayList<IBattle>(this.m_pendingBattles)) {
            if (!battle.getTerritory().equals(route.getEnd())) continue;
            battle.removeAttack(route, units);
            if (!battle.isEmpty()) continue;
            this.removeBattleForUndo(player, battle);
        }
        RelationshipTracker relationshipTracker = bridge.getData().getRelationshipTracker();
        for (Territory current : route.getAllTerritories()) {
            if (relationshipTracker.isAllied(current.getOwner(), player) || !this.m_conquered.contains(current)) continue;
            this.m_conquered.remove(current);
            this.m_blitzed.remove(current);
        }
        CompositeChange change = new CompositeChange();
        Iterator<Unit> attackIter = units.iterator();
        while (attackIter.hasNext()) {
            change.add(ChangeFactory.unitPropertyChange(attackIter.next(), false, "wasInCombat"));
        }
        bridge.addChange(change);
    }

    private void removeBattleForUndo(PlayerID player, IBattle battle) {
        if (this.m_battleRecords != null) {
            this.m_battleRecords.removeBattle(player, battle.getBattleID());
        }
        this.m_pendingBattles.remove(battle);
        this.m_dependencies.remove(battle);
        for (Collection collection : this.m_dependencies.values()) {
            collection.remove(battle);
        }
    }

    public void addBattle(Route route, Collection<Unit> units, boolean bombing, PlayerID id, IDelegateBridge bridge, UndoableMove changeTracker, Collection<Unit> unitsNotUnloadedTilEndOfRoute) {
        this.addBattle(route, units, bombing, id, bridge, changeTracker, unitsNotUnloadedTilEndOfRoute, null, false);
    }

    public void addBattle(Route route, Collection<Unit> units, boolean bombing, PlayerID id, IDelegateBridge bridge, UndoableMove changeTracker, Collection<Unit> unitsNotUnloadedTilEndOfRoute, HashMap<Unit, HashSet<Unit>> targets, boolean airBattleCompleted) {
        GameData data = bridge.getData();
        if (bombing) {
            if (!airBattleCompleted && Properties.getRaidsMayBePreceededByAirBattles(data) && AirBattle.territoryCouldPossiblyHaveAirBattleDefenders(route.getEnd(), id, data, bombing)) {
                this.addAirBattle(route, units, id, data, true);
            } else {
                this.addBombingBattle(route, units, id, data, targets);
            }
            this.markWasInCombat(units, bridge, changeTracker);
        } else {
            if (!airBattleCompleted && Properties.getBattlesMayBePreceededByAirBattles(data) && AirBattle.territoryCouldPossiblyHaveAirBattleDefenders(route.getEnd(), id, data, bombing)) {
                this.addAirBattle(route, Match.getMatches(units, AirBattle.attackingGroundSeaBattleEscorts(id, data)), id, data, false);
            }
            Change change = this.addMustFightBattleChange(route, units, id, data);
            bridge.addChange(change);
            if (changeTracker != null) {
                changeTracker.addChange(change);
            }
            if (Match.someMatch(units, Matches.UnitIsLand) || Match.someMatch(units, Matches.UnitIsSea)) {
                this.addEmptyBattle(route, units, id, bridge, changeTracker, unitsNotUnloadedTilEndOfRoute);
            }
        }
    }

    private void markWasInCombat(Collection<Unit> units, IDelegateBridge bridge, UndoableMove changeTracker) {
        if (units == null) {
            return;
        }
        CompositeChange change = new CompositeChange();
        Iterator<Unit> attackIter = units.iterator();
        while (attackIter.hasNext()) {
            change.add(ChangeFactory.unitPropertyChange(attackIter.next(), true, "wasInCombat"));
        }
        bridge.addChange(change);
        if (changeTracker != null) {
            changeTracker.addChange(change);
        }
    }

    private void addBombingBattle(Route route, Collection<Unit> units, PlayerID attacker, GameData data, HashMap<Unit, HashSet<Unit>> targets) {
        IBattle dependentAirBattle;
        Change change;
        IBattle battle = this.getPendingBattle(route.getEnd(), true, IBattle.BattleType.BOMBING_RAID);
        if (battle == null) {
            battle = new StrategicBombingRaidBattle(route.getEnd(), data, attacker, this);
            this.m_pendingBattles.add(battle);
            this.getBattleRecords(data).addBattle(attacker, battle.getBattleID(), route.getEnd(), battle.getBattleType(), data);
        }
        if (!(change = battle.addAttackChange(route, units, targets)).isEmpty()) {
            throw new IllegalStateException("Non empty change");
        }
        IBattle dependent = this.getPendingBattle(route.getEnd(), false, IBattle.BattleType.NORMAL);
        if (dependent != null) {
            this.addDependency(dependent, battle);
        }
        if ((dependentAirBattle = this.getPendingBattle(route.getEnd(), false, IBattle.BattleType.AIR_BATTLE)) != null) {
            this.addDependency(dependentAirBattle, battle);
        }
    }

    private void addAirBattle(Route route, Collection<Unit> units, PlayerID attacker, GameData data, boolean bombingRun) {
        Change change;
        if (units.isEmpty()) {
            return;
        }
        IBattle battle = this.getPendingBattle(route.getEnd(), bombingRun, bombingRun ? IBattle.BattleType.AIR_RAID : IBattle.BattleType.AIR_BATTLE);
        if (battle == null) {
            battle = new AirBattle(route.getEnd(), bombingRun, data, attacker, this);
            this.m_pendingBattles.add(battle);
            this.getBattleRecords(data).addBattle(attacker, battle.getBattleID(), route.getEnd(), battle.getBattleType(), data);
        }
        if (!(change = battle.addAttackChange(route, units, null)).isEmpty()) {
            throw new IllegalStateException("Non empty change");
        }
        if (bombingRun) {
            IBattle dependentAirBattle = this.getPendingBattle(route.getEnd(), false, IBattle.BattleType.AIR_BATTLE);
            if (dependentAirBattle != null) {
                this.addDependency(dependentAirBattle, battle);
            }
        } else {
            IBattle raid;
            IBattle airRaid = this.getPendingBattle(route.getEnd(), true, IBattle.BattleType.AIR_RAID);
            if (airRaid != null) {
                this.addDependency(battle, airRaid);
            }
            if ((raid = this.getPendingBattle(route.getEnd(), true, IBattle.BattleType.BOMBING_RAID)) != null) {
                this.addDependency(battle, raid);
            }
        }
        IBattle dependent = this.getPendingBattle(route.getEnd(), false, IBattle.BattleType.NORMAL);
        if (dependent != null) {
            this.addDependency(dependent, battle);
        }
    }

    private void addEmptyBattle(Route route, Collection<Unit> units, PlayerID id, IDelegateBridge bridge, UndoableMove changeTracker, Collection<Unit> unitsNotUnloadedTilEndOfRoute) {
        GameData data = bridge.getData();
        List<Unit> canConquer = Match.getMatches(units, Matches.unitIsBeingTransportedByOrIsDependentOfSomeUnitInThisList(units, route, id, data, false).invert());
        if (Match.noneMatch(canConquer, Matches.UnitIsNotAir)) {
            return;
        }
        ArrayList<Unit> presentFromStartTilEnd = new ArrayList<Unit>(canConquer);
        if (unitsNotUnloadedTilEndOfRoute != null) {
            presentFromStartTilEnd.removeAll(unitsNotUnloadedTilEndOfRoute);
        }
        boolean canConquerMiddleSteps = Match.someMatch(presentFromStartTilEnd, Matches.UnitIsNotAir);
        boolean scramblingEnabled = Properties.getScramble_Rules_In_Effect(data);
        CompositeMatchAnd<Territory> conquerable = new CompositeMatchAnd<Territory>(new Match[0]);
        conquerable.add(Matches.territoryIsEmptyOfCombatUnits(data, id));
        conquerable.add(new CompositeMatchOr(Matches.territoryIsOwnedByPlayerWhosRelationshipTypeCanTakeOverOwnedTerritoryAndPassableAndNotWater(id), Matches.isTerritoryEnemyAndNotUnownedWaterOrImpassibleOrRestricted(id, data)));
        ArrayList<Territory> conquered = new ArrayList<Territory>();
        if (canConquerMiddleSteps) {
            conquered.addAll(route.getMatches(conquerable));
            if (route.getStart() != route.getEnd() && ((Match)conquerable).match(route.getStart())) {
                conquered.add(route.getStart());
            }
        }
        conquered.remove(route.getEnd());
        List<Territory> blitzed = Match.getMatches(conquered, Matches.TerritoryIsBlitzable(id, data));
        this.m_blitzed.addAll(Match.getMatches(blitzed, Matches.isTerritoryEnemy(id, data)));
        this.m_conquered.addAll(Match.getMatches(conquered, Matches.isTerritoryEnemy(id, data)));
        for (Territory current : conquered) {
            IBattle nonFight = this.getPendingBattle(current, false, IBattle.BattleType.NORMAL);
            if (nonFight == null) {
                nonFight = new FinishedBattle(current, id, this, false, IBattle.BattleType.NORMAL, data, BattleRecord.BattleResultDescription.CONQUERED, IBattle.WhoWon.ATTACKER, units);
                this.m_pendingBattles.add(nonFight);
                this.getBattleRecords(data).addBattle(id, nonFight.getBattleID(), current, nonFight.getBattleType(), data);
            }
            Change change = nonFight.addAttackChange(route, units, null);
            bridge.addChange(change);
            if (changeTracker != null) {
                changeTracker.addChange(change);
            }
            this.takeOver(current, id, bridge, changeTracker, units);
        }
        if (((Match)conquerable).match(route.getEnd())) {
            Change change;
            IBattle nonFight;
            IBattle precede = this.getDependentAmphibiousAssault(route);
            if (precede == null) {
                precede = this.getPendingBattle(route.getEnd(), true, null);
            }
            if (precede != null || scramblingEnabled && route.isUnload() && route.hasExactlyOneStep()) {
                nonFight = this.getPendingBattle(route.getEnd(), false, IBattle.BattleType.NORMAL);
                if (nonFight == null) {
                    nonFight = new NonFightingBattle(route.getEnd(), id, this, data);
                    this.m_pendingBattles.add(nonFight);
                    this.getBattleRecords(data).addBattle(id, nonFight.getBattleID(), route.getEnd(), nonFight.getBattleType(), data);
                }
                change = nonFight.addAttackChange(route, units, null);
                bridge.addChange(change);
                if (changeTracker != null) {
                    changeTracker.addChange(change);
                }
                if (precede != null) {
                    this.addDependency(nonFight, precede);
                }
            } else {
                if (Matches.isTerritoryEnemy(id, data).match(route.getEnd())) {
                    if (Matches.TerritoryIsBlitzable(id, data).match(route.getEnd())) {
                        this.m_blitzed.add(route.getEnd());
                    }
                    this.m_conquered.add(route.getEnd());
                }
                if ((nonFight = this.getPendingBattle(route.getEnd(), false, IBattle.BattleType.NORMAL)) == null) {
                    nonFight = new FinishedBattle(route.getEnd(), id, this, false, IBattle.BattleType.NORMAL, data, BattleRecord.BattleResultDescription.CONQUERED, IBattle.WhoWon.ATTACKER, units);
                    this.m_pendingBattles.add(nonFight);
                    this.getBattleRecords(data).addBattle(id, nonFight.getBattleID(), route.getEnd(), nonFight.getBattleType(), data);
                }
                change = nonFight.addAttackChange(route, units, null);
                bridge.addChange(change);
                if (changeTracker != null) {
                    changeTracker.addChange(change);
                }
                this.takeOver(route.getEnd(), id, bridge, changeTracker, units);
            }
        }
    }

    public void takeOver(Territory territory, PlayerID id, IDelegateBridge bridge, UndoableMove changeTracker, Collection<Unit> arrivingUnits) {
        IBattle bombingBattle;
        TerritoryAttachment ta = TerritoryAttachment.get(territory);
        if (ta == null) {
            return;
        }
        GameData data = bridge.getData();
        ArrayList<Unit> arrivedUnits = arrivingUnits == null ? null : new ArrayList<Unit>(arrivingUnits);
        RelationshipTracker relationshipTracker = data.getRelationshipTracker();
        boolean isTerritoryOwnerAnEnemy = relationshipTracker.canTakeOverOwnedTerritory(id, territory.getOwner());
        if (territory.isWater() && arrivedUnits != null) {
            int totalMatches = 0;
            totalMatches = arrivedUnits.size() - Match.countMatches(arrivedUnits, Matches.UnitIsLand) - Match.countMatches(arrivedUnits, Matches.UnitIsAir) - Match.countMatches(arrivedUnits, Matches.unitIsSubmerged(data));
            CompositeMatchAnd<Unit> transportsCanNotControl = new CompositeMatchAnd<Unit>(new Match[0]);
            transportsCanNotControl.add(Matches.UnitIsTransportAndNotDestroyer);
            transportsCanNotControl.add(Matches.UnitIsTransportButNotCombatTransport);
            if (!Properties.getTransportControlSeaZone(data)) {
                totalMatches -= Match.countMatches(arrivedUnits, transportsCanNotControl);
            }
            if (Properties.getSubControlSeaZoneRestricted(data)) {
                totalMatches -= Match.countMatches(arrivedUnits, Matches.UnitIsSub);
            }
            if (totalMatches == 0) {
                return;
            }
        }
        if (ta != null && ta.getConvoyRoute()) {
            Set<Territory> attachedConvoyTo = TerritoryAttachment.getWhatTerritoriesThisIsUsedInConvoysFor(territory, data);
            for (Territory convoy : attachedConvoyTo) {
                TerritoryAttachment cta = TerritoryAttachment.get(convoy);
                if (!cta.getConvoyRoute()) continue;
                PlayerID convoyOwner = convoy.getOwner();
                if (relationshipTracker.isAllied(id, convoyOwner)) {
                    if (Match.getMatches(cta.getConvoyAttached(), Matches.isTerritoryAllied(convoyOwner, data)).size() > 0) continue;
                    bridge.getHistoryWriter().addChildToEvent(convoyOwner.getName() + " gains " + cta.getProduction() + " production in " + convoy.getName() + " for the liberation the convoy route in " + territory.getName());
                    continue;
                }
                if (!relationshipTracker.isAtWar(id, convoyOwner) || Match.getMatches(cta.getConvoyAttached(), Matches.isTerritoryAllied(convoyOwner, data)).size() != 1) continue;
                bridge.getHistoryWriter().addChildToEvent(convoyOwner.getName() + " loses " + cta.getProduction() + " production in " + convoy.getName() + " due to the capture of the convoy route in " + territory.getName());
            }
        }
        if (territory.getOwner().isNull() && !territory.isWater() && Properties.getNeutralCharge(data) >= 0) {
            Resource PUs = data.getResourceList().getResource("PUs");
            int PUChargeIdeal = -Properties.getNeutralCharge(data);
            int PUChargeReal = Math.min(0, Math.max(PUChargeIdeal, -id.getResources().getQuantity(PUs)));
            Change neutralFee = ChangeFactory.changeResourcesChange(id, PUs, PUChargeReal);
            bridge.addChange(neutralFee);
            if (changeTracker != null) {
                changeTracker.addChange(neutralFee);
            }
            if (PUChargeIdeal == PUChargeReal) {
                bridge.getHistoryWriter().addChildToEvent(id.getName() + " loses " + -PUChargeReal + " " + MyFormatter.pluralize("PU", -PUChargeReal) + " for violating " + territory.getName() + "s neutrality.");
            } else {
                System.out.println("Player, " + id.getName() + " attacks a Neutral territory, and should have had to pay " + PUChargeIdeal + ", but did not have enough PUs to pay! This is a bug.");
                bridge.getHistoryWriter().addChildToEvent(id.getName() + " loses " + -PUChargeReal + " " + MyFormatter.pluralize("PU", -PUChargeReal) + " for violating " + territory.getName() + "s neutrality.  Correct amount to charge is: " + PUChargeIdeal + ".  Player should not have been able to make this attack!");
            }
        }
        if (ta != null && isTerritoryOwnerAnEnemy && ta.getCapital() != null) {
            PlayerID whoseCapital = data.getPlayerList().getPlayerID(ta.getCapital());
            PlayerAttachment pa = PlayerAttachment.get(id);
            PlayerAttachment paWhoseCapital = PlayerAttachment.get(whoseCapital);
            ArrayList<Territory> capitalsList = new ArrayList<Territory>(TerritoryAttachment.getAllCurrentlyOwnedCapitals(whoseCapital, data));
            if (paWhoseCapital != null && paWhoseCapital.getRetainCapitalNumber() < capitalsList.size()) {
                bridge.getHistoryWriter().addChildToEvent(id.getName() + " captures one of " + whoseCapital.getName() + " capitals");
            } else if (whoseCapital.equals(territory.getOwner())) {
                Resource tokens;
                Resource PUs = data.getResourceList().getResource("PUs");
                int capturedPUCount = whoseCapital.getResources().getQuantity(PUs);
                if (pa != null && this.isPacificTheater(data)) {
                    Change changeVP = ChangeFactory.attachmentPropertyChange(pa, capturedPUCount + pa.getCaptureVps(), "captureVps");
                    bridge.addChange(changeVP);
                    if (changeTracker != null) {
                        changeTracker.addChange(changeVP);
                    }
                }
                Change remove = ChangeFactory.changeResourcesChange(whoseCapital, PUs, -capturedPUCount);
                bridge.addChange(remove);
                if (paWhoseCapital != null && paWhoseCapital.getDestroysPUs()) {
                    bridge.getHistoryWriter().addChildToEvent(id.getName() + " destroys " + capturedPUCount + MyFormatter.pluralize("PU", capturedPUCount) + " while taking " + whoseCapital.getName() + " capital");
                    if (changeTracker != null) {
                        changeTracker.addChange(remove);
                    }
                } else {
                    bridge.getHistoryWriter().addChildToEvent(id.getName() + " captures " + capturedPUCount + MyFormatter.pluralize("PU", capturedPUCount) + " while taking " + whoseCapital.getName() + " capital");
                    if (changeTracker != null) {
                        changeTracker.addChange(remove);
                    }
                    Change add = ChangeFactory.changeResourcesChange(id, PUs, capturedPUCount);
                    bridge.addChange(add);
                    if (changeTracker != null) {
                        changeTracker.addChange(add);
                    }
                }
                if ((tokens = data.getResourceList().getResource("techTokens")) != null) {
                    int m_currTokens = whoseCapital.getResources().getQuantity("techTokens");
                    Change removeTokens = ChangeFactory.changeResourcesChange(whoseCapital, tokens, -m_currTokens);
                    bridge.addChange(removeTokens);
                    if (changeTracker != null) {
                        changeTracker.addChange(removeTokens);
                    }
                }
            }
        }
        PlayerID terrOrigOwner = OriginalOwnerTracker.getOriginalOwner(territory);
        PlayerID newOwner = id;
        if (isTerritoryOwnerAnEnemy && terrOrigOwner != null && relationshipTracker.isAllied(terrOrigOwner, id) && !terrOrigOwner.equals(territory.getOwner())) {
            ArrayList<Territory> capitalsListOwned = new ArrayList<Territory>(TerritoryAttachment.getAllCurrentlyOwnedCapitals(terrOrigOwner, data));
            if (!capitalsListOwned.isEmpty()) {
                newOwner = terrOrigOwner;
            } else {
                newOwner = id;
                ArrayList<Territory> capitalsListOriginal = new ArrayList<Territory>(TerritoryAttachment.getAllCapitals(terrOrigOwner, data));
                for (Territory current : capitalsListOriginal) {
                    if (!territory.equals(current) && !current.getOwner().equals(PlayerID.NULL_PLAYERID)) continue;
                    newOwner = terrOrigOwner;
                }
            }
        }
        if (ta != null && isTerritoryOwnerAnEnemy && newOwner.equals(id) && Matches.TerritoryHasWhenCapturedByGoesTo().match(territory)) {
            for (String value : ta.getWhenCapturedByGoesTo()) {
                PlayerID goesToPlayer;
                String[] s = value.split(":");
                PlayerID capturingPlayer = data.getPlayerList().getPlayerID(s[0]);
                if (capturingPlayer.equals(goesToPlayer = data.getPlayerList().getPlayerID(s[1])) || !capturingPlayer.equals(id)) continue;
                newOwner = goesToPlayer;
                break;
            }
        }
        if (isTerritoryOwnerAnEnemy && ta != null) {
            Change takeOver = ChangeFactory.changeOwner(territory, newOwner);
            bridge.getHistoryWriter().addChildToEvent(takeOver.toString());
            bridge.addChange(takeOver);
            if (changeTracker != null) {
                changeTracker.addChange(takeOver);
                changeTracker.addToConquered(territory);
            }
            if (territory.isWater()) {
                bridge.getSoundChannelBroadcaster().playSoundForAll("territory_capture_sea", id.getName());
            } else if (ta != null && ta.getCapital() != null) {
                bridge.getSoundChannelBroadcaster().playSoundForAll("territory_capture_capital", id.getName());
            } else if (this.m_blitzed.contains(territory) && Match.someMatch(arrivedUnits, Matches.UnitCanBlitz)) {
                bridge.getSoundChannelBroadcaster().playSoundForAll("territory_capture_blitz", id.getName());
            } else {
                bridge.getSoundChannelBroadcaster().playSoundForAll("territory_capture_land", id.getName());
            }
        }
        if (Match.someMatch(territory.getUnits().getUnits(), new CompositeMatchAnd(Matches.unitIsEnemyOf(data, id), Matches.UnitCanBeDamaged)) && (bombingBattle = this.getPendingBattle(territory, true, null)) != null) {
            BattleResults results = new BattleResults(bombingBattle, IBattle.WhoWon.DRAW, data);
            this.getBattleRecords(data).addResultToBattle(id, bombingBattle.getBattleID(), null, 0, 0, BattleRecord.BattleResultDescription.NO_BATTLE, results, 0);
            bombingBattle.cancelBattle(bridge);
            this.removeBattle(bombingBattle);
            throw new IllegalStateException("Bombing Raids should be dealt with first! Be sure the battle has dependencies set correctly!");
        }
        BattleTracker.captureOrDestroyUnits(territory, id, newOwner, bridge, changeTracker, arrivedUnits);
        if (isTerritoryOwnerAnEnemy && terrOrigOwner != null && ta != null && ta.getCapital() != null && TerritoryAttachment.getAllCapitals(terrOrigOwner, data).contains(territory) && relationshipTracker.isAllied(terrOrigOwner, id)) {
            Collection<Territory> originallyOwned = OriginalOwnerTracker.getOriginallyOwned(data, terrOrigOwner);
            List<Territory> friendlyTerritories = Match.getMatches(originallyOwned, Matches.isTerritoryAllied(terrOrigOwner, data));
            for (Territory item : friendlyTerritories) {
                List<Unit> units;
                if (item.getOwner() == terrOrigOwner) continue;
                Change takeOverFriendlyTerritories = ChangeFactory.changeOwner(item, terrOrigOwner);
                bridge.addChange(takeOverFriendlyTerritories);
                bridge.getHistoryWriter().addChildToEvent(takeOverFriendlyTerritories.toString());
                if (changeTracker != null) {
                    changeTracker.addChange(takeOverFriendlyTerritories);
                }
                if ((units = Match.getMatches(item.getUnits().getUnits(), Matches.UnitIsInfrastructure)).isEmpty()) continue;
                Change takeOverNonComUnits = ChangeFactory.changeOwner(units, terrOrigOwner, territory);
                bridge.addChange(takeOverNonComUnits);
                if (changeTracker == null) continue;
                changeTracker.addChange(takeOverNonComUnits);
            }
        }
        if (Matches.TerritoryIsWater.match(territory) && arrivedUnits != null) {
            arrivedUnits.removeAll(Match.getMatches(arrivedUnits, Matches.UnitIsLand));
        }
        this.markWasInCombat(arrivedUnits, bridge, changeTracker);
    }

    public static void captureOrDestroyUnits(Territory territory, PlayerID id, PlayerID newOwner, IDelegateBridge bridge, UndoableMove changeTracker, Collection<Unit> arrivingUnits) {
        List<Unit> destroyed;
        Change destroyUnits;
        List<Unit> destroyed2;
        CompositeMatchAnd<Unit> enemyToBeDestroyed;
        GameData data = bridge.getData();
        if (Properties.getUnitsCanBeDestroyedInsteadOfCaptured(data)) {
            enemyToBeDestroyed = new CompositeMatchAnd<Unit>(Matches.enemyUnit(id, data), Matches.UnitDestroyedWhenCapturedByOrFrom(id));
            destroyed2 = territory.getUnits().getMatches(enemyToBeDestroyed);
            if (!destroyed2.isEmpty()) {
                destroyUnits = ChangeFactory.removeUnits(territory, destroyed2);
                bridge.getHistoryWriter().addChildToEvent("Some non-combat units are destroyed: ", destroyed2);
                bridge.addChange(destroyUnits);
                if (changeTracker != null) {
                    changeTracker.addChange(destroyUnits);
                }
            }
        }
        if (Properties.getOnEnteringUnitsDestroyedInsteadOfCaptured(data) && !(destroyed = territory.getUnits().getMatches(Matches.UnitCanBeCapturedOnEnteringToInThisTerritory(id, territory, data))).isEmpty()) {
            Change destroyUnits2 = ChangeFactory.removeUnits(territory, destroyed);
            bridge.getHistoryWriter().addChildToEvent(id.getName() + " destroys some units instead of capturing them", destroyed);
            bridge.addChange(destroyUnits2);
            if (changeTracker != null) {
                changeTracker.addChange(destroyUnits2);
            }
        }
        enemyToBeDestroyed = new CompositeMatchAnd(Matches.enemyUnit(id, data), Matches.UnitIsDisabled, Matches.UnitIsInfrastructure.invert());
        destroyed2 = territory.getUnits().getMatches(enemyToBeDestroyed);
        if (!destroyed2.isEmpty()) {
            destroyUnits = ChangeFactory.removeUnits(territory, destroyed2);
            bridge.getHistoryWriter().addChildToEvent(id.getName() + " destroys some disabled combat units", destroyed2);
            bridge.addChange(destroyUnits);
            if (changeTracker != null) {
                changeTracker.addChange(destroyUnits);
            }
        }
        CompositeMatchAnd enemyNonCom = new CompositeMatchAnd(Matches.enemyUnit(id, data), Matches.UnitIsInfrastructure);
        CompositeMatchOr<Unit> willBeCaptured = new CompositeMatchOr<Unit>(enemyNonCom, Matches.UnitCanBeCapturedOnEnteringToInThisTerritory(id, territory, data));
        List<Unit> nonCom = territory.getUnits().getMatches(willBeCaptured);
        if (Properties.getUnitsCanBeChangedOnCapture(data)) {
            List<Unit> toReplace = Match.getMatches(nonCom, Matches.UnitWhenCapturedChangesIntoDifferentUnitType());
            block0: for (Unit u : toReplace) {
                LinkedHashMap<String, Tuple<String, IntegerMap<UnitType>>> map = UnitAttachment.get(u.getType()).getWhenCapturedChangesInto();
                PlayerID currentOwner = u.getOwner();
                for (String value : map.keySet()) {
                    Change translate;
                    String[] s = value.split(":");
                    if (!s[0].equals("any") && !data.getPlayerList().getPlayerID(s[0]).equals(currentOwner) || !s[1].equals("any") && !data.getPlayerList().getPlayerID(s[1]).equals(id)) continue;
                    CompositeChange changes = new CompositeChange();
                    ArrayList<Unit> toAdd = new ArrayList<Unit>();
                    Tuple<String, IntegerMap<UnitType>> toCreate = map.get(value);
                    boolean translateAttributes = toCreate.getFirst().equalsIgnoreCase("true");
                    for (UnitType ut : toCreate.getSecond().keySet()) {
                        toAdd.addAll(ut.create(toCreate.getSecond().getInt(ut), newOwner));
                    }
                    if (toAdd.isEmpty()) continue;
                    if (translateAttributes && !(translate = TripleAUnit.translateAttributesToOtherUnits(u, toAdd, territory)).isEmpty()) {
                        changes.add(translate);
                    }
                    changes.add(ChangeFactory.removeUnits(territory, Collections.singleton(u)));
                    changes.add(ChangeFactory.addUnits(territory, toAdd));
                    changes.add(ChangeFactory.markNoMovementChange(toAdd));
                    bridge.getHistoryWriter().addChildToEvent(id.getName() + " converts " + u.toStringNoOwner() + " into different units", toAdd);
                    bridge.addChange(changes);
                    if (changeTracker != null) {
                        changeTracker.addChange(changes);
                    }
                    nonCom.remove(u);
                    continue block0;
                }
            }
        }
        if (!nonCom.isEmpty()) {
            Change capture = ChangeFactory.changeOwner(nonCom, newOwner, territory);
            bridge.addChange(capture);
            if (changeTracker != null) {
                changeTracker.addChange(capture);
            }
            Change noMovementChange = ChangeFactory.markNoMovementChange(nonCom);
            bridge.addChange(noMovementChange);
            if (changeTracker != null) {
                changeTracker.addChange(noMovementChange);
            }
        }
    }

    private Change addMustFightBattleChange(Route route, Collection<Unit> units, PlayerID id, GameData data) {
        IBattle airBattle;
        IBattle bombing;
        Territory site = route.getEnd();
        if (site == null) {
            site = route.getStart();
        }
        if (!Matches.territoryHasEnemyUnits(id, data).match(site)) {
            return ChangeFactory.EMPTY_CHANGE;
        }
        List<Unit> enemyUnits = Match.getMatches(site.getUnits().getUnits(), Matches.enemyUnit(id, data));
        if (route.getEnd() != null && Match.allMatch(enemyUnits, Matches.UnitIsInfrastructure)) {
            return ChangeFactory.EMPTY_CHANGE;
        }
        IBattle battle = this.getPendingBattle(site, false, IBattle.BattleType.NORMAL);
        if (battle == null) {
            battle = new MustFightBattle(site, id, data, this);
            this.m_pendingBattles.add(battle);
            this.getBattleRecords(data).addBattle(id, battle.getBattleID(), site, battle.getBattleType(), data);
        }
        Change change = battle.addAttackChange(route, units, null);
        IBattle precede = this.getDependentAmphibiousAssault(route);
        if (precede != null && Match.someMatch(units, Matches.UnitIsLand)) {
            this.addDependency(battle, precede);
        }
        if ((bombing = this.getPendingBattle(route.getEnd(), true, null)) != null) {
            this.addDependency(battle, bombing);
        }
        if ((airBattle = this.getPendingBattle(route.getEnd(), false, IBattle.BattleType.AIR_BATTLE)) != null) {
            this.addDependency(battle, airBattle);
        }
        return change;
    }

    private IBattle getDependentAmphibiousAssault(Route route) {
        if (!route.isUnload()) {
            return null;
        }
        return this.getPendingBattle(route.getStart(), false, IBattle.BattleType.NORMAL);
    }

    public IBattle getPendingBattle(Territory t, boolean bombing, IBattle.BattleType type) {
        for (IBattle battle : this.m_pendingBattles) {
            if (!battle.getTerritory().equals(t) || battle.isBombingRun() != bombing || type != null && !type.equals((Object)battle.getBattleType())) continue;
            return battle;
        }
        return null;
    }

    public Collection<IBattle> getPendingBattles(Territory t, Boolean bombing, IBattle.BattleType type) {
        HashSet<IBattle> battles = new HashSet<IBattle>();
        for (IBattle battle : this.m_pendingBattles) {
            if (!battle.getTerritory().equals(t) || bombing != null && battle.isBombingRun() != bombing.booleanValue() || type != null && !type.equals((Object)battle.getBattleType())) continue;
            battles.add(battle);
        }
        return battles;
    }

    public IBattle getPendingBattle(GUID guid) {
        if (guid == null) {
            return null;
        }
        for (IBattle battle : this.m_pendingBattles) {
            if (!guid.equals(battle.getBattleID())) continue;
            return battle;
        }
        return null;
    }

    public Collection<Territory> getPendingBattleSites(boolean bombing) {
        HashSet<IBattle> pending = new HashSet<IBattle>(this.m_pendingBattles);
        ArrayList<Territory> battles = new ArrayList<Territory>();
        for (IBattle battle : pending) {
            if (battle == null || battle.isEmpty() || battle.isBombingRun() != bombing) continue;
            battles.add(battle.getTerritory());
        }
        return battles;
    }

    public BattleListing getPendingBattleSites() {
        HashMap<IBattle.BattleType, Collection<Territory>> battles = new HashMap<IBattle.BattleType, Collection<Territory>>();
        HashSet<IBattle> pending = new HashSet<IBattle>(this.m_pendingBattles);
        for (IBattle battle : pending) {
            if (battle == null || battle.isEmpty()) continue;
            HashSet<Territory> territories = (HashSet<Territory>)battles.get((Object)battle.getBattleType());
            if (territories == null) {
                territories = new HashSet<Territory>();
            }
            territories.add(battle.getTerritory());
            battles.put(battle.getBattleType(), territories);
        }
        return new BattleListing(battles);
    }

    public Collection<IBattle> getDependentOn(IBattle blocked) {
        Collection dependent = this.m_dependencies.get(blocked);
        if (dependent == null) {
            return Collections.emptyList();
        }
        return Match.getMatches(dependent, new InverseMatch<IBattle>(Matches.BattleIsEmpty));
    }

    public Collection<IBattle> getBlocked(IBattle blocking) {
        Iterator<IBattle> iter = this.m_dependencies.keySet().iterator();
        ArrayList<IBattle> allBlocked = new ArrayList<IBattle>();
        while (iter.hasNext()) {
            IBattle current = iter.next();
            Collection<IBattle> currentBlockedBy = this.getDependentOn(current);
            if (!currentBlockedBy.contains(blocking)) continue;
            allBlocked.add(current);
        }
        return allBlocked;
    }

    public void addDependency(IBattle blocked, IBattle blocking) {
        if (this.m_dependencies.get(blocked) == null) {
            this.m_dependencies.put(blocked, new HashSet());
        }
        this.m_dependencies.get(blocked).add(blocking);
    }

    private void removeDependency(IBattle blocked, IBattle blocking) {
        Collection dependencies = this.m_dependencies.get(blocked);
        dependencies.remove(blocking);
        if (dependencies.isEmpty()) {
            this.m_dependencies.remove(blocked);
        }
    }

    public void removeBattle(IBattle battle) {
        if (battle != null) {
            for (IBattle current : this.getBlocked(battle)) {
                this.removeDependency(current, battle);
            }
            this.m_pendingBattles.remove(battle);
            this.m_foughBattles.add(battle.getTerritory());
        }
    }

    public void addPreviouslyNavalBombardmentSource(Collection<Territory> territories) {
        this.m_bombardedFromTerritories.addAll(territories);
    }

    public boolean wasNavalBombardmentSource(Territory territory) {
        return this.m_bombardedFromTerritories.contains(territory);
    }

    private boolean isPacificTheater(GameData data) {
        return data.getProperties().get("Pacific Theater", false);
    }

    public void clear() {
        this.m_finishedBattlesUnitAttackFromMap.clear();
        this.m_bombardedFromTerritories.clear();
        this.m_pendingBattles.clear();
        this.m_blitzed.clear();
        this.m_foughBattles.clear();
        this.m_conquered.clear();
        this.m_dependencies.clear();
        this.m_defendingAirThatCanNotLand.clear();
        this.m_noBombardAllowed.clear();
        this.m_relationshipChangesThisTurn.clear();
    }

    public void addToDefendingAirThatCanNotLand(Collection<Unit> units, Territory szTerritoryTheyAreIn) {
        Collection<Unit> current = this.m_defendingAirThatCanNotLand.get(szTerritoryTheyAreIn);
        if (current == null) {
            current = new ArrayList<Unit>();
        }
        current.addAll(units);
        this.m_defendingAirThatCanNotLand.put(szTerritoryTheyAreIn, current);
    }

    public Map<Territory, Collection<Unit>> getDefendingAirThatCanNotLand() {
        return this.m_defendingAirThatCanNotLand;
    }

    public void clearBattleRecords() {
        if (this.m_battleRecords != null) {
            this.m_battleRecords.clear();
            this.m_battleRecords = null;
        }
    }

    public BattleRecords getBattleRecords(GameData data) {
        if (this.m_battleRecords == null) {
            this.m_battleRecords = new BattleRecords(data);
        }
        return this.m_battleRecords;
    }

    public void sendBattleRecordsToGameData(IDelegateBridge aBridge) {
        if (this.m_battleRecords != null && !this.m_battleRecords.isEmpty()) {
            aBridge.getHistoryWriter().startEvent("Recording Battle Statistics");
            aBridge.addChange(ChangeFactory.addBattleRecords(this.m_battleRecords, aBridge.getData()));
        }
    }

    public String toString() {
        return "BattleTracker:\nConquered:" + this.m_conquered + "\n" + "Blitzed:" + this.m_blitzed + "\n" + "Fought:" + this.m_foughBattles + "\n" + "Pending:" + this.m_pendingBattles;
    }
}

