/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.attatchments.PlayerAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.AbstractPlaceDelegate;
import games.strategy.triplea.delegate.Matches;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class BidPlaceDelegate
extends AbstractPlaceDelegate {
    @Override
    protected String checkProduction(Territory to, Collection<Unit> units, PlayerID player) {
        return null;
    }

    @Override
    protected String canProduce(Territory to, Collection<Unit> units, PlayerID player) {
        return this.canProduce(to, to, units, player);
    }

    @Override
    protected String canProduce(Territory producer, Territory to, Collection<Unit> units, PlayerID player) {
        if (to.isWater()) {
            if (Match.someMatch(units, Matches.UnitIsLand)) {
                return "Cant place land units at sea";
            }
            if (to.getUnits().someMatch(Matches.enemyUnit(player, this.getData()))) {
                return "Cant place in sea zone containing enemy units";
            }
            if (!to.getUnits().someMatch(Matches.unitIsOwnedBy(player))) {
                return "Cant place in sea zone that does not contain a unit owned by you";
            }
            return null;
        }
        if (Match.someMatch(units, Matches.UnitIsSea)) {
            return "Cant place sea units on land";
        }
        if (to.getOwner() == null) {
            return "You dont own " + to.getName();
        }
        if (!to.getOwner().equals(player)) {
            PlayerAttachment pa = PlayerAttachment.get(to.getOwner());
            if (pa != null && pa.getGiveUnitControl() != null && pa.getGiveUnitControl().contains(player)) {
                return null;
            }
            if (to.getUnits().someMatch(Matches.unitIsOwnedBy(player))) {
                return null;
            }
            return "You dont own " + to.getName();
        }
        return null;
    }

    @Override
    protected List<Territory> getAllProducers(Territory to, PlayerID player, Collection<Unit> unitsToPlace) {
        ArrayList<Territory> producers = new ArrayList<Territory>();
        producers.add(to);
        return producers;
    }

    @Override
    protected int getMaxUnitsToBePlaced(Collection<Unit> units, Territory to, PlayerID player, boolean countSwitchedProductionToNeighbors) {
        if (units == null) {
            return -1;
        }
        return units.size();
    }

    @Override
    protected int getMaxUnitsToBePlacedFrom(Territory producer, Collection<Unit> units, Territory to, PlayerID player, boolean countSwitchedProductionToNeighbors, Collection<Territory> notUsableAsOtherProducers, Map<Territory, Integer> currentAvailablePlacementForOtherProducers) {
        if (units == null) {
            return -1;
        }
        return units.size();
    }

    @Override
    protected int getMaxUnitsToBePlacedFrom(Territory producer, Collection<Unit> units, Territory to, PlayerID player) {
        if (units == null) {
            return -1;
        }
        return this.getMaxUnitsToBePlacedFrom(producer, units, to, player, false, null, null);
    }

    protected int getMaxUnitsToBePlaced(Territory to, PlayerID player) {
        return -1;
    }

    @Override
    protected Collection<Unit> getUnitsToBePlacedLand(Territory to, Collection<Unit> units, PlayerID player) {
        Collection<Unit> unitsAtStartOfTurnInTO = this.unitsAtStartOfStepInTerritory(to);
        ArrayList<Unit> placeableUnits = new ArrayList<Unit>();
        CompositeMatchAnd groundUnits = new CompositeMatchAnd(Matches.UnitIsLand, Matches.UnitIsNotConstruction);
        CompositeMatchAnd airUnits = new CompositeMatchAnd(Matches.UnitIsAir, Matches.UnitIsNotConstruction);
        placeableUnits.addAll(Match.getMatches(units, groundUnits));
        placeableUnits.addAll(Match.getMatches(units, airUnits));
        if (Match.someMatch(units, Matches.UnitIsConstruction)) {
            IntegerMap<String> constructionsMap = this.howManyOfEachConstructionCanPlace(to, to, units, player);
            ArrayList<Unit> skipUnit = new ArrayList<Unit>();
            for (Unit currentUnit : Match.getMatches(units, Matches.UnitIsConstruction)) {
                int maxUnits = this.howManyOfConstructionUnit(currentUnit, constructionsMap);
                if (maxUnits <= 0 || skipUnit.contains(currentUnit)) continue;
                placeableUnits.addAll(Match.getNMatches(units, maxUnits, Matches.unitIsOfType(currentUnit.getType())));
                skipUnit.addAll(Match.getMatches(units, Matches.unitIsOfType(currentUnit.getType())));
            }
        }
        if (Match.someMatch(placeableUnits, Matches.UnitConsumesUnitsOnCreation)) {
            List<Unit> unitsWhichConsume = Match.getMatches(placeableUnits, Matches.UnitConsumesUnitsOnCreation);
            for (Unit unit : unitsWhichConsume) {
                if (!Matches.UnitWhichConsumesUnitsHasRequiredUnits(unitsAtStartOfTurnInTO, to).invert().match(unit)) continue;
                placeableUnits.remove(unit);
            }
        }
        ArrayList<Unit> placeableUnits2 = new ArrayList<Unit>();
        ArrayList<UnitType> typesAlreadyChecked = new ArrayList<UnitType>();
        for (Unit currentUnit : placeableUnits) {
            UnitType ut = currentUnit.getType();
            if (typesAlreadyChecked.contains(ut)) continue;
            typesAlreadyChecked.add(ut);
            placeableUnits2.addAll(Match.getNMatches(placeableUnits, UnitAttachment.getMaximumNumberOfThisUnitTypeToReachStackingLimit("placementLimit", ut, to, player, this.getData()), Matches.unitIsOfType(ut)));
        }
        return placeableUnits2;
    }
}

