/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.GameData;
import games.strategy.engine.delegate.IDelegate;
import games.strategy.triplea.delegate.AbstractMoveDelegate;
import games.strategy.triplea.delegate.BattleDelegate;
import games.strategy.triplea.delegate.PoliticsDelegate;
import games.strategy.triplea.delegate.TechnologyDelegate;

public class DelegateFinder {
    private static final IDelegate findDelegate(GameData data, String delegate_name) {
        IDelegate delegate = data.getDelegateList().getDelegate(delegate_name);
        if (delegate == null) {
            throw new IllegalStateException(delegate_name + " delegate not found");
        }
        return delegate;
    }

    public static final PoliticsDelegate politicsDelegate(GameData data) {
        return (PoliticsDelegate)DelegateFinder.findDelegate(data, "politics");
    }

    public static final BattleDelegate battleDelegate(GameData data) {
        return (BattleDelegate)DelegateFinder.findDelegate(data, "battle");
    }

    public static final AbstractMoveDelegate moveDelegate(GameData data) {
        return (AbstractMoveDelegate)DelegateFinder.findDelegate(data, "move");
    }

    public static final TechnologyDelegate techDelegate(GameData data) {
        return (TechnologyDelegate)DelegateFinder.findDelegate(data, "tech");
    }
}

