/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.TerritoryEffect;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.engine.random.IRandomStats;
import games.strategy.triplea.Properties;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.attatchments.RulesAttachment;
import games.strategy.triplea.attatchments.TechAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.attatchments.UnitSupportAttachment;
import games.strategy.triplea.delegate.AirBattle;
import games.strategy.triplea.delegate.Die;
import games.strategy.triplea.delegate.IBattle;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.TerritoryEffectHelper;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.IntegerMap;
import games.strategy.util.LinkedIntegerMap;
import games.strategy.util.Match;
import games.strategy.util.Triple;
import games.strategy.util.Tuple;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DiceRoll
implements Externalizable {
    private static final long serialVersionUID = -1167204061937566271L;
    private List<Die> m_rolls;
    private int m_hits;

    public static void sortAAHighToLow(List<Unit> units, final GameData data, final boolean defending) {
        Comparator<Unit> comparator = new Comparator<Unit>(){

            @Override
            public int compare(Unit u1, Unit u2) {
                float value2;
                Tuple<Integer, Integer> tuple1 = DiceRoll.getAAattackAndMaxDiceSides(Collections.singleton(u1), data, defending);
                Tuple<Integer, Integer> tuple2 = DiceRoll.getAAattackAndMaxDiceSides(Collections.singleton(u2), data, defending);
                if (tuple1.getFirst() == 0) {
                    if (tuple2.getFirst() == 0) {
                        return 0;
                    }
                    return 1;
                }
                if (tuple2.getFirst() == 0) {
                    return -1;
                }
                float value1 = (float)tuple1.getFirst().intValue() / (float)tuple1.getSecond().intValue();
                if (value1 < (value2 = (float)tuple2.getFirst().intValue() / (float)tuple2.getSecond().intValue())) {
                    return 1;
                }
                if (value1 > value2) {
                    return -1;
                }
                return 0;
            }
        };
        Collections.sort(units, comparator);
    }

    public static Tuple<Integer, Integer> getAAattackAndMaxDiceSides(Collection<Unit> defendingEnemyAA, GameData data, boolean defending) {
        int diceSize;
        int highestAttack = 0;
        int chosenDiceSize = diceSize = data.getDiceSides();
        for (Unit u : defendingEnemyAA) {
            int attack;
            int uaDiceSides;
            UnitAttachment ua = UnitAttachment.get(u.getType());
            int n = uaDiceSides = defending ? ua.getAttackAAmaxDieSides() : ua.getOffensiveAttackAAmaxDieSides();
            if (uaDiceSides < 1) {
                uaDiceSides = diceSize;
            }
            int n2 = attack = defending ? ua.getAttackAA(u.getOwner()) : ua.getOffensiveAttackAA(u.getOwner());
            if (attack > uaDiceSides) {
                attack = uaDiceSides;
            }
            if (!((float)attack / (float)uaDiceSides > (float)highestAttack / (float)chosenDiceSize)) continue;
            highestAttack = attack;
            chosenDiceSize = uaDiceSides;
        }
        if (highestAttack > chosenDiceSize / 2 && chosenDiceSize > 1) {
            highestAttack = chosenDiceSize / 2;
        }
        return new Tuple<Integer, Integer>(highestAttack, chosenDiceSize);
    }

    public static int getTotalAAattacks(Collection<Unit> defendingEnemyAA, Collection<Unit> validAttackingUnitsForThisRoll, GameData data) {
        if (defendingEnemyAA.isEmpty() || validAttackingUnitsForThisRoll.isEmpty()) {
            return 0;
        }
        int totalAAattacksNormal = 0;
        int totalAAattacksSurplus = 0;
        for (Unit aa : defendingEnemyAA) {
            UnitAttachment ua = UnitAttachment.get(aa.getType());
            if (ua.getMaxAAattacks() == -1) {
                totalAAattacksNormal = validAttackingUnitsForThisRoll.size();
                continue;
            }
            if (ua.getMayOverStackAA()) {
                totalAAattacksSurplus += ua.getMaxAAattacks();
                continue;
            }
            totalAAattacksNormal += ua.getMaxAAattacks();
        }
        totalAAattacksNormal = Math.min(totalAAattacksNormal, validAttackingUnitsForThisRoll.size());
        return totalAAattacksNormal + totalAAattacksSurplus;
    }

    public static DiceRoll rollAA(Collection<Unit> validAttackingUnitsForThisRoll, Collection<Unit> defendingAAForThisRoll, IDelegateBridge bridge, Territory location, boolean defending) {
        String annotation;
        HashSet<Unit> duplicatesCheckSet1 = new HashSet<Unit>(validAttackingUnitsForThisRoll);
        if (validAttackingUnitsForThisRoll.size() != duplicatesCheckSet1.size()) {
            throw new IllegalStateException("Duplicate Units Detected: Original List:" + validAttackingUnitsForThisRoll + "  HashSet:" + duplicatesCheckSet1);
        }
        HashSet<Unit> duplicatesCheckSet2 = new HashSet<Unit>(defendingAAForThisRoll);
        if (defendingAAForThisRoll.size() != duplicatesCheckSet2.size()) {
            throw new IllegalStateException("Duplicate Units Detected: Original List:" + defendingAAForThisRoll + "  HashSet:" + duplicatesCheckSet2);
        }
        List<Unit> defendingAA = Match.getMatches(defendingAAForThisRoll, defending ? Matches.UnitAttackAAisGreaterThanZeroAndMaxAAattacksIsNotZero : Matches.UnitOffensiveAttackAAisGreaterThanZeroAndMaxAAattacksIsNotZero);
        if (defendingAA.isEmpty()) {
            return new DiceRoll(new ArrayList<Die>(0), 0);
        }
        GameData data = bridge.getData();
        int totalAAattacksTotal = DiceRoll.getTotalAAattacks(defendingAA, validAttackingUnitsForThisRoll, data);
        if (totalAAattacksTotal <= 0) {
            return new DiceRoll(new ArrayList<Die>(0), 0);
        }
        Tuple<Integer, Integer> attackThenDiceSidesForAll = DiceRoll.getAAattackAndMaxDiceSides(defendingAA, data, defending);
        int chosenDiceSizeForAll = attackThenDiceSidesForAll.getSecond();
        int hits = 0;
        ArrayList<Die> sortedDice = new ArrayList<Die>();
        String typeAA = UnitAttachment.get(defendingAA.get(0).getType()).getTypeAA();
        if (Properties.getLow_Luck(data) || Properties.getLL_AA_ONLY(data)) {
            annotation = "Roll " + typeAA + " in " + location.getName();
            Triple<Integer, Integer, Boolean> triple = DiceRoll.getTotalAAPowerThenHitsAndFillSortedDiceThenIfAllUseSameAttack(null, null, defending, defendingAA, validAttackingUnitsForThisRoll, data, false);
            int totalPower = (Integer)triple.getFirst();
            hits += DiceRoll.getLowLuckHits(bridge, sortedDice, totalPower, chosenDiceSizeForAll, defendingAA.get(0).getOwner(), annotation);
        } else {
            annotation = "Roll " + typeAA + " in " + location.getName();
            int[] dice = bridge.getRandom(chosenDiceSizeForAll, totalAAattacksTotal, defendingAA.get(0).getOwner(), IRandomStats.DiceType.COMBAT, annotation);
            hits += ((Integer)DiceRoll.getTotalAAPowerThenHitsAndFillSortedDiceThenIfAllUseSameAttack(dice, sortedDice, defending, defendingAA, validAttackingUnitsForThisRoll, data, true).getSecond()).intValue();
        }
        DiceRoll roll = new DiceRoll(sortedDice, hits);
        String annotation2 = typeAA + " fire in " + location + " : " + MyFormatter.asDice(roll);
        bridge.getHistoryWriter().addChildToEvent(annotation2, roll);
        return roll;
    }

    public static Triple<Integer, Integer, Boolean> getTotalAAPowerThenHitsAndFillSortedDiceThenIfAllUseSameAttack(int[] dice, List<Die> sortedDice, boolean defending, Collection<Unit> defendingAAForThisRoll, Collection<Unit> validAttackingUnitsForThisRoll, GameData data, boolean fillInSortedDiceAndRecordHits) {
        List<Unit> defendingAA = Match.getMatches(defendingAAForThisRoll, defending ? Matches.UnitAttackAAisGreaterThanZeroAndMaxAAattacksIsNotZero : Matches.UnitOffensiveAttackAAisGreaterThanZeroAndMaxAAattacksIsNotZero);
        if (defendingAA.size() <= 0) {
            return new Triple<Integer, Integer, Boolean>(0, 0, false);
        }
        DiceRoll.sortAAHighToLow(defendingAA, data, defending);
        ArrayList<Unit> normalNonInfiniteAA = new ArrayList<Unit>(defendingAA);
        List<Unit> infiniteAA = Match.getMatches(defendingAA, Matches.UnitMaxAAattacksIsInfinite);
        List<Unit> overstackAA = Match.getMatches(defendingAA, Matches.UnitMayOverStackAA);
        overstackAA.removeAll(infiniteAA);
        normalNonInfiniteAA.removeAll(infiniteAA);
        normalNonInfiniteAA.removeAll(overstackAA);
        int totalAAattacksTotal = DiceRoll.getTotalAAattacks(defendingAA, validAttackingUnitsForThisRoll, data);
        int normalNonInfiniteAAtotalAAattacks = DiceRoll.getTotalAAattacks(normalNonInfiniteAA, validAttackingUnitsForThisRoll, data);
        int infiniteAAtotalAAattacks = Math.min(validAttackingUnitsForThisRoll.size() - normalNonInfiniteAAtotalAAattacks, DiceRoll.getTotalAAattacks(infiniteAA, validAttackingUnitsForThisRoll, data));
        int overstackAAtotalAAattacks = DiceRoll.getTotalAAattacks(overstackAA, validAttackingUnitsForThisRoll, data);
        if (totalAAattacksTotal != normalNonInfiniteAAtotalAAattacks + infiniteAAtotalAAattacks + overstackAAtotalAAattacks) {
            throw new IllegalStateException("Total attacks should be: " + totalAAattacksTotal + " but instead is: " + (normalNonInfiniteAAtotalAAattacks + infiniteAAtotalAAattacks + overstackAAtotalAAattacks));
        }
        Tuple<Integer, Integer> attackThenDiceSidesForInfinite = DiceRoll.getAAattackAndMaxDiceSides(infiniteAA, data, defending);
        int hitAtForInfinite = attackThenDiceSidesForInfinite.getFirst();
        boolean recordSortedDice = fillInSortedDiceAndRecordHits && dice != null && dice.length > 0 && sortedDice != null;
        int totalPower = 0;
        int hits = 0;
        int i = 0;
        HashSet<Integer> rolledAt = new HashSet<Integer>();
        int runningMaximum = normalNonInfiniteAAtotalAAattacks;
        Iterator normalAAiter = normalNonInfiniteAA.iterator();
        while (i < runningMaximum && normalAAiter.hasNext()) {
            Unit aaGun = (Unit)normalAAiter.next();
            int numAttacks = UnitAttachment.get(aaGun.getType()).getMaxAAattacks();
            int hitAt = DiceRoll.getAAattackAndMaxDiceSides(Collections.singleton(aaGun), data, defending).getFirst();
            if (hitAt < hitAtForInfinite) continue;
            while (i < runningMaximum && numAttacks > 0) {
                if (recordSortedDice) {
                    boolean hit = dice[i] < hitAt;
                    sortedDice.add(new Die(dice[i], hitAt, hit ? Die.DieType.HIT : Die.DieType.MISS));
                    if (hit) {
                        ++hits;
                    }
                }
                ++i;
                --numAttacks;
                totalPower += hitAt;
                rolledAt.add(hitAt);
            }
        }
        runningMaximum += infiniteAAtotalAAattacks;
        while (i < runningMaximum) {
            if (recordSortedDice) {
                boolean hit = dice[i] < hitAtForInfinite;
                sortedDice.add(new Die(dice[i], hitAtForInfinite, hit ? Die.DieType.HIT : Die.DieType.MISS));
                if (hit) {
                    ++hits;
                }
            }
            ++i;
            totalPower += hitAtForInfinite;
            rolledAt.add(hitAtForInfinite);
        }
        runningMaximum += overstackAAtotalAAattacks;
        Iterator<Unit> overstackAAiter = overstackAA.iterator();
        while (i < runningMaximum && overstackAAiter.hasNext()) {
            Unit aaGun = overstackAAiter.next();
            int numAttacks = UnitAttachment.get(aaGun.getType()).getMaxAAattacks();
            int hitAt = DiceRoll.getAAattackAndMaxDiceSides(Collections.singleton(aaGun), data, defending).getFirst();
            while (i < runningMaximum && numAttacks > 0) {
                if (recordSortedDice) {
                    boolean hit = dice[i] < hitAt;
                    sortedDice.add(new Die(dice[i], hitAt, hit ? Die.DieType.HIT : Die.DieType.MISS));
                    if (hit) {
                        ++hits;
                    }
                }
                ++i;
                --numAttacks;
                totalPower += hitAt;
                rolledAt.add(hitAt);
            }
        }
        return new Triple<Integer, Integer, Boolean>(totalPower, hits, rolledAt.size() == 1);
    }

    private static int getLowLuckHits(IDelegateBridge bridge, List<Die> sortedDice, int totalPower, int chosenDiceSize, PlayerID playerRolling, String annotation) {
        int hits = totalPower / chosenDiceSize;
        int hitsFractional = totalPower % chosenDiceSize;
        if (hitsFractional > 0) {
            boolean hit;
            int[] dice = bridge.getRandom(chosenDiceSize, 1, playerRolling, IRandomStats.DiceType.COMBAT, annotation);
            boolean bl = hit = hitsFractional > dice[0];
            if (hit) {
                ++hits;
            }
            Die die = new Die(dice[0], hitsFractional, hit ? Die.DieType.HIT : Die.DieType.MISS);
            sortedDice.add(die);
        }
        return hits;
    }

    public static DiceRoll rollDice(List<Unit> units, boolean defending, PlayerID player, IDelegateBridge bridge, IBattle battle, String annotation, Collection<TerritoryEffect> territoryEffects, List<Unit> allEnemyUnitsAliveOrWaitingToDie) {
        if (Properties.getLow_Luck(bridge.getData())) {
            return DiceRoll.rollDiceLowLuck(units, defending, player, bridge, battle, annotation, territoryEffects, allEnemyUnitsAliveOrWaitingToDie);
        }
        return DiceRoll.rollDiceNormal(units, defending, player, bridge, battle, annotation, territoryEffects, allEnemyUnitsAliveOrWaitingToDie);
    }

    public static DiceRoll rollNDice(IDelegateBridge bridge, int rollCount, int sides, PlayerID playerRolling, IRandomStats.DiceType diceType, String annotation) {
        if (rollCount == 0) {
            return new DiceRoll(new ArrayList<Die>(), 0);
        }
        int[] random = bridge.getRandom(sides, rollCount, playerRolling, diceType, annotation);
        ArrayList<Die> dice = new ArrayList<Die>();
        int diceIndex = 0;
        for (int i = 0; i < rollCount; ++i) {
            dice.add(new Die(random[diceIndex], 1, Die.DieType.IGNORED));
            ++diceIndex;
        }
        DiceRoll rVal = new DiceRoll(dice, rollCount);
        return rVal;
    }

    public static Map<Unit, Tuple<Integer, Integer>> getUnitPowerAndRollsForNormalBattles(List<Unit> unitsGettingPowerFor, List<Unit> allFriendlyUnitsAliveOrWaitingToDie, List<Unit> allEnemyUnitsAliveOrWaitingToDie, boolean defending, boolean bombing, PlayerID player, GameData data, Territory location, Collection<TerritoryEffect> territoryEffects, boolean isAmphibiousBattle, Collection<Unit> amphibiousLandAttackers) {
        return DiceRoll.getUnitPowerAndRollsForNormalBattles(unitsGettingPowerFor, allFriendlyUnitsAliveOrWaitingToDie, allEnemyUnitsAliveOrWaitingToDie, defending, bombing, player, data, location, territoryEffects, isAmphibiousBattle, amphibiousLandAttackers, new HashMap<Unit, IntegerMap<Unit>>(), new HashMap<Unit, IntegerMap<Unit>>());
    }

    public static Map<Unit, Tuple<Integer, Integer>> getUnitPowerAndRollsForNormalBattles(List<Unit> unitsGettingPowerFor, List<Unit> allFriendlyUnitsAliveOrWaitingToDie, List<Unit> allEnemyUnitsAliveOrWaitingToDie, boolean defending, boolean bombing, PlayerID player, GameData data, Territory location, Collection<TerritoryEffect> territoryEffects, boolean isAmphibiousBattle, Collection<Unit> amphibiousLandAttackers, Map<Unit, IntegerMap<Unit>> unitSupportPowerMap, Map<Unit, IntegerMap<Unit>> unitSupportRollsMap) {
        HashMap<Unit, Tuple<Integer, Integer>> rVal = new HashMap<Unit, Tuple<Integer, Integer>>();
        if (unitsGettingPowerFor == null || unitsGettingPowerFor.isEmpty()) {
            return rVal;
        }
        HashSet<List<UnitSupportAttachment>> supportRulesFriendly = new HashSet<List<UnitSupportAttachment>>();
        IntegerMap<UnitSupportAttachment> supportLeftFriendly = new IntegerMap<UnitSupportAttachment>();
        HashMap<UnitSupportAttachment, LinkedIntegerMap<Unit>> supportUnitsLeftFriendly = new HashMap<UnitSupportAttachment, LinkedIntegerMap<Unit>>();
        DiceRoll.getSupport(allFriendlyUnitsAliveOrWaitingToDie, supportRulesFriendly, supportLeftFriendly, supportUnitsLeftFriendly, data, defending, true);
        HashSet<List<UnitSupportAttachment>> supportRulesEnemy = new HashSet<List<UnitSupportAttachment>>();
        IntegerMap<UnitSupportAttachment> supportLeftEnemy = new IntegerMap<UnitSupportAttachment>();
        HashMap<UnitSupportAttachment, LinkedIntegerMap<Unit>> supportUnitsLeftEnemy = new HashMap<UnitSupportAttachment, LinkedIntegerMap<Unit>>();
        DiceRoll.getSupport(allEnemyUnitsAliveOrWaitingToDie, supportRulesEnemy, supportLeftEnemy, supportUnitsLeftEnemy, data, !defending, false);
        IntegerMap<UnitSupportAttachment> supportLeftFriendlyRolls = new IntegerMap<UnitSupportAttachment>(supportLeftFriendly);
        IntegerMap<UnitSupportAttachment> supportLeftEnemyRolls = new IntegerMap<UnitSupportAttachment>(supportLeftEnemy);
        HashMap<UnitSupportAttachment, LinkedIntegerMap<Unit>> supportUnitsLeftFriendlyRolls = new HashMap<UnitSupportAttachment, LinkedIntegerMap<Unit>>();
        for (UnitSupportAttachment usa : supportUnitsLeftFriendly.keySet()) {
            supportUnitsLeftFriendlyRolls.put(usa, new LinkedIntegerMap((LinkedIntegerMap)supportUnitsLeftFriendly.get(usa)));
        }
        HashMap<UnitSupportAttachment, LinkedIntegerMap<Unit>> supportUnitsLeftEnemyRolls = new HashMap<UnitSupportAttachment, LinkedIntegerMap<Unit>>();
        for (UnitSupportAttachment usa : supportUnitsLeftEnemy.keySet()) {
            supportUnitsLeftEnemyRolls.put(usa, new LinkedIntegerMap((LinkedIntegerMap)supportUnitsLeftEnemy.get(usa)));
        }
        int diceSides = data.getDiceSides();
        for (Unit current : unitsGettingPowerFor) {
            int rolls;
            int strength;
            UnitAttachment ua = UnitAttachment.get(current.getType());
            if (defending) {
                strength = ua.getDefense(current.getOwner());
                strength = DiceRoll.isFirstTurnLimitedRoll(current.getOwner(), data) ? Math.min(1, strength) : (strength += DiceRoll.getSupport(current, supportRulesFriendly, supportLeftFriendly, supportUnitsLeftFriendly, unitSupportPowerMap, true, false));
                strength += DiceRoll.getSupport(current, supportRulesEnemy, supportLeftEnemy, supportUnitsLeftEnemy, unitSupportPowerMap, true, false);
            } else {
                strength = ua.getAttack(current.getOwner());
                if (ua.getIsMarine() != 0 && isAmphibiousBattle && amphibiousLandAttackers.contains(current)) {
                    strength += ua.getIsMarine();
                }
                if (ua.getIsSea() && isAmphibiousBattle && Matches.TerritoryIsLand.match(location)) {
                    strength = ua.getBombard(current.getOwner());
                }
                strength += DiceRoll.getSupport(current, supportRulesFriendly, supportLeftFriendly, supportUnitsLeftFriendly, unitSupportPowerMap, true, false);
                strength += DiceRoll.getSupport(current, supportRulesEnemy, supportLeftEnemy, supportUnitsLeftEnemy, unitSupportPowerMap, true, false);
            }
            strength += TerritoryEffectHelper.getTerritoryCombatBonus(current.getType(), territoryEffects, defending);
            strength = Math.min(Math.max(strength, 0), diceSides);
            if (!bombing && strength == 0) {
                rolls = 0;
            } else {
                rolls = defending ? ua.getDefenseRolls(current.getOwner()) : ua.getAttackRolls(current.getOwner());
                rolls += DiceRoll.getSupport(current, supportRulesFriendly, supportLeftFriendlyRolls, supportUnitsLeftFriendlyRolls, unitSupportRollsMap, false, true);
                rolls += DiceRoll.getSupport(current, supportRulesEnemy, supportLeftEnemyRolls, supportUnitsLeftEnemyRolls, unitSupportRollsMap, false, true);
                if ((rolls = Math.max(0, rolls)) == 0) {
                    strength = 0;
                }
            }
            rVal.put(current, new Tuple<Integer, Integer>(strength, rolls));
        }
        return rVal;
    }

    public static Tuple<Integer, Integer> getTotalPowerAndRolls(Map<Unit, Tuple<Integer, Integer>> unitPowerAndRollsMap, GameData data) {
        int diceSides = data.getDiceSides();
        boolean lowLuck = Properties.getLow_Luck(data);
        boolean lhtrBombers = Properties.getLHTR_Heavy_Bombers(data);
        int extraRollBonus = Math.max(1, data.getDiceSides() / 6);
        int totalPower = 0;
        int totalRolls = 0;
        for (Map.Entry<Unit, Tuple<Integer, Integer>> entry : unitPowerAndRollsMap.entrySet()) {
            int unitStrength = Math.min(Math.max(0, entry.getValue().getFirst()), diceSides);
            int unitRolls = entry.getValue().getSecond();
            if (unitStrength <= 0 || unitRolls <= 0) continue;
            if (unitRolls == 1) {
                totalPower += unitStrength;
                totalRolls += unitRolls;
                continue;
            }
            UnitAttachment ua = UnitAttachment.get(entry.getKey().getType());
            if (lowLuck) {
                if (lhtrBombers || ua.getChooseBestRoll()) {
                    totalPower += Math.min(unitStrength += extraRollBonus * (unitRolls - 1), diceSides);
                    totalRolls += unitRolls;
                    continue;
                }
                totalPower += unitRolls * unitStrength;
                totalRolls += unitRolls;
                continue;
            }
            if (lhtrBombers || ua.getChooseBestRoll()) {
                totalPower += Math.min(unitStrength += extraRollBonus * (unitRolls - 1), diceSides);
                totalRolls += unitRolls;
                continue;
            }
            totalPower += unitRolls * unitStrength;
            totalRolls += unitRolls;
        }
        return new Tuple<Integer, Integer>(totalPower, totalRolls);
    }

    private static DiceRoll rollDiceLowLuck(List<Unit> unitsList, boolean defending, PlayerID player, IDelegateBridge bridge, IBattle battle, String annotation, Collection<TerritoryEffect> territoryEffects, List<Unit> allEnemyUnitsAliveOrWaitingToDie) {
        int[] random;
        Collection<Unit> amphibiousLandAttackers;
        boolean isAmphibiousBattle;
        Territory location;
        ArrayList<Unit> units = new ArrayList<Unit>(unitsList);
        HashSet<Unit> duplicatesCheckSet = new HashSet<Unit>(unitsList);
        if (units.size() != duplicatesCheckSet.size()) {
            throw new IllegalStateException("Duplicate Units Detected: Original List:" + units + "  HashSet:" + duplicatesCheckSet);
        }
        GameData data = bridge.getData();
        Map<Unit, Tuple<Integer, Integer>> unitPowerAndRollsMap = DiceRoll.getUnitPowerAndRollsForNormalBattles(units, units, allEnemyUnitsAliveOrWaitingToDie, defending, false, player, data, location = battle.getTerritory(), territoryEffects, isAmphibiousBattle = battle.isAmphibious(), amphibiousLandAttackers = battle.getAmphibiousLandAttackers());
        Tuple<Integer, Integer> totalPowerAndRolls = DiceRoll.getTotalPowerAndRolls(unitPowerAndRollsMap, data);
        int power = totalPowerAndRolls.getFirst();
        if (power == 0) {
            return new DiceRoll(new ArrayList<Die>(0), 0);
        }
        int hitCount = power / data.getDiceSides();
        ArrayList<Die> dice = new ArrayList<Die>();
        int rollFor = power % data.getDiceSides();
        if (rollFor == 0) {
            random = new int[]{};
        } else {
            boolean hit;
            random = bridge.getRandom(data.getDiceSides(), 1, player, IRandomStats.DiceType.COMBAT, annotation);
            boolean bl = hit = rollFor > random[0];
            if (hit) {
                ++hitCount;
            }
            dice.add(new Die(random[0], rollFor, hit ? Die.DieType.HIT : Die.DieType.MISS));
        }
        DiceRoll rVal = new DiceRoll(dice, hitCount);
        bridge.getHistoryWriter().addChildToEvent(annotation + " : " + MyFormatter.asDice(random), rVal);
        return rVal;
    }

    public static int getArtillerySupportAvailable(List<Unit> units, boolean defending, PlayerID player) {
        int artillerySupportAvailable = 0;
        if (!defending) {
            List<Unit> arty = Match.getMatches(units, Matches.UnitIsArtillery);
            for (Unit current : arty) {
                UnitAttachment ua = UnitAttachment.get(current.getType());
                artillerySupportAvailable += ua.getUnitSupportCount();
            }
            if (DiceRoll.isImprovedArtillerySupport(player)) {
                artillerySupportAvailable *= 2;
            }
        }
        return artillerySupportAvailable;
    }

    public static int getArtillerySupportAvailable(Unit u, boolean defending, PlayerID player) {
        if (Matches.UnitIsArtillery.match(u) && !defending) {
            UnitAttachment ua = UnitAttachment.get(u.getType());
            int artillerySupportAvailable = ua.getUnitSupportCount();
            if (DiceRoll.isImprovedArtillerySupport(player)) {
                artillerySupportAvailable *= 2;
            }
            return artillerySupportAvailable;
        }
        return 0;
    }

    public static int getSupportableAvailable(List<Unit> units, boolean defending, PlayerID player) {
        if (!defending) {
            return Match.countMatches(units, Matches.UnitIsArtillerySupportable);
        }
        return 0;
    }

    public static int getSupportableAvailable(Unit u, boolean defending, PlayerID player) {
        if (Matches.UnitIsArtillerySupportable.match(u) && !defending) {
            return 1;
        }
        return 0;
    }

    public static void getSupport(List<Unit> unitsGivingTheSupport, Set<List<UnitSupportAttachment>> supportsAvailable, IntegerMap<UnitSupportAttachment> supportLeft, Map<UnitSupportAttachment, LinkedIntegerMap<Unit>> supportUnitsLeft, GameData data, boolean defence, boolean allies) {
        if (unitsGivingTheSupport == null || unitsGivingTheSupport.isEmpty()) {
            return;
        }
        for (UnitSupportAttachment rule : UnitSupportAttachment.get(data)) {
            CompositeMatchAnd canSupport;
            List<Unit> supporters;
            int numSupport;
            if (!(!rule.getPlayers().isEmpty() && (defence && rule.getDefence() || !defence && rule.getOffence()) && (allies && rule.getAllied() || !allies && rule.getEnemy()) && (numSupport = (supporters = Match.getMatches(unitsGivingTheSupport, canSupport = new CompositeMatchAnd(Matches.unitIsOfType((UnitType)rule.getAttachedTo()), Matches.unitOwnedBy(rule.getPlayers())))).size()) > 0)) continue;
            ArrayList<Unit> impArtTechUnits = new ArrayList<Unit>();
            if (rule.getImpArtTech()) {
                impArtTechUnits.addAll(Match.getMatches(supporters, Matches.unitOwnerHasImprovedArtillerySupportTech()));
            }
            supportLeft.put(rule, (numSupport += impArtTechUnits.size()) * rule.getNumber());
            supportUnitsLeft.put(rule, new LinkedIntegerMap<Unit>(supporters, rule.getNumber()));
            supportUnitsLeft.get(rule).addAll(impArtTechUnits, rule.getNumber());
            Iterator<List<UnitSupportAttachment>> iter2 = supportsAvailable.iterator();
            List<UnitSupportAttachment> ruleType = null;
            boolean found = false;
            String bonusType = rule.getBonusType();
            while (iter2.hasNext()) {
                ruleType = iter2.next();
                if (!ruleType.get(0).getBonusType().equals(bonusType)) continue;
                found = true;
                break;
            }
            if (!found) {
                ruleType = new ArrayList<UnitSupportAttachment>();
                supportsAvailable.add(ruleType);
            }
            if (ruleType == null) continue;
            ruleType.add(rule);
        }
        DiceRoll.sortSupportRules(supportsAvailable, defence, allies);
    }

    public static int getSupport(Unit unit, Set<List<UnitSupportAttachment>> supportsAvailable, IntegerMap<UnitSupportAttachment> supportLeft, Map<UnitSupportAttachment, LinkedIntegerMap<Unit>> supportUnitsLeft, Map<Unit, IntegerMap<Unit>> unitSupportMap, boolean strength, boolean rolls) {
        int givenSupport = 0;
        block0: for (List<UnitSupportAttachment> bonusType : supportsAvailable) {
            for (UnitSupportAttachment rule : bonusType) {
                Set<Unit> supporters;
                HashSet<UnitType> types;
                if ((!strength || !rule.getStrength()) && (!rolls || !rule.getRoll()) || (types = rule.getUnitType()) == null || !types.contains(unit.getType()) || supportLeft.getInt(rule) <= 0) continue;
                givenSupport += rule.getBonus();
                supportLeft.add(rule, -1);
                LinkedIntegerMap<Unit> supportersLeft = supportUnitsLeft.get(rule);
                if (supportersLeft == null || (supporters = supportersLeft.keySet()).isEmpty()) continue block0;
                Unit u = supporters.iterator().next();
                supportUnitsLeft.get(rule).add(u, -1);
                if (supportUnitsLeft.get(rule).getInt(u) <= 0) {
                    supportUnitsLeft.get(rule).removeKey(u);
                }
                if (unitSupportMap.containsKey(u)) {
                    unitSupportMap.get(u).add(unit, rule.getBonus());
                    continue block0;
                }
                unitSupportMap.put(u, new IntegerMap<Unit>(unit, rule.getBonus()));
                continue block0;
            }
        }
        return givenSupport;
    }

    public static void sortByStrength(List<Unit> units, final boolean defending) {
        Comparator<Unit> comp = new Comparator<Unit>(){

            @Override
            public int compare(Unit u1, Unit u2) {
                Integer v2;
                Integer v1;
                if (defending) {
                    v1 = UnitAttachment.get(u1.getType()).getDefense(u1.getOwner());
                    v2 = UnitAttachment.get(u2.getType()).getDefense(u2.getOwner());
                } else {
                    v1 = UnitAttachment.get(u1.getType()).getAttack(u1.getOwner());
                    v2 = UnitAttachment.get(u2.getType()).getAttack(u2.getOwner());
                }
                return v1.compareTo(v2);
            }
        };
        Collections.sort(units, comp);
    }

    private static void sortSupportRules(Set<List<UnitSupportAttachment>> support, final boolean defense, final boolean friendly) {
        Comparator<UnitSupportAttachment> compList = new Comparator<UnitSupportAttachment>(){

            @Override
            public int compare(UnitSupportAttachment u1, UnitSupportAttachment u2) {
                Integer unitPower2;
                Integer unitPower1;
                Integer s2;
                Integer u2Bonus;
                Integer u1Bonus;
                boolean u2CanBonus;
                int compareTo = 0;
                boolean u1CanBonus = defense ? u1.getDefence() : u1.getOffence();
                boolean bl = u2CanBonus = defense ? u2.getDefence() : u2.getOffence();
                if (friendly) {
                    if (u1.getRoll() || u2.getRoll()) {
                        u1Bonus = u1.getRoll() && u1CanBonus ? u1.getBonus() : 0;
                        u2Bonus = u2.getRoll() && u2CanBonus ? u2.getBonus() : 0;
                        compareTo = u2Bonus.compareTo(u1Bonus);
                        if (compareTo != 0) {
                            return compareTo;
                        }
                    }
                    if (u1.getStrength() || u2.getStrength()) {
                        u1Bonus = u1.getStrength() && u1CanBonus ? u1.getBonus() : 0;
                        u2Bonus = u2.getStrength() && u2CanBonus ? u2.getBonus() : 0;
                        compareTo = u2Bonus.compareTo(u1Bonus);
                        if (compareTo != 0) {
                            return compareTo;
                        }
                    }
                } else {
                    if ((u1.getRoll() || u2.getRoll()) && (compareTo = (u1Bonus = Integer.valueOf(u1.getRoll() && u1CanBonus ? u1.getBonus() : 0)).compareTo(u2Bonus = Integer.valueOf(u2.getRoll() && u2CanBonus ? u2.getBonus() : 0))) != 0) {
                        return compareTo;
                    }
                    if ((u1.getStrength() || u2.getStrength()) && (compareTo = (u1Bonus = Integer.valueOf(u1.getStrength() && u1CanBonus ? u1.getBonus() : 0)).compareTo(u2Bonus = Integer.valueOf(u2.getStrength() && u2CanBonus ? u2.getBonus() : 0))) != 0) {
                        return compareTo;
                    }
                }
                HashSet<UnitType> types1 = u1.getUnitType();
                HashSet<UnitType> types2 = u2.getUnitType();
                Integer s1 = types1 == null ? 0 : types1.size();
                compareTo = s1.compareTo(s2 = Integer.valueOf(types2 == null ? 0 : types2.size()));
                if (compareTo != 0) {
                    return compareTo;
                }
                UnitType unitType1 = (UnitType)u1.getAttachedTo();
                UnitType unitType2 = (UnitType)u2.getAttachedTo();
                UnitAttachment ua1 = UnitAttachment.get(unitType1);
                UnitAttachment ua2 = UnitAttachment.get(unitType2);
                if (u1.getDefence()) {
                    unitPower1 = ua1.getDefenseRolls(PlayerID.NULL_PLAYERID) * ua1.getDefense(PlayerID.NULL_PLAYERID);
                    unitPower2 = ua2.getDefenseRolls(PlayerID.NULL_PLAYERID) * ua2.getDefense(PlayerID.NULL_PLAYERID);
                } else {
                    unitPower1 = ua1.getAttackRolls(PlayerID.NULL_PLAYERID) * ua1.getAttack(PlayerID.NULL_PLAYERID);
                    unitPower2 = ua2.getAttackRolls(PlayerID.NULL_PLAYERID) * ua2.getAttack(PlayerID.NULL_PLAYERID);
                }
                return unitPower2.compareTo(unitPower1);
            }
        };
        Iterator<List<UnitSupportAttachment>> iter = support.iterator();
        while (iter.hasNext()) {
            Collections.sort(iter.next(), compList);
        }
    }

    public static DiceRoll airBattle(List<Unit> unitsList, boolean defending, PlayerID player, IDelegateBridge bridge, IBattle battle, String annotation) {
        int[] random;
        HashSet<Unit> duplicatesCheckSet1 = new HashSet<Unit>(unitsList);
        if (unitsList.size() != duplicatesCheckSet1.size()) {
            throw new IllegalStateException("Duplicate Units Detected: Original List:" + unitsList + "  HashSet:" + duplicatesCheckSet1);
        }
        GameData data = bridge.getData();
        boolean lhtrBombers = Properties.getLHTR_Heavy_Bombers(data);
        ArrayList<Unit> units = new ArrayList<Unit>(unitsList);
        int rollCount = AirBattle.getAirBattleRolls(unitsList, defending);
        if (rollCount == 0) {
            return new DiceRoll(new ArrayList<Die>(), 0);
        }
        ArrayList<Die> dice = new ArrayList<Die>();
        int hitCount = 0;
        if (Properties.getLow_Luck(data)) {
            int extraRollBonus = Math.max(1, data.getDiceSides() / 6);
            Iterator iter = units.iterator();
            int power = 0;
            while (iter.hasNext()) {
                Unit current = (Unit)iter.next();
                UnitAttachment ua = UnitAttachment.get(current.getType());
                int rolls = AirBattle.getAirBattleRolls(current, defending);
                int totalStrength = 0;
                int strength = Math.min(data.getDiceSides(), Math.max(0, defending ? ua.getAirDefense(current.getOwner()) : ua.getAirAttack(current.getOwner())));
                for (int i = 0; i < rolls; ++i) {
                    if (i > 1 && (lhtrBombers || ua.getChooseBestRoll())) {
                        totalStrength += extraRollBonus;
                        continue;
                    }
                    totalStrength += strength;
                }
                power += Math.min(Math.max(totalStrength, 0), data.getDiceSides());
            }
            hitCount = power / data.getDiceSides();
            random = new int[]{};
            if ((power %= data.getDiceSides()) != 0) {
                boolean hit;
                random = bridge.getRandom(data.getDiceSides(), 1, player, IRandomStats.DiceType.COMBAT, annotation);
                boolean bl = hit = power > random[0];
                if (hit) {
                    ++hitCount;
                }
                dice.add(new Die(random[0], power, hit ? Die.DieType.HIT : Die.DieType.MISS));
            }
        } else {
            random = bridge.getRandom(data.getDiceSides(), rollCount, player, IRandomStats.DiceType.COMBAT, annotation);
            Iterator iter = units.iterator();
            int diceIndex = 0;
            while (iter.hasNext()) {
                Unit current = (Unit)iter.next();
                UnitAttachment ua = UnitAttachment.get(current.getType());
                int strength = Math.min(data.getDiceSides(), Math.max(0, defending ? ua.getAirDefense(current.getOwner()) : ua.getAirAttack(current.getOwner())));
                int rolls = AirBattle.getAirBattleRolls(current, defending);
                if (rolls > 1 && (lhtrBombers || ua.getChooseBestRoll())) {
                    int minIndex = 0;
                    int min = data.getDiceSides();
                    for (int i = 0; i < rolls; ++i) {
                        if (random[diceIndex + i] >= min) continue;
                        min = random[diceIndex + i];
                        minIndex = i;
                    }
                    boolean hit = strength > random[diceIndex + minIndex];
                    dice.add(new Die(random[diceIndex + minIndex], strength, hit ? Die.DieType.HIT : Die.DieType.MISS));
                    for (int i = 0; i < rolls; ++i) {
                        if (i == minIndex) continue;
                        dice.add(new Die(random[diceIndex + i], strength, Die.DieType.IGNORED));
                    }
                    if (hit) {
                        ++hitCount;
                    }
                    diceIndex += rolls;
                    continue;
                }
                for (int i = 0; i < rolls; ++i) {
                    boolean hit = strength > random[diceIndex];
                    dice.add(new Die(random[diceIndex], strength, hit ? Die.DieType.HIT : Die.DieType.MISS));
                    if (hit) {
                        ++hitCount;
                    }
                    ++diceIndex;
                }
            }
        }
        DiceRoll rVal = new DiceRoll(dice, hitCount);
        bridge.getHistoryWriter().addChildToEvent(annotation + " : " + MyFormatter.asDice(random), rVal);
        return rVal;
    }

    private static DiceRoll rollDiceNormal(List<Unit> unitsList, boolean defending, PlayerID player, IDelegateBridge bridge, IBattle battle, String annotation, Collection<TerritoryEffect> territoryEffects, List<Unit> allEnemyUnitsAliveOrWaitingToDie) {
        ArrayList<Unit> units = new ArrayList<Unit>(unitsList);
        HashSet<Unit> duplicatesCheckSet = new HashSet<Unit>(unitsList);
        if (units.size() != duplicatesCheckSet.size()) {
            throw new IllegalStateException("Duplicate Units Detected: Original List:" + units + "  HashSet:" + duplicatesCheckSet);
        }
        GameData data = bridge.getData();
        DiceRoll.sortByStrength(units, defending);
        Territory location = battle.getTerritory();
        boolean isAmphibiousBattle = battle.isAmphibious();
        Collection<Unit> amphibiousLandAttackers = battle.getAmphibiousLandAttackers();
        Map<Unit, Tuple<Integer, Integer>> unitPowerAndRollsMap = DiceRoll.getUnitPowerAndRollsForNormalBattles(units, units, allEnemyUnitsAliveOrWaitingToDie, defending, false, player, data, location, territoryEffects, isAmphibiousBattle, amphibiousLandAttackers);
        Tuple<Integer, Integer> totalPowerAndRolls = DiceRoll.getTotalPowerAndRolls(unitPowerAndRollsMap, data);
        int rollCount = totalPowerAndRolls.getSecond();
        if (rollCount == 0) {
            return new DiceRoll(new ArrayList<Die>(), 0);
        }
        int[] random = bridge.getRandom(data.getDiceSides(), rollCount, player, IRandomStats.DiceType.COMBAT, annotation);
        boolean lhtrBombers = Properties.getLHTR_Heavy_Bombers(data);
        ArrayList<Die> dice = new ArrayList<Die>();
        int hitCount = 0;
        int diceIndex = 0;
        for (Unit current : units) {
            UnitAttachment ua = UnitAttachment.get(current.getType());
            Tuple<Integer, Integer> powerAndRolls = unitPowerAndRollsMap.get(current);
            int strength = powerAndRolls.getFirst();
            int rolls = powerAndRolls.getSecond();
            if (rolls <= 0 || strength <= 0) continue;
            if (rolls > 1 && (lhtrBombers || ua.getChooseBestRoll())) {
                int smallestDieIndex = 0;
                int smallestDie = data.getDiceSides();
                for (int i = 0; i < rolls; ++i) {
                    if (random[diceIndex + i] >= smallestDie) continue;
                    smallestDie = random[diceIndex + i];
                    smallestDieIndex = i;
                }
                boolean hit = strength > random[diceIndex + smallestDieIndex];
                dice.add(new Die(random[diceIndex + smallestDieIndex], strength, hit ? Die.DieType.HIT : Die.DieType.MISS));
                for (int i = 0; i < rolls; ++i) {
                    if (i == smallestDieIndex) continue;
                    dice.add(new Die(random[diceIndex + i], strength, Die.DieType.IGNORED));
                }
                if (hit) {
                    ++hitCount;
                }
                diceIndex += rolls;
                continue;
            }
            for (int i = 0; i < rolls; ++i) {
                boolean hit = strength > random[diceIndex];
                dice.add(new Die(random[diceIndex], strength, hit ? Die.DieType.HIT : Die.DieType.MISS));
                if (hit) {
                    ++hitCount;
                }
                ++diceIndex;
            }
        }
        DiceRoll rVal = new DiceRoll(dice, hitCount);
        bridge.getHistoryWriter().addChildToEvent(annotation + " : " + MyFormatter.asDice(random), rVal);
        return rVal;
    }

    public static boolean isFirstTurnLimitedRoll(PlayerID player, GameData data) {
        if (player.isNull() || data.getSequence().getRound() != 1 || DiceRoll.isNegateDominatingFirstRoundAttack(player)) {
            return false;
        }
        return DiceRoll.isDominatingFirstRoundAttack(data.getSequence().getStep().getPlayerID());
    }

    private static boolean isDominatingFirstRoundAttack(PlayerID player) {
        if (player == null) {
            return false;
        }
        RulesAttachment ra = (RulesAttachment)player.getAttachment("rulesAttatchment");
        if (ra == null) {
            return false;
        }
        return ra.getDominatingFirstRoundAttack();
    }

    private static boolean isNegateDominatingFirstRoundAttack(PlayerID player) {
        RulesAttachment ra = (RulesAttachment)player.getAttachment("rulesAttatchment");
        if (ra == null) {
            return false;
        }
        return ra.getNegateDominatingFirstRoundAttack();
    }

    public static boolean isAmphibious(Collection<Unit> m_units) {
        for (TripleAUnit tripleAUnit : m_units) {
            if (!tripleAUnit.getWasAmphibious()) continue;
            return true;
        }
        return false;
    }

    private static boolean isImprovedArtillerySupport(PlayerID player) {
        TechAttachment ta = (TechAttachment)player.getAttachment("techAttatchment");
        if (ta == null) {
            return false;
        }
        return ta.getImprovedArtillerySupport();
    }

    public static String getAnnotation(List<Unit> units, PlayerID player, IBattle battle) {
        StringBuilder buffer = new StringBuilder(80);
        buffer.append(player.getName()).append(" roll dice for ").append(MyFormatter.unitsToTextNoOwner(units));
        if (battle != null) {
            buffer.append(" in ").append(battle.getTerritory().getName()).append(", round ").append(battle.getBattleRound() + 1);
        }
        return buffer.toString();
    }

    public DiceRoll(int[] dice, int hits, int rollAt, boolean hitOnlyIfEquals) {
        this.m_hits = hits;
        this.m_rolls = new ArrayList<Die>(dice.length);
        for (int element : dice) {
            boolean hit = hitOnlyIfEquals ? rollAt == element : element <= rollAt;
            this.m_rolls.add(new Die(element, rollAt, hit ? Die.DieType.HIT : Die.DieType.MISS));
        }
    }

    public DiceRoll() {
    }

    private DiceRoll(List<Die> dice, int hits) {
        this.m_rolls = new ArrayList<Die>(dice);
        this.m_hits = hits;
    }

    public int getHits() {
        return this.m_hits;
    }

    public List<Die> getRolls(int rollAt) {
        ArrayList<Die> rVal = new ArrayList<Die>();
        for (Die die : this.m_rolls) {
            if (die.getRolledAt() != rollAt) continue;
            rVal.add(die);
        }
        return rVal;
    }

    public int size() {
        return this.m_rolls.size();
    }

    public Die getDie(int index) {
        return this.m_rolls.get(index);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int[] dice = new int[this.m_rolls.size()];
        for (int i = 0; i < this.m_rolls.size(); ++i) {
            dice[i] = this.m_rolls.get(i).getCompressedValue();
        }
        out.writeObject(dice);
        out.writeInt(this.m_hits);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int[] dice = (int[])in.readObject();
        this.m_rolls = new ArrayList<Die>(dice.length);
        for (int element : dice) {
            this.m_rolls.add(Die.getFromWriteValue(element));
        }
        this.m_hits = in.readInt();
    }

    public String toString() {
        return "DiceRoll dice:" + this.m_rolls + " hits:" + this.m_hits;
    }
}

