/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.triplea.delegate.IExecutable;
import java.io.Serializable;
import java.util.Collection;
import java.util.Stack;

public class ExecutionStack
implements Serializable {
    private static final long serialVersionUID = -8675285470515074530L;
    private IExecutable m_current;
    private final Stack<IExecutable> m_stack = new Stack();

    public void execute(IDelegateBridge bridge) {
        if (this.m_current != null) {
            this.m_stack.push(this.m_current);
        }
        while (!this.m_stack.isEmpty()) {
            this.m_current = this.m_stack.pop();
            this.m_current.execute(this, bridge);
        }
        this.m_current = null;
    }

    public void push(Collection<IExecutable> executables) {
        for (IExecutable ex : executables) {
            this.push(ex);
        }
    }

    public void push(IExecutable executable) {
        this.m_stack.push(executable);
    }

    public boolean isExecuting() {
        return this.m_current != null;
    }

    public boolean isEmpty() {
        return this.m_stack.isEmpty();
    }
}

