/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.triplea.delegate.AbstractBattle;
import games.strategy.triplea.delegate.BattleCalculator;
import games.strategy.triplea.delegate.BattleTracker;
import games.strategy.triplea.delegate.IBattle;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.TransportTracker;
import games.strategy.triplea.delegate.dataObjects.BattleRecord;
import games.strategy.triplea.oddsCalculator.ta.BattleResults;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import games.strategy.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FinishedBattle
extends AbstractBattle {
    private static final long serialVersionUID = -5852495231826940879L;
    private final Set<Territory> m_attackingFrom = new HashSet<Territory>();
    private final Collection<Territory> m_amphibiousAttackFrom = new ArrayList<Territory>();
    private final Map<Territory, Collection<Unit>> m_attackingFromMap = new HashMap<Territory, Collection<Unit>>();

    public FinishedBattle(Territory battleSite, PlayerID attacker, BattleTracker battleTracker, boolean isBombingRun, IBattle.BattleType battleType, GameData data, BattleRecord.BattleResultDescription battleResultDescription, IBattle.WhoWon whoWon, Collection<Unit> attackingUnits) {
        super(battleSite, attacker, battleTracker, isBombingRun, battleType, data);
        this.m_battleResultDescription = battleResultDescription;
        this.m_whoWon = whoWon;
    }

    public void setDefendingUnits(List<Unit> defendingUnits) {
        this.m_defendingUnits = defendingUnits;
    }

    @Override
    public boolean isEmpty() {
        return this.m_attackingUnits.isEmpty();
    }

    @Override
    public void fight(IDelegateBridge bridge) {
        if (!this.m_headless) {
            this.m_battleTracker.getBattleRecords(this.m_data).addResultToBattle(this.m_attacker, this.m_battleID, this.m_defender, this.m_attackerLostTUV, this.m_defenderLostTUV, this.m_battleResultDescription, new BattleResults(this, this.m_data), 0);
        }
        this.m_battleTracker.removeBattle(this);
        this.m_isOver = true;
    }

    @Override
    public Change addAttackChange(Route route, Collection<Unit> units, HashMap<Unit, HashSet<Unit>> targets) {
        Map<Unit, Collection<Unit>> addedTransporting = TransportTracker.transporting(units);
        for (Unit unit : addedTransporting.keySet()) {
            if (this.m_dependentUnits.get(unit) != null) {
                ((Collection)this.m_dependentUnits.get(unit)).addAll(addedTransporting.get(unit));
                continue;
            }
            this.m_dependentUnits.put(unit, addedTransporting.get(unit));
        }
        Territory attackingFrom = route.getTerritoryBeforeEnd();
        this.m_attackingFrom.add(attackingFrom);
        this.m_attackingUnits.addAll(units);
        if (this.m_attackingFromMap.get(attackingFrom) == null) {
            this.m_attackingFromMap.put(attackingFrom, new ArrayList());
        }
        Collection<Unit> attackingFromMapUnits = this.m_attackingFromMap.get(attackingFrom);
        attackingFromMapUnits.addAll(units);
        if (route.getStart().isWater() && route.getEnd() != null && !route.getEnd().isWater() && Match.someMatch(units, Matches.UnitIsLand)) {
            this.m_amphibiousAttackFrom.add(route.getTerritoryBeforeEnd());
            this.m_amphibiousLandAttackers.addAll(Match.getMatches(units, Matches.UnitIsLand));
            this.m_isAmphibious = true;
        }
        return ChangeFactory.EMPTY_CHANGE;
    }

    @Override
    public void removeAttack(Route route, Collection<Unit> units) {
        this.m_attackingUnits.removeAll(units);
        if (route == null) {
            return;
        }
        Territory attackingFrom = route.getTerritoryBeforeEnd();
        Collection<Unit> attackingFromMapUnits = this.m_attackingFromMap.get(attackingFrom);
        if (attackingFromMapUnits == null) {
            attackingFromMapUnits = new ArrayList<Unit>();
        }
        attackingFromMapUnits.removeAll(units);
        if (attackingFromMapUnits.isEmpty()) {
            this.m_attackingFrom.remove(attackingFrom);
        }
        if (attackingFrom.isWater()) {
            if (route.getEnd() != null && !route.getEnd().isWater() && Match.someMatch(units, Matches.UnitIsLand)) {
                this.m_amphibiousLandAttackers.removeAll(Match.getMatches(units, Matches.UnitIsLand));
            }
            if (Match.noneMatch(attackingFromMapUnits, Matches.UnitIsLand)) {
                this.m_amphibiousAttackFrom.remove(attackingFrom);
                this.m_isAmphibious = !this.m_amphibiousAttackFrom.isEmpty();
            }
        }
        for (Unit dependence : this.m_dependentUnits.keySet()) {
            Collection dependent = (Collection)this.m_dependentUnits.get(dependence);
            dependent.removeAll(units);
        }
    }

    @Override
    public void unitsLostInPrecedingBattle(IBattle battle, Collection<Unit> units, IDelegateBridge bridge, boolean withdrawn) {
        Collection<Unit> lost = this.getDependentUnits(units);
        lost.addAll(Util.intersection(units, this.m_attackingUnits));
        if (lost.size() != 0) {
            this.m_attackingUnits.removeAll(lost);
            if (this.m_attackingUnits.isEmpty()) {
                IntegerMap<UnitType> costs = BattleCalculator.getCostsForTUV(this.m_attacker, this.m_data);
                int tuvLostAttacker = withdrawn ? 0 : BattleCalculator.getTUV(lost, this.m_attacker, costs, this.m_data);
                this.m_attackerLostTUV += tuvLostAttacker;
                this.m_whoWon = IBattle.WhoWon.DEFENDER;
                if (!this.m_headless) {
                    this.m_battleTracker.getBattleRecords(this.m_data).addResultToBattle(this.m_attacker, this.m_battleID, this.m_defender, this.m_attackerLostTUV, this.m_defenderLostTUV, BattleRecord.BattleResultDescription.LOST, new BattleResults(this, this.m_data), 0);
                }
                this.m_battleTracker.removeBattle(this);
            }
        }
    }

    public Collection<Territory> getAmphibiousAttackTerritories() {
        return this.m_amphibiousAttackFrom;
    }

    public Collection<Territory> getAttackingFrom() {
        return this.m_attackingFrom;
    }

    public Map<Territory, Collection<Unit>> getAttackingFromMap() {
        return this.m_attackingFromMap;
    }
}

