/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.triplea.Properties;
import games.strategy.triplea.delegate.NoAirCheckPlaceDelegate;
import java.util.HashSet;
import java.util.Set;

public class GameStepPropertiesHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSkipPosting(GameData data) {
        boolean skipPosting;
        data.acquireReadLock();
        try {
            skipPosting = Boolean.parseBoolean(data.getSequence().getStep().getProperties().getProperty("skipPosting", "false"));
        }
        finally {
            data.releaseReadLock();
        }
        return skipPosting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<PlayerID> getTurnSummaryPlayers(GameData data) {
        HashSet<PlayerID> allowedIDs;
        data.acquireReadLock();
        try {
            String allowedPlayers = data.getSequence().getStep().getProperties().getProperty("turnSummaryPlayers");
            if (allowedPlayers != null) {
                allowedIDs = new HashSet<PlayerID>();
                for (String p : allowedPlayers.split(":")) {
                    PlayerID id = data.getPlayerList().getPlayerID(p);
                    if (id == null) {
                        System.err.println("gamePlay sequence step: " + data.getSequence().getStep().getName() + " stepProperty: " + "turnSummaryPlayers" + " player: " + p + " DOES NOT EXIST");
                        continue;
                    }
                    allowedIDs.add(id);
                }
            } else {
                allowedIDs = null;
            }
        }
        finally {
            data.releaseReadLock();
        }
        return allowedIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAirborneMove(GameData data) {
        boolean isAirborneMove;
        data.acquireReadLock();
        try {
            String prop = data.getSequence().getStep().getProperties().getProperty("airborneMove");
            isAirborneMove = prop != null ? Boolean.parseBoolean(prop) : GameStepPropertiesHelper.isAirborneDelegate(data);
        }
        finally {
            data.releaseReadLock();
        }
        return isAirborneMove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCombatMove(GameData data, boolean doNotThrowErrorIfNotMoveDelegate) {
        boolean isCombatMove;
        block7: {
            data.acquireReadLock();
            try {
                String prop = data.getSequence().getStep().getProperties().getProperty("combatMove");
                if (prop != null) {
                    isCombatMove = Boolean.parseBoolean(prop);
                    break block7;
                }
                if (GameStepPropertiesHelper.isCombatDelegate(data)) {
                    isCombatMove = true;
                    break block7;
                }
                if (GameStepPropertiesHelper.isNonCombatDelegate(data)) {
                    isCombatMove = false;
                    break block7;
                }
                if (doNotThrowErrorIfNotMoveDelegate) {
                    isCombatMove = false;
                    break block7;
                }
                throw new IllegalStateException("Cannot determine combat or not: " + data.getSequence().getStep().getName());
            }
            finally {
                data.releaseReadLock();
            }
        }
        return isCombatMove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isNonCombatMove(GameData data, boolean doNotThrowErrorIfNotMoveDelegate) {
        boolean isNonCombatMove;
        block7: {
            data.acquireReadLock();
            try {
                String prop = data.getSequence().getStep().getProperties().getProperty("nonCombatMove");
                if (prop != null) {
                    isNonCombatMove = Boolean.parseBoolean(prop);
                    break block7;
                }
                if (GameStepPropertiesHelper.isNonCombatDelegate(data)) {
                    isNonCombatMove = true;
                    break block7;
                }
                if (GameStepPropertiesHelper.isCombatDelegate(data)) {
                    isNonCombatMove = false;
                    break block7;
                }
                if (doNotThrowErrorIfNotMoveDelegate) {
                    isNonCombatMove = false;
                    break block7;
                }
                throw new IllegalStateException("Cannot determine combat or not: " + data.getSequence().getStep().getName());
            }
            finally {
                data.releaseReadLock();
            }
        }
        return isNonCombatMove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFireRockets(GameData data) {
        boolean isFireRockets;
        data.acquireReadLock();
        try {
            String prop = data.getSequence().getStep().getProperties().getProperty("fireRockets");
            isFireRockets = prop != null ? Boolean.parseBoolean(prop) : (Properties.getWW2V2(data) || Properties.getWW2V3(data) ? GameStepPropertiesHelper.isCombatDelegate(data) : GameStepPropertiesHelper.isNonCombatDelegate(data));
        }
        finally {
            data.releaseReadLock();
        }
        return isFireRockets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRepairUnits(GameData data) {
        boolean isRepairUnits;
        data.acquireReadLock();
        try {
            String prop;
            boolean repairAtStartAndOnlyOwn = Properties.getBattleshipsRepairAtBeginningOfRound(data);
            boolean repairAtEndAndAll = Properties.getBattleshipsRepairAtEndOfRound(data);
            isRepairUnits = !repairAtStartAndOnlyOwn && !repairAtEndAndAll ? false : ((prop = data.getSequence().getStep().getProperties().getProperty("repairUnits")) != null ? Boolean.parseBoolean(prop) : (GameStepPropertiesHelper.isCombatDelegate(data) && repairAtStartAndOnlyOwn ? true : data.getSequence().getStep().getName().endsWith("EndTurn") && repairAtEndAndAll));
        }
        finally {
            data.releaseReadLock();
        }
        return isRepairUnits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isGiveBonusMovement(GameData data) {
        boolean isBonus;
        data.acquireReadLock();
        try {
            String prop = data.getSequence().getStep().getProperties().getProperty("giveBonusMovement");
            isBonus = prop != null ? Boolean.parseBoolean(prop) : GameStepPropertiesHelper.isCombatDelegate(data);
        }
        finally {
            data.releaseReadLock();
        }
        return isBonus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRemoveAirThatCanNotLand(GameData data) {
        boolean isRemoveAir;
        data.acquireReadLock();
        try {
            String prop = data.getSequence().getStep().getProperties().getProperty("removeAirThatCanNotLand");
            isRemoveAir = prop != null ? Boolean.parseBoolean(prop) : (data.getSequence().getStep().getDelegate() != null && NoAirCheckPlaceDelegate.class.equals(data.getSequence().getStep().getDelegate().getClass()) ? false : (GameStepPropertiesHelper.isNonCombatDelegate(data) ? true : data.getSequence().getStep().getName().endsWith("Place")));
        }
        finally {
            data.releaseReadLock();
        }
        return isRemoveAir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<PlayerID> getCombinedTurns(GameData data, PlayerID player) {
        HashSet<PlayerID> allowedIDs = new HashSet<PlayerID>();
        data.acquireReadLock();
        try {
            String allowedPlayers = data.getSequence().getStep().getProperties().getProperty("combinedTurns");
            if (player != null) {
                allowedIDs.add(player);
            }
            if (allowedPlayers != null) {
                for (String p : allowedPlayers.split(":")) {
                    PlayerID id = data.getPlayerList().getPlayerID(p);
                    if (id == null) {
                        System.err.println("gamePlay sequence step: " + data.getSequence().getStep().getName() + " stepProperty: " + "combinedTurns" + " player: " + p + " DOES NOT EXIST");
                        continue;
                    }
                    allowedIDs.add(id);
                }
            }
        }
        finally {
            data.releaseReadLock();
        }
        return allowedIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isResetUnitStateAtStart(GameData data) {
        boolean isReset;
        data.acquireReadLock();
        try {
            String prop = data.getSequence().getStep().getProperties().getProperty("resetUnitStateAtStart");
            isReset = prop != null ? Boolean.parseBoolean(prop) : false;
        }
        finally {
            data.releaseReadLock();
        }
        return isReset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isResetUnitStateAtEnd(GameData data) {
        boolean isReset;
        data.acquireReadLock();
        try {
            String prop = data.getSequence().getStep().getProperties().getProperty("resetUnitStateAtEnd");
            isReset = prop != null ? Boolean.parseBoolean(prop) : GameStepPropertiesHelper.isNonCombatDelegate(data);
        }
        finally {
            data.releaseReadLock();
        }
        return isReset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBid(GameData data) {
        boolean isBid;
        data.acquireReadLock();
        try {
            String prop = data.getSequence().getStep().getProperties().getProperty("bid");
            isBid = prop != null ? Boolean.parseBoolean(prop) : (GameStepPropertiesHelper.isBidPurchaseDelegate(data) ? true : GameStepPropertiesHelper.isBidPlaceDelegate(data));
        }
        finally {
            data.releaseReadLock();
        }
        return isBid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<PlayerID> getRepairPlayers(GameData data, PlayerID player) {
        HashSet<PlayerID> allowedIDs = new HashSet<PlayerID>();
        data.acquireReadLock();
        try {
            String allowedPlayers = data.getSequence().getStep().getProperties().getProperty("repairPlayers");
            if (player != null) {
                allowedIDs.add(player);
            }
            if (allowedPlayers != null) {
                for (String p : allowedPlayers.split(":")) {
                    PlayerID id = data.getPlayerList().getPlayerID(p);
                    if (id == null) {
                        System.err.println("gamePlay sequence step: " + data.getSequence().getStep().getName() + " stepProperty: " + "repairPlayers" + " player: " + p + " DOES NOT EXIST");
                        continue;
                    }
                    allowedIDs.add(id);
                }
            }
        }
        finally {
            data.releaseReadLock();
        }
        return allowedIDs;
    }

    private static boolean isNonCombatDelegate(GameData data) {
        return data.getSequence().getStep().getName().endsWith("NonCombatMove");
    }

    private static boolean isCombatDelegate(GameData data) {
        if (data.getSequence().getStep().getName().endsWith("NonCombatMove")) {
            return false;
        }
        return data.getSequence().getStep().getName().endsWith("CombatMove");
    }

    private static boolean isAirborneDelegate(GameData data) {
        return data.getSequence().getStep().getName().endsWith("AirborneCombatMove");
    }

    private static boolean isBidPurchaseDelegate(GameData data) {
        return data.getSequence().getStep().getName().endsWith("Bid");
    }

    private static boolean isBidPlaceDelegate(GameData data) {
        return data.getSequence().getStep().getName().endsWith("BidPlace");
    }
}

