/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.common.delegate.BaseTripleADelegate;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameStep;
import games.strategy.engine.data.NamedAttachable;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionFrontier;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.engine.message.IRemote;
import games.strategy.triplea.Properties;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.BidPlaceDelegate;
import games.strategy.triplea.delegate.BidPurchaseDelegate;
import games.strategy.triplea.delegate.InitializationExtendedDelegateState;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.MoveDelegate;
import games.strategy.triplea.delegate.OriginalOwnerTracker;
import games.strategy.triplea.delegate.TechAdvance;
import games.strategy.triplea.delegate.TechTracker;
import games.strategy.triplea.delegate.TransportTracker;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class InitializationDelegate
extends BaseTripleADelegate {
    private boolean m_needToInitialize = true;

    @Override
    public void initialize(String name, String displayName) {
        this.m_name = name;
        this.m_displayName = displayName;
    }

    @Override
    public void start() {
        super.start();
        if (this.m_needToInitialize) {
            this.init(this.m_bridge);
            this.m_needToInitialize = false;
        }
    }

    @Override
    public void end() {
        super.end();
    }

    @Override
    public Serializable saveState() {
        InitializationExtendedDelegateState state = new InitializationExtendedDelegateState();
        state.superState = super.saveState();
        state.m_needToInitialize = this.m_needToInitialize;
        return state;
    }

    @Override
    public void loadState(Serializable state) {
        InitializationExtendedDelegateState s = (InitializationExtendedDelegateState)state;
        super.loadState(s.superState);
        this.m_needToInitialize = s.m_needToInitialize;
    }

    @Override
    public boolean delegateCurrentlyRequiresUserInput() {
        return false;
    }

    protected void init(IDelegateBridge aBridge) {
        this.initDestroyerArtillery(aBridge);
        this.initShipyards(aBridge);
        this.initTwoHitBattleship(aBridge);
        this.initOriginalOwner(aBridge);
        this.initTech(aBridge);
        this.initSkipUnusedBids(aBridge.getData());
        this.initDeleteAssetsOfDisabledPlayers(aBridge);
        this.initTransportedLandUnits(aBridge);
        this.resetUnitState(aBridge);
    }

    private void resetUnitState(IDelegateBridge aBridge) {
        Change change = MoveDelegate.getResetUnitStateChange(this.getData());
        if (!change.isEmpty()) {
            this.m_bridge.getHistoryWriter().startEvent("Cleaning up unit state.");
            this.m_bridge.addChange(change);
        }
    }

    private void initTransportedLandUnits(IDelegateBridge aBridge) {
        GameData data = aBridge.getData();
        boolean historyItemCreated = false;
        for (Territory current : data.getMap().getTerritories()) {
            Collection<Unit> units;
            if (!current.isWater() || (units = current.getUnits().getUnits()).size() == 0 || !Match.someMatch(units, Matches.UnitIsLand)) continue;
            List<Unit> transports = Match.getMatches(units, Matches.UnitIsTransport);
            List<Unit> land = Match.getMatches(units, Matches.UnitIsLand);
            for (Unit toLoad : land) {
                UnitAttachment ua = UnitAttachment.get(toLoad.getType());
                int cost = ua.getTransportCost();
                if (cost == -1) {
                    throw new IllegalStateException("Non transportable unit in sea");
                }
                Iterator transportIter = transports.iterator();
                boolean found = false;
                while (transportIter.hasNext()) {
                    Unit transport = (Unit)transportIter.next();
                    int capacity = TransportTracker.getAvailableCapacity(transport);
                    if (capacity < cost) continue;
                    if (!historyItemCreated) {
                        aBridge.getHistoryWriter().startEvent("Initializing Units in Transports");
                        historyItemCreated = true;
                    }
                    try {
                        aBridge.addChange(TransportTracker.loadTransportChange((TripleAUnit)transport, toLoad));
                    }
                    catch (IllegalStateException e) {
                        System.err.println("You can only edit add transports+units after the initialization delegate of the game is finished.  If this error came up and you have not used Edit Mode to add units + transports, then please report this as a bug:  \r\n" + e.getMessage());
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                throw new IllegalStateException("Cannot load all land units in sea transports. Please make sure you have enough transports. You may need to re-order the xml's placement of transports and land units, as the engine will try to fill them in the order they are given.");
            }
        }
    }

    private void initDeleteAssetsOfDisabledPlayers(IDelegateBridge aBridge) {
        GameData data = aBridge.getData();
        if (!Properties.getDisabledPlayersAssetsDeleted(data)) {
            return;
        }
        for (PlayerID player : data.getPlayerList().getPlayers()) {
            if (player.isNull() || !player.getIsDisabled()) continue;
            CompositeChange change = new CompositeChange();
            for (Resource r : player.getResources().getResourcesCopy().keySet()) {
                int deleted = player.getResources().getQuantity(r);
                if (deleted == 0) continue;
                change.add(ChangeFactory.changeResourcesChange(player, r, -deleted));
            }
            Collection<Unit> heldUnits = player.getUnits().getUnits();
            if (!heldUnits.isEmpty()) {
                change.add(ChangeFactory.removeUnits(player, heldUnits));
            }
            Match<Unit> owned = Matches.unitIsOwnedBy(player);
            for (Territory t : data.getMap().getTerritories()) {
                List<Unit> terrUnits = t.getUnits().getMatches(owned);
                if (terrUnits.isEmpty()) continue;
                change.add(ChangeFactory.removeUnits(t, terrUnits));
            }
            if (change.isEmpty()) continue;
            aBridge.getHistoryWriter().startEvent("Remove all resources and units from: " + player.getName());
            aBridge.addChange(change);
        }
    }

    private void initSkipUnusedBids(GameData data) {
        for (GameStep step : data.getSequence()) {
            if (!(step.getDelegate() instanceof BidPlaceDelegate) && !(step.getDelegate() instanceof BidPurchaseDelegate) || BidPurchaseDelegate.doesPlayerHaveBid(data, step.getPlayerID())) continue;
            step.setMaxRunCount(0);
        }
    }

    private void initTech(IDelegateBridge bridge) {
        GameData data = bridge.getData();
        for (PlayerID player : data.getPlayerList().getPlayers()) {
            Iterator<TechAdvance> advances = TechTracker.getCurrentTechAdvances(player, data).iterator();
            if (!advances.hasNext()) continue;
            bridge.getHistoryWriter().startEvent("Initializing " + player.getName() + " with tech advances");
            while (advances.hasNext()) {
                TechAdvance advance = advances.next();
                advance.perform(player, bridge);
            }
        }
    }

    private void initDestroyerArtillery(IDelegateBridge aBridge) {
        GameData data = aBridge.getData();
        boolean addArtilleryAndDestroyers = Properties.getUse_Destroyers_And_Artillery(data);
        if (!this.isWW2V2(data) && addArtilleryAndDestroyers) {
            CompositeChange change = new CompositeChange();
            ProductionRule artillery = data.getProductionRuleList().getProductionRule("buyArtillery");
            ProductionRule destroyer = data.getProductionRuleList().getProductionRule("buyDestroyer");
            ProductionFrontier frontier = data.getProductionFrontierList().getProductionFrontier("production");
            if (artillery != null && !frontier.getRules().contains(artillery)) {
                change.add(ChangeFactory.addProductionRule(artillery, frontier));
            }
            if (destroyer != null && !frontier.getRules().contains(destroyer)) {
                change.add(ChangeFactory.addProductionRule(destroyer, frontier));
            }
            ProductionRule artilleryIT = data.getProductionRuleList().getProductionRule("buyArtilleryIndustrialTechnology");
            ProductionRule destroyerIT = data.getProductionRuleList().getProductionRule("buyDestroyerIndustrialTechnology");
            ProductionFrontier frontierIT = data.getProductionFrontierList().getProductionFrontier("productionIndustrialTechnology");
            if (artilleryIT != null && !frontierIT.getRules().contains(artilleryIT)) {
                change.add(ChangeFactory.addProductionRule(artilleryIT, frontierIT));
            }
            if (destroyerIT != null && !frontierIT.getRules().contains(destroyerIT)) {
                change.add(ChangeFactory.addProductionRule(destroyerIT, frontierIT));
            }
            if (!change.isEmpty()) {
                aBridge.getHistoryWriter().startEvent("Adding destroyers and artillery production rules");
                aBridge.addChange(change);
            }
        }
    }

    private void initShipyards(IDelegateBridge aBridge) {
        GameData data = aBridge.getData();
        boolean useShipyards = Properties.getUse_Shipyards(data);
        if (useShipyards) {
            CompositeChange change = new CompositeChange();
            ProductionFrontier frontierShipyards = data.getProductionFrontierList().getProductionFrontier("productionShipyards");
            ProductionFrontier frontierNONShipyards = data.getProductionFrontierList().getProductionFrontier("production");
            List<ProductionRule> rules = frontierNONShipyards.getRules();
            for (ProductionRule rule : rules) {
                UnitType unit;
                boolean isSea;
                String ruleName = rule.getName();
                IntegerMap<NamedAttachable> ruleResults = rule.getResults();
                NamedAttachable named = ruleResults.keySet().iterator().next();
                if (!(named instanceof UnitType) || (isSea = UnitAttachment.get(unit = data.getUnitTypeList().getUnitType(named.getName())).getIsSea())) continue;
                ProductionRule prodRule = data.getProductionRuleList().getProductionRule(ruleName);
                change.add(ChangeFactory.addProductionRule(prodRule, frontierShipyards));
            }
            aBridge.getHistoryWriter().startEvent("Adding shipyard production rules - land/air units");
            aBridge.addChange(change);
        }
    }

    private boolean isWW2V2(GameData data) {
        return Properties.getWW2V2(data);
    }

    private void initTwoHitBattleship(IDelegateBridge aBridge) {
        boolean defaultEnabled;
        GameData data = aBridge.getData();
        boolean userEnabled = Properties.getTwoHitBattleships(data);
        UnitType battleShipUnit = data.getUnitTypeList().getUnitType("battleship");
        if (battleShipUnit == null) {
            return;
        }
        UnitAttachment battleShipAttachment = UnitAttachment.get(battleShipUnit);
        boolean bl = defaultEnabled = battleShipAttachment.getHitPoints() > 1;
        if (userEnabled != defaultEnabled) {
            aBridge.getHistoryWriter().startEvent("TwoHitBattleships:" + userEnabled);
            aBridge.addChange(ChangeFactory.attachmentPropertyChange(battleShipAttachment, userEnabled ? 2 : 1, "hitPoints"));
        }
    }

    private void initOriginalOwner(IDelegateBridge aBridge) {
        GameData data = aBridge.getData();
        CompositeChange changes = new CompositeChange();
        for (Territory current : data.getMap()) {
            TerritoryAttachment territoryAttachment;
            if (!current.getOwner().isNull()) {
                territoryAttachment = TerritoryAttachment.get(current);
                if (territoryAttachment == null) {
                    throw new IllegalStateException("No territory attachment for " + current);
                }
                if (territoryAttachment.getOriginalOwner() == null && current.getOwner() != null) {
                    changes.add(OriginalOwnerTracker.addOriginalOwnerChange(current, current.getOwner()));
                }
                List<Unit> factoryAndInfrastructure = current.getUnits().getMatches(Matches.UnitIsInfrastructure);
                changes.add(OriginalOwnerTracker.addOriginalOwnerChange(factoryAndInfrastructure, current.getOwner()));
                continue;
            }
            if (current.isWater() || (territoryAttachment = TerritoryAttachment.get(current)) != null) continue;
            throw new IllegalStateException("No territory attachment for " + current);
        }
        aBridge.getHistoryWriter().startEvent("Adding original owners");
        aBridge.addChange(changes);
    }

    @Override
    public Class<? extends IRemote> getRemoteType() {
        return null;
    }
}

