/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.common.delegate.GameDelegateBridge;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.triplea.Properties;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.attatchments.AbstractTriggerAttachment;
import games.strategy.triplea.attatchments.ICondition;
import games.strategy.triplea.attatchments.TriggerAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.AAInMoveUtil;
import games.strategy.triplea.delegate.AbstractMoveDelegate;
import games.strategy.triplea.delegate.AirThatCantLandUtil;
import games.strategy.triplea.delegate.GameStepPropertiesHelper;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.MoveExtendedDelegateState;
import games.strategy.triplea.delegate.MovePerformer;
import games.strategy.triplea.delegate.MoveValidator;
import games.strategy.triplea.delegate.MustFightBattle;
import games.strategy.triplea.delegate.RocketsFireHelper;
import games.strategy.triplea.delegate.TechTracker;
import games.strategy.triplea.delegate.TransportTracker;
import games.strategy.triplea.delegate.UndoableMove;
import games.strategy.triplea.delegate.dataObjects.MoveValidationResult;
import games.strategy.triplea.delegate.remote.IMoveDelegate;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.triplea.util.UnitCategory;
import games.strategy.triplea.util.UnitSeperator;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.CompositeMatchOr;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import games.strategy.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MoveDelegate
extends AbstractMoveDelegate
implements IMoveDelegate {
    public static String CLEANING_UP_DURING_MOVEMENT_PHASE = "Cleaning up during movement phase";
    private boolean m_needToInitialize = true;
    private boolean m_needToDoRockets = true;
    private IntegerMap<Territory> m_PUsLost = new IntegerMap();

    @Override
    public void setDelegateBridgeAndPlayer(IDelegateBridge iDelegateBridge) {
        super.setDelegateBridgeAndPlayer(new GameDelegateBridge(iDelegateBridge));
    }

    @Override
    public void start() {
        super.start();
        GameData data = this.getData();
        if (this.m_needToInitialize) {
            HashSet<TriggerAttachment> toFireAfterBonus;
            HashSet<TriggerAttachment> toFirePossible;
            HashMap<ICondition, Boolean> testedConditions = null;
            CompositeMatchAnd<TriggerAttachment> moveCombatDelegateBeforeBonusTriggerMatch = new CompositeMatchAnd<TriggerAttachment>(AbstractTriggerAttachment.availableUses, AbstractTriggerAttachment.whenOrDefaultMatch(null, null), new CompositeMatchOr(AbstractTriggerAttachment.notificationMatch(), TriggerAttachment.playerPropertyMatch(), TriggerAttachment.relationshipTypePropertyMatch(), TriggerAttachment.territoryPropertyMatch(), TriggerAttachment.territoryEffectPropertyMatch(), TriggerAttachment.removeUnitsMatch(), TriggerAttachment.changeOwnershipMatch()));
            CompositeMatchAnd<TriggerAttachment> moveCombatDelegateAfterBonusTriggerMatch = new CompositeMatchAnd<TriggerAttachment>(AbstractTriggerAttachment.availableUses, AbstractTriggerAttachment.whenOrDefaultMatch(null, null), new CompositeMatchOr(TriggerAttachment.placeMatch()));
            CompositeMatchOr<TriggerAttachment> moveCombatDelegateAllTriggerMatch = new CompositeMatchOr<TriggerAttachment>(moveCombatDelegateBeforeBonusTriggerMatch, moveCombatDelegateAfterBonusTriggerMatch);
            if (GameStepPropertiesHelper.isCombatMove(data, false) && Properties.getTriggers(data) && !(toFirePossible = TriggerAttachment.collectForAllTriggersMatching(new HashSet<PlayerID>(Collections.singleton(this.m_player)), moveCombatDelegateAllTriggerMatch, this.m_bridge)).isEmpty()) {
                testedConditions = TriggerAttachment.collectTestsForAllTriggers(toFirePossible, this.m_bridge);
                HashSet<TriggerAttachment> toFireBeforeBonus = TriggerAttachment.collectForAllTriggersMatching(new HashSet<PlayerID>(Collections.singleton(this.m_player)), moveCombatDelegateBeforeBonusTriggerMatch, this.m_bridge);
                if (!toFireBeforeBonus.isEmpty()) {
                    HashSet<TriggerAttachment> toFireTestedAndSatisfied = new HashSet<TriggerAttachment>(Match.getMatches(toFireBeforeBonus, AbstractTriggerAttachment.isSatisfiedMatch(testedConditions)));
                    TriggerAttachment.triggerNotifications(toFireTestedAndSatisfied, this.m_bridge, null, null, true, true, true, true);
                    TriggerAttachment.triggerPlayerPropertyChange(toFireTestedAndSatisfied, this.m_bridge, null, null, true, true, true, true);
                    TriggerAttachment.triggerRelationshipTypePropertyChange(toFireTestedAndSatisfied, this.m_bridge, null, null, true, true, true, true);
                    TriggerAttachment.triggerTerritoryPropertyChange(toFireTestedAndSatisfied, this.m_bridge, null, null, true, true, true, true);
                    TriggerAttachment.triggerTerritoryEffectPropertyChange(toFireTestedAndSatisfied, this.m_bridge, null, null, true, true, true, true);
                    TriggerAttachment.triggerChangeOwnership(toFireTestedAndSatisfied, this.m_bridge, null, null, true, true, true, true);
                    TriggerAttachment.triggerUnitRemoval(toFireTestedAndSatisfied, this.m_bridge, null, null, true, true, true, true);
                }
            }
            if (GameStepPropertiesHelper.isRepairUnits(data)) {
                MoveDelegate.repairMultipleHitPointUnits(this.m_bridge, this.m_player);
            }
            if (GameStepPropertiesHelper.isGiveBonusMovement(data)) {
                this.resetAndGiveBonusMovement();
            }
            this.removeMovementFromAirOnDamagedAlliedCarriers(this.m_bridge, this.m_player);
            if (GameStepPropertiesHelper.isCombatMove(data, false) && Properties.getTriggers(data) && !(toFireAfterBonus = TriggerAttachment.collectForAllTriggersMatching(new HashSet<PlayerID>(Collections.singleton(this.m_player)), moveCombatDelegateAfterBonusTriggerMatch, this.m_bridge)).isEmpty()) {
                HashSet<TriggerAttachment> toFireTestedAndSatisfied = new HashSet<TriggerAttachment>(Match.getMatches(toFireAfterBonus, AbstractTriggerAttachment.isSatisfiedMatch(testedConditions)));
                TriggerAttachment.triggerUnitPlacement(toFireTestedAndSatisfied, this.m_bridge, null, null, true, true, true, true);
            }
            if (GameStepPropertiesHelper.isResetUnitStateAtStart(data)) {
                this.resetUnitStateAndDelegateState();
            }
            this.m_needToInitialize = false;
        }
    }

    private void resetAndGiveBonusMovement() {
        boolean addedHistoryEvent = false;
        Change changeReset = this.resetBonusMovement();
        if (!changeReset.isEmpty()) {
            this.m_bridge.getHistoryWriter().startEvent("Resetting and Giving Bonus Movement to Units");
            this.m_bridge.addChange(changeReset);
            addedHistoryEvent = true;
        }
        Change changeBonus = null;
        if (Properties.getUnitsMayGiveBonusMovement(this.getData())) {
            changeBonus = this.giveBonusMovement(this.m_bridge, this.m_player);
        }
        if (changeBonus != null && !changeBonus.isEmpty()) {
            if (!addedHistoryEvent) {
                this.m_bridge.getHistoryWriter().startEvent("Resetting and Giving Bonus Movement to Units");
            }
            this.m_bridge.addChange(changeBonus);
        }
    }

    @Override
    public void end() {
        super.end();
        GameData data = this.getData();
        if (GameStepPropertiesHelper.isRemoveAirThatCanNotLand(data)) {
            this.removeAirThatCantLand();
        }
        if (GameStepPropertiesHelper.isFireRockets(data) && this.m_needToDoRockets && TechTracker.hasRocket(this.m_bridge.getPlayerID())) {
            RocketsFireHelper helper = new RocketsFireHelper();
            helper.fireRockets(this.m_bridge, this.m_bridge.getPlayerID());
            this.m_needToDoRockets = false;
        }
        if (GameStepPropertiesHelper.isResetUnitStateAtEnd(data)) {
            this.resetUnitStateAndDelegateState();
        }
        this.m_needToInitialize = true;
        this.m_needToDoRockets = true;
    }

    @Override
    public Serializable saveState() {
        return this.saveState(true);
    }

    private Serializable saveState(boolean saveUndo) {
        MoveExtendedDelegateState state = new MoveExtendedDelegateState();
        state.superState = super.saveState();
        state.m_needToInitialize = this.m_needToInitialize;
        state.m_needToDoRockets = this.m_needToDoRockets;
        state.m_PUsLost = this.m_PUsLost;
        return state;
    }

    @Override
    public void loadState(Serializable state) {
        MoveExtendedDelegateState s = (MoveExtendedDelegateState)state;
        super.loadState(s.superState);
        this.m_needToInitialize = s.m_needToInitialize;
        this.m_needToDoRockets = s.m_needToDoRockets;
        this.m_PUsLost = s.m_PUsLost;
    }

    @Override
    public boolean delegateCurrentlyRequiresUserInput() {
        CompositeMatchAnd<Unit> moveableUnitOwnedByMe = new CompositeMatchAnd<Unit>(new Match[0]);
        moveableUnitOwnedByMe.add(Matches.unitIsOwnedBy(this.m_player));
        moveableUnitOwnedByMe.add(new CompositeMatchOr(Matches.unitHasMovementLeft, new CompositeMatchAnd(Matches.UnitIsLand, Matches.unitIsBeingTransported())));
        if (GameStepPropertiesHelper.isCombatMove(this.getData(), false)) {
            moveableUnitOwnedByMe.add(Matches.UnitCanNotMoveDuringCombatMove.invert());
        }
        for (Territory item : this.getData().getMap().getTerritories()) {
            if (!item.getUnits().someMatch(moveableUnitOwnedByMe)) continue;
            return true;
        }
        return false;
    }

    private Change resetBonusMovement() {
        GameData data = this.getData();
        CompositeChange change = new CompositeChange();
        for (Unit u : data.getUnits()) {
            if (TripleAUnit.get(u).getBonusMovement() == 0) continue;
            change.add(ChangeFactory.unitPropertyChange(u, 0, "bonusMovement"));
        }
        return change;
    }

    private void resetUnitStateAndDelegateState() {
        this.m_PUsLost.clear();
        Change change = MoveDelegate.getResetUnitStateChange(this.getData());
        if (!change.isEmpty()) {
            this.m_bridge.getHistoryWriter().startEvent(CLEANING_UP_DURING_MOVEMENT_PHASE);
            this.m_bridge.addChange(change);
        }
    }

    public static Change getResetUnitStateChange(GameData data) {
        CompositeChange change = new CompositeChange();
        for (Unit u : data.getUnits()) {
            TripleAUnit taUnit = TripleAUnit.get(u);
            if (taUnit.getAlreadyMoved() != 0) {
                change.add(ChangeFactory.unitPropertyChange(u, 0, "alreadyMoved"));
            }
            if (taUnit.getWasInCombat()) {
                change.add(ChangeFactory.unitPropertyChange(u, false, "wasInCombat"));
            }
            if (taUnit.getSubmerged()) {
                change.add(ChangeFactory.unitPropertyChange(u, false, "submerged"));
            }
            if (taUnit.getAirborne()) {
                change.add(ChangeFactory.unitPropertyChange(u, false, "airborne"));
            }
            if (taUnit.getLaunched() != 0) {
                change.add(ChangeFactory.unitPropertyChange(u, 0, "launched"));
            }
            if (!taUnit.getUnloaded().isEmpty()) {
                change.add(ChangeFactory.unitPropertyChange(u, Collections.EMPTY_LIST, "unloaded"));
            }
            if (taUnit.getWasLoadedThisTurn()) {
                change.add(ChangeFactory.unitPropertyChange(u, Boolean.FALSE, "wasLoadedThisTurn"));
            }
            if (taUnit.getUnloadedTo() != null) {
                change.add(ChangeFactory.unitPropertyChange(u, null, "unloadedTo"));
            }
            if (taUnit.getWasUnloadedInCombatPhase()) {
                change.add(ChangeFactory.unitPropertyChange(u, Boolean.FALSE, "wasUnloadedInCombatPhase"));
            }
            if (!taUnit.getWasAmphibious()) continue;
            change.add(ChangeFactory.unitPropertyChange(u, Boolean.FALSE, "wasAmphibious"));
        }
        return change;
    }

    private void removeMovementFromAirOnDamagedAlliedCarriers(IDelegateBridge aBridge, PlayerID player) {
        GameData data = aBridge.getData();
        CompositeMatchAnd crippledAlliedCarriersMatch = new CompositeMatchAnd(Matches.isUnitAllied(player, data), Matches.unitIsOwnedBy(player).invert(), Matches.UnitIsCarrier, Matches.UnitHasWhenCombatDamagedEffect("unitsMayNotLeaveAlliedCarrier"));
        CompositeMatchAnd<Unit> ownedFightersMatch = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsAir, Matches.UnitCanLandOnCarrier, Matches.unitHasMovementLeft);
        CompositeChange change = new CompositeChange();
        for (Territory t : data.getMap().getTerritories()) {
            List<Unit> crippledAlliedCarriers;
            List<Unit> ownedFighters = t.getUnits().getMatches(ownedFightersMatch);
            if (ownedFighters.isEmpty() || (crippledAlliedCarriers = Match.getMatches(t.getUnits().getUnits(), crippledAlliedCarriersMatch)).isEmpty()) continue;
            for (Unit fighter : ownedFighters) {
                TripleAUnit taUnit = (TripleAUnit)fighter;
                if (taUnit.getTransportedBy() == null || !crippledAlliedCarriers.contains(taUnit.getTransportedBy())) continue;
                change.add(ChangeFactory.markNoMovementChange(fighter));
            }
        }
        if (!change.isEmpty()) {
            aBridge.addChange(change);
        }
    }

    private Change giveBonusMovement(IDelegateBridge aBridge, PlayerID player) {
        GameData data = aBridge.getData();
        CompositeChange change = new CompositeChange();
        for (Territory t : data.getMap().getTerritories()) {
            for (Unit u : t.getUnits().getUnits()) {
                ArrayList<Territory> neighbors;
                if (!Matches.UnitCanBeGivenBonusMovementByFacilitiesInItsTerritory(t, player, data).match(u) || !Matches.isUnitAllied(player, data).match(u)) continue;
                int bonusMovement = Integer.MIN_VALUE;
                ArrayList<Unit> givesBonusUnits = new ArrayList<Unit>();
                CompositeMatchAnd givesBonusUnit = new CompositeMatchAnd(Matches.alliedUnit(player, data), Matches.UnitCanGiveBonusMovementToThisUnit(u));
                givesBonusUnits.addAll(Match.getMatches(t.getUnits().getUnits(), givesBonusUnit));
                if (Matches.UnitIsSea.match(u)) {
                    CompositeMatchAnd givesBonusUnitLand = new CompositeMatchAnd(givesBonusUnit, Matches.UnitIsLand);
                    neighbors = new ArrayList<Territory>(data.getMap().getNeighbors(t, Matches.TerritoryIsLand));
                    for (Territory current : neighbors) {
                        givesBonusUnits.addAll(Match.getMatches(current.getUnits().getUnits(), givesBonusUnitLand));
                    }
                } else if (Matches.UnitIsLand.match(u)) {
                    CompositeMatchAnd givesBonusUnitSea = new CompositeMatchAnd(givesBonusUnit, Matches.UnitIsSea);
                    neighbors = new ArrayList<Territory>(data.getMap().getNeighbors(t, Matches.TerritoryIsWater));
                    for (Territory current : neighbors) {
                        givesBonusUnits.addAll(Match.getMatches(current.getUnits().getUnits(), givesBonusUnitSea));
                    }
                }
                for (Unit bonusGiver : givesBonusUnits) {
                    int tempBonus = UnitAttachment.get(bonusGiver.getType()).getGivesMovement().getInt(u.getType());
                    if (tempBonus <= bonusMovement) continue;
                    bonusMovement = tempBonus;
                }
                if (bonusMovement == Integer.MIN_VALUE || bonusMovement == 0) continue;
                bonusMovement = Math.max(bonusMovement, UnitAttachment.get(u.getType()).getMovement(player) * -1);
                change.add(ChangeFactory.unitPropertyChange(u, bonusMovement, "bonusMovement"));
            }
        }
        return change;
    }

    public static void repairMultipleHitPointUnits(IDelegateBridge aBridge, PlayerID player) {
        GameData data = aBridge.getData();
        boolean repairOnlyOwn = Properties.getBattleshipsRepairAtBeginningOfRound(aBridge.getData());
        CompositeMatchAnd<Unit> damagedUnits = new CompositeMatchAnd<Unit>(Matches.UnitHasMoreThanOneHitPointTotal, Matches.UnitHasTakenSomeDamage);
        CompositeMatchAnd<Unit> damagedUnitsOwned = new CompositeMatchAnd<Unit>(damagedUnits, Matches.unitIsOwnedBy(player));
        HashMap<Territory, HashSet<Unit>> damagedMap = new HashMap<Territory, HashSet<Unit>>();
        for (Territory current : data.getMap().getTerritories()) {
            HashSet<Unit> damaged = !Properties.getTwoHitPointUnitsRequireRepairFacilities(data) ? (repairOnlyOwn ? new HashSet<Unit>(current.getUnits().getMatches(damagedUnitsOwned)) : new HashSet<Unit>(current.getUnits().getMatches(damagedUnits))) : new HashSet<Unit>(current.getUnits().getMatches(new CompositeMatchAnd<Unit>(damagedUnitsOwned, Matches.UnitCanBeRepairedByFacilitiesInItsTerritory(current, player, data))));
            if (damaged.isEmpty()) continue;
            damagedMap.put(current, damaged);
        }
        if (damagedMap.isEmpty()) {
            return;
        }
        HashMap fullyRepaired = new HashMap();
        IntegerMap<Unit> newHitsMap = new IntegerMap<Unit>();
        for (Map.Entry entry : damagedMap.entrySet()) {
            for (Unit u : (Set)entry.getValue()) {
                int repairAmount = MoveDelegate.getLargestRepairRateForThisUnit(u, (Territory)entry.getKey(), data);
                int currentHits = u.getHits();
                int newHits = Math.max(0, Math.min(currentHits, currentHits - repairAmount));
                if (newHits != currentHits) {
                    newHitsMap.put(u, newHits);
                }
                if (newHits > 0) continue;
                fullyRepaired.put(u, entry.getKey());
            }
        }
        aBridge.getHistoryWriter().startEvent(newHitsMap.size() + " " + MyFormatter.pluralize("unit", newHitsMap.size()) + " repaired.", new HashSet(newHitsMap.keySet()));
        aBridge.addChange(ChangeFactory.unitsHit(newHitsMap));
        List<Unit> damagedCarriers = Match.getMatches(fullyRepaired.keySet(), Matches.UnitHasWhenCombatDamagedEffect("unitsMayNotLeaveAlliedCarrier"));
        CompositeChange clearAlliedAir = new CompositeChange();
        for (Unit carrier : damagedCarriers) {
            CompositeChange change = MustFightBattle.clearTransportedByForAlliedAirOnCarrier(Collections.singleton(carrier), (Territory)fullyRepaired.get(carrier), carrier.getOwner(), data);
            if (change.isEmpty()) continue;
            clearAlliedAir.add(change);
        }
        if (!clearAlliedAir.isEmpty()) {
            aBridge.addChange(clearAlliedAir);
        }
    }

    public static int getLargestRepairRateForThisUnit(Unit unitToBeRepaired, Territory territoryUnitIsIn, GameData data) {
        ArrayList<Territory> neighbors;
        if (!Properties.getTwoHitPointUnitsRequireRepairFacilities(data)) {
            return 1;
        }
        HashSet<Unit> repairUnitsForThisUnit = new HashSet<Unit>();
        PlayerID owner = unitToBeRepaired.getOwner();
        CompositeMatchAnd<Unit> repairUnit = new CompositeMatchAnd<Unit>(Matches.alliedUnit(owner, data), Matches.UnitCanRepairOthers, Matches.UnitCanRepairThisUnit(unitToBeRepaired));
        repairUnitsForThisUnit.addAll(territoryUnitIsIn.getUnits().getMatches(repairUnit));
        if (Matches.UnitIsSea.match(unitToBeRepaired)) {
            CompositeMatchAnd<Unit> repairUnitLand = new CompositeMatchAnd<Unit>(repairUnit, Matches.UnitIsLand);
            neighbors = new ArrayList<Territory>(data.getMap().getNeighbors(territoryUnitIsIn, Matches.TerritoryIsLand));
            for (Territory current : neighbors) {
                repairUnitsForThisUnit.addAll(current.getUnits().getMatches(repairUnitLand));
            }
        } else if (Matches.UnitIsLand.match(unitToBeRepaired)) {
            CompositeMatchAnd<Unit> repairUnitSea = new CompositeMatchAnd<Unit>(repairUnit, Matches.UnitIsSea);
            neighbors = new ArrayList<Territory>(data.getMap().getNeighbors(territoryUnitIsIn, Matches.TerritoryIsWater));
            for (Territory current : neighbors) {
                repairUnitsForThisUnit.addAll(current.getUnits().getMatches(repairUnitSea));
            }
        }
        int largest = 0;
        for (Unit u : repairUnitsForThisUnit) {
            int repair = UnitAttachment.get(u.getType()).getRepairsUnits().getInt(unitToBeRepaired.getType());
            if (largest >= repair) continue;
            largest = repair;
        }
        return largest;
    }

    @Override
    public String move(Collection<Unit> units, Route route, Collection<Unit> transportsThatCanBeLoaded, Map<Unit, Collection<Unit>> newDependents) {
        String numErrorsMsg;
        GameData data = this.getData();
        PlayerID player = this.getUnitsOwner(units);
        MoveValidationResult result = MoveValidator.validateMove(units, route, player, transportsThatCanBeLoaded, newDependents, GameStepPropertiesHelper.isNonCombatMove(data, false), this.m_movesToUndo, data);
        StringBuilder errorMsg = new StringBuilder(100);
        int numProblems = result.getTotalWarningCount() - (result.hasError() ? 0 : 1);
        String string = numErrorsMsg = numProblems > 0 ? "; " + numProblems + " " + MyFormatter.pluralize("error", numProblems) + " not shown" : "";
        if (result.hasError()) {
            return errorMsg.append(result.getError()).append(numErrorsMsg).toString();
        }
        if (result.hasDisallowedUnits()) {
            return errorMsg.append(result.getDisallowedUnitWarning(0)).append(numErrorsMsg).toString();
        }
        boolean isKamikaze = false;
        boolean getKamikazeAir = Properties.getKamikaze_Airplanes(data);
        Collection<Object> kamikazeUnits = new ArrayList();
        if ((getKamikazeAir || Match.someMatch(units, Matches.UnitIsKamikaze)) && (kamikazeUnits = result.getUnresolvedUnits("Not all air units can land")).size() > 0 && this.getRemotePlayer().confirmMoveKamikaze()) {
            for (Unit unit : kamikazeUnits) {
                if (!getKamikazeAir && !Matches.UnitIsKamikaze.match(unit)) continue;
                result.removeUnresolvedUnit("Not all air units can land", unit);
                isKamikaze = true;
            }
        }
        if (result.hasUnresolvedUnits()) {
            return errorMsg.append(result.getUnresolvedUnitWarning(0)).append(numErrorsMsg).toString();
        }
        AAInMoveUtil aaInMoveUtil = new AAInMoveUtil();
        aaInMoveUtil.initialize(this.m_bridge);
        Collection<Territory> collection = aaInMoveUtil.getTerritoriesWhereAAWillFire(route, units);
        if (!collection.isEmpty() && !this.getRemotePlayer().confirmMoveInFaceOfAA(collection)) {
            return null;
        }
        UndoableMove currentMove = new UndoableMove(data, units, route);
        String transcriptText = MyFormatter.unitsToTextNoOwner(units) + " moved from " + route.getStart().getName() + " to " + route.getEnd().getName();
        this.m_bridge.getHistoryWriter().startEvent(transcriptText, currentMove.getDescriptionObject());
        if (isKamikaze) {
            this.m_bridge.getHistoryWriter().addChildToEvent("This was a kamikaze move, for at least some of the units", kamikazeUnits);
        }
        this.m_tempMovePerformer = new MovePerformer();
        this.m_tempMovePerformer.initialize(this);
        this.m_tempMovePerformer.moveUnits(units, route, player, transportsThatCanBeLoaded, newDependents, currentMove);
        this.m_tempMovePerformer = null;
        return null;
    }

    public static Collection<Territory> getEmptyNeutral(Route route) {
        CompositeMatchAnd<Territory> emptyNeutral = new CompositeMatchAnd<Territory>(Matches.TerritoryIsEmpty, Matches.TerritoryIsNeutralButNotWater);
        Collection<Territory> neutral = route.getMatches(emptyNeutral);
        return neutral;
    }

    public static Change ensureCanMoveOneSpaceChange(Unit unit) {
        int alreadyMoved = TripleAUnit.get(unit).getAlreadyMoved();
        int maxMovement = UnitAttachment.get(unit.getType()).getMovement(unit.getOwner());
        int bonusMovement = TripleAUnit.get(unit).getBonusMovement();
        return ChangeFactory.unitPropertyChange(unit, Math.min(alreadyMoved, maxMovement + bonusMovement - 1), "alreadyMoved");
    }

    private void removeAirThatCantLand() {
        GameData data = this.getData();
        boolean lhtrCarrierProd = AirThatCantLandUtil.isLHTRCarrierProduction(data) || AirThatCantLandUtil.isLandExistingFightersOnNewCarriers(data);
        boolean hasProducedCarriers = false;
        for (PlayerID p : GameStepPropertiesHelper.getCombinedTurns(data, this.m_player)) {
            if (!p.getUnits().someMatch(Matches.UnitIsCarrier)) continue;
            hasProducedCarriers = true;
            break;
        }
        AirThatCantLandUtil util = new AirThatCantLandUtil(this.m_bridge);
        util.removeAirThatCantLand(this.m_player, lhtrCarrierProd && hasProducedCarriers);
        for (PlayerID player : data.getPlayerList()) {
            if (player.equals(this.m_player)) continue;
            util.removeAirThatCantLand(player, (player.getUnits().someMatch(Matches.UnitIsCarrier) || hasProducedCarriers) && lhtrCarrierProd);
        }
    }

    public static Map<Unit, Unit> mapTransports(Route route, Collection<Unit> units, Collection<Unit> transportsToLoad) {
        if (route.isLoad()) {
            return MoveDelegate.mapTransportsToLoad(units, transportsToLoad);
        }
        if (route.isUnload()) {
            return MoveDelegate.mapTransportsAlreadyLoaded(units, route.getStart().getUnits().getUnits());
        }
        return MoveDelegate.mapTransportsAlreadyLoaded(units, units);
    }

    public static Map<Unit, Unit> mapTransports(Route route, Collection<Unit> units, Collection<Unit> transportsToLoad, boolean isload, PlayerID player) {
        if (isload) {
            return MoveDelegate.mapTransportsToLoad(units, transportsToLoad);
        }
        if (route != null && route.isUnload()) {
            return MoveDelegate.mapTransportsAlreadyLoaded(units, route.getStart().getUnits().getUnits());
        }
        return MoveDelegate.mapTransportsAlreadyLoaded(units, units);
    }

    public static Map<Unit, Unit> mapAirTransports(Route route, Collection<Unit> units, Collection<Unit> transportsToLoad, boolean isload, PlayerID player) {
        return MoveDelegate.mapTransports(route, units, transportsToLoad, isload, player);
    }

    public static List<Unit> mapAirTransportPossibilities(Route route, Collection<Unit> units, Collection<Unit> transportsToLoad, boolean isload, PlayerID player) {
        return MoveDelegate.mapAirTransportsToLoad2(units, Match.getMatches(transportsToLoad, Matches.UnitIsAirTransport));
    }

    private static Map<Unit, Unit> mapTransportsAlreadyLoaded(Collection<Unit> units, Collection<Unit> transports) {
        List<Unit> canBeTransported = Match.getMatches(units, Matches.UnitCanBeTransported);
        List<Unit> canTransport = Match.getMatches(transports, Matches.UnitCanTransport);
        HashMap<Unit, Unit> mapping = new HashMap<Unit, Unit>();
        for (Unit currentTransported : canBeTransported) {
            Unit transport = TransportTracker.transportedBy(currentTransported);
            if (transport == null || !canTransport.contains(transport)) continue;
            mapping.put(currentTransported, transport);
        }
        return mapping;
    }

    private static Map<Unit, Unit> mapTransportsToLoad(Collection<Unit> units, Collection<Unit> transports) {
        List<Unit> canBeTransported = Match.getMatches(units, Matches.UnitCanBeTransported);
        int transportIndex = 0;
        Comparator<Unit> transportCostComparator = new Comparator<Unit>(){

            @Override
            public int compare(Unit o1, Unit o2) {
                int cost1 = UnitAttachment.get(o1.getUnitType()).getTransportCost();
                int cost2 = UnitAttachment.get(o2.getUnitType()).getTransportCost();
                return cost2 - cost1;
            }
        };
        Collections.sort(canBeTransported, transportCostComparator);
        List<Unit> canTransport = Match.getMatches(transports, Matches.UnitCanTransport);
        Comparator<Unit> transportCapacityComparator = new Comparator<Unit>(){

            @Override
            public int compare(Unit o1, Unit o2) {
                int capacityLeft2;
                int capacityLeft1 = TransportTracker.getAvailableCapacity(o1);
                if (capacityLeft1 != (capacityLeft2 = TransportTracker.getAvailableCapacity(o1))) {
                    return capacityLeft1 - capacityLeft2;
                }
                int capacity1 = UnitAttachment.get(o1.getUnitType()).getTransportCapacity();
                int capacity2 = UnitAttachment.get(o2.getUnitType()).getTransportCapacity();
                return capacity1 - capacity2;
            }
        };
        Collections.sort(canTransport, transportCapacityComparator);
        HashMap<Unit, Unit> mapping = new HashMap<Unit, Unit>();
        IntegerMap<Unit> addedLoad = new IntegerMap<Unit>();
        Comparator<Unit> previouslyLoadedToLast = MoveDelegate.transportsThatPreviouslyUnloadedComeLast();
        for (Unit land : canBeTransported) {
            UnitAttachment landUA = UnitAttachment.get(land.getType());
            int cost = landUA.getTransportCost();
            boolean loaded = false;
            List<Unit> shiftedToEnd = Util.shiftElementsToEnd(canTransport, transportIndex);
            Collections.sort(shiftedToEnd, previouslyLoadedToLast);
            Iterator<Unit> transportIter = shiftedToEnd.iterator();
            while (transportIter.hasNext() && !loaded) {
                if (++transportIndex >= canTransport.size()) {
                    transportIndex = 0;
                }
                Unit transport = transportIter.next();
                int capacity = TransportTracker.getAvailableCapacity(transport);
                if ((capacity -= addedLoad.getInt(transport)) < cost) continue;
                addedLoad.add(transport, cost);
                mapping.put(land, transport);
                loaded = true;
            }
        }
        return mapping;
    }

    private static Comparator<Unit> transportsThatPreviouslyUnloadedComeLast() {
        return new Comparator<Unit>(){

            @Override
            public int compare(Unit t1, Unit t2) {
                boolean t2previous;
                if (t1 == t2 || t1.equals(t2)) {
                    return 0;
                }
                boolean t1previous = TransportTracker.hasTransportUnloadedInPreviousPhase(t1);
                if (t1previous == (t2previous = TransportTracker.hasTransportUnloadedInPreviousPhase(t2))) {
                    return 0;
                }
                if (!t1previous) {
                    return -1;
                }
                return 1;
            }
        };
    }

    private static List<Unit> mapAirTransportsToLoad2(Collection<Unit> units, Collection<Unit> transports) {
        Comparator<Unit> c = new Comparator<Unit>(){

            @Override
            public int compare(Unit o1, Unit o2) {
                int cost1 = UnitAttachment.get(o1.getUnitType()).getTransportCost();
                int cost2 = UnitAttachment.get(o2.getUnitType()).getTransportCost();
                return cost2 - cost1;
            }
        };
        Collections.sort((List)units, c);
        ArrayList<Unit> totalLoad = new ArrayList<Unit>();
        Set<UnitCategory> unitTypes = UnitSeperator.categorize(units, null, false, true);
        Set<UnitCategory> transportTypes = UnitSeperator.categorize(transports, null, false, false);
        for (UnitCategory unitType : unitTypes) {
            int transportCost = unitType.getTransportCost();
            for (UnitCategory transportType : transportTypes) {
                int transportCapacity = UnitAttachment.get(transportType.getType()).getTransportCapacity();
                if (transportCost <= 0 || transportCapacity < transportCost) continue;
                int transportCount = Match.countMatches(transports, Matches.unitIsOfType(transportType.getType()));
                int ttlTransportCapacity = transportCount * (int)Math.floor(transportCapacity / transportCost);
                totalLoad.addAll(Match.getNMatches(units, ttlTransportCapacity, Matches.unitIsOfType(unitType.getType())));
            }
        }
        return totalLoad;
    }

    @Override
    public int PUsAlreadyLost(Territory t) {
        return this.m_PUsLost.getInt(t);
    }

    @Override
    public void PUsLost(Territory t, int amt) {
        this.m_PUsLost.add(t, amt);
    }
}

