/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.RelationshipTracker;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.triplea.Properties;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.AAInMoveUtil;
import games.strategy.triplea.delegate.AbstractMoveDelegate;
import games.strategy.triplea.delegate.AirBattle;
import games.strategy.triplea.delegate.BattleTracker;
import games.strategy.triplea.delegate.DelegateFinder;
import games.strategy.triplea.delegate.ExecutionStack;
import games.strategy.triplea.delegate.GameStepPropertiesHelper;
import games.strategy.triplea.delegate.IBattle;
import games.strategy.triplea.delegate.IExecutable;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.MoveDelegate;
import games.strategy.triplea.delegate.MoveValidator;
import games.strategy.triplea.delegate.TransportTracker;
import games.strategy.triplea.delegate.UndoableMove;
import games.strategy.triplea.delegate.UnitComparator;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.triplea.player.ITripleaPlayer;
import games.strategy.triplea.ui.MovePanel;
import games.strategy.util.CompositeMatch;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.CompositeMatchOr;
import games.strategy.util.Match;
import games.strategy.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MovePerformer
implements Serializable {
    private static final long serialVersionUID = 3752242292777658310L;
    private transient AbstractMoveDelegate m_moveDelegate;
    private transient IDelegateBridge m_bridge;
    private transient PlayerID m_player;
    private AAInMoveUtil m_aaInMoveUtil;
    private final ExecutionStack m_executionStack = new ExecutionStack();
    private UndoableMove m_currentMove;
    private Map<Unit, Collection<Unit>> m_newDependents;

    MovePerformer() {
    }

    private BattleTracker getBattleTracker() {
        return DelegateFinder.battleDelegate(this.m_bridge.getData()).getBattleTracker();
    }

    void initialize(AbstractMoveDelegate delegate) {
        this.m_moveDelegate = delegate;
        this.m_bridge = delegate.getBridge();
        this.m_player = this.m_bridge.getPlayerID();
        if (this.m_aaInMoveUtil != null) {
            this.m_aaInMoveUtil.initialize(this.m_bridge);
        }
    }

    private ITripleaPlayer getRemotePlayer(PlayerID id) {
        return (ITripleaPlayer)this.m_bridge.getRemotePlayer(id);
    }

    private ITripleaPlayer getRemotePlayer() {
        return this.getRemotePlayer(this.m_player);
    }

    void moveUnits(Collection<Unit> units, Route route, PlayerID id, Collection<Unit> transportsToLoad, Map<Unit, Collection<Unit>> newDependents, UndoableMove currentMove) {
        this.m_currentMove = currentMove;
        this.m_newDependents = newDependents;
        this.populateStack(units, route, id, transportsToLoad);
        this.m_executionStack.execute(this.m_bridge);
    }

    public void resume() {
        this.m_executionStack.execute(this.m_bridge);
    }

    void populateStack(final Collection<Unit> units, final Route route, final PlayerID id, final Collection<Unit> transportsToLoad) {
        IExecutable preAAFire = new IExecutable(){
            private static final long serialVersionUID = -7945930782650355037L;

            @Override
            public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                for (IBattle battle : MovePerformer.this.getBattleTracker().getPendingBattles(route.getStart(), null, null)) {
                    for (Unit unit : units) {
                        Route routeUnitUsedToMove = MovePerformer.this.m_moveDelegate.getRouteUsedToMoveInto(unit, route.getStart());
                        if (battle == null) continue;
                        battle.removeAttack(routeUnitUsedToMove, Collections.singleton(unit));
                    }
                }
            }
        };
        final Collection[] arrivingUnits = new Collection[1];
        IExecutable fireAA = new IExecutable(){
            private static final long serialVersionUID = -3780228078499895244L;

            @Override
            public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                Collection aaCasualties = MovePerformer.this.fireAA(route, units);
                HashSet<Unit> aaCasualtiesWithDependents = new HashSet<Unit>();
                if (aaCasualties != null) {
                    aaCasualtiesWithDependents.addAll(aaCasualties);
                    Map<Unit, Collection<Unit>> dependencies = TransportTracker.transporting(units, (Collection<Unit>)units);
                    for (Unit u : aaCasualties) {
                        Collection newDependents;
                        Collection<Unit> dependents = dependencies.get(u);
                        if (dependents != null) {
                            aaCasualtiesWithDependents.addAll(dependents);
                        }
                        if ((newDependents = (Collection)MovePerformer.this.m_newDependents.get(u)) == null) continue;
                        aaCasualtiesWithDependents.addAll(newDependents);
                    }
                }
                arrivingUnits[0] = Util.difference(units, aaCasualtiesWithDependents);
            }
        };
        IExecutable postAAFire = new IExecutable(){
            private static final long serialVersionUID = 670783657414493643L;

            @Override
            public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                GameData data = bridge.getData();
                CompositeMatch<Territory> mustFightThrough = MovePerformer.getMustFightThroughMatch(id, data);
                List<Unit> arrived = Collections.unmodifiableList(Util.intersection(units, arrivingUnits[0]));
                ArrayList<Unit> arrivedCopyForBattles = new ArrayList<Unit>(arrived);
                Map<Unit, Unit> transporting = MoveDelegate.mapTransports(route, arrived, transportsToLoad);
                ArrayList<Unit> dependentOnSomethingTilTheEndOfRoute = new ArrayList<Unit>();
                List<Unit> airTransports = Match.getMatches(arrived, Matches.UnitIsAirTransport);
                List<Unit> paratroops = Match.getMatches(arrived, Matches.UnitIsAirTransportable);
                if (!airTransports.isEmpty() && !paratroops.isEmpty()) {
                    Map<Unit, Unit> transportingAir = MoveDelegate.mapAirTransports(route, paratroops, airTransports, true, id);
                    dependentOnSomethingTilTheEndOfRoute.addAll(transportingAir.keySet());
                }
                ArrayList<Unit> presentFromStartTilEnd = new ArrayList<Unit>(arrived);
                presentFromStartTilEnd.removeAll(dependentOnSomethingTilTheEndOfRoute);
                CompositeChange change = new CompositeChange();
                if (Properties.getUseFuelCost(data)) {
                    change.add(MovePerformer.this.markFuelCostResourceChange(units, route, id, data));
                }
                MovePerformer.this.markTransportsMovement(arrived, transporting, route);
                if (route.someMatch(mustFightThrough) && arrived.size() != 0) {
                    boolean canCreateAirBattle;
                    boolean bombing = false;
                    boolean ignoreBattle = false;
                    List<Unit> enemyUnits = route.getEnd().getUnits().getMatches(Matches.enemyUnit(id, data));
                    List<Unit> enemyTargetsTotal = Match.getMatches(enemyUnits, new CompositeMatchAnd(Matches.UnitIsAtMaxDamageOrNotCanBeDamaged(route.getEnd()).invert(), Matches.unitIsBeingTransported().invert()));
                    CompositeMatchOr<Unit> allBombingRaid = new CompositeMatchOr<Unit>(Matches.UnitIsStrategicBomber);
                    boolean bl = canCreateAirBattle = !enemyTargetsTotal.isEmpty() && Properties.getRaidsMayBePreceededByAirBattles(data) && AirBattle.territoryCouldPossiblyHaveAirBattleDefenders(route.getEnd(), id, data, true);
                    if (canCreateAirBattle) {
                        allBombingRaid.add(Matches.unitCanEscort);
                    }
                    boolean allCanBomb = Match.allMatch(arrived, allBombingRaid);
                    List<Unit> enemyTargets = Match.getMatches(enemyTargetsTotal, Matches.unitIsOfTypes(UnitAttachment.getAllowedBombingTargetsIntersection(Match.getMatches(arrived, Matches.UnitIsStrategicBomber), data)));
                    boolean targetsOrEscort = !enemyTargets.isEmpty() || !enemyTargetsTotal.isEmpty() && canCreateAirBattle && Match.allMatch(arrived, Matches.unitCanEscort);
                    boolean targetedAttack = false;
                    if (allCanBomb && targetsOrEscort && GameStepPropertiesHelper.isCombatMove(data, false) && (bombing = MovePerformer.this.getRemotePlayer().shouldBomberBomb(route.getEnd()))) {
                        Unit target = enemyTargets.size() > 1 && Properties.getDamageFromBombingDoneToUnitsInsteadOfTerritories(data) && !canCreateAirBattle ? MovePerformer.this.getRemotePlayer().whatShouldBomberBomb(route.getEnd(), enemyTargets, arrived) : (!enemyTargets.isEmpty() ? (Unit)enemyTargets.iterator().next() : (Unit)enemyTargetsTotal.iterator().next());
                        if (target == null) {
                            bombing = false;
                            targetedAttack = false;
                        } else {
                            targetedAttack = true;
                            HashMap<Unit, HashSet<Unit>> targets = new HashMap<Unit, HashSet<Unit>>();
                            targets.put(target, new HashSet<Unit>(arrived));
                            MovePerformer.this.getBattleTracker().addBattle(route, arrivedCopyForBattles, bombing, id, MovePerformer.this.m_bridge, MovePerformer.this.m_currentMove, dependentOnSomethingTilTheEndOfRoute, targets, false);
                        }
                    }
                    if (MovePerformer.isIgnoreTransportInMovement(bridge.getData())) {
                        boolean allOwnedTransports = Match.allMatch(arrived, Matches.UnitIsTransportButNotCombatTransport);
                        boolean allEnemyTransports = Match.allMatch(enemyUnits, Matches.UnitIsTransportButNotCombatTransport);
                        if (allOwnedTransports && allEnemyTransports) {
                            ignoreBattle = true;
                        }
                    }
                    if (!ignoreBattle && GameStepPropertiesHelper.isCombatMove(data, false) && !targetedAttack) {
                        MovePerformer.this.getBattleTracker().addBattle(route, arrivedCopyForBattles, bombing, id, MovePerformer.this.m_bridge, MovePerformer.this.m_currentMove, dependentOnSomethingTilTheEndOfRoute);
                    }
                    if (!ignoreBattle && GameStepPropertiesHelper.isNonCombatMove(data, false) && !targetedAttack) {
                        for (Territory t : route.getMatches(new CompositeMatchAnd<Territory>(Matches.territoryIsOwnedByPlayerWhosRelationshipTypeCanTakeOverOwnedTerritoryAndPassableAndNotWater(id), Matches.TerritoryIsBlitzable(id, data)))) {
                            if (Matches.isTerritoryEnemy(id, data).match(t) || Matches.territoryHasEnemyUnits(id, data).match(t) || t.equals(route.getEnd()) && Match.allMatch(arrivedCopyForBattles, Matches.UnitIsAir) || !t.equals(route.getEnd()) && Match.allMatch(presentFromStartTilEnd, Matches.UnitIsAir)) continue;
                            MovePerformer.this.getBattleTracker().takeOver(t, id, bridge, MovePerformer.this.m_currentMove, arrivedCopyForBattles);
                        }
                    }
                }
                Change moveChange = MovePerformer.this.markMovementChange(arrived, route, id);
                change.add(moveChange);
                Change remove = null;
                Change add = null;
                if (route.getStart() != null && route.getEnd() != null) {
                    remove = ChangeFactory.removeUnits(route.getStart(), (Collection<Unit>)units);
                    add = ChangeFactory.addUnits(route.getEnd(), arrived);
                    change.add(add, remove);
                }
                MovePerformer.this.m_bridge.addChange(change);
                MovePerformer.this.m_currentMove.addChange(change);
                MovePerformer.this.m_currentMove.setDescription(MyFormatter.unitsToTextNoOwner(arrived) + " moved from " + route.getStart().getName() + " to " + route.getEnd().getName());
                MovePerformer.this.m_moveDelegate.updateUndoableMoves(MovePerformer.this.m_currentMove);
            }
        };
        this.m_executionStack.push(postAAFire);
        this.m_executionStack.push(fireAA);
        this.m_executionStack.push(preAAFire);
        this.m_executionStack.execute(this.m_bridge);
    }

    public static CompositeMatch<Territory> getMustFightThroughMatch(PlayerID id, GameData data) {
        CompositeMatchOr<Territory> mustFightThrough = new CompositeMatchOr<Territory>(new Match[0]);
        mustFightThrough.add(Matches.isTerritoryEnemyAndNotUnownedWaterOrImpassibleOrRestricted(id, data));
        mustFightThrough.add(Matches.territoryHasNonSubmergedEnemyUnits(id, data));
        mustFightThrough.add(Matches.territoryIsOwnedByPlayerWhosRelationshipTypeCanTakeOverOwnedTerritoryAndPassableAndNotWater(id));
        return mustFightThrough;
    }

    private Change markFuelCostResourceChange(Collection<Unit> units, Route route, PlayerID id, GameData data) {
        return ChangeFactory.removeResourceCollection(id, Route.getMovementFuelCostCharge(units, route, id, data));
    }

    private Change markMovementChange(Collection<Unit> units, Route route, PlayerID id) {
        GameData data = this.m_bridge.getData();
        CompositeChange change = new CompositeChange();
        Territory routeStart = route.getStart();
        TerritoryAttachment taRouteStart = TerritoryAttachment.get(routeStart);
        Territory routeEnd = route.getEnd();
        TerritoryAttachment taRouteEnd = null;
        if (routeEnd != null) {
            taRouteEnd = TerritoryAttachment.get(routeEnd);
        }
        Iterator<Unit> iter = Match.getMatches(units, Matches.unitIsOwnedBy(id)).iterator();
        RelationshipTracker relationshipTracker = data.getRelationshipTracker();
        while (iter.hasNext()) {
            TripleAUnit unit = (TripleAUnit)iter.next();
            int moved = route.getMovementCost(unit);
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            if (ua.getIsAir()) {
                if (taRouteStart != null && taRouteStart.getAirBase() && relationshipTracker.isAllied(route.getStart().getOwner(), unit.getOwner())) {
                    --moved;
                }
                if (taRouteEnd != null && taRouteEnd.getAirBase() && relationshipTracker.isAllied(route.getEnd().getOwner(), unit.getOwner())) {
                    --moved;
                }
            }
            change.add(ChangeFactory.unitPropertyChange(unit, moved + unit.getAlreadyMoved(), "alreadyMoved"));
        }
        if (GameStepPropertiesHelper.isCombatMove(data, false) && (MoveDelegate.getEmptyNeutral(route).size() != 0 || this.hasConqueredNonBlitzed(route))) {
            for (Unit unit : Match.getMatches(units, Matches.UnitIsLand)) {
                change.add(ChangeFactory.markNoMovementChange(Collections.singleton(unit)));
            }
        }
        if (routeEnd != null && Properties.getSubsCanEndNonCombatMoveWithEnemies(data) && GameStepPropertiesHelper.isNonCombatMove(data, false) && routeEnd.getUnits().someMatch(new CompositeMatchAnd<Unit>(Matches.unitIsEnemyOf(data, id), Matches.UnitIsDestroyer))) {
            for (Unit unit : Match.getMatches(units, new CompositeMatchAnd(Matches.UnitIsSub, Matches.UnitIsAir.invert()))) {
                change.add(ChangeFactory.markNoMovementChange(Collections.singleton(unit)));
            }
        }
        return change;
    }

    private void markTransportsMovement(Collection<Unit> arrived, Map<Unit, Unit> transporting, Route route) {
        if (transporting == null) {
            return;
        }
        GameData data = this.m_bridge.getData();
        CompositeMatchOr<Unit> paratroopNAirTransports = new CompositeMatchOr<Unit>(new Match[0]);
        paratroopNAirTransports.add(Matches.UnitIsAirTransport);
        paratroopNAirTransports.add(Matches.UnitIsAirTransportable);
        boolean paratroopsLanding = Match.someMatch(arrived, paratroopNAirTransports) && MoveValidator.allLandUnitsAreBeingParatroopered(arrived, route, this.m_player);
        Map<Unit, Collection<Unit>> dependentAirTransportableUnits = MoveValidator.getDependents(Match.getMatches(arrived, Matches.UnitCanTransport), data);
        if (this.m_newDependents != null) {
            for (Map.Entry<Unit, Collection<Unit>> entry : this.m_newDependents.entrySet()) {
                Collection<Unit> dependents = dependentAirTransportableUnits.get(entry.getKey());
                if (dependents != null) {
                    dependents.addAll(entry.getValue());
                } else {
                    dependents = entry.getValue();
                }
                dependentAirTransportableUnits.put(entry.getKey(), dependents);
            }
        }
        if (!paratroopsLanding && !dependentAirTransportableUnits.isEmpty()) {
            List<Unit> airTransports = Match.getMatches(arrived, Matches.UnitIsAirTransport);
            airTransports.addAll(dependentAirTransportableUnits.keySet());
            MovePanel.clearDependents(airTransports);
        }
        if (route.isLoad() || paratroopsLanding) {
            for (Unit load : transporting.keySet()) {
                Unit transport = transporting.get(load);
                if (TransportTracker.transporting(transport).contains(load)) continue;
                Change change = TransportTracker.loadTransportChange((TripleAUnit)transport, load);
                this.m_currentMove.addChange(change);
                this.m_currentMove.load(transport);
                this.m_bridge.addChange(change);
            }
            if (transporting.isEmpty()) {
                for (Unit airTransport : dependentAirTransportableUnits.keySet()) {
                    for (Unit unit : dependentAirTransportableUnits.get(airTransport)) {
                        Change change = TransportTracker.loadTransportChange((TripleAUnit)airTransport, unit);
                        this.m_currentMove.addChange(change);
                        this.m_currentMove.load(airTransport);
                        this.m_bridge.addChange(change);
                    }
                }
            }
        }
        if (route.isUnload() || paratroopsLanding) {
            BattleTracker tracker;
            HashSet units = new HashSet();
            units.addAll(transporting.values());
            units.addAll(transporting.keySet());
            if (transporting.isEmpty()) {
                units.addAll(dependentAirTransportableUnits.keySet());
                for (Unit airTransport : dependentAirTransportableUnits.keySet()) {
                    units.addAll(dependentAirTransportableUnits.get(airTransport));
                }
            }
            boolean pendingBattles = (tracker = this.getBattleTracker()).getPendingBattle(route.getStart(), false, IBattle.BattleType.NORMAL) != null;
            Iterator iter = units.iterator();
            while (iter.hasNext()) {
                Unit unit;
                unit = (Unit)iter.next();
                if (Matches.UnitIsAir.match(unit)) continue;
                Unit transportedBy = ((TripleAUnit)unit).getTransportedBy();
                if (paratroopsLanding && transportedBy != null && Matches.UnitIsAirTransport.match(transportedBy) && GameStepPropertiesHelper.isCombatMove(data, false) && Matches.territoryHasNonSubmergedEnemyUnits(this.m_player, data).match(route.getEnd())) continue;
                Change change1 = TransportTracker.unloadTransportChange((TripleAUnit)unit, this.m_currentMove.getRoute().getEnd(), this.m_player, pendingBattles);
                this.m_currentMove.addChange(change1);
                this.m_currentMove.unload(unit);
                this.m_bridge.addChange(change1);
                Change change2 = ChangeFactory.markNoMovementChange(Collections.singleton(unit));
                this.m_currentMove.addChange(change2);
                this.m_bridge.addChange(change2);
            }
        }
    }

    private boolean hasConqueredNonBlitzed(Route route) {
        BattleTracker tracker = this.getBattleTracker();
        for (Territory current : route.getSteps()) {
            if (!tracker.wasConquered(current) || tracker.wasBlitzed(current)) continue;
            return true;
        }
        return false;
    }

    private Collection<Unit> fireAA(Route route, Collection<Unit> units) {
        if (this.m_aaInMoveUtil == null) {
            this.m_aaInMoveUtil = new AAInMoveUtil();
        }
        this.m_aaInMoveUtil.initialize(this.m_bridge);
        Collection<Unit> rVal = this.m_aaInMoveUtil.fireAA(route, units, UnitComparator.getLowestToHighestMovementComparator(), this.m_currentMove);
        this.m_aaInMoveUtil = null;
        return rVal;
    }

    private static boolean isIgnoreTransportInMovement(GameData data) {
        return Properties.getIgnoreTransportInMovement(data);
    }
}

