/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.triplea.delegate.AbstractBattle;
import games.strategy.triplea.delegate.BattleTracker;
import games.strategy.triplea.delegate.IBattle;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.TransportTracker;
import games.strategy.triplea.delegate.dataObjects.BattleRecord;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.triplea.oddsCalculator.ta.BattleResults;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.Match;
import games.strategy.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class NonFightingBattle
extends AbstractBattle {
    private static final long serialVersionUID = -1699534010648145123L;
    private final Set<Territory> m_attackingFrom = new HashSet<Territory>();
    private final Collection<Territory> m_amphibiousAttackFrom = new ArrayList<Territory>();
    private final Map<Territory, Collection<Unit>> m_attackingFromMap = new HashMap<Territory, Collection<Unit>>();

    public NonFightingBattle(Territory battleSite, PlayerID attacker, BattleTracker battleTracker, GameData data) {
        super(battleSite, attacker, battleTracker, false, IBattle.BattleType.NORMAL, data);
    }

    @Override
    public Change addAttackChange(Route route, Collection<Unit> units, HashMap<Unit, HashSet<Unit>> targets) {
        Map<Unit, Collection<Unit>> addedTransporting = TransportTracker.transporting(units);
        for (Unit unit : addedTransporting.keySet()) {
            if (this.m_dependentUnits.get(unit) != null) {
                ((Collection)this.m_dependentUnits.get(unit)).addAll(addedTransporting.get(unit));
                continue;
            }
            this.m_dependentUnits.put(unit, addedTransporting.get(unit));
        }
        Territory attackingFrom = route.getTerritoryBeforeEnd();
        this.m_attackingFrom.add(attackingFrom);
        this.m_attackingUnits.addAll(units);
        if (this.m_attackingFromMap.get(attackingFrom) == null) {
            this.m_attackingFromMap.put(attackingFrom, new ArrayList());
        }
        Collection<Unit> attackingFromMapUnits = this.m_attackingFromMap.get(attackingFrom);
        attackingFromMapUnits.addAll(units);
        if (route.getStart().isWater() && route.getEnd() != null && !route.getEnd().isWater() && Match.someMatch(units, Matches.UnitIsLand)) {
            this.m_amphibiousAttackFrom.add(route.getTerritoryBeforeEnd());
            this.m_amphibiousLandAttackers.addAll(Match.getMatches(units, Matches.UnitIsLand));
            this.m_isAmphibious = true;
        }
        return ChangeFactory.EMPTY_CHANGE;
    }

    @Override
    public void fight(IDelegateBridge bridge) {
        if (!this.m_battleTracker.getDependentOn(this).isEmpty()) {
            throw new IllegalStateException("Must fight battles that this battle depends on first");
        }
        bridge.getHistoryWriter().startEvent("Battle in " + this.m_battleSite, this.m_battleSite);
        boolean someAttacking = this.hasAttackingUnits();
        if (someAttacking) {
            this.m_whoWon = IBattle.WhoWon.ATTACKER;
            this.m_battleResultDescription = BattleRecord.BattleResultDescription.BLITZED;
            this.m_battleTracker.takeOver(this.m_battleSite, this.m_attacker, bridge, null, null);
            this.m_battleTracker.addToConquered(this.m_battleSite);
        } else {
            this.m_whoWon = IBattle.WhoWon.DEFENDER;
            this.m_battleResultDescription = BattleRecord.BattleResultDescription.LOST;
        }
        this.m_battleTracker.getBattleRecords(this.m_data).addResultToBattle(this.m_attacker, this.m_battleID, this.m_defender, this.m_attackerLostTUV, this.m_defenderLostTUV, this.m_battleResultDescription, new BattleResults(this, this.m_data), 0);
        this.end();
    }

    private void end() {
        this.m_battleTracker.removeBattle(this);
        this.m_isOver = true;
    }

    public Collection<Territory> getAmphibiousAttackTerritories() {
        return this.m_amphibiousAttackFrom;
    }

    public Collection<Territory> getAttackingFrom() {
        return this.m_attackingFrom;
    }

    public Map<Territory, Collection<Unit>> getAttackingFromMap() {
        return this.m_attackingFromMap;
    }

    boolean hasAttackingUnits() {
        CompositeMatchAnd<Unit> attackingLand = new CompositeMatchAnd<Unit>(new Match[0]);
        attackingLand.add(Matches.alliedUnit(this.m_attacker, this.m_data));
        attackingLand.add(Matches.UnitIsLand);
        boolean someAttacking = this.m_battleSite.getUnits().someMatch(attackingLand);
        return someAttacking;
    }

    @Override
    public void removeAttack(Route route, Collection<Unit> units) {
        this.m_attackingUnits.removeAll(units);
        if (route == null) {
            return;
        }
        Territory attackingFrom = route.getTerritoryBeforeEnd();
        Collection<Unit> attackingFromMapUnits = this.m_attackingFromMap.get(attackingFrom);
        if (attackingFromMapUnits == null) {
            attackingFromMapUnits = new ArrayList<Unit>();
        }
        attackingFromMapUnits.removeAll(units);
        if (attackingFromMapUnits.isEmpty()) {
            this.m_attackingFrom.remove(attackingFrom);
        }
        if (attackingFrom.isWater()) {
            if (route.getEnd() != null && !route.getEnd().isWater() && Match.someMatch(units, Matches.UnitIsLand)) {
                this.m_amphibiousLandAttackers.removeAll(Match.getMatches(units, Matches.UnitIsLand));
            }
            if (Match.noneMatch(attackingFromMapUnits, Matches.UnitIsLand)) {
                this.m_amphibiousAttackFrom.remove(attackingFrom);
                this.m_isAmphibious = !this.m_amphibiousAttackFrom.isEmpty();
            }
        }
        for (Unit dependence : this.m_dependentUnits.keySet()) {
            Collection dependent = (Collection)this.m_dependentUnits.get(dependence);
            dependent.removeAll(units);
        }
    }

    @Override
    public boolean isEmpty() {
        return !this.hasAttackingUnits();
    }

    @Override
    public void unitsLostInPrecedingBattle(IBattle battle, Collection<Unit> units, IDelegateBridge bridge, boolean withdrawn) {
        if (withdrawn) {
            return;
        }
        Collection<Unit> lost = this.getDependentUnits(units);
        lost.addAll(Util.intersection(units, this.m_attackingUnits));
        lost = Match.getMatches(lost, Matches.unitIsInTerritory(this.m_battleSite));
        if (lost.size() != 0) {
            String transcriptText = MyFormatter.unitsToText(lost) + " lost in " + this.m_battleSite.getName();
            bridge.getHistoryWriter().addChildToEvent(transcriptText, lost);
            Change change = ChangeFactory.removeUnits(this.m_battleSite, lost);
            bridge.addChange(change);
        }
    }

    public void addDependentUnits(Map<Unit, Collection<Unit>> dependencies) {
        for (Unit holder : dependencies.keySet()) {
            Collection<Unit> transporting = dependencies.get(holder);
            if (this.m_dependentUnits.get(holder) != null) {
                ((Collection)this.m_dependentUnits.get(holder)).addAll(transporting);
                continue;
            }
            this.m_dependentUnits.put(holder, new LinkedHashSet<Unit>(transporting));
        }
    }
}

