/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

public class OriginalOwnerTracker
implements Serializable {
    private static final long serialVersionUID = 8462432412106180906L;

    public static Change addOriginalOwnerChange(Territory t, PlayerID player) {
        return ChangeFactory.attachmentPropertyChange(TerritoryAttachment.get(t), player, "originalOwner");
    }

    public static Change addOriginalOwnerChange(Unit unit, PlayerID player) {
        return ChangeFactory.unitPropertyChange(unit, player, "originalOwner");
    }

    public static Change addOriginalOwnerChange(Collection<Unit> units, PlayerID player) {
        CompositeChange change = new CompositeChange();
        for (Unit unit : units) {
            change.add(OriginalOwnerTracker.addOriginalOwnerChange(unit, player));
        }
        return change;
    }

    public static PlayerID getOriginalOwner(Unit unit) {
        return TripleAUnit.get(unit).getOriginalOwner();
    }

    public static PlayerID getOriginalOwner(Territory t) {
        TerritoryAttachment ta = TerritoryAttachment.get(t);
        if (ta == null) {
            return null;
        }
        return ta.getOriginalOwner();
    }

    public static Collection<Territory> getOriginallyOwned(GameData data, PlayerID player) {
        ArrayList<Territory> rVal = new ArrayList<Territory>();
        for (Territory t : data.getMap()) {
            PlayerID originalOwner = OriginalOwnerTracker.getOriginalOwner(t);
            if (originalOwner == null) {
                originalOwner = PlayerID.NULL_PLAYERID;
            }
            if (!originalOwner.equals(player)) continue;
            rVal.add(t);
        }
        return rVal;
    }
}

