/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.common.delegate.BaseTripleADelegate;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.RelationshipType;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.Territory;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.engine.random.IRandomStats;
import games.strategy.triplea.Properties;
import games.strategy.triplea.attatchments.ICondition;
import games.strategy.triplea.attatchments.PoliticalActionAttachment;
import games.strategy.triplea.attatchments.RulesAttachment;
import games.strategy.triplea.attatchments.TriggerAttachment;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.MoveDelegate;
import games.strategy.triplea.delegate.OriginalOwnerTracker;
import games.strategy.triplea.delegate.PoliticsExtendedDelegateState;
import games.strategy.triplea.delegate.remote.IPoliticsDelegate;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.triplea.ui.PoliticsText;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.CompositeMatchOr;
import games.strategy.util.Match;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;

public class PoliticsDelegate
extends BaseTripleADelegate
implements IPoliticsDelegate {
    @Override
    public void start() {
        super.start();
    }

    @Override
    public void end() {
        super.end();
        this.resetAttempts();
        if (Properties.getTriggers(this.getData())) {
            CompositeMatchAnd<TriggerAttachment> politicsDelegateTriggerMatch = new CompositeMatchAnd<TriggerAttachment>(TriggerAttachment.availableUses, TriggerAttachment.whenOrDefaultMatch(null, null), new CompositeMatchOr(TriggerAttachment.relationshipChangeMatch()));
            HashSet<TriggerAttachment> toFirePossible = TriggerAttachment.collectForAllTriggersMatching(new HashSet<PlayerID>(Collections.singleton(this.m_player)), politicsDelegateTriggerMatch, this.m_bridge);
            if (!toFirePossible.isEmpty()) {
                HashMap<ICondition, Boolean> testedConditions = TriggerAttachment.collectTestsForAllTriggers(toFirePossible, this.m_bridge);
                HashSet<TriggerAttachment> toFireTestedAndSatisfied = new HashSet<TriggerAttachment>(Match.getMatches(toFirePossible, TriggerAttachment.isSatisfiedMatch(testedConditions)));
                TriggerAttachment.triggerRelationshipChange(toFireTestedAndSatisfied, this.m_bridge, null, null, true, true, true, true);
            }
        }
        PoliticsDelegate.chainAlliancesTogether(this.m_bridge);
        PoliticsDelegate.givesBackOriginalTerritories(this.m_bridge);
    }

    @Override
    public Serializable saveState() {
        PoliticsExtendedDelegateState state = new PoliticsExtendedDelegateState();
        state.superState = super.saveState();
        return state;
    }

    @Override
    public void loadState(Serializable state) {
        PoliticsExtendedDelegateState s = (PoliticsExtendedDelegateState)state;
        super.loadState(s.superState);
    }

    @Override
    public boolean delegateCurrentlyRequiresUserInput() {
        if (!this.m_player.amNotDeadYet(this.getData())) {
            return false;
        }
        if (!Properties.getUsePolitics(this.getData())) {
            return false;
        }
        return !this.getValidActions().isEmpty();
    }

    public HashMap<ICondition, Boolean> getTestedConditions() {
        HashSet<ICondition> allConditionsNeeded = RulesAttachment.getAllConditionsRecursive(new HashSet<ICondition>(PoliticalActionAttachment.getPoliticalActionAttachments(this.m_player)), null);
        return RulesAttachment.testAllConditionsRecursive(allConditionsNeeded, null, this.m_bridge);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<PoliticalActionAttachment> getValidActions() {
        HashMap<ICondition, Boolean> testedConditions;
        GameData data = this.m_bridge.getData();
        data.acquireReadLock();
        try {
            testedConditions = this.getTestedConditions();
        }
        finally {
            data.releaseReadLock();
        }
        return PoliticalActionAttachment.getValidActions(this.m_player, testedConditions, data);
    }

    public Class<IPoliticsDelegate> getRemoteType() {
        return IPoliticsDelegate.class;
    }

    @Override
    public void attemptAction(PoliticalActionAttachment paa) {
        if (!Properties.getUsePolitics(this.getData())) {
            this.notifyPoliticsTurnedOff();
            return;
        }
        if (paa.canPerform(this.getTestedConditions())) {
            if (this.checkEnoughMoney(paa)) {
                this.chargeForAction(paa);
                paa.useAttempt(this.getBridge());
                if (this.actionRollSucceeds(paa)) {
                    if (this.actionIsAccepted(paa)) {
                        this.changeRelationships(paa);
                        this.notifySuccess(paa);
                    } else {
                        this.notifyFailure(paa);
                    }
                } else {
                    this.notifyFailure(paa);
                }
            } else {
                this.notifyMoney(paa, false);
            }
        } else {
            this.notifyNoValidAction(paa);
        }
    }

    private boolean actionIsAccepted(PoliticalActionAttachment paa) {
        GameData data = this.getData();
        CompositeMatchOr<PoliticalActionAttachment> intoAlliedChainOrIntoOrOutOfWar = new CompositeMatchOr<PoliticalActionAttachment>(Matches.politicalActionIsRelationshipChangeOf(null, Matches.RelationshipTypeIsAlliedAndAlliancesCanChainTogether.invert(), Matches.RelationshipTypeIsAlliedAndAlliancesCanChainTogether, data), Matches.politicalActionIsRelationshipChangeOf(null, Matches.RelationshipTypeIsAtWar.invert(), Matches.RelationshipTypeIsAtWar, data), Matches.politicalActionIsRelationshipChangeOf(null, Matches.RelationshipTypeIsAtWar, Matches.RelationshipTypeIsAtWar.invert(), data));
        if (!Properties.getAlliancesCanChainTogether(data) || !intoAlliedChainOrIntoOrOutOfWar.match(paa)) {
            for (PlayerID player : paa.getActionAccept()) {
                if (this.getRemotePlayer(player).acceptAction(this.m_player, PoliticsText.getInstance().getAcceptanceQuestion(paa.getText()), true)) continue;
                return false;
            }
        } else {
            LinkedHashSet<PlayerID> playersWhoNeedToAccept = new LinkedHashSet<PlayerID>();
            playersWhoNeedToAccept.addAll(paa.getActionAccept());
            playersWhoNeedToAccept.addAll(Match.getMatches(data.getPlayerList().getPlayers(), Matches.isAlliedAndAlliancesCanChainTogether(this.m_player, data)));
            for (PlayerID player : paa.getActionAccept()) {
                playersWhoNeedToAccept.addAll(Match.getMatches(data.getPlayerList().getPlayers(), Matches.isAlliedAndAlliancesCanChainTogether(player, data)));
            }
            LinkedHashSet<PlayerID> alliesWhoMustAccept = playersWhoNeedToAccept;
            alliesWhoMustAccept.removeAll(paa.getActionAccept());
            for (PlayerID player : playersWhoNeedToAccept) {
                String actionText = PoliticsText.getInstance().getAcceptanceQuestion(paa.getText());
                actionText = actionText.equals("NONE") ? this.m_player.getName() + " wants to take the following action: " + MyFormatter.attachmentNameToText(paa.getName()) + " \r\n Do you approve?" : this.m_player.getName() + " wants to take the following action: " + MyFormatter.attachmentNameToText(paa.getName()) + ".  Do you approve? \r\n\r\n " + this.m_player.getName() + " will ask " + MyFormatter.defaultNamedToTextList(paa.getActionAccept()) + ", the following question: \r\n " + actionText;
                if (this.getRemotePlayer(player).acceptAction(this.m_player, actionText, true)) continue;
                return false;
            }
            for (PlayerID player : paa.getActionAccept()) {
                if (this.getRemotePlayer(player).acceptAction(this.m_player, PoliticsText.getInstance().getAcceptanceQuestion(paa.getText()), true)) continue;
                return false;
            }
        }
        return true;
    }

    private void notifyNoValidAction(PoliticalActionAttachment paa) {
        this.sendNotification("This action isn't available anymore (this shouldn't happen!?!)");
    }

    private void notifyPoliticsTurnedOff() {
        this.sendNotification("Politics is turned off in the game options");
    }

    private void notifyMoney(PoliticalActionAttachment paa, boolean enough) {
        if (enough) {
            this.sendNotification("Charging " + paa.getCostPU() + " PU's to perform this action");
        } else {
            this.sendNotification("You don't have ennough money, you need " + paa.getCostPU() + " PU's to perform this action");
        }
    }

    private void chargeForAction(PoliticalActionAttachment paa) {
        Resource PUs = this.getData().getResourceList().getResource("PUs");
        int cost = paa.getCostPU();
        if (cost > 0) {
            String transcriptText = this.m_bridge.getPlayerID().getName() + " spend " + cost + " PU on Political Action: " + MyFormatter.attachmentNameToText(paa.getName());
            this.m_bridge.getHistoryWriter().startEvent(transcriptText);
            Change charge = ChangeFactory.changeResourcesChange(this.m_bridge.getPlayerID(), PUs, -cost);
            this.m_bridge.addChange(charge);
        } else {
            String transcriptText = this.m_bridge.getPlayerID().getName() + " takes Political Action: " + MyFormatter.attachmentNameToText(paa.getName());
            this.m_bridge.getHistoryWriter().startEvent(transcriptText);
        }
    }

    private boolean checkEnoughMoney(PoliticalActionAttachment paa) {
        Resource PUs = this.getData().getResourceList().getResource("PUs");
        int cost = paa.getCostPU();
        int has = this.m_bridge.getPlayerID().getResources().getQuantity(PUs);
        return has >= cost;
    }

    private void notifyFailure(PoliticalActionAttachment paa) {
        this.getSoundChannel().playSoundForAll("political_action_failure", this.m_player.getName());
        String transcriptText = this.m_bridge.getPlayerID().getName() + " fails on action: " + MyFormatter.attachmentNameToText(paa.getName());
        this.m_bridge.getHistoryWriter().addChildToEvent(transcriptText);
        this.sendNotification(PoliticsText.getInstance().getNotificationFailure(paa.getText()));
        this.notifyOtherPlayers(paa, PoliticsText.getInstance().getNotificationFailureOthers(paa.getText()));
    }

    private void notifySuccess(PoliticalActionAttachment paa) {
        this.getSoundChannel().playSoundForAll("political_action_successful", this.m_player.getName());
        this.sendNotification(PoliticsText.getInstance().getNotificationSucccess(paa.getText()));
        this.notifyOtherPlayers(paa, PoliticsText.getInstance().getNotificationSuccessOthers(paa.getText()));
    }

    private void notifyOtherPlayers(PoliticalActionAttachment paa, String notification) {
        if (!"NONE".equals(notification)) {
            ArrayList<PlayerID> currentPlayer = new ArrayList<PlayerID>();
            currentPlayer.add(this.m_player);
            List<PlayerID> otherPlayers = this.getData().getPlayerList().getPlayers();
            otherPlayers.removeAll(currentPlayer);
            this.getDisplay().reportMessageToPlayers(otherPlayers, currentPlayer, notification, notification);
        }
    }

    private void sendNotification(String text) {
        if (!"NONE".equals(text)) {
            this.getRemotePlayer().reportMessage(text, text);
        }
    }

    private void changeRelationships(PoliticalActionAttachment paa) {
        PoliticsDelegate.getMyselfOutOfAlliance(paa, this.m_player, this.m_bridge);
        PoliticsDelegate.getNeutralOutOfWarWithAllies(paa, this.m_player, this.m_bridge);
        CompositeChange change = new CompositeChange();
        for (String relationshipChange : paa.getRelationshipChange()) {
            RelationshipType newRelation;
            String[] s = relationshipChange.split(":");
            PlayerID player1 = this.getData().getPlayerList().getPlayerID(s[0]);
            PlayerID player2 = this.getData().getPlayerList().getPlayerID(s[1]);
            RelationshipType oldRelation = this.getData().getRelationshipTracker().getRelationshipType(player1, player2);
            if (oldRelation.equals(newRelation = this.getData().getRelationshipTypeList().getRelationshipType(s[2]))) continue;
            change.add(ChangeFactory.relationshipChange(player1, player2, oldRelation, newRelation));
            this.m_bridge.getHistoryWriter().addChildToEvent(this.m_bridge.getPlayerID().getName() + " succeeds on action: " + MyFormatter.attachmentNameToText(paa.getName()) + ": Changing Relationship for " + player1.getName() + " and " + player2.getName() + " from " + oldRelation.getName() + " to " + newRelation.getName());
            MoveDelegate.getBattleTracker(this.getData()).addRelationshipChangesThisTurn(player1, player2, oldRelation, newRelation);
        }
        if (!change.isEmpty()) {
            this.m_bridge.addChange(change);
        }
        PoliticsDelegate.chainAlliancesTogether(this.m_bridge);
    }

    private boolean actionRollSucceeds(PoliticalActionAttachment paa) {
        int hitTarget = paa.getChanceToHit();
        int diceSides = paa.getChanceDiceSides();
        if (diceSides <= 0 || hitTarget >= diceSides) {
            paa.changeChanceDecrementOrIncrementOnSuccessOrFailure(this.m_bridge, true, true);
            return true;
        }
        if (hitTarget <= 0) {
            paa.changeChanceDecrementOrIncrementOnSuccessOrFailure(this.m_bridge, false, true);
            return false;
        }
        int rollResult = this.m_bridge.getRandom(diceSides, this.m_player, IRandomStats.DiceType.NONCOMBAT, "Attempting the Political Action: " + MyFormatter.attachmentNameToText(paa.getName())) + 1;
        boolean success = rollResult <= hitTarget;
        String notificationMessage = "rolling (" + hitTarget + " out of " + diceSides + ") result: " + rollResult + " = " + (success ? "Success!" : "Failure!");
        this.m_bridge.getHistoryWriter().addChildToEvent(MyFormatter.attachmentNameToText(paa.getName()) + " : " + notificationMessage);
        paa.changeChanceDecrementOrIncrementOnSuccessOrFailure(this.m_bridge, success, true);
        this.sendNotification(notificationMessage);
        return success;
    }

    private void resetAttempts() {
        for (PoliticalActionAttachment paa : PoliticalActionAttachment.getPoliticalActionAttachments(this.m_player)) {
            paa.resetAttempts(this.getBridge());
        }
    }

    public static void getMyselfOutOfAlliance(PoliticalActionAttachment paa, PlayerID player, IDelegateBridge aBridge) {
        GameData data = aBridge.getData();
        if (!Properties.getAlliancesCanChainTogether(data)) {
            return;
        }
        List<PlayerID> players = data.getPlayerList().getPlayers();
        List<PlayerID> p1AlliedWith = Match.getMatches(players, Matches.isAlliedAndAlliancesCanChainTogether(player, data));
        p1AlliedWith.remove(player);
        CompositeChange change = new CompositeChange();
        for (String relationshipChangeString : paa.getRelationshipChange()) {
            PlayerID pOther;
            String[] relationshipChange = relationshipChangeString.split(":");
            PlayerID p1 = data.getPlayerList().getPlayerID(relationshipChange[0]);
            PlayerID p2 = data.getPlayerList().getPlayerID(relationshipChange[1]);
            if (!p1.equals(player) && !p2.equals(player)) continue;
            PlayerID playerID = pOther = p1.equals(player) ? p2 : p1;
            if (!p1AlliedWith.contains(pOther)) continue;
            RelationshipType currentType = data.getRelationshipTracker().getRelationshipType(p1, p2);
            RelationshipType newType = data.getRelationshipTypeList().getRelationshipType(relationshipChange[2]);
            if (!Matches.RelationshipTypeIsAlliedAndAlliancesCanChainTogether.match(currentType) || !Matches.RelationshipTypeIsAlliedAndAlliancesCanChainTogether.invert().match(newType)) continue;
            for (PlayerID p3 : p1AlliedWith) {
                RelationshipType currentOther = data.getRelationshipTracker().getRelationshipType(p3, player);
                if (currentOther.equals(newType)) continue;
                change.add(ChangeFactory.relationshipChange(p3, player, currentOther, newType));
                aBridge.getHistoryWriter().addChildToEvent(player.getName() + " and " + p3.getName() + " sign a " + newType.getName() + " treaty");
                MoveDelegate.getBattleTracker(data).addRelationshipChangesThisTurn(p3, player, currentOther, newType);
            }
        }
        if (!change.isEmpty()) {
            aBridge.addChange(change);
        }
    }

    public static void getNeutralOutOfWarWithAllies(PoliticalActionAttachment paa, PlayerID player, IDelegateBridge aBridge) {
        GameData data = aBridge.getData();
        if (!Properties.getAlliancesCanChainTogether(data)) {
            return;
        }
        List<PlayerID> players = data.getPlayerList().getPlayers();
        List<PlayerID> p1AlliedWith = Match.getMatches(players, Matches.isAlliedAndAlliancesCanChainTogether(player, data));
        CompositeChange change = new CompositeChange();
        for (String relationshipChangeString : paa.getRelationshipChange()) {
            String[] relationshipChange = relationshipChangeString.split(":");
            PlayerID p1 = data.getPlayerList().getPlayerID(relationshipChange[0]);
            PlayerID p2 = data.getPlayerList().getPlayerID(relationshipChange[1]);
            if (!p1.equals(player) && !p2.equals(player)) continue;
            PlayerID pOther = p1.equals(player) ? p2 : p1;
            RelationshipType currentType = data.getRelationshipTracker().getRelationshipType(p1, p2);
            RelationshipType newType = data.getRelationshipTypeList().getRelationshipType(relationshipChange[2]);
            if (!Matches.RelationshipTypeIsAtWar.match(currentType) || !Matches.RelationshipTypeIsAtWar.invert().match(newType)) continue;
            List<PlayerID> pOtherAlliedWith = Match.getMatches(players, Matches.isAlliedAndAlliancesCanChainTogether(pOther, data));
            if (!pOtherAlliedWith.contains(pOther)) {
                pOtherAlliedWith.add(pOther);
            }
            if (!p1AlliedWith.contains(player)) {
                p1AlliedWith.add(player);
            }
            for (PlayerID p3 : p1AlliedWith) {
                for (PlayerID p4 : pOtherAlliedWith) {
                    RelationshipType currentOther = data.getRelationshipTracker().getRelationshipType(p3, p4);
                    if (currentOther.equals(newType) || !Matches.RelationshipTypeIsAtWar.match(currentOther)) continue;
                    change.add(ChangeFactory.relationshipChange(p3, p4, currentOther, newType));
                    aBridge.getHistoryWriter().addChildToEvent(p3.getName() + " and " + p4.getName() + " sign a " + newType.getName() + " treaty");
                    MoveDelegate.getBattleTracker(data).addRelationshipChangesThisTurn(p3, p4, currentOther, newType);
                }
            }
        }
        if (!change.isEmpty()) {
            aBridge.addChange(change);
        }
    }

    public static void chainAlliancesTogether(IDelegateBridge aBridge) {
        GameData data = aBridge.getData();
        if (!Properties.getAlliancesCanChainTogether(data)) {
            return;
        }
        Collection<RelationshipType> allTypes = data.getRelationshipTypeList().getAllRelationshipTypes();
        RelationshipType alliedType = null;
        RelationshipType warType = null;
        for (RelationshipType type : allTypes) {
            if (type.getRelationshipTypeAttachment().getIsDefaultWarPosition()) {
                warType = type;
                continue;
            }
            if (!type.getRelationshipTypeAttachment().getAlliancesCanChainTogether()) continue;
            alliedType = type;
        }
        if (alliedType == null) {
            return;
        }
        List<PlayerID> players = data.getPlayerList().getPlayers();
        for (PlayerID p1 : players) {
            HashSet<PlayerID> p1NewAllies = new HashSet<PlayerID>();
            List<PlayerID> p1AlliedWith = Match.getMatches(players, Matches.isAlliedAndAlliancesCanChainTogether(p1, data));
            for (PlayerID p2 : p1AlliedWith) {
                p1NewAllies.addAll(Match.getMatches(players, Matches.isAlliedAndAlliancesCanChainTogether(p2, data)));
            }
            p1NewAllies.removeAll(p1AlliedWith);
            p1NewAllies.remove(p1);
            for (PlayerID p3 : p1NewAllies) {
                if (data.getRelationshipTracker().getRelationshipType(p1, p3).equals(alliedType)) continue;
                RelationshipType current = data.getRelationshipTracker().getRelationshipType(p1, p3);
                aBridge.addChange(ChangeFactory.relationshipChange(p1, p3, current, alliedType));
                aBridge.getHistoryWriter().addChildToEvent(p1.getName() + " and " + p3.getName() + " are joined together in an " + alliedType.getName() + " treaty");
                MoveDelegate.getBattleTracker(data).addRelationshipChangesThisTurn(p1, p3, current, alliedType);
            }
        }
        if (warType == null) {
            return;
        }
        for (PlayerID p1 : players) {
            HashSet<PlayerID> p1NewWar = new HashSet<PlayerID>();
            List<PlayerID> p1WarWith = Match.getMatches(players, Matches.isAtWar(p1, data));
            List<PlayerID> p1AlliedWith = Match.getMatches(players, Matches.isAlliedAndAlliancesCanChainTogether(p1, data));
            for (PlayerID p2 : p1AlliedWith) {
                p1NewWar.addAll(Match.getMatches(players, Matches.isAtWar(p2, data)));
            }
            p1NewWar.removeAll(p1WarWith);
            p1NewWar.remove(p1);
            for (PlayerID p3 : p1NewWar) {
                if (data.getRelationshipTracker().getRelationshipType(p1, p3).equals(warType)) continue;
                RelationshipType current = data.getRelationshipTracker().getRelationshipType(p1, p3);
                aBridge.addChange(ChangeFactory.relationshipChange(p1, p3, current, warType));
                aBridge.getHistoryWriter().addChildToEvent(p1.getName() + " and " + p3.getName() + " declare " + warType.getName() + " on each other");
                MoveDelegate.getBattleTracker(data).addRelationshipChangesThisTurn(p1, p3, current, warType);
            }
        }
    }

    public static void givesBackOriginalTerritories(IDelegateBridge aBridge) {
        GameData data = aBridge.getData();
        CompositeChange change = new CompositeChange();
        List<PlayerID> players = data.getPlayerList().getPlayers();
        for (PlayerID p1 : players) {
            for (PlayerID p2 : players) {
                if (!data.getRelationshipTracker().givesBackOriginalTerritories(p1, p2)) continue;
                for (Territory t : data.getMap().getTerritoriesOwnedBy(p1)) {
                    PlayerID original = OriginalOwnerTracker.getOriginalOwner(t);
                    if (original == null || !original.equals(p2)) continue;
                    change.add(ChangeFactory.changeOwner(t, original));
                }
            }
        }
        if (!change.isEmpty()) {
            aBridge.getHistoryWriter().startEvent("Giving back territories to original owners");
            aBridge.addChange(change);
        }
    }
}

