/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.common.delegate.BaseTripleADelegate;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.NamedAttachable;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.RepairRule;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.message.IRemote;
import games.strategy.triplea.Properties;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.attatchments.AbstractTriggerAttachment;
import games.strategy.triplea.attatchments.ICondition;
import games.strategy.triplea.attatchments.TechAbilityAttachment;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.TriggerAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.attatchments.UnitTypeComparator;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.PurchaseExtendedDelegateState;
import games.strategy.triplea.delegate.remote.IPurchaseDelegate;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.CompositeMatchOr;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class PurchaseDelegate
extends BaseTripleADelegate
implements IPurchaseDelegate {
    private boolean m_needToInitialize = true;
    public static final String NOT_ENOUGH_RESOURCES = "Not enough resources";
    Comparator<RepairRule> repairRuleComparator = new Comparator<RepairRule>(){
        UnitTypeComparator utc = new UnitTypeComparator();

        @Override
        public int compare(RepairRule o1, RepairRule o2) {
            UnitType u1 = (UnitType)o1.getResults().keySet().iterator().next();
            UnitType u2 = (UnitType)o2.getResults().keySet().iterator().next();
            return this.utc.compare(u1, u2);
        }
    };

    @Override
    public void start() {
        super.start();
        GameData data = this.getData();
        if (this.m_needToInitialize) {
            if (Properties.getTriggers(data)) {
                CompositeMatchAnd<TriggerAttachment> purchaseDelegateTriggerMatch = new CompositeMatchAnd<TriggerAttachment>(AbstractTriggerAttachment.availableUses, AbstractTriggerAttachment.whenOrDefaultMatch(null, null), new CompositeMatchOr(TriggerAttachment.prodMatch(), TriggerAttachment.prodFrontierEditMatch(), TriggerAttachment.purchaseMatch()));
                HashSet<TriggerAttachment> toFirePossible = TriggerAttachment.collectForAllTriggersMatching(new HashSet<PlayerID>(Collections.singleton(this.m_player)), purchaseDelegateTriggerMatch, this.m_bridge);
                if (!toFirePossible.isEmpty()) {
                    HashMap<ICondition, Boolean> testedConditions = TriggerAttachment.collectTestsForAllTriggers(toFirePossible, this.m_bridge);
                    HashSet<TriggerAttachment> toFireTestedAndSatisfied = new HashSet<TriggerAttachment>(Match.getMatches(toFirePossible, AbstractTriggerAttachment.isSatisfiedMatch(testedConditions)));
                    TriggerAttachment.triggerProductionChange(toFireTestedAndSatisfied, this.m_bridge, null, null, true, true, true, true);
                    TriggerAttachment.triggerProductionFrontierEditChange(toFireTestedAndSatisfied, this.m_bridge, null, null, true, true, true, true);
                    TriggerAttachment.triggerPurchase(toFireTestedAndSatisfied, this.m_bridge, null, null, true, true, true, true);
                }
            }
            this.giveBonusIncomeToAI();
            this.m_needToInitialize = false;
        }
    }

    @Override
    public void end() {
        super.end();
        this.m_needToInitialize = true;
    }

    @Override
    public Serializable saveState() {
        PurchaseExtendedDelegateState state = new PurchaseExtendedDelegateState();
        state.superState = super.saveState();
        state.m_needToInitialize = this.m_needToInitialize;
        return state;
    }

    @Override
    public void loadState(Serializable state) {
        PurchaseExtendedDelegateState s = (PurchaseExtendedDelegateState)state;
        super.loadState(s.superState);
        this.m_needToInitialize = s.m_needToInitialize;
    }

    @Override
    public boolean delegateCurrentlyRequiresUserInput() {
        if ((this.m_player.getProductionFrontier() == null || this.m_player.getProductionFrontier().getRules().isEmpty()) && (this.m_player.getRepairFrontier() == null || this.m_player.getRepairFrontier().getRules().isEmpty())) {
            return false;
        }
        if (!this.canWePurchaseOrRepair()) {
            return false;
        }
        return TerritoryAttachment.doWeHaveEnoughCapitalsToProduce(this.m_player, this.getData());
    }

    protected boolean canWePurchaseOrRepair() {
        if (this.m_player.getProductionFrontier() != null && this.m_player.getProductionFrontier().getRules() != null) {
            for (ProductionRule productionRule : this.m_player.getProductionFrontier().getRules()) {
                if (!this.m_player.getResources().has(productionRule.getCosts())) continue;
                return true;
            }
        }
        if (this.m_player.getRepairFrontier() != null && this.m_player.getRepairFrontier().getRules() != null) {
            for (RepairRule repairRule : this.m_player.getRepairFrontier().getRules()) {
                if (!this.m_player.getResources().has(repairRule.getCosts())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean canAfford(IntegerMap<Resource> costs, PlayerID player) {
        return player.getResources().has(costs);
    }

    @Override
    public String purchase(IntegerMap<ProductionRule> productionRules) {
        IntegerMap<Resource> costs = this.getCosts(productionRules, this.m_player);
        IntegerMap<NamedAttachable> results = this.getResults(productionRules);
        if (!this.canAfford(costs, this.m_player)) {
            return NOT_ENOUGH_RESOURCES;
        }
        for (NamedAttachable next : results.keySet()) {
            if (next instanceof Resource) continue;
            UnitType type = (UnitType)next;
            int quantity = results.getInt(type);
            UnitAttachment ua = UnitAttachment.get(type);
            int maxBuilt = ua.getMaxBuiltPerPlayer();
            if (maxBuilt == 0) {
                return "May not build any of this unit right now: " + type.getName();
            }
            if (maxBuilt <= 0) continue;
            int currentlyBuilt = this.m_player.getUnits().countMatches(Matches.unitIsOfType(type));
            CompositeMatchAnd<Unit> unitTypeOwnedBy = new CompositeMatchAnd<Unit>(Matches.unitIsOfType(type), Matches.unitIsOwnedBy(this.m_player));
            List<Territory> allTerrs = this.getData().getMap().getTerritories();
            for (Territory t : allTerrs) {
                currentlyBuilt += t.getUnits().countMatches(unitTypeOwnedBy);
            }
            int allowedBuild = maxBuilt - currentlyBuilt;
            if (allowedBuild - quantity >= 0) continue;
            return "May only build " + allowedBuild + " of " + type.getName() + " this turn, may only build " + maxBuilt + " total";
        }
        Iterator<NamedAttachable> iter = results.keySet().iterator();
        ArrayList<Unit> totalUnits = new ArrayList<Unit>();
        ArrayList<UnitType> totalUnitTypes = new ArrayList<UnitType>();
        ArrayList<Resource> totalResources = new ArrayList<Resource>();
        ArrayList<NamedAttachable> totalAll = new ArrayList<NamedAttachable>();
        CompositeChange changes = new CompositeChange();
        while (iter.hasNext()) {
            int i;
            int quantity;
            NamedAttachable next = iter.next();
            if (next instanceof Resource) {
                Resource resource = (Resource)next;
                quantity = results.getInt(resource);
                Change change = ChangeFactory.changeResourcesChange(this.m_player, resource, quantity);
                changes.add(change);
                for (i = 0; i < quantity; ++i) {
                    totalResources.add(resource);
                }
                continue;
            }
            UnitType type = (UnitType)next;
            quantity = results.getInt(type);
            List<Unit> units = type.create(quantity, this.m_player);
            totalUnits.addAll(units);
            for (i = 0; i < quantity; ++i) {
                totalUnitTypes.add(type);
            }
        }
        totalAll.addAll(totalUnitTypes);
        totalAll.addAll(totalResources);
        if (!totalUnits.isEmpty()) {
            Change change = ChangeFactory.addUnits(this.m_player, totalUnits);
            changes.add(change);
        }
        String remaining = this.removeFromPlayer(this.m_player, costs, changes);
        String transcriptText = !totalUnits.isEmpty() ? this.m_player.getName() + " buy " + MyFormatter.defaultNamedToTextList(totalAll, ", ", true) + "; " + remaining : this.m_player.getName() + " buy nothing; " + remaining;
        this.m_bridge.getHistoryWriter().startEvent(transcriptText, totalUnits);
        this.m_bridge.addChange(changes);
        return null;
    }

    @Override
    public String purchaseRepair(Map<Unit, IntegerMap<RepairRule>> repairRules) {
        IntegerMap<Resource> costs = this.getRepairCosts(repairRules, this.m_player);
        if (!this.canAfford(costs, this.m_player)) {
            return NOT_ENOUGH_RESOURCES;
        }
        if (!Properties.getDamageFromBombingDoneToUnitsInsteadOfTerritories(this.getData())) {
            return null;
        }
        IntegerMap<Unit> repairMap = this.getUnitRepairs(repairRules);
        if (repairMap.isEmpty()) {
            return null;
        }
        CompositeChange changes = new CompositeChange();
        HashSet<Unit> repairUnits = new HashSet<Unit>(repairMap.keySet());
        IntegerMap<Unit> damageMap = new IntegerMap<Unit>();
        for (Unit u : repairUnits) {
            TripleAUnit taUnit;
            int newDamageTotal;
            int repairCount = repairMap.getInt(u);
            if (repairCount <= 0 || (newDamageTotal = Math.max(0, (taUnit = (TripleAUnit)u).getUnitDamage() - repairCount)) == taUnit.getUnitDamage()) continue;
            damageMap.put(u, newDamageTotal);
        }
        if (!damageMap.isEmpty()) {
            changes.add(ChangeFactory.bombingUnitDamage(damageMap));
        }
        String remaining = this.removeFromPlayer(this.m_player, costs, changes);
        String transcriptText = !damageMap.isEmpty() ? this.m_player.getName() + " repair damage of " + MyFormatter.integerUnitMapToString(repairMap, ", ", "x ", true) + "; " + remaining : this.m_player.getName() + " repair nothing; " + remaining;
        this.m_bridge.getHistoryWriter().startEvent(transcriptText, new HashSet<Unit>(damageMap.keySet()));
        if (!changes.isEmpty()) {
            this.m_bridge.addChange(changes);
        }
        return null;
    }

    private IntegerMap<Unit> getUnitRepairs(Map<Unit, IntegerMap<RepairRule>> repairRules) {
        IntegerMap<Unit> repairMap = new IntegerMap<Unit>();
        for (Unit u : repairRules.keySet()) {
            IntegerMap<RepairRule> rules = repairRules.get(u);
            TreeSet<RepairRule> repRules = new TreeSet<RepairRule>(this.repairRuleComparator);
            repRules.addAll(rules.keySet());
            for (RepairRule repairRule : repRules) {
                int quantity = rules.getInt(repairRule) * repairRule.getResults().getInt(u.getType());
                repairMap.add(u, quantity);
            }
        }
        return repairMap;
    }

    private IntegerMap<Resource> getCosts(IntegerMap<ProductionRule> productionRules, PlayerID player) {
        IntegerMap<Resource> costs = new IntegerMap<Resource>();
        for (ProductionRule rule : productionRules.keySet()) {
            costs.addMultiple(rule.getCosts(), productionRules.getInt(rule));
        }
        return costs;
    }

    private IntegerMap<Resource> getRepairCosts(Map<Unit, IntegerMap<RepairRule>> repairRules, PlayerID player) {
        Set<Unit> units = repairRules.keySet();
        Iterator iter = units.iterator();
        IntegerMap<Resource> costs = new IntegerMap<Resource>();
        while (iter.hasNext()) {
            Unit u = (Unit)iter.next();
            for (RepairRule rule : repairRules.get(u).keySet()) {
                costs.addMultiple(rule.getCosts(), repairRules.get(u).getInt(rule));
            }
        }
        double discount = TechAbilityAttachment.getRepairDiscount(player, this.getData());
        if (discount != 1.0) {
            costs.multiplyAllValuesBy(discount, 3);
        }
        return costs;
    }

    private IntegerMap<NamedAttachable> getResults(IntegerMap<ProductionRule> productionRules) {
        IntegerMap<NamedAttachable> costs = new IntegerMap<NamedAttachable>();
        for (ProductionRule rule : productionRules.keySet()) {
            costs.addMultiple(rule.getResults(), productionRules.getInt(rule));
        }
        return costs;
    }

    @Override
    public Class<? extends IRemote> getRemoteType() {
        return IPurchaseDelegate.class;
    }

    protected String removeFromPlayer(PlayerID player, IntegerMap<Resource> costs, CompositeChange changes) {
        StringBuffer returnString = new StringBuffer("Remaining resources: ");
        IntegerMap<Resource> left = this.m_player.getResources().getResourcesCopy();
        left.subtract(costs);
        for (Map.Entry<Resource, Integer> entry : left.entrySet()) {
            returnString.append(entry.getValue() + " " + entry.getKey().getName() + "; ");
        }
        for (Resource resource : costs.keySet()) {
            float quantity = costs.getInt(resource);
            int cost = (int)quantity;
            Change change = ChangeFactory.changeResourcesChange(this.m_player, resource, -cost);
            changes.add(change);
        }
        return returnString.toString();
    }

    private void giveBonusIncomeToAI() {
        if (!this.m_player.isAI()) {
            return;
        }
        int currentPUs = this.m_player.getResources().getQuantity("PUs");
        if (currentPUs <= 0) {
            return;
        }
        int toGive = 0;
        int bonusPercent = Properties.getAIBonusIncomePercentage(this.getData());
        if (bonusPercent != 0 && (toGive += (int)Math.round((double)currentPUs * (double)bonusPercent / 100.0)) == 0 && bonusPercent > 0 && currentPUs > 0) {
            ++toGive;
        }
        if ((toGive += Properties.getAIBonusIncomeFlatRate(this.getData())) + currentPUs < 0) {
            toGive = currentPUs * -1;
        }
        if (toGive == 0) {
            return;
        }
        this.m_bridge.getHistoryWriter().startEvent("Giving AI player bonus income modifier of " + toGive + MyFormatter.pluralize(" PU", toGive));
        this.m_bridge.addChange(ChangeFactory.changeResourcesChange(this.m_player, this.getData().getResourceList().getResource("PUs"), toGive));
    }
}

