/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.common.delegate.BaseTripleADelegate;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.message.IRemote;
import games.strategy.engine.random.IRandomStats;
import games.strategy.triplea.Properties;
import games.strategy.triplea.delegate.BattleCalculator;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.OriginalOwnerTracker;
import games.strategy.triplea.delegate.RandomStartExtendedDelegateState;
import games.strategy.triplea.delegate.UnitCostComparator;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import games.strategy.util.Tuple;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RandomStartDelegate
extends BaseTripleADelegate {
    private static final int UNITS_PER_PICK = 1;
    protected PlayerID m_currentPickingPlayer = null;

    @Override
    public void start() {
        super.start();
        this.setupBoard();
    }

    @Override
    public void end() {
        super.end();
        this.m_currentPickingPlayer = null;
    }

    @Override
    public boolean delegateCurrentlyRequiresUserInput() {
        return !Match.noneMatch(this.getData().getMap().getTerritories(), this.getTerritoryPickableMatch()) || !Match.noneMatch(this.getData().getPlayerList().getPlayers(), this.getPlayerCanPickMatch());
    }

    @Override
    public Serializable saveState() {
        RandomStartExtendedDelegateState state = new RandomStartExtendedDelegateState();
        state.superState = super.saveState();
        state.m_currentPickingPlayer = this.m_currentPickingPlayer;
        return state;
    }

    @Override
    public void loadState(Serializable state) {
        RandomStartExtendedDelegateState s = (RandomStartExtendedDelegateState)state;
        super.loadState(s.superState);
        this.m_currentPickingPlayer = s.m_currentPickingPlayer;
    }

    protected void setupBoard() {
        Tuple<Territory, Set<Unit>> pick;
        List<Unit> factoryAndInfrastructure;
        CompositeChange change;
        Set<Unit> unitsToPlace;
        GameData data = this.getData();
        boolean randomTerritories = Properties.getTerritoriesAreAssignedRandomly(data);
        Match<Territory> pickableTerritoryMatch = this.getTerritoryPickableMatch();
        Match<PlayerID> playerCanPickMatch = this.getPlayerCanPickMatch();
        List<Territory> allPickableTerritories = Match.getMatches(data.getMap().getTerritories(), pickableTerritoryMatch);
        ArrayList<PlayerID> playersCanPick = new ArrayList<PlayerID>();
        playersCanPick.addAll(Match.getMatches(data.getPlayerList().getPlayers(), playerCanPickMatch));
        if (!playersCanPick.isEmpty()) {
            this.m_bridge.getHistoryWriter().startEvent("Assigning Territories");
        }
        int[] hitRandom = !randomTerritories ? new int[]{} : this.m_bridge.getRandom(allPickableTerritories.size(), allPickableTerritories.size(), null, IRandomStats.DiceType.ENGINE, "Picking random territories");
        int i = 0;
        int pos = 0;
        while (!allPickableTerritories.isEmpty() && !playersCanPick.isEmpty()) {
            Territory picked;
            if (this.m_currentPickingPlayer == null || !playersCanPick.contains(this.m_currentPickingPlayer)) {
                this.m_currentPickingPlayer = (PlayerID)playersCanPick.get(0);
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (randomTerritories) {
                pos += hitRandom[i];
                ++i;
                IntegerMap<UnitType> costs = BattleCalculator.getCostsForTUV(this.m_currentPickingPlayer, data);
                ArrayList<Unit> units = new ArrayList<Unit>(this.m_currentPickingPlayer.getUnits().getUnits());
                Collections.sort(units, new UnitCostComparator(costs));
                unitsToPlace = new HashSet<Unit>();
                unitsToPlace.add((Unit)units.get(0));
                picked = allPickableTerritories.get(pos % allPickableTerritories.size());
                change = new CompositeChange();
                change.add(ChangeFactory.changeOwner(picked, this.m_currentPickingPlayer));
                factoryAndInfrastructure = Match.getMatches(unitsToPlace, Matches.UnitIsInfrastructure);
                if (!factoryAndInfrastructure.isEmpty()) {
                    change.add(OriginalOwnerTracker.addOriginalOwnerChange(factoryAndInfrastructure, this.m_currentPickingPlayer));
                }
                change.add(ChangeFactory.removeUnits(this.m_currentPickingPlayer, unitsToPlace));
                change.add(ChangeFactory.addUnits(picked, unitsToPlace));
                this.m_bridge.getHistoryWriter().addChildToEvent(this.m_currentPickingPlayer.getName() + " receives territory " + picked.getName() + " with units " + MyFormatter.unitsToTextNoOwner(unitsToPlace), picked);
                this.m_bridge.addChange(change);
            } else {
                Set<Unit> unitsToPlace2;
                while (true) {
                    pick = this.getRemotePlayer(this.m_currentPickingPlayer).pickTerritoryAndUnits(new ArrayList<Territory>(allPickableTerritories), new ArrayList<Unit>(this.m_currentPickingPlayer.getUnits().getUnits()), 1);
                    picked = pick.getFirst();
                    unitsToPlace2 = pick.getSecond();
                    if (allPickableTerritories.contains(picked) && this.m_currentPickingPlayer.getUnits().getUnits().containsAll(unitsToPlace2) && unitsToPlace2.size() <= 1 && (unitsToPlace2.size() >= 1 || unitsToPlace2.size() >= this.m_currentPickingPlayer.getUnits().getUnits().size())) break;
                    this.getRemotePlayer(this.m_currentPickingPlayer).reportMessage("Chosen territory or units invalid!", "Chosen territory or units invalid!");
                }
                CompositeChange change2 = new CompositeChange();
                change2.add(ChangeFactory.changeOwner(picked, this.m_currentPickingPlayer));
                List<Unit> factoryAndInfrastructure2 = Match.getMatches(unitsToPlace2, Matches.UnitIsInfrastructure);
                if (!factoryAndInfrastructure2.isEmpty()) {
                    change2.add(OriginalOwnerTracker.addOriginalOwnerChange(factoryAndInfrastructure2, this.m_currentPickingPlayer));
                }
                change2.add(ChangeFactory.removeUnits(this.m_currentPickingPlayer, unitsToPlace2));
                change2.add(ChangeFactory.addUnits(picked, unitsToPlace2));
                this.m_bridge.getHistoryWriter().addChildToEvent(this.m_currentPickingPlayer.getName() + " picks territory " + picked.getName() + " and places in it " + MyFormatter.unitsToTextNoOwner(unitsToPlace2), unitsToPlace2);
                this.m_bridge.addChange(change2);
            }
            allPickableTerritories.remove(picked);
            PlayerID lastPlayer = this.m_currentPickingPlayer;
            this.m_currentPickingPlayer = this.getNextPlayer(playersCanPick, this.m_currentPickingPlayer);
            if (!playerCanPickMatch.match(lastPlayer)) {
                playersCanPick.remove(lastPlayer);
            }
            if (!playersCanPick.isEmpty()) continue;
            this.m_currentPickingPlayer = null;
        }
        while (!playersCanPick.isEmpty()) {
            Territory picked;
            if (this.m_currentPickingPlayer == null || !playersCanPick.contains(this.m_currentPickingPlayer)) {
                this.m_currentPickingPlayer = (PlayerID)playersCanPick.get(0);
            }
            List<Territory> territoriesToPickFrom = data.getMap().getTerritoriesOwnedBy(this.m_currentPickingPlayer);
            while (true) {
                pick = this.getRemotePlayer(this.m_currentPickingPlayer).pickTerritoryAndUnits(new ArrayList<Territory>(territoriesToPickFrom), new ArrayList<Unit>(this.m_currentPickingPlayer.getUnits().getUnits()), 1);
                picked = pick.getFirst();
                unitsToPlace = pick.getSecond();
                if (territoriesToPickFrom.contains(picked) && this.m_currentPickingPlayer.getUnits().getUnits().containsAll(unitsToPlace) && unitsToPlace.size() <= 1 && (unitsToPlace.size() >= 1 || unitsToPlace.size() >= this.m_currentPickingPlayer.getUnits().getUnits().size())) break;
                this.getRemotePlayer(this.m_currentPickingPlayer).reportMessage("Chosen territory or units invalid!", "Chosen territory or units invalid!");
            }
            change = new CompositeChange();
            factoryAndInfrastructure = Match.getMatches(unitsToPlace, Matches.UnitIsInfrastructure);
            if (!factoryAndInfrastructure.isEmpty()) {
                change.add(OriginalOwnerTracker.addOriginalOwnerChange(factoryAndInfrastructure, this.m_currentPickingPlayer));
            }
            change.add(ChangeFactory.removeUnits(this.m_currentPickingPlayer, unitsToPlace));
            change.add(ChangeFactory.addUnits(picked, unitsToPlace));
            this.m_bridge.getHistoryWriter().addChildToEvent(this.m_currentPickingPlayer.getName() + " places " + MyFormatter.unitsToTextNoOwner(unitsToPlace) + " in territory " + picked.getName(), unitsToPlace);
            this.m_bridge.addChange(change);
            PlayerID lastPlayer = this.m_currentPickingPlayer;
            this.m_currentPickingPlayer = this.getNextPlayer(playersCanPick, this.m_currentPickingPlayer);
            if (!playerCanPickMatch.match(lastPlayer)) {
                playersCanPick.remove(lastPlayer);
            }
            if (!playersCanPick.isEmpty()) continue;
            this.m_currentPickingPlayer = null;
        }
    }

    protected PlayerID getNextPlayer(List<PlayerID> playersCanPick, PlayerID currentPlayer) {
        int index = playersCanPick.indexOf(currentPlayer);
        if (index == -1) {
            return null;
        }
        if (++index >= playersCanPick.size()) {
            index = 0;
        }
        return playersCanPick.get(index);
    }

    public Match<Territory> getTerritoryPickableMatch() {
        return new CompositeMatchAnd<Territory>(Matches.TerritoryIsLand, Matches.TerritoryIsNotImpassable, Matches.isTerritoryOwnedBy(PlayerID.NULL_PLAYERID), Matches.TerritoryIsEmpty);
    }

    public Match<PlayerID> getPlayerCanPickMatch() {
        return new Match<PlayerID>(){

            @Override
            public boolean match(PlayerID player) {
                if (player == null || player.equals(PlayerID.NULL_PLAYERID)) {
                    return false;
                }
                if (player.getUnits().isEmpty()) {
                    return false;
                }
                return !player.getIsDisabled();
            }
        };
    }

    @Override
    public Class<? extends IRemote> getRemoteType() {
        return null;
    }
}

