/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.engine.random.IRandomStats;
import games.strategy.triplea.Properties;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.attatchments.TechAbilityAttachment;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.AbstractMoveDelegate;
import games.strategy.triplea.delegate.BattleTracker;
import games.strategy.triplea.delegate.DelegateFinder;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.triplea.player.ITripleaPlayer;
import games.strategy.util.CompositeMatch;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RocketsFireHelper {
    private boolean isWW2V2(GameData data) {
        return Properties.getWW2V2(data);
    }

    private boolean isAllRocketsAttack(GameData data) {
        return Properties.getAllRocketsAttack(data);
    }

    private boolean isRocketsCanFlyOverImpassables(GameData data) {
        return Properties.getRocketsCanFlyOverImpassables(data);
    }

    private boolean isDamageFromBombingDoneToUnitsInsteadOfTerritories(GameData data) {
        return Properties.getDamageFromBombingDoneToUnitsInsteadOfTerritories(data);
    }

    private boolean isRocketAttacksPerFactoryInfinite(GameData data) {
        return Properties.getRocketAttacksPerFactoryInfinite(data);
    }

    private boolean isPUCap(GameData data) {
        return Properties.getPUCap(data);
    }

    private boolean isLimitRocketDamagePerTurn(GameData data) {
        return Properties.getLimitRocketDamagePerTurn(data);
    }

    private boolean isLimitRocketDamageToProduction(GameData data) {
        return Properties.getLimitRocketAndSBRDamageToProduction(data);
    }

    public void fireRockets(IDelegateBridge bridge, PlayerID player) {
        GameData data = bridge.getData();
        Set<Territory> rocketTerritories = this.getTerritoriesWithRockets(data, player);
        if (rocketTerritories.isEmpty()) {
            bridge.getHistoryWriter().startEvent(player.getName() + " has no rockets to fire");
            return;
        }
        if (this.isWW2V2(data) || this.isAllRocketsAttack(data)) {
            this.fireWW2V2(bridge, player, rocketTerritories);
        } else {
            this.fireWW2V1(bridge, player, rocketTerritories);
        }
    }

    private void fireWW2V2(IDelegateBridge bridge, PlayerID player, Set<Territory> rocketTerritories) {
        GameData data = bridge.getData();
        HashSet<Territory> attackedTerritories = new HashSet<Territory>();
        boolean oneAttackPerTerritory = !this.isRocketAttacksPerFactoryInfinite(data);
        for (Territory territory : rocketTerritories) {
            Territory target;
            Set<Territory> targets = this.getTargetsWithinRange(territory, data, player);
            if (oneAttackPerTerritory) {
                targets.removeAll(attackedTerritories);
            }
            if (targets.isEmpty() || (target = this.getTarget(targets, player, bridge, territory)) == null) continue;
            if (oneAttackPerTerritory) {
                attackedTerritories.add(target);
            }
            this.fireRocket(player, target, bridge, territory);
        }
    }

    private void fireWW2V1(IDelegateBridge bridge, PlayerID player, Set<Territory> rocketTerritories) {
        GameData data = bridge.getData();
        HashSet<Territory> targets = new HashSet<Territory>();
        for (Territory territory : rocketTerritories) {
            targets.addAll(this.getTargetsWithinRange(territory, data, player));
        }
        if (targets.isEmpty()) {
            bridge.getHistoryWriter().startEvent(player.getName() + " has no targets to attack with rockets");
            return;
        }
        Territory attacked = this.getTarget(targets, player, bridge, null);
        if (attacked != null) {
            this.fireRocket(player, attacked, bridge, null);
        }
    }

    Set<Territory> getTerritoriesWithRockets(GameData data, PlayerID player) {
        HashSet<Territory> territories = new HashSet<Territory>();
        CompositeMatch<Unit> ownedRockets = this.rocketMatch(player, data);
        BattleTracker tracker = AbstractMoveDelegate.getBattleTracker(data);
        for (Territory current : data.getMap()) {
            if (tracker.wasConquered(current) || !current.getUnits().someMatch(ownedRockets)) continue;
            territories.add(current);
        }
        return territories;
    }

    CompositeMatch<Unit> rocketMatch(PlayerID player, GameData data) {
        return new CompositeMatchAnd<Unit>(Matches.UnitIsRocket, Matches.unitIsOwnedBy(player), Matches.UnitIsNotDisabled, Matches.unitIsBeingTransported().invert(), Matches.unitIsSubmerged(data).invert(), Matches.unitHasNotMoved);
    }

    private Set<Territory> getTargetsWithinRange(Territory territory, GameData data, PlayerID player) {
        int maxDistance = TechAbilityAttachment.getRocketDistance(player, data);
        Set<Territory> possible = data.getMap().getNeighbors(territory, maxDistance);
        HashSet<Territory> hasFactory = new HashSet<Territory>();
        CompositeMatchAnd<Territory> allowed = new CompositeMatchAnd<Territory>(Matches.territoryAllowsRocketsCanFlyOver(player, data));
        if (!this.isRocketsCanFlyOverImpassables(data)) {
            allowed.add(Matches.TerritoryIsNotImpassable);
        }
        CompositeMatchAnd attackableUnits = new CompositeMatchAnd(Matches.enemyUnit(player, data), Matches.unitIsBeingTransported().invert());
        for (Territory current : possible) {
            Route route = data.getMap().getRoute(territory, current, allowed);
            if (route == null || route.numberOfSteps() > maxDistance || !current.getUnits().someMatch(new CompositeMatchAnd<Unit>(attackableUnits, Matches.UnitIsAtMaxDamageOrNotCanBeDamaged(current).invert()))) continue;
            hasFactory.add(current);
        }
        return hasFactory;
    }

    private Territory getTarget(Collection<Territory> targets, PlayerID player, IDelegateBridge bridge, Territory from) {
        return ((ITripleaPlayer)bridge.getRemotePlayer()).whereShouldRocketsAttack(targets, from);
    }

    private void fireRocket(PlayerID player, Territory attackedTerritory, IDelegateBridge bridge, Territory attackFrom) {
        String transcript;
        int numberOfAttacks;
        GameData data = bridge.getData();
        PlayerID attacked = attackedTerritory.getOwner();
        Resource PUs = data.getResourceList().getResource("PUs");
        boolean DamageFromBombingDoneToUnits = this.isDamageFromBombingDoneToUnitsInsteadOfTerritories(data);
        List<Unit> enemyUnits = attackedTerritory.getUnits().getMatches(new CompositeMatchAnd<Unit>(Matches.enemyUnit(player, data), Matches.unitIsBeingTransported().invert()));
        List<Unit> enemyTargetsTotal = Match.getMatches(enemyUnits, Matches.UnitIsAtMaxDamageOrNotCanBeDamaged(attackedTerritory).invert());
        ArrayList<Unit> targets = new ArrayList<Unit>();
        ArrayList<Unit> rockets = attackFrom == null ? null : new ArrayList<Unit>(Match.getMatches(attackFrom.getUnits().getUnits(), this.rocketMatch(player, data)));
        int n = numberOfAttacks = rockets == null ? 1 : Math.min(TechAbilityAttachment.getRocketNumberPerTerritory(player, data), TechAbilityAttachment.getRocketDiceNumber(rockets, data));
        if (numberOfAttacks <= 0) {
            return;
        }
        if (DamageFromBombingDoneToUnits) {
            HashSet<UnitType> legalTargetsForTheseRockets = new HashSet<UnitType>();
            if (rockets == null) {
                legalTargetsForTheseRockets.addAll(data.getUnitTypeList().getAllUnitTypes());
            } else {
                for (Unit r : rockets) {
                    legalTargetsForTheseRockets.addAll(UnitAttachment.get(r.getType()).getBombingTargets(data));
                }
            }
            List<Unit> enemyTargets = Match.getMatches(enemyTargetsTotal, Matches.unitIsOfTypes(legalTargetsForTheseRockets));
            if (enemyTargets.isEmpty()) {
                return;
            }
            Unit target = null;
            if (enemyTargets.size() == 1) {
                target = (Unit)enemyTargets.iterator().next();
            } else {
                while (target == null) {
                    ITripleaPlayer iplayer = (ITripleaPlayer)bridge.getRemotePlayer(player);
                    target = iplayer.whatShouldBomberBomb(attackedTerritory, enemyTargets, rockets);
                }
            }
            if (target == null) {
                throw new IllegalStateException("No Targets in " + attackedTerritory.getName());
            }
            targets.add(target);
        }
        boolean doNotUseBombingBonus = !Properties.getUseBombingMaxDiceSidesAndBonus(data) || rockets == null;
        int cost = 0;
        if (!Properties.getLL_DAMAGE_ONLY(data)) {
            if (doNotUseBombingBonus || rockets == null) {
                int[] rolls;
                for (int r : rolls = bridge.getRandom(data.getDiceSides(), numberOfAttacks, player, IRandomStats.DiceType.BOMBING, "Rocket fired by " + player.getName() + " at " + attacked.getName())) {
                    cost += r + 1;
                }
                transcript = "Rockets " + (attackFrom == null ? "" : "in " + attackFrom.getName()) + " roll: " + MyFormatter.asDice(rolls);
            } else {
                int highestMaxDice = 0;
                int highestBonus = 0;
                int diceSides = data.getDiceSides();
                for (Unit u : rockets) {
                    UnitAttachment ua = UnitAttachment.get(u.getType());
                    int maxDice = ua.getBombingMaxDieSides();
                    int bonus = ua.getBombingBonus();
                    if (maxDice < 0) {
                        maxDice = diceSides;
                    }
                    if (bonus < 0) {
                        bonus = 0;
                    }
                    if (bonus + (maxDice + 1) / 2 <= highestBonus + (highestMaxDice + 1) / 2) continue;
                    highestMaxDice = maxDice;
                    highestBonus = bonus;
                }
                if (highestMaxDice > 0) {
                    int[] rolls = bridge.getRandom(highestMaxDice, numberOfAttacks, player, IRandomStats.DiceType.BOMBING, "Rocket fired by " + player.getName() + " at " + attacked.getName());
                    for (int i = 0; i < rolls.length; ++i) {
                        int r;
                        rolls[i] = r = rolls[i] + highestBonus;
                        cost += r + 1;
                    }
                    transcript = "Rockets " + (attackFrom == null ? "" : "in " + attackFrom.getName()) + " roll: " + MyFormatter.asDice(rolls);
                } else {
                    cost = highestBonus * numberOfAttacks;
                    transcript = "Rockets " + (attackFrom == null ? "" : "in " + attackFrom.getName()) + " do " + highestBonus + " damage for each rocket";
                }
            }
        } else if (doNotUseBombingBonus || rockets == null) {
            int maxDice = (data.getDiceSides() + 1) / 3;
            int bonus = (data.getDiceSides() + 1) / 3;
            int[] rolls = bridge.getRandom(maxDice, numberOfAttacks, player, IRandomStats.DiceType.BOMBING, "Rocket fired by " + player.getName() + " at " + attacked.getName());
            for (int i = 0; i < rolls.length; ++i) {
                int r;
                rolls[i] = r = rolls[i] + bonus;
                cost += r + 1;
            }
            transcript = "Rockets " + (attackFrom == null ? "" : "in " + attackFrom.getName()) + " roll: " + MyFormatter.asDice(rolls);
        } else {
            int highestMaxDice = 0;
            int highestBonus = 0;
            int diceSides = data.getDiceSides();
            for (Unit u : rockets) {
                UnitAttachment ua = UnitAttachment.get(u.getType());
                int maxDice = ua.getBombingMaxDieSides();
                int bonus = ua.getBombingBonus();
                if (maxDice < 0 || doNotUseBombingBonus) {
                    maxDice = diceSides;
                }
                if (bonus < 0 || doNotUseBombingBonus) {
                    bonus = 0;
                }
                if (maxDice >= 5) {
                    bonus += (maxDice + 1) / 3;
                    maxDice = (maxDice + 1) / 3;
                }
                if (bonus + (maxDice + 1) / 2 <= highestBonus + (highestMaxDice + 1) / 2) continue;
                highestMaxDice = maxDice;
                highestBonus = bonus;
            }
            if (highestMaxDice > 0) {
                int[] rolls = bridge.getRandom(highestMaxDice, numberOfAttacks, player, IRandomStats.DiceType.BOMBING, "Rocket fired by " + player.getName() + " at " + attacked.getName());
                for (int i = 0; i < rolls.length; ++i) {
                    int r;
                    rolls[i] = r = rolls[i] + highestBonus;
                    cost += r + 1;
                }
                transcript = "Rockets " + (attackFrom == null ? "" : "in " + attackFrom.getName()) + " roll: " + MyFormatter.asDice(rolls);
            } else {
                cost = highestBonus * numberOfAttacks;
                transcript = "Rockets " + (attackFrom == null ? "" : "in " + attackFrom.getName()) + " do " + highestBonus + " damage for each rocket";
            }
        }
        int territoryProduction = TerritoryAttachment.getProduction(attackedTerritory);
        if (DamageFromBombingDoneToUnits && !targets.isEmpty()) {
            Unit target = (Unit)targets.iterator().next();
            TripleAUnit taUnit = (TripleAUnit)target;
            int damageLimit = taUnit.getHowMuchMoreDamageCanThisUnitTake(target, attackedTerritory);
            cost = Math.max(0, Math.min(cost, damageLimit));
            int totalDamage = taUnit.getUnitDamage() + cost;
            IntegerMap<Unit> damageMap = new IntegerMap<Unit>();
            damageMap.put(target, totalDamage);
            bridge.addChange(ChangeFactory.bombingUnitDamage(damageMap));
        } else if (this.isWW2V2(data) || this.isLimitRocketDamageToProduction(data)) {
            if (this.isPUCap(data) || this.isLimitRocketDamagePerTurn(data)) {
                int alreadyLost = DelegateFinder.moveDelegate(data).PUsAlreadyLost(attackedTerritory);
                territoryProduction -= alreadyLost;
                territoryProduction = Math.max(0, territoryProduction);
            }
            if (cost > territoryProduction) {
                cost = territoryProduction;
            }
        }
        DelegateFinder.moveDelegate(data).PUsLost(attackedTerritory, cost);
        if (DamageFromBombingDoneToUnits && !targets.isEmpty()) {
            this.getRemote(bridge).reportMessage("Rocket attack in " + attackedTerritory.getName() + " does " + cost + " damage to " + targets.iterator().next(), "Rocket attack in " + attackedTerritory.getName() + " does " + cost + " damage to " + targets.iterator().next());
            bridge.getHistoryWriter().startEvent("Rocket attack in " + attackedTerritory.getName() + " does " + cost + " damage to " + targets.iterator().next());
        } else {
            this.getRemote(bridge).reportMessage("Rocket attack in " + attackedTerritory.getName() + " costs:" + (cost *= Properties.getPU_Multiplier(data)), "Rocket attack in " + attackedTerritory.getName() + " costs:" + cost);
            int availForRemoval = attacked.getResources().getQuantity(PUs);
            if (cost > availForRemoval) {
                cost = availForRemoval;
            }
            String transcriptText = attacked.getName() + " lost " + cost + " PUs to rocket attack by " + player.getName();
            bridge.getHistoryWriter().startEvent(transcriptText);
            Change rocketCharge = ChangeFactory.changeResourcesChange(attacked, PUs, -cost);
            bridge.addChange(rocketCharge);
        }
        bridge.getHistoryWriter().addChildToEvent(transcript, rockets == null ? null : new ArrayList<Unit>(rockets));
        if (attackFrom != null) {
            if (rockets != null && !rockets.isEmpty()) {
                Change change = ChangeFactory.markNoMovementChange(Collections.singleton(rockets.iterator().next()));
                bridge.addChange(change);
            } else {
                throw new IllegalStateException("No rockets?" + attackFrom.getUnits().getUnits());
            }
        }
        if (Match.someMatch(targets, Matches.UnitCanDieFromReachingMaxDamage)) {
            List<Unit> unitsCanDie = Match.getMatches(targets, Matches.UnitCanDieFromReachingMaxDamage);
            unitsCanDie.retainAll(Match.getMatches(unitsCanDie, Matches.UnitIsAtMaxDamageOrNotCanBeDamaged(attackedTerritory)));
            if (!unitsCanDie.isEmpty()) {
                Change removeDead = ChangeFactory.removeUnits(attackedTerritory, unitsCanDie);
                String transcriptText = MyFormatter.unitsToText(unitsCanDie) + " lost in " + attackedTerritory.getName();
                bridge.getHistoryWriter().addChildToEvent(transcriptText, unitsCanDie);
                bridge.addChange(removeDead);
            }
        }
        if (cost > 0) {
            bridge.getSoundChannelBroadcaster().playSoundForAll("bombing_rocket", player.getName());
        }
    }

    private ITripleaPlayer getRemote(IDelegateBridge bridge) {
        return (ITripleaPlayer)bridge.getRemotePlayer();
    }
}

