/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.common.delegate.BaseTripleADelegate;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.message.IRemote;
import games.strategy.triplea.Properties;
import games.strategy.triplea.attatchments.ICondition;
import games.strategy.triplea.attatchments.PlayerAttachment;
import games.strategy.triplea.attatchments.TriggerAttachment;
import games.strategy.triplea.delegate.DelegateFinder;
import games.strategy.triplea.delegate.TechActivationExtendedDelegateState;
import games.strategy.triplea.delegate.TechAdvance;
import games.strategy.triplea.delegate.TechTracker;
import games.strategy.triplea.delegate.TechnologyDelegate;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.CompositeMatchOr;
import games.strategy.util.Match;
import games.strategy.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TechActivationDelegate
extends BaseTripleADelegate {
    private boolean m_needToInitialize = true;

    @Override
    public void start() {
        super.start();
        GameData data = this.getData();
        if (!this.m_needToInitialize) {
            return;
        }
        Map<PlayerID, Collection<TechAdvance>> techMap = DelegateFinder.techDelegate(data).getAdvances();
        Collection<TechAdvance> advances = techMap.get(this.m_player);
        if (advances != null && advances.size() > 0) {
            this.m_bridge.getHistoryWriter().startEvent(this.m_player.getName() + " activating " + this.advancesAsString(advances));
            for (TechAdvance advance : advances) {
                TechTracker.addAdvance(this.m_player, this.m_bridge, advance);
            }
        }
        techMap.put(this.m_player, null);
        if (Properties.getTriggers(data)) {
            CompositeMatchAnd<TriggerAttachment> techActivationDelegateTriggerMatch = new CompositeMatchAnd<TriggerAttachment>(TriggerAttachment.availableUses, TriggerAttachment.whenOrDefaultMatch(null, null), new CompositeMatchOr(TriggerAttachment.unitPropertyMatch(), TriggerAttachment.techMatch(), TriggerAttachment.supportMatch()));
            HashSet<TriggerAttachment> toFirePossible = TriggerAttachment.collectForAllTriggersMatching(new HashSet<PlayerID>(Collections.singleton(this.m_player)), techActivationDelegateTriggerMatch, this.m_bridge);
            if (!toFirePossible.isEmpty()) {
                HashMap<ICondition, Boolean> testedConditions = TriggerAttachment.collectTestsForAllTriggers(toFirePossible, this.m_bridge);
                HashSet<TriggerAttachment> toFireTestedAndSatisfied = new HashSet<TriggerAttachment>(Match.getMatches(toFirePossible, TriggerAttachment.isSatisfiedMatch(testedConditions)));
                TriggerAttachment.triggerUnitPropertyChange(toFireTestedAndSatisfied, this.m_bridge, null, null, true, true, true, true);
                TriggerAttachment.triggerTechChange(toFireTestedAndSatisfied, this.m_bridge, null, null, true, true, true, true);
                TriggerAttachment.triggerSupportChange(toFireTestedAndSatisfied, this.m_bridge, null, null, true, true, true, true);
            }
        }
        this.shareTechnology();
        this.m_needToInitialize = false;
    }

    @Override
    public void end() {
        super.end();
        this.m_needToInitialize = true;
    }

    @Override
    public boolean delegateCurrentlyRequiresUserInput() {
        return false;
    }

    private void shareTechnology() {
        PlayerAttachment pa = PlayerAttachment.get(this.m_player);
        if (pa == null) {
            return;
        }
        ArrayList<PlayerID> shareWith = pa.getShareTechnology();
        if (shareWith == null || shareWith.isEmpty()) {
            return;
        }
        GameData data = this.getData();
        Collection<TechAdvance> currentAdvances = TechTracker.getCurrentTechAdvances(this.m_player, data);
        for (PlayerID p : shareWith) {
            List<TechAdvance> availableTechs = TechnologyDelegate.getAvailableTechs(p, data);
            List<TechAdvance> toGive = Util.intersection(currentAdvances, availableTechs);
            if (toGive.isEmpty()) continue;
            this.m_bridge.getHistoryWriter().startEvent(this.m_player.getName() + " giving technology to " + p.getName() + ": " + this.advancesAsString(toGive));
            for (TechAdvance advance : toGive) {
                TechTracker.addAdvance(p, this.m_bridge, advance);
            }
        }
    }

    @Override
    public Serializable saveState() {
        TechActivationExtendedDelegateState state = new TechActivationExtendedDelegateState();
        state.superState = super.saveState();
        state.m_needToInitialize = this.m_needToInitialize;
        return state;
    }

    @Override
    public void loadState(Serializable state) {
        TechActivationExtendedDelegateState s = (TechActivationExtendedDelegateState)state;
        super.loadState(s.superState);
        this.m_needToInitialize = s.m_needToInitialize;
    }

    private String advancesAsString(Collection<TechAdvance> advances) {
        Iterator<TechAdvance> iter = advances.iterator();
        int count = advances.size();
        StringBuilder text = new StringBuilder();
        while (iter.hasNext()) {
            TechAdvance advance = iter.next();
            text.append(advance.getName());
            if (--count > 1) {
                text.append(", ");
            }
            if (count != 1) continue;
            text.append(" and ");
        }
        return text.toString();
    }

    @Override
    public Class<? extends IRemote> getRemoteType() {
        return null;
    }
}

