/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.common.delegate.BaseEditDelegate;
import games.strategy.common.delegate.BaseTripleADelegate;
import games.strategy.common.delegate.GameDelegateBridge;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.TechnologyFrontier;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.engine.random.IRandomStats;
import games.strategy.triplea.Properties;
import games.strategy.triplea.attatchments.AbstractTriggerAttachment;
import games.strategy.triplea.attatchments.ICondition;
import games.strategy.triplea.attatchments.PlayerAttachment;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.TriggerAttachment;
import games.strategy.triplea.delegate.DiceRoll;
import games.strategy.triplea.delegate.TechAdvance;
import games.strategy.triplea.delegate.TechTracker;
import games.strategy.triplea.delegate.TechnologyExtendedDelegateState;
import games.strategy.triplea.delegate.dataObjects.TechResults;
import games.strategy.triplea.delegate.remote.ITechDelegate;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.triplea.player.ITripleaPlayer;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.CompositeMatchOr;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import games.strategy.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TechnologyDelegate
extends BaseTripleADelegate
implements ITechDelegate {
    private int m_techCost;
    private HashMap<PlayerID, Collection<TechAdvance>> m_techs;
    private TechnologyFrontier m_techCategory;
    private boolean m_needToInitialize = true;

    @Override
    public void initialize(String name, String displayName) {
        super.initialize(name, displayName);
        this.m_techs = new HashMap();
        this.m_techCost = -1;
    }

    @Override
    public void setDelegateBridgeAndPlayer(IDelegateBridge iDelegateBridge) {
        super.setDelegateBridgeAndPlayer(new GameDelegateBridge(iDelegateBridge));
    }

    @Override
    public void start() {
        super.start();
        if (!this.m_needToInitialize) {
            return;
        }
        if (Properties.getTriggers(this.getData())) {
            CompositeMatchAnd<TriggerAttachment> technologyDelegateTriggerMatch = new CompositeMatchAnd<TriggerAttachment>(AbstractTriggerAttachment.availableUses, AbstractTriggerAttachment.whenOrDefaultMatch(null, null), new CompositeMatchOr(TriggerAttachment.techAvailableMatch()));
            HashSet<TriggerAttachment> toFirePossible = TriggerAttachment.collectForAllTriggersMatching(new HashSet<PlayerID>(Collections.singleton(this.m_player)), technologyDelegateTriggerMatch, this.m_bridge);
            if (!toFirePossible.isEmpty()) {
                HashMap<ICondition, Boolean> testedConditions = TriggerAttachment.collectTestsForAllTriggers(toFirePossible, this.m_bridge);
                List<TriggerAttachment> toFireTestedAndSatisfied = Match.getMatches(toFirePossible, AbstractTriggerAttachment.isSatisfiedMatch(testedConditions));
                TriggerAttachment.triggerAvailableTechChange(new HashSet<TriggerAttachment>(toFireTestedAndSatisfied), this.m_bridge, null, null, true, true, true, true);
            }
        }
        this.m_needToInitialize = false;
    }

    @Override
    public void end() {
        super.end();
        this.m_needToInitialize = true;
    }

    @Override
    public Serializable saveState() {
        TechnologyExtendedDelegateState state = new TechnologyExtendedDelegateState();
        state.superState = super.saveState();
        state.m_needToInitialize = this.m_needToInitialize;
        state.m_techs = this.m_techs;
        return state;
    }

    @Override
    public void loadState(Serializable state) {
        TechnologyExtendedDelegateState s = (TechnologyExtendedDelegateState)state;
        super.loadState(s.superState);
        this.m_needToInitialize = s.m_needToInitialize;
        this.m_techs = s.m_techs;
    }

    @Override
    public boolean delegateCurrentlyRequiresUserInput() {
        int techTokens;
        Resource techtokens;
        if (!Properties.getTechDevelopment(this.getData())) {
            return false;
        }
        if (!TerritoryAttachment.doWeHaveEnoughCapitalsToProduce(this.m_player, this.getData())) {
            return false;
        }
        if (Properties.getWW2V3TechModel(this.getData()) && (techtokens = this.getData().getResourceList().getResource("techTokens")) != null && (techTokens = this.m_player.getResources().getQuantity(techtokens)) > 0) {
            return true;
        }
        int techCost = TechTracker.getTechCost(this.m_player);
        int money = this.m_player.getResources().getQuantity("PUs");
        if (money < techCost) {
            PlayerAttachment pa = PlayerAttachment.get(this.m_player);
            if (pa == null) {
                return false;
            }
            ArrayList<PlayerID> helpPay = pa.getHelpPayTechCost();
            if (helpPay == null || helpPay.isEmpty()) {
                return false;
            }
            for (PlayerID p : helpPay) {
                money += p.getResources().getQuantity("PUs");
            }
            if (money < techCost) {
                return false;
            }
        }
        return true;
    }

    public Map<PlayerID, Collection<TechAdvance>> getAdvances() {
        return this.m_techs;
    }

    private boolean isWW2V2() {
        return Properties.getWW2V2(this.getData());
    }

    private boolean isWW2V3TechModel() {
        return Properties.getWW2V3TechModel(this.getData());
    }

    private boolean isSelectableTechRoll() {
        return Properties.getSelectableTechRoll(this.getData());
    }

    private boolean isLL_TECH_ONLY() {
        return Properties.getLL_TECH_ONLY(this.getData());
    }

    @Override
    public TechResults rollTech(int techRolls, TechnologyFrontier techToRollFor, int newTokens, IntegerMap<PlayerID> whoPaysHowMuch) {
        int[] random;
        GameData data;
        boolean canPay;
        int rollCount = techRolls;
        if (this.isWW2V3TechModel()) {
            rollCount = newTokens;
        }
        if (!(canPay = this.checkEnoughMoney(rollCount, whoPaysHowMuch))) {
            return new TechResults("Not enough money to pay for that many tech rolls.");
        }
        this.chargeForTechRolls(rollCount, whoPaysHowMuch);
        int m_currTokens = 0;
        if (this.isWW2V3TechModel()) {
            m_currTokens = this.m_player.getResources().getQuantity("techTokens");
        }
        if (TechnologyDelegate.getAvailableTechs(this.m_player, data = this.getData()).isEmpty()) {
            if (this.isWW2V3TechModel()) {
                Resource techTokens = data.getResourceList().getResource("techTokens");
                String transcriptText = this.m_player.getName() + " No more available tech advances.";
                this.m_bridge.getHistoryWriter().startEvent(transcriptText);
                Change removeTokens = ChangeFactory.changeResourcesChange(this.m_bridge.getPlayerID(), techTokens, -m_currTokens);
                this.m_bridge.addChange(removeTokens);
            }
            return new TechResults("No more available tech advances.");
        }
        String annotation = this.m_player.getName() + " rolling for tech.";
        int techHits = 0;
        int remainder = 0;
        int diceSides = data.getDiceSides();
        if (BaseEditDelegate.getEditMode(data)) {
            ITripleaPlayer tripleaPlayer = this.getRemotePlayer();
            random = tripleaPlayer.selectFixedDice(techRolls, diceSides, true, annotation, diceSides);
            techHits = this.getTechHits(random);
        } else if (this.isLL_TECH_ONLY()) {
            techHits = techRolls / diceSides;
            remainder = techRolls % diceSides;
            if (remainder > 0) {
                random = this.m_bridge.getRandom(diceSides, 1, this.m_player, IRandomStats.DiceType.TECH, annotation);
                if (random[0] + 1 <= remainder) {
                    ++techHits;
                }
            } else {
                random = this.m_bridge.getRandom(diceSides, 1, this.m_player, IRandomStats.DiceType.TECH, annotation);
                remainder = diceSides;
            }
        } else {
            random = this.m_bridge.getRandom(diceSides, techRolls, this.m_player, IRandomStats.DiceType.TECH, annotation);
            techHits = this.getTechHits(random);
        }
        boolean isRevisedModel = this.isWW2V2() || this.isSelectableTechRoll() && !this.isWW2V3TechModel();
        String directedTechInfo = isRevisedModel ? " for " + techToRollFor.getTechs().get(0) : "";
        DiceRoll renderDice = this.isLL_TECH_ONLY() ? new DiceRoll(random, techHits, remainder, false) : new DiceRoll(random, techHits, diceSides - 1, true);
        this.m_bridge.getHistoryWriter().startEvent(this.m_player.getName() + (random.length > 1 ? " roll " : " rolls : ") + MyFormatter.asDice(random) + directedTechInfo + " and gets " + techHits + " " + MyFormatter.pluralize("hit", techHits), renderDice);
        if (this.isWW2V3TechModel() && (techHits > 0 || Properties.getRemoveAllTechTokensAtEndOfTurn(data))) {
            this.m_techCategory = techToRollFor;
            Resource techTokens = data.getResourceList().getResource("techTokens");
            String transcriptText = this.m_player.getName() + " removing all Technology Tokens after " + (techHits > 0 ? "successful" : "unsuccessful") + " research.";
            this.m_bridge.getHistoryWriter().startEvent(transcriptText);
            Change removeTokens = ChangeFactory.changeResourcesChange(this.m_bridge.getPlayerID(), techTokens, -m_currTokens);
            this.m_bridge.addChange(removeTokens);
        }
        Collection<Object> advances = isRevisedModel ? (techHits > 0 ? Collections.singletonList(techToRollFor.getTechs().get(0)) : Collections.emptyList()) : this.getTechAdvances(techHits);
        this.m_techs.put(this.m_player, advances);
        ArrayList<String> advancesAsString = new ArrayList<String>();
        Iterator<Object> iter = advances.iterator();
        int count = advances.size();
        StringBuilder text = new StringBuilder();
        while (iter.hasNext()) {
            TechAdvance advance = (TechAdvance)iter.next();
            text.append(advance.getName());
            advancesAsString.add(advance.getName());
            if (--count > 1) {
                text.append(", ");
            }
            if (count != 1) continue;
            text.append(" and ");
        }
        String transcriptText = this.m_player.getName() + " discover " + text.toString();
        if (advances.size() > 0) {
            this.m_bridge.getHistoryWriter().startEvent(transcriptText);
            this.getSoundChannel().playSoundForAll("technology_successful", this.m_player.getName());
        } else {
            this.getSoundChannel().playSoundForAll("technology_failure", this.m_player.getName());
        }
        return new TechResults(random, remainder, techHits, advancesAsString, this.m_player);
    }

    boolean checkEnoughMoney(int rolls, IntegerMap<PlayerID> whoPaysHowMuch) {
        Resource PUs = this.getData().getResourceList().getResource("PUs");
        int cost = rolls * this.getTechCost();
        if (whoPaysHowMuch == null || whoPaysHowMuch.isEmpty()) {
            int has = this.m_bridge.getPlayerID().getResources().getQuantity(PUs);
            return has >= cost;
        }
        int runningTotal = 0;
        for (Map.Entry<PlayerID, Integer> entry : whoPaysHowMuch.entrySet()) {
            int has = entry.getKey().getResources().getQuantity(PUs);
            int paying = entry.getValue();
            if (paying > has) {
                return false;
            }
            runningTotal += paying;
        }
        return runningTotal >= cost;
    }

    private void chargeForTechRolls(int rolls, IntegerMap<PlayerID> whoPaysHowMuch) {
        Resource PUs = this.getData().getResourceList().getResource("PUs");
        int cost = rolls * this.getTechCost();
        if (whoPaysHowMuch == null || whoPaysHowMuch.isEmpty()) {
            String transcriptText = this.m_bridge.getPlayerID().getName() + " spend " + cost + " on tech rolls";
            this.m_bridge.getHistoryWriter().startEvent(transcriptText);
            Change charge = ChangeFactory.changeResourcesChange(this.m_bridge.getPlayerID(), PUs, -cost);
            this.m_bridge.addChange(charge);
        } else {
            for (Map.Entry<PlayerID, Integer> entry : whoPaysHowMuch.entrySet()) {
                PlayerID p = entry.getKey();
                int pays = Math.min(cost, entry.getValue());
                if (pays <= 0) continue;
                cost -= pays;
                String transcriptText = p.getName() + " spend " + pays + " on tech rolls";
                this.m_bridge.getHistoryWriter().startEvent(transcriptText);
                Change charge = ChangeFactory.changeResourcesChange(p, PUs, -pays);
                this.m_bridge.addChange(charge);
            }
        }
        if (this.isWW2V3TechModel()) {
            Resource tokens = this.getData().getResourceList().getResource("techTokens");
            Change newTokens = ChangeFactory.changeResourcesChange(this.m_bridge.getPlayerID(), tokens, rolls);
            this.m_bridge.addChange(newTokens);
        }
    }

    private int getTechHits(int[] random) {
        int count = 0;
        for (int element : random) {
            if (element != this.getData().getDiceSides() - 1) continue;
            ++count;
        }
        return count;
    }

    private Collection<TechAdvance> getTechAdvances(int hits) {
        ArrayList<Integer> rolled;
        int[] random;
        List<Object> available = new ArrayList();
        if (hits > 0 && this.isWW2V3TechModel()) {
            available = this.getAvailableAdvancesForCategory(this.m_techCategory);
            hits = 1;
        } else {
            available = this.getAvailableAdvances();
        }
        if (available.isEmpty()) {
            return Collections.emptyList();
        }
        if (hits >= available.size()) {
            return available;
        }
        if (hits == 0) {
            return Collections.emptyList();
        }
        ArrayList<TechAdvance> newAdvances = new ArrayList<TechAdvance>(hits);
        String annotation = this.m_player.getName() + " rolling to see what tech advances are aquired";
        if (this.isSelectableTechRoll() || BaseEditDelegate.getEditMode(this.getData())) {
            ITripleaPlayer tripleaPlayer = this.getRemotePlayer();
            random = tripleaPlayer.selectFixedDice(hits, 0, true, annotation, available.size());
        } else {
            random = new int[hits];
            rolled = new ArrayList<Integer>();
            for (int i = 0; i < hits; ++i) {
                int roll = this.m_bridge.getRandom(available.size() - i, null, IRandomStats.DiceType.ENGINE, annotation);
                Iterator i$ = rolled.iterator();
                while (i$.hasNext()) {
                    int r = (Integer)i$.next();
                    if (roll < r) continue;
                    ++roll;
                }
                random[i] = roll;
                rolled.add(roll);
            }
        }
        rolled = new ArrayList();
        for (int element : random) {
            int index = element;
            if (rolled.contains(index) || index >= available.size()) continue;
            newAdvances.add((TechAdvance)available.get(index));
            rolled.add(index);
        }
        this.m_bridge.getHistoryWriter().startEvent("Rolls to resolve tech hits:" + MyFormatter.asDice(random));
        return newAdvances;
    }

    private List<TechAdvance> getAvailableAdvances() {
        return TechnologyDelegate.getAvailableTechs(this.m_bridge.getPlayerID(), this.getData());
    }

    public static List<TechAdvance> getAvailableTechs(PlayerID player, GameData data) {
        Collection<TechAdvance> currentAdvances = TechTracker.getCurrentTechAdvances(player, data);
        List<TechAdvance> allAdvances = TechAdvance.getTechAdvances(data, player);
        return Util.difference(allAdvances, currentAdvances);
    }

    private List<TechAdvance> getAvailableAdvancesForCategory(TechnologyFrontier techCategory) {
        Collection<TechAdvance> playersAdvances = TechTracker.getCurrentTechAdvances(this.m_bridge.getPlayerID(), this.getData());
        List<TechAdvance> available = Util.difference(techCategory.getTechs(), playersAdvances);
        return available;
    }

    public int getTechCost() {
        this.m_techCost = TechTracker.getTechCost(this.m_player);
        return this.m_techCost;
    }

    public Class<ITechDelegate> getRemoteType() {
        return ITechDelegate.class;
    }
}

