/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.Properties;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.GameStepPropertiesHelper;
import games.strategy.triplea.delegate.MoveValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TransportTracker {
    public static int getCost(Collection<Unit> units) {
        return MoveValidator.getTransportCost(units);
    }

    private static void assertTransport(Unit u) {
        if (UnitAttachment.get(u.getType()).getTransportCapacity() == -1) {
            throw new IllegalStateException("Not a transport:" + u);
        }
    }

    private TransportTracker() {
    }

    public static Collection<Unit> transporting(Unit transport) {
        return new ArrayList<Unit>(((TripleAUnit)transport).getTransporting());
    }

    public static Collection<Unit> transporting(Unit transport, Collection<Unit> transportedUnitsPossible) {
        return new ArrayList<Unit>(((TripleAUnit)transport).getTransporting(transportedUnitsPossible));
    }

    public static boolean isTransporting(Unit transport) {
        return !((TripleAUnit)transport).getTransporting().isEmpty();
    }

    public static Collection<Unit> unloaded(Unit transport) {
        return ((TripleAUnit)transport).getUnloaded();
    }

    public static Collection<Unit> transportingAndUnloaded(Unit transport) {
        Collection<Unit> rVal = TransportTracker.transporting(transport);
        if (rVal == null) {
            rVal = new ArrayList<Unit>();
        }
        rVal.addAll(TransportTracker.unloaded(transport));
        return rVal;
    }

    public static Map<Unit, Collection<Unit>> transporting(Collection<Unit> units) {
        HashMap<Unit, Collection<Unit>> returnVal = new HashMap<Unit, Collection<Unit>>();
        for (Unit transported : units) {
            Unit transport = TransportTracker.transportedBy(transported);
            Collection<Unit> transporting = null;
            if (transport != null) {
                transporting = TransportTracker.transporting(transport);
            }
            if (transporting == null) continue;
            returnVal.put(transport, transporting);
        }
        return returnVal;
    }

    public static Map<Unit, Collection<Unit>> transporting(Collection<Unit> transports, Collection<Unit> transportedUnits) {
        HashMap<Unit, Collection<Unit>> returnVal = new HashMap<Unit, Collection<Unit>>();
        for (Unit transported : transportedUnits) {
            Unit transport = TransportTracker.transportedBy(transported);
            Collection<Unit> transporting = null;
            if (transport != null) {
                transporting = TransportTracker.transporting(transport, transportedUnits);
            }
            if (transporting == null) continue;
            returnVal.put(transport, transporting);
        }
        return returnVal;
    }

    public static Unit transportedBy(Unit unit) {
        return ((TripleAUnit)unit).getTransportedBy();
    }

    public static Change unloadTransportChange(TripleAUnit unit, Territory territory, PlayerID id, boolean dependentBattle) {
        CompositeChange change = new CompositeChange();
        TripleAUnit transport = (TripleAUnit)TransportTracker.transportedBy(unit);
        if (transport == null) {
            return change;
        }
        TransportTracker.assertTransport(transport);
        if (!transport.getTransporting().contains(unit)) {
            throw new IllegalStateException("Not being carried, unit:" + unit + " transport:" + transport);
        }
        ArrayList<Unit> newUnloaded = new ArrayList<Unit>(transport.getUnloaded());
        newUnloaded.add(unit);
        change.add(ChangeFactory.unitPropertyChange(unit, territory, "unloadedTo"));
        if (!GameStepPropertiesHelper.isNonCombatMove(unit.getData(), true)) {
            change.add(ChangeFactory.unitPropertyChange(unit, true, "wasUnloadedInCombatPhase"));
            change.add(ChangeFactory.unitPropertyChange(unit, true, "wasAmphibious"));
            change.add(ChangeFactory.unitPropertyChange(transport, true, "wasUnloadedInCombatPhase"));
            change.add(ChangeFactory.unitPropertyChange(transport, true, "wasAmphibious"));
        }
        if (!dependentBattle) {
            change.add(ChangeFactory.unitPropertyChange(unit, null, "transportedBy"));
        }
        change.add(ChangeFactory.unitPropertyChange(transport, newUnloaded, "unloaded"));
        return change;
    }

    public static Change unloadAirTransportChange(TripleAUnit unit, Territory territory, PlayerID id, boolean dependentBattle) {
        CompositeChange change = new CompositeChange();
        TripleAUnit transport = (TripleAUnit)TransportTracker.transportedBy(unit);
        if (transport == null) {
            return change;
        }
        TransportTracker.assertTransport(transport);
        if (!transport.getTransporting().contains(unit)) {
            throw new IllegalStateException("Not being carried, unit:" + unit + " transport:" + transport);
        }
        ArrayList<Unit> newUnloaded = new ArrayList<Unit>(transport.getUnloaded());
        newUnloaded.add(unit);
        change.add(ChangeFactory.unitPropertyChange(unit, territory, "unloadedTo"));
        if (!GameStepPropertiesHelper.isNonCombatMove(unit.getData(), true)) {
            change.add(ChangeFactory.unitPropertyChange(unit, true, "wasUnloadedInCombatPhase"));
            change.add(ChangeFactory.unitPropertyChange(transport, true, "wasUnloadedInCombatPhase"));
        }
        if (!dependentBattle) {
            change.add(ChangeFactory.unitPropertyChange(unit, null, "transportedBy"));
        }
        return change;
    }

    public static Change loadTransportChange(TripleAUnit transport, Unit unit) {
        TransportTracker.assertTransport(transport);
        CompositeChange change = new CompositeChange();
        change.add(ChangeFactory.unitPropertyChange(unit, transport, "transportedBy"));
        ArrayList<Unit> newCarrying = new ArrayList<Unit>(transport.getTransporting());
        if (newCarrying.contains(unit)) {
            throw new IllegalStateException("Already carrying, transport:" + transport + " unt:" + unit);
        }
        newCarrying.add(unit);
        change.add(ChangeFactory.unitPropertyChange(unit, Boolean.TRUE, "wasLoadedThisTurn"));
        change.add(ChangeFactory.unitPropertyChange(transport, true, "wasLoadedThisTurn"));
        if (transport.getWasInCombat()) {
            change.add(ChangeFactory.unitPropertyChange(transport, true, "wasLoadedAfterCombat"));
        }
        return change;
    }

    public static Change combatTransportChange(TripleAUnit transport, PlayerID id) {
        TransportTracker.assertTransport(transport);
        CompositeChange change = new CompositeChange();
        change.add(ChangeFactory.unitPropertyChange(transport, true, "wasInCombat"));
        return change;
    }

    public static int getAvailableCapacity(Unit unit) {
        UnitAttachment ua = UnitAttachment.get(unit.getType());
        if (ua.getTransportCapacity() == -1 || unit.getData().getProperties().get("Pacific Theater", false) && ua.getIsDestroyer() && !unit.getOwner().getName().equals("Japanese")) {
            return 0;
        }
        int capacity = ua.getTransportCapacity();
        int used = TransportTracker.getCost(TransportTracker.transporting(unit));
        int unloaded = TransportTracker.getCost(TransportTracker.unloaded(unit));
        return capacity - used - unloaded;
    }

    public static Collection<Unit> getUnitsLoadedOnAlliedTransportsThisTurn(Collection<Unit> units) {
        ArrayList<Unit> rVal = new ArrayList<Unit>();
        for (Unit u : units) {
            TripleAUnit taUnit = (TripleAUnit)u;
            if (!taUnit.getWasLoadedThisTurn() || taUnit.getTransportedBy() == null || taUnit.getTransportedBy().getOwner().equals(taUnit.getOwner())) continue;
            rVal.add(u);
        }
        return rVal;
    }

    public static boolean hasTransportUnloadedInPreviousPhase(Unit transport) {
        List<Unit> unloaded = ((TripleAUnit)transport).getUnloaded();
        for (Unit u : unloaded) {
            TripleAUnit taUnit = (TripleAUnit)u;
            if (!GameStepPropertiesHelper.isNonCombatMove(transport.getData(), true) || !taUnit.getWasUnloadedInCombatPhase()) continue;
            return true;
        }
        return false;
    }

    private static boolean isWW2V2(GameData data) {
        return Properties.getWW2V2(data);
    }

    private static boolean isTransportUnloadRestricted(GameData data) {
        return Properties.getTransportUnloadRestricted(data);
    }

    public static boolean isTransportUnloadRestrictedToAnotherTerritory(Unit transport, Territory territory) {
        List<Unit> unloaded = ((TripleAUnit)transport).getUnloaded();
        if (unloaded.isEmpty()) {
            return false;
        }
        GameData data = transport.getData();
        for (Unit u : unloaded) {
            TripleAUnit taUnit = (TripleAUnit)u;
            if (!(TransportTracker.isWW2V2(data) || TransportTracker.isTransportUnloadRestricted(data) ? !taUnit.getUnloadedTo().equals(territory) : !GameStepPropertiesHelper.isNonCombatMove(transport.getData(), true) && !taUnit.getUnloadedTo().equals(territory))) continue;
            return true;
        }
        return false;
    }

    public static Territory getTerritoryTransportHasUnloadedTo(Unit transport) {
        List<Unit> unloaded = ((TripleAUnit)transport).getUnloaded();
        if (unloaded.isEmpty()) {
            return null;
        }
        Iterator iter = unloaded.iterator();
        return ((TripleAUnit)iter.next()).getUnloadedTo();
    }

    public static boolean isTransportUnloadRestrictedInNonCombat(Unit transport) {
        TripleAUnit taUnit = (TripleAUnit)transport;
        return GameStepPropertiesHelper.isNonCombatMove(transport.getData(), true) && taUnit.getWasInCombat() && taUnit.getWasLoadedAfterCombat();
    }
}

