/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.triplea.delegate.AbstractPlaceDelegate;
import games.strategy.triplea.delegate.AbstractUndoableMove;
import games.strategy.triplea.delegate.dataObjects.PlacementDescription;
import games.strategy.triplea.formatter.MyFormatter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

class UndoablePlacement
extends AbstractUndoableMove {
    private static final long serialVersionUID = -1493488646587233451L;
    final Territory m_placeTerritory;
    Territory m_producerTerritory;
    PlayerID m_player;

    public UndoablePlacement(PlayerID player, CompositeChange change, Territory producer_territory, Territory place_territory, Collection<Unit> units) {
        super(change, units);
        this.m_placeTerritory = place_territory;
        this.m_producerTerritory = producer_territory;
        this.m_player = player;
    }

    public Territory getProducerTerritory() {
        return this.m_producerTerritory;
    }

    public void setProducerTerritory(Territory producerTerritory) {
        this.m_producerTerritory = producerTerritory;
    }

    public Territory getPlaceTerritory() {
        return this.m_placeTerritory;
    }

    @Override
    protected final void undoSpecific(IDelegateBridge bridge) {
        GameData data = bridge.getData();
        AbstractPlaceDelegate currentDelegate = (AbstractPlaceDelegate)data.getSequence().getStep().getDelegate();
        Map<Territory, Collection<Unit>> produced = currentDelegate.getProduced();
        Collection<Unit> units = produced.get(this.m_producerTerritory);
        units.removeAll(this.getUnits());
        if (units.isEmpty()) {
            produced.remove(this.m_producerTerritory);
        }
        currentDelegate.setProduced(new HashMap<Territory, Collection<Unit>>(produced));
    }

    @Override
    public final String getMoveLabel() {
        if (this.m_producerTerritory != this.m_placeTerritory) {
            return this.m_producerTerritory.getName() + " -> " + this.m_placeTerritory.getName();
        }
        return this.m_placeTerritory.getName();
    }

    @Override
    public final Territory getEnd() {
        return this.m_placeTerritory;
    }

    @Override
    protected final PlacementDescription getDescriptionObject() {
        return new PlacementDescription(this.m_units, this.m_placeTerritory);
    }

    public String toString() {
        if (this.m_producerTerritory != this.m_placeTerritory) {
            return this.m_producerTerritory.getName() + " produces in " + this.m_placeTerritory.getName() + ": " + MyFormatter.unitsToTextNoOwner(this.m_units);
        }
        return this.m_placeTerritory.getName() + ": " + MyFormatter.unitsToTextNoOwner(this.m_units);
    }
}

