/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.TerritoryEffect;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.Properties;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.BattleCalculator;
import games.strategy.triplea.delegate.Matches;
import games.strategy.util.IntegerMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;

public class UnitBattleComparator
implements Comparator<Unit> {
    private final boolean m_defending;
    private final IntegerMap<UnitType> m_costs;
    private final GameData m_data;
    private final boolean m_bonus;
    private final boolean m_ignorePrimaryPower;
    private final Collection<TerritoryEffect> m_territoryEffects;
    private final Collection<UnitType> m_multiHitpointCanRepair = new HashSet<UnitType>();

    public UnitBattleComparator(boolean defending, IntegerMap<UnitType> costs, Collection<TerritoryEffect> territoryEffects, GameData data, boolean bonus, boolean ignorePrimaryPower) {
        this.m_defending = defending;
        this.m_costs = costs;
        this.m_data = data;
        this.m_bonus = bonus;
        this.m_ignorePrimaryPower = ignorePrimaryPower;
        this.m_territoryEffects = territoryEffects;
        if (Properties.getBattleshipsRepairAtEndOfRound(data) || Properties.getBattleshipsRepairAtBeginningOfRound(data)) {
            for (UnitType ut : data.getUnitTypeList()) {
                if (!Matches.UnitTypeHasMoreThanOneHitPointTotal.match(ut)) continue;
                this.m_multiHitpointCanRepair.add(ut);
            }
        }
    }

    @Override
    public int compare(Unit u1, Unit u2) {
        int cost2;
        int cost1;
        UnitAttachment ua2;
        if (u1.equals(u2)) {
            return 0;
        }
        boolean transporting1 = Matches.transportIsTransporting().match(u1);
        boolean transporting2 = Matches.transportIsTransporting().match(u2);
        UnitAttachment ua1 = UnitAttachment.get(u1.getType());
        if (ua1 == (ua2 = UnitAttachment.get(u2.getType())) && u1.getOwner().equals(u2.getOwner())) {
            if (transporting1 && !transporting2) {
                return 1;
            }
            if (!transporting1 && transporting2) {
                return -1;
            }
            return 0;
        }
        boolean airOrCarrierOrTransport1 = Matches.UnitIsAir.match(u1) || Matches.UnitIsCarrier.match(u1) || !transporting1 && Matches.UnitIsTransport.match(u1);
        boolean airOrCarrierOrTransport2 = Matches.UnitIsAir.match(u2) || Matches.UnitIsCarrier.match(u2) || !transporting2 && Matches.UnitIsTransport.match(u2);
        boolean subDestroyer1 = Matches.UnitIsSub.match(u1) || Matches.UnitIsDestroyer.match(u1);
        boolean subDestroyer2 = Matches.UnitIsSub.match(u2) || Matches.UnitIsDestroyer.match(u2);
        boolean multiHpCanRepair1 = this.m_multiHitpointCanRepair.contains(u1.getType());
        boolean multiHpCanRepair2 = this.m_multiHitpointCanRepair.contains(u2.getType());
        if (!this.m_ignorePrimaryPower) {
            int power1 = 8 * BattleCalculator.getUnitPowerForSorting(u1, this.m_defending, this.m_data, this.m_territoryEffects);
            int power2 = 8 * BattleCalculator.getUnitPowerForSorting(u2, this.m_defending, this.m_data, this.m_territoryEffects);
            if (this.m_bonus) {
                if (subDestroyer1 && !subDestroyer2) {
                    power1 += 4;
                } else if (!subDestroyer1 && subDestroyer2) {
                    power2 += 4;
                }
                if (multiHpCanRepair1 && !multiHpCanRepair2) {
                    ++power1;
                } else if (!multiHpCanRepair1 && multiHpCanRepair2) {
                    ++power2;
                }
                if (transporting1 && !transporting2) {
                    ++power1;
                } else if (!transporting1 && transporting2) {
                    ++power2;
                }
                if (airOrCarrierOrTransport1 && !airOrCarrierOrTransport2) {
                    ++power1;
                } else if (!airOrCarrierOrTransport1 && airOrCarrierOrTransport2) {
                    ++power2;
                }
            }
            if (power1 != power2) {
                return power1 - power2;
            }
        }
        if ((cost1 = this.m_costs.getInt(u1.getType())) != (cost2 = this.m_costs.getInt(u2.getType()))) {
            return cost1 - cost2;
        }
        int power1reverse = 8 * BattleCalculator.getUnitPowerForSorting(u1, !this.m_defending, this.m_data, this.m_territoryEffects);
        int power2reverse = 8 * BattleCalculator.getUnitPowerForSorting(u2, !this.m_defending, this.m_data, this.m_territoryEffects);
        if (this.m_bonus) {
            if (subDestroyer1 && !subDestroyer2) {
                power1reverse += 4;
            } else if (!subDestroyer1 && subDestroyer2) {
                power2reverse += 4;
            }
            if (multiHpCanRepair1 && !multiHpCanRepair2) {
                ++power1reverse;
            } else if (!multiHpCanRepair1 && multiHpCanRepair2) {
                ++power2reverse;
            }
            if (transporting1 && !transporting2) {
                ++power1reverse;
            } else if (!transporting1 && transporting2) {
                ++power2reverse;
            }
            if (airOrCarrierOrTransport1 && !airOrCarrierOrTransport2) {
                ++power1reverse;
            } else if (!airOrCarrierOrTransport1 && airOrCarrierOrTransport2) {
                ++power2reverse;
            }
        }
        if (power1reverse != power2reverse) {
            return power1reverse - power2reverse;
        }
        if (subDestroyer1 && !subDestroyer2) {
            return 1;
        }
        if (!subDestroyer1 && subDestroyer2) {
            return -1;
        }
        if (multiHpCanRepair1 && !multiHpCanRepair2) {
            return 1;
        }
        if (!multiHpCanRepair1 && multiHpCanRepair2) {
            return -1;
        }
        if (transporting1 && !transporting2) {
            return 1;
        }
        if (!transporting1 && transporting2) {
            return -1;
        }
        if (airOrCarrierOrTransport1 && !airOrCarrierOrTransport2) {
            return 1;
        }
        if (!airOrCarrierOrTransport1 && airOrCarrierOrTransport2) {
            return -1;
        }
        return ua1.getMovement(u1.getOwner()) - ua2.getMovement(u2.getOwner());
    }
}

