/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.delegate.BattleCalculator;
import games.strategy.util.IntegerMap;
import java.util.Comparator;

class UnitCostComparator
implements Comparator<Unit> {
    private final IntegerMap<UnitType> m_costs;

    public UnitCostComparator(IntegerMap<UnitType> costs) {
        this.m_costs = costs;
    }

    public UnitCostComparator(PlayerID player, GameData data) {
        this.m_costs = BattleCalculator.getCostsForTUV(player, data);
    }

    @Override
    public int compare(Unit u1, Unit u2) {
        return this.m_costs.getInt(u1.getType()) - this.m_costs.getInt(u2.getType());
    }
}

