/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.delegate.Matches;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.InverseMatch;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UnitsThatCantFightUtil {
    private final GameData m_data;

    public UnitsThatCantFightUtil(GameData data) {
        this.m_data = data;
    }

    public Collection<Territory> getTerritoriesWhereUnitsCantFight(PlayerID player) {
        CompositeMatchAnd<Unit> enemyAttackUnits = new CompositeMatchAnd<Unit>(new Match[0]);
        enemyAttackUnits.add(Matches.enemyUnit(player, this.m_data));
        enemyAttackUnits.add(Matches.unitCanAttack(player));
        ArrayList<Territory> cantFight = new ArrayList<Territory>();
        for (Territory current : this.m_data.getMap()) {
            CompositeMatchAnd<Unit> ownedUnitsMatch = new CompositeMatchAnd<Unit>(new Match[0]);
            ownedUnitsMatch.add(new InverseMatch<Unit>(Matches.UnitIsInfrastructure));
            if (current.isWater()) {
                ownedUnitsMatch.add(Matches.UnitIsLand.invert());
            }
            ownedUnitsMatch.add(Matches.unitIsOwnedBy(player));
            int countAllOwnedUnits = current.getUnits().countMatches(ownedUnitsMatch);
            ownedUnitsMatch.add(new InverseMatch<Unit>(Matches.unitCanAttack(player)));
            List<Unit> nonCombatUnits = current.getUnits().getMatches(ownedUnitsMatch);
            if (nonCombatUnits.isEmpty() || nonCombatUnits.size() != countAllOwnedUnits || !current.getUnits().someMatch(enemyAttackUnits)) continue;
            cantFight.add(current);
        }
        return cantFight;
    }
}

