/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.common.delegate.BaseTripleADelegate;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Resource;
import games.strategy.engine.random.IRandomStats;
import games.strategy.triplea.attatchments.AbstractConditionsAttachment;
import games.strategy.triplea.attatchments.ICondition;
import games.strategy.triplea.attatchments.UserActionAttachment;
import games.strategy.triplea.delegate.UserActionExtendedDelegateState;
import games.strategy.triplea.delegate.remote.IUserActionDelegate;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.triplea.ui.UserActionText;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class UserActionDelegate
extends BaseTripleADelegate
implements IUserActionDelegate {
    @Override
    public void start() {
        super.start();
    }

    @Override
    public void end() {
        super.end();
        this.resetAttempts();
    }

    @Override
    public Serializable saveState() {
        UserActionExtendedDelegateState state = new UserActionExtendedDelegateState();
        state.superState = super.saveState();
        return state;
    }

    @Override
    public void loadState(Serializable state) {
        UserActionExtendedDelegateState s = (UserActionExtendedDelegateState)state;
        super.loadState(s.superState);
    }

    @Override
    public boolean delegateCurrentlyRequiresUserInput() {
        return !this.getValidActions().isEmpty();
    }

    public HashMap<ICondition, Boolean> getTestedConditions() {
        HashSet<ICondition> allConditionsNeeded = AbstractConditionsAttachment.getAllConditionsRecursive(new HashSet<ICondition>(UserActionAttachment.getUserActionAttachments(this.m_player)), null);
        return AbstractConditionsAttachment.testAllConditionsRecursive(allConditionsNeeded, null, this.m_bridge);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<UserActionAttachment> getValidActions() {
        HashMap<ICondition, Boolean> testedConditions;
        GameData data = this.m_bridge.getData();
        data.acquireReadLock();
        try {
            testedConditions = this.getTestedConditions();
        }
        finally {
            data.releaseReadLock();
        }
        return UserActionAttachment.getValidActions(this.m_player, testedConditions, data);
    }

    @Override
    public void attemptAction(UserActionAttachment actionChoice) {
        if (actionChoice.canPerform(this.getTestedConditions())) {
            if (this.checkEnoughMoney(actionChoice)) {
                this.chargeForAction(actionChoice);
                actionChoice.useAttempt(this.getBridge());
                if (this.actionRollSucceeds(actionChoice)) {
                    if (this.actionIsAccepted(actionChoice)) {
                        this.activateTriggers(actionChoice);
                        this.notifySuccess(actionChoice);
                    } else {
                        this.notifyFailure(actionChoice);
                    }
                } else {
                    this.notifyFailure(actionChoice);
                }
            } else {
                this.notifyMoney(actionChoice, false);
            }
        } else {
            this.notifyNoValidAction(actionChoice);
        }
    }

    private boolean checkEnoughMoney(UserActionAttachment uaa) {
        Resource PUs = this.getData().getResourceList().getResource("PUs");
        int cost = uaa.getCostPU();
        int has = this.m_bridge.getPlayerID().getResources().getQuantity(PUs);
        return has >= cost;
    }

    private void chargeForAction(UserActionAttachment uaa) {
        Resource PUs = this.getData().getResourceList().getResource("PUs");
        int cost = uaa.getCostPU();
        if (cost > 0) {
            String transcriptText = this.m_bridge.getPlayerID().getName() + " spend " + cost + " PU on User Action: " + MyFormatter.attachmentNameToText(uaa.getName());
            this.m_bridge.getHistoryWriter().startEvent(transcriptText);
            Change charge = ChangeFactory.changeResourcesChange(this.m_bridge.getPlayerID(), PUs, -cost);
            this.m_bridge.addChange(charge);
        } else {
            String transcriptText = this.m_bridge.getPlayerID().getName() + " takes action: " + MyFormatter.attachmentNameToText(uaa.getName());
            this.m_bridge.getHistoryWriter().startEvent(transcriptText);
        }
    }

    private boolean actionRollSucceeds(UserActionAttachment uaa) {
        int hitTarget = uaa.getChanceToHit();
        int diceSides = uaa.getChanceDiceSides();
        if (diceSides <= 0 || hitTarget >= diceSides) {
            uaa.changeChanceDecrementOrIncrementOnSuccessOrFailure(this.m_bridge, true, true);
            return true;
        }
        if (hitTarget <= 0) {
            uaa.changeChanceDecrementOrIncrementOnSuccessOrFailure(this.m_bridge, false, true);
            return false;
        }
        int rollResult = this.m_bridge.getRandom(diceSides, this.m_player, IRandomStats.DiceType.NONCOMBAT, "Attempting the User Action: " + MyFormatter.attachmentNameToText(uaa.getName())) + 1;
        boolean success = rollResult <= hitTarget;
        String notificationMessage = "rolling (" + hitTarget + " out of " + diceSides + ") result: " + rollResult + " = " + (success ? "Success!" : "Failure!");
        this.m_bridge.getHistoryWriter().addChildToEvent(MyFormatter.attachmentNameToText(uaa.getName()) + " : " + notificationMessage);
        uaa.changeChanceDecrementOrIncrementOnSuccessOrFailure(this.m_bridge, success, true);
        this.sendNotification(notificationMessage);
        return success;
    }

    private boolean actionIsAccepted(UserActionAttachment uaa) {
        for (PlayerID player : uaa.getActionAccept()) {
            if (this.getRemotePlayer(player).acceptAction(this.m_player, UserActionText.getInstance().getAcceptanceQuestion(uaa.getText()), false)) continue;
            return false;
        }
        return true;
    }

    private void activateTriggers(UserActionAttachment uaa) {
        UserActionAttachment.fireTriggers(uaa, this.getTestedConditions(), this.m_bridge);
    }

    private void notifySuccess(UserActionAttachment uaa) {
        this.getSoundChannel().playSoundForAll("user_action_successful", this.m_player.getName());
        this.sendNotification(UserActionText.getInstance().getNotificationSucccess(uaa.getText()));
        this.notifyOtherPlayers(uaa, UserActionText.getInstance().getNotificationSuccessOthers(uaa.getText()));
    }

    private void sendNotification(String text) {
        if (!"NONE".equals(text)) {
            this.getRemotePlayer().reportMessage(text, text);
        }
    }

    private void notifyOtherPlayers(UserActionAttachment uaa, String notification) {
        if (!"NONE".equals(notification)) {
            ArrayList<PlayerID> currentPlayer = new ArrayList<PlayerID>();
            currentPlayer.add(this.m_player);
            List<PlayerID> otherPlayers = this.getData().getPlayerList().getPlayers();
            otherPlayers.removeAll(currentPlayer);
            this.getDisplay().reportMessageToPlayers(otherPlayers, currentPlayer, notification, notification);
        }
    }

    private void notifyFailure(UserActionAttachment uaa) {
        this.getSoundChannel().playSoundForAll("user_action_failure", this.m_player.getName());
        String transcriptText = this.m_bridge.getPlayerID().getName() + " fails on action: " + MyFormatter.attachmentNameToText(uaa.getName());
        this.m_bridge.getHistoryWriter().addChildToEvent(transcriptText);
        this.sendNotification(UserActionText.getInstance().getNotificationFailure(uaa.getText()));
        this.notifyOtherPlayers(uaa, UserActionText.getInstance().getNotificationFailureOthers(uaa.getText()));
    }

    private void notifyMoney(UserActionAttachment uaa, boolean enough) {
        if (enough) {
            this.sendNotification("Charging " + uaa.getCostPU() + " PU's to perform this action");
        } else {
            this.sendNotification("You don't have ennough money, you need " + uaa.getCostPU() + " PU's to perform this action");
        }
    }

    private void notifyNoValidAction(UserActionAttachment uaa) {
        this.sendNotification("This action isn't available anymore (this shouldn't happen!?!)");
    }

    private void resetAttempts() {
        for (UserActionAttachment uaa : UserActionAttachment.getUserActionAttachments(this.m_player)) {
            uaa.resetAttempts(this.getBridge());
        }
    }

    public Class<IUserActionDelegate> getRemoteType() {
        return IUserActionDelegate.class;
    }
}

