/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate.dataObjects;

import games.strategy.engine.data.Territory;
import games.strategy.triplea.delegate.IBattle;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BattleListing
implements Serializable {
    private static final long serialVersionUID = 2700129486225793827L;
    private final Map<IBattle.BattleType, Collection<Territory>> m_battles;

    public BattleListing(Map<IBattle.BattleType, Collection<Territory>> battles) {
        this.m_battles = battles;
    }

    public Map<IBattle.BattleType, Collection<Territory>> getBattles() {
        return this.m_battles;
    }

    public Set<Territory> getAllBattleTerritories() {
        HashSet<Territory> territories = new HashSet<Territory>();
        for (Map.Entry<IBattle.BattleType, Collection<Territory>> entry : this.m_battles.entrySet()) {
            territories.addAll(entry.getValue());
        }
        return territories;
    }

    public Set<Territory> getNormalBattlesIncludingAirBattles() {
        HashSet<Territory> territories = new HashSet<Territory>();
        for (Map.Entry<IBattle.BattleType, Collection<Territory>> entry : this.m_battles.entrySet()) {
            if (entry.getKey().isBombingRun()) continue;
            territories.addAll(entry.getValue());
        }
        return territories;
    }

    public Set<Territory> getStrategicBombingRaidsIncludingAirBattles() {
        HashSet<Territory> territories = new HashSet<Territory>();
        for (Map.Entry<IBattle.BattleType, Collection<Territory>> entry : this.m_battles.entrySet()) {
            if (!entry.getKey().isBombingRun()) continue;
            territories.addAll(entry.getValue());
        }
        return territories;
    }

    public Set<Territory> getAirBattles() {
        HashSet<Territory> territories = new HashSet<Territory>();
        for (Map.Entry<IBattle.BattleType, Collection<Territory>> entry : this.m_battles.entrySet()) {
            if (!entry.getKey().isAirPreBattleOrPreRaid()) continue;
            territories.addAll(entry.getValue());
        }
        return territories;
    }

    public boolean isEmpty() {
        return this.m_battles.isEmpty();
    }
}

