/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate.dataObjects;

import games.strategy.engine.data.Unit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CasualtyList
implements Serializable {
    private static final long serialVersionUID = 6501752134047891398L;
    protected List<Unit> m_killed;
    protected List<Unit> m_damaged;

    public CasualtyList(List<Unit> killed, List<Unit> damaged) {
        if (killed == null) {
            throw new IllegalArgumentException("null killed");
        }
        if (damaged == null) {
            throw new IllegalArgumentException("null damaged");
        }
        this.m_killed = new ArrayList<Unit>(killed);
        this.m_damaged = new ArrayList<Unit>(damaged);
    }

    public CasualtyList() {
        this.m_killed = new ArrayList<Unit>();
        this.m_damaged = new ArrayList<Unit>();
    }

    public List<Unit> getKilled() {
        return this.m_killed;
    }

    public List<Unit> getDamaged() {
        return this.m_damaged;
    }

    public List<Unit> getKilledAndDamaged() {
        ArrayList<Unit> all = new ArrayList<Unit>(this.m_killed);
        all.addAll(this.m_damaged);
        return all;
    }

    public void addToKilled(Unit deadUnit) {
        this.m_killed.add(deadUnit);
    }

    public void addToKilled(Collection<Unit> deadUnits) {
        this.m_killed.addAll(deadUnits);
    }

    public void addToDamaged(Unit damagedUnit) {
        this.m_damaged.add(damagedUnit);
    }

    public void addToDamaged(Collection<Unit> damagedUnits) {
        this.m_damaged.addAll(damagedUnits);
    }

    public void removeFromKilled(Unit deadUnit) {
        this.m_killed.remove(deadUnit);
    }

    public void removeFromKilled(Collection<Unit> deadUnits) {
        this.m_killed.removeAll(deadUnits);
    }

    public void removeOnceFromDamaged(Unit damagedUnit) {
        this.m_damaged.remove(damagedUnit);
    }

    public void removeOnceFromDamaged(Collection<Unit> damagedUnits) {
        this.m_damaged.removeAll(damagedUnits);
    }

    public void removeAllFromDamaged(Unit damagedUnit) {
        while (this.m_damaged.contains(damagedUnit)) {
            this.m_damaged.remove(damagedUnit);
        }
    }

    public void removeAllFromDamaged(Collection<Unit> damagedUnits) {
        for (Unit u : damagedUnits) {
            while (this.m_damaged.contains(u)) {
                this.m_damaged.remove(u);
            }
        }
    }

    public void addAll(CasualtyList casualtyList) {
        this.m_damaged.addAll(casualtyList.getDamaged());
        this.m_killed.addAll(casualtyList.getKilled());
    }

    public void clear() {
        this.m_killed.clear();
        this.m_damaged.clear();
    }

    public int size() {
        return this.m_killed.size() + this.m_damaged.size();
    }

    public String toString() {
        return "Selected Casualties: Damaged: [" + this.m_damaged + "],  Killed: [" + this.m_killed + "]";
    }
}

