/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate.dataObjects;

import games.strategy.engine.data.Route;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.delegate.dataObjects.AbstractMoveDescription;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class MoveDescription
extends AbstractMoveDescription {
    private static final long serialVersionUID = 2199608152808948043L;
    private final Route m_route;
    private final Collection<Unit> m_transportsThatCanBeLoaded;
    private final Map<Unit, Collection<Unit>> m_dependentUnits;

    public MoveDescription(Collection<Unit> units, Route route, Collection<Unit> transportsThatCanBeLoaded, Map<Unit, Collection<Unit>> dependentUnits) {
        super(units);
        this.m_route = route;
        this.m_transportsThatCanBeLoaded = transportsThatCanBeLoaded;
        if (dependentUnits != null && !dependentUnits.isEmpty()) {
            this.m_dependentUnits = new HashMap<Unit, Collection<Unit>>();
            for (Map.Entry<Unit, Collection<Unit>> entry : dependentUnits.entrySet()) {
                this.m_dependentUnits.put(entry.getKey(), new HashSet<Unit>(entry.getValue()));
            }
        } else {
            this.m_dependentUnits = null;
        }
    }

    public MoveDescription(Collection<Unit> units, Route route, Collection<Unit> transportsThatCanBeLoaded) {
        super(units);
        this.m_route = route;
        this.m_transportsThatCanBeLoaded = transportsThatCanBeLoaded;
        this.m_dependentUnits = null;
    }

    public MoveDescription(Collection<Unit> units, Route route) {
        super(units);
        this.m_route = route;
        this.m_transportsThatCanBeLoaded = null;
        this.m_dependentUnits = null;
    }

    public Route getRoute() {
        return this.m_route;
    }

    @Override
    public String toString() {
        return "Move message route:" + this.m_route + " units:" + this.getUnits();
    }

    public Collection<Unit> getTransportsThatCanBeLoaded() {
        if (this.m_transportsThatCanBeLoaded == null) {
            return Collections.emptyList();
        }
        return this.m_transportsThatCanBeLoaded;
    }

    public Map<Unit, Collection<Unit>> getDependentUnits() {
        if (this.m_dependentUnits == null) {
            return new HashMap<Unit, Collection<Unit>>();
        }
        return this.m_dependentUnits;
    }
}

