/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.formatter;

import games.strategy.engine.data.DefaultNamed;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.delegate.DiceRoll;
import games.strategy.triplea.delegate.Die;
import games.strategy.triplea.formatter.UnitOwner;
import games.strategy.util.IntegerMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MyFormatter {
    private static Map<String, String> s_plural = new HashMap<String, String>();

    public static String unitsToTextNoOwner(Collection<Unit> units) {
        return MyFormatter.unitsToTextNoOwner(units, null);
    }

    public static String unitsToTextNoOwner(Collection<Unit> units, PlayerID owner) {
        Iterator<Unit> iter = units.iterator();
        IntegerMap<UnitType> map = new IntegerMap<UnitType>();
        while (iter.hasNext()) {
            Unit unit = iter.next();
            if (unit == null || unit.getUnitType() == null) {
                throw new IllegalStateException("Trying to format a unit that does not exist.  If you are using Dynamix AI, then this is being caused by switching maps with the ai (it is still thinking about the last map's units).  Try restarting TripleA every time you switch maps and wish to play with Dynamix AI.");
            }
            if (owner != null && !owner.equals(unit.getOwner())) continue;
            map.add(unit.getUnitType(), 1);
        }
        StringBuilder buf = new StringBuilder();
        ArrayList sortedList = new ArrayList(map.keySet());
        Comparator<UnitType> comp = new Comparator<UnitType>(){

            @Override
            public int compare(UnitType u1, UnitType u2) {
                return u1.getName().compareTo(u2.getName());
            }
        };
        Collections.sort(sortedList, comp);
        Iterator typeIter = sortedList.iterator();
        int count = map.keySet().size();
        while (typeIter.hasNext()) {
            UnitType type = (UnitType)typeIter.next();
            int quantity = map.getInt(type);
            buf.append(quantity);
            buf.append(" ");
            buf.append(quantity > 1 ? MyFormatter.pluralize(type.getName()) : type.getName());
            if (--count > 1) {
                buf.append(", ");
            }
            if (count != 1) continue;
            buf.append(" and ");
        }
        return buf.toString();
    }

    public static String unitsToText(Collection<Unit> units) {
        Iterator<Unit> iter = units.iterator();
        IntegerMap<UnitOwner> map = new IntegerMap<UnitOwner>();
        while (iter.hasNext()) {
            Unit unit = iter.next();
            UnitOwner owner = new UnitOwner(unit.getType(), unit.getOwner());
            map.add(owner, 1);
        }
        StringBuilder buf = new StringBuilder();
        Iterator iter2 = map.keySet().iterator();
        int count = map.keySet().size();
        while (iter2.hasNext()) {
            UnitOwner owner = (UnitOwner)iter2.next();
            int quantity = map.getInt(owner);
            buf.append(quantity);
            buf.append(" ");
            buf.append(quantity > 1 ? MyFormatter.pluralize(owner.type.getName()) : owner.type.getName());
            buf.append(" owned by the ");
            buf.append(owner.owner.getName());
            if (--count > 1) {
                buf.append(", ");
            }
            if (count != 1) continue;
            buf.append(" and ");
        }
        return buf.toString();
    }

    public static String pluralize(String in, int quantity) {
        if (quantity == -1 || quantity == 1) {
            return in;
        }
        return MyFormatter.pluralize(in);
    }

    public static String pluralize(String in) {
        if (s_plural.containsKey(in)) {
            return s_plural.get(in);
        }
        if (in.endsWith("man")) {
            return in.substring(0, in.lastIndexOf("man")) + "men";
        }
        return in + "s";
    }

    public static String attachmentNameToText(String attachmentGetName) {
        String toText = attachmentGetName;
        if (attachmentGetName.startsWith("relationshipTypeAttachment")) {
            toText = attachmentGetName.replaceFirst("relationshipTypeAttachment", "Relationship Type ");
        } else if (attachmentGetName.startsWith("techAttatchment")) {
            toText = attachmentGetName.replaceFirst("techAttatchment", "Player Techs ");
        } else if (attachmentGetName.startsWith("unitAttatchment")) {
            toText = attachmentGetName.replaceFirst("unitAttatchment", "Unit Type Properties ");
        } else if (attachmentGetName.startsWith("territoryAttatchment")) {
            toText = attachmentGetName.replaceFirst("territoryAttatchment", "Territory Properties ");
        } else if (attachmentGetName.startsWith("canalAttatchment")) {
            toText = attachmentGetName.replaceFirst("canalAttatchment", "Canal ");
        } else if (attachmentGetName.startsWith("territoryEffectAttachment")) {
            toText = attachmentGetName.replaceFirst("territoryEffectAttachment", "Territory Effect ");
        } else if (attachmentGetName.startsWith("supportAttachment")) {
            toText = attachmentGetName.replaceFirst("supportAttachment", "Support ");
        } else if (attachmentGetName.startsWith("objectiveAttachment")) {
            toText = attachmentGetName.replaceFirst("objectiveAttachment", "Objective ");
        } else if (attachmentGetName.startsWith("conditionAttachment")) {
            toText = attachmentGetName.replaceFirst("conditionAttachment", "Condition ");
        } else if (attachmentGetName.startsWith("triggerAttachment")) {
            toText = attachmentGetName.replaceFirst("triggerAttachment", "Trigger ");
        } else if (attachmentGetName.startsWith("rulesAttatchment")) {
            toText = attachmentGetName.replaceFirst("rulesAttatchment", "Rules ");
        } else if (attachmentGetName.startsWith("playerAttatchment")) {
            toText = attachmentGetName.replaceFirst("playerAttatchment", "Player Properties ");
        } else if (attachmentGetName.startsWith("politicalActionAttachment")) {
            toText = attachmentGetName.replaceFirst("politicalActionAttachment", "Political Action ");
        } else if (attachmentGetName.startsWith("politicalActionAttachment")) {
            toText = attachmentGetName.replaceFirst("userActionAttachment", "Action ");
        } else if (attachmentGetName.startsWith("techAbilityAttachment")) {
            toText = attachmentGetName.replaceFirst("techAbilityAttachment", "Tech Properties ");
        }
        toText = toText.replaceAll("_", " ");
        toText = toText.replaceAll("  ", " ");
        toText = toText.trim();
        return toText;
    }

    public static String listOfArraysToString(ArrayList<String[]> listOfArrays) {
        if (listOfArrays == null) {
            return "null";
        }
        String toText = "[";
        for (Object[] objectArray : listOfArrays) {
            toText = toText + Arrays.toString(objectArray);
            toText = toText + ",";
        }
        toText = toText + "]";
        return toText;
    }

    public static String asDice(DiceRoll roll) {
        if (roll == null || roll.size() == 0) {
            return "none";
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < roll.size(); ++i) {
            buf.append(roll.getDie(i).getValue() + 1);
            if (i + 1 >= roll.size()) continue;
            buf.append(",");
        }
        return buf.toString();
    }

    public static String asDice(int[] rolls) {
        if (rolls == null || rolls.length == 0) {
            return "none";
        }
        StringBuilder buf = new StringBuilder(rolls.length * 2);
        for (int i = 0; i < rolls.length; ++i) {
            buf.append(rolls[i] + 1);
            if (i + 1 >= rolls.length) continue;
            buf.append(",");
        }
        return buf.toString();
    }

    public static String asDice(List<Die> rolls) {
        if (rolls == null || rolls.size() == 0) {
            return "none";
        }
        StringBuilder buf = new StringBuilder(rolls.size() * 2);
        for (int i = 0; i < rolls.size(); ++i) {
            buf.append(rolls.get(i).getValue() + 1);
            if (i + 1 >= rolls.size()) continue;
            buf.append(",");
        }
        return buf.toString();
    }

    public static String defaultNamedToTextList(Collection<? extends DefaultNamed> list) {
        return MyFormatter.defaultNamedToTextList(list, ", ", false);
    }

    public static String defaultNamedToTextList(Collection<? extends DefaultNamed> list, boolean showQuantity) {
        return MyFormatter.defaultNamedToTextList(list, ", ", showQuantity);
    }

    public static String defaultNamedToTextList(Collection<? extends DefaultNamed> list, String seperator, boolean showQuantity) {
        Iterator<? extends DefaultNamed> iter = list.iterator();
        IntegerMap<DefaultNamed> map = new IntegerMap<DefaultNamed>();
        while (iter.hasNext()) {
            DefaultNamed unit = iter.next();
            if (unit == null || unit.getName() == null) {
                throw new IllegalStateException("Unit or Resource no longer exists?!?");
            }
            map.add(unit, 1);
        }
        StringBuilder buf = new StringBuilder();
        ArrayList sortedList = new ArrayList(map.keySet());
        Comparator<DefaultNamed> comp = new Comparator<DefaultNamed>(){

            @Override
            public int compare(DefaultNamed u1, DefaultNamed u2) {
                return u1.getName().compareTo(u2.getName());
            }
        };
        Collections.sort(sortedList, comp);
        Iterator typeIter = sortedList.iterator();
        int count = map.keySet().size();
        while (typeIter.hasNext()) {
            DefaultNamed type = (DefaultNamed)typeIter.next();
            if (showQuantity) {
                int quantity = map.getInt(type);
                buf.append(quantity);
                buf.append(" ");
                buf.append(quantity > 1 ? MyFormatter.pluralize(type.getName()) : type.getName());
            } else {
                buf.append(type.getName());
            }
            if (--count > 1) {
                buf.append(seperator);
            }
            if (count != 1) continue;
            buf.append(" and ");
        }
        return buf.toString();
    }

    public static String integerDefaultNamedMapToString(IntegerMap<? extends DefaultNamed> map, String separator, String assignment, boolean valueBeforeKey) {
        StringBuilder buf = new StringBuilder("");
        for (Map.Entry<? extends DefaultNamed, Integer> entry : map.entrySet()) {
            buf.append(separator);
            DefaultNamed current = entry.getKey();
            int val = entry.getValue();
            if (valueBeforeKey) {
                buf.append(val).append(assignment).append(current.getName());
                continue;
            }
            buf.append(current.getName()).append(assignment).append(val);
        }
        return buf.toString().replaceFirst(separator, "");
    }

    public static String integerUnitMapToString(IntegerMap<? extends Unit> map, String separator, String assignment, boolean valueBeforeKey) {
        StringBuilder buf = new StringBuilder("");
        for (Map.Entry<? extends Unit, Integer> entry : map.entrySet()) {
            buf.append(separator);
            Unit current = entry.getKey();
            int val = entry.getValue();
            if (valueBeforeKey) {
                buf.append(val).append(assignment).append(current.getType().getName());
                continue;
            }
            buf.append(current.getType().getName()).append(assignment).append(val);
        }
        return buf.toString().replaceFirst(separator, "");
    }

    private MyFormatter() {
    }

    static {
        s_plural.put("armour", "armour");
        s_plural.put("infantry", "infantry");
        s_plural.put("Infantry", "Infantry");
        s_plural.put("artillery", "artilleries");
        s_plural.put("factory", "factories");
    }
}

